/*
** Linux specific Audio driver functions for the Xew Widgets.
**
**	If AUDIO_LINUX symbol is defined, the real functions are
**	compiled, otherwise all functions will compile into dummy
**	routines that always return an error or do nothing.
**
**	CURRENTLY JUST A SKETCH, I HAVE TO FIND SOME DOCS ABOUT
**	LINUX AUDIO FIRST... --msa
**
** Copyright 1995 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <stdio.h>

#ifdef AUDIO_LINUX
/*
** These are really needed only if compiling real functions.
*/
#	include <errno.h>
#	include <fcntl.h>
#	include <signal.h>
#endif

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xew/XewInit.h>
#include <X11/Xew/AudioP.h>

#include "AudioLINUX.h"

#define WATCH_INTERVAL	1500

#ifdef AUDIO_LINUX
/*
** Audio play will contain the file descriptor number (>= 0), if
** this application has control over it. Audio control is opened
** to gain access via "/dev/audioctl".
*/
static int audio_play = -1;
static XtIntervalId audio_timer = None;

/*
** There may be multiple audio widgets, but only one of them can
** "own" the audio device at any point.
*/
static XeAudioWidget audio_owner = 0;
static int owner_playing = 0;
static XeAudioNotify owner_notify = NULL;

/*
** AudioError
*/
static void AudioError(w)
XeAudioWidget w;
    {
	extern char *sys_errlist[];
	extern int sys_nerr;
	String par[1];

	par[0] = errno < sys_nerr ? sys_errlist[errno]:"";
	XeWidgetWarningMsg((Widget)w, "systemError", "/dev/audio:%s", par, 1);
    }


static void ReleasePlay()
    {
	if (audio_play >= 0)
	    {
		close(audio_play);
		audio_play = -1;
	    }
    }

static void TimerEvent();

static void SetWatchdog()
    {
	if (audio_owner)
		audio_timer = XtAppAddTimeOut
			(XtWidgetToApplicationContext((Widget)audio_owner),
			 WATCH_INTERVAL, TimerEvent, (XtPointer)audio_owner);
	else
		audio_timer = None;
    }

static void TimerEvent(w)
XeAudioWidget w;
    {
	if (audio_owner != w)
		return;
	audio_timer = None;
	if (audio_play < 0)
		return;
	audio_owner = NULL;
	owner_playing = 0;
	if (owner_notify)
		(*owner_notify)(w);
	ReleasePlay();
    }

/*
** GrabAudioPlay
**	Open audio device for play.
*/
int GrabAudioPlay(w)
XeAudioWidget w;
    {
	if (audio_owner && audio_owner != w)
	    {
		XeWidgetWarningMsg((Widget)w,
				   "cannotOpen",
				   "/dev/audio busy with another widget.",
				   (char **)NULL, 0);
		return -1;	/* Not owned by this widget */
	    }
	if (audio_play < 0)
	    {
		if ((audio_play = open("/dev/audio", O_WRONLY | O_NDELAY)) < 0)
		    {
			AudioError(w);
			return -1;
		    }
	    }
	if (audio_owner == NULL)
	    {
		audio_owner = w;
		owner_notify = NULL;
		owner_playing = 0;
	    }
	return audio_play;
    }
#endif

/*
** XeAudioOpenPlay_LINUX
**	Open the audio device for playing to the widget (unless it is busy).
*/
static int XeAudioOpenPlay_LINUX(w)
XeAudioWidget w;
    {
	int fd = -1;
#ifdef AUDIO_LINUX

	if ((fd = GrabAudioPlay(w)) >= 0)
		owner_playing = 1;
#endif
	return fd;
    }

/*
** XeAudioClosePlay_LINUX
**	Release the audio play device from a widget.
*/
static void XeAudioClosePlay_LINUX(w, notify)
XeAudioWidget w;
XeAudioNotify notify;
    {
#ifdef AUDIO_LINUX
	if (audio_owner == w)
	    {
		owner_notify = notify;
		SetWatchdog();
	    }
#endif
    }

/*
** XeAudioControl_LINUX
**	Set the audio device according to the state of the control
**	resources in the widget.
**
**	If flush is non-zero, the current pending output will be
**	discarded.
*/
static void XeAudioControl_LINUX(w, flush)
XeAudioWidget w;
int flush;
    {
#ifdef AUDIO_LINUX

	if (GrabAudioPlay(w) < 0)
		return;

	/*
	** Do not reserve audio_play permanently just for control.
	** Release if owner is not actually playing.
	*/
	if (owner_playing == 0)
		audio_owner = NULL;
#endif
    }

/*
** XeAudioCleanup_LINUX
**	This function is called from the widget destroy method. It should
**	clean out all references to this widget from the audio driver.
*/
static void XeAudioCleanup_LINUX(w)
XeAudioWidget w;
    {
#ifdef AUDIO_LINUX
	if (audio_owner != w)
		return;
	audio_owner = NULL;
	owner_notify = NULL;
	if (audio_timer != None)
		XtRemoveTimeOut(audio_timer);
	audio_timer = None;
	ReleasePlay();
#endif
    }

/*
** XeAudio_LINUX
**	Initialize LINUX Audio driving.
*/
void XeAudio_LINUX(w)
XeAudioWidget w;
    {
	w->audio.open_play = XeAudioOpenPlay_LINUX;
	w->audio.close_play = XeAudioClosePlay_LINUX;
	w->audio.audio_control = XeAudioControl_LINUX;
	w->audio.audio_cleanup = XeAudioCleanup_LINUX;
    }
