/*
** BasicColor
**
**	A collection of widget class independent color manipulation
**	functions.
**
**      The color allocationg algorithm has been modified from xv 2.21
**	xvcolor.c - color allocation/sorting/freeing code John Bradley,
**	University of Pennsylvania (bradley@cis.upenn.edu)
**
**
** Copyright 1994-1995 by Markku Savela and
**	Technical Research Centre of Finland
*/
#if SYSV_INCLUDES
#	include <memory.h>
#endif
#if ANSI_INCLUDES
#	include <stddef.h>
#	include <stdlib.h>
#endif
#include <assert.h>

#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xew/BasicP.h>
#include "BasicColor.h"
#include "Color.h"

void _XeFreeColors(im)
XeImage *im;
    {
	if (im->pixels)
	    {
		XeFreeColors(im->display, im->colormap,
			     im->num_pixels, im->pixels);
		XtFree((char *)im->pixels);
		im->pixels = NULL;
	    }
	im->num_pixels = 0;
    }

/*
** structure and routine used in SortColormap()
*/
typedef unsigned char byte;
typedef struct thing
    {
	byte r,g,b;		/* actual value of color  */
	int oldindex;           /* its index in the old colormap */
	int use;                /* # of pixels of this color */
	int mindist;            /* min distance to a selected color */
    } CMAPENT;


static int SortColormap(im, size, r, g, b, data, width, height, scanline)
XeImage *im;
int size;
byte *r, *g, *b, *data;
int width, height, scanline;
    {
	byte *p, *q;

	int nc, i, j, mdist, entry, d, hist[256], trans[256];
	static CMAPENT c[256], c1[256], *cp, *cj, *ck;

	/* initialize histogram and compute it */

	memset((void *)hist, 0, sizeof(hist));
	for (p = data, i = height; i > 0; i--, p += scanline)
		for (j = width, q = p; j > 0; j--, q++)
			hist[*q]++;
	/*
	** Put the actually-used colors into the 'c' array in the order
	** they occur also, while we're at it, number of colors and close
	** up gaps in colortable
	*/
	for (i = nc = 0, cp = c; i < size; i++) 
		if (hist[i]) 
		    { 
			trans[i] = i;
			cp->r = r[i];
			cp->g = g[i];
			cp->b = b[i];
			cp->use = hist[i]; 
			cp->oldindex = i;
			cp->mindist = 200000; /* 255^2 * 3 = 195075 */
			nc += 1;
			cp += 1;
		    }
	/*
	** find most-used color, put that in c1[0]
	*/
	for (entry = -1, mdist = -1, i = 0; i < nc; i++)
		if (c[i].use > mdist)
		    {
			mdist = c[i].use; 
			entry=i; 
		    }
	c1[0] = c[entry];
	c[entry].use = 0;   /* and mark it dealt with */
	/*
	** sort rest of colormap.  Half of the entries are allocated on the
	** basis of distance from already allocated colors, and half on the
	** basis of usage.  (NB: 'taxicab' distance is used throughout this
	** file.)
	**
	** Mod:  pick first 10 colors based on maximum distance.  pick
	** remaining colors half by distance and half by usage   -- JHB
	**
	** To obtain O(n^2) performance, we keep each unselected color
	** (in c[], with use>0) marked with the minimum distance to any of
	** the selected colors (in c1[]).  Each time we select a color, we
	** can update the minimum distances in O(n) time. 
	**
	** mod by Tom Lane   Tom.Lane@g.gp.cs.cmu.edu
	**
	** (above comment was in xvraster.c --msa)
	*/
	for (i = 1; i < nc; i++)
	    {
		int ckR, ckG, ckB;
		/*
		** Get RGB of color last selected  and choose
		** selection method
		*/
		ck = &c1[i-1];            /* point to just-selected color */
		ckR = ck->r;
		ckG = ck->g;
		ckB = ck->b;
		entry = mdist = -1;
		if (i&1 || i<10) 
			/*
			** Now find the i'th most different color.
			** we want to select the unused color that has
			** the greatest mindist
			*/
			for (j = 0, cj = c; j < nc; j++,cj++)
			    {
				if (cj->use)
				    { 
					/* this color has not been marked
					   already. update mindist */
					d = (cj->r - ckR) * (cj->r - ckR) +
					    (cj->g - ckG) * (cj->g - ckG) + 
					    (cj->b - ckB) * (cj->b - ckB);
					if (cj->mindist > d)
						cj->mindist = d;
					if (cj->mindist > mdist)
					    {
						mdist = cj->mindist;
						entry = j;
					    }
				    }
			    }
		else 
			/* Now find the i'th most different color */
			/* we want to select the unused color that has
			   the greatest usage */
			for (j=0, cj=c; j < nc; j++,cj++)
			    {
				if (cj->use)
				    {  /* this color has not been marked
					  already. update mindist */
					d = (cj->r - ckR) * (cj->r - ckR) +
					    (cj->g - ckG) * (cj->g - ckG) + 
					    (cj->b - ckB) * (cj->b - ckB);
					if (cj->mindist > d)
						cj->mindist = d;
					if (cj->use > mdist) 
					    {
						mdist = cj->use; 
						entry = j;
					    }
				    }
			    }
		/* c[entry] is the next color to put in the map.  do so */
		c1[i] = c[entry];
		c[entry].use = 0;
	    }
	for ( i = 0; i < nc; i++)
	    {
		trans[c1[i].oldindex] = i;
		r[i] = c1[i].r;
		g[i] = c1[i].g;
		b[i] = c1[i].b;
	    }
	/*
	** modify image to reflect new colormap
	*/
	for (p = data, i = height; i; i--, p += scanline)
		for (j = width, q = p; j; j--, q++)
			*q = trans[*q];
	return nc;
    }

#define NOPIX 0xffffffff    

/*
** _XeAllocColors
**	Remap and allocate colors for a map.
**	This function is only designed to be called with PseudoColor
**	and GrayScale visuals. Calling with others may produce incorrect
**	results.
**
**	Return the number of exact colors actually allocated (do not
**	count "close colors").
**
**  WARNING!
**	THIS FUNCTION GLOBBERS THE INPUT COLORMAP AND IMAGE. DO NOT
**	CALL FOR IMAGE AND COLORMAP WHICH YOU WANT TO KEEP!
*/
int _XeAllocColors(im, size, r, g, b, data, width, height, scanline, do_sort)
XeImage *im;
int size;			/* Size of the input RGB color maps */
unsigned char *r, *g, *b;	/* RGB colormaps */
unsigned char *data;		/* Optional input data matrix */
int width, height, scanline;	/* (data paramters) */
int do_sort;
    {
	Colormap cmap;
	int nc, i, j;
	unsigned char *p, *q;

	if (size > 256)
		size = 256;	/* Cannot handle more than 256 colors! */
	if (do_sort)
		nc = SortColormap(im,size,r,g,b,data,width,height,scanline);
	else
		nc = size;
	_XeFreeColors(im);
	im->pixels = (Pixel *)XtMalloc(nc * sizeof(Pixel));
	if (im->imaging.colormap_use == XeColormapUse_PRIVATE)
		cmap = None;
	else
		cmap = im->colormap;
	im->colormap = XeAllocColors
		(im->display, DefaultRootWindow(im->display), cmap,
		 im->imaging.colormap_use,
		 im->imaging.max_colors, nc, r, g, b,
		 im->pixels);
	im->num_pixels = nc;
	/*
	** modify image to reflect new colormap
	*/
	for (p = data, i = height; i; i--, p += scanline)
		for (j = width, q = p; j; j--, q++)
			*q = im->pixels[*q];

	return nc;
    }


