#ifndef _XewFrame_h
#define _XewFrame_h
/*
** Copyright 1994-1995 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <X11/Xew/Basic.h>

/*

 Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	0
 bottomShadowContrast BottomShadowContrast int          40
 cursor              Cursor             Cursor          None
 destroyCallback     Callback		Pointer		NULL
 exposeCallback      ExposeCallback     Pointer         NULL
 height		     Height		Dimension	0
 invertShadow        InvertShadow       Boolean		False
 horizontal          FrameDimension     XeFrameDimension XeFrameDimension_MAX
 layoutPath          LayoutPath         int		270
 leadingBorder       FrameBorder        XeFrameBorder	No border
 leftBorder          FrameBorder        XeFrameBorder	No border
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 notifyCallback      NotifyCallback     Pointer         NULL
 rightBorder         FrameBorder        XeFrameBorder	No border
 topShadowContrast   TopShadowContrast  int             20
 trailingBorder      FrameBorder        XeFrameBorder	No border
 vertical            FrameDimension     XeFrameDimension XeFrameDimension_MAX
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0


 Constraint resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 bottomShadowContrast BottomShadowContrast int          40
 centerSeparation    FrameSeparation	int		0
 framealignment      FrameAlignment     XeFrameAlignment XeFrameAlignment_RIGHT
 framePosition       FramePosition      XeFramePosition XeFramePosition_NORMAL
 horizontal          FrameDimension     XeFrameDimension XeFrameDimension_MAX
 invertShadow        InvertShadow       Boolean		False
 leadingBorder       FrameBorder        XeFrameBorder	No border
 leadingOffset       FrameOffset        int             0
 leadingSeparation   FrameSeparation	int		0
 leftBorder          FrameBorder        XeFrameBorder	No border
 leftOffset          FrameOffset        int             0
 overflowCallback    OverFlowCallback   Pointer         NULL
 rightBorder         FrameBorder        XeFrameBorder	No border
 rightOffset         FrameOffset        int		0
 topShadowContrast   TopShadowContrast  int             20
 trailingOffset      FrameOffset        int		0
 trailingBorder      FrameBorder        XeFrameBorder	No border
 trailingSeparation  FrameSeparation    int		0
 vertical            FrameDimension     XeFrameDimension XeFrameDimension_MAX

*/

/* New Classes and Types */

#define XtCFrameAlignment "FrameAlignment"
#define XeRFrameAlignment "XeFrameAlignment"
#define XtCFrameBorder "FrameBorder"
#define XeRFrameBorder "XeFrameBorder"
#define XtCFrameOffset "FrameOffset"
#define XtCFrameSeparation "FrameSeparation"
#define XtCFramePosition "FramePosition"
#define XeRFramePosition "XeFramePosition"
#define XtCLayoutPath "LayoutPath"
#define XtNoverflowCallback "overflowCallback"
#define XtCOverflowCallback "OverflowCallback"

#ifndef XtNinvertShadow
#define XtNinvertShadow "invertShadow"
#define XtCInvertShadow "InvertShadow"
#endif

/* Some resources equivalent to Xaw3d */
#ifndef XtNtopShadowContrast
#define XtNtopShadowContrast "topShadowContrast"
#define XtCTopShadowContrast "TopShadowContrast"
#endif
#ifndef XtNbottomShadowContrast
#define XtNbottomShadowContrast "bottomShadowContrast"
#define XtCBottomShadowContrast "BottomShadowContrast"
#endif

/* New fields */
#ifndef XtNframeAlignment
#define XtNframeAlignment "frameAlignment"
#endif
#define XtNcenterSeparation "centerSeparation"
#define XtNlayoutPath "layoutPath"
#define XtNleadingBorder "leadingBorder"
#define XtNleadingOffset "leadingOffset"
#define XtNleadingSeparation "leadingSeparation"
#define XtNleftBorder "leftBorder"
#define XtNleftOffset "leftOffset"
#define XtNleftSeparation "leftSeparation"
#define XtNframePosition "framePosition"
#define XtNrightBorder "rightBorder"
#define XtNrightOffset "rightOffset"
#define XtNrightSeparation "rightSeparation"
#define XtNtrailingOffset "trailingOffset"
#define XtNtrailingBorder "trailingBorder"
#define XtNtrailingSeparation "trailingSeparation"

/*
** Resource structures
*/
typedef enum
    {
	XeFrameAlignment_LEFT,
	XeFrameAlignment_RIGHT,
	XeFrameAlignment_CENTER,
	/*
	** ..additional types for XeText
	*/
	XeFrameAlignment_TOP,		/* Aligned to top of line box */
	XeFrameAlignment_BOTTOM,	/* Aligned to bottome of line box */
	XeFrameAlignment_ABOVE,		/* Aligned above baseline */
	XeFrameAlignment_AROUND,	/* Aligned around baseline */
	XeFrameAlignment_BELOW		/* Aligned below baseline */
    } XeFrameAlignment;

typedef enum
    {
	XeFramePositionType_NORMAL,	/* Fill order NORMAL */
	XeFramePositionType_REVERSE,	/* Fill order REVERSE */
	XeFramePositionType_FIXED,	/* Fixed position */
	/* ..for XeText */
	XeFramePositionType_INLINE,	/* ..float within line */
	XeFramePositionType_START,	/* ..float to start of line */
	XeFramePositionType_END		/* ..float to end of line */
    } XeFramePositionType;

typedef struct XeFramePosition
    {
	XeFramePositionType type;
	Position x, y;			/* Only used if FIXED type */
    } XeFramePosition;


/*
** Frame Border specifications.
**	The border can be individually specified for each edge (leading,
**	trailing, left and right).
**
**	This resource is both a constraint resource and a resource for the
**	frame self. If the child is not a subclass of Frame, then the Frame
**	widget draws the borders around the child (outside them). The Frame
**	widget always draws it's own borders inside self. [This specification
**	follows loosely the ODA Border attribute.]
*/
typedef enum
    {
	XeBorderType_INVISIBLE,
	XeBorderType_SOLID,
	XeBorderType_DASHED,
	XeBorderType_DOT,
	XeBorderType_DASH_DOT,
	XeBorderType_DASH_DOT_DOT,
	XeBorderType_SHADOW
    } XeBorderType;

typedef struct XeFrameBorder
    {
	XeBorderType type;	/* Border type selection */
	int width;		/* Width of the border */
	int space;		/* free space between edge and border */
	unsigned char color[4];	/* Border color (RGB), is specified if
			        ** the 4th byte is set non-zero.
				*/
    } XeFrameBorder;

/* Class record constants */

extern WidgetClass xeFrameWidgetClass;

typedef struct _XeFrameClassRec *XeFrameWidgetClass;
typedef struct _XeFrameRec *XeFrameWidget;


#endif




