#ifndef ImageTools_h
#define ImageTools_h
/*
** ImageTools.h
**
** Copyright 1992-1995 by Markku Savela and
**	Technical Research Centre of Finland
*/

#ifdef SH_MEM
#	include <sys/ipc.h>
#	include <sys/shm.h>
#	include <X11/extensions/XShm.h>
#endif

#include <X11/Xew/Raster.h>

struct XeImage;

typedef void (*XeImageOpF)(
#if NeedFunctionPrototypes
			   struct XeImage *,	/* imaging "context" */
			   unsigned char *,	/* in map parameter */
			   unsigned char *,	/* out val parameter */
			   unsigned char *,	/* out map parameter */
			   XeImageChannel *,	/* dst channel(s) */
			   XeImageChannel *	/* src channel(s) */
#endif
			   );

typedef struct XeImageOp
    {
	XeImageOpF op;	/* Function to execute the operation */
	int in_offset;	/* Offset to the in map area in parameter area */
	int val_offset;	/* Offset to the val area in parameter area */
	int out_offset;	/* Offset to the out map area in parameter area */
	int dst, src;	/* Source and destination channel indexes */
    } XeImageOp;

typedef struct XeImage
    {
	XeImaging imaging;	/* Imaging control parameters being used */
	XImage *image;		/* X Image structure */
	unsigned char *map;	/* Color Mapping information */
	XeImageOp *image_op;	/* Image processing instructions */
	Display *display;	/* The display being used */
	Visual *visual;		/* The visual being used */
	Colormap colormap;	/* The actual colormap being used */
	int num_pixels;		/* Number of allocated Pixels */
	Pixel *pixels;		/* Pixel array (num_pixels size) */
#if SH_MEM
	unsigned int shared:1;	/* True, if MIT_SHM image allocated */
	XShmSegmentInfo shm;	/* Shared memory segment info */
	Pixmap pixmap;		/* Server side Pixmap (if supported) */
#endif
    } XeImage;


_XFUNCPROTOBEGIN
XeImage *_XeCreateImage
	(
#if NeedFunctionPrototypes
	 Display *,		/* Target Display pointer */
	 Window,		/* Target Window on the display */
	 XeRawImage *,		/* Raw image description */
	 XeImaging *,		/* Imaging control parameters */
	 int,			/* "Canvas width" (width of the XImage) */
	 int			/* "Canvas height" (height of the Ximage) */
#endif
	 );

/*
** _XeMirrorRotation
**	Setup line, inc and start parameters according to the rotation
**	and mirror parameters.
*/
void _XeMirrorRotation
	(
#if NeedFunctionPrototypes
	 int,			/* Rotation angle: 0, 90, 180, 270 */
	 int,			/* Mirror: True/False */
	 XeImageChannel *,	/* Source channel */
	 XeImageChannel *	/* Destination channel */
#endif
	 );
/*
** _XeBuildImage
**	Build the actuall XImage from the raw input image using the
**	control structures.
*/
void _XeBuildImage
	(
#if NeedFunctionPrototypes
	 XeImage *,		/* Xew Image Control Structure */
	 int n,			/* Number of entries in data */
	 XeImageChannel *	/* Raw Image data channels */
#endif
	 );

void _XePutImage
	(
#if NeedFunctionPrototypes
	 Display *,		/* Destination Display */
	 Drawable,		/* Destination */
	 GC,			/* Graphics context */
	 XeImage *,		/* Image to display */
	 int, int,		/* (src_x, src_y) */
	 int, int,		/* (dst_x, dst_y) */
	 unsigned int,		/* width */
	 unsigned int		/* height */
#endif
	 );

void _XeDestroyImage
	(
#if NeedFunctionPrototypes
	 XeImage *		/* Display Image descriptor */
#endif
	 );

/*
** _XeCreateRawImage
**	Create empty raw image structure which has room for the
**	specified number of channels.
*/
XeRawImage *_XeCreateRawImage
	(
#if NeedFunctionPrototypes
	 int		/* Number of channel structures */
#endif
	 );

/*
** _XeDestroyRawImage
**	Release all resources allocated to a raw image, including the
**	descriptor structure itself (do not call this for staticly
**	allocated descriptor!)
*/
void _XeDestroyRawImage
	(
#if NeedFunctionPrototypes
	 XeRawImage *		/* Raw Image Descriptor */
#endif
	 );

_XFUNCPROTOEND
#endif


