#ifndef _XewTextEd_h
#define _XewTextEd_h
/*
** Copyright 1993-1995 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <X11/Xew/Text.h>

/* Parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 alignment           XeAlignment        XeAlignment     XeStartAligned
 allowEdit           AllowEdit          Boolean         True
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 contentFile         ContentFile        String          NULL
 contentLength       ContentLength      long            Computed from content
 contentOffset       ContentOffset      long            0
 contentStream       ContentStream      FILE *          NULL
 contentString       ContentString      Pointer         NULL
 cursor              Cursor             Cursor          None
 cursorPosition      CursorPosition     long            0
 destroyCallback     Callback		Pointer		NULL
 displayCaret        Output             Boolean         True
 exportFormat        ExportFormat       XeTextExport    XeTextExport_ODIF
 firstLineOffset     Offset             int             0
 fonts               XeFonts            XeFont *        NULL
 format              Format             Boolean         False
 graphicRendition    Rendition          String          NULL
 height		     Height		Dimension	0
 indentation         Offset             Dimension       0
 initialState        Sequence           String          NULL
 itemization         Itemization        XeItemization * NULL
 kerningOffset       KerningOffset      Dimension *     NULL
 lineLayoutTable     LineLayoutTable    XeTabStop *     NULL
 lineSpacing         LineSpacing        Dimension       Computed from font
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 modifyCallback      ModifyCallback     Pointer         NULL
 proportional        Proportional       Boolean         False
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0

*/

/* New fields */
#define XtNallowEdit "allowEdit"
#define XtCAllowEdit "AllowEdit"
#define XtNcursorPosition "cursorPosition"
#define XtCCursorPosition "CursorPosition"
#define XtNmodifyCallback "modifyCallback"
#define XtCModifyCallback "ModifyCallback"
#ifndef XtNdisplayCaret
#define XtNdisplayCaret "displayCaret"
#endif
#ifndef XtCOutput
#define XtCOutput "Output"
#endif
/* Class record constants */

extern WidgetClass xeTextEdWidgetClass;

typedef struct _XeTextEdClassRec *XeTextEdWidgetClass;
typedef struct _XeTextEdRec      *XeTextEdWidget;

/*
** XeTextModifyCallbackData
**	is the data supplied for the XtNmodifyCallback just before
**	the content is prepared for any modifications. The callback
**	function has the option of preventing the modification by
**	setting the field 'cancel' to True.
**
**	NOTE:	The event == NULL is an indication the the callback
**		is caused by the programmatic interface function (not
**		by users keyboard/mouse actions).
*/
typedef struct XeTextModifyCallbackData
    {
	int reason;		/* == XeCR_MODIFY_TEXT */
	Boolean cancel;		/* Initialized to False */
	XEvent *event;		/* event that triggered the callback or NULL */
    } XeTextModifyCallbackData;

/*
** XeTextUnit
*/
typedef enum
    {
	XeTextUnit_POINT,	/* Current point */
	XeTextUnit_POSITION,	/* Virtual positions */
	XeTextUnit_WORD,	/* A word */
	XeTextUnit_LINE,	/* A line */
	XeTextUnit_LINE_BEGIN,	/* Beginning of current line */
	XeTextUnit_LINE_END,	/* End of current line */
	XeTextUnit_PARAGRAPH,	/* Paragraph */
	XeTextUnit_TAG,		/* Content with the same tag */
	XeTextUnit_ALL		/* All content, End/Begin "file" */
    } XeTextUnit;

/*
** XeTextHighlight
*/
typedef enum
    {
	XeTextHighlight_UNUSED,	/* Do not use in application */
	XeTextHighlight_NONE,	/* No special highlighting */
	XeTextHighlight_REVERSE,/* Highlite with reverse video */
	XeTextHighlight_FRAME	/* Highlite with wire frame */
    } XeTextHighlight;

	
_XFUNCPROTOBEGIN

void XeTextEnableDisplay
	(
#if NeedFunctionPrototypes
	Widget
#endif
	);

void XeTextDisableDisplay
	(
#if NeedFunctionPrototypes
	 Widget
#endif
	 );

void XeTextDisplay
	(
#if NeedFunctionPrototypes
	 Widget
#endif
	 );

Boolean XeTextSaveAsFile
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 String		/* Name (path) of the file to be written */
#endif
	 );

String XeTextGetString
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 long *		/* Number of octets returned */
#endif
	 );

String XeTextGetSubstring
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 long *,	/* Number of octets returned */
	 long,		/* Virtual offset to the start of region */
	 long		/* Virtual offset to the end of region */
#endif
	 );

typedef int (*XeTextExtractFeed)
 (
#if NeedFunctionPrototypes
  char *,		/* Extracted text portion */
  int,			/* The length of the text */
  XeTextTag,		/* The content TAG value */
  XtPointer		/* client_data */
#endif
 );

void XeTextExtract
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 long,		/* Virtual offset to the start of region */
	 long,		/* Virtual offset to the end of region */
	 XeTextExtractFeed, /* Function to receive the content (feed) */
	 XtPointer	/* client_data for the feed function */
#endif
	 );

void XeTextReplace
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 long,		/* Virtual offset to the start of the replace */
	 long,		/* Virtual offset to the end of the replace */
	 char *,	/* Pointer to the octest to be inserted */
	 long		/* Number of octets to insert */
#endif
	 );

void XeTextInsert
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 char *,	/* Pointer to octest to be inserted */
	 long		/* Number of octets to insert */
#endif
	 );

void XeTextChangeMode
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 char *,	/* Pointer to octets to be inserted (modes) */
	 long,		/* Number of octets to insert */
	 long		/* Number of characters to modify after insert */
#endif
	 );

void XeTextChangeModeAndTag
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 char *,	/* Pointer to octets to be inserted (modes) */
	 long,		/* Number of octets to insert */
	 long,		/* Number of characters to modify after insert */
	 XeTextTag	/* New tag to be changed */
#endif
	 );

void XeTextReplaceTagged
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 long,		/* Virtual offset to the start of replace */
	 long,		/* Virtual offset to the end of replace */
	 char *,	/* Pointer to octets to be inserted */
	 long,		/* Number of octets to insert */
	 XeTextTag	/* The Text tag to be used */
#endif
	 );

void XeTextInsertPrefix
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 char *,	/* Pointer to octets to be used as prefix */
	 long		/* Length of the prefix */
#endif
	 );

long XeTextGetInsertionPosition
	(
#if NeedFunctionPrototypes
	 Widget		/* TextEd Widget pointer */
#endif
	 );

/* for backward compatibility */
#define XeTextGetInsertionPoint XeTextGetInsertionPosition

long XeTextLocateTag
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 long,		/* Starting point of the search */
	 XeTextTag,	/* Tag to be compared */
	 int		/* = 0, for equal; = 1, for non-equal */
#endif
	 );

long XeTextScan
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 XeTextUnit,	/* Type of unit(s) to scan */
	 int		/* Amount and direction of the scan */
#endif
	 );

long XeTextSearch
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 int,		/* Amount and direction of the search */
	 char *,	/* "Compound" string to search */
	 long,		/* Number of octets in the search string */
	 int		/* case sensitive/case insensitive flag */
#endif
	 );

XeTextTag XeTextGetInsertionTag
	(
#if NeedFunctionPrototypes
	 Widget		/* TextEd Widget pointer */
#endif
	 );

void XeTextSetInsertionPosition
	(
#if NeedFunctionPrototypes
	 Widget,
	 long
#endif
	 );

void XeTextSetInsertionTag
	(
#if NeedFunctionPrototypes
	 Widget,
	 XeTextTag
#endif
	 );

void XeTextGetSelectionPosition
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 long *,	/* Virtual offset of the start of selection */
	 long *		/* Virtual offset of the end of selection */
#endif
	 );

void XeTextSetSelection
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 long,		/* Virtual offset of the start of selection */
	 long		/* Virtual offset of the end of selection */
#endif
	 );

void XeTextUnsetSelection
	(
#if NeedFunctionPrototypes
	 Widget		/* TextEd Widget pointer */
#endif
	 );

void XeTextGetRegionPosition
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 int,		/* Text Region identifier */
	 long *,	/* Virtual offset of the start of region */
	 long *		/* Virtual offset of the end of region */
#endif
	 );

int XeTextSetRegion
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 long,		/* Virtual offset of the start of region */
	 long,		/* Virtual offset of the end of region */
	 XeTextHighlight/* Highlight mode to be used */
#endif
	 );

int XeTextUnsetRegion
	(
#if NeedFunctionPrototypes
	 Widget,	/* TextEd Widget pointer */
	 int		/* Text Region identifier */
#endif
	 );

#ifdef USING_MOTIF_122
/***
 ** SHL - convenience routine to create a Text Editor and to reinstall
 ** the translations like Return and arrow keys that normally a Motif manager
 ** would see.
 **/

Widget XeCreateMotifTextEd(
#if NeedFunctionPrototypes
    String		/* name */,
    Widget              /* parent */,
    ArgList             /* args */,
    Cardinal            /* num_args */
#endif
    );

#endif

_XFUNCPROTOEND
#endif
