#ifndef _XewVideoP_h
#define _XewVideoP_h
/*
** Copyright 1992, 1993, 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/

#include <stdio.h>
#include <X11/Xew/BasicP.h>
#include <X11/Xew/AnimationP.h>
#include <X11/Xew/Video.h>
#include "ImageTools.h"

#if NeedFunctionPrototypes
typedef void (*XeVideoNotify)(XeVideoWidget);
typedef int (*XeVideoOpenPlay)(XeVideoWidget);
typedef int (*XeVideoDecodePlay)(XeVideoWidget);
typedef void (*XeVideoClosePlay)(XeVideoWidget, XeVideoNotify);
typedef void (*XeVideoCleanup)(XeVideoWidget);
#else
typedef void (*XeVideoNotify)();
typedef int (*XeVideoOpenPlay)();
typedef int (*XeVideoDecodePlay)();
typedef void (*XeVideoClosePlay)();
typedef void (*XeVideoCleanup)();
#endif

typedef struct _XeVideoClass
    {
	int makes_compiler_happy;	/* not used */
    } XeVideoClassPart;

typedef struct _XeVideoClassRec
    {
	CoreClassPart	core_class;
	CompositeClassPart composite_class;
	ConstraintClassPart constraint_class;
#ifdef USING_MOTIF_122
        XmManagerClassPart manager_class;
#endif
	XeBasicClassPart basic_class;
	XeAnimationClassPart animation_class;
	XeVideoClassPart video_class;
    } XeVideoClassRec;

typedef struct
    {
	/* resources */
	int min_frame_delay;

	/*
	** private state
	*/
	GC mygc;		/* Craphics Context */
	XeImage *dsp_image;	/* Display image */
	XeRawImage *raw_image;	/* Current raw image */
	XeDataFlow *flow_in;	/* Input flow (from content) */
	XtIntervalId work_id;	/* Non-zero when play running */
	/*
	** Video picture parameters
	*/
	unsigned int done:1;	/* TRUE, if image layout done */
	unsigned int hold:1;	/* TRUE, if decoding should be held off */
	unsigned width, height;	/* Real Image dimensions (pixels) */
	/*
	** Interface to the Video decoder
	*/
	XtPointer decoder;
	XeVideoOpenPlay open_play;
	XeVideoDecodePlay decode_play;
	XeVideoClosePlay close_play;
	XeVideoCleanup video_cleanup;
    } XeVideoPart;

typedef struct _XeVideoRec
    {
	CorePart	core;
	CompositePart	composite;
	ConstraintPart	constraint;
#ifdef USING_MOTIF_122
        XmManagerPart	manager;
#endif
	XeBasicPart	basic;
	XeAnimationPart	animation;
	XeVideoPart	video;
    } XeVideoRec;

/* Class pointer */
extern XeVideoClassRec xeVideoClassRec;

#endif

