/*
** TetrisP.h for XmtdsTetris widget in .
** 
** Made by MaxTheDogSays (dubray_f@epita.fr && rancur_v@epita.fr
** Login   <vr@epita.fr>
** 
** Started on  Mon May 16 22:12:13 1994 vr
** Last update Mon Nov 21 12:11:28 1994 hydrix
*/

#ifndef _XMTDSTETRISP_H_
#define _XMTDSTETRISP_H_	1

#include <X11/CoreP.h>
#include "Tetris.h"

typedef struct		_tm_attr
{
   unsigned char	state:2;
   unsigned char	color:6;	/* see MAX_COLORS */
} tm_attr;

typedef union		_tm_attr_union
{
   unsigned char	equiv;
   tm_attr		tma;		
} tm_attr_union;

#define MAX_COLORS	64		/* 2^6 */

#define STATE_NOTHING	0
#define STATE_FIXED	1
#define STATE_MOVING	2

typedef int		shape_def[4];

typedef struct
{
   int			empty;
} XmtdsTetrisClassPart;

typedef struct			_XmtdsTetrisClassRec
{
   CoreClassPart		core_class;
   XmtdsTetrisClassPart		xmtds_tetris_class;
} XmtdsTetrisClassRec;

extern XmtdsTetrisClassRec	xmtdsTetrisClassRec;

typedef struct
{
   /* resources */
   Pixel		background;
   int			interval;
   int			block_width;
   int			block_height;
   int			game_width;
   int			game_height;
   char			*color_list;
   XtCallbackList	score_callback;
   Boolean		comm;
   int			fd;
   XtPointer		user_data;
   Boolean		slave;
   /* private state */
   Pixel		*pixel_list;
   int			num_colors;
   GC			*gc_list;
   XtIntervalId		xt_interval_id;
   GC			black_gc;
   GC			white_gc;
   GC			bg_gc;
   GC			gray_gc;
   tm_attr_union	*video_mem;
   Boolean		start;
   int			shape;
   int			next_shape;
   int			rotation;
   int			x;
   int			y;
   int			color;
   Boolean		pause;
} XmtdsTetrisPart;

typedef struct	_XmtdsTetrisRec
{
   CorePart		core;
   XmtdsTetrisPart	xmtds_tetris;
} XmtdsTetrisRec;

#define CORE			((w)->core)
#define NEW_CORE		((new)->core)
#define REQUEST_CORE		((request)->core)
#define CURRENT_CORE		((current)->core)
#define TETRIS			((w)->xmtds_tetris)
#define NEW_TETRIS		((new)->xmtds_tetris)
#define REQUEST_TETRIS		((request)->xmtds_tetris)
#define CURRENT_TETRIS		((current)->xmtds_tetris)

#define TM_STATE(tm)		((tm).state)
#define TM_COLOR(tm)		((tm).color)

#define TMU_EQUIV(tmu)		((tmu).equiv)
#define TMU_STATE(tmu)		((tmu).tma.state)
#define TMU_COLOR(tmu)		((tmu).tma.color)

#define VM_ATTR(w,x,y)		((w)->xmtds_tetris.video_mem\
				 [(y)*(w)->xmtds_tetris.game_width+(x)])   

#define VM_EQUIV(w,x,y)		TMU_EQUIV(VM_ATTR(w,x,y))
#define VM_STATE(w,x,y)		TMU_STATE(VM_ATTR(w,x,y))
#define VM_COLOR(w,x,y)		TMU_COLOR(VM_ATTR(w,x,y))

#define VAL_TEST(val,x,y)	((val)&(1<<(15-((y)*4)-(x))))	

#define TETRIS_DEFAULT_FONT	"fixed"

#define RAND(x)			(rand()%(x))

#endif /* _XMTDSTETRISP_H_ */
