/* Generated by wbuild from "Entry.w"
** (generator version $Revision: 2.5 $ of $Date: 94/07/29 15:31:49 $)
*/
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#line 567 "Entry.w"
#include <ctype.h>
#line 568 "Entry.w"
#include <stdio.h>
#line 569 "Entry.w"
#include <string.h>
#line 570 "Entry.w"
#include <X11/Xatom.h>
#line 571 "Entry.w"
#include <X11/Xmu/Atoms.h>
#include <Xfwf/EntryP.h>
#line 257 "Entry.w"
static void activate(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 262 "Entry.w"
static void self_insert(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 288 "Entry.w"
static void del_char(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 307 "Entry.w"
static void backspace(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 324 "Entry.w"
static void kill(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 350 "Entry.w"
static void redraw(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 357 "Entry.w"
static void mclick(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 383 "Entry.w"
static void mouse_in(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 389 "Entry.w"
static void mouse_out(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 395 "Entry.w"
static void bol(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 405 "Entry.w"
static void eol(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 415 "Entry.w"
static void left(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 425 "Entry.w"
static void right(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);

static XtActionsRec actionsList[] = {
{"activate", activate},
{"self_insert", self_insert},
{"del_char", del_char},
{"backspace", backspace},
{"kill", kill},
{"redraw", redraw},
{"mclick", mclick},
{"mouse_in", mouse_in},
{"mouse_out", mouse_out},
{"bol", bol},
{"eol", eol},
{"left", left},
{"right", right},
};

static char defaultTranslations[] = "\
<FocusIn>: focusIn() mouse_in() \n\
<FocusOut>: mouse_out() focusOut() \n\
<Btn1Down>: traverseCurrent() mclick() \n\
<Key>Up: traverseUp() \n\
<Key>Down: traverseDown() \n\
Shift<Key>Tab: traversePrev() \n\
~Shift<Key>Tab: traverseNext() \n\
<Key>BackSpace: backspace() \n\
<Key>Right: right() \n\
<Key>Left: left() \n\
<Key>Home: bol() \n\
<Key>End: eol() \n\
Ctrl<Key>a: bol() \n\
Ctrl<Key>d: del_char() \n\
Ctrl<Key>e: eol() \n\
Ctrl<Key>b: left() \n\
Ctrl<Key>f: right() \n\
Ctrl<Key>h: backspace() \n\
Ctrl<Key>k: kill() \n\
Ctrl<Key>l: redraw() \n\
<Key>Return: activate() \n\
~Ctrl<Key>: self_insert() \n\
";
static void _resolve_inheritance(
#if NeedFunctionPrototypes
WidgetClass
#endif
);
#line 142 "Entry.w"
static void initialize(
#if NeedFunctionPrototypes
Widget ,Widget,ArgList ,Cardinal *
#endif
);
#line 178 "Entry.w"
static Boolean  set_values(
#if NeedFunctionPrototypes
Widget ,Widget ,Widget,ArgList ,Cardinal *
#endif
);
#line 204 "Entry.w"
static void expose(
#if NeedFunctionPrototypes
Widget,XEvent *,Region 
#endif
);
#line 440 "Entry.w"
static void make_gc(
#if NeedFunctionPrototypes
Widget
#endif
);
#line 467 "Entry.w"
static void get_pos(
#if NeedFunctionPrototypes
Widget,Position *,Position *
#endif
);
#line 483 "Entry.w"
static void set_cursor(
#if NeedFunctionPrototypes
Widget,Bool 
#endif
);
#line 502 "Entry.w"
static void set_text(
#if NeedFunctionPrototypes
Widget,int 
#endif
);
#line 527 "Entry.w"
static int  insert_char(
#if NeedFunctionPrototypes
Widget,int 
#endif
);
#line 440 "Entry.w"
/*ARGSUSED*/static void make_gc(self)Widget self;
{
	XtGCMask mask;
	XGCValues values;

	if(((XfwfEntryWidget)self)->xfwfEntry.ngc != NULL)				/* GC for normal text */
		XtReleaseGC(self,((XfwfEntryWidget)self)->xfwfEntry.ngc);

	values.foreground=((XfwfEntryWidget)self)->xfwfEntry.foreground;
	values.background=((XfwfEntryWidget)self)->core.background_pixel;
	values.font=((XfwfEntryWidget)self)->xfwfEntry.font->fid;
	mask=GCFont|GCBackground|GCForeground;
	((XfwfEntryWidget)self)->xfwfEntry.ngc=XtGetGC(self,mask,&values);

	if(((XfwfEntryWidget)self)->xfwfEntry.rgc != NULL)				/* GC for reverse text */
		XtReleaseGC(self,((XfwfEntryWidget)self)->xfwfEntry.rgc);

	values.foreground=((XfwfEntryWidget)self)->core.background_pixel;	
	values.background=((XfwfEntryWidget)self)->xfwfEntry.foreground;			
	values.font=((XfwfEntryWidget)self)->xfwfEntry.font->fid;
	mask=GCFont|GCBackground|GCForeground;
	((XfwfEntryWidget)self)->xfwfEntry.rgc=XtGetGC(self,mask,&values);

}
#line 467 "Entry.w"
/*ARGSUSED*/static void get_pos(self,x,y)Widget self;Position * x;Position * y;
{
	Dimension baseline;
	XRectangle rect;
	
	baseline = ((XfwfEntryWidget)self)->xfwfEntry.font->ascent + ((XfwfEntryWidget)self)->xfwfEntry.font->descent;
	((XfwfEntryWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, &rect.x, &rect.y, &rect.width, &rect.height);

	rect.x += 2;	rect.width -= 4;
	rect.y += 2;	rect.height -= 4;

	*y = rect.y + (rect.height - baseline)/2 + ((XfwfEntryWidget)self)->xfwfEntry.font->ascent;
	*x = rect.x;
}
#line 483 "Entry.w"
/*ARGSUSED*/static void set_cursor(self,flag)Widget self;Bool  flag;
{
	Position x,y;
	Dimension pos,w;
	GC gc;

	/* cursor position is always 0 if echo disabled */
	pos = (((XfwfEntryWidget)self)->xfwfEntry.echo == False ? 0 : ((XfwfEntryWidget)self)->xfwfEntry.text_pos);
	
	gc = (flag == True ? ((XfwfEntryWidget)self)->xfwfEntry.rgc : ((XfwfEntryWidget)self)->xfwfEntry.ngc);
	get_pos(self,&x,&y);
	w=pos*((XfwfEntryWidget)self)->xfwfEntry.font->min_bounds.width;
					  
	if(((XfwfEntryWidget)self)->xfwfEntry.text_pos == ((XfwfEntryWidget)self)->xfwfEntry.text_len || ((XfwfEntryWidget)self)->xfwfEntry.echo == False)
		XDrawImageString(XtDisplay(self),XtWindow(self),gc,x+w,y," ",1);
	else
		XDrawImageString(XtDisplay(self),XtWindow(self),gc,x+w,y,((XfwfEntryWidget)self)->xfwfEntry.text+((XfwfEntryWidget)self)->xfwfEntry.text_pos,1);
}
#line 502 "Entry.w"
/*ARGSUSED*/static void set_text(self,pos)Widget self;int  pos;
{
	Position x,y;
	Dimension w;
	
	get_pos(self,&x,&y);

	w = (((XfwfEntryWidget)self)->xfwfEntry.echo == True ? ((XfwfEntryWidget)self)->xfwfEntry.text_len : 0)*((XfwfEntryWidget)self)->xfwfEntry.font->min_bounds.width;
	XDrawImageString(XtDisplay(self),XtWindow(self),((XfwfEntryWidget)self)->xfwfEntry.ngc,x+w,y," ",1);

	w=pos*((XfwfEntryWidget)self)->xfwfEntry.font->min_bounds.width;
	
#ifdef DEBUG 	
	fprintf(stderr,"set_text(%s,%d) @%d,%d\n",((XfwfEntryWidget)self)->xfwfEntry.text+pos,((XfwfEntryWidget)self)->xfwfEntry.text_len-pos,x+w,y);
#endif
	
	if(((XfwfEntryWidget)self)->xfwfEntry.echo == True)
	{
		XDrawImageString(XtDisplay(self),XtWindow(self),((XfwfEntryWidget)self)->xfwfEntry.ngc,x+w,y,((XfwfEntryWidget)self)->xfwfEntry.text+pos,
						 ((XfwfEntryWidget)self)->xfwfEntry.text_len-pos);
	}
}
#line 527 "Entry.w"
/*ARGSUSED*/static int  insert_char(self,c)Widget self;int  c;
{
	int i,n=0;
	Boolean flag=False;

	if(((XfwfEntryWidget)self)->xfwfEntry.text_len == ((XfwfEntryWidget)self)->xfwfEntry.max)
	{
		XBell(XtDisplay(self),100);
		return n;
	}
	
	if(((XfwfEntryWidget)self)->xfwfEntry.valid == NULL)			/* all printable chars are allowed */
	{
		if(' ' <= c && c <= '~')
			flag=True;
	}
	else					/* check if c is a valid char */
	{
		for(i=0;((XfwfEntryWidget)self)->xfwfEntry.valid[i];i++)
			if(c == ((XfwfEntryWidget)self)->xfwfEntry.valid[i])
			{
				flag=True;
				break ;
			}
	}

	if(flag == True)
	{
		((XfwfEntryWidget)self)->xfwfEntry.text_len++;
		for(i=((XfwfEntryWidget)self)->xfwfEntry.text_len;i > ((XfwfEntryWidget)self)->xfwfEntry.text_pos;)
			((XfwfEntryWidget)self)->xfwfEntry.text[i]=((XfwfEntryWidget)self)->xfwfEntry.text[--i];
		((XfwfEntryWidget)self)->xfwfEntry.text[((XfwfEntryWidget)self)->xfwfEntry.text_pos++]=c;
		n++;
	}
	return n;
}

static XtResource resources[] = {
#line 26 "Entry.w"
{XtNtext,XtCText,XtRString,sizeof(((XfwfEntryRec*)NULL)->xfwfEntry.text),XtOffsetOf(XfwfEntryRec,xfwfEntry.text),XtRImmediate,(XtPointer)NULL },
#line 33 "Entry.w"
{XtNvalid,XtCValid,XtRString,sizeof(((XfwfEntryRec*)NULL)->xfwfEntry.valid),XtOffsetOf(XfwfEntryRec,xfwfEntry.valid),XtRImmediate,(XtPointer)NULL },
#line 39 "Entry.w"
{XtNmax,XtCMax,XtRInt,sizeof(((XfwfEntryRec*)NULL)->xfwfEntry.max),XtOffsetOf(XfwfEntryRec,xfwfEntry.max),XtRImmediate,(XtPointer)0 },
#line 44 "Entry.w"
{XtNecho,XtCEcho,XtRBoolean,sizeof(((XfwfEntryRec*)NULL)->xfwfEntry.echo),XtOffsetOf(XfwfEntryRec,xfwfEntry.echo),XtRImmediate,(XtPointer)True },
#line 51 "Entry.w"
{XtNactivate,XtCActivate,XtRCallback,sizeof(((XfwfEntryRec*)NULL)->xfwfEntry.activate),XtOffsetOf(XfwfEntryRec,xfwfEntry.activate),XtRImmediate,(XtPointer)NULL },
#line 55 "Entry.w"
{XtNfont,XtCFont,XtRFontStruct,sizeof(((XfwfEntryRec*)NULL)->xfwfEntry.font),XtOffsetOf(XfwfEntryRec,xfwfEntry.font),XtRString,(XtPointer)XtDefaultFont },
#line 59 "Entry.w"
{XtNforeground,XtCForeground,XtRPixel,sizeof(((XfwfEntryRec*)NULL)->xfwfEntry.foreground),XtOffsetOf(XfwfEntryRec,xfwfEntry.foreground),XtRString,(XtPointer)XtDefaultForeground },
#line 64 "Entry.w"
{XtNcursor,XtCCursor,XtRCursor,sizeof(((XfwfEntryRec*)NULL)->xfwfFrame.cursor),XtOffsetOf(XfwfEntryRec,xfwfFrame.cursor),XtRString,(XtPointer)"xterm"},
#line 68 "Entry.w"
{XtNtraversalOn,XtCTraversalOn,XtRBoolean,sizeof(((XfwfEntryRec*)NULL)->xfwfCommon.traversalOn),XtOffsetOf(XfwfEntryRec,xfwfCommon.traversalOn),XtRImmediate,(XtPointer)True },
#line 72 "Entry.w"
{XtNframeWidth,XtCFrameWidth,XtRDimension,sizeof(((XfwfEntryRec*)NULL)->xfwfFrame.frameWidth),XtOffsetOf(XfwfEntryRec,xfwfFrame.frameWidth),XtRImmediate,(XtPointer)2 },
#line 76 "Entry.w"
{XtNframeType,XtCFrameType,XtRFrameType,sizeof(((XfwfEntryRec*)NULL)->xfwfFrame.frameType),XtOffsetOf(XfwfEntryRec,xfwfFrame.frameType),XtRImmediate,(XtPointer)XfwfSunken },
};

XfwfEntryClassRec xfwfEntryClassRec = {
{ /* core_class part */
(WidgetClass) &xfwfBoardClassRec,
"XfwfEntry",
sizeof(XfwfEntryRec),
NULL,
_resolve_inheritance,
FALSE,
initialize,
NULL,
XtInheritRealize,
actionsList,
13,
resources,
11,
NULLQUARK,
True ,
XtExposeCompressMultiple ,
True ,
False ,
NULL,
XtInheritResize,
expose,
set_values,
NULL,
XtInheritSetValuesAlmost,
NULL,
XtInheritAcceptFocus,
XtVersion,
NULL,
defaultTranslations,
XtInheritQueryGeometry,
XtInheritDisplayAccelerator,
NULL 
},
{ /* composite_class part */
XtInheritGeometryManager,
XtInheritChangeManaged,
XtInheritInsertChild,
XtInheritDeleteChild,
NULL
},
{ /* XfwfCommon_class part */
XtInherit_compute_inside,
XtInherit_total_frame_width,
XtInherit_highlight_border,
XtInherit_unhighlight_border,
XtInherit_would_accept_focus,
XtInherit_traverse,
XtInherit_lighter_color,
XtInherit_darker_color,
NULL ,
},
{ /* XfwfFrame_class part */
0
},
{ /* XfwfBoard_class part */
XtInherit_set_abs_location,
},
{ /* XfwfEntry_class part */
0
},
};
WidgetClass xfwfEntryWidgetClass = (WidgetClass) &xfwfEntryClassRec;
/*ARGSUSED*/
#line 257 "Entry.w"
static void activate(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    XtCallCallbackList(self, ((XfwfEntryWidget)self)->xfwfEntry.activate, ((XfwfEntryWidget)self)->xfwfEntry.text);
}

/*ARGSUSED*/
#line 262 "Entry.w"
static void self_insert(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    KeySym keysym;
    int n,k,i;
    char buf[100];

    if (event->type != KeyPress && event->type != KeyRelease) 
	{
		XtWarning("action <self_insert> can only handle keyboard events");
		return;
    }

    n = XLookupString(&event->xkey, buf, sizeof(buf), &keysym, &((XfwfEntryWidget)self)->xfwfEntry.compose_stat);
	set_cursor(self,False);
	for(k=i=0;i < n;i++)
		k+=insert_char(self,buf[i]);
	set_text(self,((XfwfEntryWidget)self)->xfwfEntry.text_pos-k);
	set_cursor(self,True);

#ifdef DEBUG	
	fprintf(stderr,"self_insert()\t%d ->%s<\n",keysym,((XfwfEntryWidget)self)->xfwfEntry.text);
#endif	
}

/*ARGSUSED*/
#line 288 "Entry.w"
static void del_char(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    int i;

	if(((XfwfEntryWidget)self)->xfwfEntry.text_pos < ((XfwfEntryWidget)self)->xfwfEntry.text_len)
	{
		set_cursor(self,False);
		((XfwfEntryWidget)self)->xfwfEntry.text_len--;
		for(i=((XfwfEntryWidget)self)->xfwfEntry.text_pos;i < ((XfwfEntryWidget)self)->xfwfEntry.text_len;)
			((XfwfEntryWidget)self)->xfwfEntry.text[i]=((XfwfEntryWidget)self)->xfwfEntry.text[++i];
		((XfwfEntryWidget)self)->xfwfEntry.text[((XfwfEntryWidget)self)->xfwfEntry.text_len]='\0';
		if(((XfwfEntryWidget)self)->xfwfEntry.text_pos > ((XfwfEntryWidget)self)->xfwfEntry.text_len)
			((XfwfEntryWidget)self)->xfwfEntry.text_pos=((XfwfEntryWidget)self)->xfwfEntry.text_len;
		set_text(self,((XfwfEntryWidget)self)->xfwfEntry.text_pos);
		set_cursor(self,True);
	}	
}

/*ARGSUSED*/
#line 307 "Entry.w"
static void backspace(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    int i;

    if(((XfwfEntryWidget)self)->xfwfEntry.text_len > 0 && ((XfwfEntryWidget)self)->xfwfEntry.text_pos > 0)
	{
		set_cursor(self,False);
		for(i=((XfwfEntryWidget)self)->xfwfEntry.text_pos-1;i < ((XfwfEntryWidget)self)->xfwfEntry.text_len;)
			((XfwfEntryWidget)self)->xfwfEntry.text[i]=((XfwfEntryWidget)self)->xfwfEntry.text[++i];
		((XfwfEntryWidget)self)->xfwfEntry.text_len--;
		((XfwfEntryWidget)self)->xfwfEntry.text_pos--;
		set_text(self,((XfwfEntryWidget)self)->xfwfEntry.text_pos);
		set_cursor(self,True);
	}
}

/*ARGSUSED*/
#line 324 "Entry.w"
static void kill(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
	Position x,y;
	Dimension w,h;
	
	if(((XfwfEntryWidget)self)->xfwfEntry.text_pos < ((XfwfEntryWidget)self)->xfwfEntry.text_len)
	{
		get_pos(self,&x,&y);
		x+=(((XfwfEntryWidget)self)->xfwfEntry.text_pos*((XfwfEntryWidget)self)->xfwfEntry.font->min_bounds.width);
		w=(1+((XfwfEntryWidget)self)->xfwfEntry.text_len-((XfwfEntryWidget)self)->xfwfEntry.text_pos)*((XfwfEntryWidget)self)->xfwfEntry.font->min_bounds.width;
		h=((XfwfEntryWidget)self)->xfwfEntry.font->ascent+((XfwfEntryWidget)self)->xfwfEntry.font->descent;
		
#ifdef DBEUG		
		fprintf(stderr,"kill(%s,%d,%d) %dx%d @%d,%d\n",((XfwfEntryWidget)self)->xfwfEntry.text,((XfwfEntryWidget)self)->xfwfEntry.text_pos,\
				((XfwfEntryWidget)self)->xfwfEntry.text_len,w,h,x,y);
#endif
		
		XClearArea(XtDisplay(self),XtWindow(self),x,y-((XfwfEntryWidget)self)->xfwfEntry.font->ascent,w,h,False);
		((XfwfEntryWidget)self)->xfwfEntry.text[((XfwfEntryWidget)self)->xfwfEntry.text_pos]='\0';
		((XfwfEntryWidget)self)->xfwfEntry.text_len=((XfwfEntryWidget)self)->xfwfEntry.text_pos;
		set_text(self,((XfwfEntryWidget)self)->xfwfEntry.text_pos);
		set_cursor(self,True);
	}
}

/*ARGSUSED*/
#line 350 "Entry.w"
static void redraw(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
	set_text(self,0);
	set_cursor(self,True);
}

/*ARGSUSED*/
#line 357 "Entry.w"
static void mclick(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
	Position x,y;
	XButtonEvent xbutton;
	
	if(event->type != ButtonPress)
	{
		fprintf(stderr,"mclick called with invalid event type\n");
		XBell(XtDisplay(self),100);
		return ;
	}
	xbutton= event->xbutton;
	set_cursor(self,False);
	get_pos(self,&x,&y);

	((XfwfEntryWidget)self)->xfwfEntry.text_pos=(xbutton.x-x)/((XfwfEntryWidget)self)->xfwfEntry.font->min_bounds.width;
	if(((XfwfEntryWidget)self)->xfwfEntry.text_pos > ((XfwfEntryWidget)self)->xfwfEntry.text_len)
		((XfwfEntryWidget)self)->xfwfEntry.text_pos=((XfwfEntryWidget)self)->xfwfEntry.text_len;
	set_cursor(self,True);

#ifdef DEBUG
	fprintf(stderr,"mclick @%d,%d -> %d\n",xbutton.x,xbutton.y,((XfwfEntryWidget)self)->xfwfEntry.text_pos);
#endif	
}

/*ARGSUSED*/
#line 383 "Entry.w"
static void mouse_in(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
	set_cursor(self,True);	
}

/*ARGSUSED*/
#line 389 "Entry.w"
static void mouse_out(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
	set_cursor(self,False);	
}

/*ARGSUSED*/
#line 395 "Entry.w"
static void bol(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
	if (((XfwfEntryWidget)self)->xfwfEntry.text_pos != 0)
	{
		set_cursor(self,False);		
		((XfwfEntryWidget)self)->xfwfEntry.text_pos = 0;
		set_cursor(self,True);		
	}
}

/*ARGSUSED*/
#line 405 "Entry.w"
static void eol(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
	if (((XfwfEntryWidget)self)->xfwfEntry.text_pos < ((XfwfEntryWidget)self)->xfwfEntry.text_len)
	{
		set_cursor(self,False);
		((XfwfEntryWidget)self)->xfwfEntry.text_pos = ((XfwfEntryWidget)self)->xfwfEntry.text_len;
		set_cursor(self,True);
	}
}

/*ARGSUSED*/
#line 415 "Entry.w"
static void left(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
	if(((XfwfEntryWidget)self)->xfwfEntry.text_pos > 0)
	{
		set_cursor(self,False);
		((XfwfEntryWidget)self)->xfwfEntry.text_pos--;
		set_cursor(self,True);
	}
}

/*ARGSUSED*/
#line 425 "Entry.w"
static void right(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
	if(((XfwfEntryWidget)self)->xfwfEntry.text_pos < ((XfwfEntryWidget)self)->xfwfEntry.text_len)
	{
		set_cursor(self,False);
		((XfwfEntryWidget)self)->xfwfEntry.text_pos++;
		set_cursor(self,True);
	}
}

static void _resolve_inheritance(class)
WidgetClass class;
{
  XfwfEntryWidgetClass c = (XfwfEntryWidgetClass) class;
  XfwfEntryWidgetClass super;
  static CompositeClassExtensionRec extension_rec = {
    NULL, NULLQUARK, XtCompositeExtensionVersion,
    sizeof(CompositeClassExtensionRec), True};
  CompositeClassExtensionRec *ext;
  ext = (XtPointer)XtMalloc(sizeof(*ext));
  *ext = extension_rec;
  ext->next_extension = c->composite_class.extension;
  c->composite_class.extension = ext;
  if (class == xfwfEntryWidgetClass) return;
  super = (XfwfEntryWidgetClass)class->core_class.superclass;
}
#line 142 "Entry.w"
/*ARGSUSED*/static void initialize(request,self,args,num_args)Widget  request;Widget self;ArgList  args;Cardinal * num_args;
{
	String tmp;
	int i;

#ifdef DEBUG	
	fprintf(stderr,"init(%s) [%s,%d,%s]\n",XtName(self),((XfwfEntryWidget)self)->xfwfEntry.valid,((XfwfEntryWidget)self)->xfwfEntry.max,\
			((XfwfEntryWidget)self)->xfwfEntry.echo ? "true" : "false");
#endif
	
	((XfwfEntryWidget)self)->xfwfEntry.text_pos=((XfwfEntryWidget)self)->xfwfEntry.text_len=0;

	((XfwfEntryWidget)self)->xfwfEntry.ngc=((XfwfEntryWidget)self)->xfwfEntry.rgc=NULL;
	make_gc(self);
	
	if(((XfwfEntryWidget)self)->xfwfEntry.valid != NULL)
		((XfwfEntryWidget)self)->xfwfEntry.valid=XtNewString(((XfwfEntryWidget)self)->xfwfEntry.valid);
	tmp=XtMalloc((1+((XfwfEntryWidget)self)->xfwfEntry.max)*sizeof(char));
	tmp[0]='\0';

	if(((XfwfEntryWidget)self)->xfwfEntry.text != NULL)
	{
		for(i=0;((XfwfEntryWidget)self)->xfwfEntry.text[i] && i < ((XfwfEntryWidget)self)->xfwfEntry.max;i++)
			tmp[i]=((XfwfEntryWidget)self)->xfwfEntry.text[i];
		tmp[i]='\0';
		((XfwfEntryWidget)self)->xfwfEntry.text_pos=((XfwfEntryWidget)self)->xfwfEntry.text_len=i;
	}
	((XfwfEntryWidget)self)->xfwfEntry.text=tmp;
#ifdef DEBUG	
	fprintf(stderr,"entry.init(%s)\n",((XfwfEntryWidget)self)->xfwfEntry.text);
#endif	
}
#line 178 "Entry.w"
/*ARGSUSED*/static Boolean  set_values(old,request,self,args,num_args)Widget  old;Widget  request;Widget self;ArgList  args;Cardinal * num_args;
{
	String tmp;
	int i;

#ifdef DEBUG	
	fprintf(stderr,"set_values(%s) '%s'\n",XtName(self),((XfwfEntryWidget)self)->xfwfEntry.text);
#endif
	
	if(((XfwfEntryWidget)old)->xfwfEntry.text != ((XfwfEntryWidget)self)->xfwfEntry.text)
	{
		XtFree(((XfwfEntryWidget)old)->xfwfEntry.text);
		tmp=XtMalloc((1+((XfwfEntryWidget)self)->xfwfEntry.max)*sizeof(char));
		for(i=0;((XfwfEntryWidget)self)->xfwfEntry.text[i] && i < ((XfwfEntryWidget)self)->xfwfEntry.max;i++)
			tmp[i]=((XfwfEntryWidget)self)->xfwfEntry.text[i];
		tmp[i]='\0';
		((XfwfEntryWidget)self)->xfwfEntry.text_pos=((XfwfEntryWidget)self)->xfwfEntry.text_len=i;
		((XfwfEntryWidget)self)->xfwfEntry.text=tmp;
	}

	return True;	
}
#line 204 "Entry.w"
/*ARGSUSED*/static void expose(self,event,region)Widget self;XEvent * event;Region  region;
{
	if(! XtIsRealized(self))
		return ;
	
	xfwfBoardClassRec.core_class.expose(self,event,region);
	set_text(self,0);
	if(((XfwfEntryWidget)self)->xfwfCommon.traversal_focus == True)
		set_cursor(self,True);
	
#ifdef DEBUG	
	fprintf(stderr,"expose(%s)\t,%s,len %d, max %d, pos %d\n",XtName(self),\
				((XfwfEntryWidget)self)->xfwfEntry.text,((XfwfEntryWidget)self)->xfwfEntry.text_len,((XfwfEntryWidget)self)->xfwfEntry.max,((XfwfEntryWidget)self)->xfwfEntry.text_pos);
#endif	
}
#line 116 "Entry.w"
/*ARGSUSED*/void  XfwfEntryClear(self)Widget self;
{
	Position x,y;
	Dimension h,w;
	
	if(((XfwfEntryWidget)self)->xfwfEntry.text != NULL)
	{
		get_pos(self,&x,&y);
		w=++((XfwfEntryWidget)self)->xfwfEntry.text_len*((XfwfEntryWidget)self)->xfwfEntry.font->min_bounds.width;
		h=((XfwfEntryWidget)self)->xfwfEntry.font->ascent+((XfwfEntryWidget)self)->xfwfEntry.font->descent;
#ifdef DEBUG		
		fprintf(stderr,"clear(%s,%d) %dx%d @%d,%d,[%dx%d]\n",((XfwfEntryWidget)self)->xfwfEntry.text,((XfwfEntryWidget)self)->xfwfEntry.text_len,\
				w,h,x,y,((XfwfEntryWidget)self)->core.width,((XfwfEntryWidget)self)->core.height);
#endif		
		((XfwfEntryWidget)self)->xfwfEntry.text_pos=((XfwfEntryWidget)self)->xfwfEntry.text_len=0;
		((XfwfEntryWidget)self)->xfwfEntry.text[0]='\0';
		XClearArea(XtDisplay(self),XtWindow(self),x,y-((XfwfEntryWidget)self)->xfwfEntry.font->ascent,w,h,False);
		if(((XfwfEntryWidget)self)->xfwfCommon.traversal_focus == True)
			set_cursor(self,True);
	}
}
