.\"remove .ig hn for full docs
.de hi
.ig eh
..
.de eh
..
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfPager
.SH DESCRIPTION
The Pager widget displays one page from a long text. A dog's ear in
the corner allows flipping pages. This is an alternative to scrolled
texts, meant for material that is preferrably read a page at a time.

The Pager can operate in two modes, depending on the setting of the
\fIlines\fP resource. If \fIlines\fP is 0, as many lines are displayed as will
fit in the widget. If \fIlines\fP is positive, that many lines will be
displayed. In the latter case, the widget will also try to scale the
font (provided the font is scalable).

.SS "Public variables"

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfPager
Name	Class	Type	Default
XtNtext	XtCText	String 	NULL 
XtNfontFamily	XtCFontFamily	String 	NULL 
XtNroman	XtCRoman	FontStruct	guess_roman 
XtNlines	XtCLines	int 	0 
XtNwrap	XtCWrap	Boolean 	False 
XtNbaseline	XtCBaseline	float 	"1.2"
XtNmargin	XtCMargin	int 	5 
XtNtablist	XtCTablist	String 	NULL 
XtNforeground	XtCForeground	Pixel 	"black"

.TE
.ps +2

.TP
.I "XtNtext"
The text that is displayed can either be given directly as a
resource, or it can be input from a file or a pipe. The text can
include newlines. Form-feed characters can be used to force the start
of a new page.

If the text starts with an atsign (@@) the rest of the text is
interpreted as a file name. The file will only be read only once and
the contents are held in memory. The file is searched in the current
directory first and, if that fails, with a call to
\fIXtResolvePathname()\fP.

If the text starts with an inverted quote (`), the rest of the text is
considered a command that will be passed to \fIpopen()\fP. The output of
the command is stored in memory and used as the text to display.

	

.hi
String  text = NULL 
.eh

.TP
.I "XtNfontFamily"
The \fIfontFamily\fP is used to set a generic name for the font, instead
of a specific font. If \fIfontFamily\fP is set, but \fIroman\fP is left
unspecified, the widget will try to find a font of the appropriate
size itself.

	

.hi
String  fontFamily = NULL 
.eh

.TP
.I "XtNroman"
The font that is used for the text can be inferred from the
\fIfontFamily\fP resource or it can be set explicitly.

Note that, if the font is scalable and the \fIlines\fP resources is
positive, the actual point size used will depend on the size of the
widget.

	

.hi
<FontStruct> XFontStruct * roman = <CallProc>guess_roman 
.eh

.TP
.I "XtNlines"
The \fIlines\fP resource can be set to a positive value, to force the
widget to display a fixed number of lines, whatever its size. This can
give strange results when the font is not scalable. If \fIlines <= 0\fP,
as many lines are displayed as will fit.

	

.hi
int  lines = 0 
.eh

.TP
.I "XtNwrap"
Someday, the widget might support another mode of display, namely
wrapping text. In this mode, lines are broken between words if they
don't fit on one line. Newlines are ignored, unless there are two in a
row.

	

.hi
Boolean  wrap = False 
.eh

.TP
.I "XtNbaseline"
The interline spacing depends on the font. The \fIbaseline\fP resource
specifies how much the normal baseline is stretched (or shrunk). A
value of 1 corresponds to a baseline equal to the font's ascent plus
the font's descent.

Note that setting \fIlines\fP to a positive value without also using a
scalable font, will mess up the baselines, because the widget will
still try to draw the requested number of lines.

	

.hi
float  baseline = <String>"1.2"
.eh

.TP
.I "XtNmargin"
The \fImargin\fP resource gives the number of pixels that must be left
blank above and to the left of the text.

        

.hi
int  margin = 5 
.eh

.TP
.I "XtNtablist"
A tablist can be provided for tabbing to particular columns
within the label.

	

.hi
String  tablist = NULL 
.eh

.TP
.I "XtNforeground"
The \fIforeground\fP color is the color the text is drawn in. By default,
this widget uses black letters on a white background.

        

.hi
Pixel  foreground = <String>"black"
.eh

.TP
.I "XtNbackground_pixel"
The \fIbackground\fP resource is therefore given the default \fI"white"\fP,
instead of the usual \fIXtDefaultBackground\fP, since that is not guaranteed
to produce white.

        

.hi
 background_pixel = <String>"white"
.eh

.TP
.I "XtNframeType"
The frame type is by default set to sunken.

	

.hi
 frameType = XfwfSunken 
.eh

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfBoard
Name	Class	Type	Default
XtNabs_x	XtCAbs_x	Position 	0 
XtNrel_x	XtCRel_x	Float 	"0.0"
XtNabs_y	XtCAbs_y	Position 	0 
XtNrel_y	XtCRel_y	Float 	"0.0"
XtNabs_width	XtCAbs_width	Position 	0 
XtNrel_width	XtCRel_width	Float 	"1.0"
XtNabs_height	XtCAbs_height	Position 	0 
XtNrel_height	XtCRel_height	Float 	"1.0"
XtNhunit	XtCHunit	Float 	"1.0"
XtNvunit	XtCVunit	Float 	"1.0"
XtNlocation	XtCLocation	String 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfFrame
Name	Class	Type	Default
XtNcursor	XtCCursor	Cursor 	None 
XtNframeType	XtCFrameType	FrameType 	XfwfRaised 
XtNframeWidth	XtCFrameWidth	Dimension 	0 
XtNouterOffset	XtCOuterOffset	Dimension 	0 
XtNinnerOffset	XtCInnerOffset	Dimension 	0 
XtNshadowScheme	XtCShadowScheme	ShadowScheme 	XfwfAuto 
XtNtopShadowColor	XtCTopShadowColor	Pixel 	compute_topcolor 
XtNbottomShadowColor	XtCBottomShadowColor	Pixel 	compute_bottomcolor 
XtNtopShadowStipple	XtCTopShadowStipple	Bitmap 	NULL 
XtNbottomShadowStipple	XtCBottomShadowStipple	Bitmap 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfCommon
Name	Class	Type	Default
XtNtraversalOn	XtCTraversalOn	Boolean 	True 
XtNhighlightThickness	XtCHighlightThickness	Dimension 	2 
XtNhighlightColor	XtCHighlightColor	Pixel 	XtDefaultForeground 
XtNhighlightPixmap	XtCHighlightPixmap	Pixmap 	None 
XtNnextTop	XtCNextTop	Callback	NULL 
XtNuserData	XtCUserData	Pointer	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps +2

.SS "Translations"

.nf
<Key>Prior: previous_page() 
.fi

.nf
<Key>BackSpace: previous_page() 
.fi

.nf
<Key>minus: previous_page() 
.fi

.nf
<Key>Next: next_page() 
.fi

.nf
<Key>space: next_page() 
.fi

.nf
<Key>plus: next_page() 
.fi

.hi
.SS "Actions"

.TP
.I "previous_page

.hi

.nf
void previous_page($, XEvent* event, String* params, Cardinal* num_params)
{
    backwards_CB($, $, NULL);
}
.fi

.eh

.TP
.I "next_page

.hi

.nf
void next_page($, XEvent* event, String* params, Cardinal* num_params)
{
    forward_CB($, $, NULL);
}
.fi

.eh

.hi

.hi
.SH "Importss"

.nf

.B incl
 "flip_back.xpm"
.fi

.nf

.B incl
 "flip_forward.xpm"
.fi

.nf

.B incl
 <Xfwf/Icon.h>
.fi

.nf

.B incl
 <stdlib.h>
.fi

.nf

.B incl
 <fcntl.h>
.fi

.nf

.B incl
 <stdio.h>
.fi

.nf

.B incl
 <Xfwf/TabString.h>
.fi

.nf

.B incl
 <X11/Xmu/Converters.h>
.fi

.hi

.hi
.SS "Private variables"

The text to display may have been passed in the \fItext\fP resource, or
it may have been read from file. In the latter case the \fItext\fP resource
will hold the file name instead of the text. The private variable
\fIfulltext\fP will hold the real text, whether stored in the \fItext\fP
resource or read from file.

	

.nf
String  fulltext
.fi

\fIpage\fP is a list of indexes into \fIfulltext\fP that points to the start
of each page. It is updated whenever the size of a page changes.
\fIpage[0]\fP is unused, since the first page will be numbered `1'.  The
end of the text is marked with \fIpage[i] == -1\fP

	

.nf
int * page
.fi

The current page number is held in \fIpageno\fP. Asnoted above, pages
are numbered from 1.

	

.nf
int  pageno
.fi

The dog's ear in the lower right corner actually consists of two
icons.

	

.nf
Widget  flip_back
.fi

.nf
Widget  flip_forward
.fi

The full name of the font is stored in a private variable, so
it can be changed by the \fIscale_font\fP function, in search of scaled
versions of the font.

        

.nf
String  roman_name
.fi

The GC is used to draw the text.

	

.nf
GC  romangc
.fi

The baseline distance in pixels is computed from the font's height
times the value of \fIbaseline\fP.

	

.nf
int  baselineskip
.fi

The two icons that make up the dog's ear.

	

.nf
Icon  f_back
.fi

.nf
Icon  f_forward
.fi

The tablist is converted from string format to a list of int's for speed.

	

.nf
int * tabs
.fi

.hi

.hi
.SS "Methods"

The \fIinitialize\fP method uses a utility function \fIinit_text\fP to set
the private variables. The same function is also used by \fIset_values\fP.
Another utility function is used to try to change the font size when
\fIlines\fP is set to a positive value.

The dog's ear is implemented as a pair of icons. Callbacks will be
attached to the icons.

The event translations for the icons would normally include an action
for the Return key, but in this case the icons are made to react only
to button events. Key events are passed on to the Pager itself.

.nf
initialize(Widget  request, $, ArgList  args, Cardinal * num_args)
{
    int status;
    static char trans[] = "<Btn1Down>,<Btn1Up>: activate()";

    $tabs = XfwfTablist2Tabs($tablist);

    $f_back.attributes.valuemask = XpmSize;
    status = XpmCreatePixmapFromData
	(XtDisplay($), DefaultRootWindow(XtDisplay($)), flip_back,
	 $f_back.pixmap, $f_back.mask, $f_back.attributes);
    switch (status) {
    case XpmNoMemory: XtError("Out of memory");
    case XpmColorFailed: XtError("Failed to allocate color for pixmap");
    case XpmColorError: XtWarning("Not all pixmap colors found");
    default: ; /* skip */
    }
    $flip_back = XtVaCreateManagedWidget
	("_flip_back", xfwfIconWidgetClass, $,
	 XtNlocation, "1.0-50 1.0-50 50 50", XtNimage, $f_back,
	 XtNhighlightThickness, 0, XtNtraversalOn, False,
	 XtVaTypedArg, XtNtranslations, XtRString, trans,
	 strlen(trans)+1, NULL);
    XtAddCallback($flip_back, XtNactivate, backwards_CB, $);

    $f_forward.attributes.valuemask = XpmSize;
    status = XpmCreatePixmapFromData
	(XtDisplay($), DefaultRootWindow(XtDisplay($)), flip_forward,
	 $f_forward.pixmap, $f_forward.mask, $f_forward.attributes);
    switch (status) {
    case XpmNoMemory: XtError("Out of memory");
    case XpmColorFailed: XtError("Failed to allocate color for pixmap");
    case XpmColorError: XtWarning("Not all pixmap colors found");
    default: ; /* skip */
    }
    $flip_forward = XtVaCreateManagedWidget
	("_flip_forward", xfwfIconWidgetClass, $,
	 XtNlocation, "1.0-50 1.0-50 50 50", XtNimage, $f_forward,
	 XtNhighlightThickness, 0, XtNtraversalOn, False,
	 XtVaTypedArg, XtNtranslations, XtRString, trans,
	 strlen(trans)+1, NULL);
    XtAddCallback($flip_forward, XtNactivate, forward_CB, $);

    create_romangc($);
    $baselineskip = 0.5 + $baseline * ($roman->ascent + $roman->descent);
    $text = XtNewString($text);
    $fontFamily = XtNewString($fontFamily);
    $tablist = XtNewString($tablist);
    $fulltext = NULL;
    $page = NULL;
    init_text($);
    split_text($);
    if ($lines > 0) scale_font($);
}
.fi

The \fIset_values\fP method calls \fIinit_text\fP for most changes. After
that, the widget will have to be drawn again.

All string resources are copied to newly allocated space on the heap,
so the caller can use local variables as arguments to \fIXtVaSetValues\fP.

.nf
Boolean  set_values(Widget  old, Widget  request, $, ArgList  args, Cardinal * num_args)
{
    Boolean need_redisplay = False;

    if ($tablist != $old$tablist) {
	XtFree($old$tablist);
	XtFree((String) $old$tabs);
	$tablist = XtNewString($tablist);
	$tabs = XfwfTablist2Tabs($tablist);
	need_redisplay = True;
    }
    if ($old$fontFamily != $fontFamily) {
	XtFree($old$fontFamily);
	$fontFamily = XtNewString($fontFamily);
	XFreeFont(XtDisplay($), $roman);
	(void) infer_roman($);
    }
    if ($old$text != $text) {
	XtFree($old$text);
	$text = XtNewString($text);
	init_text($);
	split_text($);
	need_redisplay = True;
    }
    if ($old$roman != $roman
	|| $old$lines != $lines
	|| $old$wrap != $wrap
	|| $old$baseline != $baseline
	|| ($old$width != $width  $lines == 0)
	|| ($old$height != $height  $lines == 0)) {
	split_text($);
	need_redisplay = True;
    }
    if ($old$height != $height  $lines > 0) {
	scale_font($);
	need_redisplay = True;
    }
    return need_redisplay;
}
.fi

When the widget changes size, the font may change, in the case that
\fIlines\fP is positive.

.nf
resize($)
{
    #resize($);
    if ($lines > 0) scale_font($); else split_text($);
}
.fi

The \fIexpose\fP method draws the text of the current page into the widget.
It can operate in two modes, depending on the setting of the \fIwrap\fP
resource. If \fIwrap\fP is \fIFalse\fP, the lines are broken only at newline
characters, even if that would mean that a part of the line disappears
off the right edge of the window. On the other hand, if \fIwrap\fP is \fITrue\fP,
single newline characters are treated as spaces and only double newlines
will force a line break. In this mode, the function will try to find line
breaks at spaces in the text.

The \fIexpose\fP method also adds the current page number at the bottom of
the window.

Note that the \fIexpose\fP method does not have to look at the \fIlines\fP
resource to limit the number of lines on the page, since presumably the
\fIbaseline\fP and the font size have already been set to such values that
exactly the right amount of lines will fit on the page. Drawing text will
stop at 50 pixels from the bottom, to leave room for the dog's ear and
the page number.
 

.nf
expose($, XEvent * event, Region  region)
{
    Region reg;
    XRectangle rect;
    Position y;
    char *p, *q, h[20];
    Display *dpy = XtDisplay($);
    Window win = XtWindow($);

    if (! XtIsRealized($)) return;
    if (! $fulltext) { #expose($, event, region); return; }
    $compute_inside($, rect.x, rect.y, rect.width, rect.height);
    reg = XCreateRegion();
    XUnionRectWithRegion(rect, reg, reg);
    if (region) XIntersectRegion(reg, region, reg);
    XSetRegion(dpy, $romangc, reg);
    y = $margin + $baselineskip - $roman->descent;
    if ($wrap) {
        /* wrapping mode not implemented yet */
    } else {
        p = $fulltext + $page[$pageno];
        while (True) {
            if (y + $roman->descent >= rect.y + rect.height - 50) break;
            for (q = p; *q != '\\0'  *q != '\\n'  *q != '\\f'; q++) ;
            XfwfDrawImageString(dpy, win, $romangc, rect.x+$margin, y,
				p, q - p, $tabs);
            if (*q == '\\0' || *q == '\\f') break;
            y += $baselineskip;
            p = q + 1;
        }
    }
    /* Draw page number */
    sprintf(h, "%d", $pageno);
    XfwfDrawImageString(dpy, win, $romangc, rect.x + rect.width/2, rect.y +
		     rect.height - $roman->descent, h, strlen(h), $tabs);

    XSetClipMask(dpy, $romangc, None);
    #expose($, event, region);
}
.fi

.hi

.hi
.SH "Utilities"

\fIread_from_file\fP opens a file and reads its contents into
\fI$fulltext\fP, which is dynamically allocated.

\fBdef\fP INCREMENT = 2048 

\fBdef\fP mrealloc(ptr, size) =
(void *)XtRealloc ((char *)ptr ,size )

.nf
read_from_file($, String  filename)
{
    int fd, len = 0, nbytes;

    if ((fd = open(filename, O_RDONLY)) < 0) {
	perror(filename);
	return;
    }
    do {
	$fulltext = mrealloc($fulltext, len + INCREMENT + 1);
	nbytes = read(fd, $fulltext + len, INCREMENT);
	if (nbytes < 0) perror(filename); else len += nbytes;
    } while (nbytes > 0);
    $fulltext[len] = '\\0';
    (void) close(fd);
}
.fi

\fIread_from_pipe\fP works almost like \fIread_from_file\fP, except that it
read from a pipe instead of a file.

.nf
read_from_pipe($, String  cmd)
{
    int len = 0, nbytes;
    FILE *stream;

    if ((stream = popen(cmd, "r")) == NULL) {
	perror(cmd);
	return;
    }
    do {
	$fulltext = mrealloc($fulltext, sizeof(char) * (len + INCREMENT + 1));
	nbytes = fread($fulltext + len, sizeof(char), INCREMENT, stream);
	if (nbytes < 0) perror(cmd); else len += nbytes;
    } while (nbytes > 0);
    $fulltext[len] = '\\0';
    (void) pclose(stream);
}
.fi

\fIinit_text\fP initializes the private variables after a change to one
of the resources. It starts by freeing previously allocated memory.
Then it initializes \fIfulltext\fP.

.nf
init_text($)
{
    XtFree($fulltext); $fulltext = NULL;
    XtFree((char*) $page); $page = NULL;
    if ($text == NULL) return;
    /*
     * Initialize $fulltext
     */
    switch ($text[0]) {
    case '@': read_from_file($, $text + 1); break;
    case '`': read_from_pipe($, $text + 1); break;
    default: $fulltext = XtNewString($text);
    }
}
.fi

\fIsplit_text\fP splits \fIfulltext\fP into pages, by setting the indices of
each page in \fIpage\fP. The way in which that is done, depends on the
setting of the \fIwrap\fP and \fIlines\fP resources. Currently, wrapping is
not supported.

.nf
split_text($)
{
    int i, j, n, h;
    Position x, y;
    Dimension wd, ht;
    char prev = '\\0';

    $page = mrealloc($page, 3 * sizeof($page[0]));
    $page[1] = 0;
    j = 2;
    /* Wrapping is not implemented yet */
    if ($lines > 0  $fulltext != NULL) {
	/* Count lines until n == $lines */
	n = 0;
	for (i = 0; $fulltext[i]; prev = $fulltext[i], i++) {
	    if (prev == '\\n') {
		n++;
		if (n == $lines) {
		    $page = mrealloc($page, (j+2) * sizeof($page[0]));
		    $page[j++] = i;
		    n = 0;
		}
	    }
	}
    } else if ($fulltext != NULL) {
	/* Determine page length with actual height of the text */
	$compute_inside($, x, y, wd, ht);
	h = y + $margin + $baselineskip;
	ht = y + ht - 50;
	for (i = 0; $fulltext[i]; prev = $fulltext[i], i++) {
	    if (prev == '\\n') {
		h += $baselineskip;
		if (h + $roman->descent >= ht) {
		    $page[j++] = i;
		    h = y + $margin + $baselineskip;
		}
	    }
	}
    }
    $page[j] = -1;
    $pageno = 1;
}
.fi

When the widget's size changes while \fIlines\fP is set, or when \fIlines\fP
itself changes, the widget tries to shrink or enlarge the fonts to still
be able to display the same number of lines. If the fonts cannot change
(because they are not scalable), the \fIbaseline\fP will be changed instead.
This may produce strange results, even to the extent of overlapping lines
of text.

\fBdef\fP F_FOUNDRY = 1 

\fBdef\fP F_FAMILY = 2 

\fBdef\fP F_WEIGHT = 3 

\fBdef\fP F_SLANT = 4 

\fBdef\fP F_SET_WIDTH = 5 

\fBdef\fP F_SANS = 6 

\fBdef\fP F_PIXELS = 7 

\fBdef\fP F_POINTS = 8 

\fBdef\fP F_HRESOLUTION = 9 

\fBdef\fP F_VRESOLUTION = 10 

\fBdef\fP F_SPACING = 11 

\fBdef\fP F_AVG_WITH = 12 

\fBdef\fP F_CHARSET = 13 

.nf
scale_font($)
{
    Position x, y;
    Dimension w, h;
    int pixels;
    char s[250];
    XFontStruct *fs;
    String info[15];

    $compute_inside($, x, y, w, h);
    $baselineskip = (h - 50 - $margin) / $lines;
    if ($roman_name == NULL			/* Font name is unknown */
	|| ! parse_font_name($roman_name, info)
	|| ! is_scalable_font($roman_name)) {
	$baseline = $baselineskip / (float) ($roman->ascent + $roman->descent);
        return;
    }

    pixels = $baselineskip/$baseline;

    (void) sprintf(s, "-%s-%s-%s-%s-%s-%s-%d-*-%s-%s-%s-*-%s",
		   info[F_FOUNDRY], info[F_FAMILY], info[F_WEIGHT],
		   info[F_SLANT], info[F_SET_WIDTH], info[F_SANS],
		   pixels, info[F_HRESOLUTION], info[F_VRESOLUTION],
		   info[F_SPACING], info[F_CHARSET]);
    /* (void) fprintf(stderr, "scaled roman = %s\\n", s); */
    if ((fs = XLoadQueryFont(XtDisplay($), s)) != NULL) {
        XFreeFont(XtDisplay($), $roman);
        $roman = fs;
        create_romangc($);
    }

    XtFree(info[0]);
}
.fi

.nf
create_romangc($)
{
    XGCValues val;
    XtGCMask mask = GCForeground | GCBackground | GCFont;

    if ($romangc != NULL) XtReleaseGC($, $romangc);
    val.foreground = $foreground;
    val.background = $background_pixel;
    val.font = $roman->fid;
    $romangc = XtGetGC($, mask, val);
}
.fi

To construct the roman font from the \fIfontFamily\fP string, the string is
passed to \fIXListFonts\fP. The returned list is scanned for a font that is
`medium' or `normal' and `r' (i.e., roman). If none is found, the list is
scanned again for one that is `r' of any weight. If that still doesn't
produce a font, the first font from the list is taken. If there is no
\fIfontFamily\fP resource, or \fIXListFonts\fP returns no matching fonts, the
function returns \fIFalse\fP.

.nf
Boolean  infer_roman($)
{
    char **fonts;
    int n, i;

    XtFree($roman_name); $roman_name = NULL;
    if ($fontFamily == NULL) return False;
    fonts = XListFonts(XtDisplay($), $fontFamily, 1000, n);
    if (n == 0) return False;
    for (i = 0; i < n; i++)
	if (strstr(fonts[i], "normal-r") || strstr(fonts[i], "medium-r")) {
	    $roman_name = XtNewString(fonts[i]);
	    break;
	}
    if ($roman_name == NULL)
	for (i = 0; i < n; i++)
	    if (strstr(fonts[i], "-r-")) {
		$roman_name = XtNewString(fonts[i]);
		break;
	    }
    if ($roman_name == NULL)
	$roman_name = XtNewString(fonts[0]);
    $roman = XLoadQueryFont(XtDisplay($), $roman_name);
    XFreeFontNames(fonts);
    /* (void) fprintf(stderr, "roman name = %s\\n", $roman_name); */
    return True;
}
.fi

The \fIguess_roman\fP routine first tries to construct the font from
the \fIfontFamily\fP resource and if that fails it loads the `fixed' font,
which should always be available.

.nf
guess_roman($, int  offset, XrmValue * value)
{
    static XFontStruct *fixed;

    $roman_name = NULL;
    if (infer_roman($))
	value->addr = (XtPointer) $roman;
    else {
	fixed = XLoadQueryFont(XtDisplay($), "fixed");
	value->addr = (XtPointer) fixed;
    }
}
.fi

This routine (which is copied from Adrian Nye's `Xlib programming
manual,' (O'Reilly 1992), page 569), returns \fITrue\fP if the passed name
is a well-formed XLFD style font name with a pixel size,point size,
and average width (fields 7, 8, and 12) of \fI-0-\fP.

.nf
Boolean  is_scalable_font(String  name)
{
    int i, field;

    if (name == NULL || name[0] != '-') return False;
    for (i = field = 0; name[i] != '\\0'; i++) {
	if (name[i] == '-') {
	    field++;
	    if (field == 7 || field == 8 || field == 12)
		if (name[i+1] != '0' || name[i+2] != '-')
		    return False;
	}
    }
    return (field == 14);
}
.fi

The function \fIparse_font_name\fP makes a copy of the font name into
\fItable[0]\fP (room is allocated on the heap). All hyphens are then
replaced by \fI\\0\fP and the other 14 entries in \fItable\fP are made to point
to the start of each part of the name.

.nf
Boolean  parse_font_name(String  name, String * table)
{
    int i, field;

    if (name == NULL || name[0] != '-') return False;
    table[0] = XtNewString(name);
    for (i = field = 0; name[i] != '\\0'; i++) {
	if (name[i] == '-') {
	    field++;
	    table[0][i] = '\\0';
	    table[field] = table[0][i+1];
	    if (field == 13) break;		/* No more fields */
	}
    }
    return True;
}
.fi

The \fIforward_CB\fP callback is attached to the `flip_forward' icon. The
callback increments the page number and causes the corresponding page to
be displayed, provided the current page isn't already the last one.

.nf
forward_CB(Widget  w, XtPointer  client_data, XtPointer  call_data)
{
    Widget $ = (Widget) client_data;

    if ($page[$pageno+1] >= 0) {
	$pageno++;
	XClearWindow(XtDisplay($), XtWindow($));
	$expose($, NULL, NULL);
    }
}
.fi

The `flip_back' icon has gotten the \fIbackwards_CB\fP callback. The
callback decrements the page number and causes the corresponding page to
be displayed, provided the page number isn't already 1.

.nf
backwards_CB(Widget  w, XtPointer  client_data, XtPointer  call_data)
{
    Widget $ = (Widget) client_data;

    if ($pageno > 1) {
	$pageno--;
	XClearWindow(XtDisplay($), XtWindow($));
	$expose($, NULL, NULL);
    }
}
.fi

.hi
