.\"remove .ig hn for full docs
.de hi
.ig eh
..
.de eh
..
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfSpinLabel
.SH DESCRIPTION
The \fIXfwfSpinLabel\fP is derived from the \fIXfwfLabel\fP widget.
It provides nearly the same features as its superclass but
additionally it is possible to manipulate the labels using
two arrow buttons. With these the user is able to increase/decrease a 
numerical value or scroll trough a list of strings. every time one 
of the arrows is pressed the \fIactivate\fP callback is invoked.
The \fISpinLabel\fP widget provides a keyboard interface too.
Using a callback the programmer is free to decide trough what 
he let the user scroll.
It is possible to choose various styles using different
combinations of orientation and side.

.SS "Public variables"

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfSpinLabel
Name	Class	Type	Default
XtNarrowForeground	XtCArrowForeground	Pixel 	copy_background 
XtNcallback	XtCCallback	Callback	NULL 
XtNlabelframeWidth	XtCLabelframeWidth	Dimension 	0 
XtNlabelframeType	XtCLabelframeType	FrameType 	XfwfSunken 
XtNhorizontal	XtCHorizontal	Boolean 	True 

.TE
.ps +2

.TP
.I "XtNarrowForeground"
The foreground color for the arrows. if not specified the background
color is used.

	

.hi
Pixel  arrowForeground = <CallProc>copy_background 
.eh

.TP
.I "XtNcallback"
The \fIactivate\fP action is invoked every time the user clicks
on one of the arrows using the mouse or uses the keyboard interface.
See Translations for the default keybindings.
The concrete action (XfwfFirst,XfwfPrev,XfwfNext,XfwfLast) is passed 
using the \fIcall_data\fP argument.

	

.hi
<Callback> XtCallbackList  callback = NULL 
.eh

.TP
.I "XtNtraversalOn"
In contrast to its superclass \fIXfwfLabel\fP the SpinLabel widget
provides a keyboard interface. this means traversalOn is set to True.

	

.hi
 traversalOn = True 
.eh

.TP
.I "XtNframeWidth"
The default \fIframeWidth\fP of the SpinLabel widget is 0.

	

.hi
 frameWidth = 0 
.eh

.TP
.I "XtNframeType"
The value of the \fIframeType\fP resource is set to XfwfChiseled.

	

.hi
 frameType = XfwfChiseled 
.eh

.TP
.I "XtNlabelframeWidth"
The \fIlabelframeWidth\fP controls the frame width of the label.
Defaults to 0.

	

.hi
Dimension  labelframeWidth = 0 
.eh

.TP
.I "XtNlabelframeType"
The \fIlabelframeType\fP controls the frame type of the label.
Default values is XfwfSunken.

	

.hi
FrameType  labelframeType = XfwfSunken 
.eh

.TP
.I "XtNhorizontal"
The \fIhorizontal\fP resource specifies if the arrows should be
horizontal (\fITrue\fP) or vertical (\fIFalse\fP).
Default value is \fITrue\fP.

	

.hi
Boolean  horizontal = True 
.eh

.TP
.I "XtNalignment"
The \fIside\fP is used to specify where the label should live.
Possible values are \fI"center"\fP (\fIXfwfCenter\fP), \fI"left"\fP (\fIXfwfLeft\fP)
and \fI"right"\fP (\fIXfwfRight\fP).
The default value is \fIXfwfCenter\fP.

	

.hi
Alignment  alignment = XfwfCenter 
.eh

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfLabel
Name	Class	Type	Default
XtNlabel	XtCLabel	String 	NULL 
XtNtablist	XtCTablist	String 	NULL 
XtNfont	XtCFont	FontStruct	XtDefaultFont 
XtNforeground	XtCForeground	Pixel 	XtDefaultForeground 
XtNhlForeground	XtCHlForeground	Pixel 	XtDefaultForeground 
XtNalignment	XtCAlignment	Alignment 	0 
XtNtopMargin	XtCTopMargin	Dimension 	2 
XtNbottomMargin	XtCBottomMargin	Dimension 	2 
XtNleftMargin	XtCLeftMargin	Dimension 	2 
XtNrightMargin	XtCRightMargin	Dimension 	2 
XtNshrinkToFit	XtCShrinkToFit	Boolean 	False 
XtNrvStart	XtCRvStart	Int 	0 
XtNrvLength	XtCRvLength	Int 	0 
XtNhlStart	XtCHlStart	Int 	0 
XtNhlLength	XtCHlLength	Int 	0 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfBoard
Name	Class	Type	Default
XtNabs_x	XtCAbs_x	Position 	0 
XtNrel_x	XtCRel_x	Float 	"0.0"
XtNabs_y	XtCAbs_y	Position 	0 
XtNrel_y	XtCRel_y	Float 	"0.0"
XtNabs_width	XtCAbs_width	Position 	0 
XtNrel_width	XtCRel_width	Float 	"1.0"
XtNabs_height	XtCAbs_height	Position 	0 
XtNrel_height	XtCRel_height	Float 	"1.0"
XtNhunit	XtCHunit	Float 	"1.0"
XtNvunit	XtCVunit	Float 	"1.0"
XtNlocation	XtCLocation	String 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfFrame
Name	Class	Type	Default
XtNcursor	XtCCursor	Cursor 	None 
XtNframeType	XtCFrameType	FrameType 	XfwfRaised 
XtNframeWidth	XtCFrameWidth	Dimension 	0 
XtNouterOffset	XtCOuterOffset	Dimension 	0 
XtNinnerOffset	XtCInnerOffset	Dimension 	0 
XtNshadowScheme	XtCShadowScheme	ShadowScheme 	XfwfAuto 
XtNtopShadowColor	XtCTopShadowColor	Pixel 	compute_topcolor 
XtNbottomShadowColor	XtCBottomShadowColor	Pixel 	compute_bottomcolor 
XtNtopShadowStipple	XtCTopShadowStipple	Bitmap 	NULL 
XtNbottomShadowStipple	XtCBottomShadowStipple	Bitmap 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfCommon
Name	Class	Type	Default
XtNtraversalOn	XtCTraversalOn	Boolean 	True 
XtNhighlightThickness	XtCHighlightThickness	Dimension 	2 
XtNhighlightColor	XtCHighlightColor	Pixel 	XtDefaultForeground 
XtNhighlightPixmap	XtCHighlightPixmap	Pixmap 	None 
XtNnextTop	XtCNextTop	Callback	NULL 
XtNuserData	XtCUserData	Pointer	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps +2

.SS "Exports"

SpinType is used for returning the action.

	

.nf

.B type
 SpinType = enum {XfwfFirst,XfwfPrev,XfwfNext,XfwfLast}
.fi

.SS "Translations"

.nf
<Btn1Down>: traverseCurrent() 
.fi

.nf
~Shift<Key>Tab: traverseNext() 
.fi

.nf
Shift<Key>Tab: traversePrev() 
.fi

.nf
<Key>Home: first() 
.fi

.nf
Ctrl<Key>a: first() 
.fi

.nf
<Key>Left: prev() 
.fi

.nf
<Key>Down: prev() 
.fi

.nf
<Key>KP_Subtract: prev() 
.fi

.nf
<Key>minus: prev() 
.fi

.nf
Ctrl<Key>p: prev() 
.fi

.nf
Ctrl<Key>b: prev() 
.fi

.nf
<Key>Up: next() 
.fi

.nf
<Key>Right: next() 
.fi

.nf
Ctrl<Key>n: next() 
.fi

.nf
Ctrl<Key>f: next() 
.fi

.nf
<Key>plus: next() 
.fi

.nf
<Key>KP_Add: next() 
.fi

.nf
<Key>End: last() 
.fi

.nf
Ctrl<Key>e: last() 
.fi

.hi
.SS "Actions"

.TP
.I "first

The \fIfirst\fP action just calls the \fIcallback\fP function passing
\fIXfwfFirst\fP in the \fIcall_data\fP argument.

.hi

.nf
void first($, XEvent* event, String* params, Cardinal* num_params)
{
	XtCallCallbackList($,$callback,(XtPointer) XfwfFirst);
}
.fi

.eh

.TP
.I "prev

The \fIprev\fP action just calls the \fIcallback\fP function passing
\fIXfwfPrev\fP in the \fIcall_data\fP argument.

.hi

.nf
void prev($, XEvent* event, String* params, Cardinal* num_params)
{
	XtCallCallbackList($,$callback,(XtPointer) XfwfPrev);
}
.fi

.eh

.TP
.I "next

The \fInext\fP action just calls the \fIcallback\fP callback passing
\fIXfwfNext\fP in the \fIcall_data\fP argument.

.hi

.nf
void next($, XEvent* event, String* params, Cardinal* num_params)
{
	XtCallCallbackList($,$callback,(XtPointer) XfwfNext);
}
.fi

.eh

.TP
.I "last

The \fIlast\fP action just calls the \fIcallback\fP function passing
\fIXfwfLast\fP in the \fIcall_data\fP argument.

.hi

.nf
void last($, XEvent* event, String* params, Cardinal* num_params)
{
	XtCallCallbackList($,$callback,(XtPointer) XfwfLast);
}
.fi

.eh

.hi

.hi
.SH "Importss"

.nf

.B incl
 <stdio.h>
.fi

.nf

.B incl
 <Xfwf/Arrow.h>
.fi

.nf

.B incl
 <Xfwf/Label.h>
.fi

.hi

.hi
.SS "Private variables"

The 3 children are stored in the following private variables

	

.nf
Widget  _child[3]
.fi

.hi

.hi
.SS "Methods"

The \fIinitialize\fP method creates the Widgets:
Two arrows and one label Widget.

.nf
initialize(Widget  request, $, ArgList  args, Cardinal * num_args)
{
	Bool vert;

	vert=($alignment == XfwfCenter  $horizontal ? True : False);
			
	$_child[0]=XtVaCreateWidget("_arrow1",xfwfArrowWidgetClass,$,
			XtNframeWidth,0,XtNforeground,$arrowForeground,
			XtNtraversalOn, False, XtNhighlightThickness, 0,  
			XtNdirection, vert ? XfwfLeft : XfwfBottom,NULL);
	XtAddCallback($_child[0],XtNcallback,arrow_prev,$);
		
	$_child[1]=XtVaCreateWidget("_label",xfwfLabelWidgetClass,$,
			XtNframeWidth,$labelframeWidth,XtNframeType,$labelframeType,
			XtNlabel,$label,NULL);
	
	$_child[2]=XtVaCreateWidget("_arrow2",xfwfArrowWidgetClass,$,
			XtNframeWidth,0,XtNforeground,$arrowForeground,
			XtNtraversalOn, False, XtNhighlightThickness, 0,
			XtNdirection, vert ? XfwfRight : XfwfTop,NULL);
	XtAddCallback($_child[2],XtNcallback,arrow_next,$);
	set_geometry($);
	XtManageChildren($_child,3);
}
.fi

.nf
resize($)
{
	set_geometry($);
}
.fi

.nf
Boolean  set_values(Widget  old, Widget  request, $, ArgList  args, Cardinal * num_args)
{
	Bool redisplay=False;

#ifdef DEBUG	
	fprintf(stderr,"set_values(%s)\\n",XtName($));
#endif
	
	$set_label($_child[1],$label);

	if($old$alignment != $alignment)
		redisplay=True;

	if($old$horizontal != $horizontal)
		redisplay=True;

	if(redisplay)
		set_geometry($);
	
	if($old$arrowForeground != $arrowForeground)
	{
		XtVaSetValues($_child[0],XtNforeground,$arrowForeground,NULL);
		XtVaSetValues($_child[2],XtNforeground,$arrowForeground,NULL);
	}

	 if($old$labelframeType != $labelframeType)
		XtVaSetValues($_child[1],XtNframeType,$labelframeType,NULL);

	if($old$labelframeWidth != $labelframeWidth)
		XtVaSetValues($_child[1],XtNframeWidth,$labelframeWidth,NULL);

	return redisplay;
}
.fi

.hi

.hi
.SH "Utilities"

.nf
arrow_prev(Widget  w, XtPointer  client_data, XtPointer  call_data)
{
	Widget $ = (Widget) client_data;
	
	XtCallCallbackList(w,$callback,(XtPointer) XfwfPrev);
}
.fi

.nf
arrow_next(Widget  w, XtPointer  client_data, XtPointer  call_data)
{
	Widget $ = (Widget) client_data;
	
	XtCallCallbackList(w,$callback,(XtPointer) XfwfNext);
}
.fi

The \fIcopy_background\fP routine is resource default procedure. It is
called to initialize the default value of the \fIforeground\fP resource.

.nf
copy_background($, int  offset, XrmValue * value)
{
    value->addr = (XtPointer) $background_pixel;
}
.fi

The \fIset_geometry\fP calculates the size of the children

.nf
set_geometry($)
{
	Position x,y,xa1,xa2,xl,yl,ya1,ya2;
	Dimension w,h,wa,ha,wl,hl;
	
	$compute_inside($,x,y,w,h);
	
	if($horizontal)
	{
		hl=h;
		ha=wa=h-4;	/* 2*$frameWidth; */
		wl=w-(2*ha)-2;	/* $frameWidth; */
		yl=y;
		ya1=ya2=y+2;	/* $frameWidth; */
		
		if($alignment == XfwfLeft)
		{
			 xl=x;	xa1=wl+4; /* 2*$frameWidth;*/	xa2=xa1+wa;
		}
		else if($alignment == XfwfRight)
		{
			xa1=x;	xa2=wa+2; /* $frameWidth; */	xl=2*xa2;
		}
		else
		{
			if($alignment != XfwfCenter)
			{
				XtWarning("SpinLabel.alignment: illegal value. using center");
				$alignment=XfwfCenter;
			}
			xa1=x+2; /*$frameWidth;*/	xl=wa+4; /* 2*($frameWidth+$labelframeWidth); */
			xa2=xl+wl;
		}
	}
	else		/* vertical */	
	{
		if($alignment == XfwfLeft)
		{
			hl=h;	ha=h/2-1;
			wa=ha+4; /* 2*$frameWidth;*/	wl=w-wa-2;
			xl=x;	xa1=xa2=wl+2; /* $frameWidth; */
			yl=ya2=y;
			ya1=ha+6;	/* 2+2*$frameWidth; */
		}
		else if($alignment == XfwfRight)
		{
			hl=h;	ha=h/2-1;
			wa=ha+4; /* 2*$frameWidth;*/	wl=w-wa-2;
			xl=wa+4; /* 2*$frameWidth;*/	xa1=xa2=x;
			yl=ya2=y;
			ya1=ha+4; /* 2+2*$frameWidth; */
		}
		else
		{
			if($alignment != XfwfCenter)
			{
				XtWarning("SpinLabel.alignment: illegal value. using center");
				$alignment=XfwfCenter;
			}
			hl=ha=h/3;	wl=wa=w;
			xl=xa1=xa2=x;
			ya2=y;	yl=ya2+ha;	ya1=yl+hl;
		}
	}

#ifdef DEBUG	
	fprintf(stderr,"spin.resize(%s %dx%d @%d,%d)\\n",XtName($),w,h,x,y);
	fprintf(stderr,"\\t[arrow1 %dx%d @%d,%d]\\n",wa,ha,xa1,ya1);
	fprintf(stderr,"\\t[label  %dx%d @%d,%d]\\n",wl,hl,xl,yl);
	fprintf(stderr,"\\t[arrow2 %dx%d @%d,%d]\\n",wa,ha,xa2,ya2);
#endif

	XtConfigureWidget($_child[0],xa1,ya1,wa,ha,0);
	XtConfigureWidget($_child[1],xl,yl,wl,hl,0);
	XtConfigureWidget($_child[2],xa2,ya2,wa,ha,0);
}
.fi

.hi
