.\"remove .ig hn for full docs
.de hi
.ig eh
..
.de eh
..
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XmTabs
.SH DESCRIPTION
The \fIXmTabs\fP widget displays a series of tabs, similar to the
alphabet tabs along the top of index cards. One tab, the front one, is
completely visible, the others are partially hidden behind it. Each of
the tabs can be clicked on with the mouse.

.SS "Public variables"

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XmTabs
Name	Class	Type	Default
XtNlefttabs	XtCLefttabs	int 	0 
XtNrighttabs	XtCRighttabs	int 	0 
XtNlabels	XtCLabels	StringArray 	NULL 
XtNtabcolor	XtCTabcolor	Pixel 	copy_bg 
XtNfont	XtCFont	FontStruct	XtDefaultFont 
XtNactivateCallback	XtCActivateCallback	Callback	NULL 
XtNtextmargin	XtCTextmargin	int 	3 

.TE
.ps +2

.TP
.I "XtNlefttabs"
\fIlefttabs\fP is the number of partially visible tabs to the left of
the main one. The main tab always occupies the same amount of space,
but the tabs to the left become narrower when \fIlefttabs\fP is increased.

	

.hi
int  lefttabs = 0 
.eh

.TP
.I "XtNrighttabs"
The number of tabs to the right of the main one. The higher the
number, the smaller the tabs will be.

	

.hi
int  righttabs = 0 
.eh

.TP
.I "XtNlabels"
The labels on each of the tabs must be simple strings. There is no
support for multiline labels or different fonts in this version of
\fIXfwfTabs\fP. The array \fIlabels\fP should contain no less than \fIlefttabs +
righttabs + 1\fP strings. The widget makes private copies of the array
and of the strings.

The leftmost tab displays \fIlabels[0]\fP. Note that the labels may be too
large to fit in the tab. In that case they are clipped. The left tabs
show only the initial part of the labels, the right tabs show the last
part of their labels and the main (front) tab shows the middle part of
its label.

	

.hi
StringArray  labels = NULL 
.eh

.TP
.I "XtNtabcolor"
The color of the left and right tabs. The main (front) tab is drawn
in the \fIbackground\fP color. Unless the \fItabcolor\fP has been specified
explicitly, the left and right tabs have the same color as the main
tab.

	

.hi
Pixel  tabcolor = <CallProc>copy_bg 
.eh

.TP
.I "XtNfont"
The text is drawn in the font which is given as the \fIfont\fP resource.

	

.hi
<FontStruct> XFontStruct * font = <String>XtDefaultFont 
.eh

.TP
.I "XtNactivateCallback"
When the user clicks on a tab, a callback function is called. The
\fIcall_data\fP argument to the callback will be a relative number: 0 if
the user clicked on the main tab, -1 if he clicked on the tab
immediately to the left, +1 if he clicked on the first right tab, and
higher numbers for tabs that are further removed from the main one.

	

.hi
<Callback> XtCallbackList  activateCallback = NULL 
.eh

.TP
.I "XtNtextmargin"
Labels in the left and right tabs are drawn left resp. right
justified. The \fItextmargin\fP resource gives the number of pixels
between the edge of the tab and the label.

	

.hi
int  textmargin = 3 
.eh

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XmPrimitive
Name	Class	Type	Default
XtNbottom_shadow_color	XtCBottom_shadow_color	Pixel 	0 
XtNbottom_shadow_pixmap	XtCBottom_shadow_pixmap	Pixmap 	None 
XtNforeground	XtCForeground	Pixel 	0 
XtNhelp_callback	XtCHelp_callback	XTCallbackList 	NULL 
XtNhighlight_color	XtCHighlight_color	Pixel 	0 
XtNhighlight_on_enter	XtCHighlight_on_enter	Boolean 	0 
XtNhighlight_pixmap	XtCHighlight_pixmap	Pixmap 	0 
XtNhighlight_thickness	XtCHighlight_thickness	Dimension 	2 
navigationType	XtCNavigationType	NavigationType	XmNONE 
XtNshadow_thickness	XtCShadow_thickness	Dimension 	2 
XtNtop_shadow_color	XtCTop_shadow_color	Pixel 	0 
XtNtop_shadow_pixmap	XtCTop_shadow_pixmap	Pixmap 	None 
XtNtraversal_on	XtCTraversal_on	Boolean 	True 
XtNunit_type	XtCUnit_type	Unsigned  char 	XmPIXELS 
XtNuser_data	XtCUser_data	XTPointer 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps +2

.SS "Translations"

.nf
<Btn1Down>,<Btn1Up>: activate() 
.fi

.hi
.SS "Actions"

.TP
.I "activate

.hi

.nf
void activate($, XEvent* event, String* params, Cardinal* num_params)
{
    Dimension w, delta, ww, w1, w2;
    int i;

    delta = ($height - event->xbutton.y)/2;
    w = $lefttabs + $righttabs == 0 ? 0 : $width/2/($lefttabs + $righttabs);
    w1 = $lefttabs == 0 ? 0 : $lefttabs * w;
    w2 = $righttabs == 0 ? 0 : $righttabs * w;

    if (event->xbutton.x < w1 + delta) {
	/* Click left of main tab */
	if ($lefttabs != 0) {
	    ww = w + delta;
	    for (i = -$lefttabs; event->xbutton.x >= ww; i++, ww += w) ;
	    XtCallCallbackList($, $activateCallback, (XtPointer) i);
	}
    } else if (event->xbutton.x < $width - w2 - delta) {
	/* Click on main tab */
	XtCallCallbackList($, $activateCallback, (XtPointer) 0);
    } else {
	/* Click right of main tab */
	if ($righttabs != 0) {
	    ww = $width - w - delta;
	    for (i = $righttabs; event->xbutton.x < ww; i--, ww -= w) ;
	    XtCallCallbackList($, $activateCallback, (XtPointer) i);
	}
    }
}
.fi

.eh

.hi

.hi
.SH "Importss"

.nf

.B incl
 <stdio.h>
.fi

.nf

.B incl
 <X11/extensions/shape.h>
.fi

.nf

.B incl
 <Xfwf/Converters.h>
.fi

.hi

.hi
.SS "Private variables"

A GC for drawing the labels.

	

.nf
GC  textgc
.fi

A GC for drawing the top shadow lines.

	

.nf
GC  topgc
.fi

A GC for drawing the top shadow lines.

	

.nf
GC  bottomgc
.fi

A GC for filing the main tab.

	

.nf
GC  fillgc
.fi

.hi

.hi
.SH "Class variables"

Set a few class variables.

	

.nf
compress_motion = True 
.fi

.nf
compress_exposure = XtExposeCompressMultiple 
.fi

.nf
compress_enterleave = True 
.fi

.hi

.hi
.SS "Methods"

.nf
class_initialize()
{
    XtSetTypeConverter(XtRString, "StringArray", cvtStringToStringArray,
		       NULL, 0, XtCacheNone, NULL);
}
.fi

The \fIinitialize\fP method checks the resources and creates the local
variables.

For the time being, there is no keyboard traversal.

.nf
initialize(Widget  request, $, ArgList  args, Cardinal * num_args)
{
    String *h;
    int i;

    $traversal_on = FALSE;
    $topgc = NULL;
    create_topgc($);
    $bottomgc = NULL;
    create_bottomgc($);
    $textgc = NULL;
    create_textgc($);
    $fillgc = NULL;
    create_fillgc($);
    if ($labels) {
	h = (String*) XtMalloc(($lefttabs + $righttabs + 1) * sizeof(*h));
	for (i = $lefttabs + $righttabs; i >= 0; i--)
	    h[i] = XtNewString($labels[i]);
	$labels = h;
    }
}
.fi

The \fIset_values\fP method checks changed resources and recomputes some
local variables. In this case the GC's may have to be changed.

.nf
Boolean  set_values(Widget  old, Widget  request, $, ArgList  args, Cardinal * num_args)
{
    Boolean redraw = False;
    String *h;
    int i;

    if ($background_pixel != $old$background_pixel
	|| $background_pixmap != $old$background_pixmap
	|| $shadow_thickness != $old$shadow_thickness) {
	create_topgc($);
	create_bottomgc($);
    }
    if ($foreground != $old$foreground || $font != $old$font) {
	create_textgc($);
	redraw = True;
    }
    if ($textmargin != $old$textmargin
	|| $highlight_thickness != $old$highlight_thickness) {
	redraw = True;
    }
    if ($tabcolor != $old$tabcolor) {
	create_fillgc($);
	redraw = True;
    }
    if ($labels != $old$labels) {
	if ($labels) {
	    h = (String*) XtMalloc(($lefttabs + $righttabs + 1) * sizeof(*h));
	    for (i = $lefttabs + $righttabs; i >= 0; i--) {
		h[i] = XtNewString($labels[i]);
	    }
	    $labels = h;
	}
	if ($old$labels) {
	    for (i = $old$lefttabs + $old$righttabs; i >= 0; i--)
		XtFree($old$labels[i]);
	    XtFree((XtPointer) $old$labels);
	}
	redraw = True;
    }
    if ($lefttabs != $old$lefttabs || $righttabs != $old$righttabs)
	redraw = True;

    return redraw;
}
.fi

When the widget is realized or resized, a new shape mask is
installed. The shape mask makes the corners transparent.

.nf
realize($, XtValueMask * mask, XSetWindowAttributes * attributes)
{
    #realize($, mask, attributes);
    set_shape($);
}
.fi

.nf
resize($)
{
    #resize($);
    set_shape($);
}
.fi

The \fIexpose\fP method draws the tabs. First the tabs to the left, then
the tabs to the right, and finally the main one. Three private
routines do most of the work. The inherited \fIexpose\fP method is called
to draw the frame, if any, although the tabs should look best without
a frame.

.nf
expose($, XEvent * event, Region  region)
{
    int i;
    Dimension width, height;
    Position x, y;

    if (! XtIsRealized($)) return;

    for (i = 0; i < $lefttabs; i++)
	draw_left_tab($, region, i);
    for (i = $lefttabs + $righttabs; i > $lefttabs; i--)
	draw_right_tab($, region, i);
    draw_main_tab($, region);
    /* Focus highlight? */
}
.fi

TO DO: There should be some internal keyboard traversal, and also
new \fIborder_highlight\fP and \fIborder_unhighlight\fP methods.

.nf
border_highlight($)
{
}
.fi

.nf
border_unhighlight($)
{
}
.fi

.hi

.hi
.SH "Utilities"

The \fIdraw_left_tab\fP routine draws a narrow tab to the left of the
main one. The \fIpoly\fP variable holds the corner points of the area
occupied by this tab. The label is written inside this area,
left-aligned.

.nf
draw_left_tab_old($, Region  region, int  i)
{
    Region clip;
    XPoint poly[7];
    Dimension w, delta, shad, h;
    Position x1, y1;
    Display *dpy = XtDisplay($);
    int j = $lefttabs - i + 1;
    h = $highlight_thickness;
    w = ($width - 2 * h)/2/($lefttabs + $righttabs);
    delta = $height/2;				/* Skew */
    shad = $shadow_thickness/2;
    x1 = h + i * w;

    /*
     *     5 o--------o 6
     *      /
     *   4 o
     *    /
     * 3 o        o 0
     *   |        |
     *   |        |
     *   |        |
     * 2 o--------o 1
     */
    poly[0].x = x1 + w;			poly[0].y = h + 4 + j * shad;
    poly[1].x = x1 + w;			poly[1].y = $height - 1 - shad;
    poly[2].x = x1 + shad;		poly[2].y = $height - 1 - shad;
    poly[3].x = x1 + shad;		poly[3].y = h + 4 + j * shad;
    poly[4].x = x1 + 1 + shad;		poly[4].y = h + 1 + j * shad;
    poly[5].x = x1 + 4 + shad;		poly[5].y = h + j * shad;
    poly[6].x = x1 + w + 4 + shad;	poly[6].y = h + j * shad;
	
    clip = XPolygonRegion(poly, XtNumber(poly), EvenOddRule);
    if (region) XIntersectRegion(clip, region, clip);
    XSetRegion(dpy, $textgc, clip);

    XFillPolygon(dpy, XtWindow($), $fillgc, poly, XtNumber(poly),
		 Convex, CoordModeOrigin);

    if ($labels) {
	y1 = ($height - h - j * shad - $font->ascent - $font->descent)/2
	    + h + j * shad;
	XDrawString(dpy, XtWindow($), $textgc, x1 + shad + $textmargin,
		    y1 + $font->ascent, $labels[i], strlen($labels[i]));
    }
    XDrawLines(dpy, XtWindow($), $topgc, poly + 2, 5, CoordModeOrigin);
    XDestroyRegion(clip);
}
.fi

.nf
draw_left_tab($, Region  region, int  i)
{
    Region clip;
    XPoint poly[4];
    Dimension w, delta, shad;
    Position x1, y1, x2;
    Display *dpy = XtDisplay($);

    w = $width/2/($lefttabs + $righttabs);
    delta = $height/2;				/* Skew */
    shad = $shadow_thickness/2;
    x1 = i * w;

    /*
     *     2 o--------o 3
     *      /
     *     /
     *    /
     * 1 o--------o 0
     */
    poly[0].x = x1 + w;			poly[0].y = $height - shad;
    poly[1].x = x1 + shad;		poly[1].y = $height - shad;
    poly[2].x = x1 + shad + delta;	poly[2].y = shad;
    poly[3].x = x1 + w + shad + delta;	poly[3].y = shad;
	
    clip = XPolygonRegion(poly, XtNumber(poly), EvenOddRule);
    if (region) XIntersectRegion(clip, region, clip);
    XSetRegion(dpy, $textgc, clip);

    XFillPolygon(dpy, XtWindow($), $fillgc, poly, XtNumber(poly),
		 Convex, CoordModeOrigin);

    if ($labels) {
	y1 = ($height - $font->ascent - $font->descent)/2;
	x2 = x1 + shad + $textmargin
	    + (y1 + $font->ascent + $font->descent)/2;
	XDrawString(dpy, XtWindow($), $textgc, x2,
		    y1 + $font->ascent, $labels[i], strlen($labels[i]));
    }
    XDrawLines(dpy, XtWindow($), $topgc, poly + 1, 3, CoordModeOrigin);
    XDestroyRegion(clip);
}
.fi

.nf
draw_right_tab_old($, Region  region, int  i)
{
    Region clip;
    XPoint poly[7];
    Dimension w, delta, textw, len, shad, h;
    Position x1, y1;
    Display *dpy = XtDisplay($);
    int j = i - $lefttabs + 1;

    h = $highlight_thickness;
    w = ($width - 2 * h)/2/($lefttabs + $righttabs);
    delta = $height/2;				/* Skew */
    shad = $shadow_thickness/2;

    /*
     * 6 o--------o 5
     *             \\
     *              o 4
     *               \\
     *     0 o        o 3
     *       |        |
     *       |        |
     *       |        |
     *     1 o--------o 2
     */
    x1 = $width - h - w * ($lefttabs + $righttabs - i);
    poly[0].x = x1 - w;			poly[0].y = 4 + j * shad;
    poly[1].x = x1 - w;			poly[1].y = $height - 1 - shad;
    poly[2].x = x1 - shad;		poly[2].y = $height - 1 - shad;
    poly[3].x = x1 - shad;		poly[3].y = h + 4 + j * shad;
    poly[4].x = x1 - 1 - shad;		poly[4].y = h + 1 + j * shad;
    poly[5].x = x1 - 4 - shad;		poly[5].y = h + 0 + j * shad;
    poly[6].x = x1 - w - 4 - shad;	poly[6].y = h + 0 + j * shad;

    clip = XPolygonRegion(poly, XtNumber(poly), EvenOddRule);
    if (region) XIntersectRegion(region, clip, clip);
    XSetRegion(dpy, $textgc, clip);

    XFillPolygon(dpy, XtWindow($), $fillgc, poly, XtNumber(poly),
		 Convex, CoordModeOrigin);

    if ($labels) {
	len = strlen($labels[i]);
	textw = XTextWidth($font, $labels[i], len);
	y1 = ($height - h - j * shad - $font->ascent - $font->descent)/2
	    + h + j * shad;
	XDrawString(dpy, XtWindow($), $textgc, x1 - shad - $textmargin - textw,
		    y1 + $font->ascent, $labels[i], len);
    }
    XDrawLines(dpy, XtWindow($), $bottomgc, poly + 2, 4, CoordModeOrigin);
    XDrawLines(dpy, XtWindow($), $topgc, poly + 5, 2, CoordModeOrigin);
    XDestroyRegion(clip);
}
.fi

.nf
draw_right_tab($, Region  region, int  i)
{
    Region clip;
    XPoint poly[4];
    Dimension w, delta, textw, len, shad;
    Position x1, y1, x2;
    Display *dpy = XtDisplay($);

    w = $width/2/($lefttabs + $righttabs);
    delta = $height/2;				/* Skew */
    shad = $shadow_thickness/2;

    /*
     * 3 o--------o 2
     *             \\
     *              \\
     *               \\
     *     0 o--------o 1
     */
    x1 = $width - w * ($lefttabs + $righttabs - i);
    poly[0].x = x1 - w;			poly[0].y = $height - shad;
    poly[1].x = x1 - shad;		poly[1].y = $height - shad;
    poly[2].x = x1 - shad - delta;	poly[2].y = shad;
    poly[3].x = x1 - w - shad - delta;	poly[3].y = shad;

    clip = XPolygonRegion(poly, XtNumber(poly), EvenOddRule);
    if (region) XIntersectRegion(region, clip, clip);
    XSetRegion(dpy, $textgc, clip);

    XFillPolygon(dpy, XtWindow($), $fillgc, poly, XtNumber(poly),
		 Convex, CoordModeOrigin);

    if ($labels) {
	len = strlen($labels[i]);
	textw = XTextWidth($font, $labels[i], len);
	y1 = ($height - $font->ascent - $font->descent)/2;
	x2 = x1 - shad - $textmargin - textw
	    - (y1 + $font->ascent + $font->descent)/2;
	XDrawString(dpy, XtWindow($), $textgc, x2,
		    y1 + $font->ascent, $labels[i], len);
    }
    XDrawLines(dpy, XtWindow($), $bottomgc, poly + 1, 2, CoordModeOrigin);
    XDrawLines(dpy, XtWindow($), $topgc, poly + 2, 2, CoordModeOrigin);
    XDestroyRegion(clip);
}
.fi

.nf
draw_main_tab_old($, Region  region)
{
    Dimension textw, w1, w2, delta, len, shad, h;
    Display *dpy = XtDisplay($);
    Position x1, y1;
    Region clip;
    XPoint poly[10];

    h = $highlight_thickness;
    delta = $height/2;
    w1 = $lefttabs == 0 ? 0
	: $lefttabs * (($width - 2 * h)/2/($lefttabs + $righttabs));
    w1 += h;
    w2 = $righttabs == 0 ? 0
	: $righttabs * (($width - 2 * h)/2/($lefttabs +$righttabs));
    w2 += h;
    shad = $shadow_thickness/2;

    /*
     *           4 o-------------o 5
     *            /               \\
     *         3 o                 o 6
     *          /                   \\
     *       2 o                     o 7
     *         |                     |
     *         |                     |
     *         |                     |
     * 0 o-----o 1                 8 o------o 9
     */
    poly[0].x = h;			poly[0].y = $height - 1;
    poly[1].x = w1 + shad;		poly[1].y = $height - 1;
    poly[2].x = w1 + shad;		poly[2].y = h + 4 + shad;
    poly[3].x = w1 + 1 + shad;		poly[3].y = h + 1 + shad;
    poly[4].x = w1 + 4 + shad;		poly[4].y = h + 0 + shad;
    poly[5].x = $width - w2 - 4 - shad;	poly[5].y = h + 0 + shad;
    poly[6].x = $width - w2 - 1 - shad;	poly[6].y = h + 1 + shad;
    poly[7].x = $width - w2 - shad;	poly[7].y = h + 4 + shad;
    poly[8].x = $width - w2 - shad;	poly[8].y = $height - 1;
    poly[9].x = $width - h;		poly[9].y = $height - 1;

    clip = XPolygonRegion(poly + 1, 8, EvenOddRule);

    if (region) XIntersectRegion(clip, region, clip);
    XSetRegion(dpy, $textgc, clip);

    if ($labels) {
	len = strlen($labels[$lefttabs]);
	textw = XTextWidth($font, $labels[$lefttabs], len);
	x1 = (w1 + $width - w2)/2 - textw/2;
	y1 = ($height - h - shad - $font->ascent - $font->descent)/2
	    + h + shad + $font->ascent;
	XDrawString(dpy, XtWindow($), $textgc, x1, y1, $labels[$lefttabs],len);
    }
    XDrawLines(dpy, XtWindow($), $topgc, poly, 6, CoordModeOrigin);
    XDrawLines(dpy, XtWindow($), $bottomgc, poly + 5, 4, CoordModeOrigin);
    XDrawLines(dpy, XtWindow($), $topgc, poly + 8, 2, CoordModeOrigin);
    XDestroyRegion(clip);
}
.fi

.nf
draw_main_tab($, Region  region)
{
    Dimension textw, w1, w2, delta, len, shad;
    Display *dpy = XtDisplay($);
    Position x1, y1;
    Region clip;
    XPoint poly[6];

    delta = $height/2;
    w1 = $lefttabs == 0 ? 0
	: $lefttabs * ($width/2/($lefttabs + $righttabs));
    w2 = $righttabs == 0 ? 0
	: $righttabs * ($width/2/($lefttabs +$righttabs));
    w2 = $width - w2;
    shad = $shadow_thickness/2;

    /*
     *           2 o-------------o 3
     *            /               \\
     *           /                 \\
     *          /                   \\
     * 0 o-----o 1                 4 o------o 5
     */
    poly[0].x = 0;			poly[0].y = $height - 1 - shad;
    poly[1].x = w1 + shad;		poly[1].y = $height - 1 - shad;
    poly[2].x = w1 + shad + delta;	poly[2].y = shad;
    poly[3].x = w2 - shad - delta;	poly[3].y = shad;
    poly[4].x = w2 - shad;		poly[4].y = $height - 1 - shad;
    poly[5].x = $width;			poly[5].y = $height - 1 - shad;

    clip = XPolygonRegion(poly + 1, 4, EvenOddRule);
    if (region) XIntersectRegion(clip, region, clip);
    XSetRegion(dpy, $textgc, clip);

    if ($labels) {
	len = strlen($labels[$lefttabs]);
	textw = XTextWidth($font, $labels[$lefttabs], len);
	x1 = (w1 + w2 - textw)/2;
	y1 = ($height - $font->ascent - $font->descent)/2 + $font->ascent;
	XDrawString(dpy, XtWindow($), $textgc, x1, y1, $labels[$lefttabs],len);
    }
    XDrawLines(dpy, XtWindow($), $topgc, poly, 4, CoordModeOrigin);
    XDrawLines(dpy, XtWindow($), $bottomgc, poly + 3, 2, CoordModeOrigin);
    XDrawLines(dpy, XtWindow($), $topgc, poly + 4, 2, CoordModeOrigin);
    XDestroyRegion(clip);
}
.fi

The GCs are not shared, because the clip masks are changed
sometimes.

The current shadows are only drawn with colors, not with pixmaps. This
has to be changed some day.

.nf
create_topgc($)
{
    XtGCMask mask = GCForeground | GCLineWidth;
    XGCValues values;

    if ($topgc != NULL) XFreeGC(XtDisplay($), $topgc);
    values.foreground = $top_shadow_color;
    values.line_width = $shadow_thickness;
    $topgc = XCreateGC(XtDisplay($), RootWindowOfScreen(XtScreen($)),
		       mask, values);
}
.fi

.nf
create_bottomgc($)
{
    XtGCMask mask = GCForeground | GCLineWidth;
    XGCValues values;

    if ($bottomgc != NULL) XFreeGC(XtDisplay($), $bottomgc);
    values.foreground = $bottom_shadow_color;
    values.line_width = $shadow_thickness;
    $bottomgc = XCreateGC(XtDisplay($), RootWindowOfScreen(XtScreen($)),
			  mask, values);
}
.fi

.nf
create_textgc($)
{
    XtGCMask mask = GCForeground | GCFont;
    XGCValues values;

    if ($textgc != NULL) XFreeGC(XtDisplay($), $textgc);
    values.foreground = $foreground;
    values.font = $font->fid;
    $textgc = XCreateGC(XtDisplay($), RootWindowOfScreen(XtScreen($)),
			mask, values);
}
.fi

.nf
create_fillgc($)
{
    XtGCMask mask = GCForeground;
    XGCValues values;

    if ($fillgc != NULL) XFreeGC(XtDisplay($), $fillgc);
    values.foreground = $tabcolor;
    $fillgc = XCreateGC(XtDisplay($), RootWindowOfScreen(XtScreen($)),
			mask, values);
}
.fi

\fIcopy_bg\fP copies the \fIbackground\fP color to the \fImain_color\fP.

.nf
copy_bg($, int  offset, XrmValue * value)
{
    value->addr = (XtPointer) $background_pixel;
}
.fi

\fIset_shape\fP is called from \fIrealize\fP and from \fIresize\fP, to set the
shape of the window.

.nf
set_shape_old($)
{
    Region region;
    Dimension delta;
    XPoint poly[8];

    if (! XtIsRealized($)) return;
    delta = $height/2;

    /*
     *      3 o----------------o 4
     *       /                  \\
     *    2 o                    o 5
     *     /                      \\
     *  1 o                        o 6
     *    |                        |
     *    |                        |
     *    |                        |
     *  0 o------------------------o 7
     */
    poly[0].x = 0;		poly[0].y = $height;
    poly[1].x = 0;		poly[1].y = 4;
    poly[2].x = 1;		poly[2].y = 1;
    poly[3].x = 4;		poly[3].y = 0;
    poly[4].x = $width - 4;	poly[4].y = 0;
    poly[5].x = $width - 1;	poly[5].y = 1;
    poly[6].x = $width;		poly[6].y = 4;
    poly[7].x = $width;		poly[7].y = $height;

    region = XPolygonRegion(poly, XtNumber(poly), EvenOddRule);
    XShapeCombineRegion(XtDisplay($), XtWindow($), ShapeBounding,
			0, 0, region, ShapeSet);
    XDestroyRegion(region);
}
.fi

.nf
set_shape($)
{
    Region region;
    Dimension delta;
    XPoint poly[4];

    if (! XtIsRealized($)) return;
    delta = $height/2;

    /*
     *      1 o----------------o 2
     *       /                  \\
     *      /                    \\
     *     /                      \\
     *  0 o------------------------o 3
     */
    poly[0].x = 0;		poly[0].y = $height;
    poly[1].x = delta;		poly[1].y = 0;
    poly[2].x = $width - delta;	poly[2].y = 0;
    poly[3].x = $width;		poly[3].y = $height;

    region = XPolygonRegion(poly, XtNumber(poly), EvenOddRule);
    XShapeCombineRegion(XtDisplay($), XtWindow($), ShapeBounding,
			0, 0, region, ShapeSet);
    XDestroyRegion(region);
}
.fi

.hi
