'\" t
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfBoard
.SH DESCRIPTION
The Board class adds one thing to the capabilities already present
in the Frame class, viz., location management.

Location management is an improved version of the standard X geometry
management. Size and position of a Board widget (or subclass) can be
given as a combination of absolute and relative sizes.

In contrast to its superclass Frame, Board accepts any number of
children. No layout policy is enforced, however. The children are
expected to be positioned with the help of their own geometry or
location resources.

.SS "Public variables"

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfBoard
Name	Class	Type	Default
XtNabs_x	XtCAbs_x	Position 	0 
XtNrel_x	XtCRel_x	float 	"0.0"
XtNabs_y	XtCAbs_y	Position 	0 
XtNrel_y	XtCRel_y	float 	"0.0"
XtNabs_width	XtCAbs_width	Position 	0 
XtNrel_width	XtCRel_width	float 	"1.0"
XtNabs_height	XtCAbs_height	Position 	0 
XtNrel_height	XtCRel_height	float 	"1.0"
XtNhunit	XtCHunit	float 	"1.0"
XtNvunit	XtCVunit	float 	"1.0"
XtNlocation	XtCLocation	String 	NULL 

.TE
.ps +2

The location management relies on a total of ten resources plus a
string resource that combines eight of them in a more convenient and
compact notation. The location is given by two values in each of the
four dimensions (x, y, width and height). One value holds the absolute
position in pixels, the other holds the position relative to the
parent's width. E.g., When \fIabs_x\fP is 20 and \fIrel_x\fP is 0.3, the x
position of the widget will be 20 pixels plus 0.3 times the width of
the parent. For more examples, see the \fIlocation\fP resource below.

The ninth and tenth resources are \fIhunit\fP and \fIvunit\fP. All assignments
to the \fIabs_*\fP resources are multiplied by \fIhunit\fP (horizontal) or
\fIvunit\fP (vertical). Normally the units are 1, but, e.g., a widget that
displays text might set them to the width and height of character
cells, so that \fIabs_width = 80\fP means a width of 80 characters,
instead of 80 pixels.

The geometry resources of the Core widget (\fIx\fP, \fIy\fP, \fIwidth\fP and
\fIheight\fP are still available.  When they are set, the values are
copied to the \fIabs_*\fP variables and the \fIrel_*\fP variables are set to
0.0.

It is possible that the parent of the current widget doesn't grant the
preferred geometry. In that case the location variables and the geometry
variables will not be synchronized. The location variables will then be
taken to hold the preferred geometry, instead of the actual one.

.TP
.I "XtNabs_x"
The position is determined by the four resources \fIabs_x\fP, \fIrel_x\fP,
\fIabs_y\fP and \fIrel_y\fP.  When the parent is (a subclass of) a Board
widget, the position is not measured from the real size of the parent,
but from the size inside the frame.

(The representation of the float values as strings seems necessary,
because the compiler can't cast a float to a pointer.)

.TP
.I "XtNrel_x"

.TP
.I "XtNabs_y"

.TP
.I "XtNrel_y"

.TP
.I "XtNMAGICNUM"
By setting default values for the \fIx\fP and \fIy\fP variables from Core
explicitly, we can be sure that the variables are synchronized from the
start. If the \fIinitialize\fP method detects a change in any of them, it can
re-synchronize them.

.TP
.I "XtNx"

.TP
.I "XtNy"

.TP
.I "XtNabs_width"
The default values cause a Board widget to be the same size as it's
parent at all times, provided, of course, that the parent allows that.
If the parent is (a subclass of) a Board widget, the size is relative
to the area inside the parent's frame, instead of the total size of
the parent.

.TP
.I "XtNrel_width"

.TP
.I "XtNabs_height"

.TP
.I "XtNrel_height"

.TP
.I "XtNwidth"
The Core variables are given strange defaults, in the hope that the
\fIinitialize\fP method can detect a change in them.

.TP
.I "XtNheight"

.TP
.I "XtNhunit"
\fIhunit\fP is a value in pixels by which \fIabs_x\fP and \fIabs_width\fP are
multiplied; \fIabs_y\fP and \fIabs_height\fP are multiplied by \fIvunit\fP. The
results are rounded to the next larger whole number.

.TP
.I "XtNvunit"

.TP
.I "XtNlocation"
Specifying eight resources in a resource file is more easily done
with the string resource \fIlocation\fP. The string contains four
expressions of the form \fIxa [+-] xr\fP or \fIxr [+-] xa\fP or \fIxa\fP or
\fIxr\fP, where \fI[+-]\fP is either \fI+\fP or \fI-\fP, \fIxa\fP is the absolute value and \fIxr\fP is the relative
value. The two are distinguished by the fact that \fIx_r\fP must
contain a decimal point.

Examples: \fI"0.5 - 20  5  40  1.0 - 50"\fP is a widget of fixed width (40
units) that is horizontally centered; the height is always 50 units
less than the height of the parent.

\fI"0 0 2.0 3.0"\fP is a widget that is twice as wide and three times as
high as its parent.

\fI"-20 0 20 20"\fP is a widget that will be invisible, because it is
located 20 units to the left of the parent and it is also 20 units
wide.

The initial value is \fINULL\fP, but the \fIinitialize\fP method will make sure
that the string is synchronized with the other variables.

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfFrame
Name	Class	Type	Default
XtNcursor	XtCCursor	Cursor 	None 
XtNframeType	XtCFrameType	FrameType 	XfwfRaised 
XtNframeWidth	XtCFrameWidth	Dimension 	0 
XtNouterOffset	XtCOuterOffset	Dimension 	0 
XtNinnerOffset	XtCInnerOffset	Dimension 	0 
XtNshadowScheme	XtCShadowScheme	ShadowScheme 	XfwfAuto 
XtNtopShadowColor	XtCTopShadowColor	Color 	compute_topcolor 
XtNbottomShadowColor	XtCBottomShadowColor	Color 	compute_bottomcolor 
XtNtopShadowStipple	XtCTopShadowStipple	Bitmap 	NULL 
XtNbottomShadowStipple	XtCBottomShadowStipple	Bitmap 	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfCommon
Name	Class	Type	Default
XtNuseXCC	XtCUseXCC	Boolean 	TRUE 
XtNusePrivateColormap	XtCUsePrivateColormap	Boolean 	FALSE 
XtNuseStandardColormaps	XtCUseStandardColormaps	Boolean 	TRUE 
XtNstandardColormap	XtCStandardColormap	Atom 	0 
XtNxcc	XtCXCc	XCC 	create_xcc 
XtNtraversalOn	XtCTraversalOn	Boolean 	True 
XtNhighlightThickness	XtCHighlightThickness	Dimension 	2 
XtNhighlightColor	XtCHighlightColor	Color 	XtDefaultForeground 
XtNbackground	XtCBackground	Color 	XtDefaultBackground 
XtNhighlightPixmap	XtCHighlightPixmap	Pixmap 	None 
XtNnextTop	XtCNextTop	Callback	NULL 
XtNuserData	XtCUserData	Pointer	NULL 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps +2

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps +2
