/**
 *
 * $Header: /cvsroot/hungry/lesstif/lib/Xm-2.0/Xme.c,v 1.12 2000/01/16 17:12:28 amai Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static const char rcsid[] = "$Header: /cvsroot/hungry/lesstif/lib/Xm-2.0/Xme.c,v 1.12 2000/01/16 17:12:28 amai Exp $";

#include <stdio.h>
#include <stdlib.h>

#include <XmI/DebugUtil.h>

#include <LTconfig.h>
#include <XmI/XmI.h>
#include <Xm/XmP.h>
#include <Xm/DragIconP.h>
#include <Xm/XmosP.h>
#include <Xm/VirtKeysP.h>
#include <Xm/VendorSEP.h>
#include <XmI/MessagesI.h>

#include <stdarg.h>

/* DragIcon */
Widget
XmeGetTextualDragIcon(Widget w)
{
    return _XmGetTextualDragIcon(w);
}

/* GeoUtils */
XtGeometryResult
XmeReplyToQueryGeometry(Widget w,
			XtWidgetGeometry *request,
			XtWidgetGeometry *reply)
{
    return _XmGMReplyToQueryGeometry(w, request, reply);
}

/* GadgetUtil */
void
XmeConfigureObject(Widget g,
		   Position x, Position y,
		   Dimension width, Dimension height, Dimension border_width)
{
    _XmConfigureObject(g, x, y, width, height, border_width);
}

/* GadgetUtil */
void
XmeRedisplayGadgets(Widget w, XEvent *event, Region region)
{
    _XmRedisplayGadgets(w, event, region);
}

/* ImageCache */
Boolean
XmeGetPixmapData(Screen *screen, Pixmap pixmap,
		 char **image_name,
		 int *depth, Pixel *foreground, Pixel *background,
		 int *hot_x, int *hot_y,
		 unsigned int *width, unsigned int *height)
{
    return _XmGetPixmapData(screen, pixmap,
			    image_name,
			    depth, foreground, background,
			    hot_x, hot_y, width, height);
}

/* ResConvert */
void
XmeWarning(Widget w, char *fmt,...)
{
    va_list arg_list;
    char buf[256];

    va_start(arg_list, fmt);
    if (w)
    {
	sprintf(buf, "\n    Name: %s\n    Class: %s\n    ",
		XtName(w), XtClass(w)->core_class.class_name);

	vsprintf(buf + strlen(buf), fmt, arg_list);
	va_end(arg_list);

	strcat(buf, "\n");

#ifdef	LESSTIF_PRODUCTION
	XtAppWarning(XtWidgetToApplicationContext(w), buf);
#else
	if (getenv("DEBUG_REDIRECT_XMWARNING"))
	{
	    XdbPrintString(buf);
	}
	else
	{
	    XtAppWarning(XtWidgetToApplicationContext(w), buf);
	}
#endif
    }
    else
    {
	buf[0] = '\0';
	vsprintf(buf + strlen(buf), fmt, arg_list);
	va_end(arg_list);

#ifdef	LESSTIF_PRODUCTION
	XtWarning(buf);
#else
	if (getenv("DEBUG_REDIRECT_XMWARNING"))
	{
	    XdbPrintString(buf);
	}
	else
	{
	    XtWarning(buf);
	}
#endif
    }
}

/* ResConvert */
Boolean
XmeNamesAreEqual(char *in_str, char *text_str)
{
    return _XmStringsAreEqual(in_str, text_str);
}

/* ResInd */
void
XmeFromHorizontalPixels(Widget widget,
			int offset,
			XtArgVal *value)
{
    _XmFromHorizontalPixels(widget, offset, value);
}

/* ResInd */
void
XmeFromVerticalPixels(Widget widget,
		      int offset,
		      XtArgVal *value)
{
    _XmFromVerticalPixels(widget, offset, value);
}

/* ResInd */
XmImportOperator
XmeToHorizontalPixels(Widget widget,
		      int offset,
		      XtArgVal *value)
{
    return _XmToHorizontalPixels(widget, offset, value);
}

/* ResInd */
XmImportOperator
XmeToVerticalPixels(Widget widget,
		    int offset,
		    XtArgVal *value)
{
    return _XmToVerticalPixels(widget, offset, value);
}

/* Screen */
Cursor
XmeGetNullCursor(Widget w)
{
    return _XmGetNullCursor(w);
}

/* Traversal */
Boolean
XmeFocusIsInShell(Widget wid)
{
    return _XmFocusIsInShell(wid);
}

/* Traversal */
void
XmeNavigChangeManaged(Widget w)
{
    _XmNavigChangeManaged(w);
}

/* Vendor */
Display *
XmeGetDefaultDisplay(void)
{
    return _XmGetDefaultDisplay();
}

void 
XmeAddFocusChangeCallback(Widget w, XtCallbackProc cp, XtPointer udata)
{
    XmWidgetExtData extData;

    if(!XmIsVendorShell(w))
    {
        XmeWarning(w, _XmMsgProtocols_0000);
        return;
    }

    extData = _XmGetWidgetExtData(w, XmSHELL_EXTENSION);
    if (extData == NULL)
    {
        XmeWarning(w, "Can not find Vendor Shell Extention Data.");
        return;
    }

    XtAddCallback(extData->widget, XmNfocusMovedCallback, cp, udata);
}

void
XmeRemoveFocusChangeCallback(Widget w, XtCallbackProc cp, XtPointer udata)
{
    XmWidgetExtData extData;

    if(!XmIsVendorShell(w))
    {
        XmeWarning(w, _XmMsgProtocols_0000);
        return;
    }

    extData = _XmGetWidgetExtData(w, XmSHELL_EXTENSION);
    if (extData == NULL)
    {
        XmeWarning(w, "Can not find Vendor Shell Extention Data.");
        return;
    }

    XtRemoveCallback(extData->widget, XmNfocusMovedCallback, cp, udata);
}

/* Visual */
void
XmeGetDefaultPixel(Widget widget,
		   int type,
		   int offset,
		   XrmValue *value)
{
    static Pixel pix;

    if (type == XmBACKGROUND)
    {
	_XmBackgroundColorDefault(widget, offset, value);
	return;
    }
    value->addr = (XPointer)&pix;
    value->size = sizeof pix;
    pix = _XmAccessColorData(_XmGetColors(XtScreenOfObject(widget),
					  ColormapOfObject(widget),
					  XmIsGadget(widget) ?
					  XmParentBackground(widget) :
					  XtBackground(widget)),
			     type);
}

/* VirtKeys */
void
XmeVirtualToActualKeysym(Display *Dsp,
			 KeySym VirtualKeysym,
			 KeySym *RealKeysymReturn,
			 Modifiers *ModifierReturn)
{
    _XmVirtualToActualKeysym(Dsp, VirtualKeysym, RealKeysymReturn,
			     ModifierReturn);
}

/* XmString */
void
XmeStringUpdateWMShellTitle(XmString xmstr, Widget shell)
{
    _XmStringUpdateWMShellTitle(xmstr, shell);
}

void
XmeSetWMShellTitle(XmString xmstr, Widget shell)
{
	/* Apparently the same thing as the above. */
	_XmStringUpdateWMShellTitle(xmstr, shell);
}

/* Xmos */
int
XmeMicroSleep(long secs)
{
    return _XmMicroSleep(secs);
}

/* Xmos */
String
XmeGetHomeDirName(void)
{
    return _XmOSGetHomeDirName();
}

XmFontList
XmeGetDefaultRenderTable(Widget w, unsigned int fontListType)
{
	return NULL;
}
