/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xmu/Converters.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/Toggle.h>
#include "Earth.h"
#include "XearthI.h" /* FOR THE TEST */

#define MIN_TIME	0.1	
#define MAX_TIME	23.59
#define TIME_RES	3600

#define MIN_VIEW_MAG	0.2
#define MAX_VIEW_MAG	50.0

#define MIN_VIEW_ROT	-179.0
#define MAX_VIEW_ROT	359.0

#define MIN_VIEW_LAT	-89.0
#define MAX_VIEW_LAT	89.0

#define MIN_VIEW_LON	-179.0
#define MAX_VIEW_LON	179.0

#define MIN_SHIFT	-1000.0
#define MAX_SHIFT	1000.0
#define SHIFT_RES	1

#define LINE_INCR	0.1

Boolean			verbose = TRUE;
Boolean			help = FALSE;
int			timeout = 50;
int			timeout2 = 1000;
int			time_incr = 1800;

XtAppContext		app_context;
Widget			toplevel;
Widget			earthwidget;
XtIntervalId		interval_id = 0;

char			*fallback[] = 
{
  "*Scrollbar.width:	200",
  "*Scrollbar.height:	10",
  "*background:		gray",
  NULL
};

VOID_FUNC		usage(VOID_DECL)
{
  exit(1);
}

int			check_options(VOID_DECL)
{
  if (verbose)
    {
      fprintf(stderr,"%s %s %s\n",PRODUCT,VERSION,VENDOR);
#ifdef DEBUG
      fprintf(stderr,"compiled with DEBUG\n");
#endif
    }
  return (0);
}

VOID_FUNC		command_quit(w,closure,cbs)
Widget			w;
XtPointer		closure;
XtPointer		cbs;
{
  exit(0);
}

VOID_FUNC		command_new_earth(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
  Widget		shell;
  
  shell = XtVaCreatePopupShell("earthShell",
			       wmShellWidgetClass,
			       toplevel,
			       XtNtitle,	"new earth",
			       NULL);
  earthwidget = XtVaCreateManagedWidget("earth",
					earthWidgetClass,
					shell,
					NULL);
  XtPopup(shell,XtGrabNone);
}

VOID_FUNC		sat_changed P((Widget sat));
VOID_FUNC		sat_changed2 P((Widget sat));

VOID_FUNC		sat_timer(sat)
Widget			sat;
{
  XtAppAddTimeOut(app_context,
		  timeout,
		  (XtTimerCallbackProc)sat_changed,
		  sat);
}

VOID_FUNC		sat_timer2(sat)
Widget			sat;
{
  XtAppAddTimeOut(app_context,
		  timeout2,
		  (XtTimerCallbackProc)sat_changed2,
		  sat);
}

VOID_FUNC		sat_changed(sat)
Widget			sat;
{
  double		lon;

  XearthChildGetLongitude(sat,&lon);
  XearthChildSetLongitude(sat,lon + 1);
  sat_timer(sat);
}

VOID_FUNC		sat_changed2(sat)
Widget			sat;
{
  double		lat;

  XearthChildGetLatitude(sat,&lat);
  XearthChildSetLatitude(sat,lat + 1);
  sat_timer2(sat);
}

VOID_FUNC		command_new_sat(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
  Widget		sat;	

  sat = XtVaCreateManagedWidget("sat",
				labelWidgetClass,
				earthwidget,
				NULL);
  sat_timer(sat);
  sat_timer2(sat);
}

VOID_FUNC		command_do_grid(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
  Boolean		do_grid;

  XtVaGetValues(earthwidget,
		XtNdoGrid,	&do_grid,
		NULL);
  XtVaSetValues(earthwidget,
		XtNdoGrid,	!do_grid,
		NULL);
}

VOID_FUNC		command_proj_type(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
  ProjType		proj_type;

  XtVaGetValues(earthwidget,
		XtNprojType,	&proj_type,
		NULL);
  if (proj_type == ProjTypeMercator)
    proj_type = ProjTypeOrthographic;
  else
    proj_type = ProjTypeMercator;
  XtVaSetValues(earthwidget,
		XtNprojType,	proj_type,
		NULL);
}

VOID_FUNC		command_do_shade(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
  Boolean		do_shade;

  XtVaGetValues(earthwidget,
		XtNdoShade,	&do_shade,
		NULL);
  XtVaSetValues(earthwidget,
		XtNdoShade,	!do_shade,
		NULL);
}

VOID_FUNC		rotate(VOID_DECL)
{
  int			t;

  XtVaGetValues(earthwidget,
		XtNtime,	&t,
		NULL);
  t += time_incr;
  XtVaSetValues(earthwidget,
		XtNtime,	t,
		NULL);
  interval_id = XtAppAddTimeOut(app_context,
				timeout,
				(XtTimerCallbackProc)rotate,
				NULL);
}

VOID_FUNC		command_rotate(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
  rotate();
}

VOID_FUNC		command_stop(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
  if (interval_id)
    {
      XtRemoveTimeOut(interval_id);
      interval_id = 0;
    }
}

VOID_FUNC		time_scrollbar_jump(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
   float                per;
   double               top;
   int                  r;

   per = *(float *)ptr;
   top = (double)per;
   top = top * (MAX_TIME - MIN_TIME) + MIN_TIME;
#ifdef NOTDEF
   fprintf(stderr,"%f\n",top);
#endif
   r = (int)((double)TIME_RES * top);
   XtVaSetValues(earthwidget,
                 XtNtime, r,
                 NULL);
}

VOID_FUNC		view_mag_scrollbar_jump(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
   float                per;
   double               top;
   int                  r;

   per = *(float *)ptr;
   top = (double)per;
   top = top * (MAX_VIEW_MAG - MIN_VIEW_MAG) + MIN_VIEW_MAG;
   XearthSetViewMag(earthwidget,(float)top);
}

VOID_FUNC		view_rot_scrollbar_jump(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
   float                per;
   double               top;
   int                  r;

   per = *(float *)ptr;
   top = (double)per;
   top = top * (MAX_VIEW_ROT - MIN_VIEW_ROT) + MIN_VIEW_ROT;
   XearthSetViewRot(earthwidget,(float)top);
}

VOID_FUNC		view_lon_scrollbar_jump(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
   float                per;
   double               top;
   int                  r;

   per = *(float *)ptr;
   top = (double)per;
   top = top * (MAX_VIEW_LON - MIN_VIEW_LON) + MIN_VIEW_LON;
   XearthSetViewLon(earthwidget,(float)top);
}

VOID_FUNC		view_lat_scrollbar_jump(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
   float                per;
   double               top;
   int                  r;

   per = *(float *)ptr;
   top = (double)per;
   top = top * (MAX_VIEW_LAT - MIN_VIEW_LAT) + MIN_VIEW_LAT;
   XearthSetViewLat(earthwidget,(float)top);
}

VOID_FUNC		shift_x_scrollbar_jump(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
  float                per;
  double               top;
  int                  r;

   per = *(float *)ptr;
   top = (double)per;
   top = top * (MAX_SHIFT - MIN_SHIFT) + MIN_SHIFT;
#ifdef NOTDEF
   fprintf(stderr,"%f\n",top);
#endif
   r = (int)((double)SHIFT_RES * top);
   XtVaSetValues(earthwidget,
                 XtNshiftX, r,
                 NULL);
}

VOID_FUNC		shift_y_scrollbar_jump(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
  float                per;
  double               top;
  int                  r;

   per = *(float *)ptr;
   top = (double)per;
   top = top * (MAX_SHIFT - MIN_SHIFT) + MIN_SHIFT;
#ifdef NOTDEF
   fprintf(stderr,"%f\n",top);
#endif
   r = (int)((double)SHIFT_RES * top);
   XtVaSetValues(earthwidget,
                 XtNshiftY, r,
                 NULL);
}

VOID_FUNC		doit(argc,argv)
int			argc;
char			**argv;
{
  t_status		status;
  Widget		box;
  Widget		shell;
  Widget		command;
  Widget		scrollbar;
  time_t		t;

  if (check_options() < 0)
    exit(1);
  toplevel = XtVaAppInitialize(&app_context,
			       "EarthT",
			       NULL,
			       0,
			       &argc,
			       argv,
			       fallback,
			       NULL);
  box = XtVaCreateManagedWidget("box",
				boxWidgetClass,
				toplevel,
				NULL);
  command = XtVaCreateManagedWidget("quit",
				    commandWidgetClass,
				    box,
				    NULL);
  XtAddCallback(command,
		XtNcallback,
		command_quit,
		NULL);
  command = XtVaCreateManagedWidget("new_earth",
				    commandWidgetClass,
				    box,
				    NULL);
  XtAddCallback(command,
		XtNcallback,
		command_new_earth,
		NULL);
  command = XtVaCreateManagedWidget("new_sat",
				    commandWidgetClass,
				    box,
				    NULL);
  XtAddCallback(command,
		XtNcallback,
		command_new_sat,
		NULL);
  command = XtVaCreateManagedWidget("rotate",
				    commandWidgetClass,
				    box,
				    NULL);
  XtAddCallback(command,
		XtNcallback,
		command_rotate,
		NULL);
  command = XtVaCreateManagedWidget("stop",
				    commandWidgetClass,
				    box,
				    NULL);
  XtAddCallback(command,
		XtNcallback,
		command_stop,
		NULL);
  command = XtVaCreateManagedWidget("change doGrid",
				    commandWidgetClass,
				    box,
				    NULL);
  XtAddCallback(command,
		XtNcallback,
		command_do_grid,
		NULL);
  command = XtVaCreateManagedWidget("change projType",
				    commandWidgetClass,
				    box,
				    NULL);
  XtAddCallback(command,
		XtNcallback,
		command_proj_type,
		NULL);
  command = XtVaCreateManagedWidget("change doShade",
				    commandWidgetClass,
				    box,
				    NULL);
  XtAddCallback(command,
		XtNcallback,
		command_do_shade,
		NULL);
  XtVaCreateManagedWidget("time:",
			  labelWidgetClass,
			  box,
			  NULL);
  scrollbar = XtVaCreateManagedWidget("time_scrollbar",
				      scrollbarWidgetClass,
				      box,
				      XtNorientation,XtorientHorizontal,
				      NULL);
  XtAddCallback(scrollbar,
		XtNjumpProc,
		time_scrollbar_jump,
		NULL);
  XtVaCreateManagedWidget("viewMag:",
			  labelWidgetClass,
			  box,
			  NULL);
  scrollbar = XtVaCreateManagedWidget("view_mag_scrollbar",
				      scrollbarWidgetClass,
				      box,
				      XtNorientation,XtorientHorizontal,
				      NULL);
  XtAddCallback(scrollbar,
		XtNjumpProc,
		view_mag_scrollbar_jump,
		NULL);
  XtVaCreateManagedWidget("viewRot:",
			  labelWidgetClass,
			  box,
			  NULL);
  scrollbar = XtVaCreateManagedWidget("view_rot_scrollbar",
				      scrollbarWidgetClass,
				      box,
				      XtNorientation,XtorientHorizontal,
				      NULL);
  XtAddCallback(scrollbar,
		XtNjumpProc,
		view_rot_scrollbar_jump,
		NULL);
  XtVaCreateManagedWidget("viewLat:",
			  labelWidgetClass,
			  box,
			  NULL);
  scrollbar = XtVaCreateManagedWidget("view_lat_scrollbar",
				      scrollbarWidgetClass,
				      box,
				      XtNorientation,XtorientHorizontal,
				      NULL);
  XtAddCallback(scrollbar,
		XtNjumpProc,
		view_lat_scrollbar_jump,
		NULL);
  XtVaCreateManagedWidget("viewLon:",
			  labelWidgetClass,
			  box,
			  NULL);
  scrollbar = XtVaCreateManagedWidget("view_lon_scrollbar",
				      scrollbarWidgetClass,
				      box,
				      XtNorientation,XtorientHorizontal,
				      NULL);
  XtAddCallback(scrollbar,
		XtNjumpProc,
		view_lon_scrollbar_jump,
		NULL);
  XtVaCreateManagedWidget("shiftX:",
			  labelWidgetClass,
			  box,
			  NULL);
  scrollbar = XtVaCreateManagedWidget("shift_x_scrollbar",
				      scrollbarWidgetClass,
				      box,
				      XtNorientation,XtorientHorizontal,
				      NULL);
  XtAddCallback(scrollbar,
		XtNjumpProc,
		shift_x_scrollbar_jump,
		NULL);
  XtVaCreateManagedWidget("shiftY:",
			  labelWidgetClass,
			  box,
			  NULL);
  scrollbar = XtVaCreateManagedWidget("shift_y_scrollbar",
				      scrollbarWidgetClass,
				      box,
				      XtNorientation,XtorientHorizontal,
				      NULL);
  XtAddCallback(scrollbar,
		XtNjumpProc,
		shift_y_scrollbar_jump,
		NULL);
  shell = XtVaCreatePopupShell("shell",
			       wmShellWidgetClass,
			       toplevel,
			       XtNtitle,	"earth",
			       NULL);
  time(&t);
  earthwidget = XtVaCreateManagedWidget("earth",
					earthWidgetClass,
					shell,
					XtNtime,	t,
					NULL);
  XtPopup(shell,XtGrabNone);
  XtRealizeWidget(toplevel);
  XtAppMainLoop(app_context);
  exit(0);
}

int			main(argc,argv)
int			argc;
char			**argv;
{
  if (help)
    usage();
  doit(argc,argv);
}
