/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "XearthI.h"
#include "Earth.h"
#include "XearthCvt.h"

#define	done(type,value) \
	{							\
	    if (toval->addr != NULL) {				\
		if (toval->size < sizeof(type)) {		\
		    toval->size = sizeof(type);			\
		    return False;				\
		}						\
		*(type*)(toval->addr) = (value);		\
	    }							\
	    else {						\
		static type static_val;				\
		static_val = (value);				\
		toval->addr = (XPointer)&static_val;		\
	    }							\
	    toval->size = sizeof(type);				\
	    return True;					\
	}

Boolean				XearthCvtStringToProjType(display,
							  arg,
							  num_args,
							  fromval,
							  toval,
							  converter_data)
Display				*display;
XrmValue			*arg;
Cardinal			*num_args;
XrmValue			*fromval;
XrmValue			*toval;
XtPointer			*converter_data;
{
  t_status			status;
  static ProjType		proj_type;
  
  if (!strcasecmp(fromval->addr,"orthographic"))
    proj_type = ProjTypeOrthographic;
  else
    if (!(strcasecmp(fromval->addr,"mercator")))
      proj_type = ProjTypeMercator;
    else
      goto bad;
  done(ProjType,proj_type);
bad:
  XtDisplayStringConversionWarning(display,fromval->addr,XtRProjType);
  return (False);
}


VOID_FUNC			XearthFreeCvtProjType(app,
						      toval,
						      converter_data,
						      args,
						      num_args)
XtAppContext			app;
XrmValue			*toval;
XtPointer			converter_data;
XrmValue			*args;
Cardinal			*num_args;
{
  /* NOP */
}

Boolean				XearthCvtStringToViewPosType(display,
							     arg,
							     num_args,
							     fromval,
							     toval,
							     converter_data)
Display				*display;
XrmValue			*arg;
Cardinal			*num_args;
XrmValue			*fromval;
XrmValue			*toval;
XtPointer			*converter_data;
{
  t_status			status;
  static ViewPosType		view_pos_type;
  
  if (!strcasecmp(fromval->addr,"fixed"))
    view_pos_type = ViewPosTypeFixed;
  else
    if (!strcasecmp(fromval->addr,"sunrel"))
      view_pos_type = ViewPosTypeSunRel;
    else
      if (!strcasecmp(fromval->addr,"orbit"))
	view_pos_type = ViewPosTypeOrbit;
      else
	goto bad;
  done(ViewPosType,view_pos_type);
bad:
  XtDisplayStringConversionWarning(display,fromval->addr,XtRViewPosType);
  return (False);
}


VOID_FUNC			XearthFreeCvtViewPosType(app,
							 toval,
							 converter_data,
							 args,
							 num_args)
XtAppContext			app;
XrmValue			*toval;
XtPointer			converter_data;
XrmValue			*args;
Cardinal			*num_args;
{
  /* NOP */
}

VOID_FUNC			XearthRegisterConverters(VOID_DECL)
{
  static Boolean		first = True;
  static XtConvertArgRec	arg[]=
    {
      {
	XtWidgetBaseOffset,0,sizeof(CoreWidget)
      }
    };
  if (first == False)
    return;
  XtSetTypeConverter(XtRString,
		     XtRProjType,
		     XearthCvtStringToProjType,
		     arg,
		     XtNumber(arg),
		     XtCacheNone,
		     XearthFreeCvtProjType);
  XtSetTypeConverter(XtRString,
		     XtRViewPosType,
		     XearthCvtStringToViewPosType,
		     arg,
		     XtNumber(arg),
		     XtCacheNone,
		     XearthFreeCvtViewPosType);
  first = False;
}
