/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "XearthI.h"

t_status		XearthAllocAlgorithm(old_size,
					     request_size,
					     new_size)
size_t			old_size;
size_t			request_size;
size_t			*new_size;
{
  size_t		n;
  
  assert(request_size > old_size);
#ifdef NOTDEF
  fprintf(stderr,"old_size=%d request_size=%d\n",old_size,request_size);
#endif
  if (old_size == 0)
    {
      (*new_size) = request_size;
      return (0);
    }
  n = old_size;
  while (n < request_size)
    n *= 2;
  (*new_size) = n;
  return (0);
}

VOID_PTR		XearthAlloc(size,comment1,comment2,status)
size_t			size;
char			*comment1;
char			*comment2;
t_status		*status;	
{
  VOID_PTR		ptr;

  if (size == 0)
    {
      (*status) = -1;
      return (NULL);
    }
  if ((ptr = malloc(size)) == NULL)
    {
      (*status) = -1;
      return (NULL);
    }
#ifdef NOTDEF
  bff(ptr,size); /* FILL WITH FF */
#endif
  return (ptr);
}

VOID_PTR		XearthRealloc(old_ptr,size,comment1,comment2,status)
VOID_PTR		old_ptr;
size_t			size;
char			*comment1;
char			*comment2;
t_status		*status;
{
  VOID_PTR		ptr;

  if ((ptr = realloc(old_ptr,size)) == NULL)
    {
      (*status) = -1;
      return (NULL);
    }
  return (ptr);
}

VOID_FUNC		XearthFree(ptr,comment1,comment2)
VOID_PTR		ptr;
char			*comment1;
char			*comment2;
{
  free(ptr);
}

t_status		XearthArrAlloc(arr,n)
XearthArr		*arr;
int			n;
{
  t_status		status;
  size_t		real_size;
  VOID_PTR		ptr;

  if (n < arr->base)
    n = arr->base;
  if ((status = arr->alloc_algorithm_proc(arr->allocated * arr->eltsize,
					  n * arr->eltsize,
					  &real_size)) < 0)
    return (status);
  if (arr->elts == NULL)
    {
      if ((ptr = arr->alloc_proc(real_size,
				 arr->comment,
				 "arr_alloc:elts",
				 &status)) == NULL)
	return (status);
    }
  else
    {
      if ((ptr = arr->realloc_proc(arr->elts,
				   real_size,
				   arr->comment,
				   "arr_alloc:elts",
				   &status)) == NULL)
	return (status);
    }
  arr->elts = ptr;
  arr->allocated = real_size / arr->eltsize;
  return (0);
}

XearthArr		*XearthArrNew(eltsize,
				      base,
				      now,
				      alloc_algorithm_proc,
				      alloc_proc,
				      realloc_proc,
				      free_proc,
				      comment,
				      status)
size_t			eltsize;
int			base;
t_boolean		now;
t_alloc_algorithm_proc	alloc_algorithm_proc;
t_alloc_proc		alloc_proc;
t_realloc_proc		realloc_proc;
t_free_proc		free_proc;
char			*comment;
t_status		*status;
{
  XearthArr		*arr;

  if ((arr = alloc_proc(sizeof (XearthArr),
			comment,
			"arr_new:arr",
			status)) == NULL)
    return (NULL);
  arr->eltsize = eltsize;
  arr->base = base;
  arr->elts = NULL;
  arr->count = 0;
  arr->allocated = 0;
  arr->alloc_algorithm_proc = alloc_algorithm_proc;
  arr->alloc_proc = alloc_proc; 
  arr->realloc_proc = realloc_proc;
  arr->free_proc = free_proc;
  arr->comment = comment;
  if (now)
    if (((*status) = XearthArrAlloc(arr,base)) < 0)
      {
	arr->free_proc(arr,
		       comment,
		       "arr_new:arr");
	return (NULL);
      }
  return (arr);
}

VOID_FUNC		XearthArrDestroy(arr)
XearthArr		*arr;
{
  if (arr->elts)
    arr->free_proc(arr->elts,
		   arr->comment,
		   "*:elts");
  arr->elts = NULL;
  arr->count = 0;
  arr->allocated = 0;
}

VOID_FUNC		XearthArrDelete(arr)
XearthArr		*arr;
{
  XearthArrDestroy(arr);
  arr->free_proc(arr,
		 arr->comment,
		 "*:arr");
}

VOID_PTR		XearthArrNext(arr,status)
XearthArr		*arr;
t_status		*status;
{
  VOID_PTR		ptr;

  if (arr->allocated < (arr->count + 1))
    if (((*status) = XearthArrAlloc(arr,arr->count + 1)) < 0)
      return (NULL);
  ptr = ((char *)arr->elts) + arr->count * arr->eltsize;
  arr->count++;
  return (ptr);
}

VOID_FUNC		XearthArrRm(arr,idx)
XearthArr		*arr;
int			idx;
{
  bcopy((char *)(arr->elts + idx + 1),
	(char *)(arr->elts + idx),
	(arr->count - idx - 1) * arr->eltsize);
  arr->count--;
}

#ifdef DEBUG
VOID_FUNC		XearthArrShow(arr)
XearthArr		*arr;
{
  fprintf(stderr,"eltsize=%d\n",arr->eltsize);
  fprintf(stderr,"base=%d\n",arr->base);
  fprintf(stderr,"count=%d\n",arr->count);
  fprintf(stderr,"allocated=%d\n",arr->allocated);
  fprintf(stderr,"elts=%p\n",arr->elts);
}
#endif
