/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef XEARTHI_H
#define XEARTHI_H	1

#include "config.h"

#ifdef WITH_MG_KLUDGE
# undef HAVE_BITFIELDS
# define HAVE_STDARG_H
#endif

#ifdef HAVE_VOID_FUNC
# define VOID_FUNC	void
#else
# define VOID_FUNC	int
#endif

#ifdef HAVE_VOID_PTR
# define VOID_PTR	void*
#else
# define VOID_PTR	char*
#endif

#ifdef HAVE_VOID_DECL
# define VOID_DECL	void
#else
# define VOID_DECL
#endif

#ifndef HAVE_BZERO
# define bzero(Ptr,Size)	memset((Ptr),0,(Size))
#endif

#ifndef HAVE_BCOPY
# define bcopy(Src,Dst,Size)	memcpy((Dst),(Src),(Size))
#endif

#ifdef NO_PROTOTYPE
# define P(proto) ()
#else
# ifdef HAVE_PROTOTYPES
#  define P(proto) proto
# else
#  define P(proto) ()
# endif
#endif

#ifdef HAVE_ANSI_CPP
# define QUOTE(expr)	#expr
#else
# define QUOTE(expr)	""
#endif

#ifndef NULL
# define NULL	((VOID_PTR)0)
#endif

#ifndef TRUE
# define TRUE	(1==1)
#endif
#ifndef FALSE
# define FALSE	(1==0)
#endif

/*
 * types
 */

#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>

#endif

typedef int		t_status;
typedef int		t_boolean;
typedef unsigned long	t_off;

typedef int		t_32;
typedef signed int	t_s32;
typedef unsigned int	t_u32;
typedef short		t_16;
typedef signed short	t_s16;
typedef unsigned short	t_u16;
typedef char		t_8;
typedef signed char	t_s8;
typedef unsigned char	t_u8;
#if defined(__osf__) && defined(__alpha)
typedef long		t_64;
typedef unsigned long	t_u64;
typedef signed long	t_s64;
#endif


#define ARRAY_COUNT(array)	(sizeof (array)/sizeof ((array)[0]))
#define OFFSET(ptype,field)	((t_off)(&(((ptype)NULL)->field)))

/*
 * stdlib
 */

#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#else
extern VOID_PTR		malloc P((size_t size));
extern VOID_PTR		realloc P((VOID_PTR ptr,size_t new_size));
extern VOID_FUNC	free P((VOID_PTR ptr));
extern int	abort P((VOID_DECL));
extern char	*getenv P((char *var));
#endif

/*
 * unistd
 */

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#else
extern char	*ttyname();
#endif

/*
 * errno
 */

#include <errno.h>

#ifdef NOTDEF
extern int	errno;
extern char	*sys_errlist[];
#endif

#ifndef HAVE_STRERROR
char		*strerror P((int errcode));
#endif

/*
 * varargs
 */

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#else
# include <varargs.h>
#endif

/*
 * BUFSIZ
 */

#include <stdio.h>

/*
 * string*.h
 */

#ifdef HAVE_STRING_H
# include <string.h>
#endif
#ifdef HAVE_STRINGS_H
# include <strings.h>
#endif

#ifndef HAVE_STRDUP
char	*strdup P((char *string));
#endif

/*
 * MAXHOSTNAMELEN
 */

#include <sys/param.h>

/*
 * assert
 */

#ifdef HAVE_ASSERT_H
# include <assert.h>
#endif

#define STR_BUFSIZ	256

typedef t_status	(*t_alloc_algorithm_proc) P((size_t old_size,
						     size_t request_size,
						     size_t *new_size));

typedef VOID_PTR	(*t_alloc_proc) P((size_t size,
					   char *comment1,
					   char *comment2,
					   t_status *status));

typedef VOID_PTR	(*t_realloc_proc) P((VOID_PTR oldptr,
					     size_t size,
					     char *comment1,
					     char *comment2,
					     t_status *status));

typedef VOID_FUNC	(*t_free_proc) P((VOID_PTR ptr,
					  char *comment1,
					  char *comment2));

#define XEARTH_ALLOC_ALGORITHM		XearthAllocAlgorithm
#define XEARTH_ALLOC_PROC		XearthAlloc
#define XEARTH_FREE_PROC		XearthFree
#define XEARTH_REALLOC_PROC		XearthRealloc

#define ARR_BASE			32

typedef struct				_XearthArr
{
  size_t				eltsize;
  int					base;
  int					count;
  int					allocated;
  VOID_PTR				*elts;
  t_alloc_algorithm_proc		alloc_algorithm_proc;
  t_alloc_proc				alloc_proc;
  t_realloc_proc			realloc_proc;
  t_free_proc				free_proc;
  char					*comment;
} XearthArr;

#define ARR_EMPTY(arr)			((arr)->count = 0)
#define ARR_COUNT(arr)			((arr)->count)

#define XEARTH_ARR_NEW(EltSize,Comment,StatusPtr)    XearthArrNew((EltSize),\
							ARR_BASE,\
							FALSE,\
						       XEARTH_ALLOC_ALGORITHM,\
							XEARTH_ALLOC_PROC,\
							XEARTH_REALLOC_PROC,\
							XEARTH_FREE_PROC,\
							    (Comment),\
							(StatusPtr))


/* PROTO XearthI.c */
/* XearthI.c */
t_status XearthAllocAlgorithm P((size_t old_size, size_t request_size, size_t *new_size));
void *XearthAlloc P((size_t size, char *comment1, char *comment2, t_status *status));
void *XearthRealloc P((void *old_ptr, size_t size, char *comment1, char *comment2, t_status *status));
void XearthFree P((void *ptr, char *comment1, char *comment2));
t_status XearthArrAlloc P((XearthArr *arr, int n));
XearthArr *XearthArrNew P((size_t eltsize, int base, t_boolean now, t_alloc_algorithm_proc alloc_algorithm_proc, t_alloc_proc alloc_proc, t_realloc_proc realloc_proc, t_free_proc free_proc, char *comment, t_status *status));
void XearthArrDestroy P((XearthArr *arr));
void XearthArrDelete P((XearthArr *arr));
void *XearthArrNext P((XearthArr *arr, t_status *status));
void XearthArrRm P((XearthArr *arr, int idx));
void XearthArrShow P((XearthArr *arr));
#endif
