

/*************************************************************************
 * Version 1.4  on  18-Nov-1996
 * (c) 1996 Pralay Kanti Dakua (pralay@teil.soft.net) 
 *     Tata Elxsi India Ltd
 *
 * This is a free software and permission to use, modify, distribute,
 * selling and using for commercial purpose is hereby granted provided
 * that the above copyright notice and this permission notice shall be
 * included in all copies and their supporting documentations.
 *
 * There is no warranty for this software. In no event Pralay Kanti Dakua
 * or Tata Elxsi India Ltd will be liable for merchantability and
 * fitness of the software and damages due to this software.
 *
 * Author:
 * Pralay Kanti Dakua (pralay@teil.soft.net)
 * Tata Elxsi India Ltd.
 *
 **************************************************************************
 *
 * Credits
 * -------
 * The keyboard translations are added by Andreas Zeller (zeller@comsoft.de).
 *
 **************************************************************************/



#ifndef __DOUBLESS_H__
#define __DOUBLESS_H__

#include <Xm/Xm.h>

#ifdef __cplusplus
extern "C" {
#endif

#define XmNlowerDragCallback "lowerDragCallback"
#define XmCLowerDragCallback "LowerDragCallback"

#define XmNupperDragCallback "upperDragCallback"
#define XmCUpperDragCallback "UpperDragCallback"

#define XmNlowerValueChangedCallback "lowerValueChangedCallback"
#define XmCLowerValueChangedCallback "LowerValueChangedCallback"

#define XmNupperValueChangedCallback "upperValueChangedCallback"
#define XmCUpperValueChangedCallback "UpperValueChangedCallback"

#define XmNlowerValue "lowerValue"
#define XmCLowerValue "LowerValue"

#define XmNupperValue "upperValue"
#define XmCUpperValue "UpperValue"

#define XmNshowValues "showValues"
#define XmCShowValues "ShowValues"

#define XmNscaleAlignment "scaleAlignment"
#define XmCScaleAlignment "ScaleAlignment"
#define XmRScaleAlignment "ScaleAlignment"

extern WidgetClass xmDoubleSliderScaleWidgetClass;

typedef struct _XmDoubleSliderScaleClassRec *XmDoubleSliderScaleWidgetClass;
typedef struct _XmDoubleSliderScaleRec *XmDoubleSliderScaleWidget;

enum {
XmCR_LOWER_VALUE_CHANGED, XmCR_UPPER_VALUE_CHANGED,
XmCR_LOWER_DRAG, XmCR_UPPER_DRAG
};

 
typedef struct {
int reason;
XEvent *event;
int value;
} XmDoubleSliderScaleCallbackStruct;


#ifdef _NO_PROTO

extern void XmDoubleSliderScaleSetUpperValue();
extern void XmDoubleSliderScaleSetLowerValue();
extern void XmDoubleSliderScaleGetUpperValue();
extern void XmDoubleSliderScaleGetLowerValue();

#else /** _NO_PROTO **/

extern void XmDoubleSliderScaleSetUpperValue(Widget, int);
extern void XmDoubleSliderScaleSetLowerValue(Widget, int);
extern void XmDoubleSliderScaleGetUpperValue(Widget, int *);
extern void XmDoubleSliderScaleGetLowerValue(Widget, int *);

#endif /** _NO_PROTO **/

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration which encloses file. */
#endif

#endif /**  __DOUBLESS_H__  **/
