/*****************************************************************************\
  $Id: KlLib.h,v 1.1.1.1 95/05/23 14:23:18 leon Exp $
*                                                                             *
* 			   KLONE OBJECT MODEL FOR C                           *
* 				 declarations                                 *
*                                                                             *
\*****************************************************************************/
/*****************************************************************************\
*                                                                             *
* Copyright (C) 1989-94 GROUPE BULL                                           *
*                                                                             *
* Permission is hereby granted, free of charge, to any person obtaining a     *
* copy of this software and associated documentation files (the "Software"),  *
* to deal in the Software without restriction, including without limitation   *
* the rights to use, copy, modify, merge, publish, distribute, sublicense,    *
* andor sell copies of the Software, and to permit persons to whom the        *
* Software is furnished to do so, subject to the following conditions:        *
*                                                                             *
* The above copyright notice and this permission notice shall be included in  *
* all copies or substantial portions of the Software.                         *
*                                                                             *
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR  *
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,    *
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL     *
* GROUPE BULL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN *
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN        *
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.  *
*                                                                             *
* Except as contained in this notice, the name of GROUPE BULL shall not be    *
* used in advertising or otherwise to promote the sale, use or other dealings *
* in this Software without prior written authorization from GROUPE BULL.      *
*                                                                             *
\*****************************************************************************/

/* Author:
 * Colas NAHABOO        Koala Project, User Interfaces, BULL Research FRANCE
 * email: colas@sophia.inria.fr
 * surface mail:
 * INRIA
 * BP 93
 * 06902 Sophia Antipolis cedex
 * FRANCE
 * Tel: (33) 93 65 77 70
 * Fax: (33) 93 65 77 65
 * WWW: http://zenon.inria.fr:8003/koala/colas.html
 */

#ifndef INCLUDE_KLONE_H
#define INCLUDE_KLONE_H
#ifndef EXT				/* EXTERN.h */
#  ifdef EXT
#    undef EXT
#  endif
#  define EXT extern
#  ifdef INIT
#    undef INIT
#  endif
#  define INIT(x)
#  ifdef DO_INIT
#    undef DO_INIT
#  endif
#endif /* EXT */

#include <stdio.h>

#include "kl_config.h"

/******************************************************************** malloc */
#ifdef SYSV
#include <stdlib.h>
#define NO_MALLOC_DECLARE		/* since already done in stdlib.h */
#endif
#ifndef USE_STANDARD_MALLOC
#define USE_STANDARD_MALLOC
#endif


#ifdef __cplusplus
extern "C" {
#endif



#define Malloc(bytes) malloc(bytes)
#define Free(bytes) free(bytes)
#define Realloc(ptr, bytes) realloc(ptr, bytes)
#define Calloc(ptr, bytes) calloc(ptr, bytes)
#define KlMalloc(bytes) malloc(bytes)
#define KlFree(bytes) free(bytes)
#define KlRealloc(ptr, bytes) realloc(ptr, bytes)
#define KlCalloc(ptr, bytes) calloc(ptr, bytes)
#ifdef USE_STANDARD_MALLOC
/* standard realloc might not like null pointers */
#undef Realloc
#undef KlRealloc
#define Realloc(ptr, bytes) ((ptr) ? realloc(ptr, bytes) : malloc(bytes))
#define KlRealloc(ptr, bytes) ((ptr) ? realloc(ptr, bytes) : malloc(bytes))
#define KlMallocBucketOfSize(s) s
#define KlMallocSizeOfBucket(s) s
#define KlMallocBucket(bytes) malloc(bytes)
#else /* !USE_STANDARD_MALLOC */
#endif /* !USE_STANDARD_MALLOC */

#ifndef NO_MALLOC_DECLARE
#  ifdef VOID_MALLOC
extern void *malloc(), *realloc(), *calloc();
#    ifdef VOID_FREE
extern void free();
#    else
extern free();
#    endif /* !VOID_FREE */
#  else /* !VOID_MALLOC */
extern char *malloc(), *realloc(), *calloc();
#  endif /* !VOID_MALLOC */
#endif /* NO_MALLOC_DECLARE */


/* generic numerical type */
#ifdef PTR_TYPE
typedef PTR_TYPE Int;
typedef unsigned PTR_TYPE UInt;
#else					/* PTR_TYPE */
typedef long Int;
typedef unsigned long UInt;
#endif /* PTR_TYPE */

#ifdef CARD32
typedef CARD32 Card32;
#else					/* CARD32 */
typedef unsigned long Card32;
#endif					/* CARD32 */

/* END OF INSTALLATION PARAMETERS */

EXT char *KlTextExtension INIT(0);	/* default: none "" */

/******************************************************** misc useful macros */

#ifndef Max
#define KlMax(x,y)		(((x)<(y))?(y):(x))
#define KlMin(x,y)		(((x)<(y))?(x):(y))
#define KlAbs(x)			(((x)>0)?(x):-(x))
#define FlagOn(mask,flag) ((mask)&(flag))
#endif
/********************************************************************* types */

/* the KlO type:
 * Each object handled by KLONE is a pointer to a structure including at least:
 *  - a pointer to a list of methods, common to all objects of this type.
 *  - a reference count, integer telling how many objects points to this
 *    one. The object should be freed as soon as this counter goes down to
 *    zero. (first bit is to see if it is not in the KlZrt, rest is for count)
 * hack: first slots in the list of methods are reserved for some type info
 * such as name of type, inheritance, etc... this hack is for efficiency...
 */

#ifndef DEBUG
#define KlKLONE_HEADER \
	struct _KlO *(**type)(); \
	unsigned int reference_count
#else					/* DEBUG */
#define KlKLONE_HEADER \
	struct _KlO *(**type)(); \
	int reference_count
#endif					/* DEBUG */

typedef struct _KlO {
    KlKLONE_HEADER;
}   *KlO;

void KlZrtPut(KlO obj);
#define KLSO sizeof(KlO)

typedef KlO(*KlMethod) ();

typedef KlMethod *KlType;

#define KlOZero(o, s) bzero(((char *) (o)) + KLSO, (s) - KLSO)

/************************************************************* the type type */
EXT KlType KlAnyType;
EXT KlType KlTypeType;

#define KlIsAType(o) (((KlO) o)->type == KlTypeType)
#define KlMustBeType(o, n) KlArgumentMustBe(((KlO) o), n, KlTypeType)

#define KlDeclareMethod1(type, selector, method) type[selector] = method
#define KlDeclareMethodUndefined(type, selector) \
    KlDeclareMethod(type, selector, KlSelectorUndefmethod(selector))
#define KlUndefinedMethod(selector) KlSelectorUndefmethod(selector)
#define KlIsUndefinedMethod(obj, selector) \
    ((obj)->type[selector] == KlSelectorUndefmethod(selector))
#define KlClassMethod(type, selector) type[selector]

/* definition of first "methods": first fields in a klone type are:
 * type		KlTypeType
 * refcount	integer
 * name    	klone atom
 * next		linked list pointer to next type. KlTypes = llist of all types
 * traits 	class of types to which this type belongs
 * trait	is this type defining a trait, and which one?
 * father 	allows to have a simple hierarchy
 * ID 		(0..N) ordering number of the type for tables such as coerce
 * TypeMethods	used to store Klone methods dispatched by generic functions
 * mhooks       0 or pointer to a backup of the whole type itself, allowing
 *              the system to replace a method by a hook-caller
 * mcalls       0 or pointer to an array of Klone functions to be applied
 *              by the hook caller
 * --- to add?
 * bucket       optimization: bucket number to malloc with
 */

#define KlTypeSlotGet(type, n) ((int) type[n])
#define KlTypeSlotSet(type, n, val) type[n] = ((KlMethod) (val))

#define KlTypeTypeGet(type) ((KlType) type[0])	/* type */
#define KlTypeTypeSet(type,name) type[0] = (KlMethod)(name)
#define KlTypeRefGet(type) ((UInt) type[1])	/* refcount */
#define KlTypeRefSet(type,name) type[1] = (KlMethod)(name)
#define KlTypeNameGet(type) ((char *) type[2])	/* name as an KlAtom */
#define KlTypeNameSet(type,name) type[2] = (KlMethod)(name)
#define KlTypeNextGet(type) ((KlType) type[3])	/* linked list of types */
#define KlTypeNextSet(type,name) type[3] = (KlMethod)(name)
#define KlTypeTraitsGet(type) ((Card32) type[4]) /* traits */
#define KlTypeTraitsReset(type) type[4] = 0
#define KlTypeTraitsSet(type, v) type[4] = (KlMethod)(v)
#define KlTypeTraitGet(type) ((Card32) type[5])	/* trait this type defines */
#define KlTypeTraitReset(type) type[5] = 0
#define KlTypeTraitSet(type, v) type[5] = (KlMethod)(v)
#define KlTypeFatherGet(type) ((KlType) type[6]) /* supertype */
#define KlTypeFatherSet(type, f) type[6] = (KlMethod)(f)
#define KlTypeNumGet(type) ((int) type[7]) /* type number, for coerces */
#define KlTypeNumSet(type, ht) type[7] = (KlMethod)(ht)
#define KlTypeMHooksGet(type) ((KlType) ((type)[8]))	/* for *:mhook */
#define KlTypeMHooksSet(type, h) (type)[8] = (KlMethod)(h)
#define KlTypeMCallsGet(type) ((KlType) ((type)[9])) /* for *:mhook */
#define KlTypeMCallsSet(type, h) (type)[9] = (KlMethod)(h)
#define KlTypeSizeGet(type) ((KlType) ((type)[10])) /* for KlOMake */
#define KlTypeSizeSet(type, h) (type)[10] = (KlMethod)(h)

/* number of non-method slots. Must be last slot index + 2 */
#define KlTypeStaticReservedSlots 12

EXT int KlSelEval INIT(KlTypeStaticReservedSlots-1); /* must be here */

EXT int KlTypeReservedSlots INIT(KlTypeStaticReservedSlots);

#define KlTypeCName(type) ((type)[2])	/* name as an KlAtom */

EXT KlType KlTypes INIT(0);
EXT int KlTypeNumCurrent INIT(0);
EXT KlMethod **KlCoerceTable;
EXT int *KlCoerceTableSizes;


					/* some backcompats */
#define KlTypeRef(type) KlTypeRefGet(type)
#define KlTypeName(type) KlTypeNameGet(type)
#define KlTypeNext(type) KlTypeNextGet(type)
#define KlTypeTraits(type) KlTypeTraitsGet(type)
#define KlTypeTrait(type) KlTypeTraitGet(type)

#define KlDeclareType(typep, name, size) \
    KlDeclareSubType(typep, name, 0, size)
#define KlDeclarePseudoType(typep, name) KlDeclareType(typep, name, 0)

EXT KlO KlOMakeTemp;
#define KlOMake(kltype) \
    (KlOMakeTemp = (KlO) KlMallocBucket(KlTypeSizeGet(kltype)), \
     KlZrtPut(KlOMakeTemp), KlOMakeTemp->type = kltype, KlOMakeTemp)

#define KlOMakeZero(kltype) \
    (KlOMakeTemp = (KlO) KlMallocBucket(KlTypeSizeGet(kltype)), \
     bzero(((char *) KlOMakeTemp) + sizeof(struct _KlO), \
	   KlMallocSizeOfBucket(KlTypeSizeGet(kltype)) - sizeof(struct _KlO));\
     KlZrtPut(KlOMakeTemp), KlOMakeTemp->type = kltype, KlOMakeTemp)

#define KlOMakeOfSize(kltype, size) \
    (KlOMakeTemp = (KlO) Malloc(size), \
     KlZrtPut(KlOMakeTemp), KlOMakeTemp->type = kltype, KlOMakeTemp)

#define KlOMakeOfSizeZero(kltype, size) \
    (KlOMakeTemp = (KlO) Calloc(size, 1), \
     KlZrtPut(KlOMakeTemp), KlOMakeTemp->type = kltype, KlOMakeTemp)


/***************************************************************** SELECTORS */

/* Properties of each individual selector */
EXT struct _KlSelector {
    char *name;				/* external printable name */
    int arity;				/* actual arity, 0 = NARY */
}          *KlSelectors INIT(0);

EXT int KlSelectorsSize INIT(KlTypeStaticReservedSlots);

/* Properties per selector arity 0=NARY */
EXT struct _KlSelectorProps {
    KlMethod undefmethod;		/* default method */
    KlMethod hooker;			/* calls the Klone hook */
    KlMethod bypass_once;		/* used to bypass the hooker once */
}          *KlSelectorsProps INIT(0);

EXT int KlSelectorsPropsSize;

#define KlSelectorArity(sel) KlSelectors[sel].arity
#define KlSelectorName(sel) KlSelectors[sel].name
#define KlSelectorUndefmethod(sel) \
    KlSelectorsProps[KlSelectors[sel].arity].undefmethod
#define KlSelectorHooker(sel) \
    KlSelectorsProps[KlSelectors[sel].arity].hooker
#define KlCurrentHookerCall(obj) \
     ((KlO) KlTypeSlotGet(KlTypeMCallsGet((obj)->type), KlCurrentMessage))
#define KlCurrentHookerBackup(obj) \
     ((KlMethod) KlTypeSlotGet(KlTypeMHooksGet((obj)->type), KlCurrentMessage))
#define KlUnHookedMethod(type, sel) \
    ((KlMethod) (KlTypeMHooksGet(type) \
		 ? KlTypeSlotGet(KlTypeMHooksGet(type), sel) \
		 : KlTypeSlotGet(type, sel)))

/* predefined selectors.  KlSelEval is defined before */
/* NOTE: if you add a built-in selector foo, you must
 - add a symbol KlSelFoo here
 - add a macro KlSend_foo underneath
 - in klone.c: in KlInitPredefinedSelectors, add definition
 */
EXT int KlSelFree;
EXT int KlSelEqual;
EXT int KlSelMake;
EXT int KlSelCopy;

/********************************************************************* SENDS */

/* the send define:
 * called by KlSend(KLONE_MethodName,
 *		       object,
 *		       (object, parm1, parm2, ... )); NEED parenthesises !!!
 */

/* WARNING: DO NOT CALL A SEND INTO ANOTHER SEND!!!
 * use temporary variable to hold the result
 * See KlSend_setq_protect convenient macro for exemple
 */

#ifndef DEBUG
#  define KlSend(message,object,parms) \
    (*(((object)->type)[KlCurrentMessage = message]))parms
#  define KlSendNary(message,argc,argv) \
    CFAPPLY((((argv[0])->type)[KlCurrentMessage = message]), (argc, argv))
#  define KlSendType(message,t,parms)  \
    (*((t)[KlCurrentMessage = message]))parms
#else					/* DEBUG */
#  define KlSend(message,object,parms) \
    (KlCurSend++,KlSendIsValid(message,object), KlCurrentMessage = message, \
	(KlO) (*(((object)->type)[message]))parms)
#  define KlSendType(message,t,parms)  \
    (KlCurSend++,KlCurrentMessage = message, (*((t)[message]))parms)
#  define KlSendNary(message,argc,argv) \
    (KlCurSend++,KlSendIsValid(message,argv[0]), KlCurrentMessage = message, \
    (KlO) CFAPPLY((((argv[0])->type)[message]), (argc, argv)))
#endif /* DEBUG */

/********************************************** some predefined method sends */

#define KlSend_free(o) KlSend(KlSelFree, o, (o))
#define KlSend_equal(o, p) KlSend(KlSelEqual, o, (o, p))
#define KlSend_copy(o) KlSend(KlSelCopy, o, (o))
#define KlSend_make(o) KlSend(KlSelMake, o, (o))

/* traits. Do not forget to update the KlDeclareBuiltInTraits func in klone.c*/

EXT char **KlTraitNames;

#define KlTrait_list (1 << 7)

EXT int KlLastTrait INIT(1);

#define KlHasTrait(obj, trait) (KlTypeTraits((obj)->type) & (trait))
#define KlArgumentMustHaveTrait(obj, pos, trait) \
    if(!KlHasTrait(obj, trait)) KlBadArgument(obj, pos, KlTraitName(trait))

#ifdef SIMPLE_LHS
#define KlDeclareTrait(type,trait) \
    type[4] = (KlMethod) (((Card32) type[4]) | trait)
#define KlDeclareIsTrait(type,trait) \
    type[5] = (KlMethod) (((Card32) type[5]) | trait); \
    KlDeclareTrait(type,trait)
#else
#define KlDeclareTrait(type,trait) ((Card32) type[4]) |= trait
#define KlDeclareIsTrait(type,trait) ((Card32) type[5]) |= trait; \
    KlDeclareTrait(type,trait)
#endif

#define KlIsOfType(o, t) \
    (KlTypeTrait(t) ? KlHasTrait(o, KlTypeTrait(t)) : \
     ((o)->type == t ? 1 : KlTypeIsSonOf((o)->type, t)))
#define KlArgumentValue(o, n, t) \
    ((KlTypeTrait(t) ? KlHasTrait(o, KlTypeTrait(t)) : (o)->type == t) \
     ? o : KlBadArgument(o, n, KlTypeCName(t)), o)

#define KlArgumentMustBe(obj, pos, t) \
    if((obj)->type != (t)) KlBadArgument((obj), (pos), KlTypeCName(t))

#define KlArgumentMustBeOrNil(obj, pos, t) \
    if(obj->type != t && KlTrueP(obj)) \
    KlBadArgument(obj, pos, KlTypeCName(t))

#define KlMustBeOrEval(variable, value, kltype, predicate, error) \
    variable = (kltype) value;\
    if(!predicate) { \
	variable = (kltype) KlSend_eval(variable); \
	if (!predicate) { \
	     error;}}

EXT KlO KlConvertArgTo_obj;
#define KlConvertArgTo(o, n, t) (KlIsOfType(o, t) ? ((KlO) (o)) : \
    ((KlConvertArgTo_obj = KlCoerceOrNil(o, t)) ? \
     KlConvertArgTo_obj : KlBadArgument(o, n, KlTypeCName(t))))

#define KlBadNumberOfArguments(i) \
    KlError1i(KlE_BAD_NUMBER_OF_ARGS, (i))
#define KlNumberOfArgumentsCheck(e, i) \
    if (e) {return KlError1i(KlE_BAD_NUMBER_OF_ARGS, (i));}

/* the undefined methods (aborts!), one per arity */

extern KlO KlUndefinedMethodNary();
extern KlO KlUndefinedMethod1();
extern KlO KlUndefinedMethod2();
extern KlO KlUndefinedMethod3();
extern KlO KlUndefinedMethod4();
extern KlO KlUndefinedMethod5();

#ifdef DEBUG_CFAPPLY
#define CFAPPLY(f, args) (f ? ((*(f)) args) : (CFAPPLY_ERROR(), (*(f)) args))
#else /* !DEBUG_CFAPPLY */
#define CFAPPLY(f, args) ((*(f)) args)
#endif /* !DEBUG_CFAPPLY */

#ifdef DEBUG
#if __STDC__
#define ANSI_STRING_MACRO_EXPANSION
#endif /* __STDC__ */

#  ifdef ANSI_STRING_MACRO_EXPANSION
#    define	ASSERT(p) \
      if (!(p)) {fprintf(stderr, "\nAssertion failed: %s\n", #p); \
		 stop_if_in_dbx("ASSERT FAILED");}		
#    define KlSTROF(p) #p
#  else					/* ANSI_STRING_MACRO_EXPANSION */
#    define	ASSERT(p) \
      if (!(p)) {fprintf(stderr, "\nAssertion failed: %s\n", "p"); \
		 stop_if_in_dbx("ASSERT FAILED");}		
#    define KlSTROF(p) "p"
#  endif				/* ANSI_STRING_MACRO_EXPANSION */
#else /* !DEBUG */
#  define	ASSERT(p)
#endif /* !DEBUG */

/********************************************************* global variabless */

/* first include standards file if missing */

#ifndef NULL
#define NULL 0
#endif					/* NULL */

/* to access easily any object's reference count */

#define KlRef(obj) (((KlO) (obj))->reference_count)
/************************************************************************ GC */

#define KlResetRef(obj) if (KlRef(obj) & 1) KlRef(obj)=0; else KlZrtPut(obj)

#ifndef DEBUGREF
#define KlIncRef(obj) KlRef(obj) += 2
#define KlDecRef(obj) {if(obj && (KlRef(obj)-=2)==1)KlZrtPut((KlO)obj);}
#define KlDecRefNonNull(obj) {if((KlRef(obj)-=2)==1)KlZrtPut(obj);}
#endif					/* DEBUG2 */

#define KlAppendToArray(array, i, obj) \
    array = (KlO *) Realloc(array, (i+2) * sizeof(KlO)); \
    KlIncRef(array[i++] = (KlO) obj); \
    array[i] = 0

/*********************************************************************** ZRT */
/* ZRT= Zero Reference Table, objects that will be scanned for deletion */
EXT KlO *KlZrt;				/* start of Garbaged objects stack */
EXT KlO *KlZrtLast;			/* current end (+ 1) */
EXT KlO *KlZrtFrom;			/* current start during current GC */
EXT KlO *KlZrtLimit;			/* malloced space */
EXT Int KlZrtSizeLimit;			/* same for efficiency */

#define KlDftGc()			/* obsolete, for backwards compat */

#define KlGCMark() Int KlZrtLocalMarker = KlZrtLast - KlZrt
#define KlGCDecls Int KlZrtLocalMarker
#define KlGCSet() KlZrtLocalMarker = KlZrtLast - KlZrt
#define KlGC() KlZrtGc(KlZrtLocalMarker)
#define KlGCFull() KlZrtGc(0);

#define KlZrtSize (KlZrtLast - KlZrt)   /* for backwards compat */

/******************************************************** exported functions */

extern KlO KlEq();
extern KlO KlQuote();
extern KlO KlKlOFree();
extern KlO KlBadArgument();

/********************************************************** exported objects */

EXT KlO KlTempObj;

EXT KlO NIL;				/* NIL is just a predefined nil list */
EXT KlO TRU;				/* TRU is just a predefined non-nil list */

#ifndef NULL
#define NULL 0
#endif					/* NULL */

#define NARY	-1

EXT int KlCurrentMessage;
#ifdef DEBUG
EXT int KlCurSend INIT(0);		/* send counter for debug */

#else /* DEBUG */
#define stop_if_in_dbx(why)
#endif					/* DEBUG */

#define KlUndefinedPos	-1

/* logical values */
#define KlFalseP(o) (!((KlList)(o))->size && KlIsAList((o)))
#define KlTrueP(o) (((KlList)(o))->size || (!KlIsAList((o))))

/********************************************************* C-klone interface */

#define KlDefaultTo(var, value) if (!var) var=(value)

/***************************************************** debugging-only traces */

#define KLTRACE printf
#ifdef DEBUG
EXT char *KlTraceFlags INIT("");

#define KlTrace(flag, args) if(strchr(KlTraceFlags, flag)) printf args
#else					/* DEBUG */
#define KlTrace(flag, args)
#endif					/* DEBUG */

/*****************************************************************************\
* 				    Lists                                     *
\*****************************************************************************/
/* type */

typedef struct _KlList {
    KlKLONE_HEADER;
    int size;				/* size of list  ( # of elements ) */
    KlO *list;				/* malloced region to store elements */
}      *KlList;				/* so that lists are expandable now */

EXT KlType KlListType;

#define KlIsAList(obj) KlHasTrait(obj, KlTrait_list)
#define KlMustBeList(obj, n) KlArgumentMustHaveTrait(obj, n, KlTrait_list)

EXT KlList KlListNMake();

/********************************************************** Extension system */

typedef struct _KlExtension {
    char *name;				/* name of extension */
    int (*selectors)();			/* init of selectors */
    int (*types)();			/* init of types */
    int (*profile)();			/* klone level inits */
} *KlExtension;
EXT KlExtension KlExtensions INIT(0);	/* list of asked for extensions */
EXT int KlExtensionsSize INIT(0);

/********************************************************* Klone C functions */

EXT KlO KlListDeleteC();


#ifdef __cplusplus
} /* Close scope of 'extern "C"' */
#endif

#endif /* !INCLUDE_KLONE_H */
