/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: Knvas.h,v 1.6 95/07/28 15:22:23 leon Exp $ */
#ifndef __KNVAS_H
#define __KNVAS_H


#include <Kn/init.h>
#include <Kn/libkn.h>


#ifdef __cplusplus
extern "C" {
#endif



/****************************************************************
 *
 * Knvas widget public header
 *
 ****************************************************************/

typedef struct _KnvasClassRec*	KnvasWidgetClass;
typedef struct _KnvasRec*	KnvasWidget;


/* error messages */
#define badResourceValue "badResourceValue"
#define badExtension "badExtension"
#define sanityChecks     "sanityChecks"
#define KnvasWarning "KnvasWarning"
#define invalidParameterCount "invalidParameterCount"
#define invalidParameterValue "invalidParameterValue"
#define actionParameters "actionParameters"

#define XtNinteractorCallback "interactorCallback"
#define XtNknvasCallback "knvasCallback"
#define XtNpixmapBuffering "pixmapBuffering"
#define XtCPixmapBuffering "PixmapBuffering"
#define XtNautoUpdate "autoUpdate"
#define XtCAutoUpdate "AutoUpdate"



extern WidgetClass knvasWidgetClass;





/* Creates a new Knvas widget
   
 * Creates a new Knvas widget whose parent is given as parameter. This function
 * have the signature of any Motif widget's creation convenience function. It
 * simply makes a call to XtCreateWidget passing the given parameters. It does
 * not set or modify any specific resource. The returned widget is unmanaged:
 * you have to call XtManageChild, to make it appear.

 * USE: application programming
 
 returns: The newly created widget */
Widget
KnCreateKnvas(Widget parent,	/* The parent in the widget hierachy */
	     char *name,	/* widget's name */
	     Arg *args,		/* Overriding resources */
	     Cardinal numargs	/* number of resources */
    );



/* description: register a newly created tag.

 * Add the given tag in the widget's tags list. If the widget is realized, call
 * the KnTagRealize function.

 * USE: internal
 
 * returns: the tag itself */
KnTag
KnvasRegisterTag(Widget w,	/* the knvas widget */
		  KnTag tag	/* the tag to register */
    );



/* description: register a newly created interactor.

 * Add the given interactor in the widget's interactors list. If the widget is realized, call
 * the KnInteractorRealize function.

 * USE: internal
 
 * returns: the interactor itself */
KnInteractor
KnvasRegisterInteractor(Widget w,	/* the knvas widget */
		  KnInteractor interactor	/* the interactor to register */
    );


/* Clear a knvas area
   
 * Computes the closest bounding box containing the given points, and clears
 * this region in the knvas window.  This function does not generate expose
 * events.

 * USE: internal

 returns: */
void
KnvasClearArea(Widget,		/* the knvas widget */
		XPoint *points,	/* points defining a link */
		Cardinal n,	/* number of points */
	       XRectangle *extra /* extra area to clear */
    );



/* Updates the knvas graphical appearance
   
 * This function first clear and remove objects that have been destroy from the
 * knvas. Then it clears the modified region of the knvas window and then the
 * call the knvas's redraw engine on that region. This function should be
 * called in any used defined interaction function to update the Knvas's
 * graphical appearance.

 * USE: application programming
 
 * returns: */
void
KnvasUpdateDisplay(Widget w);	/* the knvas widget */


/* Updates the knvas's layers appearance
   
 * For each layer of the knvas, this function calls the KnvasUpdateDisplay
 * function for each view (i.e knvas) showing the layer, so that the graphical
 * appearance will be preserved and updated in any view. It might be used
 * alternatively to KnvasUpdateDisplay, even if there is no shared view.

 * USE: application programming
 
 * returns: */
void
KnvasUpdateLayers(Widget w);	/* the knvas widget */



/* Get the knvas default Tag
   
 * As the knvas widget is an opaque type, we provide this function to access
 * the defaultTag private field (the tag whose tag id is 0). This function
 * simply returns the default tag contained in the Knvas. There is no side
 * effect.

 * USE: application programming
 
 * returns: the knvas's default tag */
KnTag
KnvasGetDefaultTag(Widget w);	/* the knvas widget */


/* Set the knvas default Tag
   
 * As the knvas widget is an opaque type, we provide this function to modify
 * the defaultTag private field (the tag whose tag id is 0). Setting the
 * default tag for a Knvas has no side effect. In particuliar it does not
 * change the graphical attributes for objects which were build with the
 * default tag. But objects created after this modification will receive the
 * given tag.

 * USE: application programming
 
 * returns:  */
void
KnvasSetDefaultTag(Widget w,	/* the knvas widget */
		    KnTag tag);	/* the new default tag */





/* get the knvas's transformer
 * 
 * As the knvas widget is an opaque type, we provide this function to access
 * the transformer private field. 

 * USE: class writing
 
 * returns: the knvas's transformer, or NULL */
Transformer
KnvasGetTransformer(Widget w);	/* a knvas widget */




/* Zoom In or Out the whole knvas view
   
 * Apply the sx, sy scale factors on the knvas's transformer, that will
 * produce a global zoom / unzoom effect for the whole view. This will modify
 * only the given widget; other views (if they exist) are unchanged. The whole
 * knvas is cleared and redrawn.

 * USE: application programming
 
 * returns: */
void
KnvasZoom(Widget w,		/* the knvas widget that we want to Zoom */
	   float sx,		/* horizontal scale factor */
	   float sy);		/* vertical scale factor */



/* Merge a global behavior in a knvas widget

 * This functions allows to define globals behaviors on the knvas (i.e htey
 * will be available for every knvas's object. the function override the old
 * knvas's behavior with the intercator's behavior (using XtMergeTranslations).

 * USE: application programming

 * returns: */
void
KnvasAddInteractor(Widget w,	/* the knvas widget */
		   KnInteractor intr); /* the interactor to add */






/* Add a layer in a knvas widget
   
 * This function both add the layer in the given knvas and register the widget
 *  as parent of the layer. This allow to share layers between many knvases,
 *  just by calling this function. The layer object must exist, so it already
 *  has (at least) one parent.

 * USE: application programming
 
 * returns: */
void
KnvasShareLayer(Widget w,	/* a knvas widget */
		KnLayer layer); /* the layer to share */




KnLayer
KnvasGetDefaultLayer(Widget w);




/* Get the current selection

 * This function returns the list of the currently selected objects in the
 * Knvas.

 * returns: a KlList containing the selected objects. */
KlList
KnvasGetSelection(Widget w);	/* a knvas widget */



#ifdef __cplusplus
} /* Close scope of 'extern "C"' */
#endif


#endif /* __KNVAS_H */
