/* Copyright (c) 1995 by Groupe Bull.  All Rights Reserved */
/* $Id: TagP.h,v 1.4 95/09/25 14:56:30 leon Exp $ */

/***
   NAME
     TagP
   PURPOSE
     
   NOTES
     
   HISTORY
     jml - Feb 6, 1995: Created.
***/

#ifndef __TAGP_H
#define __TAGP_H

#include <X11/IntrinsicP.h>
#include <X11/xpm.h>
#include <Kn/Tag.h>
#include <Kn/region.h>

#ifdef __cplusplus
extern "C" {
#endif

/* set default to 3D LOOK */
#ifndef NO_RELIEF
#define LOOK3D
#endif

typedef struct _SymColorsRec {
    XpmColorSymbol *colors;
    unsigned int n;
} SymColorsRec, *SymColors;


typedef struct _TagClassPart {
    int empty;
} TagClassPart;


typedef struct _TagPart {
    /* public fields (resources) */
    Pixel foreground;
    Pixel background;
    int line_width;
    int line_style;
    int cap_style;
    int join_style;
    XFontStruct *font;
    SymColors sym;
    Boolean visibleAnchors;
    SelectionLook selectionLook;
#ifdef LOOK3D
    unsigned char shadowType;
    KnDimension shadowThickness;
#endif /* LOOK3D */


    /* private fields */
    Widget knvas;
    GC gc;
#ifdef LOOK3D
    GC top_shadow_gc;
    GC bottom_shadow_gc;
#endif /* LOOK3D */
    Boolean clipped;
    KnRegion region;
    KnTagId id;
} TagPart;


typedef struct _TagClassRec {
    ObjectClassPart object_class;
    TagClassPart tag_class;
} TagClassRec;

typedef struct _TagRec {
    ObjectPart object;
    TagPart tag;
} TagRec;


extern TagClassRec tagClassRec;

#ifdef __cplusplus
} /* Close scope of 'extern "C"' declaration which encloses file. */
#endif

#endif /* __TAGP_H */
