/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: draw.c,v 1.6 95/09/28 11:58:21 leon Exp $ */
/* Author: Jean-Michel.Leon@sophia.inria.fr */



#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include "misc.h"
#include "interactor.h"
#include "knoP.h"



char 
drawBehavior[] = "\
 <Btn3Down>: KnvasDrawStart()\n\
 <Btn3Motion>: KnvasDrawDrag()\n\
 <Btn3Up>: KnvasDrawDrop()\n\
";

char 
genericDrawBehavior[] = "\
 <Btn%dDown>: KnvasDrawStart()\n\
 <Btn%dMotion>: KnvasDrawDrag()\n\
 <Btn%dUp>: KnvasDrawDrop()\n\
";



static void
DrawGhost(Widget w)
{
    KnvasWidget cw = (KnvasWidget) w;
#define THIS cw->knvas
    XDrawLine(XtDisplay(w), XtWindow(w), THIS.ghostgc,
	      THIS.firstx, THIS.firsty,
	      THIS.lastx, THIS.lasty);
#undef THIS
}


void
KnvasDrawStartProc(Widget w, XEvent *event, String *params, Cardinal *num)
{
    InteractorCallbackStruct cs;
    KnvasWidget cw = (KnvasWidget) w;
#define THIS cw->knvas
    cs.tox = event->xbutton.x;
    cs.toy = event->xbutton.y;
    if(THIS.t) {
	TransformerInvTransform(THIS.t, event->xbutton.x, 
				event->xbutton.y, &cs.tox, &cs.toy);
    }
    cs.e = event;
    cs.target = THIS.target;
    cs.accept = True;
    cs.reason = KnCR_PICK;

    XtCallCallbacks(w, XtNknvasCallback, &cs);

    THIS.firstx = THIS.lastx = event->xbutton.x;
    THIS.firsty = THIS.lasty = event->xbutton.y;
    KnvasUpdateLayers(w);
    DrawGhost(w);
#undef THIS
}


void
KnvasDrawDragProc(Widget w, XEvent *event, String *params, Cardinal *num)
{
    InteractorCallbackStruct cs;
    KnvasWidget cw = (KnvasWidget) w;
#define THIS cw->knvas
    DrawGhost(w);
    THIS.lastx = event->xbutton.x;
    THIS.lasty = event->xbutton.y;
    /* HERE, we could add callbacks, because, previous ghost is cleared, and
       next is not yet drawn */
    DrawGhost(w);
    KnvasUpdateLayers(w);
#undef THIS
}



void
KnvasDrawDropProc(Widget w, XEvent *event, String *params, Cardinal *num)
{
    InteractorCallbackStruct cs;
    KnvasWidget cw = (KnvasWidget) w;
#define THIS cw->knvas
    cs.tox = event->xbutton.x;
    cs.toy = event->xbutton.y;
    if(THIS.t) {
	TransformerInvTransform(THIS.t, event->xbutton.x, 
				event->xbutton.y, &cs.tox, &cs.toy);
    }
    cs.e = event;
    cs.target = THIS.target;
    cs.accept = True;
    cs.reason = KnCR_DROP;
    DrawGhost(w);

    XtCallCallbacks(w, XtNknvasCallback, &cs);

    KnvasUpdateLayers(w);
#undef THIS
}



KnInteractor
KnCreateDrawInteractor(Widget knvas, unsigned button)
{
    char translations[1024];
    sprintf(translations, genericDrawBehavior,
	    button,
	    button,
	    button);
    return KnCreateInteractor(knvas, translations);
}
