/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: layer.h,v 1.6 95/03/24 15:33:39 leon Exp $ */
#ifndef __KN_LAYER_H
#define __KN_LAYER_H

#include <Kn/group.h>



#ifdef __cplusplus
extern "C" {
#endif


extern void KnLayerImport();
extern void KnLayerClassInitialize();

#define KnLayerPart\
    KnGroupPart;\
    KlList parents




typedef struct KnLayerStruct {
    KnLayerPart;
} *KnLayer;


/* The Layer Class
   
 * INHERITS: KnGroup
 
 * OVERRIDES:
- KnSelClearBox
- KnSelBoundingBox

 
 * FIELDS: new fields defined in the KnRect class are:
-    KlList parents: parents list

 * DESCRIPTION

 * The KnLayer class is intended to be at the top of the objects hierachy. It
 * is the unique object that can (and must) be build without parent (giving
 * NULL). A KnLayer is intended to be child of a knvas; it is a kind of view
 * object, that may be shared between knvases using the KnvasShareLayer
 * function.

 * USE: class writing
 */
extern KlType KnLayerClass;

/* Builds a new KnLayer object
   
 * This is the KnLayer class constructor. It builds a new layer whose parent is
 * the given knvas. A knvas may have multiple layers. A layer can be shared
 * by multiple knvases.

 * USE: application programming
 
 * returns: The newly created Layer
 */
KnO
KnCreateLayer(Widget knvas);	/* layer's parent */



/* KnLayer Initializer
   
 * This funcions builds the KnLayer specific fields, then it calls the KnGroup
 * Initializer. It registers the new layer to its parent, calling
 * KnvasShareLayer.
 
 * USE: class writing
 */
void
KnLayerInit(KnLayer layer,	/* the layer object */
	    Widget knvas);	/* a knvas widget */







#ifdef __cplusplus
} /* Close scope of 'extern "C"' */
#endif



#endif /* __KN_LAYER_H */
