/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: libkn.c,v 1.10.2.3 96/03/27 16:30:40 leon Exp $ */



#include "misc.h"
#include "transformer.h"
#include "kno.h"
#include "TagP.h"
#include "KnvasP.h"



/*
 *
 * encapsulate methods for graphical objects
 *
 */

void
KnMove(Widget w, KnO kno, KnPosition tox, KnPosition toy)
{
    KlSend_clear(kno, w);
    KlSend_move(kno, tox, toy);
    kno->flags &= ~KnCLEARED_FLAG;
    KlSend_clear(kno, w);
}



void
KnTranslate(Widget w, KnO kno, KnPosition dx, KnPosition dy)
{
    KlSend_clear(kno, w);
    KlSend_translate(kno, dx, dy);
    kno->flags &= ~KnCLEARED_FLAG;
    KlSend_clear(kno, w);
}


void
KnResize(Widget w, KnO kno, float sx, float sy)
{
    KlSend_clear(kno, w);
    KlSend_resize(kno, &sx, &sy);
    kno->flags &= ~KnCLEARED_FLAG;
    KlSend_clear(kno, w);
}


void
KnRotate(Widget w, KnO kno, int angle)
{
    KnPosition x, y;

    KlSend_center(kno, &x, &y);
    
    KlSend_clear(kno, w);
    KlSend_rotate(kno, x, y, angle);
    kno->flags &= ~KnCLEARED_FLAG;
    KlSend_clear(kno, w);
}





void
KnSelect(Widget w, KnO kno, Boolean visible)
{
    kno->flags |= KnSELECTED_FLAG;
    if(visible) {
	kno->flags |= KnSHOW_SELECTION_FLAG;
	KlSend_clear(kno, w);
    }
    KlSend_select(kno, w);
}


void
KnUnselect(Widget w, KnO kno)
{
    if(kno->flags & KnSHOW_SELECTION_FLAG) {
	KlSend_clear(kno, w);
    }
    kno->flags &= ~(KnSELECTED_FLAG | KnSHOW_SELECTION_FLAG);    
    KlSend_unselect(kno, w);
}



void
KnUnmanage(KnO kno)
{
    Cardinal n;
    
    if(kno->parent) {
	KnGroup g = (KnGroup)kno->parent;
	for(n = 0; n < g->children->size; n++) {
	    if((KnO)g->children->list[n] == kno) {
		KlListDeletePos(g->children, n);
	    }
	}
    }

}


void
KnAppMainLoop(XtAppContext context)
{
    XEvent event;
    

    for(;;) {
	XtAppNextEvent(context, &event);
	{
/*	    KlGCMark();*/
	    XtDispatchEvent(&event);
/*	    KlGC();*/
	    KlZrtGc(0);
	}
    }
}




void
KnSetInteractor(Widget w, KnO kno, KnInteractor i)
{
    if(kno->interactor)
	KlDecRef(kno->interactor);
    kno->interactor = i;
    if(i) {
	/* allow NULL interactor to remove a behavior from an object */
	KlIncRef(i);
    }
}




#define WidgetIsKnO(w, s)\
    cl = w->knvas.interactorCallback;\
    w->knvas.interactorCallback = s->interactorCallback



#define KnOIsWidget(s, w)\
    s->interactorCallback = w->knvas.interactorCallback;\
    w->knvas.interactorCallback = cl

    
void
KnAddCallback(Widget knvas, KnO s, 
	      String name, 
	      XtCallbackProc proc, 
	      XtPointer client)
{
    KnvasWidget cw = (KnvasWidget)knvas;
    XtCallbackList cl;

    WidgetIsKnO(cw, s);
    XtAddCallback(knvas, name, proc, client);
    KnOIsWidget(s, cw);
}


void
KnRemoveCallback(Widget knvas, KnO s, 
		 String name, 
		 XtCallbackProc proc, 
		 XtPointer client)
{
    KnvasWidget cw = (KnvasWidget)knvas;
    XtCallbackList cl;

    WidgetIsKnO(cw, s);
    XtRemoveCallback(knvas, name, proc, client);
    KnOIsWidget(s, cw);
}

void
KnRemoveAllCallbacks(Widget knvas, KnO s, String name)

{
    KnvasWidget cw = (KnvasWidget)knvas;
    XtCallbackList cl;
    
    WidgetIsKnO(cw, s);
    XtRemoveAllCallbacks(knvas, name);
    KnOIsWidget(s, cw);
}

void
KnCallCallbacks(Widget knvas, KnO s, 
		String name, 
		XtPointer call)
{
    KnvasWidget cw = (KnvasWidget)knvas;
    XtCallbackList cl;
    
    WidgetIsKnO(cw, s);
    XtCallCallbacks(knvas, name, call);
    KnOIsWidget(s, cw);
}
    

void
KnDestroyTag(Widget knvas, KnTag kntag)
{
    TagObject tag = (TagObject)kntag;
    KnvasWidget kw = (KnvasWidget)knvas;

    KlListDeleteNonKlO(kw->knvas.tags, tag);
    XtDestroyWidget(kntag);
}
    

void
KnSetTag(Widget knvas, KnO kno, KnTag kntag)
{
    TagObject tag = (TagObject) kntag;
    kno->tid = tag->tag.id;
    /* prevent method call */
    if ( ! (kno->flags & KnCLEARED_FLAG))
	KlSend_clear(kno, knvas);
}



KnTag
KnGetTag(Widget w, KnO kno)
{
    KnvasWidget cw = (KnvasWidget)w;
#define THIS cw->knvas
    KnTagId id;

    id = kno->tid;
    if(id < THIS.tags->size)
	return (KnTag)THIS.tags->list[id];
    else
	return (KnTag)THIS.tags->list[0];  /* default tag */
#undef THIS
}


void
KnClear(Widget w, KnO kno)
{
    if ( ! (kno->flags & KnCLEARED_FLAG))
	KlSend_clear(kno, w);
}    



void
KnDamage(Widget w, KnO kno)
{
    KlSend_clear(kno, w);
}    


void
KnReparent(Widget w, KnO kno, KnO parent)
{
    KlSend_clear(kno, w);
    KnUnmanage(kno);
    KnGroupAdd((KnGroup)parent, kno);
    KlSend_clear(kno, w);
}    


extern KnvasDeleteObject(Widget w, KnO kno);
extern KnvasRemoveLayer(Widget w, KnO kno);
void
KnRemove(Widget w, KnO kno)
{
    /* keep KnvasDeleteObject for back compat */
    if(KlIsOfType(kno, KnLayerClass)) {
	KnvasRemoveLayer(w, kno);
    }
    else if(KlIsOfType(kno, KnOClass)) {
	KnvasDeleteObject(w, kno);
    }
}    




void
KnGetPosition(Widget unused, KnO kno, KnPosition *x, KnPosition *y)
{
    KlSend_position(kno, x, y);
}    




void
KnSetSensitive(Widget w, KnO kno, Boolean sensitive)
{
    if(sensitive) {
	kno->flags |= KnSENSITIVE_FLAG;
    }
    else {
	kno->flags &= ~KnSENSITIVE_FLAG;
    }
}



void
KnMap(Widget w, KnO kno)
{
    if(KnIsUnmapped(kno)) {
	/* after being unmapped, the kno is in the CLEARED state. the CLEARED
           flag is never removed, because redraw traversals wont affect the kno
           (because of the UNMAPPED flag. so the next clear won't damage the
           knvas, unless we force the flag here */
	kno->flags &= ~KnCLEARED_FLAG;
	kno->flags |= KnMAPPED_FLAG;
	KlSend_clear(kno, w);
    }
}



void
KnUnmap(Widget w, KnO kno)
{
    if(KnIsMapped(kno)) {
	KlSend_clear(kno, w);
	kno->flags &= ~KnMAPPED_FLAG;
    }
}


/*
 * NOT TESTED !!! UNDOCUMENTED !!!
 */
void
KnAttach(Widget knvas, KnO kno, KnAnchor anchor)
{
    if(NULL == kno->anchors) {
	kno->anchors = KlListNMake(0);
	KlIncRef(kno->anchors);
    }
    KlListAppend(kno->anchors, (KlO)anchor);

    KlListAppend(anchor->links, (KlO)kno);
    KlDecRef(kno);
}

void
KnDettach(Widget knvas, KnO kno, KnAnchor anchor)
{
    
}

KnO
KnContains(KnO kno, Widget knvas, KnPosition x, KnPosition y)
{
    return (KnO)KlSend_contains(kno, knvas, x, y);
}


    
