/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: link.c,v 1.7 95/09/28 11:58:16 leon Exp $ */

#include "link.h"
#include "anchor.h"
#include "TagP.h"


void
KnLinkInit(KnLink link,
	   Widget knvas,
	   KnO parent, 
	   KnAnchor a1,
	   KnAnchor a2)
{
    KnOInit((KnO)link, knvas, parent, 0, 0);

    link->anchors = KlListNMake(0);
    KlIncRef(link->anchors);
    
    KlListAppend(link->anchors, a1);
    KlListAppend(a1->links, link);

    KlListAppend(link->anchors, a2);
    KlListAppend(a2->links, link);
}



KnO
KnCreateLink(Widget knvas,
	      KnO parent,
	   KnO a1,
	   KnO a2)
{
    KnLink link;
    link = (KnLink)KlOMake(KnLinkClass);
    KnLinkInit(link, knvas, parent, (KnAnchor)a1, (KnAnchor)a2);
    KlDecRef(link);		/* suppress cycling references */
    KlDecRef(link);		/* suppress cycling references */
    return (KnO)link;
}


void
KnLinkDraw(KnLink link, KnDrawingContext ct, Transformer tf) 
{
    Transformer t;    
    XPoint *points;
    XRectangle box;
    TagObject tag;
    Cardinal i;
    tag = (TagObject)KnGetTag(ct->w, (KnO)link);
    link->flags &= ~KnCLEARED_FLAG;
    points = (XPoint *)XtMalloc(sizeof(XPoint) * link->anchors->size);
    for(i = 0; i < link->anchors->size; i++) {
	KlSend_position(link->anchors->list[i], &points[i].x, &points[i].y);
    }
    
    t = tf;
    if(t) {
	TransformerTransformPointList(t, points, link->anchors->size, points);
    }

    GetBoundingBox(points, link->anchors->size, &box);

    if(KnRectInRegion(ct->clip, box.x, box.y, 
		     box.width, box.height)) {
	XDrawLines(ct->dpy, ct->win,  tag->tag.gc, points,
		   link->anchors->size, CoordModeOrigin);
    }
    XtFree((void *)points);
}


void
KnLinkClear(KnLink link, Widget w)
{   
    XPoint *points;
    Cardinal i;
    XRectangle box;

    if(link->flags & KnCLEARED_FLAG) return;
    link->flags |= KnCLEARED_FLAG;
    points = (XPoint *)XtMalloc(sizeof(XPoint) * link->anchors->size);

    for(i = 0; i < link->anchors->size; i++) {
	KlSend_position(link->anchors->list[i], &points[i].x, &points[i].y);
	KlSend_clear(link->anchors->list[i], w);
    }
    
    GetBoundingBox(points, link->anchors->size, &box);
    
    KlSend_clearbox(link, points, link->anchors->size, NULL); 

    XtFree((void*)points);
}


void
KnLinkBoundingBox(KnLink link, Widget view, XRectangle *box)
{   
    XPoint *points;
    Cardinal i, n;
    n = link->anchors->size;
    points = (XPoint *)XtMalloc(sizeof(XPoint) * n);

    for(i = 0; i < n; i++) {
	KlSend_position(link->anchors->list[i], &points[i].x, &points[i].y);
    }
     
    KnTransformPointList(view, link, points, n);
    GetBoundingBox(points, n, box);

    XtFree((void*)points);
}


KnO
KnLinkContains(KnLink link, Widget w, Int x, Int y)
{
    Boolean res;
    KnPosition rx = x, ry = y;
    XPoint *points;
    Cardinal i;
    XRectangle box;

    if(link->t) {
	TransformerInvTransform(link->t, x, y, &rx, &ry);
    }
    
    points = (XPoint *)XtMalloc(sizeof(XPoint) * link->anchors->size);
    for(i = 0; i < link->anchors->size; i++) {
	KlSend_position(link->anchors->list[i], &points[i].x, &points[i].y);
    }
    GetBoundingBox(points, link->anchors->size, &box);

    res = (rx >= box.x) && (rx <= (KnPosition)(box.x + box.width)) &&
	(ry >= box.y) && (ry <= (KnPosition)(box.y + box.height));
    XtFree((void*)points);
    return res ? (KnO)link : NULL;
}



void
KnLinkSelect(KnLink link, Widget w)
{
	Cardinal i;
	for(i = 0; i < link->anchors->size; i++) {
	    KnSelect(w, (KnO)link->anchors->list[i], True);
	}
}





void
KnLinkTranslate(KnO kno, Int dx, Int dy)
{
    Cardinal i;
    KnLink link = (KnLink)kno;
    for(i = 0; i < link->anchors->size; i++) {
	KlSend_translate((KnO)link->anchors->list[i], dx, dy);
    }
}



void
KnLinkUnselect(KnLink link, Widget w)
{
	Cardinal i;
	for(i = 0; i < link->anchors->size; i++) {
	    KnUnselect(w, (KnO)link->anchors->list[i]);
	}
}


/* type desc */
KlType KnLinkClass;



/* DECLARE NEW SELECTORS HERE */
void
KnLinkImport()
{

}


/* CLASS INITIALIZATIONS FOR KNNEWCLASS OBJECTS */
void
KnLinkClassInitialize()
{
     /* DECLARE  TYPES */
    KlDeclareSubType(&KnLinkClass, "KnLink", KnOClass, sizeof(struct KnLinkStruct));

    /* declare methods */
    KlDeclareMethod(KnLinkClass, KnOSelDraw, KnLinkDraw);
    KlDeclareMethod(KnLinkClass, KnOSelContains, KnLinkContains);
    KlDeclareMethod(KnLinkClass, KnOSelClear, KnLinkClear);
    KlDeclareMethod(KnLinkClass, KnOSelTranslate, KnLinkTranslate);
    KlDeclareMethod(KnLinkClass, KnOSelBoundingBox, KnLinkBoundingBox);
}
