/* Copyright (c) 1995 by Groupe Bull.  All Rights Reserved */
/* $Id: region.h,v 1.2 95/09/25 14:56:38 leon Exp $ */

#include <X11/Intrinsic.h>

#define KnPosition Position
#define KnDimension Dimension

#ifndef __REGION_H
#define __REGION_H

#ifdef __cplusplus
extern "C" {
#endif



typedef struct _KnRegionRec {
    KnPosition x1, y1, x2, y2;
    Boolean inited;
} KnRegionRec, *KnRegion;



KnRegion
KnCreateRegion();


void
KnDestroyRegion(KnRegion region);


void
KnUnionRectWithRegion(XRectangle *rect, KnRegion src, KnRegion dest);



Boolean
KnRectInRegion(KnRegion r, KnPosition x1, KnPosition y1, KnDimension w, KnDimension h);


void
KnOffsetRegion(KnRegion r, int dx, int dy);


Boolean
KnEmptyRegion(KnRegion region);


void
KnSetRegion(Display *dpy, GC gc, KnRegion r);    


#ifdef __cplusplus
} /* Close scope of 'extern "C"' declaration which encloses file. */
#endif

#endif /* __REGION_H */
