/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: transformer.h,v 1.8.2.1 96/03/12 17:38:11 leon Exp $ */
/*
 * This is a translation of the Transformer C++ class defined in InterViews2.6,
 * to pure C code, YEAH! 
 *
 * Arnaud Le Hors - 20 May 94
 */

/*
 * Copyright (c) 1987, 1988, 1989 Stanford University
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Stanford not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Stanford makes no representations about
 * the suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * STANFORD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * Interface to transformation matrices.
 */

#ifndef __TRANSFORMER_H
#define __TRANSFORMER_H

/* become Xlib dependant */
#include <X11/Intrinsic.h>

#include <Kn/region.h>		/* for KnPosition & KnDimension */

#include <Kn/compat.h>

#ifdef __cplusplus
extern "C" {
#endif

    
#define T_TRANSLATED (1<<0)
#define T_SCALED (1<<1)
#define T_ROTATED (1<<2)
#define T_IDENTITY (1<<3)
#define T_TESTIDENTITY (1<<4)    
    
/* default tolerance */
#define DEFAULTTOL 1e-6

typedef struct {
    float mat00, mat01, mat10, mat11, mat20, mat21;
    unsigned flags;
} TransformerStruct, *Transformer;

#ifdef _NO_PROTO_UNDEF

Transformer TransformerMake();
Transformer TransformerMakeCopy();
void TransformerPremultiply();
void TransformerPostmultiply();
void TransformerInvert();
void TransformerTranslate();
void TransformerScale();
void TransformerRotate();
int TransformerTranslated();
void TransformerTransform();
void TransformerTransformPoint();
void TransformerTransformPointList();
void TransformerTransformBoxPoints();
void TransformFloat();
void TransformList();
void TransformerInvTransform();
void InvTransformFloat();
void InvTransformList();
int TransformerEqual();

#else /* _NO_PROTO */

Transformer TransformerMake();
Transformer TransformerMakeCopy(Transformer t);
void TransformerPremultiply(Transformer t, Transformer t2);
void TransformerPostmultiply(Transformer t, Transformer t2);
void TransformerInvert(Transformer t);
void TransformerTranslate(Transformer t, float dx, float dy);
void TransformerScale(Transformer t, float sx, float sy);
void TransformerRotate(Transformer t, float angle);
int TransformerTranslated(Transformer t, float tol);
void TransformerTransform(Transformer t, KnPosition x, KnPosition y, 
			  KnPosition *tx, KnPosition *ty);
void TransformerTransformPoint(Transformer t, XPoint *from, XPoint *to);
void TransformerTransformPointList(Transformer t, XPoint from[], 
				   Cardinal n, XPoint to[]);
void TransformerTransformBoxPoints(Transformer t,
				   KnPosition x, KnPosition y,
				   KnDimension w, KnDimension h,
				   XPoint *points);
void TransformFloat(Transformer t, float x, float y, float *tx, float *ty);
void TransformList(Transformer t,
		   KnPosition x[], KnPosition y[], Cardinal n, 
		   KnPosition tx[], KnPosition ty[]);
void TransformerInvTransform(Transformer t, KnPosition tx, KnPosition ty, 
			     KnPosition *x, KnPosition *y);
void InvTransformFloat(Transformer t, float tx, float ty, 
		       float *x, float *y);
void InvTransformList(Transformer t,
		      KnPosition tx[], KnPosition ty[], Cardinal n, 
		      KnPosition x[], KnPosition y[]);
int TransformerEqual(Transformer t, Transformer t2);

#endif /* _NO_PROTO */



/*
 * The following functions are defined as macros

void TransformerSet(Transformer t, Transformer t2);

float TransformerDet(Transformer t);

int TransformerScaled(Transformer t, float tol);
int TransformerStretched(Transformer t, float tol);
int TransformerRotated(Transformer t, float tol);
int TransformerRotated90(Transformer t, float tol);

*/

#define TransformerIdentity(t) ((t->flags & T_IDENTITY) &&\
                                (t->mat00==1) && (t->mat11==1)&&\
				(t->mat01==0) && (t->mat10==0) &&\
				(t->mat20==0) && (t->mat21==0))

#define TransformerSet(t, t2) { memcpy(t, t2, sizeof(TransformerStruct)); }

#define TransformerDet(t) ( \
t->mat00 * t->mat11 - t->mat01 * t->mat10 )

#define TransformerTranslated(t, tol) ( \
-tol > t->mat20 || t->mat20 > tol || -tol > t->mat21 || t->mat21 > tol )

#define TransformerScaled(t, tol) ( \
( (1 - tol) > t->mat00 || t->mat00 > (1 + tol) \
|| (1 - tol) > t->mat11 || t->mat11 > (1 + tol) ))

#define TransformerStretched(t, tol) (\
-tol > (mat00 - mat11) || (mat00 - mat11) > tol )

#define TransformerRotated(t, tol) ( \
-tol > mat01 || mat01 > tol || -tol > mat10 || mat10 > tol )

#define TransformerRotated90(t, tol) ( \
Rotated(t, tol) \
&& -tol <= mat00 && mat00 <= tol && -tol <= mat11 && mat11 <= tol )



#ifdef __cplusplus
} /* Close scope of 'extern "C"' */
#endif

#endif /* __TRANSFORMER_H */
