/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
static char rcsid[]="$Id: many.c,v 1.6 94/11/15 14:45:31 leon Exp $";
#include <stdio.h>
#include <Kn/Knvas.h>
#include <Xm/ScrolledW.h>
#include <Xm/PushB.h>
#if (XtSpecificationRelease >= 5)
#include <X11/Xmu/Editres.h>
#endif


static String 
fallbacks[] = {
    "*keyboardFocusPolicy: EXPLICIT",
    "*scrollingPolicy: AUTOMATIC",
    "*scrollBarDisplayPolicy: STATIC",
    "*geometry: 640x640",
    "*background: grey",
    "*pixmapBuffering: True",
    "*green.foreground: green",
    "*button.x: 100",
    "*button.y: 200",
    "*highlightThickness: 2",
    "*traversalOn: True",
    "*navigationType: TAB_GROUP",
    "*Knvas.width: 4000",
    "*Knvas.height: 4000",
    "*Knvas.translations: #override\n <Key>i: KnvasZoom(2, 2)\n <Key>o: KnvasZoom(0.5, 0.5)",

    NULL
};


#define OSIZE 4

XtAppContext app_context;
Widget toplevel, sc, knvas;

static KnInteractor selectI, moveI, resizeI;
static KnO r;
static KnTag green, red;
KnO layer;



void
CoucouCB(Widget w, XtPointer client, XtPointer call)
{
    fprintf(stderr, "coucou called\n");

}

int
main(int argc, char *argv[])
{
    int h, v, p;
    Cardinal numobjs;
    KnO kno;
    char fullname[256];


    

    toplevel = XtAppInitialize(&app_context, "KMany", 0, 0,
			       &argc, argv, fallbacks, 0, 0);
#if (XtSpecificationRelease >= 5)
    XtAddEventHandler(toplevel, 0, True, _XEditResCheckMessages, NULL);
#endif
    if(argc != 2) {
	fprintf(stderr, "usage: many <n>\n");
	exit(1);
    }
    numobjs = atoi(argv[1]);
    sc = XmCreateScrolledWindow(toplevel, "sc", 0, 0);
    XtManageChild(sc);
    knvas = 
	XtVaCreateManagedWidget("essai", knvasWidgetClass, sc,
				NULL);
    XtManageChild(XmCreatePushButton(knvas, "button", 0, 0));
    layer = KnCreateLayer(knvas);
    moveI = KnCreateMoveInteractor(knvas, "move");

    green = KnCreateTag(knvas, "green");
    red = KnCreateTag(knvas, "red");

    r = KnCreateFRect(knvas, layer, 100, 100, 100, 100);
    KnSetTag(knvas, r, green);
    KnSetInteractor(knvas, r, moveI);


    for(h = 0; h < numobjs; h++) {
	for(v = 0; v < numobjs; v++) {
	    r = KnCreateRect(knvas, layer, h * OSIZE + v, 
			 h+ v * OSIZE, OSIZE, OSIZE);
	}
    }
    XtRealizeWidget(toplevel);

    XtAppMainLoop(app_context);
}
