/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
static char rcsid[]="$Id: sample.c,v 1.12 96/01/04 12:37:13 leon Exp $";
#include <stdio.h>
#include <Kn/Knvas.h>
#include <X11/Shell.h>
#include <Xm/ScrolledW.h>
#if (XtSpecificationRelease >= 5)
#include "editres.h"
#endif




/* use fallbacks so that demos will always have a nice look */
static String 
fallbacks[] = {
"*mi1.button: 1",
"*mi2.button: 2",
"*visibleSelection: on",
"*KnResizeInteractor.button: 2",
"*selectionLook: FANCY",
"*geometry: 600x600",
"*essai.width: 600",
"*essai.height: 600",
"*background:grey",
"*shadowThickness: 1",
"*pixmapBuffering: True",
"*essai.translations: #override\n <Key>i: KnvasZoom(2, 2)\n <Key>o: KnvasZoom(0.5, 0.5)",
"*green.foreground: green3",
"*green.shadowType: SHADOW_OUT",
"*default.symColors: team = purple",
"*red.foreground: red3",
"*red.lineWidth: 1",
"*red.capStyle: CapButt",
"*default.shadowType: SHADOW_OUT",
"*default.foreground: blue3",
"*default.background: yellow",
"*default.lineStyle: doubledash",
"*default.lineWidth: 2",
"*default.font: -adobe-helvetica-bold-o-normal--24-240-75-75-p-138-iso8859-1",
"*yellow.foreground: yellow",
"*yellow.shadowType: SHADOW_OUT",
"*yellow.foreground: yellow3",
NULL
};



Widget toplevel, knvas;
Widget t2, c2;
KnO kno;
KnInteractor resizeI, moveI, selectI;
KnTag green, yellow, red;





void
ChangeTagCB(Widget wid, XtPointer client, XtPointer call)
{
    KnTag tag;
    Pixel c1, c2, c3;
    InteractorCallbackStruct *cs = (InteractorCallbackStruct *)call;
    if(KnCR_PICK == cs->reason) {
	tag = KnGetTag(wid, cs->target);
	if(tag == green) {
	    KnSetTag(wid, cs->target, red);
	}
	else {
	    KnSetTag(wid, cs->target, green);
	}
    }
}



void
DeleteCB(Widget wid, XtPointer client, XtPointer call)
{
    InteractorCallbackStruct *cs = (InteractorCallbackStruct *)call;
    KnClear(wid, cs->target);
    KnRemove(wid, cs->target);
}


void
rotate(Widget w, XEvent *event, String *params, Cardinal *num)
{
    KnRotate(knvas, kno, 45);
    KnvasUpdateLayers(knvas);
}

void
quit(Widget w, XEvent *event, String *params, Cardinal *num)
{
    exit(0);
}


static char translations[] = "\
<Key>r: rotate()\n\
<Key>q: quit()\n\
";


static XtActionsRec
actions[] = {
    "rotate", rotate,
    "quit",quit,
};


int
main(int argc, char *argv[])
{
    int i;
    KnO layer;
    KnO group;
    XtAppContext context;
    KnInteractor fullI, mi;
    Widget sw;
    


    toplevel = XtAppInitialize(&context, "KSample", 0, 0,
			       &argc, argv, fallbacks, 0, 0);

#if (XtSpecificationRelease >= 5)
    XtAddEventHandler(toplevel, 0, True, _XEditResCheckMessages, NULL);
#endif
    XtAppAddActions(context, actions, XtNumber(actions));
    sw = XmCreateScrolledWindow(toplevel, "sw", NULL, 0);
    knvas = 
	XtVaCreateManagedWidget("essai", knvasWidgetClass, sw,
				NULL);
    XtManageChild(sw);
    green = KnCreateTag(knvas, "green");
    yellow = KnCreateTag(knvas, "yellow");
    red = KnCreateTag(knvas, "red");


    moveI = KnCreateMoveInteractor(knvas, "mi1");
    resizeI = KnCreateResizeInteractor(knvas, "ri1");
    selectI = KnCreateSelectInteractor(knvas, "si1");
    fullI = KnCreateInteractor(knvas, "");
    KnInteractorMerge(knvas, fullI, moveI);
    KnInteractorMerge(knvas, fullI, resizeI);
    layer = KnCreateLayer(knvas);

/*    kno = KnCreateIcon(knvas, layer, "screen", 0, 0);*/

    group = KnCreateGroup(knvas, layer, 20, 200);
    kno = KnCreateLine(knvas, group, 0, 0, 100, 100);
    kno = KnCreateLine(knvas, group, 100, 0, 0, 100);
    KnSetInteractor(knvas, group, fullI);

    {
	KnO layer2 = KnCreateLayer(knvas);
	group = KnCreateGroup(knvas, layer2, 50, 100);
	kno = KnCreateLine(knvas, group, 0, 0, 100, 100);
	kno = KnCreateLine(knvas, group, 100, 0, 0, 100);
	KnSetInteractor(knvas, group, moveI);
    }

    kno = KnCreateLabel(knvas, layer, 50, 0, "Motif Knvas Widget");
    KnSetInteractor(knvas, kno, moveI);

    kno = KnCreateLine(knvas, layer, 300, 300, 300, 500);
    KnSetTag(knvas, kno, green);
    KnSetInteractor(knvas, kno, moveI);
    kno = KnCreateLine(knvas, layer, 400, 300, 500, 300);
    KnSetTag(knvas, kno, green);
    KnSetInteractor(knvas, kno, moveI);

    kno = KnCreateFRect(knvas, layer, 300, 300, 64, 64);
    KnSetInteractor(knvas, kno, selectI);
    KnSetTag(knvas, kno, green);
    KnAddCallback(knvas, kno, XtNinteractorCallback, ChangeTagCB, 0);

    kno = KnCreateIcon(knvas, layer, "king", 200, 200);
    KnSetInteractor(knvas, kno, moveI);



    kno = KnCreateCircle(knvas, layer, 200, 400, 50, 50);
    KnSetInteractor(knvas, kno, moveI);



    kno = KnCreateFCircle(knvas, layer, 200, 300, 50, 50);
    KnSetInteractor(knvas, kno, resizeI);
    KnSetTag(knvas, kno, red);

    
    kno = KnCreateRect(knvas, layer, 400, 400, 64, 64);

    KnSetTag(knvas, kno, red);

    {
	KnO a1, a2;
	a1 = KnCreateAnchor(knvas, layer, 100, 200, True);
	a2 = KnCreateAnchor(knvas, layer, 300, 300, True);
	kno = KnCreateLink(knvas, layer, a1, a2);
	KnSetInteractor(knvas, kno, moveI);
    }

    kno = KnCreateAnchor(knvas, layer, 100, 10, True);

    kno = KnCreateFArc(knvas, layer, 400, 100, 40, 40, 45, 90);
    KnSetInteractor(knvas, kno, moveI);
    KnSetTag(knvas, kno, yellow);
    kno = KnCreateFArc(knvas, layer, 400, 200, 40, 100, 200, 45);
    KnSetTag(knvas, kno, yellow);
    
    kno = KnCreateFCircle(knvas, layer, 400, 400, 100, 40);
    KnSetTag(knvas, kno, yellow);

    {
	/* tests polyline */
	XPoint points[4] = {
	    {10, 10},
	    {110, 10},
	    {110, 110},
	    {10, 110},
	};
	kno = KnCreatePolyline(knvas, layer, points, 4);
	KnSetInteractor(knvas, kno, fullI);
	KnSetTag(knvas, kno, yellow);
    }

    {
	/* tests polygon */
	XPoint points[4] = {
	    {10, 10},
	    {100, 80},
	    {40, 180},
	    {80, 35},
	};
	kno = KnCreatePolygon(knvas, layer, points, 4);
	KnSetInteractor(knvas, kno, fullI);
	KnSetTag(knvas, kno, yellow);
    }

    XtRealizeWidget(toplevel);
    XtAppMainLoop(context);
}
