/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* $Id: PieChartP.h,v 1.1 95/02/02 11:04:15 leon Exp $ */
#ifndef __PIECHARTP_H
#define __PIECHARTP_H


/* force the motif widget flag */
#ifndef DO_MOTIF_WIDGET
#define DO_MOTIF_WIDGET
#endif /* DO_MOTIF_WIDGET */
#include <Kn/KnvasP.h>
#include "PieChart.h"


#ifdef __cplusplus
extern "C" {
#endif




typedef struct {
    int empty;
} XmPieChartClassPart;

typedef struct _XmPieChartClassRec {
    CoreClassPart	core_class;
    CompositeClassPart	composite_class;
    ConstraintClassPart		constraint_class;
    XmManagerClassPart		manager_class;
    KnvasClassPart	knvas_class;
    XmPieChartClassPart    pie_chart_class;
} XmPieChartClassRec;

typedef struct _XmPieChartPart{
    /* public part: resources */
    int *items;
    int itemCount;
    int *tags;

    Dimension marginWidth;
    Dimension marginHeight;
    Dimension spacing;

    /* private part */
    KnO layer;
    int total;
    KnTag * usedtags;
} XmPieChartPart;


typedef struct _XmPieChartRec {
    CorePart		core;
    CompositePart	composite;
    ConstraintPart      constraint;
    XmManagerPart       manager;
    KnvasPart	        knvas;
    XmPieChartPart         pie_chart;
} XmPieChartRec;

extern XmPieChartClassRec xmPieChartClassRec;















#ifdef __cplusplus
} /* Close scope of 'extern "C"' declaration which encloses file. */
#endif




#endif /* __PIECHARTP_H */
/* DON'T ADD ANYTHING AFTER THIS #endif */
