
/*******************************************************************************
	topLevelShell1.c

       Associated Header file: topLevelShell1.h
*******************************************************************************/

#include <stdio.h>

#ifdef MOTIF
#include <Xm/Xm.h>
#include <Xm/MwmUtil.h>
#include <Xm/MenuShell.h>
#endif /* MOTIF */

#include "UxXt.h"
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Form.h>
#include <X11/Shell.h>

/*******************************************************************************
       Includes, Defines, and Global variables from the Declarations Editor:
*******************************************************************************/

#include <sys/ioctl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <fcntl.h>
#include <signal.h>
#include <termio.h>
#include <unistd.h>

#ifdef VT
#include <Xm/Separator.h>
#include <Xm/Label.h>
#include <Vt.h>
Widget    vt1 = NULL;
#endif

#define COMMAND               ( "/usr/bin/ftp" )
#define  ENVFLAG     ( "-e" )
#define  PRGFLAG     ( "-x" )
#define  KSH         ( "ksh" )
#define  NOUID       ( -1 )
#define  NOGID       ( -1 )



typedef int bool;

FILE *incmd = NULL;
int pid = 0;
int getrem = 0;
bool dispoff = FALSE;

extern char **special_argv;
extern int    special_argc;

extern swidget help_msg;
extern swidget textField4;
extern char pwdstr[BUFSIZ];
extern swidget dirlist;
extern swidget filelist;
extern swidget file_dialog;

swidget create_help_msg();
swidget create_login_dialog();
swidget create_lfile_dialog();
swidget create_file_dialog();
void popup_file_dialog();
void popup_lfile_dialog();
void popup_help_msg();
void popup_login();


static	int _UxIfClassId;
/*******************************************************************************
       The following header file defines the context structure.
*******************************************************************************/

#ifndef XKLOADDS
#define XKLOADDS
#endif /* XKLOADDS */

#define CONTEXT_MACRO_ACCESS 1
#include "topLevelShell1.h"
#undef CONTEXT_MACRO_ACCESS


/*******************************************************************************
Auxiliary code from the Declarations Editor:
*******************************************************************************/

#ifdef VT

static void	monitorCB_vt1( UxWidget, UxClientData, UxCallbackArg )
	Widget		UxWidget;
	XtPointer	UxClientData, UxCallbackArg;
{
    exit( 0 );
}

static void	outputCB_vt1( UxWidget, UxClientData, UxCallbackArg )
	Widget		UxWidget;
	XtPointer	UxClientData, UxCallbackArg;
{
    XmVtCallbackStruct *info = ( XmVtCallbackStruct * )UxCallbackArg;
    int inx = 0;
    for (inx = 0; inx < info->data_count;inx++)
    {
        onechar (info->data_buffer[inx]);
    }
    if (dispoff) info->data_count = 0;
}

static void	messageCB_vt1( UxWidget, UxClientData, UxCallbackArg )
	Widget		UxWidget;
	XtPointer	UxClientData, UxCallbackArg;
{
    XmVtCallbackStruct *info = ( XmVtCallbackStruct * )UxCallbackArg;
    XtVaSetValues( topLevelShell1, XmNtitle, info->data_buffer, NULL );
    XtVaSetValues( topLevelShell1, XmNiconName, info->data_buffer, NULL );
}
#endif

/******************************************************************************/
/*                                                                            */
/*   Function name:  onechar()                                                */
/*                                                                            */
/*   Program ID:     libeds.a                                                 */
/*                                                                            */
/*   Description:    This function is used to process one character of output */
/*                   from the ftp program.                                    */
/*                                                                            */
/*   Parameters:     chrout     - char  - output character to operate on.     */
/*                                                                            */
/*   Input:          chrout                                                   */
/*                                                                            */
/*   Output:         returns display varable                                  */
/*                                                                            */
/*   Special Logic Notes: None                                                */
/*                                                                            */
/******************************************************************************/
/*                                                                            */
/*                             MODIFICATION LOG                               */
/*                                                                            */
/*    DATE        AUTHOR         DESCRIPTION                                  */
/*  --------    --------------   -------------------------------------------- */
/*  08-30-91    Bruce M. Corwin  Initial Release                              */
/*                                                                            */
/******************************************************************************/

bool onechar( chout )
    char chout;
{
    char chout_str[100];
    static char linebuff[BUFSIZ];
    static int store = 0;
    static int pstore = 0;
    static char dirlines[BUFSIZ];
    static char pwdline[BUFSIZ];
    static int dirflag = FALSE;
    static int dircnt = 0;
    XmString str = NULL;
    static int inx = 0;
    static int new = TRUE;
    Widget tf4 = NULL;

    tf4 = UxGetWidget( textField4 );
    chout_str[1] = 0;
    chout_str[0] = chout;
    if( chout != 10 )
	strcat( linebuff, chout_str );
    else
	linebuff[0] = 0;
    if( pstore )
    {
	if( chout != '"' ) strcat( pwdline, chout_str );
	else
	{
	    strcpy( pwdstr, pwdline );
	    if( strcmp( pwdstr, "/" ) != 0 ) strcat( pwdstr, "/" );
	    XmTextSetString( tf4, pwdstr );
	    XmTextFieldSetInsertionPosition( tf4, XmTextFieldGetLastPosition( tf4 ) );
	    pstore = FALSE;
	    pwdline[0] = 0;
	}
    }
    if( 
	strcmp( linebuff, "257 \"" ) == 0 ||
	strcmp( linebuff, "ftp> 257 \"" ) == 0
      ) pstore = TRUE;

    if( store )
    {
	if( new )
	{
	    if( chout == 'd' || chout == 'l' ) dirflag = TRUE;
	    else                               dirflag = FALSE;
	    new = FALSE;
	}
	if( chout != 10 ) strcat( dirlines, chout_str );
	if( chout == ' ' ) dirlines[0] = 0;
	if( chout == 10 )
	{
	    if( dircnt > 1 )
	    {
		dirlines[strlen(dirlines)-1] = 0;
		str = XmStringCreateSimple( dirlines );
		if( dirflag )
		    XmListAddItemUnselected( UxGetWidget( dirlist ), str, inx+1 );
		else
		    XmListAddItemUnselected( UxGetWidget( filelist ), str, inx+1 );
		XmStringFree( str );
		inx++;
	    }
	    dirlines[0] = 0;
	    new = TRUE;
	    dircnt++;
	}
	if( strcmp( linebuff, "226 " ) == 0 ) UxPopupInterface( file_dialog, no_grab );
    }
    if( strcmp( linebuff, "150 " ) == 0 && getrem )
    {
	getrem = FALSE;
	XmListDeleteAllItems( filelist );
	XmListDeleteAllItems( dirlist );
	store = TRUE;
	dircnt = 0;
	inx = 0;
	dirlines[0] = 0;
	new = TRUE;
	dirflag = FALSE;
/*
	dispoff = TRUE;
*/
    }
    if( strcmp( linebuff, "226 " ) == 0 )
	store = FALSE;

    if( 
	strcmp( linebuff, "226" ) == 0 ||
	strcmp( linebuff, "usage:" ) == 0 ||
	strcmp( linebuff, "Not" ) == 0 ||
	strcmp( linebuff, "ftp> " ) == 0 
      )
    {
	dispoff = FALSE;
    }
    return ( dispoff );
}

/*******************************************************************************
       The following are callback functions.
*******************************************************************************/

static void  activateCB_menu1_p2_b1(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
	    popup_help_msg();
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p1_b2(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
	    char command[BUFSIZ];
#ifdef VT
	    getrem = True;
	    sprintf (command, "pwd\n");
	    XmVtSend (vt1, command);
	    sprintf (command, "ls -l\n");
	    XmVtSend (vt1, command);
#endif
	    popup_file_dialog();
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p1_b3(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
	    popup_lfile_dialog();
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p1_b1(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
	    int rcode = 0;
	    rcode = kill( ( -1*pid ), 9 );
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p9_b1(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
	    popup_login();
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p9_b2(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	    char command[BUFSIZ];
	    sprintf (command, "close\n" );
	    XmVtSend (vt1, command);
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p9_b3(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	    char command[BUFSIZ];
	    sprintf (command, "%c", 3 );
	    XmVtSend (vt1, command);
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p9_b4(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	    char command[BUFSIZ];
	    sprintf (command, "quit\n" );
	    XmVtSend (vt1, command);
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p8_b1(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	    Time timestamp1;
	
	    timestamp1 = XtLastTimestampProcessed(XtDisplay(vt1));
	     XmVtCopy (vt1, timestamp1);
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p8_b2(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	    XmVtPaste (vt1);
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p3_b4(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	    char command[BUFSIZ];
	    sprintf (command, "binary\n" );
	    XmVtSend (vt1, command);
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p3_b5(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	    char command[BUFSIZ];
	    sprintf (command, "ascii\n" );
	    XmVtSend (vt1, command);
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p3_b6(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	    char command[BUFSIZ];
	    sprintf (command, "prompt\n" );
	    XmVtSend (vt1, command);
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p10_b1(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	    char command[BUFSIZ];
	    sprintf (command, "ls -l\n" );
	    XmVtSend (vt1, command);
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

static void  activateCB_menu1_p10_b2(
			Widget wgt, 
			XtPointer cd, 
			XtPointer cb)
{
	_UxCtopLevelShell1      *UxSaveCtx, *UxContext;
	Widget                  UxWidget = wgt;
	XtPointer               UxClientData = cd;
	XtPointer               UxCallbackArg = cb;

	UxSaveCtx = UxTopLevelShell1Context;
	UxTopLevelShell1Context = UxContext =
			(_UxCtopLevelShell1 *) UxGetContext( UxWidget );
	{
#ifdef VT
	    char command[BUFSIZ];
	    sprintf (command, "!ls -l\n" );
	    XmVtSend (vt1, command);
#endif
	}
	UxTopLevelShell1Context = UxSaveCtx;
}

/*******************************************************************************
       The 'build_' function creates all the widgets
       using the resource values specified in the Property Editor.
*******************************************************************************/

static Widget	_Uxbuild_topLevelShell1()
{
	Widget		menu1_p2_shell;
	Widget		menu1_p1_shell;
	Widget		menu1_p9_shell;
	Widget		menu1_p8_shell;
	Widget		menu1_p3_shell;
	Widget		menu1_p10_shell;


	/* Creation of topLevelShell1 */
	topLevelShell1 = XtVaCreatePopupShell( "topLevelShell1",
			topLevelShellWidgetClass,
			UxTopLevel,
			XmNx, 0,
			XmNy, 0,
			XmNiconName, "ftpterm",
			XmNtitle, "ftpterm",
			XmNallowShellResize, TRUE,
			NULL );
	UxPutContext( topLevelShell1, (char *) UxTopLevelShell1Context );
	UxPutClassCode( topLevelShell1, _UxIfClassId );


	/* Creation of form1 */
	form1 = XtVaCreateManagedWidget( "form1",
			xmFormWidgetClass,
			topLevelShell1,
			XmNresizePolicy, XmRESIZE_ANY,
			XmNunitType, XmPIXELS,
			XmNx, 40,
			XmNy, 30,
			RES_CONVERT( XmNaccelerators, "<Key>Return: ManagerGadgetKeyInput()" ),
			NULL );
	UxPutContext( form1, (char *) UxTopLevelShell1Context );


	/* Creation of menu1 */
	menu1 = XtVaCreateManagedWidget( "menu1",
			xmRowColumnWidgetClass,
			form1,
			XmNrowColumnType, XmMENU_BAR,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_FORM,
			XmNtopAttachment, XmATTACH_FORM,
			XmNmenuAccelerator, "<KeyUp>F10",
			NULL );
	UxPutContext( menu1, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p2 */
	menu1_p2_shell = XtVaCreatePopupShell ("menu1_p2_shell",
			xmMenuShellWidgetClass, menu1,
			XmNwidth, 1,
			XmNheight, 1,
			XmNallowShellResize, TRUE,
			XmNoverrideRedirect, TRUE,
			NULL );

	menu1_p2 = XtVaCreateWidget( "menu1_p2",
			xmRowColumnWidgetClass,
			menu1_p2_shell,
			XmNrowColumnType, XmMENU_PULLDOWN,
			NULL );
	UxPutContext( menu1_p2, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p2_b1 */
	menu1_p2_b1 = XtVaCreateManagedWidget( "menu1_p2_b1",
			xmPushButtonWidgetClass,
			menu1_p2,
			RES_CONVERT( XmNlabelString, "About" ),
			RES_CONVERT( XmNmnemonic, "A" ),
			NULL );
	XtAddCallback( menu1_p2_b1, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p2_b1,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p2_b1, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_top_b2 */
	menu1_top_b2 = XtVaCreateManagedWidget( "menu1_top_b2",
			xmCascadeButtonWidgetClass,
			menu1,
			RES_CONVERT( XmNlabelString, "Help" ),
			RES_CONVERT( XmNmnemonic, "H" ),
			XmNsubMenuId, menu1_p2,
			NULL );
	UxPutContext( menu1_top_b2, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p1 */
	menu1_p1_shell = XtVaCreatePopupShell ("menu1_p1_shell",
			xmMenuShellWidgetClass, menu1,
			XmNwidth, 1,
			XmNheight, 1,
			XmNallowShellResize, TRUE,
			XmNoverrideRedirect, TRUE,
			NULL );

	menu1_p1 = XtVaCreateWidget( "menu1_p1",
			xmRowColumnWidgetClass,
			menu1_p1_shell,
			XmNrowColumnType, XmMENU_PULLDOWN,
			NULL );
	UxPutContext( menu1_p1, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p1_b2 */
	menu1_p1_b2 = XtVaCreateManagedWidget( "menu1_p1_b2",
			xmPushButtonWidgetClass,
			menu1_p1,
			RES_CONVERT( XmNlabelString, "Remote Files" ),
			RES_CONVERT( XmNmnemonic, "R" ),
			NULL );
	XtAddCallback( menu1_p1_b2, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p1_b2,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p1_b2, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p1_b3 */
	menu1_p1_b3 = XtVaCreateManagedWidget( "menu1_p1_b3",
			xmPushButtonWidgetClass,
			menu1_p1,
			RES_CONVERT( XmNlabelString, "Local Files" ),
			RES_CONVERT( XmNmnemonic, "L" ),
			NULL );
	XtAddCallback( menu1_p1_b3, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p1_b3,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p1_b3, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p1_b1 */
	menu1_p1_b1 = XtVaCreateManagedWidget( "menu1_p1_b1",
			xmPushButtonWidgetClass,
			menu1_p1,
			RES_CONVERT( XmNlabelString, "Exit" ),
			RES_CONVERT( XmNmnemonic, "E" ),
			NULL );
	XtAddCallback( menu1_p1_b1, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p1_b1,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p1_b1, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_top_b1 */
	menu1_top_b1 = XtVaCreateManagedWidget( "menu1_top_b1",
			xmCascadeButtonWidgetClass,
			menu1,
			RES_CONVERT( XmNlabelString, "File" ),
			RES_CONVERT( XmNmnemonic, "F" ),
			XmNsubMenuId, menu1_p1,
			NULL );
	UxPutContext( menu1_top_b1, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p9 */
	menu1_p9_shell = XtVaCreatePopupShell ("menu1_p9_shell",
			xmMenuShellWidgetClass, menu1,
			XmNwidth, 1,
			XmNheight, 1,
			XmNallowShellResize, TRUE,
			XmNoverrideRedirect, TRUE,
			NULL );

	menu1_p9 = XtVaCreateWidget( "menu1_p9",
			xmRowColumnWidgetClass,
			menu1_p9_shell,
			XmNrowColumnType, XmMENU_PULLDOWN,
			NULL );
	UxPutContext( menu1_p9, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p9_b1 */
	menu1_p9_b1 = XtVaCreateManagedWidget( "menu1_p9_b1",
			xmPushButtonWidgetClass,
			menu1_p9,
			RES_CONVERT( XmNlabelString, "Login" ),
			RES_CONVERT( XmNmnemonic, "L" ),
			NULL );
	XtAddCallback( menu1_p9_b1, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p9_b1,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p9_b1, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p9_b2 */
	menu1_p9_b2 = XtVaCreateManagedWidget( "menu1_p9_b2",
			xmPushButtonWidgetClass,
			menu1_p9,
			RES_CONVERT( XmNlabelString, "Close" ),
			RES_CONVERT( XmNmnemonic, "C" ),
			NULL );
	XtAddCallback( menu1_p9_b2, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p9_b2,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p9_b2, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p9_b3 */
	menu1_p9_b3 = XtVaCreateManagedWidget( "menu1_p9_b3",
			xmPushButtonWidgetClass,
			menu1_p9,
			RES_CONVERT( XmNlabelString, "Abort" ),
			RES_CONVERT( XmNmnemonic, "A" ),
			NULL );
	XtAddCallback( menu1_p9_b3, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p9_b3,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p9_b3, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p9_b4 */
	menu1_p9_b4 = XtVaCreateManagedWidget( "menu1_p9_b4",
			xmPushButtonWidgetClass,
			menu1_p9,
			RES_CONVERT( XmNlabelString, "Quit" ),
			RES_CONVERT( XmNmnemonic, "Q" ),
			NULL );
	XtAddCallback( menu1_p9_b4, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p9_b4,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p9_b4, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_top_b5 */
	menu1_top_b5 = XtVaCreateManagedWidget( "menu1_top_b5",
			xmCascadeButtonWidgetClass,
			menu1,
			RES_CONVERT( XmNlabelString, "Session" ),
			RES_CONVERT( XmNmnemonic, "S" ),
			XmNsubMenuId, menu1_p9,
			NULL );
	UxPutContext( menu1_top_b5, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p8 */
	menu1_p8_shell = XtVaCreatePopupShell ("menu1_p8_shell",
			xmMenuShellWidgetClass, menu1,
			XmNwidth, 1,
			XmNheight, 1,
			XmNallowShellResize, TRUE,
			XmNoverrideRedirect, TRUE,
			NULL );

	menu1_p8 = XtVaCreateWidget( "menu1_p8",
			xmRowColumnWidgetClass,
			menu1_p8_shell,
			XmNrowColumnType, XmMENU_PULLDOWN,
			NULL );
	UxPutContext( menu1_p8, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p8_b1 */
	menu1_p8_b1 = XtVaCreateManagedWidget( "menu1_p8_b1",
			xmPushButtonWidgetClass,
			menu1_p8,
			RES_CONVERT( XmNlabelString, "Copy" ),
			RES_CONVERT( XmNmnemonic, "C" ),
			NULL );
	XtAddCallback( menu1_p8_b1, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p8_b1,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p8_b1, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p8_b2 */
	menu1_p8_b2 = XtVaCreateManagedWidget( "menu1_p8_b2",
			xmPushButtonWidgetClass,
			menu1_p8,
			RES_CONVERT( XmNlabelString, "Paste" ),
			RES_CONVERT( XmNmnemonic, "P" ),
			NULL );
	XtAddCallback( menu1_p8_b2, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p8_b2,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p8_b2, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_top_b4 */
	menu1_top_b4 = XtVaCreateManagedWidget( "menu1_top_b4",
			xmCascadeButtonWidgetClass,
			menu1,
			RES_CONVERT( XmNlabelString, "Edit" ),
			RES_CONVERT( XmNmnemonic, "E" ),
			XmNsubMenuId, menu1_p8,
			NULL );
	UxPutContext( menu1_top_b4, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p3 */
	menu1_p3_shell = XtVaCreatePopupShell ("menu1_p3_shell",
			xmMenuShellWidgetClass, menu1,
			XmNwidth, 1,
			XmNheight, 1,
			XmNallowShellResize, TRUE,
			XmNoverrideRedirect, TRUE,
			NULL );

	menu1_p3 = XtVaCreateWidget( "menu1_p3",
			xmRowColumnWidgetClass,
			menu1_p3_shell,
			XmNrowColumnType, XmMENU_PULLDOWN,
			NULL );
	UxPutContext( menu1_p3, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p3_b4 */
	menu1_p3_b4 = XtVaCreateManagedWidget( "menu1_p3_b4",
			xmPushButtonWidgetClass,
			menu1_p3,
			RES_CONVERT( XmNlabelString, "Binary" ),
			RES_CONVERT( XmNmnemonic, "B" ),
			NULL );
	XtAddCallback( menu1_p3_b4, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p3_b4,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p3_b4, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p3_b5 */
	menu1_p3_b5 = XtVaCreateManagedWidget( "menu1_p3_b5",
			xmPushButtonWidgetClass,
			menu1_p3,
			RES_CONVERT( XmNlabelString, "Ascii" ),
			RES_CONVERT( XmNmnemonic, "A" ),
			NULL );
	XtAddCallback( menu1_p3_b5, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p3_b5,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p3_b5, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p3_b6 */
	menu1_p3_b6 = XtVaCreateManagedWidget( "menu1_p3_b6",
			xmPushButtonWidgetClass,
			menu1_p3,
			RES_CONVERT( XmNlabelString, "Prompt" ),
			RES_CONVERT( XmNmnemonic, "P" ),
			NULL );
	XtAddCallback( menu1_p3_b6, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p3_b6,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p3_b6, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_top_b3 */
	menu1_top_b3 = XtVaCreateManagedWidget( "menu1_top_b3",
			xmCascadeButtonWidgetClass,
			menu1,
			RES_CONVERT( XmNlabelString, "Options" ),
			RES_CONVERT( XmNmnemonic, "O" ),
			XmNsubMenuId, menu1_p3,
			NULL );
	UxPutContext( menu1_top_b3, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p10 */
	menu1_p10_shell = XtVaCreatePopupShell ("menu1_p10_shell",
			xmMenuShellWidgetClass, menu1,
			XmNwidth, 1,
			XmNheight, 1,
			XmNallowShellResize, TRUE,
			XmNoverrideRedirect, TRUE,
			NULL );

	menu1_p10 = XtVaCreateWidget( "menu1_p10",
			xmRowColumnWidgetClass,
			menu1_p10_shell,
			XmNrowColumnType, XmMENU_PULLDOWN,
			NULL );
	UxPutContext( menu1_p10, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p10_b1 */
	menu1_p10_b1 = XtVaCreateManagedWidget( "menu1_p10_b1",
			xmPushButtonWidgetClass,
			menu1_p10,
			RES_CONVERT( XmNlabelString, "Remote List" ),
			RES_CONVERT( XmNmnemonic, "R" ),
			NULL );
	XtAddCallback( menu1_p10_b1, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p10_b1,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p10_b1, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_p10_b2 */
	menu1_p10_b2 = XtVaCreateManagedWidget( "menu1_p10_b2",
			xmPushButtonWidgetClass,
			menu1_p10,
			RES_CONVERT( XmNlabelString, "Local List" ),
			RES_CONVERT( XmNmnemonic, "L" ),
			NULL );
	XtAddCallback( menu1_p10_b2, XmNactivateCallback,
		(XtCallbackProc) activateCB_menu1_p10_b2,
		(XtPointer) UxTopLevelShell1Context );

	UxPutContext( menu1_p10_b2, (char *) UxTopLevelShell1Context );


	/* Creation of menu1_top_b6 */
	menu1_top_b6 = XtVaCreateManagedWidget( "menu1_top_b6",
			xmCascadeButtonWidgetClass,
			menu1,
			RES_CONVERT( XmNlabelString, "View" ),
			RES_CONVERT( XmNmnemonic, "V" ),
			XmNsubMenuId, menu1_p10,
			NULL );
	UxPutContext( menu1_top_b6, (char *) UxTopLevelShell1Context );

	XtVaSetValues(menu1,
			XmNmenuHelpWidget, menu1_top_b2,
			NULL );


	XtAddCallback( topLevelShell1, XmNdestroyCallback,
		(XtCallbackProc) UxDestroyContextCB,
		(XtPointer) UxTopLevelShell1Context);


	return ( topLevelShell1 );
}

/*******************************************************************************
       The following is the 'Interface function' which is the
       external entry point for creating this interface.
       This function should be called from your application or from
       a callback function.
*******************************************************************************/

Widget	create_topLevelShell1()
{
	Widget                  rtrn;
	_UxCtopLevelShell1      *UxContext;
	static int		_Uxinit = 0;

	UxTopLevelShell1Context = UxContext =
		(_UxCtopLevelShell1 *) UxNewContext( sizeof(_UxCtopLevelShell1), False );


	if ( ! _Uxinit )
	{
		_UxIfClassId = UxNewInterfaceClassId();
		_Uxinit = 1;
	}

	rtrn = _Uxbuild_topLevelShell1();

	{
	
#ifdef VT
	    char environ[BUFSIZ];
	    char prog[BUFSIZ];
	    char path[BUFSIZ];
	    char *args[10];
	    int  argcnt = 0;
	    int  ttyfd = 0;
	    int  ptyfd = 0;
	    short  menuheight = 0;
	    XtVaGetValues(  menu1, XmNheight, &menuheight, NULL);
	    vt1 = XtVaCreateManagedWidget( "vt1",
			    xmVtWidgetClass, form1,
	                    XmNresponsive, True,
			    XmNbottomOffset, 10,
			    XmNbottomAttachment, XmATTACH_FORM,
			    XmNtopOffset, 10,
			    XmNtopAttachment, XmATTACH_WIDGET,
			    XmNtopWidget, UxGetWidget( menu1 ),
			    XmNrightOffset, 10,
			    XmNrightAttachment, XmATTACH_FORM,
			    XmNleftOffset, 10,
			    XmNleftAttachment, XmATTACH_FORM,
			    XmNheight, 460,
			    XmNwidth, 740,
			    XmNy, 30,
			    XmNx, 40,
	                    XmNmenuFile, ".ftpterm",
	                    XmNrootMenu, "FtpRootMenu",
			    NULL );
	
	    XmVtSyncSize( topLevelShell1, vt1, 10+menuheight, 10, 10, 10 );
	
	
	    XtAddCallback( vt1, XmNmonitorCallback,
			    monitorCB_vt1,
			    (XtPointer) NULL );
	
	    XtAddCallback( vt1, XmNoutputCallback,
			    outputCB_vt1,
			    (XtPointer) NULL );
	
	    XtAddCallback( vt1, XmNmessageCallback,
			    messageCB_vt1,
			    (XtPointer) NULL );
	
	    strcpy( path, COMMAND );
	    args[0] = "ftp";
	    args[1] = "-n";
	    args[2] = NULL;
	    incmd = procopen( path, args, NOUID, NOGID, &pid, &ttyfd, &ptyfd  );
	    XmVtMonitor( vt1, ptyfd, pid );
#endif
	    create_help_msg( topLevelShell1);
	    create_lfile_dialog( topLevelShell1);
	    create_file_dialog( topLevelShell1);
	    return(rtrn);
	}
}

/*******************************************************************************
       END OF FILE
*******************************************************************************/

