/**************************************************************************/
/* These routines might still work to interface to a serial line instead  */
/* of a pseudo terminal.                                                  */
/**************************************************************************/
set_modem( sline, save_state )
int sline;
struct termio *save_state;
{
    static struct termio tin;
    ioctl( sline, TCGETA, &tin );
    *save_state = tin;
    tin.c_lflag &= ~ECHO;
    tin.c_lflag &= ~ICANON;
    tin.c_lflag &= ~ISIG;
    tin.c_oflag &= ~ONLCR;
    tin.c_oflag &= ~OCRNL;
    tin.c_oflag &= ~ONOCR;
    tin.c_oflag |=  ONLRET;
    tin.c_iflag &= ~INLCR;
    tin.c_iflag &= ~ICRNL;
    tin.c_cc[VMIN] = 0;
    tin.c_cc[VTIME] = 0;
    ioctl( sline, TCSETA, &tin );
}

reset_modem( sline, save_state )
int sline;
struct termio *save_state;
{
    ioctl( sline, TCSETA, save_state );
}
