/*+****************************************************************************/
/*+                                                                           */
/*+ Copyright (c) 1992-1996 Bruce M. Corwin                                   */
/*+                                                                           */
/*+****************************************************************************/
/*+****************************************************************************/
/*+                                                                           */
/*+ Program ID:  Process Control Sub                                          */
/*+                                                                           */
/*+ Description: This system is a new widget called Vt it emulates a VTXXX    */
/*+              DEC style terminal plus many other special GUI type          */
/*+              functions that can make a text based application look like a */
/*+              full fledged Motif application.                              */
/*+                                                                           */
/*+ Entry Points: main()                                                      */
/*+                                                                           */
/*+ Input Parms:  None                                                        */
/*+                                                                           */
/*+ Exit Value:   None                                                        */
/*+                                                                           */
/*+ Input Files:  User Specified                                              */
/*+                                                                           */
/*+ Output Files: None                                                        */
/*+                                                                           */
/*+ Link Procedures: None                                                     */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+  02/16/96    Bruce M. Corwin  Initial Release                             */
/*+                                                                           */
/*+****************************************************************************/
/*+****************************************************************************/
/*+                                                                           */
/*+ Module Name: procopen.c                                                   */
/*+                                                                           */
/*+ Program ID:  Process Control Sub                                          */
/*+                                                                           */
/*+ Functions:  procopen                                                      */
/*+                                                                           */
/*+****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#if !defined(IG) && !defined(sun) && !defined(linux)
#include <sys/ptyio.h>
#endif
#include <fcntl.h>
#include <signal.h>
#include <termio.h>
#include <unistd.h>
#define FIRST      ( "ppppppppppppppppqqqq" )
#define SECOND     ( "0123456789abcdef0123" )
#define LOCSIZ     ( 16 )
#define NOFILE     ( 3 )
#define TRUE       ( -1 )
#define FALSE      ( 0 )
struct obuffer
{
    char data[BUFSIZ - 1];
};
typedef struct obuffer OBUFFER;
int child_stat = TRUE;
int ptyopenpid = 0;
extern int pty;
extern int ptypid;
extern char *ptydev;
extern char *ttydev;
extern char *xterm_name;

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: procopen                                                   */
/*+                                                                           */
/*+ Program ID:    Process Control Sub                                        */
/*+                                                                           */
/*+ Description: This library function is used to open a pseudo keyboard for  */
/*+              interface to an interactive process. In conjunction with the */
/*+              script function the UNIX script command can be written.      */
/*+                                                                           */
/*+ Parameters: path          - char *     - Path to a file.                  */
/*+             argv          - char *[]   - Arguments passed from UNIX       */
/*+             uid           - int        - UID value                        */
/*+             gid           - int        - GID value                        */
/*+             retpid        - int *      - Returned process Id for new      */
/*+                                          process.                         */
/*+             ttyfd         - int *      - TTY file descriptor.             */
/*+             ptyfd         - int *      - PTY file descriptor.             */
/*+                                                                           */
/*+ Input:      path, argv, uid, gid                                          */
/*+                                                                           */
/*+ Output:     retpid, ttyfd, ptyfd                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+  08-30-91    Bruce M. Corwin  Initial Release                             */
/*+  09-05-91    Bruce M. Corwin  Corrected search for valid pty              */
/*+                                                                           */
/*+****************************************************************************/
FILE *procopen (path, argv, uid, gid, retpid, ttyfd, ptyfd)
     char *path;
     char *argv[];
     int uid;
     int gid;
     int *retpid;
     int *ttyfd;
     int *ptyfd;
{
    int rcode = ptypid;
    ttydev = (char *) malloc (BUFSIZ);
    ptydev = (char *) malloc (BUFSIZ);
    xterm_name = (char *) malloc (BUFSIZ);
    strcpy (xterm_name, "vtwidget");
    child_stat = TRUE;
    signal (SIGCLD, SIG_IGN);
    spawn (path, argv, uid, gid);
    *ttyfd = open (ttydev, O_RDONLY);
    free (ttydev);
    free (ptydev);
    free (xterm_name);
    ptyopenpid = ptypid;
    *retpid = ptypid;
    *ptyfd = pty;
    return (fdopen (pty, "r+"));
}
