/*+****************************************************************************/
/*+                                                                           */
/*+ Copyright (c) 1995-1997 Bruce M. Corwin                                   */
/*+                                                                           */
/*+****************************************************************************/
/*+****************************************************************************/
/*+                                                                           */
/*+ Program ID:  vtclib                                                       */
/*+                                                                           */
/*+ Description: This program is used to demonstrate how vtclib is used to    */
/*+              write applications that access the Motif widget features and */
/*+              image features of the Vt widget.                             */
/*+                                                                           */
/*+ Entry Points: main()                                                      */
/*+                                                                           */
/*+ Input Parms:  None                                                        */
/*+                                                                           */
/*+ Exit Value:   None                                                        */
/*+                                                                           */
/*+ Input Files:  User Specified                                              */
/*+                                                                           */
/*+ Output Files: None                                                        */
/*+                                                                           */
/*+ Link Procedures: None                                                     */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 05-01-95    Bruce M. Corwin   Initial Release                             */
/*+                                                                           */
/*+****************************************************************************/
/*+****************************************************************************/
/*+                                                                           */
/*+ Module Name: browse.c                                                     */
/*+                                                                           */
/*+ Program ID:  vtclib                                                       */
/*+                                                                           */
/*+ Functions:  main, display_elements                                        */
/*+                                                                           */
/*+****************************************************************************/

#include <stdio.h>
#include "vtclib.h"
void display_elements ();


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: main                                                       */
/*+                                                                           */
/*+ Program ID:    vtclib                                                     */
/*+                                                                           */
/*+ Description: This routine initializes the vtwidget for managing widgets   */
/*+              without selection active or a border or the normal           */
/*+              scrollbar.                                                   */
/*+                                                                           */
/*+ Parameters: argc          - int        - Number of command line           */
/*+                                          parameters passed from the       */
/*+                                          invoking environment             */
/*+             argv          - char *[]   - Array of command line parameters */
/*+                                          passed from the invoking         */
/*+                                          environment                      */
/*+                                                                           */
/*+ Input:      argc, argv                                                    */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 05-01-95    Bruce M. Corwin   Initial Release                             */
/*+                                                                           */
/*+****************************************************************************/
main (argc, argv)
     int argc;
     char *argv[];
{
    int command = 0;
    char buffer[BUFSIZ];
    char filename[BUFSIZ];
    int width = 8;
    int height = 3;
    int rows = 0;
    int columns = 0;
    int cont = -1;

    manage_mode ();
    clear ();
    vtset ();
    wsize (&rows, &columns);
    create_widget (PUSHBUTTON, 'A', "Done", width, 2);
    create_widget (SCROLLEDLIST, 'B', "Text", columns, rows - height - 3);
    create_widget (SEPARATORH, 'C', "Sep", columns, 1);
    register_button ('A');
    display_elements (width, height);
    if (argc == 2)
    {
	strcpy (filename, argv[1]);
	append_list_file ('B', filename);
    }
    while (cont)
    {
	command = vtinput (buffer);
	switch (command)
	{
	    case QUIT:
		cont = 0;
		break;
	    case RESIZE:
		display_elements (width, height);
		break;
	    case 'A':
		cont = 0;
		break;
	}
    }
    destroy_all_widgets ();
    clear ();
    normal_mode ();
    return (0);
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: display_elements                                           */
/*+                                                                           */
/*+ Program ID:    vtclib                                                     */
/*+                                                                           */
/*+ Description: This routine is used to display all the nessesary widgets    */
/*+              for the demonstration application.                           */
/*+                                                                           */
/*+ Parameters: width         - int        - Number of columns the widget     */
/*+                                          will span.                       */
/*+             height        - int        - Number of rows the widget will   */
/*+                                          cover.                           */
/*+                                                                           */
/*+ Input:      width, height                                                 */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void display_elements (int width, int height)
{
    int rows = 0;
    int columns = 0;
    int middle = 0;
    int half = 0;

    wsize (&rows, &columns);
    middle = columns / 2;
    half = width / 2;
    resize_widget ('B', columns, rows - height - 3);
    resize_widget ('C', columns, 1);
    sleep (1);
    clear ();
    display_widget ('A', rows - height, middle - half);
    display_widget ('B', 0, 0);
    display_widget ('C', rows - height - 1, 1);
}
