/*+****************************************************************************/
/*+                                                                           */
/*+ Copyright (c) 1995-1997 Bruce M. Corwin                                   */
/*+                                                                           */
/*+****************************************************************************/
/*+****************************************************************************/
/*+                                                                           */
/*+ Module Name: vtedit.c                                                     */
/*+                                                                           */
/*+ Program ID:  vtclib                                                       */
/*+                                                                           */
/*+ Functions:  main, display_elements                                        */
/*+                                                                           */
/*+****************************************************************************/

#include <stdio.h>
#include "vtclib.h"
void display_elements ();


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: main                                                       */
/*+                                                                           */
/*+ Program ID:    vtclib                                                     */
/*+                                                                           */
/*+ Description: This routine initializes the vtwidget for managing widgets   */
/*+              without selection active or a border or the normal           */
/*+              scrollbar.                                                   */
/*+                                                                           */
/*+ Parameters: argc          - int        - Number of command line           */
/*+                                          parameters passed from the       */
/*+                                          invoking environment             */
/*+             argv          - char *[]   - Array of command line parameters */
/*+                                          passed from the invoking         */
/*+                                          environment                      */
/*+                                                                           */
/*+ Input:      argc, argv                                                    */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 05-01-95    Bruce M. Corwin   Initial Release                             */
/*+                                                                           */
/*+****************************************************************************/
main (argc, argv)
     int argc;
     char *argv[];
{
    int command = 0;
    char buffer[BUFSIZ];
    char filename[BUFSIZ];
    int width = 8;
    int height = 3;
    int rows = 0;
    int columns = 0;
    int cont = -1;
    char *dataload = NULL;
    int output = 0;
    FILE *outfile = NULL;
    int dcode = 0;

    manage_mode ();
    clear ();
    vtset ();
    wsize (&rows, &columns);
    create_widget (PUSHBUTTON, 'A', "Ok", width, 2);
    create_widget (PUSHBUTTON, 'B', "Cancel", width, 2);
    create_widget (PUSHBUTTON, 'C', "Help", width, 2);
    create_widget (PUSHBUTTON, 'F', "Load", width, 2);
    create_widget (SCROLLEDTEXT, 'D', "Text", columns, rows - height - 3);
    create_widget (SEPARATORHGADGET, 'E', "Sep", columns, 1);
    register_button ('A');
    register_button ('B');
    register_button ('C');
    register_button ('F');
    display_elements (width, height);
    if (argc == 2)
    {
	strcpy (filename, argv[1]);
	append_file ('D', filename);
    }
    else
    {
	strcpy (filename, "noname.txt");
    }
    while (cont)
    {
	command = vtinput (buffer);
	switch (command)
	{
	    case QUIT:
		cont = 0;
		break;
	    case RESIZE:
		display_elements (width, height);
		break;
	    case CANCEL:
		dialog_reset ();
		break;
	    case OK:
		dialog_reset ();
		break;
	    case HELP:
		dialog_reset ();
		break;
	    case FILEOK:
		if (strncmp (buffer, "FILEOK:", 7) == 0)
		{
		    strcpy (filename, buffer + 7);
		    append_file ('D', filename);
		}
		dialog_reset ();
		break;
	    case 'A':
		cont = 0;
		dump_text ('D', &dataload);
		output = -1;
		break;
	    case 'B':
		cont = 0;
		break;
	    case 'C':
		question_dialog
		    (
			"Information",
			"The vtedit command is a demonstration\\napplication written specificaly for\\nshowing how various XmVt Widget\\nfeatures can be utilized."
		    );
		break;
	    case 'F':
		file_dialog ("Load File");
		break;
	}
    }
    destroy_all_widgets ();
    clear ();
    normal_mode ();
    if (output && dataload != NULL)
    {
	outfile = fopen (filename, "w");
	if (outfile != NULL)
	{
	    fprintf (outfile, "%s", dataload);
	    fclose (outfile);
	}
	free (dataload);
    }
    return (0);
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: display_elements                                           */
/*+                                                                           */
/*+ Program ID:    vtclib                                                     */
/*+                                                                           */
/*+ Description: This routine is used to display all the nessesary widgets    */
/*+              for the demonstration application.                           */
/*+                                                                           */
/*+ Parameters: width         - int        - Number of columns the widget     */
/*+                                          will span.                       */
/*+             height        - int        - Number of rows the widget will   */
/*+                                          cover.                           */
/*+                                                                           */
/*+ Input:      width, height                                                 */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void display_elements (int width, int height)
{
    int rows = 0;
    int columns = 0;
    int middle = 0;
    int half = 0;

    wsize (&rows, &columns);
    middle = columns / 2;
    half = width / 2;
    resize_widget ('D', columns, rows - height - 3);
    resize_widget ('E', columns, 1);
    sleep (1);
    clear ();
    display_widget ('A', rows - height, middle - half - 15);
    display_widget ('B', rows - height, middle - half - 5);
    display_widget ('C', rows - height, middle - half + 5);
    display_widget ('F', rows - height, middle - half + 15);
    display_widget ('D', 0, 0);
    display_widget ('E', rows - height - 1, 1);
}
