/*+****************************************************************************/
/*+                                                                           */
/*+ Copyright (c) 1992-1997 Bruce M. Corwin                                   */
/*+                                                                           */
/*+****************************************************************************/
/*+****************************************************************************/
/*+                                                                           */
/*+ Program ID:  vtwidget                                                     */
/*+                                                                           */
/*+ Description: This system is a new widget called Vt it emulates a VTXXX    */
/*+              DEC style terminal plus many other special GUI type          */
/*+              functions that can make a text based application look like a */
/*+              full fledged Motif application.                              */
/*+                                                                           */
/*+ Entry Points: main()                                                      */
/*+                                                                           */
/*+ Input Parms:  None                                                        */
/*+                                                                           */
/*+ Exit Value:   None                                                        */
/*+                                                                           */
/*+ Input Files:  User Specified                                              */
/*+                                                                           */
/*+ Output Files: None                                                        */
/*+                                                                           */
/*+ Link Procedures: None                                                     */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 02/15/96    Bruce M. Corwin   Initial Release                             */
/*+                                                                           */
/*+****************************************************************************/
/*+****************************************************************************/
/*+                                                                           */
/*+ Module Name: Vt.c                                                         */
/*+                                                                           */
/*+ Program ID:  vtwidget                                                     */
/*+                                                                           */
/*+ Functions:  widget_child_dead, XmVtLoadIcon,                              */
/*+             XmVtMonitor, XmVtUnmonitor, checkfd,                          */
/*+             ok_update, ok_revive, revive_all,                             */
/*+             update_image, doblink, readready,                             */
/*+             writeready, XmVtWrite,                                        */
/*+             XmVtScrollBarSetValue, XmVtRead,                              */
/*+             XmVtFlush, XmVtSend, Initialize,                              */
/*+             StartTimers, StopTimers,                                      */
/*+             FontListToFirstFontStruct,                                    */
/*+             XmVtDropSiteCB, XmVtTransferProcCB,                           */
/*+             XmVtSyncSize, ObtainGraphicsContexts,                         */
/*+             OneGC, ChangeGCFont, ChangeGCSpecialFont,                     */
/*+             ChangeGCColors, ChangeGCSpecialColor,                         */
/*+             GetWidthFromColumns, GetXFromColumn,                          */
/*+             GetYFromRow, GetHeightFromRows,                               */
/*+             GetColumnsFromWidth, GetRowsFromHeight,                       */
/*+             GetRowFromY, GetColumnFromX, Redisplay,                       */
/*+             qtrim, qtrim2, string_set_attr, revive,                       */
/*+             DrawHighlight, UnDrawHighlight,                               */
/*+             DrawShadow, UnDrawShadow, SetValues,                          */
/*+             add_scrollbar, XmVtSBDragCB,                                  */
/*+             XmVtDialogCancelCB, XmVtDialogHelpCB,                         */
/*+             XmVtDialogOkCB,                                               */
/*+             XmVtFileSelectionDialogOkCB, XmVtSBDecCB,                     */
/*+             XmVtSBIncCB, XmVtSBPageIncCB,                                 */
/*+             XmVtSBPageDecCB, remove_scrollbar,                            */
/*+             change_colors, Destroy, XmVtLoadWidget,                       */
/*+             XmVtDumpTextChild, XmVtAppendTextChild,                       */
/*+             XmVtAppendListChild, XmVtPBActivate,                          */
/*+             XmVtTBActivate, XmVtTFActivate,                               */
/*+             XmVtBlankWidgets, XmVtChildSetValues,                         */
/*+             XmVtChildResize, XmVtLoadHyperData,                           */
/*+             XmVtLoadButtonData, StringInput,                              */
/*+             FocusInProc, FocusOutProc, Up, Down,                          */
/*+             PageDown, PageUp, Paste, PasteClipboard,                      */
/*+             CopyClipboard, XmVtCopy, XmVtPaste, p_cb,                     */
/*+             Motion, SelectArea, SendMouse,                                */
/*+             SelectWord, BeginFunction, ArmHyper,                          */
/*+             ExecHyper, EndFunction, convert_proc,                         */
/*+             transfer_done_proc, lose_ownership_proc,                      */
/*+             Resize, place_cursor, remove_cursor,                          */
/*+             plot, graphics_plot, XDrawEdge,                               */
/*+             widget_plot, protect,                                         */
/*+             unmanage_unpainted_widgets, make_lines,                       */
/*+             make_ukascii, beep, showgraphic,                              */
/*+             message_do, special_msg_do, send_keys,                        */
/*+             gethostaddr, convert_esc, change_width,                       */
/*+             answer, GeometryManager, InsertChild,                         */
/*+             ChangeManaged, Layout, ClearDeadSpace,                        */
/*+             DeleteChild                                                   */
/*+                                                                           */
/*+****************************************************************************/

/* ***************************************** */
/* Automaticaly created with the wsc         */
/* Widget Sub Classing compiler tool.        */
/*                                           */
/* Copyright (c) 1996 Bruce M. Corwin        */
/* ***************************************** */

#define XK_MISCELLANY ( -1 )
#include <Xm/XmP.h>
#include <Xm/Xm.h>
#include <Xm/CutPaste.h>
#ifdef DRAGDROP
#include <Xm/DragDrop.h>
#endif
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#define offset(field) XtOffsetOf(XmVtRec,field)
#include "VtP.h"

/* ****************************************** */
/* Extra TOP code for widget class C file     */
/* ****************************************** */

#include <X11/keysymdef.h>
#include <Xm/MessageB.h>
#include <Xm/ScrollBar.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/Text.h>
#include <Xm/List.h>
#include <Xm/ArrowB.h>
#include <Xm/ArrowBG.h>
#include <Xm/ToggleB.h>
#include <Xm/TextF.h>
#include <Xm/Separator.h>
#include <Xm/Command.h>
#include <Xm/FileSB.h>
#include <Xm/ScrolledW.h>
#include <Xm/PanedW.h>
#include <Xm/RowColumn.h>
#include <Xm/Frame.h>
#include <Xm/Scale.h>
#include <Xm/SelectioB.h>
#include <Xm/Form.h>
#include <Xm/SeparatoG.h>
#include <Xm/LabelG.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleBG.h>

#define MAIN
#include <sys/types.h>
#include <stddef.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <string.h>
#include <unistd.h>
#include <termios.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <signal.h>
#include <time.h>
#include "translations.h"
/***************************************************************/
/* End of include directives for this module.                  */
/***************************************************************/
/***************************************************************/
/* The following are the define directives for this module.    */
/***************************************************************/
#define NEED(x) (request_ge->request_mode & x)
#define  CHUNK           ( 256 )
#define  MAXKEY          ( 10 )
#define  ESC             ( 27 )
#define  MINX            ( 1 )
#define  MINY            ( 1 )
#define  MAXX            ( 80 )
#define  MAXY            ( 25 )
#define  C_ON            ( "ON" )
#define  C_OFF           ( "OFF" )
#define  DIALOG_CANCEL   ( "CANCEL\n" )
#define  DIALOG_OK       ( "OK\n" )
#define  DIALOG_HELP     ( "HELP\n" )
#define  CREATE          ( "+" )
#define  DESTROY         ( "-" )
#define  WRITEMODE       ( "w" )
#define  S_SAME          ( 0 )
#define  S_MOD           ( 1 )
#define  W_NORMAL        ( 0 )
#define  W_SCROLL        ( 1 )
#define  W_HSCROLL       ( 2 )

#define  NORMAL_GC       ( 0 )
#define  INVERTED_GC     ( 1 )
#define  ANSIWHITE_GC    ( 2 )
#define  ANSIDIM_GC      ( 3 )
#define  INVANSIWHITE_GC ( 4 )
#define  INVANSIDIM_GC   ( 5 )

#define  CS_USASCII      ( 0 )
#define  CS_LINES        ( 1 )
#define  CS_UKASCII      ( 2 )

#define  PUSHBUTTON              (  0 )
#define  LABEL                   (  1 )
#define  TEXT                    (  2 )
#define  SCROLLEDTEXT            (  3 )
#define  ARROWBUTTON             (  4 )
#define  LIST                    (  5 )
#define  SCROLLEDLIST            (  6 )
#define  TEXTFIELD               (  7 )
#define  SCROLLBAR               (  8 )
#define  SEPARATORV              (  9 )
#define  SEPARATORH              ( 10 )
#define  TOGGLEBUTTON            ( 11 )
#define  SEPARATORHGADGET        ( 12 )
#define  SEPARATORVGADGET        ( 13 )
#define  LABELGADGET             ( 15 )
#define  PUSHBUTTONGADGET        ( 16 )
#define  TOGGLEBUTTONGADGET      ( 17 )
#define  ARROWBUTTONGADGET       ( 18 )
#define  COMMAND                 ( 19 )
#define  FILESELECTIONBOX        ( 20 )
#define  SCROLLEDWINDOW          ( 21 )
#define  PANEDWINDOW             ( 22 )
#define  ROWCOLUMN               ( 23 )
#define  FRAME                   ( 24 )
#define  SCALE                   ( 25 )
#define  SELECTIONBOX            ( 26 )
#define  FORM                    ( 27 )
/***********************************************************************/
/* The following defines are used to determine the status of processes */
/***********************************************************************/
#define  NONE                    ( 0 )
#define  ACTIVE                  ( 1 )
#define  JUST_DIED               ( 2 )
/***********************************************************************/
/* End of status defines.                                              */
/***********************************************************************/
/***********************************************************************/
/* MAX_INSTANCES refers to the maximum number of process instances     */
/* that can be tracked by the Vt widget system.  Each time a process   */
/* is monitored one of these instances are used up.  This is a global  */
/* resource because of the nature of the signal system in UNIX.        */
/***********************************************************************/
#define  MAX_INSTANCES           ( 1000 )
/***************************************************************/
/* End of the define directives for this module.               */
/***************************************************************/
/***************************************************************/
/* The following are API calls provided to the screen.c module */
/***************************************************************/
void answer (XmVtWidget tw);
void showgraphic (XmVtWidget tw);
void place_cursor (XmVtWidget tw);
void remove_cursor (XmVtWidget tw);
void ok_update (XmVtWidget tw);
void ok_revive (XmVtWidget tw);
void beep (XmVtWidget tw);
void message_do (XmVtWidget tw);
void special_msg_do (XmVtWidget tw, char *inputdata);
char *convert_esc (char *string, char *addon);
void unmanage_unpainted_widgets (XmVtWidget tw);
int plot (XmVtWidget tw, char *pldata, attribute attr, char cset, int xcoord, int ycoord);
/***************************************************************/
/* End of API calls for screen.c                               */
/***************************************************************/
/*************************************************************/
/* The following are the API for an external screen.c module */
/*************************************************************/
extern int strcatch (char *buffer, int single);
extern int write_s (XmVtWidget tw, char *buffer, int count);
extern void init_data (XmVtWidget tw, int maxx_value, int maxy_value, int minx_value, int miny_value);
extern void resize_data (XmVtWidget tw, int maxx_value, int maxy_value);
extern void free_data (XmVtWidget tw);
extern void s_attr (XmVtWidget tw, int xc, int yc, attribute attr);
extern void s_data (XmVtWidget tw, int xc, int yc, int data);
extern void s_cset (XmVtWidget tw, int xc, int yc, int cset);
extern void s_flag (XmVtWidget tw, int xc, int yc, int flag);
extern int s_multi (XmVtWidget tw, char *buffer, int count);
extern attribute g_attr (XmVtWidget tw, int xc, int yc);
extern int g_data (XmVtWidget tw, int xc, int yc);
extern int g_cset (XmVtWidget tw, int xc, int yc);
extern int g_flag (XmVtWidget tw, int xc, int yc);
extern void s_copy (XmVtWidget tw, int dest, int src);
extern void s_modify (XmVtWidget tw, int line_pos);
extern void paint_data (XmVtWidget tw);
/*************************************************************/
/* End of screen.c API functions                             */
/*************************************************************/
/*************************************************************/
/* The following are external API functions for the library. */
/*************************************************************/
void XmVtLoadIcon (Widget cw, char identity, char *iname);
void XmVtMonitor (Widget cw, int fd, int input_pid);
void XmVtUnmonitor (Widget cw);
int XmVtWrite (Widget tw, char *buffer, int count);
int XmVtRead (Widget new_w, char *buffer, int count);
int XmVtSend (Widget tw, char *buffer);
Boolean XmVtPaste (Widget w);
Boolean XmVtCopy (Widget w, Time time);
void XmVtFlush (Widget tw);
int XmVtScrollBarSetValue (Widget new_w, int count);
void XmVtSyncSize (Widget ctw, Widget vtw, int top, int bot, int lf, int rt);
void XmVtBlankWidgets (Widget wid);
void XmVtAppendTextChild (Widget wid, char identity, char *extend);
void XmVtAppendListChild (Widget wid, char identity, char *extend);
void XmVtChildSetValues (Widget wid, char identity, char *res, char *val);
void XmVtChildResize (Widget wid, char identity, int columns, int rows);
void XmVtLoadWidget (Widget wid, char identity, char *name, int wtype, int char_width, int char_height);
void XmVtDumpTextChild (Widget wid, char identity, char *pre, char *post);
void XmVtExtendTextChild (Widget wid, char identity, char *extend);
void XmVtLoadHyperData (Widget wid, char identity, char *hyper_data);
void XmVtLoadButtonData (Widget wid, char identity, char *callback_data);
/*************************************************************/
/* End of library API functions                              */
/*************************************************************/
/*************************************************************/
/* The following are internal functions.                     */
/*************************************************************/
static void Initialize ();
static void ChangeManaged ();
static void InsertChild ();
static void DeleteChild ();
static XtGeometryResult GeometryManager ();
static void Redisplay ();
static void Destroy ();
static void Resize ();
static Boolean SetValues ();

static void Layout (XmVtWidget tw, Boolean notify_parent);
static void DrawShadow ();
static void UnDrawShadow ();
static void DrawHighlight ();
static void UnDrawHighlight ();
static void ClearDeadSpace ();
XFontStruct *FontListToFirstFontStruct (XmFontList font_list);
static void XmVtPBActivate ();
static void XmVtTBActivate ();
static void XmVtTFActivate ();
#ifdef DRAGDROP
static void XmVtDropSiteCB (Widget cw, XtPointer client_dat, XmDropProcCallbackStruct * callback);
static void XmVtTransferProcCB (Widget w, XtPointer closure, Atom * seltype, Atom * type, XtPointer value, unsigned long *length, int *format);
#endif
static void XDrawEdge (Display * display, Window win, GC bot_right, GC top_left, int depth, int xcoord, int ycoord, int width, int height);
static void XmVtDropDestroyCB (Widget w, XtPointer clientData, XtPointer callData);
void ObtainGraphicsContexts (XmVtWidget new, Widget tnew);
GC OneGC (Widget tnew, Pixel foreground, Pixel background, Font newfont);
void ChangeGCColors (XmVtWidget new);
void ChangeGCSpecialColor (XmVtWidget new);
void ChangeGCFont (XmVtWidget new);
void ChangeGCSpecialFont (XmVtWidget new);
Boolean update_image (Widget treq, XtIntervalId * id);
Boolean doblink (Widget treq, XtIntervalId * id);
static Boolean convert_proc (Widget w, Atom * selection, Atom * target, Atom * type_return, XtPointer * value_return, unsigned long *length_return, int *format_return);
static void lose_ownership_proc (Widget w, Atom * selection);
static void transfer_done_proc (Widget w, Atom * selection, Atom * target);
void revive (XmVtWidget tw);
static void add_scrollbar (XmVtWidget tw);
static void remove_scrollbar (XmVtWidget tw);
static void XmVtSBDecCB (Widget wgt, XtPointer cd, XtPointer cb);
static void XmVtSBIncCB (Widget wgt, XtPointer cd, XtPointer cb);
static void XmVtSBPageIncCB (Widget wgt, XtPointer cd, XtPointer cb);
static void XmVtSBPageDecCB (Widget wgt, XtPointer cd, XtPointer cb);
static void XmVtSBDragCB (Widget wgt, XtPointer cd, XtPointer cb);
static void XmVtDialogCancelCB (Widget wgt, XtPointer cd, XtPointer cb);
static void XmVtDialogHelpCB (Widget wgt, XtPointer cd, XtPointer cb);
static void XmVtDialogOkCB (Widget wgt, XtPointer cd, XtPointer cb);
static void XmVtFileSelectionDialogOkCB (Widget wgt, XtPointer cd, XtPointer cb);
static void StartTimers (Widget w);
static void StopTimers (Widget w);
void string_set_attr (attribute * attr, char *attr_list);
int graphics_plot (XmVtWidget tw, char *pldata, attribute attr, int xcoord, int ycoord);
void protect (XmVtWidget tw, int xc1, int yc1, int xc2, int yc2, attribute attr);
int revive_all (XmVtWidget tw);
void change_colors (XmVtWidget tw, char *rgb, int map, int mapping, int bintense, int screen_flag, int writing_flag);
void change_width (XmVtWidget tw, int scr_width);
void widget_child_dead (int signum);
int contig (XmVtWidget tw, int xcoo, int ycoo, attribute attr, int cset, char *pldata);
int make_lines (char *pldata);
int make_ukascii (char *pldata);
int GetXFromColumn (XmVtWidget new, int in_column);
int GetYFromRow (XmVtWidget new, int in_row);
int GetRowsFromHeight (XmVtWidget new);
int GetRowFromY (XmVtWidget new, int ycoord);
int GetColumnFromX (XmVtWidget new, int xcoord);
int GetColumnsFromWidth (XmVtWidget new);
int GetWidthFromColumns (XmVtWidget new);
int GetHeightFromRows (XmVtWidget new);
static void ActionExample ();
static void SendMouse ();
static void SelectArea ();
static void Motion ();
static void Paste ();
static void PasteClipboard ();
static void CopyClipboard ();
static void p_cb ();
static void BeginFunction ();
static void SelectWord ();
static void ArmHyper ();
static void ExecHyper ();
static void EndFunction ();
static void StringInput ();

static void PageUp ();
static void PageDown ();
static void Down ();
static void Up ();
static void FocusInProc ();
static void FocusOutProc ();

void qtrim (char *string);
Boolean checkfd (XmVtWidget tw, XtIntervalId * id);
int readready (int fd);
int writeready (int fd);
/*************************************************************/
/* End of internal functions                                 */
/*************************************************************/
/*************************************************************/
/* The following are global varables.                        */
/*************************************************************/
int widget_proc_cnt = 0;
Widget proc_instance[MAX_INSTANCES];
Atom COMPOUND_TEXT;
/*************************************************************/
/* End of global varables.                                   */
/*************************************************************/
/*************************************************************/
/* The following are external varables.                      */
/*************************************************************/
extern char *cmd;
extern char *Image;
extern int BitOffset;
extern int XC;
extern int YC;
extern int Pass;
/*************************************************************/
/* End of external varables.                                 */
/*************************************************************/
/*************************************************************/
/* The following are static structures.                      */
/*************************************************************/

static char *attr_list[] =
{
    "NORMAL",
    "BOLD",
    "DIM",
    "UNDERSCORE",
    "BLINK",
    "INVERSE",
    "CURSOR",
    "SELECT",
    "SPECIAL",
    "ARMED",
    "GRAPHICS",
    "WIDGET",
    "CURSOR2",
    "ANSI30",
    "ANSI31",
    "ANSI32",
    "ANSI33",
    "ANSI34",
    "ANSI35",
    "ANSI36",
    "ANSI37",
    "ANSI38",
    "ANSI39",
    "ANSI40",
    "ANSI41",
    "ANSI42",
    "ANSI43",
    "ANSI44",
    "ANSI45",
    "ANSI46",
    "ANSI47",
    NULL
};
static int attr_values[] =
{
    XmCR_VT_NORMAL,
    XmCR_VT_BOLD,
    XmCR_VT_DIM,
    XmCR_VT_UNDERSCORE,
    XmCR_VT_BLINK,
    XmCR_VT_INVERSE,
    XmCR_VT_CURSOR,
    XmCR_VT_SELECT,
    XmCR_VT_SPECIAL,
    XmCR_VT_ARMED,
    XmCR_VT_GRAPHICS,
    XmCR_VT_WIDGET,
    XmCR_VT_CURSOR2,
    XmCR_VT_ANSI30,
    XmCR_VT_ANSI31,
    XmCR_VT_ANSI32,
    XmCR_VT_ANSI33,
    XmCR_VT_ANSI34,
    XmCR_VT_ANSI35,
    XmCR_VT_ANSI36,
    XmCR_VT_ANSI37,
    XmCR_VT_ANSI38,
    XmCR_VT_ANSI39,
    XmCR_VT_ANSI40,
    XmCR_VT_ANSI41,
    XmCR_VT_ANSI42,
    XmCR_VT_ANSI43,
    XmCR_VT_ANSI44,
    XmCR_VT_ANSI45,
    XmCR_VT_ANSI46,
    XmCR_VT_ANSI47,
    256
};
static XtActionsRec actions[] =
{
    {"SendMouse", SendMouse},
    {"SelectArea", SelectArea},
    {"Paste", Paste},
    {"PasteClipboard", PasteClipboard},
    {"CopyClipboard", CopyClipboard},
    {"EndFunction", EndFunction},
    {"BeginFunction", BeginFunction},
    {"SelectWord", SelectWord},
    {"ArmHyper", ArmHyper},
    {"ExecHyper", ExecHyper},
    {"Motion", Motion},
    {"string", StringInput},
    {"self-insert", StringInput},
    {"PageUp", PageUp},
    {"PageDown", PageDown},
    {"Up", Up},
    {"Down", Down},
    {"FocusIn", FocusInProc},
    {"FocusOut", FocusOutProc},
};
static XmVtCallbackStruct info;
/* ********************************** */
/* End of extra code.                 */
/* ********************************** */

static XtResource resources[] =
{
    /* ************************************** */
    /* Normal Resources for the Defined Class */
    /* ************************************** */
    {
	XmNactivateCallback,
	XmCActivateCallback,
	XtRCallback,
	sizeof (XtPointer),
	offset (vt.activate_callback),
	XtRCallback,
	NULL
    },
    {
	XmNadjustCallback,
	XmCAdjustCallback,
	XtRCallback,
	sizeof (XtPointer),
	offset (vt.adjust_callback),
	XtRCallback,
	NULL
    },
    {
	XmNansi0Color,
	XmCAnsi0Color,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.ansi0_color),
	XtRString, "#000000"
    },
    {
	XmNansi10Color,
	XmCAnsi10Color,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.ansi10_color),
	XtRString, "#50FF50"
    },
    {
	XmNansi11Color,
	XmCAnsi11Color,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.ansi11_color),
	XtRString, "#FFFF50"
    },
    {
	XmNansi12Color,
	XmCAnsi12Color,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.ansi12_color),
	XtRString, "#5050FF"
    },
    {
	XmNansi13Color,
	XmCAnsi13Color,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.ansi13_color),
	XtRString, "#FF50FF"
    },
    {
	XmNansi14Color,
	XmCAnsi14Color,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.ansi14_color),
	XtRString, "#50FFFF"
    },
    {
	XmNansi15Color,
	XmCAnsi15Color,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.ansi15_color),
	XtRString, "#FFFFFF"
    },
    {
	XmNansi1Color,
	XmCAnsi1Color,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.ansi1_color),
	XtRString, "#A70000"
    },
    {
	XmNansi2Color,
	XmCAnsi2Color,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.ansi2_color),
	XtRString, "#00A700"
    },
    {
	XmNansi3Color,
	XmCAnsi3Color,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.ansi3_color),
	XtRString, "#A7A700"
    },
    {
	XmNansi4Color,
	XmCAnsi4Color,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.ansi4_color),
	XtRString, "#0000A7"
    },
    {
	XmNansi5Color,
	XmCAnsi5Color,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.ansi5_color),
	XtRString, "#A700A7"
    },
    {
	XmNansi6Color,
	XmCAnsi6Color,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.ansi6_color),
	XtRString, "#00A7A7"
    },
    {
	XmNansi7Color,
	XmCAnsi7Color,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.ansi7_color),
	XtRString, "#A7A7A7"
    },
    {
	XmNansi8Color,
	XmCAnsi8Color,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.ansi8_color),
	XtRString, "#505050"
    },
    {
	XmNansi9Color,
	XmCAnsi9Color,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.ansi9_color),
	XtRString, "#FF5050"
    },
    {
	XmNanswerBack,
	XmCAnswerBack,
	XmRString,
	sizeof (String),
	XtOffset (XmVtWidget, vt.answer_back),
	XtRString, "# Answer back string.\n"
    },
    {
	XmNapplication,
	XmCApplication,
	XmRString,
	sizeof (String),
	XtOffset (XmVtWidget, vt.application),
	XtRString, "vt"
    },
    {
	XmNarmedColor,
	XmCArmedColor,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.armed_color),
	XtRString, "LimeGreen"
    },
    {
	XmNblinkColor,
	XmCBlinkColor,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.blink_color),
	XtRString, "Green"
    },
    {
	XmNblinkCount,
	XmCBlinkCount,
	XmRInt,
	sizeof (int),
	XtOffset (XmVtWidget, vt.blink_count),
	XtRString, "400"
    },
    {
	XmNblinkCursor,
	XmCBlinkCursor,
	XmRBoolean,
	sizeof (Boolean),
	XtOffset (XmVtWidget, vt.blink_cursor),
	XtRImmediate,
	(XtPointer) True
    },
    {
	XmNblockBreakCount,
	XmCBlockBreakCount,
	XmRInt,
	sizeof (int),
	XtOffset (XmVtWidget, vt.block_break_count),
	XtRString, "100"
    },
    {
	XmNboldColor,
	XmCBoldColor,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.bold_color),
	XtRString, "White"
    },
    {
	XmNbuttonFilter,
	XmCButtonFilter,
	XmRString,
	sizeof (String),
	XtOffset (XmVtWidget, vt.button_filter),
	XtRString, "\\s"
    },
    {
	XmNchildrenTraversalOn,
	XmCChildrenTraversalOn,
	XmRBoolean,
	sizeof (Boolean),
	XtOffset (XmVtWidget, vt.children_traversal_on),
	XtRImmediate,
	(XtPointer) True
    },
    {
	XmNcleanupMonitored,
	XmCCleanupMonitored,
	XmRBoolean,
	sizeof (Boolean),
	XtOffset (XmVtWidget, vt.cleanup_monitored),
	XtRImmediate,
	(XtPointer) True
    },
    {
	XmNcolumns,
	XmCColumns,
	XmRInt,
	sizeof (int),
	XtOffset (XmVtWidget, vt.columns),
	XtRString, "80"
    },
    {
	XmNcursorAttribute,
	XmCCursorAttribute,
	XmRString,
	sizeof (String),
	XtOffset (XmVtWidget, vt.cursor_attribute),
	XtRString, "Cursor"
    },
    {
	XmNcursorColor,
	XmCCursorColor,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.cursor_color),
	XtRString, "Red"
    },
    {
	XmNcursorMode,
	XmCCursorMode,
	XmRBoolean,
	sizeof (Boolean),
	XtOffset (XmVtWidget, vt.cursor_mode),
	XtRImmediate,
	(XtPointer) True
    },
    {
	XmNcursorSpeed,
	XmCCursorSpeed,
	XmRInt,
	sizeof (int),
	XtOffset (XmVtWidget, vt.cursor_speed),
	XtRString, "20"
    },
    {
	XmNcutPaste,
	XmCCutPaste,
	XmRBoolean,
	sizeof (Boolean),
	XtOffset (XmVtWidget, vt.cut_paste),
	XtRImmediate,
	(XtPointer) True
    },
    {
	XmNdebug,
	XmCDebug,
	XmRBoolean,
	sizeof (Boolean),
	XtOffset (XmVtWidget, vt.debug),
	XtRImmediate,
	(XtPointer) False
    },
    {
	XmNdebugStdout,
	XmCDebugStdout,
	XmRBoolean,
	sizeof (Boolean),
	XtOffset (XmVtWidget, vt.debug_stdout),
	XtRImmediate,
	(XtPointer) True
    },
    {
	XmNdelonBSMode,
	XmCDelonBSMode,
	XmRBoolean,
	sizeof (Boolean),
	XtOffset (XmVtWidget, vt.delonBS_mode),
	XtRImmediate,
	(XtPointer) False
    },
    {
	XmNdimColor,
	XmCDimColor,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.dim_color),
	XtRString, "Grey"
    },
    {
	XmNdoubleFont,
	XmCDoubleFont,
	XmRFontList,
	sizeof (XmFontList),
	XtOffset (XmVtWidget, vt.double_font),
	XtRString, "-misc-fixed-medium-*-*-*-*-100-210-200-*-*-iso8859-1"
    },
    {
	XmNfont,
	XmCFont,
	XmRFontList,
	sizeof (XmFontList),
	XtOffset (XmVtWidget, vt.font),
	XtRString, "-misc-fixed-medium-*-*-*-*-100-100-100-*-*-iso8859-1"
    },
    {
	XmNgraphicsIdentity,
	XmCGraphicsIdentity,
	XmRString,
	sizeof (String),
	XtOffset (XmVtWidget, vt.graphics_identity),
	XtRString, "a"
    },
    {
	XmNhighlightThickness,
	XmCHighlightThickness,
	XmRDimension,
	sizeof (Dimension),
	XtOffset (XmVtWidget, vt.highlight_thickness),
	XtRString, "2"
    },
    {
	XmNhyperAttribute,
	XmCHyperAttribute,
	XmRString,
	sizeof (String),
	XtOffset (XmVtWidget, vt.hyper_attribute),
	XtRString, "Bold,UnderScore,Graphics,Ansi32"
    },
    {
	XmNhyperFilter,
	XmCHyperFilter,
	XmRString,
	sizeof (String),
	XtOffset (XmVtWidget, vt.hyper_filter),
	XtRString, "\\s"
    },
    {
	XmNiconBackgroundColor,
	XmCIconBackgroundColor,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.icon_background_color),
	XtRString, "White"
    },
    {
	XmNiconForegroundColor,
	XmCIconForegroundColor,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.icon_foreground_color),
	XtRString, "Black"
    },
    {
	XmNimageShadowThickness,
	XmCImageShadowThickness,
	XmRDimension,
	sizeof (Dimension),
	XtOffset (XmVtWidget, vt.image_shadow_thickness),
	XtRString, "2"
    },
    {
	XmNinsertMode,
	XmCInsertMode,
	XmRBoolean,
	sizeof (Boolean),
	XtOffset (XmVtWidget, vt.insert_mode),
	XtRImmediate,
	(XtPointer) False
    },
    {
	XmNmaxHistory,
	XmCMaxHistory,
	XmRInt,
	sizeof (int),
	XtOffset (XmVtWidget, vt.max_history),
	XtRString, "1000"
    },
    {
	XmNmenuFile,
	XmCMenuFile,
	XmRString,
	sizeof (String),
	XtOffset (XmVtWidget, vt.menu_file),
	XtRString, ".vtrc"
    },
    {
	XmNmessageCallback,
	XmCMessageCallback,
	XtRCallback,
	sizeof (XtPointer),
	offset (vt.message_callback),
	XtRCallback,
	NULL
    },
    {
	XmNmonitorCallback,
	XmCMonitorCallback,
	XtRCallback,
	sizeof (XtPointer),
	offset (vt.monitor_callback),
	XtRCallback,
	NULL
    },
    {
	XmNmonitorCount,
	XmCMonitorCount,
	XmRInt,
	sizeof (int),
	XtOffset (XmVtWidget, vt.monitor_count),
	XtRString, "5"
    },
    {
	XmNonlcrMode,
	XmCOnlcrMode,
	XmRBoolean,
	sizeof (Boolean),
	XtOffset (XmVtWidget, vt.onlcr_mode),
	XtRImmediate,
	(XtPointer) False
    },
    {
	XmNoutputCallback,
	XmCOutputCallback,
	XtRCallback,
	sizeof (XtPointer),
	offset (vt.output_callback),
	XtRCallback,
	NULL
    },
    {
	XmNrepaintCount,
	XmCRepaintCount,
	XmRInt,
	sizeof (int),
	XtOffset (XmVtWidget, vt.repaint_count),
	XtRString, "30"
    },
    {
	XmNresponsive,
	XmCResponsive,
	XmRBoolean,
	sizeof (Boolean),
	XtOffset (XmVtWidget, vt.responsive),
	XtRImmediate,
	(XtPointer) True
    },
    {
	XmNreverseColor,
	XmCReverseColor,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.reverse_color),
	XtRString, "Pink"
    },
    {
	XmNrootMenu,
	XmCRootMenu,
	XmRString,
	sizeof (String),
	XtOffset (XmVtWidget, vt.root_menu),
	XtRString, "VtRootMenu"
    },
    {
	XmNrows,
	XmCRows,
	XmRInt,
	sizeof (int),
	XtOffset (XmVtWidget, vt.rows),
	XtRString, "24"
    },
    {
	XmNscrollBarWidth,
	XmCScrollBarWidth,
	XmRDimension,
	sizeof (Dimension),
	XtOffset (XmVtWidget, vt.scroll_bar_width),
	XtRString, "15"
    },
    {
	XmNscrolled,
	XmCScrolled,
	XmRBoolean,
	sizeof (Boolean),
	XtOffset (XmVtWidget, vt.scrolled),
	XtRImmediate,
	(XtPointer) True
    },
    {
	XmNselectColor,
	XmCSelectColor,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.select_color),
	XtRString, "turquoise"
    },
    {
	XmNspecialColor,
	XmCSpecialColor,
	XmRPixel,
	sizeof (Pixel),
	XtOffset (XmVtWidget, vt.special_color),
	XtRString, "White"
    },
    {
	XmNspecialFont,
	XmCSpecialFont,
	XmRFontList,
	sizeof (XmFontList),
	XtOffset (XmVtWidget, vt.special_font),
	XtRString, "fixed"
    },
    {
	XmNundefinedIcon,
	XmCUndefinedIcon,
	XmRString,
	sizeof (String),
	XtOffset (XmVtWidget, vt.undefined_icon),
	XtRString, "xlogo32"
    },
    {
	XmNuseHostname,
	XmCUseHostname,
	XmRBoolean,
	sizeof (Boolean),
	XtOffset (XmVtWidget, vt.use_hostname),
	XtRImmediate,
	(XtPointer) True
    },
    {
	XmNuseScrollKeys,
	XmCUseScrollKeys,
	XmRBoolean,
	sizeof (Boolean),
	XtOffset (XmVtWidget, vt.use_scroll_keys),
	XtRImmediate,
	(XtPointer) True
    },
    {
	XmNuseShadow,
	XmCUseShadow,
	XmRBoolean,
	sizeof (Boolean),
	XtOffset (XmVtWidget, vt.use_shadow),
	XtRImmediate,
	(XtPointer) True
    },
    {
	XmNwideFont,
	XmCWideFont,
	XmRFontList,
	sizeof (XmFontList),
	XtOffset (XmVtWidget, vt.wide_font),
	XtRString, "-misc-fixed-medium-*-*-*-*-100-200-100-*-*-iso8859-1"
    },
    /* ************************************** */
    /* External resources for SuperClasses    */
    /* ************************************** */
    {
	XmNshadowThickness,
	XmCShadowThickness,
	XmRDimension,
	sizeof (Dimension),
	XtOffset (XmVtWidget, manager.shadow_thickness),
	XtRString, "2"
    },
    {
	XmNmarginWidth,
	XmCMarginWidth,
	XmRDimension,
	sizeof (Dimension),
	XtOffset (XmVtWidget, drawing_area.margin_width),
	XtRString, "2"
    },
    {
	XmNmarginHeight,
	XmCMarginHeight,
	XmRDimension,
	sizeof (Dimension),
	XtOffset (XmVtWidget, drawing_area.margin_height),
	XtRString, "2"
    },
};

XmVtClassRec xmVtClassRec =
{
    /* ***************************************** */
    /* Core Class methods and elements.          */
    /* ***************************************** */
    {
	(WidgetClass) & xmDrawingAreaClassRec,
	"XmVt",
	sizeof (XmVtRec),
	NULL,
	NULL,
	False,
	Initialize,
	NULL,
	XtInheritRealize,
	actions,
	XtNumber (actions),
	resources,
	XtNumber (resources),
	NULLQUARK,
	True,
	XtExposeCompressMultiple,
	True,
	False,
	Destroy,
	Resize,
	Redisplay,
	SetValues,
	NULL,
	XtInheritSetValuesAlmost,
	NULL,
	XtInheritAcceptFocus,
	XtVersion,
	NULL,
	defaultTranslations,
	XtInheritQueryGeometry,
	XtInheritDisplayAccelerator,
	NULL
    },
    /* ***************************************** */
    /* Composite Class methods and elements.     */
    /* ***************************************** */
    {
	GeometryManager,
	ChangeManaged,
	InsertChild,
	DeleteChild,
	NULL
    },
    /* ***************************************** */
    /* Constraint Class methods and elements.    */
    /* ***************************************** */
    {
	NULL,
	0,
	0,
	NULL,
	NULL,
	NULL,
	NULL
    },
    /* ***************************************** */
    /* Manager Class methods and elements.       */
    /* ***************************************** */
    {
	NULL,
	NULL,
	0,
	NULL,
	0,
	XmInheritParentProcess,
	NULL,
    },
    /* ***************************************** */
    /* DrawingArea Class methods and elements.   */
    /* ***************************************** */
    {
	NULL,
    },
};

WidgetClass xmVtWidgetClass = (WidgetClass) & xmVtClassRec;

/* ****************************************** */
/* Extra C code for widget class C file       */
/* ****************************************** */


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: widget_child_dead                                          */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is called by the signal handler for SIGCLD. It  */
/*+              sorts out which child to which widget has just died. It then */
/*+              sets the appropriate flag in the proper widget.              */
/*+                                                                           */
/*+ Parameters: signum        - int        - Signal number provided to the    */
/*+                                          signal handler by UNIX.          */
/*+                                                                           */
/*+ Input:      signum                                                        */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void widget_child_dead (int signum)
{
    int inx = 0;
    int tpd = 0;
    int wstat = 0;
    Boolean reinit = False;
    Widget local = NULL;
    XmVtWidget tw = (XmVtWidget) local;

    tpd = wait (&wstat);
    for (inx = 0; inx < widget_proc_cnt; inx++)
    {
	local = proc_instance[inx];
	if (local != NULL)
	{
	    tw = (XmVtWidget) local;
	    if (tpd != tw->vt.pid)
	    {
		tw->vt.child_stat = ACTIVE;
		reinit = True;
	    }
	    else
	    {
		tw->vt.child_stat = JUST_DIED;
		proc_instance[inx] = NULL;
	    }
	}
    }
    signal (SIGCLD, widget_child_dead);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtLoadIcon                                               */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is the normal method for programers to load an  */
/*+              icon file into a Pixmap. The identity is a single character  */
/*+              that when printed with an attribute of graphics will output  */
/*+              an entire icon image. An icon can be either a XBM file or    */
/*+              XPM (On Motif 2.0 or greater).                               */
/*+                                                                           */
/*+ Parameters: cw            - Widget     - Current Widget                   */
/*+             identity      - char       - Identity of the element. This is */
/*+                                          a single character that will     */
/*+                                          identify the element on the      */
/*+                                          screen.                          */
/*+             iname         - char *     - The name of the icon to load.    */
/*+                                                                           */
/*+ Input:      cw, identity, iname                                           */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void XmVtLoadIcon (Widget cw, char identity, char *iname)
{
    XmVtWidget tw = (XmVtWidget) cw;
    int inx = 0;
    int pos = -1;
    int found = 0;
    Window rt;
    int x = 0;
    int y = 0;
    unsigned int width = 0;
    unsigned int height = 0;
    unsigned int bw = 0;
    unsigned int depth = 0;
    Pixmap current;

    for (inx = 0; inx < tw->vt.image_count; inx++)
    {
	if (tw->vt.images[inx].identity == identity)
	{
	    current = tw->vt.images[inx].Pixmap;
	    XmDestroyPixmap (XtScreen (cw), current);
	    tw->vt.images[inx].width = 0;
	    tw->vt.images[inx].height = 0;
	    pos = inx;
	    break;
	}
    }
    current = XmGetPixmap
	(
	    XtScreen (cw), iname,
	    tw->vt.icon_foreground_color, tw->vt.icon_background_color
	);
    if (current != XmUNSPECIFIED_PIXMAP)
    {
	if (pos == -1)
	{
	    pos = tw->vt.image_count;
	    (tw->vt.image_count)++;
	}
	tw->vt.images[pos].Pixmap = current;
	XGetGeometry
	    (
		XtDisplay (cw), current,
		&rt, &x, &y, &width, &height,
		&bw, &depth
	    );
	tw->vt.images[pos].width = width;
	tw->vt.images[pos].height = height;
	tw->vt.images[pos].identity = identity;
    }
    else
    {
	XtWarning ("Icon sent to load is not loadable.");
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtMonitor                                                */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: XmVtMonitor is an externaly callable routine that is used to */
/*+              monitor a file descriptor that is connected to an open       */
/*+              pseudo terminal, socket or even a serial line device. It     */
/*+              properly sets up the periodic checks on the file descriptor  */
/*+              and sets up a handler for the death of children. A pid of    */
/*+              XmCR_VT_NOPID can be sent in to the input pid and this will  */
/*+              prevent any signal handling.                                 */
/*+                                                                           */
/*+ Parameters: cw            - Widget     - Current Widget                   */
/*+             fd            - int        - Input file descriptor            */
/*+             input_pid     - int        - Pid to monitor                   */
/*+                                                                           */
/*+ Input:      cw, fd, input_pid                                             */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void XmVtMonitor (cw, fd, input_pid)
     Widget cw;
     int fd;
     int input_pid;
{
    struct winsize arg;
    XmVtWidget tw = (XmVtWidget) cw;
    XtAppContext app_context;
    app_context = XtWidgetToApplicationContext (cw);
    tw->vt.iofd = fd;
    tw->vt.monitoring = True;
    tw->vt.pid = input_pid;
    if (input_pid != XmCR_VT_NOPID)
    {
	XmVtFlush (cw);
	tw->vt.child_stat = ACTIVE;
	proc_instance[widget_proc_cnt] = cw;
	widget_proc_cnt++;
	proc_instance[widget_proc_cnt] = NULL;
	signal (SIGCLD, widget_child_dead);
	arg.ws_col = tw->vt.columns;
	arg.ws_row = tw->vt.rows;
	arg.ws_xpixel = tw->core.width;
	arg.ws_ypixel = tw->core.height;
	ioctl (tw->vt.iofd, TIOCSWINSZ, &arg);
    }
    tw->vt.monitor_id = XtAppAddTimeOut
	(app_context, tw->vt.monitor_count, (XtTimerCallbackProc) checkfd, tw);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtUnmonitor                                              */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: XmVtUnmonitor is an externaly callable routine that is used  */
/*+              to end a monitoring activity on a Vt widget. If a process is */
/*+              presently being monitored that process is first sent a       */
/*+              SIGTERM signal as a friendly request for ending. If the      */
/*+              process is still present (as in the case of a shell like     */
/*+              /bin/ksh) a SIGKILL is then sent. Next the descriptor that   */
/*+              is being monitored is closed and set to the value of 0. Also */
/*+              the monitoring flag is set to False and the pid internal     */
/*+              resource is set to XmCR_VT_NOPID. At that point the monitor  */
/*+              callback list is called for any other clean up the           */
/*+              application might wish to perform.                           */
/*+                                                                           */
/*+ Parameters: cw            - Widget     - Current Widget                   */
/*+                                                                           */
/*+ Input:      cw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void XmVtUnmonitor (cw)
     Widget cw;
{
    struct winsize arg;
    XmVtWidget tw = (XmVtWidget) cw;
    XtAppContext app_context;
    app_context = XtWidgetToApplicationContext (cw);
    if (tw->vt.monitoring)
    {
	if (tw->vt.pid != XmCR_VT_NOPID)
	{
	    signal (SIGCLD, SIG_IGN);
	    kill (tw->vt.pid, SIGTERM);
	    sleep (1);
	    kill (tw->vt.pid, SIGKILL);
            signal (SIGCLD, widget_child_dead);
	}
	tw->vt.pid = XmCR_VT_NOPID;
	tw->vt.child_stat = NONE;
	tw->vt.monitoring = False;
	if (tw->vt.cleanup_monitored)
	    close (tw->vt.iofd);
	info.reason = XmCR_MONITOR_ABORT;
	info.data_buffer = NULL;
	info.data_count = 0;
	XmVtFlush ((Widget) tw);
	XtCallCallbacks ((Widget) tw, XmNmonitorCallback, &info);
    }
    XtRemoveTimeOut
	(tw->vt.monitor_id);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: checkfd                                                    */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is called whenever a free chunk of processing  */
/*+              time is available from the Xt event processing subsystem and */
/*+              when a file descipter is being monitored as a call to        */
/*+              XmVtMonitor. It checks the file descriptor to see if output  */
/*+              needs to be printed on the VT widget.                        */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+             id            - XtIntervalId *                                */
/*+                                        - Identity of interval             */
/*+                                                                           */
/*+ Input:      tw, id                                                        */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
Boolean checkfd (tw, id)
     XmVtWidget tw;
     XtIntervalId *id;
{
    int cnt = 0;
    int paint_count = 0;
    int chunk = CHUNK;
    char chout_str[BUFSIZ + 1];
    char chin_str[BUFSIZ];
    XtAppContext app_context;
    app_context = XtWidgetToApplicationContext ((Widget) tw);

    if (tw->vt.child_stat == JUST_DIED)
    {
	tw->vt.pid = XmCR_VT_NOPID;
	tw->vt.child_stat = NONE;
	tw->vt.monitoring = False;
	close (tw->vt.iofd);
	info.reason = XmCR_MONITOR_DONE;
	info.data_buffer = NULL;
	info.data_count = 0;
	XmVtFlush ((Widget) tw);
	XtCallCallbacks ((Widget) tw, XmNmonitorCallback, &info);
	return (False);
    }
    while (readready (tw->vt.iofd) == 1)
    {
	cnt = read (tw->vt.iofd, chout_str, BUFSIZ);
	if (cnt == -1 || cnt == 0)
	{
	    tw->vt.monitoring = False;
	    info.reason = XmCR_MONITOR_IOERR;
	    info.data_buffer = NULL;
	    info.data_count = 0;
	    XtCallCallbacks ((Widget) tw, XmNmonitorCallback, &info);
	    break;
	}
	else
	{
	    info.reason = XmCR_OUTPUT;
	    info.data_buffer = chout_str;
	    info.data_count = cnt;
	    XtCallCallbacks ((Widget) tw, XmNoutputCallback, &info);
	    XmVtWrite ((Widget) tw, chout_str, info.data_count);
	}
	paint_count++;
	if (paint_count == tw->vt.block_break_count)
	{
	    paint_count = 0;
	    break;
	}
    }
    if (tw->vt.keycount > 0 && writeready (tw->vt.iofd) == 1)
    {
	if (tw->vt.keycount < chunk)
	{
	    write (tw->vt.iofd, tw->vt.keybuffer, tw->vt.keycount);
	    XmVtFlush ((Widget) tw);
	}
	else
	{
	    write (tw->vt.iofd, tw->vt.keybuffer, chunk);
	    memcpy
		(
		    tw->vt.keybuffer,
		    tw->vt.keybuffer + chunk,
		    (tw->vt.keycount) - chunk + 1
		);
	    tw->vt.keycount = tw->vt.keycount - chunk;
	}
    }
    if (tw->vt.monitoring)
	tw->vt.monitor_id = XtAppAddTimeOut
	    (app_context, tw->vt.monitor_count, (XtTimerCallbackProc) checkfd, tw);
    return (tw->vt.monitoring);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: ok_update                                                  */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is called to authorize an update to the screen */
/*+              whenever the X system finds some extra time or imediately if */
/*+              smooth_mode is TRUE. If smooth_mode is FALSE, this does not  */
/*+              actualy perform the update to the screen, it just sets the   */
/*+              wheels in motion by setting the appropriate flag in the      */
/*+              widget. This is an API call for screen.c to use.             */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+                                                                           */
/*+ Input:      tw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void ok_update (tw)
     XmVtWidget tw;
{
    XtIntervalId *id = NULL;
    tw->vt.update_screen = True;
    if (tw->vt.smooth_mode)
    {
	revive_all (tw);
	paint_data (tw);
    }
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: ok_revive                                                  */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is called to OK a total revival of all          */
/*+              characters on the displayed screen. This is used when a      */
/*+              scroll has taken place. This causes the update_image routine */
/*+              to call revive_all. This is an API call that is used by      */
/*+              screen.c.                                                    */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+                                                                           */
/*+ Input:      tw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void ok_revive (tw)
     XmVtWidget tw;
{
    tw->vt.revive_all = True;
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: revive_all                                                 */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is used when there has been a scroll or        */
/*+              several scrolls that have taken place during a write. To     */
/*+              make the widget use its time best it will only mark all      */
/*+              screen bytes as modified only if a scroll has occured and it */
/*+              will only do this at the end of the write. To demonstrate,   */
/*+              consider a buffer full of line feeds. If the widget looped   */
/*+              the entire screen for each line feed there would be millions */
/*+              of iterations of the marking loop while, by using            */
/*+              revive_all, there is only a single marking of the entire     */
/*+              screen.                                                      */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+                                                                           */
/*+ Input:      tw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int revive_all (XmVtWidget tw)
{
    int jnx = 0;
    int inx = 0;
    for (jnx = tw->vt.real_miny; jnx <= tw->vt.real_maxy; jnx++)
    {
	s_modify (tw, jnx);
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: update_image                                               */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is called repeatedly whenever possible every    */
/*+              TOUT # of milliseconds. It repaints the screen to the        */
/*+              current state and places the cursor in the appropriate       */
/*+              coordinates. It then reschedules itself in another TOUT # of */
/*+              milliseconds.                                                */
/*+                                                                           */
/*+ Parameters: cw            - Widget     - Current Widget                   */
/*+             id            - XtIntervalId *                                */
/*+                                        - Identity of interval             */
/*+                                                                           */
/*+ Input:      cw, id                                                        */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
Boolean update_image (cw, id)
     Widget cw;
     XtIntervalId *id;
{
    XmVtWidget tw = (XmVtWidget) cw;
    XtAppContext app_context;
    int tout = tw->vt.repaint_count;

    if (tw->vt.revive_all)
    {
	revive_all (tw);
	tw->vt.revive_all = 0;
    }
    app_context = XtWidgetToApplicationContext (cw);
    tw->vt.update_id = XtAppAddTimeOut
	(app_context, tout, (XtTimerCallbackProc) update_image, cw);
    if (!tw->vt.hyper_started && tw->vt.update_screen)
    {
	tw->vt.update_screen = False;
	paint_data (tw);
    }
    if (tw->vt.cursor_mode)
    {
	if (tw->vt.blink_cursor && tw->manager.has_focus)
	{
	    if (tw->vt.scroll_value == 0)
	    {
		if (tw->vt.cursor_count > (tw->vt.cursor_speed) / 2)
		    place_cursor (tw);
		else
		    remove_cursor (tw);
	    }
	    tw->vt.cursor_count++;
	    if (tw->vt.cursor_count > tw->vt.cursor_speed)
		tw->vt.cursor_count = 0;
	}
	else
	{
	    place_cursor (tw);
	}
    }
    return (-1);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: doblink                                                    */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is called every 400 milliseconds or so (as     */
/*+              long as there is some processing time available) to toggle   */
/*+              the blink on blink type attribute characters on the screen.  */
/*+              It toggles the switch and then sets the modified switch on   */
/*+              all such characters on the screen. The routine plot will see */
/*+              these characters the next screen update and toggle their     */
/*+              images.                                                      */
/*+                                                                           */
/*+ Parameters: cw            - Widget     - Current Widget                   */
/*+             id            - XtIntervalId *                                */
/*+                                        - Identity of interval             */
/*+                                                                           */
/*+ Input:      cw, id                                                        */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
Boolean doblink (cw, id)
     Widget cw;
     XtIntervalId *id;
{
    XmVtWidget tw = (XmVtWidget) cw;
    XtAppContext app_context;
    int tout = tw->vt.blink_count;
    int xcoo = 0;
    int ycoo = 0;
    int blink_present = 0;

    app_context = XtWidgetToApplicationContext (cw);
    tw->vt.blink_id = XtAppAddTimeOut
	(app_context, tout, (XtTimerCallbackProc) doblink, cw);
    if (tw->vt.blink_toggle)
    {
	tw->vt.blink_toggle = False;
    }
    else
    {
	tw->vt.blink_toggle = True;
    }
    for (ycoo = 0; ycoo <= tw->vt.rows; ycoo++)
    {
	for (xcoo = 1; xcoo <= tw->vt.columns; xcoo++)
	{
	    if (isset (g_attr (tw, xcoo, ycoo), ATT_BLINK))
	    {
		s_flag (tw, xcoo, ycoo, S_MOD);
		blink_present = -1;
	    }
	}
    }
    if (blink_present)
	ok_update (tw);
    return (-1);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: readready                                                  */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function checks a file descriptor to find if it is      */
/*+              ready to be read from. This is used as a non-blocking mode   */
/*+              check on a file descriptor.                                  */
/*+                                                                           */
/*+ Parameters: fd            - int        - Input file descriptor            */
/*+                                                                           */
/*+ Input:      fd                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int readready (fd)
     int fd;
{
    fd_set readbits;
    struct timeval tout;
    int retval = 0;
    tout.tv_usec = 0;
    tout.tv_sec = 0;
    FD_ZERO (&readbits);
    FD_SET (fd, &readbits);
    retval = select (fd + 1, (int *) &readbits, 0, 0, &tout);
    return (retval);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: writeready                                                 */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function checks a file descriptor to find if it is      */
/*+              ready to be written to. This is used as a non-blocking mode  */
/*+              check on a file descriptor.                                  */
/*+                                                                           */
/*+ Parameters: fd            - int        - Input file descriptor            */
/*+                                                                           */
/*+ Input:      fd                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int writeready (fd)
     int fd;
{
    fd_set writebits;
    struct timeval tout;
    int retval = 0;
    tout.tv_usec = 0;
    tout.tv_sec = 0;
    FD_ZERO (&writebits);
    FD_SET (fd, &writebits);
    retval = select (fd + 1, 0, (int *) &writebits, 0, &tout);
    return (retval);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtWrite                                                  */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: XmVtWrite is an externaly callable routine that is used like */
/*+              the write system call except it accesses a XmVtWidget        */
/*+              instead of a file descriptor.                                */
/*+                                                                           */
/*+ Parameters: new_w         - Widget     - New Widget to Eval               */
/*+             buffer        - char *     - Buffer of output data            */
/*+             count         - int        - Count of characters to write     */
/*+                                                                           */
/*+ Input:      new_w, buffer, count                                          */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int XmVtWrite (Widget new_w, char *buffer, int count)
{
    int retval = 0;
    XmVtWidget tw = (XmVtWidget) new_w;
    if (tw->vt.scroll_value != 0)
    {
	XmVtScrollBarSetValue (new_w, 0);
	if (tw->vt.Vsbar != NULL)
	    XtVaSetValues (tw->vt.Vsbar, XmNvalue, 0, NULL);
    }
    retval = write_s (tw, buffer, count);
    return (retval);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtScrollBarSetValue                                      */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is used to set the scroll value of the VT      */
/*+              widget.                                                      */
/*+                                                                           */
/*+ Parameters: new_w         - Widget     - New Widget to Eval               */
/*+             scroll_value  - int        - Value to scroll                  */
/*+                                                                           */
/*+ Input:      new_w                                                         */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int XmVtScrollBarSetValue (Widget new_w, int scroll_value)
{
    XmVtWidget tw = (XmVtWidget) new_w;
    int xcoo = 1;
    int ycoo = 1;
    if (scroll_value > tw->vt.first_row)
	return (-1);;
    tw->vt.scroll_value = scroll_value;
    for (ycoo = 0; ycoo <= tw->vt.rows; ycoo++)
    {
	for (xcoo = 1; xcoo <= tw->vt.columns; xcoo++)
	{
	    s_flag (tw, xcoo, ycoo, S_MOD);
	}
    }
    ok_update (tw);
    return (scroll_value);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtRead                                                   */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: XmVtRead is an externaly callable routine that is used like  */
/*+              the read system call except it accesses a XmVtWidget instead */
/*+              of a file descriptor.                                        */
/*+                                                                           */
/*+ Parameters: new_w         - Widget     - New Widget to Eval               */
/*+             buffer        - char *     - Buffer of output data            */
/*+             count         - int        - Count of characters to write     */
/*+                                                                           */
/*+ Input:      new_w, buffer, count                                          */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int XmVtRead (Widget new_w, char *buffer, int count)
{
    int retval = 0;
    XmVtWidget tw = (XmVtWidget) new_w;
    char *tempbuffer = NULL;

    if (count > tw->vt.keycount)
    {
	memcpy (buffer, tw->vt.keybuffer, tw->vt.keycount);
	retval = tw->vt.keycount;
	tw->vt.keycount = 0;
	tw->vt.keybuffer[0] = 0;
    }
    else
    {
	tempbuffer = XtMalloc (tw->vt.keybuffer_size);
	strcpy (tempbuffer, tw->vt.keybuffer);
	memcpy (buffer, tw->vt.keybuffer, count);
	retval = count;
	strcpy (tw->vt.keybuffer, tempbuffer + count);
	tw->vt.keycount = strlen (tw->vt.keybuffer);
	XtFree (tempbuffer);
    }
    return (retval);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtFlush                                                  */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: XmVtFlush is an externaly callable routine that is used to   */
/*+              clear the keyboard buffer of all characters. This can be     */
/*+              used if a user would like to utilize the data in an Activate */
/*+              callback structure instead of using XmVtRead.                */
/*+                                                                           */
/*+ Parameters: new_w         - Widget     - New Widget to Eval               */
/*+                                                                           */
/*+ Input:      new_w                                                         */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void XmVtFlush (Widget new_w)
{
    XmVtWidget tw = (XmVtWidget) new_w;
    tw->vt.keybuffer[0] = 0;
    tw->vt.keycount = 0;
    return;
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtSend                                                   */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: XmVtSend is an externaly callable routine that is used to    */
/*+              send characters to the keyboard buffer manually. When this   */
/*+              is done the Activate callback is called.                     */
/*+                                                                           */
/*+ Parameters: receiver      - Widget     - Receiving Widget                 */
/*+             buffer        - char *     - Buffer of output data            */
/*+                                                                           */
/*+ Input:      receiver, buffer                                              */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int XmVtSend (Widget receiver, char *buffer)
{
    XmVtWidget cw = (XmVtWidget) receiver;
    int new_size = 0;
    if (strlen (cw->vt.keybuffer) + strlen (buffer) <= cw->vt.keybuffer_size - 1)
    {
	strcat (cw->vt.keybuffer, buffer);
	cw->vt.keycount = strlen (cw->vt.keybuffer);
    }
    else
    {
	new_size = strlen (cw->vt.keybuffer) + strlen (buffer) + 1;
	cw->vt.keybuffer = XtRealloc (cw->vt.keybuffer, new_size);
	strcat (cw->vt.keybuffer, buffer);
	cw->vt.keycount = strlen (cw->vt.keybuffer);
	cw->vt.keybuffer_size = new_size;
    }
    info.reason = XmCR_ACTIVATE;
    info.data_buffer = XtMalloc (strlen (buffer) + 1);
    strcpy (info.data_buffer, buffer);
    info.data_count = strlen (buffer);
    XtCallCallbacks (receiver, XmNactivateCallback, &info);
    XtFree (info.data_buffer);
    info.data_count = 0;
    return (0);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: Initialize                                                 */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: Initialize is used to intialize the screen data structures   */
/*+              and other XmVtWidget data structures.                        */
/*+                                                                           */
/*+ Parameters: treq          - Widget     - Requested Widget                 */
/*+             tnew          - Widget     - New Widget                       */
/*+             args          - ArgList    - Set of X arguments               */
/*+             num_args      - Cardinal * - Number of X arguments            */
/*+                                                                           */
/*+ Input:      treq, tnew, args, num_args                                    */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void Initialize (treq, tnew, args, num_args)
     Widget treq, tnew;
     ArgList args;
     Cardinal *num_args;
{
    Arg dropsite_args[10];
    Atom importList[10];
    char disp_value[BUFSIZ];
    char hostname[BUFSIZ];
    char temp[BUFSIZ];
    int inx = 0;
    char interp_value[BUFSIZ];
    XmVtWidget new = (XmVtWidget) tnew;
    Widget sw = NULL;
    int cwidth = 6;
    int ac = 0;
    int cheight = 13;
    int direction = 0;
    int ascent = 0;
    attribute new_attr = BLANK_ATTR;
    int descent = 0;
    char envstr[BUFSIZ];
    char *envadd = NULL;
    XCharStruct overall;
    XFontStruct *fstruct = NULL;
    Dimension reply_width = 0;
    Dimension reply_height = 0;
    XtGeometryResult result = XtGeometryYes;

    new->vt.dialog = NULL;
    new->vt.update_id = 0;
    new->vt.blink_id = 0;
    new->vt.monitor_id = 0;
    new->vt.internal_insert = False;
    new->vt.first_display = True;
    new->vt.oldrow = 0;
    new->vt.oldcolumn = 0;
    new->vt.last = 0;
    new->vt.menu_event_added = False;
    new->vt.dynamic_menu = NULL;
    new->vt.destroy_count = 0;
    new->vt.menu_count = 0;
    new->vt.popup_menu = NULL;
    new->vt.popup_destroy_list = NULL;

    new->vt.child_stat = NONE;
    new->vt.pid = XmCR_VT_NOPID;
    new->vt.monitoring = False;

    new->vt.keybuffer = XtMalloc (BUFSIZ);
    new->vt.keybuffer_size = BUFSIZ;

    /* ******************************************************************** */
    /* Sadly, the XmManager descended parent will never let me have Return, */
    /* Escape, and probably some other keys unless I remove its             */
    /* accelerators.  This is probably very bad form but it allows the Vt   */
    /* widget's own translations to work properly.                          */
    /* ******************************************************************** */
/*
   XtVaSetValues (XtParent (tnew), RES_CONVERT (XtNaccelerators, ""), NULL);
 */

    new->vt.keybuffer[0] = 0;
    new->vt.keycount = 0;
    new->vt.child_count = 0;
    new->vt.image_count = 0;
    new->vt.active_font = FontListToFirstFontStruct (new->vt.font);
    new->vt.active_wide_font = FontListToFirstFontStruct (new->vt.wide_font);
    new->vt.active_double_font = FontListToFirstFontStruct (new->vt.double_font);
    new->vt.active_special_font =
	FontListToFirstFontStruct (new->vt.special_font);
    fstruct = new->vt.active_font;
    cwidth = XTextWidth (fstruct, " ", 1);
    XTextExtents (fstruct, " ", 1, &direction, &ascent, &descent, &overall);
    cheight = ascent + descent;
    new->vt.cwidth = cwidth;
    new->vt.cheight = cheight;
    new->vt.cdescent = descent;
    new->vt.cascent = ascent;
    strcpy (disp_value, DisplayString (XtDisplay (new)));
    sprintf (envstr, "DISPLAY=%s", disp_value);
    envadd = (char *) malloc (strlen (envstr) + 1);
    strcpy (envadd, envstr);
    putenv (envadd);
    if (disp_value[0] == ':')
    {
	strcpy (temp, disp_value);
	if (new->vt.use_hostname)
	{
	    if (gethostname (hostname, BUFSIZ) == 0)
	    {
		sprintf (disp_value, "%s%s", hostname, temp);
	    }
	}
	else
	{
	    if (gethostaddr (hostname, BUFSIZ) == 0)
	    {
		sprintf (disp_value, "%s%s", hostname, temp);
	    }
	}
    }
    sprintf (envstr, "%s\n", disp_value);
    new->vt.report_message = (char *) malloc (strlen (envstr) + 1);
    strcpy (new->vt.report_message, envstr);
    if (new->vt.columns < 1)
	new->vt.columns = 1;
    if (new->vt.rows < 1)
	new->vt.rows = 1;
    new->core.width = GetWidthFromColumns (new);
    new->core.height = GetHeightFromRows (new);
    ObtainGraphicsContexts (new, tnew);
    new->vt.prev_max_history = new->vt.max_history;
    init_data (new, new->vt.columns, new->vt.rows, 1, 1);
    new->vt.cursor_count = 0;
    new->vt.update_screen = True;
    new->vt.override_focus_out = False;

    if (new->vt.delonBS_mode)
	XRebindKeysym
	    (
		XtDisplay (tnew),
		(KeySym) XK_BackSpace,
		(KeySym *) NULL,
		0, (unsigned char *) "\177", 1
	    );
    else
	XRebindKeysym
	    (
		XtDisplay (tnew),
		(KeySym) XK_BackSpace,
		(KeySym *) NULL,
		0, (unsigned char *) "\010", 1
	    );
    new->vt.selection = NULL;
    new->vt.selection_started = False;
    new->vt.hyper_started = False;
    string_set_attr (&new_attr, new->vt.hyper_attribute);
    new->vt.hyper_value = new_attr;

    if (new->vt.responsive)
	StartTimers (tnew);

/* Make this widget type a drop site. */
#ifdef DRAGDROP
    COMPOUND_TEXT = XmInternAtom (XtDisplay (tnew), "COMPOUND_TEXT", False);
    importList[0] = XmInternAtom (XtDisplay (tnew), "COMPOUND_TEXT", False);
    ac = 0;
    XtSetArg (dropsite_args[ac], XmNimportTargets, importList);
    ac++;
    XtSetArg (dropsite_args[ac], XmNnumImportTargets, 1);
    ac++;
    XtSetArg (dropsite_args[ac], XmNdropSiteOperations, XmDROP_COPY);
    ac++;
    XtSetArg (dropsite_args[ac], XmNdropProc, XmVtDropSiteCB);
    ac++;
    XtSetArg (dropsite_args[ac], XmNdropSiteType, XmDROP_SITE_COMPOSITE);
    ac++;
    XmDropSiteRegister (tnew, dropsite_args, ac);
#endif
    Layout (new, True);
    XmVtLoadPopup
	(tnew, new->vt.root_menu, new->vt.menu_file, new->vt.application);
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: StartTimers                                                */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is used to start two of the three Xt Timer     */
/*+              functions that service the Vt widget.                        */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+                                                                           */
/*+ Input:      w                                                             */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void StartTimers (Widget w)
{
    XmVtWidget tw = (XmVtWidget) w;
    int tout = tw->vt.repaint_count;
    int tout2 = tw->vt.blink_count;
    XtAppContext app_context;

    app_context = XtWidgetToApplicationContext (w);

    tw->vt.update_id = XtAppAddTimeOut
	(app_context, tout, (XtTimerCallbackProc) update_image, w);
    tw->vt.blink_id = XtAppAddTimeOut
	(app_context, tout2, (XtTimerCallbackProc) doblink, w);
    return;
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: StopTimers                                                 */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is used to stop two of the three Xt Timer      */
/*+              functions that service the Vt widget.                        */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+                                                                           */
/*+ Input:      w                                                             */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void StopTimers (Widget w)
{
    XmVtWidget tw = (XmVtWidget) w;

    if (tw->vt.update_id != 0)
	XtRemoveTimeOut
	    (tw->vt.update_id);
    if (tw->vt.blink_id != 0)
	XtRemoveTimeOut
	    (tw->vt.blink_id);
    tw->vt.update_id = 0;
    tw->vt.blink_id = 0;
    return;
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: FontListToFirstFontStruct                                  */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine obtains the first font structure from the       */
/*+              provided XmFontList data. It does not provide any other font */
/*+              data besides the first font structure.                       */
/*+                                                                           */
/*+ Parameters: font_list     - XmFontList - This is the font list to         */
/*+                                          examine.                         */
/*+                                                                           */
/*+ Input:      font_list                                                     */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
XFontStruct *FontListToFirstFontStruct (XmFontList font_list)
{
    XFontStruct *font;
    Boolean flag;
    Cardinal argcnt;
    Arg arg[10];
    XmFontContext font_context;
    XmStringCharSet charset;

    if (font_list == (XmFontList) NULL)
    {
	return ((XFontStruct *) NULL);
    }
    flag = XmFontListInitFontContext (&font_context, font_list);
    if (flag == False)
    {
	return ((XFontStruct *) NULL);
    }
    flag = XmFontListGetNextFont (font_context, &charset, &font);
    if (flag == False)
    {
	return ((XFontStruct *) NULL);
    }
    else
    {
	XmFontListFreeFontContext (font_context);
	free ((char *) charset);
	return (font);
    }
}
#ifdef DRAGDROP

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtDropSiteCB                                             */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This callback is called whenever a drag/drop operation       */
/*+              deposits data on the Vt widget.                              */
/*+                                                                           */
/*+ Parameters: cw            - Widget     - Current Widget                   */
/*+             client_dat    - XtPointer  - Client data passed to callback   */
/*+             callback      - XmDropProcCallbackStruct *                    */
/*+                                        - Callback data                    */
/*+                                                                           */
/*+ Input:      cw, client_dat, callback                                      */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void XmVtDropSiteCB (Widget cw, XtPointer client_dat, XmDropProcCallbackStruct * callback)
{
    XmVtWidget tw = (XmVtWidget) cw;
    Widget dragContext = callback->dragContext;
    XmDropTransferEntryRec transferEntries[10];
    XmDropTransferEntry transferList;
    Arg dargs[10];
    int ac = 0;

    if ((callback->dropAction != XmDROP) || (callback->operation != XmDROP_COPY))
    {
	XtSetArg (dargs[ac], XmNtransferStatus, XmTRANSFER_FAILURE);
	ac++;
    }
    else
    {
	transferEntries[0].target =
	    XmInternAtom (XtDisplay (cw), "COMPOUND_TEXT", False);
	transferEntries[0].client_data = (XtPointer) cw;
	transferList = transferEntries;
	XtSetArg (dargs[ac], XmNdropTransfers, transferEntries);
	ac++;
	XtSetArg (dargs[ac], XmNnumDropTransfers, 1);
	ac++;
	XtSetArg (dargs[ac], XmNtransferProc, XmVtTransferProcCB);
	ac++;
    }
    XmDropTransferStart (dragContext, dargs, ac);
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtTransferProcCB                                         */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine performs the actual transfer of data from the   */
/*+              drop to the keyboard input.                                  */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             closure       - XtPointer  - Input data from the drop. In     */
/*+                                          this case the parent vt widget.  */
/*+             seltype       - Atom *     - Selection type of transfer.      */
/*+             type          - Atom *     - Input type of data.              */
/*+             value         - XtPointer  - Value to paste                   */
/*+             length        - unsigned long *                               */
/*+                                        - Length of value data             */
/*+             format        - int *      - Format of data (8bits)           */
/*+                                                                           */
/*+ Input:      w, closure, seltype, type, value, length, format              */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void XmVtTransferProcCB (Widget w, XtPointer closure, Atom * seltype, Atom * type, XtPointer value, unsigned long *length, int *format)
{
    Arg args[10];
    int n;
    Boolean rc = False;
    Widget cw = (Widget) closure;

    /* Handle compound text type */
    if (*type == COMPOUND_TEXT)
    {
	XmVtSend (cw, (char *) value);
    }
    if (value)
	XtFree (value);
    return;
}
#endif

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtSyncSize                                               */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is used before the main application is         */
/*+              realized to coordinate its width and height with the VT      */
/*+              widgets columns and rows. This is very useful in cases where */
/*+              the VT widget is the main widget in the application and      */
/*+              should have a specified number of columns and rows for any   */
/*+              given font.                                                  */
/*+                                                                           */
/*+ Parameters: ctw           - Widget     - Current widget                   */
/*+             vtw           - Widget     - Current VT widget                */
/*+             top           - int        - Top offset                       */
/*+             bot           - int        - Bottom offset                    */
/*+             lf            - int        - Left offset                      */
/*+             rt            - int        - Right offset                     */
/*+                                                                           */
/*+ Input:      ctw, vtw, top, bot, lf, rt                                    */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void XmVtSyncSize (Widget ctw, Widget vtw, int top, int bot, int lf, int rt)
{
    int cwidth = 6;
    int cheight = 13;
    int width = 0;
    int height = 0;
    int direction = 0;
    int ascent = 0;
    int descent = 0;
    int columns = 0;
    int rows = 0;
    XCharStruct overall;
    XFontStruct *fstruct = NULL;
    XmVtWidget cw = (XmVtWidget) vtw;
    int extra_width = 0;

    if (cw->vt.scrolled)
	extra_width = cw->vt.scroll_bar_width;
    fstruct = cw->vt.active_font;
    cwidth = XTextWidth (fstruct, " ", 1);
    XTextExtents (fstruct, " ", 1, &direction, &ascent, &descent, &overall);
    cheight = ascent + descent;
    columns = cw->vt.columns;
    rows = cw->vt.rows;
    if (columns < 1)
	columns = 1;
    if (rows < 1)
	rows = 1;
    width = (columns) * (cwidth) +
	(cw->vt.highlight_thickness) * 2 +
	(cw->manager.shadow_thickness) * 2 +
	(cw->drawing_area.margin_width) * 2 +
	extra_width +
	lf + rt;
    height = (rows) * (cheight) +
	(cw->vt.highlight_thickness) * 2 +
	(cw->manager.shadow_thickness) * 2 +
	(cw->drawing_area.margin_height) * 2 + (cw->vt.cdescent) +
	top + bot;
    XtVaSetValues (ctw, XmNwidth, width, XmNheight, height, NULL);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: ObtainGraphicsContexts                                     */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is used to find all the needed Graphics        */
/*+              Contexts for the widget.                                     */
/*+                                                                           */
/*+ Parameters: new           - XmVtWidget - New Widget                       */
/*+             tnew          - Widget     - New Widget                       */
/*+                                                                           */
/*+ Input:      new, tnew                                                     */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void ObtainGraphicsContexts (XmVtWidget new, Widget tnew)
{
    XGCValues val_gc;
    XtGCMask mask_gc;
    int cwidth = 6;
    int direction = 0;
    int ascent = 0;
    int descent = 0;
    int overall = 0;
    Font tempfont;
    cwidth = XTextWidth (new->vt.active_special_font, " ", 1);
    XTextExtents
	(
	    (XFontStruct *) new->vt.active_special_font,
	    " ",
	    1,
	    &direction,
	    &ascent,
	    &descent,
	    (XCharStruct *) & overall
	);
    new->vt.normal_GC = OneGC (
				  tnew,
				  new->manager.foreground,
				  new->core.background_pixel,
				  (new->vt.active_font)->fid
	);
    new->vt.antinormal_GC = OneGC (
				      tnew,
				      new->core.background_pixel,
				      new->manager.foreground,
				      (new->vt.active_font)->fid
	);
    new->vt.armed_normal_GC = OneGC (
					tnew,
					new->vt.armed_color,
					new->core.background_pixel,
					(new->vt.active_font)->fid
	);
    new->vt.blink_GC = OneGC (
				 tnew,
				 new->vt.blink_color,
				 new->core.background_pixel,
				 (new->vt.active_font)->fid
	);
    new->vt.bold_GC = OneGC (
				tnew,
				new->vt.bold_color,
				new->core.background_pixel,
				(new->vt.active_font)->fid
	);
    new->vt.dim_GC = OneGC (
			       tnew,
			       new->vt.dim_color,
			       new->core.background_pixel,
			       (new->vt.active_font)->fid
	);
    new->vt.inverse_GC = OneGC (
				   tnew,
				   new->vt.reverse_color,
				   new->core.background_pixel,
				   (new->vt.active_font)->fid
	);
    new->vt.cursor_GC = OneGC (
				  tnew,
				  new->vt.cursor_color,
				  new->core.background_pixel,
				  (new->vt.active_font)->fid
	);
    new->vt.select_GC = OneGC (
				  tnew,
				  new->vt.select_color,
				  new->core.background_pixel,
				  (new->vt.active_font)->fid
	);
    if
	(
	    new->vt.cwidth == cwidth &&
	    new->vt.cdescent == descent &&
	    new->vt.cascent == ascent
	)
    {
	tempfont = (new->vt.active_special_font)->fid;
    }
    else
    {
	tempfont = (new->vt.active_font)->fid;
    }
    new->vt.special_GC = OneGC (
				   tnew,
				   new->vt.special_color,
				   new->core.background_pixel,
				   tempfont
	);
    new->vt.armed_special_GC = OneGC (
					 tnew,
					 new->vt.armed_color,
					 new->core.background_pixel,
					 tempfont
	);


/* ANSI Color GCs  */

    new->vt.ansi0_GC = OneGC (
				 tnew,
				 new->vt.ansi0_color,
				 new->core.background_pixel,
				 (new->vt.active_font)->fid
	);
    new->vt.ansi1_GC = OneGC (
				 tnew,
				 new->vt.ansi1_color,
				 new->core.background_pixel,
				 (new->vt.active_font)->fid
	);
    new->vt.ansi2_GC = OneGC (
				 tnew,
				 new->vt.ansi2_color,
				 new->core.background_pixel,
				 (new->vt.active_font)->fid
	);
    new->vt.ansi3_GC = OneGC (
				 tnew,
				 new->vt.ansi3_color,
				 new->core.background_pixel,
				 (new->vt.active_font)->fid
	);
    new->vt.ansi4_GC = OneGC (
				 tnew,
				 new->vt.ansi4_color,
				 new->core.background_pixel,
				 (new->vt.active_font)->fid
	);
    new->vt.ansi5_GC = OneGC (
				 tnew,
				 new->vt.ansi5_color,
				 new->core.background_pixel,
				 (new->vt.active_font)->fid
	);
    new->vt.ansi6_GC = OneGC (
				 tnew,
				 new->vt.ansi6_color,
				 new->core.background_pixel,
				 (new->vt.active_font)->fid
	);
    new->vt.ansi7_GC = OneGC (
				 tnew,
				 new->vt.ansi7_color,
				 new->core.background_pixel,
				 (new->vt.active_font)->fid
	);




    new->vt.ansi8_GC = OneGC (
				 tnew,
				 new->vt.ansi8_color,
				 new->core.background_pixel,
				 (new->vt.active_font)->fid
	);
    new->vt.ansi9_GC = OneGC (
				 tnew,
				 new->vt.ansi9_color,
				 new->core.background_pixel,
				 (new->vt.active_font)->fid
	);
    new->vt.ansi10_GC = OneGC (
				  tnew,
				  new->vt.ansi10_color,
				  new->core.background_pixel,
				  (new->vt.active_font)->fid
	);
    new->vt.ansi11_GC = OneGC (
				  tnew,
				  new->vt.ansi11_color,
				  new->core.background_pixel,
				  (new->vt.active_font)->fid
	);
    new->vt.ansi12_GC = OneGC (
				  tnew,
				  new->vt.ansi12_color,
				  new->core.background_pixel,
				  (new->vt.active_font)->fid
	);
    new->vt.ansi13_GC = OneGC (
				  tnew,
				  new->vt.ansi13_color,
				  new->core.background_pixel,
				  (new->vt.active_font)->fid
	);
    new->vt.ansi14_GC = OneGC (
				  tnew,
				  new->vt.ansi14_color,
				  new->core.background_pixel,
				  (new->vt.active_font)->fid
	);
    new->vt.ansi15_GC = OneGC (
				  tnew,
				  new->vt.ansi15_color,
				  new->core.background_pixel,
				  (new->vt.active_font)->fid
	);
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: OneGC                                                      */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine creates one GC for future use. This is called   */
/*+              for each GC used in the widget.                              */
/*+                                                                           */
/*+ Parameters: tnew          - Widget     - New Widget                       */
/*+             foreground    - Pixel      - This is the foreground Pixel for */
/*+                                          the new GC.                      */
/*+             background    - Pixel      - This is the background Pixel for */
/*+                                          the new GC.                      */
/*+             newfont       - Font       - This is the new font for the new */
/*+                                          GC.                              */
/*+                                                                           */
/*+ Input:      tnew, foreground, background, newfont                         */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
GC OneGC (Widget tnew, Pixel foreground, Pixel background, Font newfont)
{
    GC retval;
    XGCValues val_gc;
    XtGCMask mask_gc;
    val_gc.font = newfont;
    val_gc.function = GXcopy;
    val_gc.plane_mask = AllPlanes;
    val_gc.background = background;
    val_gc.foreground = foreground;
    val_gc.graphics_exposures = False;
    mask_gc = GCGraphicsExposures | GCFunction | GCPlaneMask | GCForeground | GCBackground | GCFont;
    retval = XCreateGC (
			   XtDisplay (tnew),
	    RootWindow (XtDisplay (tnew), DefaultScreen (XtDisplay (tnew))),
			   mask_gc,
			   &val_gc
	);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: ChangeGCFont                                               */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is called when a change to the VT font has     */
/*+              been made. This requires that all Graphics Contexts that use */
/*+              the font are changed accordingly.                            */
/*+                                                                           */
/*+ Parameters: new           - XmVtWidget - New Widget                       */
/*+                                                                           */
/*+ Input:      new                                                           */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void ChangeGCFont (XmVtWidget new)
{
    int cwidth = 6;
    int cheight = 13;
    int direction = 0;
    int ascent = 0;
    int descent = 0;
    XCharStruct overall;
    XFontStruct *fstruct = NULL;
    fstruct = new->vt.active_font;
    cwidth = XTextWidth (fstruct, " ", 1);
    XTextExtents (fstruct, " ", 1, &direction, &ascent, &descent, &overall);
    cheight = ascent + descent;
    new->vt.cwidth = cwidth;
    new->vt.cheight = cheight;
    new->vt.cdescent = descent;
    new->vt.cascent = ascent;
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.normal_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.antinormal_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.blink_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.bold_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.dim_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.inverse_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.cursor_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.select_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.armed_normal_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.ansi0_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.ansi1_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.ansi2_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.ansi3_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.ansi4_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.ansi5_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.ansi6_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.ansi7_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.ansi8_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.ansi9_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.ansi10_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.ansi11_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.ansi12_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.ansi13_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.ansi14_GC,
		 (new->vt.active_font)->fid
	);
    XSetFont (
		 XtDisplay ((Widget) new),
		 new->vt.ansi15_GC,
		 (new->vt.active_font)->fid
	);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: ChangeGCSpecialFont                                        */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is called when a change to the special VT font */
/*+              has been made. This requires that the special Graphics       */
/*+              Context that uses the font is changed accordingly.           */
/*+                                                                           */
/*+ Parameters: new           - XmVtWidget - New Widget                       */
/*+                                                                           */
/*+ Input:      new                                                           */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void ChangeGCSpecialFont (XmVtWidget new)
{
    int cwidth = 6;
    int cheight = 13;
    int direction = 0;
    int ascent = 0;
    int descent = 0;
    XCharStruct overall;
    XFontStruct *fstruct = NULL;
    fstruct = new->vt.active_special_font;
    cwidth = XTextWidth (fstruct, " ", 1);
    XTextExtents (fstruct, " ", 1, &direction, &ascent, &descent, &overall);
    if
	(
	    new->vt.cwidth == cwidth &&
	    new->vt.cdescent == descent &&
	    new->vt.cascent == ascent
	)
    {
	XSetFont (
		     XtDisplay ((Widget) new),
		     new->vt.special_GC,
		     (new->vt.active_special_font)->fid
	    );
	XSetFont (
		     XtDisplay ((Widget) new),
		     new->vt.armed_special_GC,
		     (new->vt.active_special_font)->fid
	    );
    }
    else
    {
	XSetFont (
		     XtDisplay ((Widget) new),
		     new->vt.special_GC,
		     (new->vt.active_font)->fid
	    );
	XSetFont (
		     XtDisplay ((Widget) new),
		     new->vt.armed_special_GC,
		     (new->vt.active_font)->fid
	    );
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: ChangeGCColors                                             */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is called whenever a change is made to one of  */
/*+              several colors defined in resources. Several of the Graphics */
/*+              Contexts have related colors. For instance, the inverse_GC   */
/*+              has the background pixel color set to the same value as the  */
/*+              normal_GC has for its foreground pixel color.                */
/*+                                                                           */
/*+ Parameters: new           - XmVtWidget - New Widget                       */
/*+                                                                           */
/*+ Input:      new                                                           */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void ChangeGCColors (XmVtWidget new)
{
    int save_fg = 0;
    save_fg = new->manager.foreground;
    XmChangeColor ((Widget) new, new->core.background_pixel);
    new->manager.foreground = save_fg;
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.normal_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.normal_GC,
		       new->manager.foreground
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.antinormal_GC,
		       new->manager.foreground
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.antinormal_GC,
		       new->core.background_pixel
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.blink_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.blink_GC,
		       new->vt.blink_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.bold_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.bold_GC,
		       new->vt.bold_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.dim_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.dim_GC,
		       new->vt.dim_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.inverse_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.inverse_GC,
		       new->vt.reverse_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.cursor_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.cursor_GC,
		       new->vt.cursor_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.select_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.select_GC,
		       new->vt.select_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.armed_special_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.armed_special_GC,
		       new->vt.armed_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.armed_normal_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.armed_normal_GC,
		       new->vt.armed_color
	);


/* ANSI Colors */


    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi0_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi0_GC,
		       new->vt.ansi0_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi1_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi1_GC,
		       new->vt.ansi1_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi2_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi2_GC,
		       new->vt.ansi2_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi3_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi3_GC,
		       new->vt.ansi3_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi4_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi4_GC,
		       new->vt.ansi4_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi5_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi5_GC,
		       new->vt.ansi5_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi6_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi6_GC,
		       new->vt.ansi6_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi7_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi7_GC,
		       new->vt.ansi7_color
	);

    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi8_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi8_GC,
		       new->vt.ansi8_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi9_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi9_GC,
		       new->vt.ansi9_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi10_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi10_GC,
		       new->vt.ansi10_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi11_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi11_GC,
		       new->vt.ansi11_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi12_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi12_GC,
		       new->vt.ansi12_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi13_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi13_GC,
		       new->vt.ansi13_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi14_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi14_GC,
		       new->vt.ansi14_color
	);
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi15_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.ansi15_GC,
		       new->vt.ansi15_color
	);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: ChangeGCSpecialColor                                       */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is specificaly used to change the colors of    */
/*+              the special font.                                            */
/*+                                                                           */
/*+ Parameters: new           - XmVtWidget - New Widget                       */
/*+                                                                           */
/*+ Input:      new                                                           */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void ChangeGCSpecialColor (XmVtWidget new)
{
    XSetBackground (
		       XtDisplay ((Widget) new),
		       new->vt.special_GC,
		       new->core.background_pixel
	);
    XSetForeground (
		       XtDisplay ((Widget) new),
		       new->vt.special_GC,
		       new->vt.special_color
	);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: GetWidthFromColumns                                        */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: GetWidthFromColumns is used to obtain an equivilent pixel    */
/*+              width of the widget from the number of columns. This is      */
/*+              usualy used to try to reset this width.                      */
/*+                                                                           */
/*+ Parameters: new           - XmVtWidget - New Widget                       */
/*+                                                                           */
/*+ Input:      new                                                           */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int GetWidthFromColumns (XmVtWidget new)
{
    int rvalue = 0;
    int extra_width = 0;

    if (new->vt.scrolled)
	extra_width = new->vt.scroll_bar_width;
    rvalue = (new->vt.columns) * (new->vt.cwidth) +
	(new->vt.highlight_thickness) * 2 +
	(new->manager.shadow_thickness) * 2 +
	(new->drawing_area.margin_width) * 2 + extra_width;
    return (rvalue);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: GetXFromColumn                                             */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine does the proper calculations to convert a       */
/*+              column value to an X pixel coordinate.                       */
/*+                                                                           */
/*+ Parameters: new           - XmVtWidget - New Widget                       */
/*+             in_column     - int        - Column to convert to a pixel X   */
/*+                                          coordinate                       */
/*+                                                                           */
/*+ Input:      new, in_column                                                */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int GetXFromColumn (XmVtWidget new, int in_column)
{
    int rvalue = 0;

    rvalue = (in_column - 1) * (new->vt.cwidth) +
	(new->vt.highlight_thickness) +
	(new->manager.shadow_thickness) +
	(new->drawing_area.margin_width);
    return (rvalue);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: GetYFromRow                                                */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine does the proper calculations to convert a row   */
/*+              value to an Y pixel coordinate.                              */
/*+                                                                           */
/*+ Parameters: new           - XmVtWidget - New Widget                       */
/*+             in_row        - int        - Row to convert to a pixel Y      */
/*+                                          coordinate                       */
/*+                                                                           */
/*+ Input:      new, in_row                                                   */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int GetYFromRow (XmVtWidget new, int in_row)
{
    int rvalue = 0;
    rvalue = (in_row - 1) * (new->vt.cheight) +
	(new->vt.highlight_thickness) +
	(new->manager.shadow_thickness) +
	(new->drawing_area.margin_height);
    return (rvalue);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: GetHeightFromRows                                          */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: GetHeightFromRows is used to obtain an equivilent pixel      */
/*+              height of the widget from the number of rows. This is usualy */
/*+              used to try to reset this height.                            */
/*+                                                                           */
/*+ Parameters: new           - XmVtWidget - New Widget                       */
/*+                                                                           */
/*+ Input:      new                                                           */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int GetHeightFromRows (XmVtWidget new)
{
    int rvalue = 0;
    rvalue = (new->vt.rows) * (new->vt.cheight) +
	(new->vt.highlight_thickness) * 2 +
	(new->manager.shadow_thickness) * 2 +
	(new->drawing_area.margin_height) * 2 + (new->vt.cdescent);
    return (rvalue);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: GetColumnsFromWidth                                        */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: GetColumnsFromWidth is used to obtain the number of          */
/*+              appropriate columns for the widget derived from the pixel    */
/*+              width.                                                       */
/*+                                                                           */
/*+ Parameters: cw            - XmVtWidget - Current Widget                   */
/*+                                                                           */
/*+ Input:      cw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int GetColumnsFromWidth (XmVtWidget cw)
{
    int rvalue = 0;
    int extra_width = 0;

    if (cw->vt.scrolled)
	extra_width = cw->vt.scroll_bar_width;
    rvalue = (
		 cw->core.width -
		 2 * (cw->vt.highlight_thickness) -
		 2 * (cw->manager.shadow_thickness) -
		 2 * (cw->drawing_area.margin_width) -
		 extra_width
	) / (cw->vt.cwidth);
    if (rvalue < 1)
	rvalue = 1;
    return (rvalue);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: GetRowsFromHeight                                          */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: GetRowsFromHeight is used to obtain the number of            */
/*+              appropriate rows for the widget derived from the pixel       */
/*+              height.                                                      */
/*+                                                                           */
/*+ Parameters: cw            - XmVtWidget - Current Widget                   */
/*+                                                                           */
/*+ Input:      cw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int GetRowsFromHeight (XmVtWidget cw)
{
    int rvalue = 0;
    rvalue = (
		 cw->core.height -
		 2 * (cw->vt.highlight_thickness) -
		 2 * (cw->manager.shadow_thickness) -
		 2 * (cw->drawing_area.margin_height)
	) / (cw->vt.cheight);
    if (rvalue < 1)
	rvalue = 1;
    return (rvalue);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: GetRowFromY                                                */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine does the proper calculations to convert a Y     */
/*+              coordinate pixel to a character screen row value.            */
/*+                                                                           */
/*+ Parameters: cw            - XmVtWidget - Current Widget                   */
/*+             ycoord        - int        - Y coordinate                     */
/*+                                                                           */
/*+ Input:      cw, ycoord                                                    */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int GetRowFromY (XmVtWidget cw, int ycoord)
{
    int rvalue = 0;
    rvalue = (
		 ycoord -
		 cw->vt.highlight_thickness -
		 cw->manager.shadow_thickness -
		 cw->drawing_area.margin_height
	) / (cw->vt.cheight) + 1;
    if (rvalue < cw->vt.real_miny)
	rvalue = cw->vt.real_miny;
    if (rvalue > cw->vt.real_maxy)
	rvalue = cw->vt.real_maxy;
    return (rvalue);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: GetColumnFromX                                             */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine does the proper calculations to convert an X    */
/*+              coordinate pixel to a character screen column value.         */
/*+                                                                           */
/*+ Parameters: cw            - XmVtWidget - Current Widget                   */
/*+             xcoord        - int        - X coordinate                     */
/*+                                                                           */
/*+ Input:      cw, xcoord                                                    */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int GetColumnFromX (XmVtWidget cw, int xcoord)
{
    int rvalue = 0;
    rvalue = (
		 xcoord -
		 cw->vt.highlight_thickness -
		 cw->manager.shadow_thickness -
		 cw->drawing_area.margin_width
	) / (cw->vt.cwidth) + 1;
    if (rvalue < cw->vt.real_minx)
	rvalue = cw->vt.real_minx;
    if (rvalue > cw->vt.real_maxx)
	rvalue = cw->vt.real_maxx;
    return (rvalue);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: Redisplay                                                  */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: Redisplay is used to redisplay the XmVtWidget after being    */
/*+              covered.                                                     */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             event         - XEvent *   - X event for situation            */
/*+             region        - Region     - This is the region that has been */
/*+                                          exposed.                         */
/*+                                                                           */
/*+ Input:      w, event, region                                              */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void Redisplay (w, event, region)
     Widget w;
     XEvent *event;
     Region region;
{
    Widget sb;
    struct winsize arg;
    Cursor local_cursor;
    XmVtWidget cw = (XmVtWidget) w;
    if (XtIsRealized (cw))
    {
	sb = cw->vt.Vsbar;
	if (cw->vt.first_display)
	{
	    /* Add a scrollbar if necessary */
	    if (cw->vt.scrolled)
	    {
		add_scrollbar (cw);
		sb = cw->vt.Vsbar;
	    }
	    local_cursor = XCreateFontCursor (XtDisplay (w), XC_xterm);
	    XDefineCursor (XtDisplay (w), XtWindow (w), local_cursor);
	    cw->vt.first_display = False;
	}
	revive (cw);
	ok_update (cw);
	if (cw->vt.use_shadow)
	{
	    if (cw->manager.has_focus)
		DrawHighlight (cw);
	    else
		UnDrawHighlight (cw);
	    DrawShadow (cw);
	}
	else
	{
	    UnDrawShadow (cw);
	    UnDrawHighlight (cw);
	}
/* ******************************************** */
/* I am not sure the _Xm type functions will be */
/* supported in later versions of Motif.        */
/* An ifdef may be required to use the new Xme  */
/* type functions.                              */
/* ******************************************** */
	_XmRedisplayGadgets
	    (
		w,
		event,
		region
	    );
    }
    return;
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: qtrim                                                      */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is used to trim white space characters from the */
/*+              end of a string.                                             */
/*+                                                                           */
/*+ Parameters: string        - char *     - This is the input string to      */
/*+                                          single space.                    */
/*+                                                                           */
/*+ Input:      string                                                        */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void qtrim (string)
     char *string;
{
    int inx = 0;
    for (inx = strlen (string) - 1; inx >= 0 && isspace (string[inx]); inx--)
	string[inx] = 0;
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: qtrim2                                                     */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is used to trim only the space character from   */
/*+              the end of a string.                                         */
/*+                                                                           */
/*+ Parameters: string        - char *     - This is the input string to      */
/*+                                          single space.                    */
/*+                                                                           */
/*+ Input:      string                                                        */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void qtrim2 (string)
     char *string;
{
    int inx = 0;
    for (inx = strlen (string) - 1; inx >= 0 && string[inx] == ' '; inx--)
	string[inx] = 0;
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: string_set_attr                                            */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function translates a string of attributes into a value */
/*+              to bitwise OR into an attribute varable. This is used for    */
/*+              instance to set the Hyperattribute resource from string      */
/*+              values.                                                      */
/*+                                                                           */
/*+ Parameters: attr          - attribute *                                   */
/*+                                        - Type of characters               */
/*+             attr_data     - char *     - Attribute data in string format. */
/*+                                                                           */
/*+ Input:      attr, attr_data                                               */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void string_set_attr (attribute * attr, char *attr_data)
{
    attribute vtclr_attr = BLANK_ATTR;
    int inx = 0;
    int jnx = 0;
    char buffer[BUFSIZ];
    char *tmp = NULL;
    for (inx = 0; inx < strlen (attr_data); inx++)
    {
	if (!isspace (attr_data[inx]))
	    buffer[jnx++] = toupper (attr_data[inx]);
    }
    buffer[jnx] = 0;
    tmp = strtok (buffer, ",");
    while (tmp != NULL)
    {
	inx = 0;
	while (attr_list[inx] != NULL)
	{
	    if (strcmp (tmp, attr_list[inx]) == 0)
		set (attr, attr_values[inx]);
	    if (strcmp (tmp, "NORMAL") == 0)
		*attr = vtclr_attr;
	    inx++;
	}
	tmp = strtok (NULL, ",");
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: revive                                                     */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function revives any character on the screen that is    */
/*+              visible. This is done for a redisplay.                       */
/*+                                                                           */
/*+ Parameters: cw            - XmVtWidget - Current Widget                   */
/*+                                                                           */
/*+ Input:      cw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void revive (XmVtWidget cw)
{
    int xcoo = 1;
    int ycoo = 1;
    for (ycoo = 1; ycoo <= cw->vt.maxy; ycoo++)
    {
	for (xcoo = 1; xcoo <= cw->vt.maxx; xcoo++)
	{
	    if
		(
		    (
			isany (g_attr (cw, xcoo, ycoo)) ||
			g_data (cw, xcoo, ycoo) != ' '
		    )
		)
	    {
		s_flag (cw, xcoo, ycoo, S_MOD);
	    }
	}
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: DrawHighlight                                              */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: DrawHighlight draws the highlight for the current            */
/*+              XmVtWidget.                                                  */
/*+                                                                           */
/*+ Parameters: cw            - XmVtWidget - Current Widget                   */
/*+                                                                           */
/*+ Input:      cw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void DrawHighlight (cw)
     XmVtWidget cw;
{
    unsigned int width = 0;
    unsigned int height = 0;
    unsigned int inside = 0;
    unsigned int start = 0;
    unsigned int c1x = 0;
    unsigned int c1y = 0;
    unsigned int c2x = 0;
    unsigned int c2y = 0;
    unsigned int c3x = 0;
    unsigned int c3y = 0;
    unsigned int c4x = 0;
    unsigned int c4y = 0;
    width = cw->core.width;
    height = cw->core.height;
    start = 0;
    for (inside = start; inside < cw->vt.highlight_thickness + start; inside++)
    {
	c1x = inside;
	c1y = inside;
	c2x = width - inside - 1;
	c2y = inside;
	c3x = width - inside - 1;
	c3y = height - inside - 1;
	c4x = inside;
	c4y = height - inside - 1;
	XDrawLine (
		      XtDisplay (cw),
		      XtWindow (cw),
		      cw->manager.highlight_GC,
		      c1x, c1y, c2x, c2y
	    );
	XDrawLine (
		      XtDisplay (cw),
		      XtWindow (cw),
		      cw->manager.highlight_GC,
		      c1x, c1y, c4x, c4y
	    );
	XDrawLine (
		      XtDisplay (cw),
		      XtWindow (cw),
		      cw->manager.highlight_GC,
		      c2x, c2y, c3x, c3y
	    );
	XDrawLine (
		      XtDisplay (cw),
		      XtWindow (cw),
		      cw->manager.highlight_GC,
		      c3x, c3y, c4x, c4y
	    );
    }
    return;
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: UnDrawHighlight                                            */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: UnDrawHighlight removes the highlight for the current        */
/*+              XmVtWidget.                                                  */
/*+                                                                           */
/*+ Parameters: cw            - XmVtWidget - Current Widget                   */
/*+                                                                           */
/*+ Input:      cw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void UnDrawHighlight (cw)
     XmVtWidget cw;
{
    unsigned int width = 0;
    unsigned int height = 0;
    unsigned int inside = 0;
    unsigned int start = 0;
    unsigned int c1x = 0;
    unsigned int c1y = 0;
    unsigned int c2x = 0;
    unsigned int c2y = 0;
    unsigned int c3x = 0;
    unsigned int c3y = 0;
    unsigned int c4x = 0;
    unsigned int c4y = 0;
    width = cw->core.width;
    height = cw->core.height;
    start = 0;
    for (inside = start; inside < cw->vt.highlight_thickness + start; inside++)
    {
	c1x = inside;
	c1y = inside;
	c2x = width - inside - 1;
	c2y = inside;
	c3x = width - inside - 1;
	c3y = height - inside - 1;
	c4x = inside;
	c4y = height - inside - 1;
	XDrawLine (
		      XtDisplay (cw),
		      XtWindow (cw),
		      cw->manager.background_GC,
		      c1x, c1y, c2x, c2y
	    );
	XDrawLine (
		      XtDisplay (cw),
		      XtWindow (cw),
		      cw->manager.background_GC,
		      c1x, c1y, c4x, c4y
	    );
	XDrawLine (
		      XtDisplay (cw),
		      XtWindow (cw),
		      cw->manager.background_GC,
		      c2x, c2y, c3x, c3y
	    );
	XDrawLine (
		      XtDisplay (cw),
		      XtWindow (cw),
		      cw->manager.background_GC,
		      c3x, c3y, c4x, c4y
	    );
    }
    return;
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: DrawShadow                                                 */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: DrawShadow redraws the shadow for the current XmVtWidget.    */
/*+                                                                           */
/*+ Parameters: cw            - XmVtWidget - Current Widget                   */
/*+                                                                           */
/*+ Input:      cw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void DrawShadow (cw)
     XmVtWidget cw;
{
    unsigned int width = 0;
    unsigned int height = 0;
    unsigned int inside = 0;
    unsigned int start = 0;
    unsigned int c1x = 0;
    unsigned int c1y = 0;
    unsigned int c2x = 0;
    unsigned int c2y = 0;
    unsigned int c3x = 0;
    unsigned int c3y = 0;
    unsigned int c4x = 0;
    unsigned int c4y = 0;
    width = cw->core.width;
    height = cw->core.height;
    start = cw->vt.highlight_thickness;
    for (inside = start; inside < cw->manager.shadow_thickness + start; inside++)
    {
	c1x = inside;
	c1y = inside;
	c2x = width - inside - 1;
	c2y = inside;
	c3x = width - inside - 1;
	c3y = height - inside - 1;
	c4x = inside;
	c4y = height - inside - 1;
	XDrawLine (
		      XtDisplay (cw),
		      XtWindow (cw),
		      cw->manager.bottom_shadow_GC,
		      c1x, c1y, c2x, c2y
	    );
	XDrawLine (
		      XtDisplay (cw),
		      XtWindow (cw),
		      cw->manager.bottom_shadow_GC,
		      c1x, c1y, c4x, c4y
	    );
	XDrawLine (
		      XtDisplay (cw),
		      XtWindow (cw),
		      cw->manager.top_shadow_GC,
		      c2x, c2y, c3x, c3y
	    );
	XDrawLine (
		      XtDisplay (cw),
		      XtWindow (cw),
		      cw->manager.top_shadow_GC,
		      c3x, c3y, c4x, c4y
	    );
    }
    return;
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: UnDrawShadow                                               */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: UnDrawShadow removes the shadow for the current XmVtWidget.  */
/*+              This is useful for prototyping gui user interfaces using the */
/*+              escape sequences. It removes a distracting border if one is  */
/*+              not desired.                                                 */
/*+                                                                           */
/*+ Parameters: cw            - XmVtWidget - Current Widget                   */
/*+                                                                           */
/*+ Input:      cw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void UnDrawShadow (cw)
     XmVtWidget cw;
{
    unsigned int width = 0;
    unsigned int height = 0;
    unsigned int inside = 0;
    unsigned int start = 0;
    unsigned int c1x = 0;
    unsigned int c1y = 0;
    unsigned int c2x = 0;
    unsigned int c2y = 0;
    unsigned int c3x = 0;
    unsigned int c3y = 0;
    unsigned int c4x = 0;
    unsigned int c4y = 0;
    width = cw->core.width;
    height = cw->core.height;
    start = cw->vt.highlight_thickness;
    for (inside = start; inside < cw->manager.shadow_thickness + start; inside++)
    {
	c1x = inside;
	c1y = inside;
	c2x = width - inside - 1;
	c2y = inside;
	c3x = width - inside - 1;
	c3y = height - inside - 1;
	c4x = inside;
	c4y = height - inside - 1;
	XDrawLine (
		      XtDisplay (cw),
		      XtWindow (cw),
		      cw->manager.background_GC,
		      c1x, c1y, c2x, c2y
	    );
	XDrawLine (
		      XtDisplay (cw),
		      XtWindow (cw),
		      cw->manager.background_GC,
		      c1x, c1y, c4x, c4y
	    );
	XDrawLine (
		      XtDisplay (cw),
		      XtWindow (cw),
		      cw->manager.background_GC,
		      c2x, c2y, c3x, c3y
	    );
	XDrawLine (
		      XtDisplay (cw),
		      XtWindow (cw),
		      cw->manager.background_GC,
		      c3x, c3y, c4x, c4y
	    );
    }
    return;
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: SetValues                                                  */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: SevValues is called whenever the user application needs to   */
/*+              change any resources.                                        */
/*+                                                                           */
/*+ Parameters: current       - Widget     - Current Widget                   */
/*+             request       - Widget     - Requested Widget                 */
/*+             new           - Widget     - New Widget                       */
/*+             args          - ArgList    - Set of X arguments               */
/*+             num_args      - Cardinal * - Number of X arguments            */
/*+                                                                           */
/*+ Input:      new, args, num_args                                           */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static Boolean SetValues (current, request, new, args, num_args)
     Widget current, request, new;
     ArgList args;
     Cardinal *num_args;
{
    XmVtWidget curcw = (XmVtWidget) current;
    XmVtWidget newcw = (XmVtWidget) new;
    Boolean do_redisplay = False;
    attribute new_attr = BLANK_ATTR;
    Boolean do_layout = False;


    if (curcw->vt.responsive != newcw->vt.responsive)
    {
	if (newcw->vt.responsive)
	    StartTimers (new);
	else
	    StopTimers (new);
    }

    if (curcw->vt.root_menu != newcw->vt.root_menu)
    {
	do_redisplay = False;
	XmVtUnloadPopup (new);
	XmVtLoadPopup
	    (
		new, newcw->vt.root_menu, newcw->vt.menu_file,
		newcw->vt.application
	    );
    }
    if (curcw->vt.menu_file != newcw->vt.menu_file)
    {
	do_redisplay = False;
	XmVtUnloadPopup (new);
	XmVtLoadPopup
	    (
		new, newcw->vt.root_menu, newcw->vt.menu_file,
		newcw->vt.application
	    );
    }
    if (curcw->vt.hyper_attribute != newcw->vt.hyper_attribute)
    {
	do_redisplay = False;
	string_set_attr (&new_attr, newcw->vt.hyper_attribute);
	newcw->vt.hyper_value = new_attr;
    }
    if (curcw->vt.font != newcw->vt.font)
    {
	do_redisplay = True;
	newcw->vt.active_font = FontListToFirstFontStruct (newcw->vt.font);
	ChangeGCFont (newcw);
	ChangeGCSpecialFont (newcw);
	do_layout = True;
    }
    if (curcw->vt.special_font != newcw->vt.special_font)
    {
	do_redisplay = True;
	newcw->vt.active_special_font =
	    FontListToFirstFontStruct (newcw->vt.special_font);
	ChangeGCSpecialFont (newcw);
    }
    if (curcw->vt.wide_font != newcw->vt.wide_font)
    {
	do_redisplay = True;
	newcw->vt.active_wide_font =
	    FontListToFirstFontStruct (newcw->vt.wide_font);
    }
    if (curcw->vt.double_font != newcw->vt.double_font)
    {
	do_redisplay = True;
	newcw->vt.active_double_font =
	    FontListToFirstFontStruct (newcw->vt.double_font);
    }
    if (curcw->manager.foreground != newcw->manager.foreground)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
	do_layout = True;
    }
    if (curcw->core.background_pixel != newcw->core.background_pixel)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
	ChangeGCSpecialColor ((XmVtWidget) new);
	do_layout = True;
    }
    if (curcw->vt.reverse_color != newcw->vt.reverse_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.blink_color != newcw->vt.blink_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.bold_color != newcw->vt.bold_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.dim_color != newcw->vt.dim_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.cursor_color != newcw->vt.cursor_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.select_color != newcw->vt.select_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.special_color != newcw->vt.special_color)
    {
	do_redisplay = True;
	ChangeGCSpecialColor ((XmVtWidget) new);
    }
    if (curcw->vt.armed_color != newcw->vt.armed_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.ansi0_color != newcw->vt.ansi0_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.ansi1_color != newcw->vt.ansi1_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.ansi2_color != newcw->vt.ansi2_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.ansi3_color != newcw->vt.ansi3_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.ansi4_color != newcw->vt.ansi4_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.ansi5_color != newcw->vt.ansi5_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.ansi6_color != newcw->vt.ansi6_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.ansi7_color != newcw->vt.ansi7_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.ansi8_color != newcw->vt.ansi8_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.ansi9_color != newcw->vt.ansi9_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.ansi10_color != newcw->vt.ansi10_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.ansi11_color != newcw->vt.ansi11_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.ansi12_color != newcw->vt.ansi12_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.ansi13_color != newcw->vt.ansi13_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.ansi14_color != newcw->vt.ansi14_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.ansi15_color != newcw->vt.ansi15_color)
    {
	do_redisplay = True;
	ChangeGCColors ((XmVtWidget) new);
    }
    if (curcw->vt.icon_foreground_color != newcw->vt.icon_foreground_color)
    {
	do_redisplay = True;
    }
    if (curcw->vt.icon_background_color != newcw->vt.icon_background_color)
    {
	do_redisplay = True;
    }
    if (curcw->vt.delonBS_mode != newcw->vt.delonBS_mode)
    {
	if (newcw->vt.delonBS_mode)
	    XRebindKeysym
		(
		    XtDisplay (new),
		    (KeySym) XK_BackSpace,
		    (KeySym *) NULL,
		    0, (unsigned char *) "\177", 1
		);
	else
	    XRebindKeysym
		(
		    XtDisplay (new),
		    (KeySym) XK_BackSpace,
		    (KeySym *) NULL,
		    0, (unsigned char *) "\010", 1
		);
    }
    if (curcw->vt.use_shadow != newcw->vt.use_shadow)
    {
	if (newcw->vt.use_shadow)
	{
	    do_redisplay = True;
	}
	else
	{
	    UnDrawShadow (newcw);
	    UnDrawHighlight (newcw);
	}
    }
    if (curcw->vt.highlight_thickness != newcw->vt.highlight_thickness)
    {
	do_redisplay = True;
	do_layout = True;
    }
    if (curcw->manager.shadow_thickness != newcw->manager.shadow_thickness)
    {
	do_redisplay = True;
	do_layout = True;
    }
    if (curcw->vt.scrolled != newcw->vt.scrolled)
    {
	do_redisplay = True;
	do_layout = False;
	if (newcw->vt.scrolled)
	{
	    add_scrollbar (newcw);
	}
	else
	{
	    remove_scrollbar (newcw);
	}
    }
    if (curcw->vt.scroll_bar_width != newcw->vt.scroll_bar_width)
    {
	do_redisplay = True;
	do_layout = True;
    }
    if (curcw->vt.columns != newcw->vt.columns)
    {
	do_redisplay = True;
	do_layout = True;
    }
    if (curcw->vt.rows != newcw->vt.rows)
    {
	do_redisplay = True;
	do_layout = True;
    }
    if (curcw->vt.max_history != newcw->vt.max_history)
    {
	do_redisplay = True;
	do_layout = True;
    }
    if (do_layout)
	Layout (newcw, True);
    return do_redisplay;
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: add_scrollbar                                              */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is called when the SetValues or Initialize     */
/*+              find that the scrolled flag is set to true. It creates a     */
/*+              scroll bar on the right side of the Vt widget. It also sets  */
/*+              up all of the internal callbacks.                            */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+                                                                           */
/*+ Input:      tw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void add_scrollbar (XmVtWidget tw)
{
    Dimension xpos = 0;
    Widget w;
    Cursor local_cursor = NULL;

    tw->vt.internal_insert = True;
    xpos = tw->core.width -
	tw->vt.highlight_thickness -
	tw->vt.scroll_bar_width;
    tw->vt.Vsbar = XtVaCreateManagedWidget
	(
	    "vt_scrollbar",
	    xmScrollBarWidgetClass,
	    (Widget) tw,
	    XmNx, xpos,
	    XmNy, tw->vt.highlight_thickness + 1,
	    XmNtraversalOn, False,
	    XmNpageIncrement, tw->vt.rows,
	    XmNnavigationType, XmTAB_GROUP,
	    XmNforeground, tw->manager.foreground,
	    XmNbackground, tw->core.background_pixel,
	    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
	    XmNtopShadowColor, tw->manager.top_shadow_color,
	    XmNwidth, tw->vt.scroll_bar_width,
	  XmNheight, tw->core.height - (2 * tw->vt.highlight_thickness) - 2,
	    XmNsliderSize, tw->vt.rows,
	    XmNmaximum, tw->vt.max_history + tw->vt.rows,
	    XmNvalue, 0,
	    XmNprocessingDirection, XmMAX_ON_TOP,
	    NULL
	);
    XtAddCallback
	(
	    tw->vt.Vsbar, XmNdecrementCallback,
	    (XtCallbackProc) XmVtSBDecCB,
	    (XtPointer) tw
	);
    XtAddCallback
	(
	    tw->vt.Vsbar, XmNincrementCallback,
	    (XtCallbackProc) XmVtSBIncCB,
	    (XtPointer) tw
	);
    XtAddCallback
	(
	    tw->vt.Vsbar, XmNpageIncrementCallback,
	    (XtCallbackProc) XmVtSBIncCB,
	    (XtPointer) tw
	);
    XtAddCallback
	(
	    tw->vt.Vsbar, XmNpageDecrementCallback,
	    (XtCallbackProc) XmVtSBIncCB,
	    (XtPointer) tw
	);
    XtAddCallback
	(
	    tw->vt.Vsbar, XmNdragCallback,
	    (XtCallbackProc) XmVtSBIncCB,
	    (XtPointer) tw
	);
    if (tw->vt.scrolled)
    {
	local_cursor =
	    XCreateFontCursor (XtDisplay (tw->vt.Vsbar), XC_left_ptr);
	XDefineCursor
	    (XtDisplay (tw->vt.Vsbar), XtWindow (tw->vt.Vsbar), local_cursor);
    }
    tw->vt.internal_insert = False;
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtSBDragCB                                               */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is used as the Drag callback to the internal   */
/*+              scrollbar.                                                   */
/*+                                                                           */
/*+ Parameters: wgt           - Widget     - Input widget to callback.        */
/*+             cd            - XtPointer  - Client data.                     */
/*+             cb            - XtPointer  - Callback data.                   */
/*+                                                                           */
/*+ Input:      wgt, cd, cb                                                   */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void XmVtSBDragCB (Widget wgt, XtPointer cd, XtPointer cb)
{
    int value = 0;
    int slider_size = 0;
    int increment = 0;
    int page_increment = 0;
    Widget vt1 = XtParent (wgt);
    XmVtWidget tw = (XmVtWidget) vt1;

    tw->vt.override_focus_out = True;
    XmScrollBarGetValues (
			     wgt,
			     &value,
			     &slider_size,
			     &increment,
			     &page_increment
	);
    XmVtScrollBarSetValue (vt1, value);
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtDialogCancelCB                                         */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is used to respond to a Cancel button being     */
/*+              pressed on a child dialog. It sends 'CANCEL' to the standard */
/*+              input of the tty process.                                    */
/*+                                                                           */
/*+ Parameters: wgt           - Widget     - Input widget to callback.        */
/*+             cd            - XtPointer  - Client data.                     */
/*+             cb            - XtPointer  - Callback data.                   */
/*+                                                                           */
/*+ Input:      wgt, cd, cb                                                   */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void XmVtDialogCancelCB (Widget wgt, XtPointer cd, XtPointer cb)
{
    Widget vt1 = (Widget) cd;
    XmVtSend (vt1, DIALOG_CANCEL);
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtDialogHelpCB                                           */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is used to respond to a Help button being       */
/*+              pressed on a child dialog. It sends 'HELP' to the standard   */
/*+              input of the tty process.                                    */
/*+                                                                           */
/*+ Parameters: wgt           - Widget     - Input widget to callback.        */
/*+             cd            - XtPointer  - Client data.                     */
/*+             cb            - XtPointer  - Callback data.                   */
/*+                                                                           */
/*+ Input:      wgt, cd, cb                                                   */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void XmVtDialogHelpCB (Widget wgt, XtPointer cd, XtPointer cb)
{
    Widget vt1 = (Widget) cd;
    XmVtSend (vt1, DIALOG_HELP);
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtDialogOkCB                                             */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is used to respond to an OK button being        */
/*+              pressed on a child dialog. It sends 'OK' to the standard     */
/*+              input of the tty process.                                    */
/*+                                                                           */
/*+ Parameters: wgt           - Widget     - Input widget to callback.        */
/*+             cd            - XtPointer  - Client data.                     */
/*+             cb            - XtPointer  - Callback data.                   */
/*+                                                                           */
/*+ Input:      wgt, cd, cb                                                   */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void XmVtDialogOkCB (Widget wgt, XtPointer cd, XtPointer cb)
{
    Widget vt1 = (Widget) cd;
    XmVtSend (vt1, DIALOG_OK);
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtFileSelectionDialogOkCB                                */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is used to respond to a selected file OK from a */
/*+              child file dialog. It sends an 'FILEOK:filepath' type        */
/*+              message back to the standard input of the tty process where  */
/*+              filepath is the fully qualified path the the selected file.  */
/*+                                                                           */
/*+ Parameters: wgt           - Widget     - Input widget to callback.        */
/*+             cd            - XtPointer  - Client data.                     */
/*+             cb            - XtPointer  - Callback data.                   */
/*+                                                                           */
/*+ Input:      wgt, cd, cb                                                   */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void XmVtFileSelectionDialogOkCB (Widget wgt, XtPointer cd, XtPointer cb)
{
    Widget vt1 = (Widget) cd;
    XmFileSelectionBoxCallbackStruct *fscb = (XmFileSelectionBoxCallbackStruct *) cb;
    XmString value = fscb->value;
    char *stvalue = NULL;
    char sendvalue[BUFSIZ];

    if (XmStringGetLtoR (value, XmFONTLIST_DEFAULT_TAG, &stvalue))
    {
	sprintf (sendvalue, "FILEOK:%s\n", stvalue);
    }
    else
    {
	strcpy (sendvalue, "FILEOK:/");
    }
    XmVtSend (vt1, sendvalue);
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtSBDecCB                                                */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is used as the Decrement callback to the       */
/*+              internal scrollbar.                                          */
/*+                                                                           */
/*+ Parameters: wgt           - Widget     - Input widget to callback.        */
/*+             cd            - XtPointer  - Client data.                     */
/*+             cb            - XtPointer  - Callback data.                   */
/*+                                                                           */
/*+ Input:      wgt, cd, cb                                                   */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void XmVtSBDecCB (Widget wgt, XtPointer cd, XtPointer cb)
{
    int value = 0;
    int slider_size = 0;
    int increment = 0;
    int page_increment = 0;
    Widget vt1 = XtParent (wgt);
    XmVtWidget tw = (XmVtWidget) vt1;

    tw->vt.override_focus_out = True;
    XmScrollBarGetValues (
			     wgt,
			     &value,
			     &slider_size,
			     &increment,
			     &page_increment
	);
    XmVtScrollBarSetValue (vt1, value);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtSBIncCB                                                */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is used as the Increment callback to the       */
/*+              internal scrollbar.                                          */
/*+                                                                           */
/*+ Parameters: wgt           - Widget     - Input widget to callback.        */
/*+             cd            - XtPointer  - Client data.                     */
/*+             cb            - XtPointer  - Callback data.                   */
/*+                                                                           */
/*+ Input:      wgt, cd, cb                                                   */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void XmVtSBIncCB (Widget wgt, XtPointer cd, XtPointer cb)
{
    int value = 0;
    int slider_size = 0;
    int increment = 0;
    int page_increment = 0;
    Widget vt1 = XtParent (wgt);
    XmVtWidget tw = (XmVtWidget) vt1;

    tw->vt.override_focus_out = True;
    XmScrollBarGetValues (
			     wgt,
			     &value,
			     &slider_size,
			     &increment,
			     &page_increment
	);
    XmVtScrollBarSetValue (vt1, value);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtSBPageIncCB                                            */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is used as the Page Increment callback to the  */
/*+              internal scrollbar.                                          */
/*+                                                                           */
/*+ Parameters: wgt           - Widget     - Input widget to callback.        */
/*+             cd            - XtPointer  - Client data.                     */
/*+             cb            - XtPointer  - Callback data.                   */
/*+                                                                           */
/*+ Input:      wgt, cd, cb                                                   */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void XmVtSBPageIncCB (Widget wgt, XtPointer cd, XtPointer cb)
{
    int value = 0;
    int slider_size = 0;
    int increment = 0;
    int page_increment = 0;
    Widget vt1 = XtParent (wgt);
    XmVtWidget tw = (XmVtWidget) vt1;

    tw->vt.override_focus_out = True;
    XmScrollBarGetValues (
			     wgt,
			     &value,
			     &slider_size,
			     &increment,
			     &page_increment
	);
    XmVtScrollBarSetValue (vt1, value);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtSBPageDecCB                                            */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is used as the Page Decrement callback to the  */
/*+              internal scrollbar.                                          */
/*+                                                                           */
/*+ Parameters: wgt           - Widget     - Input widget to callback.        */
/*+             cd            - XtPointer  - Client data.                     */
/*+             cb            - XtPointer  - Callback data.                   */
/*+                                                                           */
/*+ Input:      wgt, cd, cb                                                   */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void XmVtSBPageDecCB (Widget wgt, XtPointer cd, XtPointer cb)
{
    int value = 0;
    int slider_size = 0;
    int increment = 0;
    int page_increment = 0;
    Widget vt1 = XtParent (wgt);
    XmVtWidget tw = (XmVtWidget) vt1;

    tw->vt.override_focus_out = True;
    XmScrollBarGetValues (
			     wgt,
			     &value,
			     &slider_size,
			     &increment,
			     &page_increment
	);
    XmVtScrollBarSetValue (vt1, value);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: remove_scrollbar                                           */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function destroys the scrollbar widget when SetValues   */
/*+              finds that the scrolled flag has been set to false.          */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+                                                                           */
/*+ Input:      tw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void remove_scrollbar (XmVtWidget tw)
{
    if (tw->vt.Vsbar != NULL)
    {
	XtDestroyWidget (tw->vt.Vsbar);
	tw->vt.Vsbar = NULL;
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: change_colors                                              */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is one of several routines called by the screen */
/*+              subsystem. It is used to change the colors of the VT         */
/*+              terminal. It changes the appropriate resources to emulate    */
/*+              the changes a VT240 might make.                              */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+             rgb           - char *     - X rgb color string               */
/*+             map           - int        - Color map ID to load             */
/*+             mapping       - int        - Mapping flag                     */
/*+             bintense      - int        - Intensity flag                   */
/*+             screen_flag   - int        - Modify screen flag               */
/*+             writing_flag  - int        - Modify writing flag              */
/*+                                                                           */
/*+ Input:      tw, map, mapping, bintense, screen_flag, writing_flag         */
/*+                                                                           */
/*+ Output:     rgb                                                           */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void change_colors (XmVtWidget tw, char *rgb, int map, int mapping, int bintense, int screen_flag, int writing_flag)
{
    if (mapping && screen_flag)
    {
	switch (map)
	{
	    case 0:
		XtVaSetValues (
				  (Widget) tw,
				  RES_CONVERT (XmNbackground, rgb),
				  NULL
		    );
		break;
	    case 1:
		XtVaSetValues (
				  (Widget) tw,
				  RES_CONVERT (XmNreverseColor, rgb),
				  NULL
		    );
		break;
	    case 2:
		XtVaSetValues (
				  (Widget) tw,
				  RES_CONVERT (XmNforeground, rgb),
				  NULL
		    );
		break;
	    case 3:
		XtVaSetValues (
				  (Widget) tw,
				  RES_CONVERT (XmNboldColor, rgb),
				  NULL
		    );
		break;
	}
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: Destroy                                                    */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: Destroy is used to free up the screen data and also perform  */
/*+              any other clean up activity.                                 */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+                                                                           */
/*+ Input:      w                                                             */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void Destroy (w)
     Widget w;
{
    XmVtWidget cw = (XmVtWidget) w;
    int inx = 0;
    XmVtBlankWidgets (w);
    XmVtUnmonitor (w);
    StopTimers (w);
    XFreeGC (XtDisplay (w), cw->vt.normal_GC);
    XFreeGC (XtDisplay (w), cw->vt.antinormal_GC);
    XFreeGC (XtDisplay (w), cw->vt.special_GC);
    XFreeGC (XtDisplay (w), cw->vt.select_GC);
    XFreeGC (XtDisplay (w), cw->vt.inverse_GC);
    XFreeGC (XtDisplay (w), cw->vt.cursor_GC);
    XFreeGC (XtDisplay (w), cw->vt.bold_GC);
    XFreeGC (XtDisplay (w), cw->vt.dim_GC);
    XFreeGC (XtDisplay (w), cw->vt.blink_GC);
    XFreeGC (XtDisplay (w), cw->vt.armed_special_GC);
    XFreeGC (XtDisplay (w), cw->vt.armed_normal_GC);
    XFreeGC (XtDisplay (w), cw->vt.ansi0_GC);
    XFreeGC (XtDisplay (w), cw->vt.ansi1_GC);
    XFreeGC (XtDisplay (w), cw->vt.ansi2_GC);
    XFreeGC (XtDisplay (w), cw->vt.ansi3_GC);
    XFreeGC (XtDisplay (w), cw->vt.ansi4_GC);
    XFreeGC (XtDisplay (w), cw->vt.ansi5_GC);
    XFreeGC (XtDisplay (w), cw->vt.ansi6_GC);
    XFreeGC (XtDisplay (w), cw->vt.ansi7_GC);
    XFreeGC (XtDisplay (w), cw->vt.ansi8_GC);
    XFreeGC (XtDisplay (w), cw->vt.ansi9_GC);
    XFreeGC (XtDisplay (w), cw->vt.ansi10_GC);
    XFreeGC (XtDisplay (w), cw->vt.ansi11_GC);
    XFreeGC (XtDisplay (w), cw->vt.ansi12_GC);
    XFreeGC (XtDisplay (w), cw->vt.ansi13_GC);
    XFreeGC (XtDisplay (w), cw->vt.ansi14_GC);
    XFreeGC (XtDisplay (w), cw->vt.ansi15_GC);
    for (inx = 0; inx < cw->vt.image_count; inx++)
    {
	if (cw->vt.images[inx].identity != 0)
	{
	    XmDestroyPixmap (XtScreen (w), cw->vt.images[inx].Pixmap);
	    if ((cw->vt.images[inx].hyper_data) != NULL)
		free (cw->vt.images[inx].hyper_data);
	    cw->vt.images[inx].hyper_data = NULL;
	}
    }
    XmVtUnloadPopup (w);
    XtFree (cw->vt.selection);
    XtFree (cw->vt.keybuffer);
    free_data (cw);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtLoadWidget                                             */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is used to prepare a particular widget for      */
/*+              plotting on the screen. It does not begin managing the       */
/*+              widget however. That is done when it is actualy plotted.     */
/*+                                                                           */
/*+ Parameters: wid           - Widget     - Widget to be used for            */
/*+                                          processing.                      */
/*+             identity      - char       - Identity of the element. This is */
/*+                                          a single character that will     */
/*+                                          identify the element on the      */
/*+                                          screen.                          */
/*+             name          - char *     - The name of the widget.          */
/*+             wtype         - int        - The type of widget to realize.   */
/*+             wcol          - int        - Character width of widget to     */
/*+                                          realize.                         */
/*+             wrow          - int        - Character height of widget to    */
/*+                                          realize.                         */
/*+                                                                           */
/*+ Input:      wid, identity, name, wtype, wcol, wrow                        */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void XmVtLoadWidget (Widget wid, char identity, char *name, int wtype, int wcol, int wrow)
{
    XmVtWidget tw = (XmVtWidget) wid;
    int inx = 0;
    int altindex = -1;
    int index = 0;
    int cwidth = tw->vt.cwidth;
    int cheight = tw->vt.cheight;
    Arg load_args[1000];
    Cardinal ac = 0;

    tw->vt.internal_insert = True;
    index = tw->vt.child_count;
    for (inx = 0; inx < index; inx++)
    {
	if (identity == tw->vt.children[inx].identity)
	    altindex = inx;
    }
    if (altindex == -1)
    {
	(tw->vt.child_count)++;
    }
    else
    {
	free (tw->vt.children[altindex].name);
	if (tw->vt.children[index].callback_data != NULL)
	    free (tw->vt.children[index].callback_data);
	XtDestroyWidget (tw->vt.children[altindex].vtchild);
	index = altindex;
    }
    tw->vt.children[index].callback_data = NULL;
    tw->vt.children[index].name = (char *) malloc (strlen (name) + 1);
    strcpy (tw->vt.children[index].name, name);
    tw->vt.children[index].identity = identity;
    tw->vt.children[index].wtype = wtype;
    tw->vt.children[index].width = wcol;
    tw->vt.children[index].height = wrow;
    tw->vt.children[index].row = 1;
    tw->vt.children[index].column = 1;
    tw->vt.children[index].painted = False;
    switch (wtype)
    {
	case PUSHBUTTON:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmPushButtonWidgetClass,
		    wid,
		    XmNfontList, tw->vt.font,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNtraversalOn, tw->vt.children_traversal_on,
		    XmNunitType, XmPIXELS,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);

	    XtAddCallback
		(
		    tw->vt.children[index].vtchild,
		    XmNactivateCallback,
		    (XtCallbackProc) XmVtPBActivate,
		    (XtPointer) index
		);
	    break;
	case PUSHBUTTONGADGET:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmPushButtonGadgetClass,
		    wid,
		    XmNfontList, tw->vt.font,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNtraversalOn, tw->vt.children_traversal_on,
		    XmNunitType, XmPIXELS,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);

	    XtAddCallback
		(
		    tw->vt.children[index].vtchild,
		    XmNactivateCallback,
		    (XtCallbackProc) XmVtPBActivate,
		    (XtPointer) index
		);
	    break;
	case ARROWBUTTON:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmArrowButtonWidgetClass,
		    wid,
		    XmNfontList, tw->vt.font,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNtraversalOn, tw->vt.children_traversal_on,
		    XmNunitType, XmPIXELS,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);

	    XtAddCallback
		(
		    tw->vt.children[index].vtchild,
		    XmNactivateCallback,
		    (XtCallbackProc) XmVtPBActivate,
		    (XtPointer) index
		);
	    break;
	case ARROWBUTTONGADGET:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmArrowButtonGadgetClass,
		    wid,
		    XmNfontList, tw->vt.font,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNtraversalOn, tw->vt.children_traversal_on,
		    XmNunitType, XmPIXELS,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);

	    XtAddCallback
		(
		    tw->vt.children[index].vtchild,
		    XmNactivateCallback,
		    (XtCallbackProc) XmVtPBActivate,
		    (XtPointer) index
		);
	    break;
	case TOGGLEBUTTON:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmToggleButtonWidgetClass,
		    wid,
		    XmNfontList, tw->vt.font,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNtraversalOn, tw->vt.children_traversal_on,
		    XmNunitType, XmPIXELS,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    XtAddCallback
		(
		    tw->vt.children[index].vtchild,
		    XmNvalueChangedCallback,
		    (XtCallbackProc) XmVtTBActivate,
		    (XtPointer) index
		);
	    break;
	case TOGGLEBUTTONGADGET:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmToggleButtonGadgetClass,
		    wid,
		    XmNfontList, tw->vt.font,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNtraversalOn, tw->vt.children_traversal_on,
		    XmNunitType, XmPIXELS,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    XtAddCallback
		(
		    tw->vt.children[index].vtchild,
		    XmNvalueChangedCallback,
		    (XtCallbackProc) XmVtTBActivate,
		    (XtPointer) index
		);
	    break;
	case LABEL:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmLabelWidgetClass,
		    wid,
		    XmNfontList, tw->vt.font,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNtraversalOn, False,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNunitType, XmPIXELS,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    break;
	case LABELGADGET:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmLabelGadgetClass,
		    wid,
		    XmNfontList, tw->vt.font,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNtraversalOn, False,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNunitType, XmPIXELS,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    break;
	case TEXTFIELD:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmTextFieldWidgetClass,
		    wid,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNfontList, tw->vt.font,
		    XmNtraversalOn, tw->vt.children_traversal_on,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNunitType, XmPIXELS,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    XtAddCallback
		(
		    tw->vt.children[index].vtchild,
		    XmNactivateCallback,
		    (XtCallbackProc) XmVtTFActivate,
		    (XtPointer) index
		);
	    break;
	case TEXT:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmTextWidgetClass,
		    wid,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNfontList, tw->vt.font,
		    XmNeditMode, XmMULTI_LINE_EDIT,
		    XmNtraversalOn, tw->vt.children_traversal_on,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNunitType, XmPIXELS,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    break;
	case SCROLLBAR:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmScrollBarWidgetClass,
		    wid,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNfontList, tw->vt.font,
		    XmNtraversalOn, tw->vt.children_traversal_on,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNunitType, XmPIXELS,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    break;
	case SEPARATORH:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmSeparatorWidgetClass,
		    wid,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNorientation, XmHORIZONTAL,
		    XmNfontList, tw->vt.font,
		    XmNtraversalOn, False,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNunitType, XmPIXELS,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    break;
	case SEPARATORV:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmSeparatorWidgetClass,
		    wid,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNorientation, XmVERTICAL,
		    XmNfontList, tw->vt.font,
		    XmNtraversalOn, False,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNunitType, XmPIXELS,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    break;
	case SEPARATORHGADGET:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmSeparatorGadgetClass,
		    wid,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNorientation, XmHORIZONTAL,
		    XmNfontList, tw->vt.font,
		    XmNtraversalOn, False,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNunitType, XmPIXELS,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    break;
	case SEPARATORVGADGET:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmSeparatorGadgetClass,
		    wid,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNorientation, XmVERTICAL,
		    XmNfontList, tw->vt.font,
		    XmNtraversalOn, False,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNunitType, XmPIXELS,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    break;
	case LIST:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmListWidgetClass,
		    wid,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNfontList, tw->vt.font,
		    XmNtraversalOn, tw->vt.children_traversal_on,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNunitType, XmPIXELS,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    break;
	case COMMAND:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmCommandWidgetClass,
		    wid,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNfontList, tw->vt.font,
		    XmNtraversalOn, tw->vt.children_traversal_on,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNunitType, XmPIXELS,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    break;
	case FILESELECTIONBOX:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmFileSelectionBoxWidgetClass,
		    wid,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNfontList, tw->vt.font,
		    XmNtraversalOn, tw->vt.children_traversal_on,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNunitType, XmPIXELS,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    break;
	case SCROLLEDWINDOW:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmScrolledWindowWidgetClass,
		    wid,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNscrollingPolicy, XmAUTOMATIC,
		    XmNvisualPolicy, XmCONSTANT,
		    XmNscrollBarDisplayPolicy, XmSTATIC,
		    XmNfontList, tw->vt.font,
		    XmNtraversalOn, tw->vt.children_traversal_on,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNunitType, XmPIXELS,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    break;
	case PANEDWINDOW:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmPanedWindowWidgetClass,
		    wid,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNfontList, tw->vt.font,
		    XmNtraversalOn, tw->vt.children_traversal_on,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNunitType, XmPIXELS,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    break;
	case ROWCOLUMN:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmRowColumnWidgetClass,
		    wid,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNfontList, tw->vt.font,
		    XmNtraversalOn, tw->vt.children_traversal_on,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNunitType, XmPIXELS,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    break;
	case FRAME:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmFrameWidgetClass,
		    wid,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNfontList, tw->vt.font,
		    XmNtraversalOn, tw->vt.children_traversal_on,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNunitType, XmPIXELS,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    break;
	case SCALE:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmScaleWidgetClass,
		    wid,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNfontList, tw->vt.font,
		    XmNtraversalOn, tw->vt.children_traversal_on,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNunitType, XmPIXELS,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    break;
	case SELECTIONBOX:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmSelectionBoxWidgetClass,
		    wid,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNfontList, tw->vt.font,
		    XmNtraversalOn, tw->vt.children_traversal_on,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNunitType, XmPIXELS,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    break;
	case FORM:
	    tw->vt.children[index].vtchild = XtVaCreateWidget
		(
		    name,
		    xmFormWidgetClass,
		    wid,
		    XmNresizePolicy, XmRESIZE_ANY,
		    XmNfontList, tw->vt.font,
		    XmNtraversalOn, tw->vt.children_traversal_on,
		    XmNforeground, tw->manager.foreground,
		    XmNbackground, tw->core.background_pixel,
		    XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		    XmNtopShadowColor, tw->manager.top_shadow_color,
		    XmNunitType, XmPIXELS,
		    XmNx, 0,
		    XmNy, 0,
		    XmNwidth, wcol * cwidth,
		    XmNheight, wrow * cheight,
		    NULL
		);
	    break;
	case SCROLLEDTEXT:
	    ac = 0;
	    XtSetArg (load_args[ac], XmNfontList, tw->vt.font);
	    ac++;
	    XtSetArg (load_args[ac], XmNresizePolicy, XmRESIZE_ANY);
	    ac++;
	    XtSetArg (load_args[ac], XmNeditMode, XmMULTI_LINE_EDIT);
	    ac++;
	    XtSetArg (load_args[ac], XmNtraversalOn, tw->vt.children_traversal_on);
	    ac++;
	    XtSetArg (load_args[ac], XmNforeground, tw->manager.foreground);
	    ac++;
	    XtSetArg (load_args[ac], XmNbackground, tw->core.background_pixel);
	    ac++;
	    XtSetArg (load_args[ac], XmNbottomShadowColor, tw->manager.bottom_shadow_color);
	    ac++;
	    XtSetArg (load_args[ac], XmNtopShadowColor, tw->manager.top_shadow_color);
	    ac++;
	    XtSetArg (load_args[ac], XmNunitType, XmPIXELS);
	    ac++;
	    XtSetArg (load_args[ac], XmNx, 0);
	    ac++;
	    XtSetArg (load_args[ac], XmNy, 0);
	    ac++;
	    XtSetArg (load_args[ac], XmNwidth, wcol * cwidth);
	    ac++;
	    XtSetArg (load_args[ac], XmNheight, wrow * cheight);
	    ac++;
/* BMC Problems at time in mallocing here. */
	    tw->vt.children[index].vtchild =
		XmCreateScrolledText (wid, name, load_args, ac);
	    break;
	case SCROLLEDLIST:
	    ac = 0;
	    XtSetArg (load_args[ac], XmNfontList, tw->vt.font);
	    ac++;
	    XtSetArg (load_args[ac], XmNresizePolicy, XmRESIZE_NONE);
	    ac++;
	    XtSetArg (load_args[ac], XmNtraversalOn, tw->vt.children_traversal_on);
	    ac++;
	    XtSetArg (load_args[ac], XmNforeground, tw->manager.foreground);
	    ac++;
	    XtSetArg (load_args[ac], XmNbackground, tw->core.background_pixel);
	    ac++;
	    XtSetArg (load_args[ac], XmNbottomShadowColor, tw->manager.bottom_shadow_color);
	    ac++;
	    XtSetArg (load_args[ac], XmNtopShadowColor, tw->manager.top_shadow_color);
	    ac++;
	    XtSetArg (load_args[ac], XmNunitType, XmPIXELS);
	    ac++;
	    XtSetArg (load_args[ac], XmNx, 0);
	    ac++;
	    XtSetArg (load_args[ac], XmNy, 0);
	    ac++;
	    XtSetArg (load_args[ac], XmNwidth, wcol * cwidth);
	    ac++;
	    XtSetArg (load_args[ac], XmNheight, wrow * cheight);
	    ac++;
	    tw->vt.children[index].vtchild =
		XmCreateScrolledList (wid, name, load_args, ac);
	    break;
	default:
	    XtWarning ("Unknown widget type.");
    }
    tw->vt.internal_insert = False;
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtDumpTextChild                                          */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine sends all the data from a text widget to the    */
/*+              keyboard input queue of the parent Vt widget. The child text */
/*+              widget is identified by the character identity code provided */
/*+              as argument 2.                                               */
/*+                                                                           */
/*+ Parameters: wid           - Widget     - Widget to be used for            */
/*+                                          processing.                      */
/*+             identity      - char       - Identity of the element. This is */
/*+                                          a single character that will     */
/*+                                          identify the element on the      */
/*+                                          screen.                          */
/*+             pre           - char *     - Pre-printed tag data from a text */
/*+                                          widget.                          */
/*+             post          - char *     - Post-printed tag data from a     */
/*+                                          text widget.                     */
/*+                                                                           */
/*+ Input:      wid, identity, pre, post                                      */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void XmVtDumpTextChild (Widget wid, char identity, char *pre, char *post)
{
    XmVtWidget tw = (XmVtWidget) wid;
    Widget child = NULL;
    int inx = 0;
    int index = -1;
    char buffer[BUFSIZ];
    char *text_value = NULL;
    int length = 0;

    for (inx = 0; inx < tw->vt.child_count; inx++)
    {
	if (identity == tw->vt.children[inx].identity)
	    index = inx;
    }
    if (index != -1)
    {
	child = tw->vt.children[index].vtchild;
	if (XmIsText (child))
	{
	    XtVaGetValues (child, XmNvalue, &text_value, NULL);
	    length = strlen (text_value);
	    sprintf (buffer, "%d\n", length);
	    XmVtSend (wid, buffer);
	    XmVtSend (wid, text_value);
	    sprintf (buffer, "\n");
	    XmVtSend (wid, buffer);
	}
	else
	{
	    XtWarning ("XmVtDumpTextChild widget is not a text widget.");
	}
    }
    else
    {
	XtWarning ("XmVtDumpTextChild widget not found.");
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtAppendTextChild                                        */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function appends a line of text to a child text widget  */
/*+              of the Vt widget. This line of text is appended to the       */
/*+              bottom of the data.                                          */
/*+                                                                           */
/*+ Parameters: wid           - Widget     - Widget to be used for            */
/*+                                          processing.                      */
/*+             identity      - char       - Identity of the element. This is */
/*+                                          a single character that will     */
/*+                                          identify the element on the      */
/*+                                          screen.                          */
/*+             extend        - char *     - String data to extend the value  */
/*+                                          of the text widget.              */
/*+                                                                           */
/*+ Input:      wid, identity, extend                                         */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void XmVtAppendTextChild (Widget wid, char identity, char *extend)
{
    XmVtWidget tw = (XmVtWidget) wid;
    Widget child = NULL;
    int inx = 0;
    int index = -1;
    char final[BUFSIZ];
    XmTextPosition position = 0;

    for (inx = 0; inx < tw->vt.child_count; inx++)
    {
	if (identity == tw->vt.children[inx].identity)
	    index = inx;
    }
    if (index != -1)
    {
	child = tw->vt.children[index].vtchild;
	if (XmIsText (child))
	{
	    sprintf (final, "%s\n", convert_esc (extend, ""));
	    position = XmTextGetLastPosition (child);
	    XmTextInsert (child, position, final);
	}
	else
	{
	    XtWarning ("XmVtAppendTextChild widget is not a text widget.");
	}
    }
    else
    {
	XtWarning ("XmVtAppendTextChild widget not found.");
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtAppendListChild                                        */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function appends a line of text to a child list widget  */
/*+              of the Vt widget. This line of text is appended to the       */
/*+              bottom of the data.                                          */
/*+                                                                           */
/*+ Parameters: wid           - Widget     - Widget to be used for            */
/*+                                          processing.                      */
/*+             identity      - char       - Identity of the element. This is */
/*+                                          a single character that will     */
/*+                                          identify the element on the      */
/*+                                          screen.                          */
/*+             extend        - char *     - String data to extend the value  */
/*+                                          of the text widget.              */
/*+                                                                           */
/*+ Input:      wid, identity, extend                                         */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void XmVtAppendListChild (Widget wid, char identity, char *extend)
{
    XmVtWidget tw = (XmVtWidget) wid;
    Widget child = NULL;
    int inx = 0;
    int jnx = 0;
    int knx = 0;
    int index = -1;
    char inter[BUFSIZ];
    char final[BUFSIZ];
    XmString xmstring = 0;

    for (inx = 0; inx < tw->vt.child_count; inx++)
    {
	if (identity == tw->vt.children[inx].identity)
	    index = inx;
    }
    if (index != -1)
    {
	child = tw->vt.children[index].vtchild;
	if (XmIsList (child))
	{
	    sprintf (inter, "%s", convert_esc (extend, ""));
	    for (inx = 0; inx < strlen (inter); inx++)
	    {
		if (inter[inx] == 9)
		{
		    for (knx = 1; knx <= 8; knx++)
			final[jnx++] = ' ';
		}
		else
		{
		    final[jnx++] = inter[inx];
		}
	    }
	    final[jnx] = 0;
	    xmstring = XmStringCreateLocalized (final);
	    XmListAddItemUnselected (child, xmstring, 0);
	    XmStringFree (xmstring);
	}
	else
	{
	    XtWarning ("XmVtAppendListChild widget is not a list widget.");
	}
    }
    else
    {
	XtWarning ("XmVtAppendListChild widget not found.");
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtPBActivate                                             */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is called from all Pushbutton widgets when they */
/*+              are pressed. It is a callback routine.                       */
/*+                                                                           */
/*+ Parameters: cw            - Widget     - Current Widget                   */
/*+             client_dat    - XtPointer  - Client data passed to callback   */
/*+             callback      - XtPointer  - Callback data                    */
/*+                                                                           */
/*+ Input:      cw, client_dat, callback                                      */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void XmVtPBActivate (Widget cw, XtPointer client_dat, XtPointer callback)
{
    int index = (int) client_dat;
    XmVtWidget tw = NULL;
    char *keydata = NULL;

    tw = (XmVtWidget) XtParent (cw);
    keydata = tw->vt.children[index].callback_data;
    if (keydata != NULL)
	XmVtSend ((Widget) tw, convert_esc (tw->vt.button_filter, keydata));
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtTBActivate                                             */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is called from all Togglebutton widgets when    */
/*+              they are pressed. It is a callback routine related to any    */
/*+              change in value for a toggle button.                         */
/*+                                                                           */
/*+ Parameters: cw            - Widget     - Current Widget                   */
/*+             client_dat    - XtPointer  - Client data passed to callback   */
/*+             callback      - XtPointer  - Callback data                    */
/*+                                                                           */
/*+ Input:      cw, client_dat, callback                                      */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void XmVtTBActivate (Widget cw, XtPointer client_dat, XtPointer callback)
{
    int index = (int) client_dat;
    XmVtWidget tw = NULL;
    char *keydata = NULL;

    tw = (XmVtWidget) XtParent (cw);
    keydata = tw->vt.children[index].callback_data;
    if (keydata != NULL)
    {
	XmVtSend ((Widget) tw, convert_esc (tw->vt.button_filter, keydata));
	if (XmToggleButtonGetState (tw->vt.children[index].vtchild))
	{
	    XmVtSend ((Widget) tw, "ON\n");
	}
	else
	{
	    XmVtSend ((Widget) tw, "OFF\n");
	}
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtTFActivate                                             */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is called from all TextField widgets when they  */
/*+              are pressed. It is a callback routine.                       */
/*+                                                                           */
/*+ Parameters: cw            - Widget     - Current Widget                   */
/*+             client_dat    - XtPointer  - Client data passed to callback   */
/*+             callback      - XtPointer  - Callback data                    */
/*+                                                                           */
/*+ Input:      cw, client_dat, callback                                      */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void XmVtTFActivate (Widget cw, XtPointer client_dat, XtPointer callback)
{
    int index = (int) client_dat;
    XmVtWidget tw = NULL;
    char *keydata = NULL;

    tw = (XmVtWidget) XtParent (cw);
    keydata = tw->vt.children[index].callback_data;
    if (keydata != NULL)
	XmVtSend ((Widget) tw, convert_esc (tw->vt.button_filter, keydata));
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtBlankWidgets                                           */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine unmanages all Vt child widgets. This is similar */
/*+              to a clear screen except it is for the special case of       */
/*+              widgets.                                                     */
/*+                                                                           */
/*+ Parameters: wid           - Widget     - Widget to be used for            */
/*+                                          processing.                      */
/*+                                                                           */
/*+ Input:      wid                                                           */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void XmVtBlankWidgets (Widget wid)
{
    XmVtWidget tw = (XmVtWidget) wid;
    int inx = 0;
    int index = 0;
    index = tw->vt.child_count;
    for (inx = 0; inx < index; inx++)
    {
	XtDestroyWidget (tw->vt.children[inx].vtchild);
    }
    tw->vt.child_count = 0;
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtChildSetValues                                         */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine receives the vtwidget name, a child identity    */
/*+              character, a resource and a value for the resource that will */
/*+              be set. With this information it properly sets the given     */
/*+              resource for the child widget.                               */
/*+                                                                           */
/*+ Parameters: wid           - Widget     - Widget to be used for            */
/*+                                          processing.                      */
/*+             identity      - char       - Identity of the element. This is */
/*+                                          a single character that will     */
/*+                                          identify the element on the      */
/*+                                          screen.                          */
/*+             res           - char *     - Resource name.                   */
/*+             val           - char *     - Value to set resource to.        */
/*+                                                                           */
/*+ Input:      wid, identity, res, val                                       */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void XmVtChildSetValues (Widget wid, char identity, char *res, char *val)
{
    XmVtWidget tw = (XmVtWidget) wid;
    Widget child = NULL;
    int inx = 0;
    int index = -1;

    for (inx = 0; inx < tw->vt.child_count; inx++)
    {
	if (identity == tw->vt.children[inx].identity)
	    index = inx;
    }
    if (index != -1)
    {
	child = tw->vt.children[index].vtchild;
	XtVaSetValues (child, RES_CONVERT (res, val), NULL);
    }
    else
    {
	XtWarning ("XmVtChildSetValues widget not found.");
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtChildResize                                            */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is used to resize a child widget using the      */
/*+              normal rows and columns type values of the screen            */
/*+              coordinates.                                                 */
/*+                                                                           */
/*+ Parameters: wid           - Widget     - Widget to be used for            */
/*+                                          processing.                      */
/*+             identity      - char       - Identity of the element. This is */
/*+                                          a single character that will     */
/*+                                          identify the element on the      */
/*+                                          screen.                          */
/*+             wcol          - int        - Character width of widget to     */
/*+                                          realize.                         */
/*+             wrow          - int        - Character height of widget to    */
/*+                                          realize.                         */
/*+                                                                           */
/*+ Input:      wid, identity, wcol, wrow                                     */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void XmVtChildResize (Widget wid, char identity, int wcol, int wrow)
{
    XmVtWidget tw = (XmVtWidget) wid;
    Widget child = NULL;
    int inx = 0;
    int index = -1;

    for (inx = 0; inx < tw->vt.child_count; inx++)
    {
	if (identity == tw->vt.children[inx].identity)
	    index = inx;
    }
    if (index != -1)
    {
	child = tw->vt.children[index].vtchild;
	if (XmIsScrolledWindow (XtParent (child)))
	{
	    child = XtParent (child);
	}
	tw->vt.children[index].width = wcol;
	tw->vt.children[index].height = wrow;
	XtVaSetValues
	    (
		child,
		XmNwidth,
		wcol * tw->vt.cwidth,
		XmNheight,
		wrow * tw->vt.cheight,
		NULL
	    );
    }
    else
    {
	XtWarning ("XmVtChildResize widget not found.");
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtLoadHyperData                                          */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is the normal method for programers to load a   */
/*+              section of text to be fed back to the keyboard at the        */
/*+              activation of a hyper text link.                             */
/*+                                                                           */
/*+ Parameters: wid           - Widget     - Widget to be used for            */
/*+                                          processing.                      */
/*+             identity      - char       - Identity of the element. This is */
/*+                                          a single character that will     */
/*+                                          identify the element on the      */
/*+                                          screen.                          */
/*+             hyper_data    - char *     - This is data to be sent if the   */
/*+                                          hyper link is activated.         */
/*+                                                                           */
/*+ Input:      wid, identity, hyper_data                                     */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void XmVtLoadHyperData (Widget wid, char identity, char *hyper_data)
{
    XmVtWidget tw = (XmVtWidget) wid;
    int inx = 0;
    int altindex = -1;
    int index = 0;

    index = tw->vt.image_count;
    for (inx = 0; inx < index; inx++)
    {
	if (identity == tw->vt.images[inx].identity)
	    altindex = inx;
    }
    if (altindex != -1)
    {
	if (tw->vt.images[altindex].hyper_data != NULL)
	    free (tw->vt.images[altindex].hyper_data);
	(tw->vt.images[altindex].hyper_data) =
	    (char *) malloc (strlen (hyper_data) + 1);
	strcpy ((tw->vt.images[altindex].hyper_data), hyper_data);
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtLoadButtonData                                         */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is the normal method for programers to load a   */
/*+              section of text to be fed back to the keyboard at the        */
/*+              activation of a PushButton.                                  */
/*+                                                                           */
/*+ Parameters: wid           - Widget     - Widget to be used for            */
/*+                                          processing.                      */
/*+             identity      - char       - Identity of the element. This is */
/*+                                          a single character that will     */
/*+                                          identify the element on the      */
/*+                                          screen.                          */
/*+             callback_data - char *     - This is data to be sent if the   */
/*+                                          button is activated.             */
/*+                                                                           */
/*+ Input:      wid, identity, callback_data                                  */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void XmVtLoadButtonData (Widget wid, char identity, char *callback_data)
{
    XmVtWidget tw = (XmVtWidget) wid;
    int inx = 0;
    int altindex = -1;
    int index = 0;

    index = tw->vt.child_count;
    for (inx = 0; inx < index; inx++)
    {
	if (identity == tw->vt.children[inx].identity)
	    altindex = inx;
    }
    if (altindex != -1)
    {
	if (tw->vt.children[altindex].callback_data != NULL)
	    free (tw->vt.children[altindex].callback_data);
	(tw->vt.children[altindex].callback_data) =
	    (char *) malloc (strlen (callback_data) + 1);
	strcpy ((tw->vt.children[altindex].callback_data), callback_data);
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: StringInput                                                */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: StringInput is used as two action routines called string and */
/*+              self-insert. As self-insert it inserts the pressed key into  */
/*+              the keyboard buffer. As string it is used to insert a        */
/*+              specified ascii value into the buffer.                       */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             event         - XEvent *   - X event for situation            */
/*+             params        - String *   - Parameters to Action             */
/*+             numparams     - Cardinal * - Number of parameters             */
/*+                                                                           */
/*+ Input:      w, event, params, numparams                                   */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void StringInput (w, event, params, numparams)
     Widget w;
     XEvent *event;
     String *params;
     Cardinal *numparams;
{
    XmVtWidget cw = (XmVtWidget) w;
    int lenstr = 0;
    int value = 0;
    int rcode = 0;
    int inx = 0;
    KeySym symbol = 0;
    XKeyEvent *current_event = (XKeyEvent *) event;
    char keybuffer[BUFSIZ];
    XComposeStatus status_in_out;
    lenstr = XLookupString (current_event, keybuffer, BUFSIZ, &symbol, &status_in_out);
    keybuffer[lenstr] = 0;
    if (*numparams > 0)
    {
	rcode = sscanf (params[0], "%x", &value);
	if (rcode == 0)
	{
	    strcpy (keybuffer, params[0]);
	}
	else
	{
	    sprintf (keybuffer, "%c", value);
	}
    }
    if (keybuffer[0] != 0)
	XmVtSend (w, keybuffer);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: FocusInProc                                                */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This is an action routine used to check whether the widget   */
/*+              should be highlighted or not. It looks for a normal focus in */
/*+              event to trigger the highlighting process.                   */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             event         - XEvent *   - X event for situation            */
/*+             params        - String *   - Parameters to Action             */
/*+             numparams     - Cardinal * - Number of parameters             */
/*+                                                                           */
/*+ Input:      w, event, params, numparams                                   */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void FocusInProc (w, event, params, numparams)
     Widget w;
     XEvent *event;
     String *params;
     Cardinal *numparams;
{
    XmVtWidget cw = (XmVtWidget) w;
    XFocusInEvent *current_event = (XFocusInEvent *) event;

    if (current_event->mode == NotifyNormal)
    {
	if (cw->vt.use_shadow)
	{
	    cw->manager.has_focus = True;
	    DrawHighlight (cw);
	}
    }
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: FocusOutProc                                               */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This is an action routine used to check whether the widget   */
/*+              should be unhighlighted or not. It looks for a normal focus  */
/*+              out event to trigger the unhighlighting process.             */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             event         - XEvent *   - X event for situation            */
/*+             params        - String *   - Parameters to Action             */
/*+             numparams     - Cardinal * - Number of parameters             */
/*+                                                                           */
/*+ Input:      w, event, params, numparams                                   */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void FocusOutProc (w, event, params, numparams)
     Widget w;
     XEvent *event;
     String *params;
     Cardinal *numparams;
{
    XmVtWidget cw = (XmVtWidget) w;
    XFocusInEvent *current_event = (XFocusOutEvent *) event;

    if (current_event->mode == NotifyNormal)
    {
	cw->manager.has_focus = False;
	if (cw->vt.use_shadow)
	{
	    UnDrawHighlight (cw);
	}
    }
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: Up                                                         */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: Up is an action routine that is triggered by the Up Key      */
/*+              being pressed.                                               */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             event         - XEvent *   - X event for situation            */
/*+             params        - String *   - Parameters to Action             */
/*+             numparams     - Cardinal * - Number of parameters             */
/*+                                                                           */
/*+ Input:      w, event, params, numparams                                   */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void Up (w, event, params, numparams)
     Widget w;
     XEvent *event;
     String *params;
     Cardinal *numparams;
{
    XmVtWidget cw = (XmVtWidget) w;
    XKeyEvent *current_event = (XKeyEvent *) event;
    char keybuffer[BUFSIZ];
    int value = 0;
    int slider_size = cw->vt.rows;
    int increment = 1;
    int page_increment = cw->vt.rows;
    Widget wgt = cw->vt.Vsbar;
    int setvalue = 0;
    int max_history = cw->vt.max_history;

    if (cw->vt.use_scroll_keys)
    {
	setvalue = cw->vt.scroll_value + increment;
	if (setvalue > max_history)
	    setvalue = max_history;
	if (cw->vt.scrolled)
	    XmScrollBarSetValues
		(
		    wgt,
		    setvalue, slider_size, increment, page_increment, False
		);
	XmVtScrollBarSetValue (w, setvalue);
	keybuffer[0] = 0;
    }
    else
    {
	sprintf (keybuffer, "\033OA");
    }

    if (keybuffer[0] != 0)
	XmVtSend (w, keybuffer);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: Down                                                       */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: Down is an action routine that is triggered by the Down Key  */
/*+              being pressed.                                               */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             event         - XEvent *   - X event for situation            */
/*+             params        - String *   - Parameters to Action             */
/*+             numparams     - Cardinal * - Number of parameters             */
/*+                                                                           */
/*+ Input:      w, event, params, numparams                                   */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void Down (w, event, params, numparams)
     Widget w;
     XEvent *event;
     String *params;
     Cardinal *numparams;
{
    XmVtWidget cw = (XmVtWidget) w;
    int value = 0;
    XKeyEvent *current_event = (XKeyEvent *) event;
    char keybuffer[BUFSIZ];
    int slider_size = cw->vt.rows;
    int increment = 1;
    int page_increment = cw->vt.rows;
    Widget wgt = cw->vt.Vsbar;
    int setvalue = 0;

    if (cw->vt.use_scroll_keys)
    {
	setvalue = cw->vt.scroll_value - increment;
	if (setvalue < 0)
	    setvalue = 0;
	if (cw->vt.scrolled)
	    XmScrollBarSetValues
		(
		    wgt,
		    setvalue, slider_size, increment, page_increment, False
		);
	XmVtScrollBarSetValue (w, setvalue);
	keybuffer[0] = 0;
    }
    else
    {
	sprintf (keybuffer, "\033OB");
    }

    if (keybuffer[0] != 0)
	XmVtSend (w, keybuffer);
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: PageDown                                                   */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: PageDown is an action routine that is triggered by the       */
/*+              PageDown Key being pressed.                                  */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             event         - XEvent *   - X event for situation            */
/*+             params        - String *   - Parameters to Action             */
/*+             numparams     - Cardinal * - Number of parameters             */
/*+                                                                           */
/*+ Input:      w, event, params, numparams                                   */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void PageDown (w, event, params, numparams)
     Widget w;
     XEvent *event;
     String *params;
     Cardinal *numparams;
{
    XmVtWidget cw = (XmVtWidget) w;
    XKeyEvent *current_event = (XKeyEvent *) event;
    char keybuffer[BUFSIZ];
    int value = 0;
    int slider_size = cw->vt.rows;
    int increment = 1;
    int page_increment = cw->vt.rows;
    Widget wgt = cw->vt.Vsbar;
    int setvalue = 0;

    if (cw->vt.use_scroll_keys)
    {
	setvalue = cw->vt.scroll_value - page_increment;
	if (setvalue < 0)
	    setvalue = 0;
	if (cw->vt.scrolled)
	    XmScrollBarSetValues
		(
		    wgt,
		    setvalue, slider_size, increment, page_increment,
		    False
		);
	XmVtScrollBarSetValue (w, setvalue);
	keybuffer[0] = 0;
    }
    else
    {
	sprintf (keybuffer, "\033[6~");
    }

    if (keybuffer[0] != 0)
	XmVtSend (w, keybuffer);
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: PageUp                                                     */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: PageUp is an action routine that is triggered by the PageUp  */
/*+              Key being pressed.                                           */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             event         - XEvent *   - X event for situation            */
/*+             params        - String *   - Parameters to Action             */
/*+             numparams     - Cardinal * - Number of parameters             */
/*+                                                                           */
/*+ Input:      w, event, params, numparams                                   */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void PageUp (w, event, params, numparams)
     Widget w;
     XEvent *event;
     String *params;
     Cardinal *numparams;
{
    XmVtWidget cw = (XmVtWidget) w;
    XKeyEvent *current_event = (XKeyEvent *) event;
    char keybuffer[BUFSIZ];
    int value = 0;
    int slider_size = cw->vt.rows;
    int increment = 1;
    int page_increment = cw->vt.rows;
    Widget wgt = cw->vt.Vsbar;
    int setvalue = 0;
    int max_history = cw->vt.max_history;

    if (cw->vt.use_scroll_keys)
    {
	setvalue = cw->vt.scroll_value + page_increment;
	if (setvalue > max_history)
	    setvalue = max_history;
	if (cw->vt.scrolled)
	    XmScrollBarSetValues
		(
		    wgt,
		    setvalue, slider_size, increment, page_increment,
		    False
		);
	XmVtScrollBarSetValue (w, setvalue);
	keybuffer[0] = 0;
    }
    else
    {
	sprintf (keybuffer, "\033[5~");
    }

    if (keybuffer[0] != 0)
	XmVtSend (w, keybuffer);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: Paste                                                      */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is used to perform a paste operation for the X  */
/*+              window system.                                               */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             event         - XButtonEvent *                                */
/*+                                        - X event for situation            */
/*+                                                                           */
/*+ Input:      w, event                                                      */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void Paste (w, event)
     Widget w;
     XButtonEvent *event;
{
    XmVtWidget cw = (XmVtWidget) w;
    if (cw->vt.cut_paste)
	XtGetSelectionValue
	    (w, XA_PRIMARY, XA_STRING, p_cb, event, event->time);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: PasteClipboard                                             */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is called as an action to Paste from the X11    */
/*+              clipboard.                                                   */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             event         - XButtonEvent *                                */
/*+                                        - X event for situation            */
/*+                                                                           */
/*+ Input:      w, event                                                      */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void PasteClipboard (w, event)
     Widget w;
     XButtonEvent *event;
{
    XmVtWidget cw = (XmVtWidget) w;
    if (cw->vt.cut_paste)
	XmVtPaste (w);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: CopyClipboard                                              */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is called as an action to Copy to the X11       */
/*+              clipboard.                                                   */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             event         - XButtonEvent *                                */
/*+                                        - X event for situation            */
/*+                                                                           */
/*+ Input:      w, event                                                      */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void CopyClipboard (w, event)
     Widget w;
     XButtonEvent *event;
{
    XmVtWidget cw = (XmVtWidget) w;
    if (cw->vt.cut_paste)
	XmVtCopy (w, event->time);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtCopy                                                   */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine copies selected data to the Clipboard from the  */
/*+              Vt Widget.                                                   */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             time          - Time       - Time of event.                   */
/*+                                                                           */
/*+ Input:      w, time                                                       */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
Boolean XmVtCopy (w, time)
     Widget w;
     Time time;
{
    XmVtWidget tw = (XmVtWidget) w;
    int rc = 0;
    long item_id = 0;
    long data_id = 0;
    char buffer[BUFSIZ];
    rc = XmClipboardStartCopy
	(
	    XtDisplay (w),
	    XtWindow (w),
	    XmStringCreateLocalized ("VT Widget"),
	    time,
	    w,
	    NULL,
	    &item_id
	);
    rc = XmClipboardCopy
	(
	    XtDisplay (w),
	    XtWindow (w),
	    item_id,
	    "STRING",
	    tw->vt.selection,
	    strlen (tw->vt.selection) + 1,
	    0,
	    &data_id
	);

    XmClipboardEndCopy (XtDisplay (w), XtWindow (w), item_id);
    return (True);
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XmVtPaste                                                  */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine pastes data from the Clipboard into the Vt      */
/*+              Widget.                                                      */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+                                                                           */
/*+ Input:      w                                                             */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
Boolean XmVtPaste (w)
     Widget w;
{
    int rc = 0;
    Boolean retval = True;
    unsigned long num_bytes = 0;
    long private_id = 0;
    char buffer[BUFSIZ];
    int index = 1;
    unsigned long cpln = 0;
    Boolean valid = False;
    char format[BUFSIZ];
    char format_name[BUFSIZ];
    do
    {
	XmClipboardInquireFormat
	    (
		XtDisplay (w),
		XtWindow (w),
		index,
		(XtPointer) format,
		BUFSIZ,
		&cpln
	    );
	if (cpln != 0)
	{
	    strncpy (format_name, format, cpln);
	    format_name[cpln] = 0;
	    if (
		   strcmp (format_name, "STRING") == 0
		)
		valid = True;
	}
	index++;
    }
    while (cpln != 0);
    if (valid)
    {
	rc = XmClipboardStartRetrieve
	    (XtDisplay (w), XtWindow (w), CurrentTime);
	if (rc == ClipboardSuccess)
	{
	    do
	    {
		rc = XmClipboardRetrieve
		    (
			XtDisplay (w),
			XtWindow (w),
			"STRING",
			(XtPointer) buffer,
			(unsigned long) BUFSIZ - 1,
			&num_bytes,
			&private_id
		    );
		buffer[num_bytes] = 0;
		XmVtSend (w, buffer);
	    }
	    while (rc == ClipboardTruncate);
	    if (rc != ClipboardSuccess)
	    {
		retval = False;
	    }
	    else
	    {
		rc = XmClipboardEndRetrieve (XtDisplay (w), XtWindow (w));
		if (rc != ClipboardSuccess)
		{
		    retval = False;
		}
	    }
	}
	else
	{
	    retval = False;
	}
    }
    else
    {
	retval = False;
    }
    return (retval);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: p_cb                                                       */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is the callback for the Paste routine. It is    */
/*+              called when the X Server is ready for the actual data        */
/*+              transfer. It performs the actual paste of data. In this case */
/*+              it simple sends the data to the keyboard queue.              */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             client_data   - XtPointer  - Data for callback                */
/*+             selection     - Atom *     - Current selection struct         */
/*+             type_s        - Atom *     - Type of selection                */
/*+             value         - XtPointer  - Value to paste                   */
/*+             length        - unsigned long *                               */
/*+                                        - Length of value data             */
/*+             format        - int *      - Format of data (8bits)           */
/*+                                                                           */
/*+ Input:      w, client_data, selection, type_s, value, length, format      */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void p_cb (w, client_data, selection, type_s, value, length, format)
     Widget w;
     XtPointer client_data;
     Atom *selection;
     Atom *type_s;
     XtPointer value;
     unsigned long *length;
     int *format;
{
    char *string_value = (char *) value;
    char *data = NULL;
    if ((value != NULL) || (*length != 0))
    {
	data = (char *) malloc ((*length + 1) * sizeof (char));
	strncpy (data, string_value, *length);
	data[*length] = 0;
	XmVtSend (w, data);
	free (data);
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: Motion                                                     */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is called as the mouse moves over the Vt        */
/*+              widget. It is used to change the cursor if the cursor is     */
/*+              over a hyper-link attribute character area.                  */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             event         - XButtonEvent *                                */
/*+                                        - X event for situation            */
/*+                                                                           */
/*+ Input:      w, event                                                      */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void Motion (w, event)
     Widget w;
     XButtonEvent *event;
{
    XmVtWidget cw = (XmVtWidget) w;
    int oldrow = cw->vt.oldrow;
    int oldcolumn = cw->vt.oldcolumn;
    int last = cw->vt.last;
    Cursor local_cursor;
    int row = 0;
    attribute attr = BLANK_ATTR;
    int column = 0;
    row = GetRowFromY (cw, event->y);
    column = GetColumnFromX (cw, event->x);
    if (oldrow != row || oldcolumn != column)
    {
	attr = g_attr (cw, column, row);
	if
	    (
		hasmatching (attr, cw->vt.hyper_value) ||
		(isnone (cw->vt.hyper_value) && isnone (attr))
	    )
	{
	    if (last == 0)
	    {
		local_cursor = XCreateFontCursor (XtDisplay (w), XC_hand2);
		XDefineCursor (XtDisplay (w), XtWindow (w), local_cursor);
	    }
	    last = -1;
	}
	else
	{
	    if (last == -1)
	    {
		local_cursor = XCreateFontCursor (XtDisplay (w), XC_xterm);
		XDefineCursor (XtDisplay (w), XtWindow (w), local_cursor);
	    }
	    last = 0;
	}
    }
    cw->vt.oldrow = row;
    cw->vt.oldcolumn = column;
    cw->vt.last = last;
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: SelectArea                                                 */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine performs an Atomic selection on an area that is */
/*+              a rectangle formed by dragging the first mouse button.       */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             event         - XButtonEvent *                                */
/*+                                        - X event for situation            */
/*+                                                                           */
/*+ Input:      w, event                                                      */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void SelectArea (w, event)
     Widget w;
     XButtonEvent *event;
{
    XmVtWidget cw = (XmVtWidget) w;
    int inx = 0;
    int jnx = 0;
    attribute select_attr = BLANK_ATTR;
    int line_attr = 0;
    int marginx = 0;
    int marginy = 0;
    int row = 0;
    int column = 0;
    int low_y = 0;
    int high_y = 0;
    int low_x = 0;
    int high_x = 0;
    int oldl_y = 0;
    int oldh_y = 0;
    int oldl_x = 0;
    int oldh_x = 0;
    int begin_x = 0;
    int end_x = 0;
    int begin_y = 0;
    int end_y = 0;
    int light_x = 0;
    int light_y = 0;
    char h_data[BUFSIZ];
    char h_cset = 0;
    if (!cw->vt.cut_paste)
	return;
    if (cw->vt.word_selection)
	return;
    if (cw->vt.hyper_started)
	return;
    if (!(cw->vt.selection_started))
    {
	cw->vt.selection_started = True;
	cw->vt.begin_cy = GetRowFromY (cw, event->y);
	cw->vt.begin_cx = GetColumnFromX (cw, event->x);
	cw->vt.end_cy = cw->vt.begin_cy;
	cw->vt.end_cx = cw->vt.begin_cx;
	for (inx = cw->vt.real_minx; inx <= cw->vt.real_maxx; inx++)
	{
	    for (jnx = cw->vt.real_miny; jnx <= cw->vt.real_maxy; jnx++)
	    {
		select_attr = g_attr (cw, inx, jnx);
		clr (&select_attr, ATT_SELECT);
		s_attr (cw, inx, jnx, select_attr);
	    }
	}
	revive_all (cw);
    }
    row = GetRowFromY (cw, event->y);
    column = GetColumnFromX (cw, event->x);
    if (row != cw->vt.end_cy || column != cw->vt.end_cx)
    {
	marginx = abs (column - cw->vt.end_cx);
	marginy = abs (row - cw->vt.end_cy);
	cw->vt.end_cy = row;
	cw->vt.end_cx = column;
	if (cw->vt.end_cy > cw->vt.begin_cy)
	{
	    high_y = cw->vt.end_cy;
	    low_y = cw->vt.begin_cy;
	}
	else
	{
	    low_y = cw->vt.end_cy;
	    high_y = cw->vt.begin_cy;
	}
	if (cw->vt.end_cx > cw->vt.begin_cx)
	{
	    high_x = cw->vt.end_cx;
	    low_x = cw->vt.begin_cx;
	}
	else
	{
	    low_x = cw->vt.end_cx;
	    high_x = cw->vt.begin_cx;
	}
	oldl_x = low_x + marginx;
	oldl_y = low_y + marginy;
	oldh_x = high_x - marginx;
	oldh_y = high_y - marginy;
	begin_x = low_x - marginx;
	begin_y = low_y - marginy;
	end_x = high_x + marginx;
	end_y = high_y + marginy;
	if (end_x > cw->vt.real_maxx)
	    end_x = cw->vt.real_maxx;
	if (end_y > cw->vt.real_maxy)
	    end_y = cw->vt.real_maxy;
	if (begin_x < cw->vt.real_minx)
	    begin_x = cw->vt.real_minx;
	if (begin_y < cw->vt.real_miny)
	    begin_y = cw->vt.real_miny;
	for (inx = begin_y; inx <= end_y; inx++)
	{
	    for (jnx = begin_x; jnx <= end_x; jnx++)
	    {
		line_attr = g_line_attr (cw, inx);
		light_y = inx;
		if (line_attr == 0)
		    light_x = jnx;
		else
		    light_x = (jnx + 1) / 2;
		if (jnx < oldl_x || jnx > oldh_x || inx < oldl_y || inx > oldh_y)
		{
		    if ((jnx <= high_x && jnx >= low_x) && (inx <= high_y && inx >= low_y))
		    {
			select_attr = g_attr (cw, light_x, light_y);
			set (&select_attr, ATT_SELECT);
			s_attr (cw, light_x, light_y, select_attr);
			s_flag (cw, light_x, light_y, S_MOD);
		    }
		    else
		    {
			select_attr = g_attr (cw, light_x, light_y);
			clr (&select_attr, ATT_SELECT);
			s_attr (cw, light_x, light_y, select_attr);
			s_flag (cw, light_x, light_y, S_MOD);
		    }
		}
	    }
	}
    }
    ok_update (cw);
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: SendMouse                                                  */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is called when a send mouse event is requested. */
/*+              It sends the mouse cursor information to the character based */
/*+              application (such as elvis).                                 */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             event         - XButtonEvent *                                */
/*+                                        - X event for situation            */
/*+                                                                           */
/*+ Input:      w, event                                                      */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void SendMouse (w, event)
     Widget w;
     XButtonEvent *event;
{
    XmVtWidget cw = (XmVtWidget) w;
    int row = 0;
    int col = 0;
    char mouse_data[BUFSIZ];

    if (cw->vt.mouse_mode)
    {
	row = GetRowFromY (cw, event->y);
	col = GetColumnFromX (cw, event->x);
	sprintf (mouse_data, "\033[M %c%c", col + 32, row + 32);
	XmVtSend (w, mouse_data);
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: SelectWord                                                 */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine performs an Atomic selection on one word on the */
/*+              screen. This word is identified by having separating spaces  */
/*+              around it.                                                   */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             event         - XButtonEvent *                                */
/*+                                        - X event for situation            */
/*+                                                                           */
/*+ Input:      w, event                                                      */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void SelectWord (w, event)
     Widget w;
     XButtonEvent *event;
{
    XmVtWidget cw = (XmVtWidget) w;
    int xcoord = 0;
    int adj_x = 0;
    int line_attr = 0;
    int ycoord = 0;
    int start = 0;
    int last = 0;
    int inx = 0;
    int jnx = 0;
    attribute h_attr = BLANK_ATTR;
    attribute select_attr = BLANK_ATTR;
    int data = 0;

    ycoord = GetRowFromY (cw, event->y);
    xcoord = GetColumnFromX (cw, event->x);
/**************************************************************************/
/* The following three lines is used to correct for double and wide lines */
/**************************************************************************/
    line_attr = g_line_attr (cw, ycoord);
    if (line_attr != 0)
	xcoord = (xcoord + 1) / 2;

    for (inx = cw->vt.real_minx; inx <= cw->vt.real_maxx; inx++)
    {
	for (jnx = cw->vt.real_miny; jnx <= cw->vt.real_maxy; jnx++)
	{
	    select_attr = g_attr (cw, inx, jnx);
	    clr (&select_attr, ATT_SELECT);
	    s_attr (cw, inx, jnx, select_attr);
	}
    }
    revive_all (cw);
    set (&h_attr, ATT_SELECT);
    cw->vt.selection_started = True;
    cw->vt.word_selection = True;
    inx = cw->vt.real_minx;
    start = inx;
    while (inx <= xcoord)
    {
	if (data == ' ')
	    start = inx;
	data = g_data (cw, inx, ycoord);
	inx++;
    }
    for (inx = start; inx <= cw->vt.real_maxx; inx++)
    {
	data = g_data (cw, inx, ycoord);
	if (data == ' ')
	{
	    inx--;
	    break;
	}
    }
    last = inx;
    if (start <= last)
    {
	for (inx = start; inx <= last; inx++)
	{
	    select_attr = g_attr (cw, inx, ycoord);
	    set (&select_attr, ATT_SELECT);
	    s_attr (cw, inx, ycoord, select_attr);
	    s_flag (cw, inx, ycoord, S_MOD);
	}
    }
    cw->vt.begin_cy = ycoord;
    cw->vt.begin_cx = start;
    cw->vt.end_cy = ycoord;
    cw->vt.end_cx = last;
/**************************************************************************/
/* The following is exclusively to correct for double and wide lines      */
/**************************************************************************/
    if (line_attr != 0)
    {
	cw->vt.begin_cx = (start * 2) - 1;
	cw->vt.end_cx = (last * 2) - 1;
    }
    if (line_attr == 2)
    {
	cw->vt.end_cy = ycoord + 1;
	for (inx = start; inx <= last; inx++)
	{
	    select_attr = g_attr (cw, inx, ycoord + 1);
	    set (&select_attr, ATT_SELECT);
	    s_attr (cw, inx, ycoord + 1, select_attr);
	    s_flag (cw, inx, ycoord + 1, S_MOD);
	}
    }
    if (line_attr == 3)
    {
	cw->vt.begin_cy = ycoord - 1;
	for (inx = start; inx <= last; inx++)
	{
	    select_attr = g_attr (cw, inx, ycoord - 1);
	    set (&select_attr, ATT_SELECT);
	    s_attr (cw, inx, ycoord - 1, select_attr);
	    s_flag (cw, inx, ycoord - 1, S_MOD);
	}
    }
/**************************************************************************/
/* End of code devoted to correcting for double and wide characters       */
/**************************************************************************/
    ok_update (cw);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: BeginFunction                                              */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This action begins either a selection or a hyperlink         */
/*+              transaction. This depends on what events follow.             */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             event         - XButtonEvent *                                */
/*+                                        - X event for situation            */
/*+                                                                           */
/*+ Input:      w, event                                                      */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void BeginFunction (w, event)
     Widget w;
     XButtonEvent *event;
{
    XmVtWidget cw = (XmVtWidget) w;
    int multiclick = 0;
    attribute select_attr = BLANK_ATTR;
    int inx = 0;
    int jnx = 0;
    static time_t lasttime = 0;
    time_t now = 0;
    now = event->time;
    multiclick = XtGetMultiClickTime (XtDisplay (w));
    if (!cw->vt.hyper_started)
    {
	if (
	    ((unsigned long) now - (unsigned long) lasttime) < multiclick &&
	       cw->vt.cut_paste
	    )
	{
	    SelectWord (w, event);
	}
	else
	{
	    ok_update (cw);
	    ArmHyper (w, event);
	    if (!(cw->vt.selection_started))
	    {
		cw->vt.selection_started = True;
		cw->vt.begin_cy = GetRowFromY (cw, event->y);
		cw->vt.begin_cx = GetColumnFromX (cw, event->x);
		cw->vt.end_cy = cw->vt.begin_cy;
		cw->vt.end_cx = cw->vt.begin_cx;
		for (inx = cw->vt.real_minx; inx <= cw->vt.real_maxx; inx++)
		{
		    for (jnx = cw->vt.real_miny; jnx <= cw->vt.real_maxy; jnx++)
		    {
			select_attr = g_attr (cw, inx, jnx);
			clr (&select_attr, ATT_SELECT);
			s_attr (cw, inx, jnx, select_attr);
		    }
		}
		revive_all (cw);
	    }
	}
    }
    lasttime = now;
    return;
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: ArmHyper                                                   */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is used to change the appearance of a          */
/*+              hyperlink section of the screen. This section is any section */
/*+              that has the same attributes as the HyperAttributes          */
/*+              resource. This change in appearance is meant to represent    */
/*+              that at the lifting of the left mouse button the hyperlink   */
/*+              will execute.                                                */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             event         - XButtonEvent *                                */
/*+                                        - X event for situation            */
/*+                                                                           */
/*+ Input:      w, event                                                      */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void ArmHyper (w, event)
     Widget w;
     XButtonEvent *event;
{
    XmVtWidget cw = (XmVtWidget) w;
    int xcoord = 0;
    int ycoord = 0;
    attribute attr = BLANK_ATTR;
    attribute arm_attr = BLANK_ATTR;
    int xfirst = 0;
    int xlast = 0;
    int tmpflag = 0;
    int cset = 0;
    int inx = 0;
    char pldata[BUFSIZ];

    ycoord = GetRowFromY (cw, event->y);
    xcoord = GetColumnFromX (cw, event->x);
    attr = g_attr (cw, xcoord, ycoord);
    cset = g_cset (cw, xcoord, ycoord);
    if
	(
	    hasmatching (attr, cw->vt.hyper_value) ||
	    (isnone (cw->vt.hyper_value) && isnone (attr))
	)
    {
	arm_attr = attr;
	cw->vt.hyper_started = True;
	cw->vt.selection_started = False;
	cw->vt.word_selection = False;
	xfirst = xcoord;
	while
	    (
		xfirst >= cw->vt.real_minx &&
		isequal (attr, g_attr (cw, xfirst, ycoord))
	    )
	{
	    xfirst--;
	}
	xfirst++;
	xlast = xfirst;
	inx = 0;
	while (
		  isequal (attr, g_attr (cw, xlast, ycoord)) &&
		  xlast <= cw->vt.real_maxx
	    )
	{
	    pldata[inx] = g_data (cw, xlast, ycoord);
	    s_flag (cw, xlast, ycoord, S_MOD);
	    xlast++;
	    inx++;
	}
	pldata[inx] = 0;
	if (isset (arm_attr, ATT_GRAPHICS))
	{
	    pldata[1] = 0;
	    if (pldata[0] == ' ')
	    {
		tmpflag = -1;
		while (isset (g_attr (cw, xfirst, ycoord), ATT_GRAPHICS))
		{
		    if (ycoord <= cw->vt.real_miny)
		    {
			tmpflag = 0;
			break;
		    }
		    ycoord--;
		}
		if (tmpflag)
		    ycoord++;
	    }
	    pldata[0] = g_data (cw, xfirst, ycoord);
	}
	if (!isset (attr, ATT_WIDGET))
	{
	    set (&arm_attr, ATT_ARMED);
	    plot (cw, pldata, arm_attr, cset, xfirst, ycoord);
	}
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: ExecHyper                                                  */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is used to change the appearance of a          */
/*+              hyperlink section of the screen as well as execute the link. */
/*+              This section is any section that has the same attributes as  */
/*+              the HyperAttributes resource. resource.                      */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             event         - XButtonEvent *                                */
/*+                                        - X event for situation            */
/*+                                                                           */
/*+ Input:      w, event                                                      */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void ExecHyper (w, event)
     Widget w;
     XButtonEvent *event;
{
    XmVtWidget cw = (XmVtWidget) w;
    char *hyper_data = NULL;
    int xcoord = 0;
    int ycoord = 0;
    int xfirst = 0;
    int xlast = 0;
    int tmpflag = 0;
    attribute attr = BLANK_ATTR;
    int cset = 0;
    int inx = 0;
    int element = -1;
    char pldata[BUFSIZ];
    char datasent[BUFSIZ];

    ycoord = GetRowFromY (cw, event->y);
    xcoord = GetColumnFromX (cw, event->x);
    attr = g_attr (cw, xcoord, ycoord);
    cset = g_cset (cw, xcoord, ycoord);
    if (cw->vt.hyper_started)
    {
	cw->vt.hyper_started = False;
	xfirst = xcoord;
	while
	    (
		xfirst >= cw->vt.real_minx &&
		isequal (attr, g_attr (cw, xfirst, ycoord))
	    )
	{
	    xfirst--;
	}
	xfirst++;
	xlast = xfirst;
	inx = 0;
	while
	    (
		isequal (attr, g_attr (cw, xlast, ycoord)) &&
		xlast <= cw->vt.real_maxx
	    )
	{
	    pldata[inx] = g_data (cw, xlast, ycoord);
	    xlast++;
	    inx++;
	}
	pldata[inx] = 0;
	if (isset (attr, ATT_GRAPHICS))
	{
	    pldata[1] = 0;
	    if (pldata[0] == ' ')
	    {
		tmpflag = -1;
		while (isset (g_attr (cw, xfirst, ycoord), ATT_GRAPHICS))
		{
		    if (ycoord <= cw->vt.real_miny)
		    {
			tmpflag = 0;
			break;
		    }
		    ycoord--;
		}
		if (tmpflag)
		    ycoord++;
	    }
	    pldata[0] = g_data (cw, xfirst, ycoord);
	}
	if (!isset (attr, ATT_WIDGET))
	{
	    plot
		(
		    cw,
		    pldata,
		    attr,
		    cset,
		    xfirst,
		    ycoord
		);
	    for (inx = 0; inx < cw->vt.image_count; inx++)
	    {
		if (cw->vt.images[inx].identity == pldata[0])
		{
		    element = inx;
		}
	    }
	    if (element != -1)
	    {
		hyper_data = cw->vt.images[element].hyper_data;
		if (hyper_data == NULL)
		{
		    XmVtSend (w, convert_esc (cw->vt.hyper_filter, pldata));
		}
		else
		{
		    XmVtSend (w, convert_esc (cw->vt.hyper_filter, hyper_data));
		}
	    }
	    else
	    {
		XmVtSend (w, convert_esc (cw->vt.hyper_filter, pldata));
	    }
	}
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: EndFunction                                                */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine performs several functions. It is used to end a */
/*+              Hyperlink type transaction, and it also is used to finalize  */
/*+              a selection. A selection can be one of two types: a select   */
/*+              on an area or a select on a word. The hyperlink transaction  */
/*+              is executed by the ExecHyper function.                       */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             event         - XButtonEvent *                                */
/*+                                        - X event for situation            */
/*+                                                                           */
/*+ Input:      w, event                                                      */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void EndFunction (w, event)
     Widget w;
     XButtonEvent *event;
{
    int buffer_size = 0;
    int line_attr = 0;
    int inx = 0;
    int jnx = 0;
    int low_y = 0;
    int high_y = 0;
    int low_x = 0;
    int high_x = 0;
    XmVtWidget cw = (XmVtWidget) w;
    if (cw->vt.hyper_started)
    {
	ExecHyper (w, event);
	return;
    }
    else
    {
	cw->vt.selection_started = False;
	cw->vt.word_selection = False;
	if (cw->vt.end_cy > cw->vt.begin_cy)
	{
	    high_y = cw->vt.end_cy;
	    low_y = cw->vt.begin_cy;
	}
	else
	{
	    low_y = cw->vt.end_cy;
	    high_y = cw->vt.begin_cy;
	}
	if (cw->vt.end_cx > cw->vt.begin_cx)
	{
	    high_x = cw->vt.end_cx;
	    low_x = cw->vt.begin_cx;
	}
	else
	{
	    low_x = cw->vt.end_cx;
	    high_x = cw->vt.begin_cx;
	}
	buffer_size = (1 + high_y - low_y) * (2 + high_x - low_x);
	cw->vt.selection = (char *) XtRealloc (cw->vt.selection, buffer_size);
	cw->vt.selection[0] = 0;
	for (inx = low_y; inx <= high_y; inx++)
	{
	    line_attr = g_line_attr (cw, inx);
	    for (jnx = low_x; jnx <= high_x; jnx++)
	    {
		if (line_attr == 0)
		{
		    strcatch (cw->vt.selection, g_data (cw, jnx, inx));
		}
		if (line_attr == 1)
		{
		    strcatch (cw->vt.selection, g_data (cw, (jnx + 1) / 2, inx));
		    jnx++;
		}
		if (line_attr == 2)
		{
		    strcatch (cw->vt.selection, g_data (cw, (jnx + 1) / 2, inx));
		    jnx++;
		}
	    }
	    if (inx != high_y && jnx != high_x)
	    {
		qtrim2 (cw->vt.selection);
		strcatch (cw->vt.selection, 10);
	    }
	}
	qtrim (cw->vt.selection);
	cw->vt.selection_bufsiz = strlen (cw->vt.selection);
	if (
	 XtOwnSelection ((Widget) cw, XA_PRIMARY, event->time, convert_proc,
			 lose_ownership_proc, transfer_done_proc) == False
	    )
	{
	    XtWarning ("Failed to obtain selection ownership.");
	}
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: convert_proc                                               */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is used to respond to queries about what kind   */
/*+              of data does the widget support for selection conversions.   */
/*+              It also actual sends data to other X clients that have       */
/*+              requested a converted section of selection. TARGETS is the   */
/*+              atom that is used to respond to queries about what kind of   */
/*+              target this widget can convert to.                           */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             selection     - Atom *     - Current selection struct         */
/*+             target        - Atom *     - Target type of conversion        */
/*+             type_return   - Atom *     - Type of selection returned       */
/*+             value_return  - XtPointer *                                   */
/*+                                        - Data returned                    */
/*+             length_return - unsigned long *                               */
/*+                                        - Length of data returned          */
/*+             format_return - int *      - Format of data returned          */
/*+                                                                           */
/*+ Input:      w, selection, target, type_return, value_return,              */
/*+ Input:      length_return, format_return                                  */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static Boolean convert_proc (Widget w, Atom * selection, Atom * target, Atom * type_return, XtPointer * value_return, unsigned long *length_return, int *format_return)
{
    XmVtWidget cw = (XmVtWidget) w;
    XSelectionRequestEvent *req = XtGetSelectionRequest (w,
					    *selection, (XtRequestId) NULL);
    if (*target == XA_STRING)
    {
	*length_return = cw->vt.selection_bufsiz;
	*value_return = cw->vt.selection;
	*type_return = XA_STRING;
	*format_return = 8;
	return (True);
    }
    else
    {
	return (False);
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: transfer_done_proc                                         */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is called when a client is done transfering a  */
/*+              selection into its application. The routine is not used in   */
/*+              this widget.                                                 */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             selection     - Atom *     - Current selection struct         */
/*+             target        - Atom *     - Target type of conversion        */
/*+                                                                           */
/*+ Input:      w, selection, target                                          */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void transfer_done_proc (w, selection, target)
     Widget w;
     Atom *selection;
     Atom *target;
{
    XmVtWidget cw = (XmVtWidget) w;
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: lose_ownership_proc                                        */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is called when the Primary selection is lost on */
/*+              the X server. This means that the VT widget must clean up    */
/*+              the highlighting representing the selected data because it   */
/*+              no longer is truly selected.                                 */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             selection     - Atom *     - Current selection struct         */
/*+                                                                           */
/*+ Input:      w, selection                                                  */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void lose_ownership_proc (w, selection)
     Widget w;
     Atom *selection;
{
    XmVtWidget cw = (XmVtWidget) w;
    int inx = 0;
    int jnx = 0;
    attribute select_attr = BLANK_ATTR;

    for (inx = cw->vt.real_minx; inx <= cw->vt.real_maxx; inx++)
    {
	for (jnx = cw->vt.real_miny; jnx <= cw->vt.real_maxy; jnx++)
	{
	    select_attr = g_attr (cw, inx, jnx);
	    clr (&select_attr, ATT_SELECT);
	    s_attr (cw, inx, jnx, select_attr);
	    s_flag (cw, inx, jnx, S_MOD);
	}
    }
    ok_update (cw);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: Resize                                                     */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: Resize is used to reallocate the screen geometry to the new  */
/*+              arrangement. It will clear any new area and retain old area. */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+                                                                           */
/*+ Input:      w                                                             */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void Resize (w)
     Widget w;
{
    XmVtWidget cw = (XmVtWidget) w;
    int maxx = 0;
    int maxy = 0;
    struct winsize arg;

    maxx = GetColumnsFromWidth (cw);
    maxy = GetRowsFromHeight (cw);
    if (cw->vt.rows != maxy || cw->vt.columns != maxy)
	resize_data (cw, maxx, maxy);
    cw->vt.rows = maxy;
    cw->vt.columns = maxx;

    if (XtIsRealized (w))
    {
	Layout (cw, False);
	ClearDeadSpace (cw);
	ok_update (cw);
	if (cw->vt.use_shadow)
	{
	    if (cw->manager.has_focus)
		DrawHighlight (cw);
	    else
		UnDrawHighlight (cw);
	    DrawShadow (cw);
	}
	else
	{
	    UnDrawShadow (cw);
	    UnDrawHighlight (cw);
	}
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: place_cursor                                               */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: Place the cursor in a specific location. This is a routine   */
/*+              called by the screen system, and is located in the graphics  */
/*+              subsystem.                                                   */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+                                                                           */
/*+ Input:      tw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void place_cursor (XmVtWidget tw)
{
    char pldata[3];
    int rcode = 0;
    char cset = 0;
    attribute c_attr = BLANK_ATTR;
    int px = 0;
    int py = 0;
    pldata[0] = g_data (tw, tw->vt.screen_cx, tw->vt.screen_cy);
    pldata[1] = 0;
    cset = g_cset (tw, tw->vt.screen_cx, tw->vt.screen_cy);
    string_set_attr (&c_attr, tw->vt.cursor_attribute);
    px = tw->vt.screen_cx;
    py = tw->vt.screen_cy;
    if (tw->vt.screen_cx >= tw->vt.real_maxx)
	px = tw->vt.real_maxx;
    if (tw->vt.screen_cy >= tw->vt.real_maxy)
	py = tw->vt.real_maxy;
    if (XtIsRealized (tw))
    {
	plot (
		 tw,
		 pldata,
		 c_attr,
		 cset,
		 px,
		 py
	    );
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: remove_cursor                                              */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: Remove the cursor from a specific location. This is a        */
/*+              routine called by the screen system, and is located in the   */
/*+              graphics subsystem.                                          */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+                                                                           */
/*+ Input:      tw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void remove_cursor (XmVtWidget tw)
{
    int px = 0;
    int py = 0;
    char pldata[3];
    attribute attr1 = BLANK_ATTR;
    char cset = 0;
    pldata[0] = g_data (tw, tw->vt.screen_cx, tw->vt.screen_cy);
    pldata[1] = 0;
    attr1 = g_attr (tw, tw->vt.screen_cx, tw->vt.screen_cy);
    cset = g_cset (tw, tw->vt.screen_cx, tw->vt.screen_cy);
    px = tw->vt.screen_cx;
    py = tw->vt.screen_cy;
    if (tw->vt.screen_cx >= tw->vt.real_maxx)
	px = tw->vt.real_maxx;
    if (tw->vt.screen_cy >= tw->vt.real_maxy)
	py = tw->vt.real_maxy;
    if (XtIsRealized (tw))
    {
	plot (
		 tw,
		 pldata,
		 attr1,
		 cset,
		 px,
		 py
	    );
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: plot                                                       */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: Plot a string in a specific location. This is a routine      */
/*+              called by the screen system, and is located in the graphics  */
/*+              subsystem.                                                   */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+             pldata        - char *     - Plot data                        */
/*+             p_attr        - attribute  - Plotting attribute value.        */
/*+             cset          - char       - Character set                    */
/*+             xcoord        - int        - X coordinate                     */
/*+             ycoord        - int        - Y coordinate                     */
/*+                                                                           */
/*+ Input:      tw, pldata, p_attr, cset, xcoord, ycoord                      */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int plot (XmVtWidget tw, char *pldata, attribute p_attr, char cset, int xcoord, int ycoord)
{
    Widget wid = (Widget) tw;
    int width = 0;
    int height = 0;
    int min_width = 0;
    int min_height = 0;
    int rcode = 1;
    int top = 0;
    int bot = 0;
    int mid = 0;
    GC temp_GC = NULL;
    GC foreground_GC = NULL;
    GC background_GC = NULL;
    attribute check;
    Boolean spec_ansi = False;
    int line_attr = 0;
    int xpos = 0;
    int ypos = 0;
    int extra_width = 0;
    int yoffset = 0;
    int top_back = 0;
    int yadjust = 0;

    line_attr = g_line_attr (tw, ycoord);
    foreground_GC = tw->vt.normal_GC;
    background_GC = tw->vt.antinormal_GC;

    switch (cset)
    {
	case CS_LINES:
	    make_lines (pldata);
	    break;
	case CS_UKASCII:
	    make_ukascii (pldata);
	    break;
    }

    if (isset (p_attr, ATT_GRAPHICS))
    {
	if (graphics_plot (tw, pldata, p_attr, xcoord, ycoord) == 0)
	    return (0);
    }
    if (isset (p_attr, ATT_WIDGET))
    {
	widget_plot (tw, pldata, p_attr, xcoord, ycoord);
	return (0);
    }
    if (isset (p_attr, ATT_CURSOR))
    {
	foreground_GC = tw->vt.antinormal_GC;
	background_GC = tw->vt.cursor_GC;
    }
    if (isset (p_attr, ATT_SELECT))
    {
	foreground_GC = tw->vt.antinormal_GC;
	background_GC = tw->vt.select_GC;
    }
    if (isset (p_attr, ATT_BOLD))
    {
	foreground_GC = tw->vt.bold_GC;
    }
    if (isset (p_attr, ATT_DIM))
    {
	foreground_GC = tw->vt.dim_GC;
    }
    if (isset (p_attr, ATT_SPECIAL))
    {
	foreground_GC = tw->vt.special_GC;
    }
    if (isset (p_attr, ATT_ARMED))
    {
	if (isset (p_attr, ATT_SPECIAL))
	    foreground_GC = tw->vt.armed_special_GC;
	else
	    foreground_GC = tw->vt.armed_normal_GC;
    }

/**************************************************/
    /* The following ANSI codes change the foreground */
/**************************************************/

    if (isset (p_attr, ATT_ANSI_30))
    {
	if (isset (p_attr, ATT_BOLD))
	    foreground_GC = tw->vt.ansi8_GC;
	else
	    foreground_GC = tw->vt.ansi0_GC;
    }
    if (isset (p_attr, ATT_ANSI_31))
    {
	if (isset (p_attr, ATT_BOLD))
	    foreground_GC = tw->vt.ansi9_GC;
	else
	    foreground_GC = tw->vt.ansi1_GC;
    }
    if (isset (p_attr, ATT_ANSI_32))
    {
	if (isset (p_attr, ATT_BOLD))
	    foreground_GC = tw->vt.ansi10_GC;
	else
	    foreground_GC = tw->vt.ansi2_GC;
    }
    if (isset (p_attr, ATT_ANSI_33))
    {
	if (isset (p_attr, ATT_BOLD))
	    foreground_GC = tw->vt.ansi11_GC;
	else
	    foreground_GC = tw->vt.ansi3_GC;
    }
    if (isset (p_attr, ATT_ANSI_34))
    {
	if (isset (p_attr, ATT_BOLD))
	    foreground_GC = tw->vt.ansi12_GC;
	else
	    foreground_GC = tw->vt.ansi4_GC;
    }
    if (isset (p_attr, ATT_ANSI_35))
    {
	if (isset (p_attr, ATT_BOLD))
	    foreground_GC = tw->vt.ansi13_GC;
	else
	    foreground_GC = tw->vt.ansi5_GC;
    }
    if (isset (p_attr, ATT_ANSI_36))
    {
	if (isset (p_attr, ATT_BOLD))
	    foreground_GC = tw->vt.ansi14_GC;
	else
	    foreground_GC = tw->vt.ansi6_GC;
    }
    if (isset (p_attr, ATT_ANSI_37))
    {
	if (isset (p_attr, ATT_BOLD))
	    foreground_GC = tw->vt.ansi15_GC;
	else
	    foreground_GC = tw->vt.ansi7_GC;
    }

/**************************************************/
    /* The following ANSI codes change the background */
/**************************************************/

    if (isset (p_attr, ATT_ANSI_40))
    {
	background_GC = tw->vt.ansi0_GC;
    }
    if (isset (p_attr, ATT_ANSI_41))
    {
	background_GC = tw->vt.ansi1_GC;
    }
    if (isset (p_attr, ATT_ANSI_42))
    {
	background_GC = tw->vt.ansi2_GC;
    }
    if (isset (p_attr, ATT_ANSI_43))
    {
	background_GC = tw->vt.ansi3_GC;
    }
    if (isset (p_attr, ATT_ANSI_44))
    {
	background_GC = tw->vt.ansi4_GC;
    }
    if (isset (p_attr, ATT_ANSI_45))
    {
	background_GC = tw->vt.ansi5_GC;
    }
    if (isset (p_attr, ATT_ANSI_46))
    {
	background_GC = tw->vt.ansi6_GC;
    }
    if (isset (p_attr, ATT_ANSI_47))
    {
	background_GC = tw->vt.ansi7_GC;
    }
    if (isset (p_attr, ATT_INVERSE))
    {
	temp_GC = foreground_GC;
	foreground_GC = background_GC;
	background_GC = temp_GC;
	if (background_GC == tw->vt.normal_GC)
	    background_GC = tw->vt.inverse_GC;
    }
    if (isset (p_attr, ATT_BLINK))
    {
	if (foreground_GC == tw->vt.normal_GC)
	    foreground_GC = tw->vt.blink_GC;
	if (tw->vt.blink_toggle)
	{
	    temp_GC = foreground_GC;
	    foreground_GC = background_GC;
	    background_GC = temp_GC;
	}
    }
    if (tw->vt.inverse_mode)
    {
	temp_GC = foreground_GC;
	foreground_GC = background_GC;
	background_GC = temp_GC;
    }
    if (XtIsRealized (wid))
    {
	switch (line_attr)
	{
	    case 1:
		extra_width = tw->vt.cwidth;
		XSetFont (
			     XtDisplay ((Widget) tw),
			     foreground_GC,
			     (tw->vt.active_wide_font)->fid
		    );
		break;
	    case 2:
		extra_width = tw->vt.cwidth;
		yoffset = 1;
		yadjust = tw->vt.cdescent * 2;
		top_back = tw->vt.cheight;
		XSetFont (
			     XtDisplay ((Widget) tw),
			     foreground_GC,
			     (tw->vt.active_double_font)->fid
		    );
		break;
	    case 3:
		yadjust = tw->vt.cdescent * 2;
		extra_width = tw->vt.cwidth;
		XSetFont (
			     XtDisplay ((Widget) tw),
			     foreground_GC,
			     (tw->vt.active_double_font)->fid
		    );
		break;
	}
	xpos =
	    (
		(xcoord - 1) * (tw->vt.cwidth + extra_width) +
		tw->drawing_area.margin_width +
		tw->vt.highlight_thickness +
		tw->manager.shadow_thickness
	    );
	ypos =
	    (
		(yoffset + ycoord - 1) * (tw->vt.cheight) +
		tw->drawing_area.margin_height +
		tw->vt.highlight_thickness +
		tw->manager.shadow_thickness +
		tw->vt.cascent - yadjust
	    );
	width = strlen (pldata) * (tw->vt.cwidth + extra_width);
	height = tw->vt.cheight;
	if (
	       tw->core.background_pixmap == XmUNSPECIFIED_PIXMAP ||
	       isset (p_attr, ATT_CURSOR) ||
	       isset (p_attr, ATT_INVERSE) ||
	       isset (p_attr, ATT_SELECT)
	    )
	{
	    XFillRectangle
		(
		    XtDisplay (wid),
		    XtWindow (wid),
		    background_GC,
		    xpos,
		    ypos - height + tw->vt.cdescent - top_back + yadjust,
		    width,
		    height
		);
	}
	else
	{
	    XClearArea
		(
		    XtDisplay (wid),
		    XtWindow (wid),
		    xpos,
		    ypos - height + tw->vt.cdescent - top_back + yadjust,
		    width,
		    height,
		    False
		);
	}
	XDrawString
	    (XtDisplay (wid), XtWindow (wid), foreground_GC, xpos, ypos, pldata, strlen (pldata));

	if (isset (p_attr, ATT_BOLD))
	{
	    XDrawString (XtDisplay (wid), XtWindow (wid), foreground_GC, xpos + 1, ypos, pldata, strlen (pldata));
	}
	if (isset (p_attr, ATT_UNDERSCORE))
	{
	    XDrawLine (
			  XtDisplay (wid),
			  XtWindow (wid),
			  foreground_GC, xpos, ypos + 1,
		      xpos + (tw->vt.cwidth * strlen (pldata) - 1), ypos + 1
		);
	}
	if (isset (p_attr, ATT_CURSOR2))
	{
	    mid = (xcoord - 1) * (tw->vt.cwidth) +
		tw->drawing_area.margin_width +
		tw->vt.highlight_thickness +
		tw->manager.shadow_thickness + 2;
	    top = (ycoord - 1) * (tw->vt.cheight) +
		tw->drawing_area.margin_height +
		tw->vt.highlight_thickness +
		tw->manager.shadow_thickness;
	    bot = top + tw->vt.cascent;
	    XDrawLine (
			  XtDisplay (wid),
			  XtWindow (wid),
			  tw->vt.cursor_GC,
			  mid, top, mid, bot
		);
	    XDrawLine (
			  XtDisplay (wid),
			  XtWindow (wid),
			  tw->vt.cursor_GC,
			  mid - 2, top, mid + 2, top
		);
	    XDrawLine (
			  XtDisplay (wid),
			  XtWindow (wid),
			  tw->vt.cursor_GC,
			  mid - 2, bot, mid + 2, bot
		);
	}
    }
    rcode = 0;
    if (line_attr)
    {
	XSetFont (
		     XtDisplay ((Widget) tw),
		     foreground_GC,
		     (tw->vt.active_font)->fid
	    );
	/* ************************************************************ */
	/* These fonts can corrupt the borders and shadow and highlight */
	/* so these may need fixed here.                                */
	/* ************************************************************ */
	if (tw->vt.use_shadow)
	{
	    if (tw->manager.has_focus)
		DrawHighlight (tw);
	    else
		UnDrawHighlight (tw);
	    DrawShadow (tw);
	}
	else
	{
	    UnDrawShadow (tw);
	    UnDrawHighlight (tw);
	}
	ClearDeadSpace (tw);
    }
    return (rcode);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: graphics_plot                                              */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is used to plot high resolution graphics at a   */
/*+              specified location. These graphics are in Xpm format. Please */
/*+              notice that this routine protects sections of the screen     */
/*+              from further plots. This may block out some text if graphics */
/*+              is located at the same text coordinates.                     */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+             pldata        - char *     - Plot data                        */
/*+             attr          - attribute  - Type of characters               */
/*+             xcoord        - int        - X coordinate                     */
/*+             ycoord        - int        - Y coordinate                     */
/*+                                                                           */
/*+ Input:      tw, pldata, attr, xcoord, ycoord                              */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int graphics_plot (XmVtWidget tw, char *pldata, attribute attr, int xcoord, int ycoord)
{
    unsigned int width = 0;
    unsigned int height = 0;
    GC edge_GC;
    int data_x = 0;
    int data_y = 0;
    int data_width = 0;
    int data_height = 0;
    int edge_x = 0;
    int edge_y = 0;
    int edge_width = 0;
    int edge_height = 0;
    int xpix = 0;
    int ypix = 0;
    int xext = 0;
    int yext = 0;
    int inx = 0;
    int xc2 = 0;
    int yc2 = 0;
    int vb = 0;
    int hb = 0;
    int edge = 2;
    int lim_width = 0;
    int lim_height = 0;
    int found = 0;
    Window dw;
    int dm = 0;
    unsigned int dm2 = 0;
    Pixmap currentPixmap = XmUNSPECIFIED_PIXMAP;
    Widget wid = (Widget) tw;


    if (pldata[0] == ' ')
	return (0);
    for (inx = 0; inx < tw->vt.image_count; inx++)
    {
	if (tw->vt.images[inx].identity == pldata[0])
	{
	    found = -1;
	    currentPixmap = tw->vt.images[inx].Pixmap;
	    width = tw->vt.images[inx].width;
	    height = tw->vt.images[inx].height;
	}
    }
    if (!found)
    {
	currentPixmap = XmGetPixmap
	    (
		XtScreen (wid), tw->vt.undefined_icon,
		tw->vt.icon_foreground_color, tw->vt.icon_background_color
	    );
	if (currentPixmap != XmUNSPECIFIED_PIXMAP && currentPixmap != NULL)
	{
	    XGetGeometry
		(
		    XtDisplay (wid), currentPixmap,
		    &dw, &dm, &dm, &width, &height,
		    &dm2, &dm2
		);
	}
    }
    if (
	   width == 0 ||
	   currentPixmap == XmUNSPECIFIED_PIXMAP ||
	   currentPixmap == NULL
	)
	return (-1);
    edge = tw->vt.image_shadow_thickness;
    edge_GC = tw->vt.armed_normal_GC;
    xpix = GetXFromColumn (tw, xcoord);
    ypix = GetYFromRow (tw, ycoord);
    xc2 = GetColumnFromX (tw, xpix + width + 2 * edge);
    yc2 = GetRowFromY (tw, ypix + height + 2 * edge);
    xext = GetXFromColumn (tw, xc2 + 1);
    yext = GetYFromRow (tw, yc2 + 1);
    vb = tw->drawing_area.margin_height +
	tw->vt.highlight_thickness +
	tw->manager.shadow_thickness;
    hb = tw->drawing_area.margin_width +
	tw->vt.highlight_thickness +
	tw->manager.shadow_thickness;
    if (ypix + height > tw->core.height - vb)
    {
	lim_height = (ypix + height) - (tw->core.height - vb);
    }
    if (xpix + width > tw->core.width - hb)
    {
	lim_width = (xpix + width) - (tw->core.width - hb);
    }
    protect (tw, xcoord, ycoord, xc2, yc2, attr);
    s_data (tw, xcoord, ycoord, pldata[0]);
    XClearArea
	(
	    XtDisplay (wid),
	    XtWindow (wid),
	    xpix,
	    ypix,
	    xext - xpix,
	    yext - ypix,
	    0
	);
    data_x = xpix + edge;
    data_y = ypix + edge;
    data_width = width - lim_width;
    data_height = height - lim_height;
    edge_x = xpix;
    edge_y = ypix;
    edge_width = width - lim_width + 2 * edge;
    edge_height = height - lim_height + 2 * edge;
    if (edge_width + edge_x > tw->core.width - hb)
	edge_width = tw->core.width - hb - edge_x + 1;
    if (edge_height + edge_y > tw->core.height - vb)
	edge_height = tw->core.height - vb - edge_y + 1;
    if (isset (attr, ATT_ARMED))
    {
	XDrawEdge
	    (
		XtDisplay (wid),
		XtWindow (wid),
		tw->manager.bottom_shadow_GC,
		tw->manager.top_shadow_GC,
		edge,
		edge_x,
		edge_y,
		edge_width,
		edge_height
	    );
    }
    else
    {
	XDrawEdge
	    (
		XtDisplay (wid),
		XtWindow (wid),
		tw->manager.top_shadow_GC,
		tw->manager.bottom_shadow_GC,
		edge,
		edge_x,
		edge_y,
		edge_width,
		edge_height
	    );
    }
    XCopyArea
	(
	    XtDisplay (wid),
	    currentPixmap,
	    XtWindow (wid),
	    edge_GC, 0, 0,
	    data_width,
	    data_height,
	    data_x,
	    data_y
	);
    if (tw->vt.use_shadow)
    {
	if (tw->manager.has_focus)
	    DrawHighlight (tw);
	else
	    UnDrawHighlight (tw);
	DrawShadow (tw);
    }
    else
    {
	UnDrawShadow (tw);
	UnDrawHighlight (tw);
    }
    ClearDeadSpace (tw);
    if (!found)
    {
	XmDestroyPixmap (XtScreen (wid), currentPixmap);
    }
    return (0);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: XDrawEdge                                                  */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine looks alot like the XDrawRectangle basic XLib   */
/*+              function except that it uses an upper left and a lower right */
/*+              GC to create a shadow effect on the area bounded.            */
/*+                                                                           */
/*+ Parameters: display       - Display *  - Display for rectangle.           */
/*+             win           - Window     - Window for rectangle             */
/*+             top_left      - GC         - Top Left GC                      */
/*+             bot_right     - GC         - Bottom right GC                  */
/*+             depth         - int        - Thickness of the edge or shadow  */
/*+                                          to draw.                         */
/*+             xcoord        - int        - X coordinate                     */
/*+             ycoord        - int        - Y coordinate                     */
/*+             width         - int        - Width of rectangle               */
/*+             height        - int        - Height of rectangle              */
/*+                                                                           */
/*+ Input:      display, win, top_left, bot_right, depth, xcoord, ycoord,     */
/*+ Input:      width, height                                                 */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void XDrawEdge (Display * display, Window win, GC top_left, GC bot_right, int depth, int xcoord, int ycoord, int width, int height)
{
    int inx = 0;
    int cx1 = 0;
    int cx2 = 0;
    int cx3 = 0;
    int cx4 = 0;
    int cy1 = 0;
    int cy2 = 0;
    int cy3 = 0;
    int cy4 = 0;
    for (inx = 0; inx < depth; inx++)
    {
	cx1 = xcoord + inx;
	cx2 = xcoord + width - inx - 1;
	cx3 = xcoord + inx;
	cx4 = xcoord + width - inx - 1;

	cy1 = ycoord + inx;
	cy2 = ycoord + inx;
	cy3 = ycoord + height - inx - 1;
	cy4 = ycoord + height - inx - 1;
	XDrawLine
	    (
		display,
		win,
		top_left,
		cx1, cy1, cx2, cy2
	    );
	XDrawLine
	    (
		display,
		win,
		bot_right,
		cx3, cy3, cx4, cy4
	    );
	XDrawLine
	    (
		display,
		win,
		top_left,
		cx1, cy1 + 1, cx3, cy3 - 1
	    );
	XDrawLine
	    (
		display,
		win,
		bot_right,
		cx2, cy2 + 1, cx4, cy4 - 1
	    );
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: widget_plot                                                */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is used to place widgets at a specified         */
/*+              location. These widgets are standard Motif widgets. Please   */
/*+              notice that this routine can only place one widget of a      */
/*+              given identity a very odd effect can occur if a particular   */
/*+              widget is plotted twice on the same screen.                  */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+             pldata        - char *     - Plot data                        */
/*+             attr          - attribute  - Type of characters               */
/*+             xcoord        - int        - X coordinate                     */
/*+             ycoord        - int        - Y coordinate                     */
/*+                                                                           */
/*+ Input:      tw, pldata, attr, xcoord, ycoord                              */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: The scrolled text and scrolled list need special     */
/*+                      treatment (as denoted by the special boolean). This  */
/*+                      is apparently because to be properly sized or moved  */
/*+                      they need to be accessed throught the SetValues      */
/*+                      method instead of XtMoveWidget. This seems to be a   */
/*+                      result of having the XmScrolledWindow and child      */
/*+                      Widget so tightly integrated together. If this       */
/*+                      method is not used the XtMoveWidget ends up moving   */
/*+                      the child inside of the ScrolledWindow (or more      */
/*+                      likely its the clipping window) which distorts the   */
/*+                      appearance of the widget.                            */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int widget_plot (XmVtWidget tw, char *pldata, attribute attr, int xcoord, int ycoord)
{
    int xpix = 0;
    int ypix = 0;
    int index = 0;
    int inx = 0;
    Widget current_widget = NULL;
    Widget wid = (Widget) tw;
    Boolean special = False;
    int width = 0;
    int height = 0;
    int xc2 = 0;
    int yc2 = 0;

    if (pldata[0] == ' ')
	return (0);

    for (inx = 0; inx < tw->vt.child_count; inx++)
    {
	if (tw->vt.children[inx].identity == pldata[0])
	{
	    if (tw->vt.children[inx].wtype == SCROLLEDTEXT)
	    {
		special = True;
	    }
	    if (tw->vt.children[inx].wtype == SCROLLEDLIST)
	    {
		special = True;
	    }
	    current_widget = tw->vt.children[inx].vtchild;
	    index = inx;
	    break;
	}
    }
    if (current_widget != NULL && !tw->vt.children[index].painted)
    {
	xpix = GetXFromColumn (tw, xcoord);
	ypix = GetYFromRow (tw, ycoord);
	width = tw->vt.children[index].width * tw->vt.cwidth;
	height = tw->vt.children[index].height * tw->vt.cheight;
	xc2 = tw->vt.children[index].width + xcoord - 1;
	yc2 = tw->vt.children[index].height + ycoord - 1;
	protect (tw, xcoord, ycoord, xc2, yc2, attr);
	s_data (tw, xcoord, ycoord, pldata[0]);
	if (XtIsManaged (current_widget))
	{
	    if (special)
	    {
		XtVaSetValues
		    (
			current_widget,
			XmNx, xpix,
			XmNy, ypix,
			XmNwidth, width,
			XmNheight, height,
			NULL
		    );
	    }
	    else
	    {
		XtMoveWidget (current_widget, xpix, ypix);
		XtResizeWidget (current_widget, width, height, 0);
	    }
	}
	else
	{
	    if (special)
	    {
		XtVaSetValues
		    (
			current_widget,
			XmNx, xpix,
			XmNy, ypix,
			XmNwidth, width,
			XmNheight, height,
			NULL
		    );
	    }
	    else
	    {
		XtMoveWidget (current_widget, xpix, ypix);
		XtResizeWidget (current_widget, width, height, 0);
	    }
	    XtManageChild (current_widget);
	}

	tw->vt.children[index].painted = True;
	tw->vt.children[index].row = ycoord;
	tw->vt.children[index].column = xcoord;
    }
    return (0);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: protect                                                    */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function will protect an area of the screen from having */
/*+              text data written to it. This is used to protect graphics    */
/*+              areas. If this was not done text would overwrite the         */
/*+              graphics.                                                    */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+             xc1           - int        - X coordinate one is the left X   */
/*+                                          coordinate of a protected box    */
/*+             yc1           - int        - Y coordinate one is the top Y    */
/*+                                          coordinate of a protected box    */
/*+             xc2           - int        - X coordinate two is the right X  */
/*+                                          coordinate of a protected box    */
/*+             yc2           - int        - Y coordinate two is the bottom Y */
/*+                                          coordinate of a protected box    */
/*+             attr          - attribute  - Type of characters               */
/*+                                                                           */
/*+ Input:      tw, xc1, yc1, xc2, yc2, attr                                  */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void protect (XmVtWidget tw, int xc1, int yc1, int xc2, int yc2, attribute attr)
{
    int inx = 0;
    int jnx = 0;
    int line_attr = 0;
    int same_x = 0;
    int same_y = 0;

    if (xc1 < tw->vt.real_minx)
	xc1 = tw->vt.real_minx;
    if (xc2 < tw->vt.real_minx)
	xc2 = tw->vt.real_minx;
    if (yc1 < tw->vt.real_miny)
	yc1 = tw->vt.real_miny;
    if (yc2 < tw->vt.real_miny)
	yc2 = tw->vt.real_miny;
    if (xc1 > tw->vt.real_maxx)
	xc1 = tw->vt.real_maxx;
    if (xc2 > tw->vt.real_maxx)
	xc2 = tw->vt.real_maxx;
    if (yc1 > tw->vt.real_maxy)
	yc1 = tw->vt.real_maxy;
    if (yc2 > tw->vt.real_maxy)
	yc2 = tw->vt.real_maxy;
    for (inx = yc1; inx <= yc2; inx++)
    {
	line_attr = g_line_attr (tw, inx);
	for (jnx = xc1; jnx <= xc2; jnx++)
	{
	    if (line_attr == 0)
		same_x = jnx;
	    else
		same_x = (jnx + 1) / 2;
	    same_y = inx;
	    s_attr (tw, same_x, same_y, attr);
	    s_data (tw, same_x, same_y, ' ');
	    s_flag (tw, same_x, same_y, S_SAME);
	}
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: unmanage_unpainted_widgets                                 */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: As its name implies this routine searches the child widget   */
/*+              list to find all those widgets that have not been plotted on */
/*+              the current Vt widget. When it finds one it unmanages the    */
/*+              widget.                                                      */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+                                                                           */
/*+ Input:      tw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void unmanage_unpainted_widgets (XmVtWidget tw)
{
    Widget current_widget = NULL;
    int inx = 0;
    attribute attr = BLANK_ATTR;

    for (inx = 0; inx < tw->vt.child_count; inx++)
    {
	if (!tw->vt.children[inx].painted)
	{
	    current_widget = tw->vt.children[inx].vtchild;
	    if (XtIsManaged (current_widget))
	    {
		attr = g_attr
		    (
			tw,
			tw->vt.children[inx].column,
			tw->vt.children[inx].row
		    );
		if (!(isset (attr, ATT_WIDGET)))
		{
		    XtUnmanageChild (current_widget);
		}
	    }
	}
	else
	{
	    tw->vt.children[inx].painted = False;
	}
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: make_lines                                                 */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: make_lines takes a string of characters and converts them to */
/*+              the proper line drawing characters.                          */
/*+                                                                           */
/*+ Parameters: buffer        - char *     - Buffer of output data            */
/*+                                                                           */
/*+ Input:      buffer                                                        */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int make_lines (char *buffer)
{
    char *ins = NULL;
    for (ins = buffer; ins < buffer + strlen (buffer); ++ins)
    {
	if (*ins >= 0x5f && *ins <= 0x7e)
	    *ins = *ins == 0x5f ? 0x7f : *ins - 0x5f;
    }
    return (0);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: make_ukascii                                               */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine takes a string of characters and searches for   */
/*+              any # symbols and substitutes the correct font character ID  */
/*+              in the screen.                                               */
/*+                                                                           */
/*+ Parameters: buffer        - char *     - Buffer of output data            */
/*+                                                                           */
/*+ Input:      buffer                                                        */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int make_ukascii (char *buffer)
{
    char *ins = NULL;

    for (ins = buffer; ins < buffer + strlen (buffer); ++ins)
    {
	if (*ins == '#')
	    *ins = 0xA3;
    }
    return (0);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: beep                                                       */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: Produce an audible tone. This is a routine called by the     */
/*+              screen system, and is located in the graphics subsystem.     */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+                                                                           */
/*+ Input:      tw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void beep (XmVtWidget tw)
{
    XBell (XtDisplay (tw), 0);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: showgraphic                                                */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is called from the screen command interpreter   */
/*+              to cause the Vt widget to output a graphics image to the     */
/*+              screen. The vt.graphics_name element of the widget has the   */
/*+              filename of the graphics image.                              */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+                                                                           */
/*+ Input:      tw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void showgraphic (XmVtWidget tw)
{
    char *pldata = NULL;
    char identity = 0;
    attribute attr;
    char cset = CS_USASCII;

    identity = tw->vt.graphics_identity[0];
    pldata = (char *) malloc (2);
    pldata[0] = identity;
    pldata[1] = 0;
    reset_attr (&attr);
    set (&attr, ATT_GRAPHICS);
    XmVtLoadIcon ((Widget) tw, identity, tw->vt.graphics_name);
    plot (tw, pldata, attr, cset, tw->vt.screen_cx, tw->vt.screen_cy);
    (tw->vt.screen_cx)++;
    pldata[0] = identity + 1;
    pldata[1] = 0;
    XtVaSetValues ((Widget) tw, XmNgraphicsIdentity, pldata, NULL);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: message_do                                                 */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function calls the special callback for the message     */
/*+              escape sequence. When a message is sent to the Vt Widget     */
/*+              this routine is called and then the callback                 */
/*+              message_callback is executed.                                */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+                                                                           */
/*+ Input:      tw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void message_do (XmVtWidget tw)
{
    info.reason = XmCR_MESSAGE_SENT;
    info.data_buffer = tw->vt.message;
    info.data_count = strlen (tw->vt.message);
    XtCallCallbacks ((Widget) tw, XmNmessageCallback, &info);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: special_msg_do                                             */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is used to service a special message. These    */
/*+              special messages. can have a variety of commands directed    */
/*+              towards the widget.                                          */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+             inputdata     - char *     - This is the special message      */
/*+                                          command and data.                */
/*+                                                                           */
/*+ Input:      tw, inputdata                                                 */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void special_msg_do (XmVtWidget tw, char *inputdata)
{
    Widget current_widget = NULL;
    int com = 0;
    Widget parent = (Widget) tw;
    char *segment = NULL;
    char temp_str[BUFSIZ];
    char com_str[BUFSIZ];
    char converted[BUFSIZ];
    int cwidth = tw->vt.cwidth;
    int cheight = tw->vt.cheight;
    char extend[BUFSIZ];
    char data1[BUFSIZ];
    char data2[BUFSIZ];
    char data3[BUFSIZ];
    char data4[BUFSIZ];
    char data5[BUFSIZ];
    char data6[BUFSIZ];
    char data7[BUFSIZ];
    char data8[BUFSIZ];
    char data9[BUFSIZ];
    char data10[BUFSIZ];
    int wtype = 0;
    int wcol = 10;
    int wrow = 10;
    int inx = 0;
    int scount = 0;
    int ccount = 0;
    char *value = NULL;
    Arg load_args[1000];
    Cardinal ac = 0;
    XmString xmstring = NULL;
    XmString xmstring2 = NULL;

    for (inx = 0; inx < strlen (inputdata); inx++)
    {
	if (inputdata[inx] == ':')
	    ccount++;
	if (ccount == 2)
	{
	    scount = inx + 1;
	    break;
	}
    }
    strcpy (extend, inputdata + scount);
    strcpy (temp_str, inputdata);
    segment = strtok (temp_str, ":");
    com_str[0] = 0;
    data1[0] = 0;
    data2[0] = 0;
    data3[0] = 0;
    data4[0] = 0;
    data5[0] = 0;
    data6[0] = 0;
    data7[0] = 0;
    data8[0] = 0;
    data9[0] = 0;
    data10[0] = 0;
    if (segment != NULL)
    {
	strcpy (com_str, segment);
	sscanf (com_str, "%d", &com);
    }
    segment = strtok (NULL, ":");
    if (segment != NULL)
    {
	strcpy (data1, segment);
    }
    segment = strtok (NULL, ":");
    if (segment != NULL)
    {
	strcpy (data2, segment);
    }
    segment = strtok (NULL, ":");
    if (segment != NULL)
    {
	strcpy (data3, segment);
    }
    segment = strtok (NULL, ":");
    if (segment != NULL)
    {
	strcpy (data4, segment);
    }
    segment = strtok (NULL, ":");
    if (segment != NULL)
    {
	strcpy (data5, segment);
    }
    segment = strtok (NULL, ":");
    if (segment != NULL)
    {
	strcpy (data6, segment);
    }
    segment = strtok (NULL, ":");
    if (segment != NULL)
    {
	strcpy (data7, segment);
    }
    segment = strtok (NULL, ":");
    if (segment != NULL)
    {
	strcpy (data8, segment);
    }
    segment = strtok (NULL, ":");
    if (segment != NULL)
    {
	strcpy (data9, segment);
    }
    segment = strtok (NULL, ":");
    if (segment != NULL)
    {
	strcpy (data10, segment);
    }
    switch (com)
    {
	case 1:
	    XmVtLoadIcon ((Widget) tw, data1[0], data2);
	    break;
	case 2:
	    strcat (data2, "\n");
	    XmVtLoadHyperData ((Widget) tw, data1[0], data2);
	    break;
	case 3:
	    XmVtLoadHyperData ((Widget) tw, data1[0], data2);
	    break;
	case 4:
	    XmVtAppendTextChild ((Widget) tw, data1[0], extend);
	    break;
	case 5:
	    sscanf (data3, "%d", &wtype);
	    sscanf (data4, "%d", &wcol);
	    sscanf (data5, "%d", &wrow);
	    XmVtLoadWidget ((Widget) tw, data1[0], data2, wtype, wcol, wrow);
	    break;
	case 6:
	    XmVtDumpTextChild ((Widget) tw, data1[0], data2, data3);
	    break;
	case 7:
	    XmVtBlankWidgets ((Widget) tw);
	    break;
	case 8:
	    data1[0] = tolower (data1[0]);
	    strcpy (converted, convert_esc (data2, "\\s"));
	    value = (char *) malloc (strlen (converted) + 1);
	    strcpy (value, converted);
	    if (strcmp (data1, XmNanswerBack) != 0)
		XtVaSetValues (parent, RES_CONVERT (data1, value), NULL);
	    else
		XtWarning ("AnswerBack can not be set with escape sequences.");
	    break;
	case 9:
	    strcpy (converted, convert_esc (data3, "\\s"));
	    value = (char *) malloc (strlen (converted) + 1);
	    strcpy (value, converted);
	    XmVtChildSetValues (parent, data1[0], data2, value);
	    break;
	case 10:
	    strcat (data2, "\n");
	    XmVtLoadButtonData ((Widget) tw, data1[0], data2);
	    break;
	case 11:
	    XmVtLoadButtonData ((Widget) tw, data1[0], data2);
	    break;
	case 12:
	    sscanf (data2, "%d", &wcol);
	    sscanf (data3, "%d", &wrow);
	    XmVtChildResize (parent, data1[0], wcol, wrow);
	    break;
	case 13:
	    XmVtAppendListChild ((Widget) tw, data1[0], extend);
	    break;
	case 14:
	    if (tw->vt.dialog == NULL)
	    {
		value = strdup (convert_esc (data2, "\\s"));
		xmstring = XmStringCreateLtoR (value, XmFONTLIST_DEFAULT_TAG);
		xmstring2 = XmStringCreateLocalized (data1);
		ac = 0;
		XtSetArg (load_args[ac], XmNmessageString, xmstring);
		ac++;
		XtSetArg (load_args[ac], XmNdialogTitle, xmstring2);
		ac++;
		tw->vt.dialog = XmCreateWarningDialog ((Widget) tw, data1, load_args, ac);
		XmStringFree (xmstring);
		free (value);
		XtAddCallback
		    (
			tw->vt.dialog, XmNokCallback,
			(XtCallbackProc) XmVtDialogOkCB,
			(XtPointer) tw
		    );
		XtAddCallback
		    (
			tw->vt.dialog, XmNcancelCallback,
			(XtCallbackProc) XmVtDialogCancelCB,
			(XtPointer) tw
		    );
		XtAddCallback
		    (
			tw->vt.dialog, XmNhelpCallback,
			(XtCallbackProc) XmVtDialogHelpCB,
			(XtPointer) tw
		    );
		XtManageChild (tw->vt.dialog);
	    }
	    break;
	case 15:
	    if (tw->vt.dialog == NULL)
	    {
		value = strdup (convert_esc (data2, "\\s"));
		xmstring = XmStringCreateLtoR (value, XmFONTLIST_DEFAULT_TAG);
		xmstring2 = XmStringCreateLocalized (data1);
		ac = 0;
		XtSetArg (load_args[ac], XmNmessageString, xmstring);
		ac++;
		XtSetArg (load_args[ac], XmNdialogTitle, xmstring2);
		ac++;
		tw->vt.dialog = XmCreateErrorDialog ((Widget) tw, data1, load_args, ac);
		XmStringFree (xmstring);
		free (value);
		XtAddCallback
		    (
			tw->vt.dialog, XmNokCallback,
			(XtCallbackProc) XmVtDialogOkCB,
			(XtPointer) tw
		    );
		XtAddCallback
		    (
			tw->vt.dialog, XmNcancelCallback,
			(XtCallbackProc) XmVtDialogCancelCB,
			(XtPointer) tw
		    );
		XtAddCallback
		    (
			tw->vt.dialog, XmNhelpCallback,
			(XtCallbackProc) XmVtDialogHelpCB,
			(XtPointer) tw
		    );
		XtManageChild (tw->vt.dialog);
	    }
	    break;
	case 16:
	    if (tw->vt.dialog == NULL)
	    {
		value = strdup (convert_esc (data2, "\\s"));
		xmstring = XmStringCreateLtoR (value, XmFONTLIST_DEFAULT_TAG);
		xmstring2 = XmStringCreateLocalized (data1);
		ac = 0;
		XtSetArg (load_args[ac], XmNmessageString, xmstring);
		ac++;
		XtSetArg (load_args[ac], XmNdialogTitle, xmstring2);
		ac++;
		tw->vt.dialog = XmCreateInformationDialog ((Widget) tw, data1, load_args, ac);
		XmStringFree (xmstring);
		free (value);
		XtAddCallback
		    (
			tw->vt.dialog, XmNokCallback,
			(XtCallbackProc) XmVtDialogOkCB,
			(XtPointer) tw
		    );
		XtAddCallback
		    (
			tw->vt.dialog, XmNcancelCallback,
			(XtCallbackProc) XmVtDialogCancelCB,
			(XtPointer) tw
		    );
		XtAddCallback
		    (
			tw->vt.dialog, XmNhelpCallback,
			(XtCallbackProc) XmVtDialogHelpCB,
			(XtPointer) tw
		    );
		XtManageChild (tw->vt.dialog);
	    }
	    break;
	case 17:
	    if (tw->vt.dialog == NULL)
	    {
		value = strdup (convert_esc (data2, "\\s"));
		xmstring = XmStringCreateLtoR (value, XmFONTLIST_DEFAULT_TAG);
		xmstring2 = XmStringCreateLocalized (data1);
		ac = 0;
		XtSetArg (load_args[ac], XmNmessageString, xmstring);
		ac++;
		XtSetArg (load_args[ac], XmNdialogTitle, xmstring2);
		ac++;
		tw->vt.dialog = XmCreateMessageDialog ((Widget) tw, data1, load_args, ac);
		XmStringFree (xmstring);
		free (value);
		XtAddCallback
		    (
			tw->vt.dialog, XmNokCallback,
			(XtCallbackProc) XmVtDialogOkCB,
			(XtPointer) tw
		    );
		XtAddCallback
		    (
			tw->vt.dialog, XmNcancelCallback,
			(XtCallbackProc) XmVtDialogCancelCB,
			(XtPointer) tw
		    );
		XtAddCallback
		    (
			tw->vt.dialog, XmNhelpCallback,
			(XtCallbackProc) XmVtDialogHelpCB,
			(XtPointer) tw
		    );
		XtManageChild (tw->vt.dialog);
	    }
	    break;
	case 18:
	    if (tw->vt.dialog == NULL)
	    {
		value = strdup (convert_esc (data2, "\\s"));
		xmstring = XmStringCreateLtoR (value, XmFONTLIST_DEFAULT_TAG);
		xmstring2 = XmStringCreateLocalized (data1);
		ac = 0;
		XtSetArg (load_args[ac], XmNmessageString, xmstring);
		ac++;
		XtSetArg (load_args[ac], XmNdialogTitle, xmstring2);
		ac++;
		tw->vt.dialog = XmCreateQuestionDialog ((Widget) tw, data1, load_args, ac);
		XmStringFree (xmstring);
		free (value);
		XtAddCallback
		    (
			tw->vt.dialog, XmNokCallback,
			(XtCallbackProc) XmVtDialogOkCB,
			(XtPointer) tw
		    );
		XtAddCallback
		    (
			tw->vt.dialog, XmNcancelCallback,
			(XtCallbackProc) XmVtDialogCancelCB,
			(XtPointer) tw
		    );
		XtAddCallback
		    (
			tw->vt.dialog, XmNhelpCallback,
			(XtCallbackProc) XmVtDialogHelpCB,
			(XtPointer) tw
		    );
		XtManageChild (tw->vt.dialog);
	    }
	    break;
	case 19:
	    if (tw->vt.dialog == NULL)
	    {
		value = strdup (convert_esc (data2, "\\s"));
		xmstring = XmStringCreateLtoR (value, XmFONTLIST_DEFAULT_TAG);
		xmstring2 = XmStringCreateLocalized (data1);
		ac = 0;
		XtSetArg (load_args[ac], XmNmessageString, xmstring);
		ac++;
		XtSetArg (load_args[ac], XmNdialogTitle, xmstring2);
		ac++;
		tw->vt.dialog = XmCreateWorkingDialog ((Widget) tw, data1, load_args, ac);
		XmStringFree (xmstring);
		free (value);
		XtAddCallback
		    (
			tw->vt.dialog, XmNokCallback,
			(XtCallbackProc) XmVtDialogOkCB,
			(XtPointer) tw
		    );
		XtAddCallback
		    (
			tw->vt.dialog, XmNcancelCallback,
			(XtCallbackProc) XmVtDialogCancelCB,
			(XtPointer) tw
		    );
		XtAddCallback
		    (
			tw->vt.dialog, XmNhelpCallback,
			(XtCallbackProc) XmVtDialogHelpCB,
			(XtPointer) tw
		    );
		XtManageChild (tw->vt.dialog);
	    }
	    break;
	case 20:
	    if (tw->vt.dialog != NULL)
	    {
		XtDestroyWidget (tw->vt.dialog);
		tw->vt.dialog = NULL;
	    }
	    break;
	case 21:
	    if (tw->vt.dialog == NULL)
	    {
		value = strdup (convert_esc (data2, "\\s"));
		xmstring = XmStringCreateLtoR (value, XmFONTLIST_DEFAULT_TAG);
		xmstring2 = XmStringCreateLocalized (data1);
		ac = 0;
		XtSetArg (load_args[ac], XmNmessageString, xmstring);
		ac++;
		XtSetArg (load_args[ac], XmNdialogTitle, xmstring2);
		ac++;
		tw->vt.dialog =
		    XmCreateFileSelectionDialog
		    ((Widget) tw, data1, load_args, ac);
		XmStringFree (xmstring);
		free (value);
		XtAddCallback
		    (
			tw->vt.dialog, XmNokCallback,
			(XtCallbackProc) XmVtFileSelectionDialogOkCB,
			(XtPointer) tw
		    );
		XtAddCallback
		    (
			tw->vt.dialog, XmNcancelCallback,
			(XtCallbackProc) XmVtDialogCancelCB,
			(XtPointer) tw
		    );
		XtAddCallback
		    (
			tw->vt.dialog, XmNhelpCallback,
			(XtCallbackProc) XmVtDialogHelpCB,
			(XtPointer) tw
		    );
		XtManageChild (tw->vt.dialog);
	    }
	    break;
    }
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: send_keys                                                  */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: Send_keys is used to send data to the input buffer of the    */
/*+              widget from a non-keyboard input method.                     */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+             buffer        - char *     - Buffer of output data            */
/*+                                                                           */
/*+ Input:      tw, buffer                                                    */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int send_keys (XmVtWidget tw, char *buffer)
{
    return (XmVtSend ((Widget) tw, buffer));
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: gethostaddr                                                */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is used to find the host address of the        */
/*+              current node.                                                */
/*+                                                                           */
/*+ Parameters: address       - char *     - Address of current node.         */
/*+             length        - size_t     - Length of value data             */
/*+                                                                           */
/*+ Input:      length                                                        */
/*+                                                                           */
/*+ Output:     address                                                       */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
int gethostaddr (address, length)
     char *address;
     size_t length;
{
    int rcode = 0;
    char hostname[BUFSIZ];
    struct in_addr in;
    char *retaddr = NULL;
    struct hostent *result;
    if (gethostname (hostname, BUFSIZ) == 0)
    {
	result = gethostbyname (hostname);
	bcopy ((const char *) result->h_addr, (char *) &in.s_addr, result->h_length);
	retaddr = inet_ntoa (in);
	strncpy (address, retaddr, length);
	rcode = 0;
    }
    else
    {
	rcode = -1;
    }
    return (rcode);
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: convert_esc                                                */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is used to convert strings that have internal   */
/*+              escaped characters. These include the escape, return and     */
/*+              null characters.                                             */
/*+                                                                           */
/*+ Parameters: string        - char *     - This is the input string to      */
/*+                                          single space.                    */
/*+             addon         - char *     - String to substitute if s        */
/*+                                          directive is found.              */
/*+                                                                           */
/*+ Input:      string, addon                                                 */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
char *convert_esc (char *string, char *addon)
{
    static char retval[BUFSIZ];
    int inx = 0;
    int jnx = 0;
    retval[0] = 0;
    for (inx = 0; inx < strlen (string); inx++)
    {
	if (string[inx] == '\\')
	{
	    if (string[inx + 1] == '\\')
	    {
		retval[jnx++] = '\\';
		inx++;
	    }
	    else
	    {
		switch (string[inx + 1])
		{
		    case 's':
			strcat (retval, addon);
			jnx = jnx + strlen (addon);
			break;
		    case 'e':
			retval[jnx++] = 27;
			break;
		    case 'l':
			retval[jnx++] = 12;
			break;
		    case 't':
			retval[jnx++] = 9;
			break;
		    case 'g':
			retval[jnx++] = 7;
			break;
		    case 'n':
			retval[jnx++] = 10;
			break;
		    case 'c':
			retval[jnx++] = 13;
			break;
		    case '0':
			retval[jnx++] = 0;
			break;
		}
		inx++;
	    }
	}
	else
	{
	    if (string[inx] == '%')
	    {
		if (string[inx + 1] == 's')
		{
		    strcat (retval, addon);
		    jnx = jnx + strlen (addon);
		    inx++;
		}
		else
		{
		    retval[jnx++] = string[inx];
		}
	    }
	    else
	    {
		retval[jnx++] = string[inx];
	    }
	}
	retval[jnx] = 0;
    }
    retval[jnx] = 0;
    return (retval);
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: change_width                                               */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function is used to resize the screen from escape       */
/*+              sequences. This is used by standard ANSI escape sequences.   */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+             scr_width     - int        - New width of screen.             */
/*+                                                                           */
/*+ Input:      tw, scr_width                                                 */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void change_width (XmVtWidget tw, int scr_width)
{
    Widget cw = (Widget) tw;

    XtVaSetValues (cw, XmNcolumns, scr_width, NULL);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: answer                                                     */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This function sends the answerback message to the input      */
/*+              keyboard queue. This routine is called when a character 5    */
/*+              (answer back) is interpreted.                                */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+                                                                           */
/*+ Input:      tw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
void answer (XmVtWidget tw)
{
    Widget cw = (Widget) tw;
    XmVtSend (cw, tw->vt.answer_back);
}

/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: GeometryManager                                            */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This is a normal Method that is called when children have    */
/*+              requested position or size changes be performed on them.     */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+             request_ge    - XtWidgetGeometry *                            */
/*+                                        - This is the geometry request to  */
/*+                                          the GeometryManager routine.     */
/*+             reply_ge      - XtWidgetGeometry *                            */
/*+                                        - This is the response to a        */
/*+                                          GeometryManager request.         */
/*+                                                                           */
/*+ Input:      w, request_ge, reply_ge                                       */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static XtGeometryResult GeometryManager (w, request_ge, reply_ge)
     Widget w;
     XtWidgetGeometry *request_ge;
     XtWidgetGeometry *reply_ge;
{
    Widget parent = XtParent (w);
    XmVtWidget tw = (XmVtWidget) parent;
    XtGeometryResult result = XtGeometryYes;
    Dimension xpos = 0;
    Dimension ypos = 0;
    Dimension width = 0;
    Dimension height = 0;
    Dimension mw = tw->drawing_area.margin_width;
    Dimension mh = tw->drawing_area.margin_height;
    Dimension potential_x = w->core.x;
    Dimension potential_y = w->core.y;
    Dimension potential_width = w->core.width;
    Dimension potential_height = w->core.height;
    xpos = request_ge->x;
    ypos = request_ge->y;
    width = request_ge->width;
    height = request_ge->height;

    if (NEED (CWWidth))
    {
	potential_width = width;
    }
    if (NEED (CWHeight))
    {
	potential_height = height;
    }
    if (NEED (CWX))
    {
	potential_x = xpos;
	if (xpos < 0)
	    xpos = 0;
	if (xpos > potential_width)
	    xpos = potential_width;
    }
    if (NEED (CWY))
    {
	potential_y = ypos;
	if (ypos < 0)
	    ypos = 0;
	if (ypos > potential_height)
	    ypos = potential_height;
    }
    if (width + potential_x > tw->core.width - 2 * mw)
    {
	width = tw->core.width - 2 * mw - potential_x;
    }
    if (height + potential_y > tw->core.height - 2 * mh)
    {
	height = tw->core.height - 2 * mh - potential_y;
    }

    reply_ge->request_mode = request_ge->request_mode;

    if ((request_ge->request_mode & XtCWQueryOnly) == 0)
    {
	if (NEED (CWWidth))
	{
	    w->core.width = width;
	    reply_ge->width = width;
	}
	if (NEED (CWHeight))
	{
	    w->core.height = height;
	    reply_ge->height = height;
	}
	if (NEED (CWX))
	{
	    w->core.x = xpos;
	    reply_ge->x = xpos;
	}
	if (NEED (CWY))
	{
	    w->core.y = ypos;
	    reply_ge->y = ypos;
	}
	if (NEED (CWBorderWidth))
	{
	    w->core.border_width = request_ge->border_width;
	    reply_ge->border_width = request_ge->border_width;
	}
	result = XtGeometryYes;
    }
    else
    {
	result = XtGeometryDone;
    }
    return (result);
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: InsertChild                                                */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This is a standard method that is called when a new widget   */
/*+              is inserted into the Vt Widget.                              */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+                                                                           */
/*+ Input:      w                                                             */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void InsertChild (w)
     Widget w;
{
    Widget parent = XtParent (w);
    XmVtWidget tw = (XmVtWidget) parent;
    int count = 0;
    int index = 0;
    int identity = 0;
    char name[BUFSIZ];
    char pldata[BUFSIZ];
    attribute attr = BLANK_ATTR;
    int xcoord = 0;
    int ycoord = 0;
    int ch_width = XtWidth (w) / (tw->vt.cwidth);
    int ch_height = XtHeight (w) / (tw->vt.cheight);
    char cset = CS_USASCII;
    Boolean doplot = False;
    set (&attr, ATT_WIDGET);

    if (!tw->vt.internal_insert)
    {
	index = tw->vt.child_count;
	if (strlen (tw->vt.graphics_identity) == 1)
	{
	    identity = tw->vt.graphics_identity[0];
	    tw->vt.graphics_identity[0] = identity + 1;
	}
	else
	{
	    tw->vt.graphics_identity = XtRealloc (tw->vt.graphics_identity, 2);
	    tw->vt.graphics_identity[0] = 'a';
	    identity = tw->vt.graphics_identity[0];
	}
	ycoord = GetRowFromY (tw, XtY (w));
	xcoord = GetColumnFromX (tw, XtX (w));
	strcpy (pldata, tw->vt.graphics_identity);
	sprintf (name, "ExternalWidget_%c", identity);
	tw->vt.children[index].callback_data = NULL;
	tw->vt.children[index].name = (char *) malloc (strlen (name) + 1);
	strcpy (tw->vt.children[index].name, name);
	tw->vt.children[index].identity = identity;
	tw->vt.children[index].wtype = PUSHBUTTON;
	tw->vt.children[index].width = ch_width;
	tw->vt.children[index].height = ch_height;
	tw->vt.children[index].row = ycoord;
	tw->vt.children[index].column = xcoord;
	tw->vt.children[index].painted = False;
	tw->vt.children[index].vtchild = w;
	(tw->vt.child_count)++;
	doplot = True;
    }

    count = tw->composite.num_children;
    tw->composite.children = (WidgetList)
	XtRealloc
	((char *) tw->composite.children, sizeof (Widget) * (count + 1));
    tw->composite.num_children = count + 1;
    (tw->composite.children[count]) = w;

    if (doplot)
    {
	s_attr (tw, xcoord, ycoord, attr);
	s_data (tw, xcoord, ycoord, identity);
	s_cset (tw, xcoord, ycoord, cset);
	s_flag (tw, xcoord, ycoord, S_MOD);
	widget_plot (tw, pldata, attr, xcoord, ycoord);
    }

    Layout (tw, True);
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: ChangeManaged                                              */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This is a normal Method called when a child of the Vt Widget */
/*+              changes whether it is managed or not. With the Vt widget     */
/*+              this does not mean very much. The size of the main widget    */
/*+              does not depend on its children. So if a widget pops in and  */
/*+              out of managment it simply appears and disappears from the   */
/*+              Vt widget. Basicaly this routine is a stub in place of       */
/*+              XmDrawingArea behavior which tries to change the size of     */
/*+              this widget when all of the children are unmanaged.          */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+                                                                           */
/*+ Input:      w                                                             */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void ChangeManaged (w)
     Widget w;
{
    XmVtWidget tw = (XmVtWidget) w;
    return;
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: Layout                                                     */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is used under several circumstances to update   */
/*+              the layout of children of the Vt widget. This is mostly used */
/*+              to update the scrollbar on the right hand side of the Vt     */
/*+              widget. These circumstances might include a change in        */
/*+              background color or a change in the number of rows.          */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+             notify_parent - Boolean    - This Boolean value is used to    */
/*+                                          determine if the parent widget   */
/*+                                          should be notified of a request  */
/*+                                          for new size. This is not needed */
/*+                                          for instance when the shell      */
/*+                                          parent has been resized by the   */
/*+                                          window manager.                  */
/*+                                                                           */
/*+ Input:      tw, notify_parent                                             */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void Layout (XmVtWidget tw, Boolean notify_parent)
{
    Cursor local_cursor;
    struct winsize arg;
    Widget w = (Widget) tw;
    Dimension vt_width = 0;
    Dimension vt_height = 0;
    Dimension reply_height = 0;
    Dimension reply_width = 0;
    Dimension almost_height = 0;
    Dimension almost_width = 0;
    Dimension xpos = 0;
    Dimension ypos = 0;
    Dimension width = 0;
    Dimension height = 0;
    int req_columns = tw->vt.columns;
    int req_rows = tw->vt.rows;
    int inx = 0;
    int jnx = 0;
    int index = 0;
    int num_children = tw->composite.num_children;
    WidgetList children = tw->composite.children;
    Widget child = NULL;
    XtGeometryResult result = XtGeometryYes;
    int new_columns = 0;
    int new_rows = 0;
    int cwidth = tw->vt.cwidth;
    int cheight = tw->vt.cheight;
    xpos = tw->core.width -
	tw->vt.highlight_thickness -
	tw->vt.scroll_bar_width;

    ypos = tw->vt.highlight_thickness + 1;
    width = tw->vt.scroll_bar_width;
    height = tw->core.height - (2 * tw->vt.highlight_thickness) - 2;

    for (inx = 0; inx < num_children; inx++)
    {
	child = children[inx];
	XtVaSetValues
	    (
		child,
		XmNforeground, tw->manager.foreground,
		XmNbackground, tw->core.background_pixel,
		XmNbottomShadowColor, tw->manager.bottom_shadow_color,
		XmNtopShadowColor, tw->manager.top_shadow_color,
		NULL
	    );

	if (child == tw->vt.Vsbar)
	{
	    /* ******************************************************** */
	    /* Special processing for the scrollbar child.              */
	    /* ******************************************************** */
	    XtVaSetValues
		(
		    child,
		    XmNmaximum, tw->vt.max_history + tw->vt.rows,
		    XmNvalue, 0,
		    XmNpageIncrement, tw->vt.rows,
		    XmNincrement, 1,
		    XmNsliderSize, tw->vt.rows,
		    NULL
		);
	    XtConfigureWidget (child, xpos, ypos, width, height, 0);
	}
	else
	{
/* ********************************************************************* */
/*  Extra processing is placed here in an else for VT widget children    */
/* ********************************************************************* */
	    index = -1;
	    for (jnx = 0; jnx < tw->vt.child_count; jnx++)
	    {
		if (tw->vt.children[jnx].vtchild == child)
		{
		    index = jnx;
		}
	    }
	    if (index != -1)
	    {
		xpos = GetXFromColumn (tw, tw->vt.children[index].column);
		ypos = GetYFromRow (tw, tw->vt.children[index].row);
		width = cwidth * tw->vt.children[index].width;
		height = cheight * tw->vt.children[index].height;
		XtConfigureWidget (child, xpos, ypos, width, height, 0);
	    }
	}
    }
/* *************************************************** */
/* Try our resize with the requested rows and columns  */
/* if notify_parent is True.                           */
/* *************************************************** */
    if (notify_parent)
    {
	vt_width = GetWidthFromColumns (tw);
	vt_height = GetHeightFromRows (tw);

	result = XtMakeResizeRequest
	    (
		w,
		vt_width, vt_height,
		&reply_width, &reply_height
	    );
    }
/* *************************************************** */
/* This callback may try to force it by resizing the   */
/* top shell with XmVtSyncSize.  It depends on the     */
/* developer.                                          */
/* *************************************************** */
    info.reason = XmCR_NEW_FONT;
    info.data_buffer = NULL;
    info.data_count = 0;
    XtCallCallbacks ((Widget) tw, XmNadjustCallback, &info);
    if (result == XtGeometryAlmost && notify_parent)
    {
	result = XtMakeResizeRequest
	    (
		w,
		reply_width, reply_height,
		&almost_width, &almost_height
	    );
	reply_width = almost_width;
	reply_height = almost_height;
    }
/* *************************************************** */
/* If the value is yes for the above attempt at resize */
/* then we can set the tw->core. values for the Get... */
/* routines to use.                                    */
/* *************************************************** */
    if (result == XtGeometryYes && notify_parent)
    {
	tw->core.width = reply_width;
	tw->core.height = reply_height;
    }
    new_rows = GetRowsFromHeight (tw);
    new_columns = GetColumnsFromWidth (tw);
    resize_data (tw, new_columns, new_rows);
    tw->vt.rows = new_rows;
    tw->vt.columns = new_columns;
    if (tw->vt.monitoring)
    {
	ioctl (tw->vt.iofd, TIOCGWINSZ, &arg);
	if (arg.ws_xpixel != tw->core.width || arg.ws_ypixel != tw->core.height)
	{
	    arg.ws_col = tw->vt.columns;
	    arg.ws_row = tw->vt.rows;
	    arg.ws_xpixel = tw->core.width;
	    arg.ws_ypixel = tw->core.height;
	    ioctl (tw->vt.iofd, TIOCSWINSZ, &arg);
	}
    }
    return;
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: ClearDeadSpace                                             */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This routine is used to clean up a section of the screen     */
/*+              that is blank area but that might get clutterd with          */
/*+              extrainious graphics. This is caused by a couple of          */
/*+              situations. First, graphics output can overwrite the edge of */
/*+              the windows clear space. This space is the border between    */
/*+              text and the shadow. Sometimes the wide and double height    */
/*+              fonts cause the same problem.                                */
/*+                                                                           */
/*+ Parameters: tw            - XmVtWidget - VT Widget data                   */
/*+                                                                           */
/*+ Input:      tw                                                            */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void ClearDeadSpace (XmVtWidget tw)
{
    int dead_height = 0;
    int dead_width = 0;
    int extra_width = 0;
    int hborder = tw->drawing_area.margin_width;
    int vborder = tw->drawing_area.margin_height;
    int bd = 0;
    int descent = 4;
    Widget wid = (Widget) tw;

    if (tw->vt.scrolled)
	extra_width = tw->vt.scroll_bar_width;
    descent = tw->vt.cdescent;
    bd = tw->vt.highlight_thickness +
	tw->manager.shadow_thickness;
    dead_height = tw->core.height - GetHeightFromRows (tw);
    dead_width = tw->core.width - GetWidthFromColumns (tw);
    if (XtIsRealized (tw))
    {
	XClearArea
	    (
		XtDisplay (wid),
		XtWindow (wid),
		bd,
		tw->core.height - bd - dead_height - vborder - descent,
		tw->core.width - 2 * bd,
		dead_height + vborder + descent,
		False
	    );
	XClearArea
	    (
		XtDisplay (wid),
		XtWindow (wid),
		tw->core.width - bd - dead_width - hborder - extra_width,
		bd,
		dead_width + hborder + extra_width,
		tw->core.height - 2 * bd,
		False
	    );
	XClearArea
	    (
		XtDisplay (wid),
		XtWindow (wid),
		bd,
		bd,
		tw->core.width - 2 * bd,
		vborder,
		False
	    );
	XClearArea
	    (
		XtDisplay (wid),
		XtWindow (wid),
		bd,
		bd,
		hborder,
		tw->core.height - 2 * bd,
		False
	    );
    }
}


/*+****************************************************************************/
/*+                                                                           */
/*+ Function name: DeleteChild                                                */
/*+                                                                           */
/*+ Program ID:    vtwidget                                                   */
/*+                                                                           */
/*+ Description: This is a standard method that is called when a widget is    */
/*+              deleted from the Vt widget. It is needed to properly size    */
/*+              the window when the scrollbar disappears.                    */
/*+                                                                           */
/*+ Parameters: w             - Widget     - Passed Widget                    */
/*+                                                                           */
/*+ Input:      w                                                             */
/*+                                                                           */
/*+ Output:     None                                                          */
/*+                                                                           */
/*+ Special Logic Notes: None                                                 */
/*+                                                                           */
/*+****************************************************************************/
/*+                                                                           */
/*+                           MODIFICATION LOG                                */
/*+                                                                           */
/*+   DATE        AUTHOR         DESCRIPTION                                  */
/*+ --------    --------------   -------------------------------------------- */
/*+ 04/22/97    Bruce M. Corwin  Initial Release                              */
/*+                                                                           */
/*+****************************************************************************/
static void DeleteChild (Widget w)
{
    XmVtWidget tw = (XmVtWidget) XtParent (w);

    ((&xmDrawingAreaClassRec)->composite_class.delete_child) (w);
    Layout (tw, True);
}
/* ********************************** */
/* End of extra code.                 */
/* ********************************** */
