/*
 * $XConsortium: SmeBSBP.h,v 1.6 89/12/11 15:20:15 kit Exp $
 *
 * Copyright 1989 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Chris D. Peterson, MIT X Consortium
 *
 * 3D extensions added: Roland Krause 1997
 * XPM extensions added: Roland Krause 1997
 */

/* 
 * SmeP.h - Private definitions for Sme object
 * 
 */

#ifndef _XawSmeBSBP_h
#define _XawSmeBSBP_h

/***********************************************************************
 *
 * Sme Object Private Data
 *
 ***********************************************************************/

#include <X11/XawPlus/SmeP.h>
#include <X11/XawPlus/SmeBSB.h>

/************************************************************
 *
 * New fields for the Sme Object class record.
 *
 ************************************************************/

typedef struct _SmeBSBClassPart {
  XtPointer extension;
} SmeBSBClassPart;

/* Full class record declaration */

typedef struct _SmeBSBClassRec {
  RectObjClassPart rect_class;
  SmeClassPart     sme_class;
  SmeBSBClassPart  sme_bsb_class;
} SmeBSBClassRec;

extern SmeBSBClassRec smeBSBClassRec;

/* New fields for the Sme Object record */

typedef struct {
/* resources */
  String    label;		/* The entry label. */
  int       vert_space;		/* extra vert space to leave, as a percentage
				   of the font height of the label. */
  Pixmap    left_bitmap,
	    right_bitmap,	/* bitmaps to show */
	    left_clipmask,	/* and their clip masks */
	    right_clipmask;
  Dimension left_margin,
	    right_margin;	/* left and right margins. */
  Pixel     foreground;		/* foreground color. */
  XFontStruct *font;		/* The font to show label in. */
  XtJustify justify;		/* Justification for the label. */

/* private resources. */

  Boolean   set_values_area_cleared; /* Remember if we need to unhighlight. */
  GC	    norm_gc;		/* noral color gc. */
  GC 	    rev_gc;		/* reverse color gc. */
  GC 	    gray_gc, lgray_gc;	/* Normal color (grayed out) gc's. */
  GC	    invert_gc;		/* gc for flipping colors. */

  Dimension left_bitmap_width;	/* size and depth of each bitmap. */
  Dimension left_bitmap_height;
  unsigned int left_bitmap_depth;
  Dimension right_bitmap_width;
  Dimension right_bitmap_height;
  unsigned int right_bitmap_depth;
} SmeBSBPart;

/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _SmeBSBRec {
  ObjectPart         object;
  RectObjPart        rectangle;
  SmePart	     sme;
  SmeBSBPart	     sme_bsb;
} SmeBSBRec;

/************************************************************
 *
 * Private declarations.
 *
 ************************************************************/

#endif /* _XawSmeBSBP_h */
