/************************************************************************/
/* 									*/
/* FileFunc.h:	   Definition of the FileFunc class			*/
/*		   This class implements the basic functions for a	*/
/*		   file selction dialogue				*/
/*		   Roland Krause 1998					*/
/*									*/
/************************************************************************/

#ifndef FILEFUNC_H
#define FILEFUNC_H

// --- Include ----------------------------------------------------------

#include <sys/types.h>			// Types for access on the file system
#include <dirent.h>			// Access on directories
#include <sys/stat.h>			// File informations

#include <X11/Intrinsic.h>		// Header of Xt
#include <X11/XawPlus/IconList.h>	// Type for directory structure


// --- Definitions ------------------------------------------------------

#define PATH_LEN	200		// Maximum length of Pathnames
#define ICON_WIDTH	16		// Width and height of the
#define ICON_HEIGHT	16		// used icons

typedef enum
{
  FF_FAULT,				// Irregular entry
  FF_FILE,				// Regular file
  FF_DIRECTORY				// Directory
}
  XeFileType;


// --- Class definition -------------------------------------------------

class FileFunc
{
  private:

	// Pixmaps with their clip masks.
	// These pixmaps are used as icons in the file lists

	Pixmap	folderPix, folderClip,		// for folders
		shadefoldPix, shadefoldClip,	// not accessible folders
		filePix, fileClip,		// ordinary files
		shadefilePix, shadefileClip,	// not accessible files
		toolPix, toolClip;		// executable files

	Display 	*display;		// The display the icons are created for
	XawIconList	*Directory;		// The current directory content


  protected:

	int	IconDepth;			// Color depth of the icons

	// Protected methods of this class
						// Determine the needed icon dependend on
						// the access rights of the file
	Pixmap GetIcon(char *FileName, unsigned short FileFlags);
	Pixmap GetClip(Pixmap Icon);		// Determine the clip mask for an icon
	void FreeFileList(void);		// Free the Directory structure
						// Build one file entry of the file list
	void BuildListEntry(char *String, char *Name, int FNameLen, struct stat *FileInfo);
	int CheckFNames(DIR *dir);		// Check the length of filenames
						// Compare two entries for SortFList()
	int Compare(XawIconList ent1, XawIconList ent2, int LenFName);
						// Sort the file names of a directory
	void SortFList(XawIconList *list, int NoOfEntries, int LenFName);


  public:

	char	CurrentPath[PATH_LEN];		// Pathname to the current working directory

	// Public methods of this class

	FileFunc(void);				// The constructor
	void CreateIcons(Widget shell);		// Create all used XPM icons
	void ChangeDir(int Index);		// Change the directory
	void ResetDir(void);			// Go back one step in the directory hierarchy
	char *GetFileName(int Index);		// Build a complete filename from CurrentPath and
						// the file index
	XeFileType CheckFileType(int Index);	// Check the file type of a directory entry
	XawIconList *BuildFileList(void);	// Create a file list of the current directory
	~FileFunc(void);			// The destructor
};

#endif

