/************************************************************************/
/* 									*/
/* FileSelect.h:   Definition of the FileSelect class			*/
/*		   This is the file handling of this application	*/
/*		   Roland Krause 1998, 1999				*/
/*									*/
/************************************************************************/

#ifndef FILESELECT_H
#define FILESELECT_H

// --- Include ----------------------------------------------------------

#include "HandleTar.h"		// Used to work with tar
#include "FileFunc.h"		// The class FileSelect is derived from


// --- Class definition -------------------------------------------------

class FileSelect : public FileFunc
{
  private:
	// Callbacks and work procedures

	friend Boolean ReadTarList(XtPointer clientData);
	friend void Cancel(Widget w, XtPointer clientData, XtPointer callData);
	friend void Ok(Widget w, XtPointer clientData, XtPointer callData);
	friend void SetFileEntry(Widget w, XtPointer clientData, XtPointer callData);

  protected:

	// Some widgets of this class

	Widget	dialogueShell,		// The shell for this dialogue window
		tarListWidget,		// List widget of the root window
		selectFile,		// A text widget with the file name in it
		fileList,		// An icon list widget for the file list
		archNameWidget,		// Label widget for the archive name
		ok, cancel;		// The buttons

	inline void SetFileName(char *FName);		// Set the given filename in the text widget
	inline void UpdateTarList(char *list);		// Update the tar list
	inline void FinishTarList(void);		// Finish the tar list
	inline void ChangeList(XawIconList *FileList);	// Change the file list
	inline void Warning(void);

  public:
	HandleTar *tar;			// My object to work with tar

	FileSelect(Widget shell);	// The constructor
	~FileSelect(void);		// The destructor of this class
					// Do some initializations when the widget
					// tree is realized
	void PostInit(Widget shell,Widget FList, Widget FNameLabel);

	// Handling of the file selection dialog

	inline void PopDown(void);	// To popdown the file selection dialog
	void PopUp(int xPos, int yPos);	// To pop up the file selection dialog

	// Handling of the tar object

	void OpenArchive(char *FName);
	char *GetFileFromArchive(char *listEntry);	// Get a file from the tar archive
};

#endif

