/* $XConsortium: Label.h,v 1.31 91/07/26 19:51:37 converse Exp $ */

/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

#ifndef _XawLabel_h
#define _XawLabel_h

/***********************************************************************
 *
 * Label Widget
 *
 ***********************************************************************/

#include <X11/XawPlus/Simple.h>

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 OBJECT:
 destroyCallback     Callback		Pointer		NULL

 RECTANGLE:
 borderWidth	     BorderWidth	Dimension	1
 height		     Height		Dimension	text height
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	text width
 x		     Position		Position	0
 y		     Position		Position	0

 CORE:
 border		     BorderColor	Pixel		XtDefaultForeground
 background	     Background		Pixel		grey75
 mappedWhenManaged   MappedWhenManaged	Boolean		True

 ADD3DEXT:
 highlightColor	     Background		Pixel		grey90
 shadowColor	     Background		Pixel		grey40
 buttonBorderWidth   Width		Dimension	2

 SIMPLE:
 cursor		     Cursor		Cursor		None
 cursorName	     Cursor		String		NULL
 pointerColor        Foreground         Pixel           XtDefaultForeground
 pointerColorBackground Background      Pixel           XtDefaultBackground
 insensitiveBorder   Insensitive	Pixmap		Gray

 LABEL:
 font		     Font		XFontStruct*	XtDefaultFont
 encoding	     Encoding		unsigned char	XawTextEncoding8bit
 foreground	     Foreground		Pixel		XtDefaultForeground
 internalHeight	     Height		Dimension	2
 internalWidth	     Width		Dimension	4
 justify	     Justify		XtJustify	XtJustifyCenter
 resize		     Resize		Boolean		True
 truncateLabel	     Truncate		Boolean		True
 truncLeftSide	     Truncate		Boolean         False
 label		     Label		String		NULL
 leftBitmap	     LeftBitmap		Bitmap		None *)
 leftClipMask	     LeftBitmap		ClipMask	None *)
 bitmap		     Pixmap		Bitmap		None *)
 clipMask	     Pixmap		ClipMask	None *)

 *)  Standard XBM bitmap with depth 1 or XPM styled pixmap with depth > 1

    You may add the following lines to your applications
    resource file, to get color icons with its clip masks:

	*Label.bitmap:			Info.xpm
	*Label.clipMask:		Info.xpm
	*MenuButton.leftBitmap:		menu12.xpm
	*MenuButton.leftClipMask:	menu12.xpm

    or in the short form :

	*Label.Pixmap:			Info.xpm
	*MenuButton.LeftBitmap:		menu12.xpm
*/

#define XawTextEncoding8bit 0
#define XawTextEncodingChar2b 1

#define XtNleftBitmap   "leftBitmap"
#define XtNleftClipMask "leftClipMask"
#define XtCLeftBitmap   "LeftBitmap"

#define XtNclipMask	"clipMask"
#define XtRClipMask	"ClipMask"

#define XtNencoding	"encoding"
#define XtCEncoding	"Encoding"

#define XtNtruncLabel	"truncateLabel"
#define XtNtruncLeft	"truncLeftSide"
#define XtCTruncate	"Truncate"

#ifndef _XtStringDefs_h_
#define XtNbitmap	"bitmap"
#define XtNforeground	"foreground"
#define XtNlabel	"label"
#define XtNfont		"font"
#define XtNinternalWidth  "internalWidth"
#define XtNinternalHeight "internalHeight"
#define XtNresize	"resize"
#define XtCResize	"Resize"
#define XtCBitmap	"Bitmap"
#endif

/* Class record constants */

extern WidgetClass labelWidgetClass;

typedef struct _LabelClassRec *LabelWidgetClass;
typedef struct _LabelRec      *LabelWidget;

/******************************************************************
 *
 * Public Functions
 *
 *****************************************************************/
 
_XFUNCPROTOBEGIN

/* Truncate the label string if required
 * until it fits into the widget.
 */
extern void TruncateLabelString(
#if NeedFunctionPrototypes
	LabelWidget,			/* widget */
	Dimension			/* width of the widget */
#endif
);

_XFUNCPROTOEND

#endif /* _XawLabel_h */
/* DON'T ADD STUFF AFTER THIS #endif */
