/*
*****************************************************************************
** xminesweep version 2.0  (c) Copyright Ashley Roll, 1993.
** FILE: misc.c
** DATE: 26 Jan 1993
**
** xminesweep is Public Domain. However it, and all the code still belong to me.
** I do, however grant permission for you to freely copy and distribute it on 
** the condition that this and all other copyright notices remain unchanged in 
** all distributions.
**
** This software comes with NO warranty whatsoever. I therefore take no
** responsibility for any damages, losses or problems that the program may 
** cause.
*****************************************************************************
*/

#include <sys/time.h>
#include "xminesweep.h"
#include "bitmaps/unknown.xpm"
#include "bitmaps/marked.xpm"
#include "bitmaps/bomb.xpm"
#include "bitmaps/wrongmarked.xpm"
#include "bitmaps/question.xpm"
#include "bitmaps/b0.xpm"
#include "bitmaps/b1.xpm"
#include "bitmaps/b2.xpm"
#include "bitmaps/b3.xpm"
#include "bitmaps/b4.xpm"
#include "bitmaps/b5.xpm"
#include "bitmaps/b6.xpm"
#include "bitmaps/b7.xpm"
#include "bitmaps/b8.xpm"

extern void Start_Clock();
extern void Stop_Clock();

void place_mines();
void expose();

static int seed; /* global seed */

void seed_my_rand(val)
int val;
{
  seed = val;
}


int  my_rand()
{
static int  a = 16807,
         m = 2147483647,
         q = 12773, /* q = m div a */
         r = 2836, /* r = m mod a */
         lo,hi,test;

  hi = seed / q;
  lo = seed % q;
  test = a * lo - r * hi;
  if (test > 0)
    seed = test;
  else
    seed = test + m;

 return(seed );
}

/*
 * create all the bitmaps 
 */
void init_bitmaps()
{
  (void)XpmCreatePixmapFromData(XtDisplay(toplevel),
		DefaultRootWindow(XtDisplay(toplevel)),
		unknown_xpm, &unknown, NULL, NULL);

  (void)XpmCreatePixmapFromData(XtDisplay(toplevel),
		DefaultRootWindow(XtDisplay(toplevel)),
		marked_xpm, &marked, NULL, NULL);

  (void)XpmCreatePixmapFromData(XtDisplay(toplevel),
		DefaultRootWindow(XtDisplay(toplevel)),
		bomb_xpm, &bomb, NULL, NULL);

  (void)XpmCreatePixmapFromData(XtDisplay(toplevel),
		DefaultRootWindow(XtDisplay(toplevel)),
		wrongmarked_xpm, &wrongmarked, NULL, NULL);

  (void)XpmCreatePixmapFromData(XtDisplay(toplevel),
		DefaultRootWindow(XtDisplay(toplevel)),
		question_xpm, &question, NULL, NULL);

  (void)XpmCreatePixmapFromData(XtDisplay(toplevel),
		DefaultRootWindow(XtDisplay(toplevel)),
		b0_xpm, &b0, NULL, NULL);

  (void)XpmCreatePixmapFromData(XtDisplay(toplevel),
		DefaultRootWindow(XtDisplay(toplevel)),
		b1_xpm, &b1, NULL, NULL);

  (void)XpmCreatePixmapFromData(XtDisplay(toplevel),
		DefaultRootWindow(XtDisplay(toplevel)),
		 b2_xpm, & b2, NULL, NULL);

  (void)XpmCreatePixmapFromData(XtDisplay(toplevel),
		DefaultRootWindow(XtDisplay(toplevel)),
		b3_xpm, &b3, NULL, NULL);

  (void)XpmCreatePixmapFromData(XtDisplay(toplevel),
		DefaultRootWindow(XtDisplay(toplevel)),
		b4_xpm, &b4, NULL, NULL);

  (void)XpmCreatePixmapFromData(XtDisplay(toplevel),
		DefaultRootWindow(XtDisplay(toplevel)),
		b5_xpm, &b5, NULL, NULL);

  (void)XpmCreatePixmapFromData(XtDisplay(toplevel),
		DefaultRootWindow(XtDisplay(toplevel)),
		b6_xpm, &b6, NULL, NULL);

  (void)XpmCreatePixmapFromData(XtDisplay(toplevel),
		DefaultRootWindow(XtDisplay(toplevel)),
		b7_xpm, &b7, NULL, NULL);

  (void)XpmCreatePixmapFromData(XtDisplay(toplevel),
		DefaultRootWindow(XtDisplay(toplevel)),
		b8_xpm, &b8, NULL, NULL);
}

/*
 * initialise the world
 */
void init_world()
{
register int width,height;


  /* place the mines */
  place_mines();
  
  /* set all the CELL status's to UNKNOWN */
  /* and sett the bitmap to 'unknown' */
  for(width=0; width < WIDTH; width++)
    for(height=0; height < HEIGHT; height++)
    {
      SETBITMAP(width,height,unknown); 
      World(width,height,status) = UNKNOWN;
      World(width,height,clicked_on) = FALSE;
    }

    XFlush(disp);
}

void create_buttons()
{
register int width,height;



  /* and create all the label widgets  */
  for(width=0; width < WIDTH; width++)
    for(height=0; height < HEIGHT; height++)
    {
      World(width,height,x) = width * 21;
      World(width,height,y) = height * 21;
    }


}
/*
 * Place the mines in the world and calculate the number of 
 * mines around each CELL
 */
void place_mines()
{
register int t,width,height;
int hits=0;

  /* seed the rand function */
  {
  time_t ti;
  seed_my_rand(time(&ti));
  }

  /* set all the CELL to !is_bomb */
  for(width=0; width < WIDTH; width++)
    for(height=0; height < HEIGHT; height++)
       World(width,height,is_bomb) = FALSE;

  /* place the bombs */
  for(t = 0; t < NUM_MINES; t++)
  {
    height = RANDOM(HEIGHT);
    width = RANDOM(WIDTH);

    while (World(width,height,is_bomb) == TRUE) {
        width = RANDOM(WIDTH);
        height = RANDOM(HEIGHT);
    }
    World(width,height,is_bomb) = TRUE;
  }

  /* calculate the number of mines around each square */
  for(width=0; width < WIDTH; width++)
    for(height=0; height < HEIGHT; height++) {
    int count;
    int left_ok,right_ok,up_ok,down_ok;
      
      count = 0;
      left_ok = (width-1 >=0) ? TRUE:FALSE;
      right_ok = (width+1 < WIDTH) ? TRUE:FALSE;
      up_ok = (height-1 >=0) ? TRUE:FALSE;
      down_ok = (height+1 < HEIGHT) ? TRUE:FALSE;

      if(left_ok) 
        if(World(width-1,height,is_bomb)) count++;  /* left */

      if(right_ok)
        if(World(width+1,height,is_bomb)) count++;  /* right */

      if(up_ok)
        if(World(width,height-1,is_bomb)) count++;  /* up */

      if(down_ok)
        if(World(width,height+1,is_bomb)) count++;  /* down */

      if(left_ok && up_ok)  
        if(World(width-1,height-1,is_bomb)) count++;  /* up left */
        
      if(left_ok && down_ok)
        if(World(width-1,height+1,is_bomb)) count++;  /* down left */

      if(right_ok && up_ok)
        if(World(width+1,height-1,is_bomb)) count++;  /* up right */

      if(right_ok &&down_ok)
        if(World(width+1,height+1,is_bomb)) count++;  /* down right */

      World(width,height,num_bombs_around) = count;
    }
}

/*
 * This achieves exposing all linked squares with Zero bombs around it
 * it recursevly calles expose() and thus my be called by expose again
 */
void expose_zeros(x,y)
int x,y;
{
int left_ok,right_ok,up_ok,down_ok;

      left_ok = (x-1 >=0) ? TRUE:FALSE;
      right_ok = (x+1 < WIDTH) ? TRUE:FALSE;
      up_ok = (y-1 >=0) ? TRUE:FALSE;
      down_ok = (y+1 < HEIGHT) ? TRUE:FALSE;

      if(left_ok)
        if(World(x-1,y,status) == UNKNOWN)   /* left */
          expose(x-1,y);

      if(right_ok)
        if(World(x+1,y,status) == UNKNOWN)   /* right */
          expose(x+1,y);

      if(up_ok)
        if(World(x,y-1,status) == UNKNOWN)   /* up */
          expose(x,y-1);

      if(down_ok)
        if(World(x,y+1,status) == UNKNOWN)   /* down */
          expose(x,y+1);

      if(left_ok && up_ok)
        if(World(x-1,y-1,status) == UNKNOWN) /* up left */
          expose(x-1,y-1);

      if(left_ok && down_ok)
        if(World(x-1,y+1,status) == UNKNOWN)  /* down left */
           expose(x-1,y+1);

      if(right_ok && up_ok)
        if(World(x+1,y-1,status) == UNKNOWN) /* up right */
          expose(x+1,y-1);

      if(right_ok &&down_ok)
        if(World(x+1,y+1,status) == UNKNOWN)  /* down right */
          expose(x+1,y+1);


}


/*
 * expose the CELL x,y 
 */
void expose(x,y)
int x,y;
{

  World(x,y,status) = EXPOSED;
  switch(World(x,y,num_bombs_around))
  {
    case 0:
      SETBITMAP(x,y,b0);
      if(do_expose_zeros)
        expose_zeros(x,y);
      break;

    case 1:
      SETBITMAP(x,y,b1);
      break;

    case 2:
      SETBITMAP(x,y,b2);
      break;

    case 3:
      SETBITMAP(x,y,b3);
      break;

    case 4:
      SETBITMAP(x,y,b4);
      break;

    case 5:
      SETBITMAP(x,y,b5);
      break;

    case 6:
      SETBITMAP(x,y,b6);
      break;

    case 7:
      SETBITMAP(x,y,b7);
      break;

    case 8:
      SETBITMAP(x,y,b8);
      break;


  }
}


void show_mines_left()
{
char string[20];

  sprintf(string,"Mines Left: %d",mines_left);
  XtVaSetValues(countw,XtNlabel,(XtArgVal)string,NULL);

}

/* 
 * the user exposed a mine - expose all squares.
 */
void die()
{
register int x,y;
int missed=FALSE;

  Stop_Clock();
  /* set flag not to do expose_zeros() */
  do_expose_zeros = FALSE;
  dead = TRUE;

    for(x=0; x < WIDTH; x++)
      for(y=0; y < HEIGHT; y++)
      {
        if(World(x,y,status) == MARKED && !World(x,y,is_bomb)) {
          SETBITMAP(x,y,wrongmarked); 
          missed = TRUE;
        }
        else if(World(x,y,status) == MARKED)
               SETBITMAP(x,y,marked); 
        
        else if(World(x,y,is_bomb) && World(x,y,clicked_on)) {
               World(x,y,status) = EXPOSED;
               INVSETBITMAP(x,y,bomb);
        }


        else if(World(x,y,is_bomb) ) {
               World(x,y,status) = EXPOSED;
               SETBITMAP(x,y,bomb);
        }

        else if(World(x,y,status) == UNKNOWN)
                expose(x,y);
       
      }

   if(mines_left > 0)
    XtVaSetValues(statuslw,XtNlabel,(XtArgVal)"You Died (in a messy way)",NULL);
   else
     XtVaSetValues(statuslw,XtNlabel,(XtArgVal)"You Won!!",NULL);

   if(missed)
     XtVaSetValues(statuslw,XtNlabel,(XtArgVal)"You Died (Missed some)",NULL);

   

  /* reset flag to do expose_zeros() */
  do_expose_zeros = TRUE;
}

