
/******************************************************************************************
 *
 * XawConvertStringToPixmap(), XawConvertStringToClipMask():
 *
 * Creates a depth-n Pixmap and its clip mask suitable for icons.
 * "string" represents a pixmap filename which may be absolute,
 * or relative to the global resource pixmapFilePath, class
 * PixmapFilePath.  If the resource is not defined, the default
 * value is the build symbol PIXMAPDIR.
 *
 * To use, include the following in your ClassInitialize procedure:
 *
 * static XtConvertArgRec screenConvertArg[] = {
 *  {XtWidgetBaseOffset, (XtPointer)XtOffsetOf(Widget, core.screen), sizeof(Screen *)},
 *  {XtWidgetBaseOffset, (XtPointer)XtOffsetOf(Widget, core.colormap), sizeof(Colormap)},
 * };
 *
 * XtAddConverter(XtRString, XtRPixmap, XawCvtStringToPixmap,
 *		   screenConvertArg, XtNumber(screenConvertArg));
 *
 * Author: Roland Krause
 * EMail:  rokrause@aol.com
 *
 ******************************************************************************************/

#include	<X11/Intrinsic.h>
#include	<X11/StringDefs.h>
#include	<X11/Xmu/Converters.h>
#include	<X11/Xmu/Drawing.h>

extern Pixmap   XawLocatePixmapFile();

/******************************************************************************************
 *
 * XawCvtStringToPixmap(): Converter for XPM and XBM styled pixmaps
 * 			   If the filname ends with `.xpm', the converter
 * 			   try to convert it as XPM pixmap file, else
 *			   as XBM bitmap.
 *
 ******************************************************************************************/

void XawCvtStringToPixmap(args, numArgs, fromVal, toVal)
XrmValuePtr args;
Cardinal   *numArgs;
XrmValuePtr fromVal;
XrmValuePtr toVal;
{
    static Pixmap pixmap, clipMask;
    char *name = (char *)fromVal->addr;

    /* Number of arguments correct ? */

    if (*numArgs != 2)
    {
       XtWarning("XawCvtStringToPixmap: String to pixmap conversion "
		 "needs screen and colormap arguments.\n");
       return;
    }
    /* Check, if filename ends with `.xpm'. If so, try to convert the file
     * as XPM file format, else try bitmap file format.
     */
    if (strstr(name, ".xpm") == NULL)
         pixmap = XmuLocateBitmapFile(*((Screen **)args[0].addr),
				      name, NULL, 0, NULL, NULL, NULL, NULL);

    else pixmap = XawLocatePixmapFile(*((Screen **)args[0].addr),
				      *((Colormap *)args[1].addr),
				      name, NULL, 0, NULL, NULL, &clipMask);
    /* Conversion failed ? */

    if (pixmap == None) XtStringConversionWarning(name, "Pixmap");

    /* Store the result */

    toVal->size = sizeof(Pixmap);
    toVal->addr = (XtPointer)&pixmap;
}

/******************************************************************************************
 *
 * XawCvtStringToClipMask():Clip mask converter for XPM styled pixmaps.
 * 			    If the filname ends with `.xpm', the converter
 * 			    try to convert it as XPM pixmap file, else
 *			    the conversion fails.
 *
 ******************************************************************************************/

void XawCvtStringToClipMask(args, numArgs, fromVal, toVal)
XrmValuePtr args;
Cardinal   *numArgs;
XrmValuePtr fromVal;
XrmValuePtr toVal;
{
    static Pixmap clipMask;
    char *name = (char *)fromVal->addr;

    /* Number of arguments correct ? */

    if (*numArgs != 2)
    {
       XtWarning("XawCvtStringToClipMask: String to clipMask conversion "
		 "needs screen and colormap arguments.\n");
       return;
    }
    /* Check, if filename ends with `.xpm'. If so, try to convert the file
     * as XPM file format, else try bitmap file format.
     */
    if (strstr(name, ".xpm") == NULL)
      clipMask = XmuLocateBitmapFile(*((Screen **)args[0].addr), name, NULL, 0, NULL, NULL, NULL, NULL);
    else (void)XawLocatePixmapFile(*((Screen **)args[0].addr), *((Colormap *)args[1].addr),
				   name, NULL, 0, NULL, NULL, &clipMask);
    /* Conversion failed ? */

    if (clipMask == None) XtStringConversionWarning(name, "ClipMask");

    /* Store the result */

    toVal->size = sizeof(Pixmap);
    toVal->addr = (XtPointer)&clipMask;
}
