/************************************************************************/
/* 									*/
/* ExtrDialog.h: Definition of the extract dialog class			*/
/*		 This is a dialog to start the file extraction		*/
/*		 Roland Krause 1998					*/
/*									*/
/************************************************************************/

#ifndef EXTRDIALOG_H
#define EXTRDIALOG_H

// --- Include ----------------------------------------------------------

#include <X11/Intrinsic.h>		// Header of Xt

#include "HandleTar.h"			// Handles the interface to tar


// --- Class definition -------------------------------------------------

class ExtrDialog
{
  protected:
	char		 *FileList;	// List of file to extract
	class HandleTar  *tarObj;	// Interface to tar


  public:
	Widget		 dialogShell,	// The shell for this window
			 pathName;	// For the path to extract to

	ExtrDialog(Widget rootShell);	// The constructor
					// Pop up the dialog
	void PopUp(int x, int y, char *path, char *flist, class HandleTar *tar);
	inline void RelFList(void);	// Release memory, allocated by PopUp()
	Boolean Extract(void);		// Extract files from archive
};

#endif
