/************************************************************************/
/* 									*/
/* 	MainWin.h: Definition of the MainWin class			*/
/*		   This class creates the main window and handles all	*/
/*		   events in it.					*/
/*		   Roland Krause 1998					*/
/*									*/
/************************************************************************/

#ifndef MAINWIN_H
#define MAINWIN_H

// --- Include ----------------------------------------------------------

#include <X11/Intrinsic.h>	// Header of Xt

#include "ExtrDialog.h"		// To create the file extraction dialogue
#include "FileSelect.h"		// File handling


// --- Data structures for callbacks ------------------------------------

typedef struct			// Data for callbacks, who needs
{				// access to class methods
   class MainWin    *mainWin;
   class FileSelect *fileDialogue;
   class ExtrDialog *extrDialogue;
}
   ObjectCallbackStruct;


// --- Class definition -------------------------------------------------

class MainWin
{
  private:

   char		*StartSel, *EndSel,	// Selected area in the tar list
		*CurrPosition;		// used by GetSelection(), GetNextSelection()

  protected:

   // Some widgets of the main window

  Widget	tarList,	// List for filnames of a tar archive
		message,	// A label for messages
		quitButton,	// The quit button
		newButton,	// Create a new archive
		openButton,	// Open an archive
		extract,	// extract files from archive
		extrAll,	// Extract all file from archive
		viewButton;	// The view button

  ObjectCallbackStruct ObjCData;		// Data for callbacks


  public:

  Widget	mainShell;			// The shell of this window
  int		shellNumber;			// Number of viewer shell
						// The constructor
  MainWin(Widget shell, FileSelect *selector, ExtrDialog *dialogue);
  inline void GetPosition(int *x, int *y);	// Determine current window position
  char *GetSelection(void);			// Get selection in tar list
  char *GetNextSelection(void);			// Get next entry after a GetSelection()
  char *GetCompleteSelection(void);		// Get all selected files
  void RunIt(XtAppContext app, Widget shell);	// Runs the user interface
};

#endif

