#ifndef _GraphP_h
#define _GraphP_h

/* Modul %M% Release %R% Level %L% Branch %B% Sequenz %S% Created %E% %U% */

/* Copyright 1994 University of Stuttgart
 * This Graph Widget layouts (hierarchical) directed Graphs
 * This Work is based on the X11R5 tree widget
*/

/*
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE UNIVERSITY OF STUTTGART OR
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.

 * Except as contained in this notice, the name of the University of
 * Stuttgart or the names of the authors shall not be used in
 * advertising or otherwise to promote the sale, use or other dealings
 * in this Software without prior written authorization from the
 * University of Stuttgart and the authors.
*/

/*
 * $XConsortium: Tree.c,v 1.42 91/02/20 20:06:07 converse Exp $
 *
 * Copyright 1990 Massachusetts Institute of Technology
 * Copyright 1989 Prentice Hall
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 * 
 * M.I.T., Prentice Hall and the authors disclaim all warranties with regard
 * to this software, including all implied warranties of merchantability and
 * fitness.  In no event shall M.I.T., Prentice Hall or the authors be liable
 * for any special, indirect or cosequential damages or any damages whatsoever
 * resulting from loss of use, data or profits, whether in an action of
 * contract, negligence or other tortious action, arising out of or in
 * connection with the use or performance of this software.
 * 
 * Authors:  Jim Fulton, MIT X Consortium,
 *           based on a version by Douglas Young, Prentice Hall
 * 
 * This widget is based on the Tree widget described on pages 397-419 of
 * Douglas Young's book "The X Window System, Programming and Applications 
 * with Xt OSF/Motif Edition."  The layout code has been rewritten to use
 * additional blank space to make the structure of the graph easier to see
 * as well as to support vertical trees.
 */

/* Author: Roland Zink
           Universitaet Stuttgart
           IPVR
           Breitwiesenstrasse 20-22
           D 70565 Stuttgart (Germany)
           EMail Roland.Zink@informatik.uni-stuttgart.de
*/

#include "Graph.h"

typedef struct _GraphClassPart {
    int ignore;
} GraphClassPart;

typedef struct _GraphClassRec {
    CoreClassPart core_class;
    CompositeClassPart composite_class;
    ConstraintClassPart constraint_class;
    GraphClassPart graph_class;
} GraphClassRec;

extern GraphClassRec graphClassRec;


typedef enum { forward_edge, reverse_edge } EdgeDirection;

typedef enum { layout_edge, real_edge, virtual_edge } EdgeType;

typedef struct { struct Vertice_st *from;
                 struct Vertice_st *to;
               } Edge_t;

typedef struct LayoutEdge_st
               { Edge_t edge;
                 struct VirtualEdge_st *virtual; /* to which virtual edge
                                                    belongs this layout edge */
               } LayoutEdge_t;

typedef struct LayoutEdgeList_st
               { int n_edges;         /* number of edges in list */
		 int max_edges;       /* memory is allocated for these edges */
                 LayoutEdge_t **edges;/* edges */
               } LayoutEdgeList_t;

typedef struct { Edge_t edge;
                 GC gc;				/* used to draw lines */
                 EdgeDirection direction;
                 struct VirtualEdge_st *virtual; /* this real edge is attached
                                                    to a virtual edge */
               } RealEdge_t;

typedef struct { int n_edges;         /* number of edges in list */
		 int max_edges;       /* memory is allocated for these edges */
                 RealEdge_t **edges;  /* edges */
               } RealEdgeList_t;

typedef struct VirtualEdge_st
               { Edge_t edge;
                 LayoutEdgeList_t layouts; /* This virtual edge is represented
                                     through (possible) several layout edges */
                 RealEdgeList_t   reals;   /* This virtual edge represents
                                              (possible) several real edges */
               } VirtualEdge_t;

typedef struct { int n_edges;         /* number of edges in list */
		 int max_edges;       /* memory is allocated for these edges */
                 VirtualEdge_t **edges;  /* edges */
               } VirtualEdgeList_t;

typedef struct Vertice_st
               { Widget w;
                 LayoutEdgeList_t edges;
                 Boolean in_current_search_path;  /* is vertice in the path */
                 Boolean is_dag;      /* is graph "below" vertice a dag */
                 Boolean is_dummy;    /* Is Vertice non-visible dummy node */
                 int level;           /* Level in which vertice is displayed */
                 double elem;         /* Position in level */
                 int x,y,width,height;
               } Vertice_t;

typedef struct
{ Vertice_t **sequence;
  int        n_elems;
  int        max_elems;
  Dimension  maxwidth;
  Dimension  maxheight;
} Level_t;

typedef struct {
    GraphWidget w;
    Dimension maxwidth, maxheight;      /* for shrink wrapping */
    int left;
    Level_t *levels;                    /* for hierachie */
    int n_levels;                       /* number of levels */
    int max_levels;                     /* length of levels-array */
    Vertice_t  **dummies;
    int        n_dummies;
    int        max_dummies;
    VirtualEdgeList_t edges;
    Boolean    explodep;
  } LayoutData_t;

typedef struct {
    /* fields available through resources */
    Dimension hpad;			/* hSpace/HSpace */
    Dimension vpad;			/* vSpace/VSpace */
    Dimension line_width;		/* lineWidth/LineWidth */
    Pixel foreground;			/* foreground/Foreground */
    XtGravity gravity;			/* gravity/Gravity */
    Boolean auto_reconfigure;		/* autoReconfigure/AutoReconfigure */
    /* private fields */
    GC gc;				/* used to draw lines */
    Widget     active_Widget;
    LayoutData_t layout;
} GraphPart;


typedef struct _GraphRec {
    CorePart core;
    CompositePart composite;
    ConstraintPart constraint;
    GraphPart graph;
}  GraphRec;

/*
 * structure attached to all children
 */
typedef struct _GraphConstraintsPart {
    /* resources */
    GC gc;				/* graphGC/GraphGC */
    /* private data */
    Vertice_t vertice;
} GraphConstraintsPart;

typedef struct _GraphConstraintsRec {
   GraphConstraintsPart graph;
} GraphConstraintsRec, *GraphConstraints;


/*
 * useful macros
 */

#define GRAPH_CONSTRAINT(w) \
                   ((GraphConstraints)((w)->core.constraints))

#define GRAPH_HORIZONTAL_DEFAULT_SPACING 20
#define GRAPH_VERTICAL_DEFAULT_SPACING 6
#define IsHorizontal(gw) ((gw)->graph.gravity == WestGravity || \
			  (gw)->graph.gravity == EastGravity)


#if NeedFunctionPrototypes
int FindLayoutEdgeInEdgeList(LayoutEdgeList_t *list,LayoutEdge_t *e);
#else
int FindLayoutEdgeInEdgeList();
#endif

#if NeedFunctionPrototypes
LayoutEdge_t *CreateLayoutEdge(Edge_t edge,VirtualEdge_t *virtual);
#else
LayoutEdge_t *CreateLayoutEdge();
#endif

#if NeedFunctionPrototypes
void InsertLayoutEdgeInEdgeList(LayoutEdgeList_t *list,LayoutEdge_t *e);
#else
void InsertLayoutEdgeInEdgeList();
#endif

#if NeedFunctionPrototypes
void ReplaceLayoutEdgeInEdgeList(LayoutEdgeList_t *list,
                                 LayoutEdge_t *x,LayoutEdge_t *y);
#else
void ReplaceLayoutEdgeInEdgeList();
#endif

#if NeedFunctionPrototypes
void DestroyLayoutEdge(LayoutEdge_t *e);
#else
void DestroyLayoutEdge();
#endif

#if NeedFunctionPrototypes
void DeleteLayoutEdgeInEdgeList(LayoutEdgeList_t *list,LayoutEdge_t *e);
#else
void DeleteLayoutEdgeInEdgeList();
#endif

#endif /* _XawGraphP_h */
