divert(-1)
# AnotherLevel - A FVWM2 Configuration
# Copyright (C) 1996, 1997 Red Hat Software, Inc
#
#	$Id: fvwm2rc.decors.m4,v 1.10 1999/04/05 18:33:46 notting Exp $	
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# This work is derived from:
#       TheNextLevel
#       Copyright 1996 By Greg J. Badros <gjb@cs.duke.edu>
# distributed under GNU General Public License.
#

###########################################################################
# m4 defines for FVWM options
# Be careful w/ these-- m4 is case-sensitive

# FvwmAlias macro will ease the trouble-- you can use all lower case, 
# all uppercase, or *proper* mixed capitalization
# eg. StickyOnTop, stickyontop, or STICKYONTOP all work
# but StickyonTop will *not* work

define(`FvwmAlias',`
define(`$1',`$2')
define(upcase(`$1'),`$2')
define(downcase(`$1'),`$2')
')

FvwmAlias(StickyOnTop,`StaysOnTop,Sticky')
FvwmAlias(WinCircSkip,`WindowListSkip,CirculateSkip')
FvwmAlias(MinimalDecoration,`NoTitle,NoHandles,BorderWidth 1')
FvwmAlias(NoDecoration,`NoTitle,NoHandles,BorderWidth 0')
FvwmAlias(`FullMaximize',`Maximize 100 100')
FvwmAlias(`TallMaximize',`Maximize 0 ifdef(`FVWMTASKBAR',`95',`100')')

FvwmAlias(`WideMaximize',`Maximize 100 0')
FvwmAlias(`WindowListIcons',`WindowList 1 -1')

define(`PctOfScreenInPixelsX',`eval( ($1 * WIDTH) / 100)')
define(`PctOfScreenInPixelsY',`eval( ($1 * HEIGHT) / 100)')

define(`PctOfScreenInPixels',`PctOfScreenInPixelsX($1) PctOfScreenInPixelsY($2)')
define(`PointOfScreen', `PctOfScreenInPixelsX($1)p PctOfScreenInPixelsY($2)p')

define(`GeometryPctOfScreen',`PctOfScreenInPixelsX($1)xPctOfScreenInPixelsY($2)')

ifelse(	eval(WIDTH > 1024),`1',
		`define(`SCREEN_SIZE',`Huge')',
	eval(WIDTH > 800), `1',
		`define(`SCREEN_SIZE',`Large')',
	eval(WIDTH > 640), `1',
		`define(`SCREEN_SIZE',`Medium')',
	`define(`SCREEN_SIZE',`Small')')

# SCREEN_SIZE gets set to Huge, Large, Moderate, or Small (capitalization matters)
#       Pixels wide      >1024  >800   >640        otherwise
#   Generally for screen  1200  1024    800           640
#       dimensions        x800  x768   x600	    x480


###########################################################################
#
# Now set internal macros based on configured parameters
#

ifelse(SCREEN_SIZE,`Small',
`define(`FONT_SIZE',SMALL_SCREEN_BASIC_FONT_SIZE)',
`define(`FONT_SIZE',BASIC_FONT_SIZE)')

define(`FONT_SIZE_X_2',eval(FONT_SIZE * 2))
ifdef(`USE_CLOSE_FOR_DECORATIONS',`define(`DECORATIONS_CLOSE',`Close')',dnl
`define(`DECORATIONS_CLOSE',`Delete')')

# This makes the assumption that our binary name is the basename of the directory
# in which the modules are stored
ifdef(`FVWM_BIN_NAME',`',
`define(`FVWM_BIN_NAME',m4_basename(FVWM_MODULEDIR))')

# Check if Fvwm95 is sourcing this file
ifelse(FVWM_BIN_NAME,fvwm95,`define(`FVWM95')',
 FVWM_BIN_NAME,fvwm95-2,`define(`FVWM95')')

define(`ICONIFY_LABEL',`Hide')
ifdef(`USE_ICONS',`define(`ICONIFY_LABEL',`Iconify')')

#StartProgramIn{ColorXterm,Xterm,Rxvt}(<prg-name-and-options>,<title>,
#                    <x-class-for-resources>
define(`StartProgramInXterm',`IfProgramExistsOrError(ProgramName($1),`xterm -T $2 -n $2 ifelse($3,,,`-name $3') -e $1')')
define(`StartProgramInColorXterm',`IfProgramExistsOrError(ProgramName($1),XTERM `-T $2 -n $2 ifelse($3,,,`-name $3') -e $1 ')')
define(`StartProgramInRxvt',`IfProgramExistsOrError(ProgramName($1),RXVT `-T $2 -n $2 ifelse($3,,,`-name $3') -e $1 ')')

define(`StartNonInteractiveProgramInRxvt',`IfProgramExistsOrError(ProgramName($1),RXVT `-T $2\ --\ Use\ Meta-PgUp/Dn\ to\ Scroll -n $2 ifelse($3,,,`-name $3') -e sh -c "$1 && read waitforreturn"')')

define(`BUTTON_BAR_ROWS_OR_COLS',`Rows')
ifdef(`USE_VERTICAL_BUTTON_BARS',`define(`BUTTON_BAR_ROWS_OR_COLS',`Columns')')

# User might not want mini-icons
define(`__MiniIcon',mini-$1.xpm)
define(`RegularIcon',$1.xpm)

divert

#XTermOtherHost <Host> <Title>
#Starts an xterm running a telnet/rlogin to another host (the xterm runs locally)
AddToFunc XTermOtherHost
+ "I" exec XTERM -name remotexterm -T $0 -n $0 -e RLOGIN_OR_TELNET $1

###########################################################################
#
# Set misc. interaction preferences
#
ClickTime	CLICK_MS
TitleStyle	TITLE_STYLE
ColorMapFocus	COLOR_MAP_FOCUS
DeskTopSize	DESKTOP_SIZE
OpaqueMoveSize	OPAQUE_MOVE_SIZE
EdgeResistance	EDGE_SCROLL_RESISTANCE EDGE_MOVE_RESISTANCE
EdgeScroll	100 100

# DECORS: Now we are ready to include the choosen decoration...
syscmd(test -f HOME/USER_WM_STYLE)
ifelse(sysval,0,`
define(`WM_STYLE', `upcase(translit(sinclude(HOME/USER_WM_STYLE),`
'))')',`
define(`WM_STYLE', `FVWM95')
')

# make sure we have that decor
syscmd(test -f ANOTHERLEVEL/decors/WM_STYLE)
ifelse(sysval,0,`
',`
define(`WM_STYLE', `FVWM95')
')

changecom(%%%)
# `WM_STYLE     '=WM_STYLE
# `WM_STYLE_PATH'=ANOTHERLEVEL/decors/WM_STYLE
changecom(#)

sinclude(ANOTHERLEVEL/decors/WM_STYLE)

###########################################################################
#
# Fonts - one for window titles, another for icons, and another for the menus
#
WindowFont	BASIC_FONT*bold-r*FONT_SIZE*
IconFont	ICON_FONT
MenuStyle	MENUFORE_COLOR MENUBACK_COLOR MENUSHADE_COLOR BASIC_FONT*medium-r*FONT_SIZE* mwm

divert(-1)

ifdef(`MINI_ICONS',`define(`MiniTitleIcon',
`ifelse($1,`',`',`%__MiniIcon($1)%')')',
`define(MiniTitleIcon)')

define(`SetTitleIcon',`ifelse($2,`',`',`Style "$1" MiniIcon __MiniIcon($2)
')')

define(`SetCurrentMenu',`define(`CURRENT_ADD_TO_MENU',$1)')
SetCurrentMenu(`UndefinedLM')

define(`AddNewMenuAndButtonBar',`
ifdef(`PROVIDE_TEAROFF_BUTTON_BAR',`
*$1`'Buttons`'BUTTON_BAR_ROWS_OR_COLS 1
*$1`'ButtonsFore WINFORE_COLOR
*$1`'ButtonsBack WINBACK_COLOR
AddToMenu $1 "$1 Button Bar`'MiniTitleIcon(modules)" Module FvwmButtons $1`'Buttons
')
ifdef(`PROVIDE_TEAROFF_BIG_BUTTON_BAR',`
*$1`'BigButtons`'BUTTON_BAR_ROWS_OR_COLS 2
*$1`'BigButtonsFore WINFORE_COLOR
*$1`'BigButtonsBack WINBACK_COLOR
*$1`'BigButtonsPadding 0 0
*$1`'BigButtonsFont ifdef(`BUTTON_BARS_FONT',`BUTTON_BARS_FONT',`None')
AddToMenu $1 "$1 Big Button Bar`'MiniTitleIcon(modules)" Module FvwmButtons $1`'BigButtons
')
#At least give it a title
ifdef(`PROVIDE_TEAROFF_BIG_BUTTON_BAR',`',ifdef(`PROVIDE_TEAROFF_BUTTON_BAR',`',`
AddToMenu $1 $1 Title'))
AddToMenu $1 "" Nop
SetCurrentMenu($1)
')

# DefineProgram <menu-app-type> <program-label> <miniicon> <bigicon> <command-name>
# (only gets added if <command-name> is an executable program on the
#  current system)
# Be cautious of using quotes in command-name, or elsewhere, as single
# quote can mess up m4, and double quotes can mess up the button bar
# as they interact with the quotes around FvwmButton's Action keyword parameter
# Consider, instead, backslash-escaping all spaces in an argument.
# (See StartNonInteractiveProgramInRxvt definition, below.

changequote([[,]])
define([[Quoted]],[['$1']])
changequote(`,')

# Since we don't want the button's labels to have &'s, we need a macro
# to remove them.
define(`NoAmpersands',`translit(`$*',`&',`')')

define(`DefineProgram',`IfProgramExists(ProgramName($5),`
#FIX: not quite right
#ifelse(eval($# != 5),`0',errprint(`Not 5 args to DefineProgram for $5
#'))dnl
SetTitleIcon(patsubst($5,[ ].*$,),$3)dnl
AddToMenu $1 "$2`'MiniTitleIcon($3)" Exec $5
ifdef(`PROVIDE_TEAROFF_BUTTON_BAR',`
ifelse($3,,,*$1`'Buttons(Icon __MiniIcon($3), Action Quoted(`Exec "ProgramName($5)" $5')))
')
ifdef(`PROVIDE_TEAROFF_BIG_BUTTON_BAR',`
ifelse($4,,*$1`'BigButtons(Title "NoAmpersands($2)", Action Quoted(`Exec "ProgramName($5)" $5')),
`*$1`'BigButtons(Icon RegularIcon($4), Action Quoted(`Exec "ProgramName($5)" $5'))')
')
ifdef(`USE_ICONS',`
ifelse($4,,,`Style "ProgramName($5)" Icon RegularIcon($4)')')
')')

# MenuAndButtonEntry <menu>  <label> <miniicon> <bigicon> <command-name>
#                       1        2         3       4          5
# Be cautious of using quotes in command-name, or elsewhere, as single
# quote can mess up m4, and double quotes can mess up the button bar
# as they interact with the quotes around FvwmButton's Action keyword parameter
define(`MenuAndButtonEntry',`
AddToMenu $1 "$2`'MiniTitleIcon($3)" $5
ifdef(`PROVIDE_TEAROFF_BUTTON_BAR',`
ifelse($3,,,*$1`'Buttons(Icon __MiniIcon($3), Action "$5"))
')
ifdef(`PROVIDE_TEAROFF_BIG_BUTTON_BAR',`
ifelse($4,,*$1`'BigButtons(Title "NoAmpersands($2)", Action "$5"),`
*$1`'BigButtons(Icon RegularIcon($4), Action "$5")')
')')

# MenuSeparator <menu>
define(`MenuSeparator',`AddToMenu $1 "" Nop')

define(`DefineProgramLM',`DefineProgram(CURRENT_ADD_TO_MENU,$@)')
define(`MenuAndButtonEntryLM',`MenuAndButtonEntry(CURRENT_ADD_TO_MENU,$@)')
define(`MenuSeparatorLM',`MenuSeparator(CURRENT_ADD_TO_MENU,$@)')

#Note: Use SetCurrentMenu(<menu name>) to make the *LM commands use <menu name>
# as the menu to add to

divert

AddToMenu WindowManagers
+ ""	Title
+  "FVWM 95"		Restart /usr/X11R6/bin/RunWM.Fvwm95
+  "Lesstif WM"		Restart /usr/X11R6/bin/RunWM.MWM
IfProgramExists(`afterstep',	`+  "AfterStep"		Restart /usr/X11R6/bin/RunWM.AfterStep')
IfProgramExists(`wmaker',	`+  "WindowMaker"	Restart /usr/X11R6/bin/RunWM.WindowMaker')

TraceForErrors(`finished decorating...')
