;;; -*- coding: iso-2022-7bit  -*-
;;; mucs.el --- for MULE-UCS configuration

;; Copyright (C) 1997 Miyashita Hisashi

;; Keywords: mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;; Comment:

(defconst mucs-version "0.01(YUME:$BL4(B)")

(defvar emacs-value-bits 28)
(defvar mucs-code-range-bits 24)
(defvar mucs-data-path "reldata/")

(defvar mucs-current-package nil)

(defun mucs-max-code ()
  (1- (lsh 1 mucs-code-range-bits)))

(defun mucs-number-mask ()
  (lognot 0))

(defmacro mucs-define-package (package &rest form)
  "Enclose a unit of package with this.
By this specification, MULE-UCS may judge
whether generate a new program to prepare.
You should make PACKAGE same of your package name
that you set in `provide' function."
  (if (not (symbolp package))
      (signal 'wrong-type-argument package))
  (setq mucs-current-package package)
  (put mucs-current-package 'mucs-registered-tables nil)
  (put mucs-current-package 'mucs-registered-ccls nil)
  (append
   `(let ((mucs-current-package (quote ,package))))
   form))
    

(defmacro mucs-define-simple-coding-system
  (symbol mnemonic doc-string decode-tr encode-tr)
  (require 'mucs-ccl)
  (let ((encode-ccl-data (mucs-ccl-setup-ccl-program encode-tr))
	(decode-ccl-data (mucs-ccl-setup-ccl-program decode-tr))
	(ccl-symbol-func
	 (lambda (suf)
	   (intern (format "%s-%s" (symbol-name symbol) suf))))
	ccl-encode-sym
	ccl-decode-sym)
    (setq ccl-encode-sym
	  (funcall ccl-symbol-func "ccl-encoder")
	  ccl-decode-sym
	  (funcall ccl-symbol-func "ccl-decoder"))

    (mucs-ccl-add-registration ccl-encode-sym)
    (mucs-ccl-add-registration ccl-encode-sym)

    `(progn
       ,(car encode-ccl-data)
       ,(car decode-ccl-data)
       (declare-ccl-program 
	 ,ccl-encode-sym
	 ,(cdr encode-ccl-data))
       (declare-ccl-program
	 ,ccl-decode-sym
	 ,(cdr decode-ccl-data))
       (make-coding-system
	(quote ,symbol) 4 ,mnemonic ,doc-string 
	(quote ,(cons ccl-decode-sym
		      ccl-encode-sym))))))

(provide 'mucs)
