; -*- coding: iso-2022-7bit  -*-
;;; ujisx0201.el --- tables between UCS and JIS X 0201

;; Copyright (C) 1997 Miyashita Hisashi

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, ISO8859

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

(put 'latin-jisx0201 'unicode 'jis-x-0201-latin-vs-unicode-alist)
(put 'katakana-jisx0201 'unicode 'jis-x-0201-katakana-vs-unicode-alist)

(defvar
  jis-x-0201-latin-vs-unicode-alist
  (mapcar
   (lambda (x)
     (cons (make-char 'latin-jisx0201 (car x))
	   (cdr x)))
   '((?\x20 . ?\x20)
     (?\x21 . ?\x21)
     (?\x22 . ?\x22)
     (?\x23 . ?\x23)
     (?\x24 . ?\x24)
     (?\x25 . ?\x25)
     (?\x26 . ?\x26)
     (?\x27 . ?\x27)
     (?\x28 . ?\x28)
     (?\x29 . ?\x29)
     (?\x2a . ?\x2a)
     (?\x2b . ?\x2b)
     (?\x2c . ?\x2c)
     (?\x2d . ?\x2d)
     (?\x2e . ?\x2e)
     (?\x2f . ?\x2f)
     (?\x30 . ?\x30)
     (?\x31 . ?\x31)
     (?\x32 . ?\x32)
     (?\x33 . ?\x33)
     (?\x34 . ?\x34)
     (?\x35 . ?\x35)
     (?\x36 . ?\x36)
     (?\x37 . ?\x37)
     (?\x38 . ?\x38)
     (?\x39 . ?\x39)
     (?\x3a . ?\x3a)
     (?\x3b . ?\x3b)
     (?\x3c . ?\x3c)
     (?\x3d . ?\x3d)
     (?\x3e . ?\x3e)
     (?\x3f . ?\x3f)
     (?\x40 . ?\x40)
     (?\x41 . ?\x41)
     (?\x42 . ?\x42)
     (?\x43 . ?\x43)
     (?\x44 . ?\x44)
     (?\x45 . ?\x45)
     (?\x46 . ?\x46)
     (?\x47 . ?\x47)
     (?\x48 . ?\x48)
     (?\x49 . ?\x49)
     (?\x4a . ?\x4a)
     (?\x4b . ?\x4b)
     (?\x4c . ?\x4c)
     (?\x4d . ?\x4d)
     (?\x4e . ?\x4e)
     (?\x4f . ?\x4f)
     (?\x50 . ?\x50)
     (?\x51 . ?\x51)
     (?\x52 . ?\x52)
     (?\x53 . ?\x53)
     (?\x54 . ?\x54)
     (?\x55 . ?\x55)
     (?\x56 . ?\x56)
     (?\x57 . ?\x57)
     (?\x58 . ?\x58)
     (?\x59 . ?\x59)
     (?\x5a . ?\x5a)
     (?\x5b . ?\x5b)
     (?\x5c . ?\xa5)
     (?\x5d . ?\x5d)
     (?\x5e . ?\x5e)
     (?\x5f . ?\x5f)
     (?\x60 . ?\x60)
     (?\x61 . ?\x61)
     (?\x62 . ?\x62)
     (?\x63 . ?\x63)
     (?\x64 . ?\x64)
     (?\x65 . ?\x65)
     (?\x66 . ?\x66)
     (?\x67 . ?\x67)
     (?\x68 . ?\x68)
     (?\x69 . ?\x69)
     (?\x6a . ?\x6a)
     (?\x6b . ?\x6b)
     (?\x6c . ?\x6c)
     (?\x6d . ?\x6d)
     (?\x6e . ?\x6e)
     (?\x6f . ?\x6f)
     (?\x70 . ?\x70)
     (?\x71 . ?\x71)
     (?\x72 . ?\x72)
     (?\x73 . ?\x73)
     (?\x74 . ?\x74)
     (?\x75 . ?\x75)
     (?\x76 . ?\x76)
     (?\x77 . ?\x77)
     (?\x78 . ?\x78)
     (?\x79 . ?\x79)
     (?\x7a . ?\x7a)
     (?\x7b . ?\x7b)
     (?\x7c . ?\x7c)
     (?\x7d . ?\x7d)
     (?\x7e . ?\x203e))))

(defvar
  jis-x-0201-katakana-vs-unicode-alist 
  '((?(I!(B . 65377)
    (?(I"(B . 65378)
    (?(I#(B . 65379)
    (?(I$(B . 65380)
    (?(I%(B . 65381)
    (?(I&(B . 65382)
    (?(I'(B . 65383)
    (?(I((B . 65384)
    (?(I)(B . 65385)
    (?(I*(B . 65386)
    (?(I+(B . 65387)
    (?(I,(B . 65388)
    (?(I-(B . 65389)
    (?(I.(B . 65390)
    (?(I/(B . 65391)
    (?(I0(B . 65392)
    (?(I1(B . 65393)
    (?(I2(B . 65394)
    (?(I3(B . 65395)
    (?(I4(B . 65396)
    (?(I5(B . 65397)
    (?(I6(B . 65398)
    (?(I7(B . 65399)
    (?(I8(B . 65400)
    (?(I9(B . 65401)
    (?(I:(B . 65402)
    (?(I;(B . 65403)
    (?(I<(B . 65404)
    (?(I=(B . 65405)
    (?(I>(B . 65406)
    (?(I?(B . 65407)
    (?(I@(B . 65408)
    (?(IA(B . 65409)
    (?(IB(B . 65410)
    (?(IC(B . 65411)
    (?(ID(B . 65412)
    (?(IE(B . 65413)
    (?(IF(B . 65414)
    (?(IG(B . 65415)
    (?(IH(B . 65416)
    (?(II(B . 65417)
    (?(IJ(B . 65418)
    (?(IK(B . 65419)
    (?(IL(B . 65420)
    (?(IM(B . 65421)
    (?(IN(B . 65422)
    (?(IO(B . 65423)
    (?(IP(B . 65424)
    (?(IQ(B . 65425)
    (?(IR(B . 65426)
    (?(IS(B . 65427)
    (?(IT(B . 65428)
    (?(IU(B . 65429)
    (?(IV(B . 65430)
    (?(IW(B . 65431)
    (?(IX(B . 65432)
    (?(IY(B . 65433)
    (?(IZ(B . 65434)
    (?(I[(B . 65435)
    (?(I\(B . 65436)
    (?(I](B . 65437)
    (?(I^(B . 65438)
    (?(I_(B . 65439)))

(provide 'ujisx0201)

