; -*- coding: iso-2022-7bit  -*-
;;; ujisx0208.el --- tables between UCS and JIS X 0208-1990

;; Copyright (C) 1997 Miyashita Hisashi

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, JIS X 0208

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

(put 'japanese-jisx0208 'unicode 'jis-x-0208-1990-vs-unicode-alist)

(defvar
  jis-x-0208-1990-vs-unicode-alist 
  '((?$B!!(B . 12288)
    (?$B!"(B . 12289)
    (?$B!#(B . 12290)
    (?$B!$(B . 65292)
    (?$B!%(B . 65294)
    (?$B!&(B . 12539)
    (?$B!'(B . 65306)
    (?$B!((B . 65307)
    (?$B!)(B . 65311)
    (?$B!*(B . 65281)
    (?$B!+(B . 12443)
    (?$B!,(B . 12444)
    (?$B!-(B . 180)
    (?$B!.(B . 65344)
    (?$B!/(B . 168)
    (?$B!0(B . 65342)
    (?$B!1(B . 65507)
    (?$B!2(B . 65343)
    (?$B!3(B . 12541)
    (?$B!4(B . 12542)
    (?$B!5(B . 12445)
    (?$B!6(B . 12446)
    (?$B!7(B . 12291)
    (?$B!8(B . 20189)
    (?$B!9(B . 12293)
    (?$B!:(B . 12294)
    (?$B!;(B . 12295)
    (?$B!<(B . 12540)
    (?$B!=(B . 8213)
    (?$B!>(B . 8208)
    (?$B!?(B . 65295)
    (?$B!@(B . 92)
    (?$B!A(B . 12316)
    (?$B!B(B . 8214)
    (?$B!C(B . 65372)
    (?$B!D(B . 8230)
    (?$B!E(B . 8229)
    (?$B!F(B . 8216)
    (?$B!G(B . 8217)
    (?$B!H(B . 8220)
    (?$B!I(B . 8221)
    (?$B!J(B . 65288)
      (?$B!K(B . 65289)
    (?$B!L(B . 12308)
    (?$B!M(B . 12309)
    (?$B!N(B . 65339)
      (?$B!O(B . 65341)
    (?$B!P(B . 65371)
      (?$B!Q(B . 65373)
    (?$B!R(B . 12296)
    (?$B!S(B . 12297)
    (?$B!T(B . 12298)
    (?$B!U(B . 12299)
    (?$B!V(B . 12300)
      (?$B!W(B . 12301)
    (?$B!X(B . 12302)
      (?$B!Y(B . 12303)
    (?$B!Z(B . 12304)
    (?$B![(B . 12305)
    (?$B!\(B . 65291)
    (?$B!](B . 8722)
    (?$B!^(B . 177)
    (?$B!_(B . 215)
    (?$B!`(B . 247)
    (?$B!a(B . 65309)
    (?$B!b(B . 8800)
    (?$B!c(B . 65308)
    (?$B!d(B . 65310)
    (?$B!e(B . 8806)
    (?$B!f(B . 8807)
    (?$B!g(B . 8734)
    (?$B!h(B . 8756)
    (?$B!i(B . 9794)
    (?$B!j(B . 9792)
    (?$B!k(B . 176)
    (?$B!l(B . 8242)
    (?$B!m(B . 8243)
    (?$B!n(B . 8451)
    (?$B!o(B . 65509)
    (?$B!p(B . 65284)
    (?$B!q(B . 162)
    (?$B!r(B . 163)
    (?$B!s(B . 65285)
    (?$B!t(B . 65283)
    (?$B!u(B . 65286)
    (?$B!v(B . 65290)
    (?$B!w(B . 65312)
    (?$B!x(B . 167)
    (?$B!y(B . 9734)
    (?$B!z(B . 9733)
    (?$B!{(B . 9675)
    (?$B!|(B . 9679)
    (?$B!}(B . 9678)
    (?$B!~(B . 9671)
    (?$B"!(B . 9670)
    (?$B""(B . 9633)
    (?$B"#(B . 9632)
    (?$B"$(B . 9651)
    (?$B"%(B . 9650)
    (?$B"&(B . 9661)
    (?$B"'(B . 9660)
    (?$B"((B . 8251)
    (?$B")(B . 12306)
    (?$B"*(B . 8594)
    (?$B"+(B . 8592)
    (?$B",(B . 8593)
    (?$B"-(B . 8595)
    (?$B".(B . 12307)
    (?$B":(B . 8712)
    (?$B";(B . 8715)
    (?$B"<(B . 8838)
    (?$B"=(B . 8839)
    (?$B">(B . 8834)
    (?$B"?(B . 8835)
    (?$B"@(B . 8746)
    (?$B"A(B . 8745)
    (?$B"J(B . 8743)
    (?$B"K(B . 8744)
    (?$B"L(B . 172)
    (?$B"M(B . 8658)
    (?$B"N(B . 8660)
    (?$B"O(B . 8704)
    (?$B"P(B . 8707)
    (?$B"\(B . 8736)
    (?$B"](B . 8869)
    (?$B"^(B . 8978)
    (?$B"_(B . 8706)
    (?$B"`(B . 8711)
    (?$B"a(B . 8801)
    (?$B"b(B . 8786)
    (?$B"c(B . 8810)
    (?$B"d(B . 8811)
    (?$B"e(B . 8730)
    (?$B"f(B . 8765)
    (?$B"g(B . 8733)
    (?$B"h(B . 8757)
    (?$B"i(B . 8747)
    (?$B"j(B . 8748)
    (?$B"r(B . 8491)
    (?$B"s(B . 8240)
    (?$B"t(B . 9839)
    (?$B"u(B . 9837)
    (?$B"v(B . 9834)
    (?$B"w(B . 8224)
    (?$B"x(B . 8225)
    (?$B"y(B . 182)
    (?$B"~(B . 9711)
    (?$B#0(B . 65296)
    (?$B#1(B . 65297)
    (?$B#2(B . 65298)
    (?$B#3(B . 65299)
    (?$B#4(B . 65300)
    (?$B#5(B . 65301)
    (?$B#6(B . 65302)
    (?$B#7(B . 65303)
    (?$B#8(B . 65304)
    (?$B#9(B . 65305)
    (?$B#A(B . 65313)
    (?$B#B(B . 65314)
    (?$B#C(B . 65315)
    (?$B#D(B . 65316)
    (?$B#E(B . 65317)
    (?$B#F(B . 65318)
    (?$B#G(B . 65319)
    (?$B#H(B . 65320)
    (?$B#I(B . 65321)
    (?$B#J(B . 65322)
    (?$B#K(B . 65323)
    (?$B#L(B . 65324)
    (?$B#M(B . 65325)
    (?$B#N(B . 65326)
    (?$B#O(B . 65327)
    (?$B#P(B . 65328)
    (?$B#Q(B . 65329)
    (?$B#R(B . 65330)
    (?$B#S(B . 65331)
    (?$B#T(B . 65332)
    (?$B#U(B . 65333)
    (?$B#V(B . 65334)
    (?$B#W(B . 65335)
    (?$B#X(B . 65336)
    (?$B#Y(B . 65337)
    (?$B#Z(B . 65338)
    (?$B#a(B . 65345)
    (?$B#b(B . 65346)
    (?$B#c(B . 65347)
    (?$B#d(B . 65348)
    (?$B#e(B . 65349)
    (?$B#f(B . 65350)
    (?$B#g(B . 65351)
    (?$B#h(B . 65352)
    (?$B#i(B . 65353)
    (?$B#j(B . 65354)
    (?$B#k(B . 65355)
    (?$B#l(B . 65356)
    (?$B#m(B . 65357)
    (?$B#n(B . 65358)
    (?$B#o(B . 65359)
    (?$B#p(B . 65360)
    (?$B#q(B . 65361)
    (?$B#r(B . 65362)
    (?$B#s(B . 65363)
    (?$B#t(B . 65364)
    (?$B#u(B . 65365)
    (?$B#v(B . 65366)
    (?$B#w(B . 65367)
    (?$B#x(B . 65368)
    (?$B#y(B . 65369)
    (?$B#z(B . 65370)
    (?$B$!(B . 12353)
    (?$B$"(B . 12354)
    (?$B$#(B . 12355)
    (?$B$$(B . 12356)
    (?$B$%(B . 12357)
    (?$B$&(B . 12358)
    (?$B$'(B . 12359)
    (?$B$((B . 12360)
    (?$B$)(B . 12361)
    (?$B$*(B . 12362)
    (?$B$+(B . 12363)
    (?$B$,(B . 12364)
    (?$B$-(B . 12365)
    (?$B$.(B . 12366)
    (?$B$/(B . 12367)
    (?$B$0(B . 12368)
    (?$B$1(B . 12369)
    (?$B$2(B . 12370)
    (?$B$3(B . 12371)
    (?$B$4(B . 12372)
    (?$B$5(B . 12373)
    (?$B$6(B . 12374)
    (?$B$7(B . 12375)
    (?$B$8(B . 12376)
    (?$B$9(B . 12377)
    (?$B$:(B . 12378)
    (?$B$;(B . 12379)
    (?$B$<(B . 12380)
    (?$B$=(B . 12381)
    (?$B$>(B . 12382)
    (?$B$?(B . 12383)
    (?$B$@(B . 12384)
    (?$B$A(B . 12385)
    (?$B$B(B . 12386)
    (?$B$C(B . 12387)
    (?$B$D(B . 12388)
    (?$B$E(B . 12389)
    (?$B$F(B . 12390)
    (?$B$G(B . 12391)
    (?$B$H(B . 12392)
    (?$B$I(B . 12393)
    (?$B$J(B . 12394)
    (?$B$K(B . 12395)
    (?$B$L(B . 12396)
    (?$B$M(B . 12397)
    (?$B$N(B . 12398)
    (?$B$O(B . 12399)
    (?$B$P(B . 12400)
    (?$B$Q(B . 12401)
    (?$B$R(B . 12402)
    (?$B$S(B . 12403)
    (?$B$T(B . 12404)
    (?$B$U(B . 12405)
    (?$B$V(B . 12406)
    (?$B$W(B . 12407)
    (?$B$X(B . 12408)
    (?$B$Y(B . 12409)
    (?$B$Z(B . 12410)
    (?$B$[(B . 12411)
    (?$B$\(B . 12412)
    (?$B$](B . 12413)
    (?$B$^(B . 12414)
    (?$B$_(B . 12415)
    (?$B$`(B . 12416)
    (?$B$a(B . 12417)
    (?$B$b(B . 12418)
    (?$B$c(B . 12419)
    (?$B$d(B . 12420)
    (?$B$e(B . 12421)
    (?$B$f(B . 12422)
    (?$B$g(B . 12423)
    (?$B$h(B . 12424)
    (?$B$i(B . 12425)
    (?$B$j(B . 12426)
    (?$B$k(B . 12427)
    (?$B$l(B . 12428)
    (?$B$m(B . 12429)
    (?$B$n(B . 12430)
    (?$B$o(B . 12431)
    (?$B$p(B . 12432)
    (?$B$q(B . 12433)
    (?$B$r(B . 12434)
    (?$B$s(B . 12435)
    (?$B%!(B . 12449)
    (?$B%"(B . 12450)
    (?$B%#(B . 12451)
    (?$B%$(B . 12452)
    (?$B%%(B . 12453)
    (?$B%&(B . 12454)
    (?$B%'(B . 12455)
    (?$B%((B . 12456)
    (?$B%)(B . 12457)
    (?$B%*(B . 12458)
    (?$B%+(B . 12459)
    (?$B%,(B . 12460)
    (?$B%-(B . 12461)
    (?$B%.(B . 12462)
    (?$B%/(B . 12463)
    (?$B%0(B . 12464)
    (?$B%1(B . 12465)
    (?$B%2(B . 12466)
    (?$B%3(B . 12467)
    (?$B%4(B . 12468)
    (?$B%5(B . 12469)
    (?$B%6(B . 12470)
    (?$B%7(B . 12471)
    (?$B%8(B . 12472)
    (?$B%9(B . 12473)
    (?$B%:(B . 12474)
    (?$B%;(B . 12475)
    (?$B%<(B . 12476)
    (?$B%=(B . 12477)
    (?$B%>(B . 12478)
    (?$B%?(B . 12479)
    (?$B%@(B . 12480)
    (?$B%A(B . 12481)
    (?$B%B(B . 12482)
    (?$B%C(B . 12483)
    (?$B%D(B . 12484)
    (?$B%E(B . 12485)
    (?$B%F(B . 12486)
    (?$B%G(B . 12487)
    (?$B%H(B . 12488)
    (?$B%I(B . 12489)
    (?$B%J(B . 12490)
    (?$B%K(B . 12491)
    (?$B%L(B . 12492)
    (?$B%M(B . 12493)
    (?$B%N(B . 12494)
    (?$B%O(B . 12495)
    (?$B%P(B . 12496)
    (?$B%Q(B . 12497)
    (?$B%R(B . 12498)
    (?$B%S(B . 12499)
    (?$B%T(B . 12500)
    (?$B%U(B . 12501)
    (?$B%V(B . 12502)
    (?$B%W(B . 12503)
    (?$B%X(B . 12504)
    (?$B%Y(B . 12505)
    (?$B%Z(B . 12506)
    (?$B%[(B . 12507)
    (?$B%\(B . 12508)
    (?$B%](B . 12509)
    (?$B%^(B . 12510)
    (?$B%_(B . 12511)
    (?$B%`(B . 12512)
    (?$B%a(B . 12513)
    (?$B%b(B . 12514)
    (?$B%c(B . 12515)
    (?$B%d(B . 12516)
    (?$B%e(B . 12517)
    (?$B%f(B . 12518)
    (?$B%g(B . 12519)
    (?$B%h(B . 12520)
    (?$B%i(B . 12521)
    (?$B%j(B . 12522)
    (?$B%k(B . 12523)
    (?$B%l(B . 12524)
    (?$B%m(B . 12525)
    (?$B%n(B . 12526)
    (?$B%o(B . 12527)
    (?$B%p(B . 12528)
    (?$B%q(B . 12529)
    (?$B%r(B . 12530)
    (?$B%s(B . 12531)
    (?$B%t(B . 12532)
    (?$B%u(B . 12533)
    (?$B%v(B . 12534)
    (?$B&!(B . 913)
    (?$B&"(B . 914)
    (?$B&#(B . 915)
    (?$B&$(B . 916)
    (?$B&%(B . 917)
    (?$B&&(B . 918)
    (?$B&'(B . 919)
    (?$B&((B . 920)
    (?$B&)(B . 921)
    (?$B&*(B . 922)
    (?$B&+(B . 923)
    (?$B&,(B . 924)
    (?$B&-(B . 925)
    (?$B&.(B . 926)
    (?$B&/(B . 927)
    (?$B&0(B . 928)
    (?$B&1(B . 929)
    (?$B&2(B . 931)
    (?$B&3(B . 932)
    (?$B&4(B . 933)
    (?$B&5(B . 934)
    (?$B&6(B . 935)
    (?$B&7(B . 936)
    (?$B&8(B . 937)
    (?$B&A(B . 945)
    (?$B&B(B . 946)
    (?$B&C(B . 947)
    (?$B&D(B . 948)
    (?$B&E(B . 949)
    (?$B&F(B . 950)
    (?$B&G(B . 951)
    (?$B&H(B . 952)
    (?$B&I(B . 953)
    (?$B&J(B . 954)
    (?$B&K(B . 955)
    (?$B&L(B . 956)
    (?$B&M(B . 957)
    (?$B&N(B . 958)
    (?$B&O(B . 959)
    (?$B&P(B . 960)
    (?$B&Q(B . 961)
    (?$B&R(B . 963)
    (?$B&S(B . 964)
    (?$B&T(B . 965)
    (?$B&U(B . 966)
    (?$B&V(B . 967)
    (?$B&W(B . 968)
    (?$B&X(B . 969)
    (?$B'!(B . 1040)
    (?$B'"(B . 1041)
    (?$B'#(B . 1042)
    (?$B'$(B . 1043)
    (?$B'%(B . 1044)
    (?$B'&(B . 1045)
    (?$B''(B . 1025)
    (?$B'((B . 1046)
    (?$B')(B . 1047)
    (?$B'*(B . 1048)
    (?$B'+(B . 1049)
    (?$B',(B . 1050)
    (?$B'-(B . 1051)
    (?$B'.(B . 1052)
    (?$B'/(B . 1053)
    (?$B'0(B . 1054)
    (?$B'1(B . 1055)
    (?$B'2(B . 1056)
    (?$B'3(B . 1057)
    (?$B'4(B . 1058)
    (?$B'5(B . 1059)
    (?$B'6(B . 1060)
    (?$B'7(B . 1061)
    (?$B'8(B . 1062)
    (?$B'9(B . 1063)
    (?$B':(B . 1064)
    (?$B';(B . 1065)
    (?$B'<(B . 1066)
    (?$B'=(B . 1067)
    (?$B'>(B . 1068)
    (?$B'?(B . 1069)
    (?$B'@(B . 1070)
    (?$B'A(B . 1071)
    (?$B'Q(B . 1072)
    (?$B'R(B . 1073)
    (?$B'S(B . 1074)
    (?$B'T(B . 1075)
    (?$B'U(B . 1076)
    (?$B'V(B . 1077)
    (?$B'W(B . 1105)
    (?$B'X(B . 1078)
    (?$B'Y(B . 1079)
    (?$B'Z(B . 1080)
    (?$B'[(B . 1081)
    (?$B'\(B . 1082)
    (?$B'](B . 1083)
    (?$B'^(B . 1084)
    (?$B'_(B . 1085)
    (?$B'`(B . 1086)
    (?$B'a(B . 1087)
    (?$B'b(B . 1088)
    (?$B'c(B . 1089)
    (?$B'd(B . 1090)
    (?$B'e(B . 1091)
    (?$B'f(B . 1092)
    (?$B'g(B . 1093)
    (?$B'h(B . 1094)
    (?$B'i(B . 1095)
    (?$B'j(B . 1096)
    (?$B'k(B . 1097)
    (?$B'l(B . 1098)
    (?$B'm(B . 1099)
    (?$B'n(B . 1100)
    (?$B'o(B . 1101)
    (?$B'p(B . 1102)
    (?$B'q(B . 1103)
    (?$B(!(B . 9472)
    (?$B("(B . 9474)
    (?$B(#(B . 9484)
    (?$B($(B . 9488)
    (?$B(%(B . 9496)
    (?$B(&(B . 9492)
    (?$B('(B . 9500)
    (?$B(((B . 9516)
    (?$B()(B . 9508)
    (?$B(*(B . 9524)
    (?$B(+(B . 9532)
    (?$B(,(B . 9473)
    (?$B(-(B . 9475)
    (?$B(.(B . 9487)
    (?$B(/(B . 9491)
    (?$B(0(B . 9499)
    (?$B(1(B . 9495)
    (?$B(2(B . 9507)
    (?$B(3(B . 9523)
    (?$B(4(B . 9515)
    (?$B(5(B . 9531)
    (?$B(6(B . 9547)
    (?$B(7(B . 9504)
    (?$B(8(B . 9519)
    (?$B(9(B . 9512)
    (?$B(:(B . 9527)
    (?$B(;(B . 9535)
    (?$B(<(B . 9501)
    (?$B(=(B . 9520)
    (?$B(>(B . 9509)
    (?$B(?(B . 9528)
    (?$B(@(B . 9538)
    (?$B0!(B . 20124)
    (?$B0"(B . 21782)
    (?$B0#(B . 23043)
    (?$B0$(B . 38463)
    (?$B0%(B . 21696)
    (?$B0&(B . 24859)
    (?$B0'(B . 25384)
    (?$B0((B . 23030)
    (?$B0)(B . 36898)
    (?$B0*(B . 33909)
    (?$B0+(B . 33564)
    (?$B0,(B . 31312)
    (?$B0-(B . 24746)
    (?$B0.(B . 25569)
    (?$B0/(B . 28197)
    (?$B00(B . 26093)
    (?$B01(B . 33894)
    (?$B02(B . 33446)
    (?$B03(B . 39925)
    (?$B04(B . 26771)
    (?$B05(B . 22311)
    (?$B06(B . 26017)
    (?$B07(B . 25201)
    (?$B08(B . 23451)
    (?$B09(B . 22992)
    (?$B0:(B . 34427)
    (?$B0;(B . 39156)
    (?$B0<(B . 32098)
    (?$B0=(B . 32190)
    (?$B0>(B . 39822)
    (?$B0?(B . 25110)
    (?$B0@(B . 31903)
    (?$B0A(B . 34999)
    (?$B0B(B . 23433)
    (?$B0C(B . 24245)
    (?$B0D(B . 25353)
    (?$B0E(B . 26263)
    (?$B0F(B . 26696)
    (?$B0G(B . 38343)
    (?$B0H(B . 38797)
    (?$B0I(B . 26447)
    (?$B0J(B . 20197)
    (?$B0K(B . 20234)
    (?$B0L(B . 20301)
    (?$B0M(B . 20381)
    (?$B0N(B . 20553)
    (?$B0O(B . 22258)
    (?$B0P(B . 22839)
    (?$B0Q(B . 22996)
    (?$B0R(B . 23041)
    (?$B0S(B . 23561)
    (?$B0T(B . 24799)
    (?$B0U(B . 24847)
    (?$B0V(B . 24944)
    (?$B0W(B . 26131)
    (?$B0X(B . 26885)
    (?$B0Y(B . 28858)
    (?$B0Z(B . 30031)
    (?$B0[(B . 30064)
    (?$B0\(B . 31227)
    (?$B0](B . 32173)
    (?$B0^(B . 32239)
    (?$B0_(B . 32963)
    (?$B0`(B . 33806)
    (?$B0a(B . 34915)
    (?$B0b(B . 35586)
    (?$B0c(B . 36949)
    (?$B0d(B . 36986)
    (?$B0e(B . 21307)
    (?$B0f(B . 20117)
    (?$B0g(B . 20133)
    (?$B0h(B . 22495)
    (?$B0i(B . 32946)
    (?$B0j(B . 37057)
    (?$B0k(B . 30959)
    (?$B0l(B . 19968)
    (?$B0m(B . 22769)
    (?$B0n(B . 28322)
    (?$B0o(B . 36920)
    (?$B0p(B . 31282)
    (?$B0q(B . 33576)
    (?$B0r(B . 33419)
    (?$B0s(B . 39983)
    (?$B0t(B . 20801)
    (?$B0u(B . 21360)
    (?$B0v(B . 21693)
    (?$B0w(B . 21729)
    (?$B0x(B . 22240)
    (?$B0y(B . 23035)
    (?$B0z(B . 24341)
    (?$B0{(B . 39154)
    (?$B0|(B . 28139)
    (?$B0}(B . 32996)
    (?$B0~(B . 34093)
    (?$B1!(B . 38498)
    (?$B1"(B . 38512)
    (?$B1#(B . 38560)
    (?$B1$(B . 38907)
    (?$B1%(B . 21515)
    (?$B1&(B . 21491)
    (?$B1'(B . 23431)
    (?$B1((B . 28879)
    (?$B1)(B . 32701)
    (?$B1*(B . 36802)
    (?$B1+(B . 38632)
    (?$B1,(B . 21359)
    (?$B1-(B . 40284)
    (?$B1.(B . 31418)
    (?$B1/(B . 19985)
    (?$B10(B . 30867)
    (?$B11(B . 33276)
    (?$B12(B . 28198)
    (?$B13(B . 22040)
    (?$B14(B . 21764)
    (?$B15(B . 27421)
    (?$B16(B . 34074)
    (?$B17(B . 39995)
    (?$B18(B . 23013)
    (?$B19(B . 21417)
    (?$B1:(B . 28006)
    (?$B1;(B . 29916)
    (?$B1<(B . 38287)
    (?$B1=(B . 22082)
    (?$B1>(B . 20113)
    (?$B1?(B . 36939)
    (?$B1@(B . 38642)
    (?$B1A(B . 33615)
    (?$B1B(B . 39180)
    (?$B1C(B . 21473)
    (?$B1D(B . 21942)
    (?$B1E(B . 23344)
    (?$B1F(B . 24433)
    (?$B1G(B . 26144)
    (?$B1H(B . 26355)
    (?$B1I(B . 26628)
    (?$B1J(B . 27704)
    (?$B1K(B . 27891)
    (?$B1L(B . 27945)
    (?$B1M(B . 29787)
    (?$B1N(B . 30408)
    (?$B1O(B . 31310)
    (?$B1P(B . 38964)
    (?$B1Q(B . 33521)
    (?$B1R(B . 34907)
    (?$B1S(B . 35424)
    (?$B1T(B . 37613)
    (?$B1U(B . 28082)
    (?$B1V(B . 30123)
    (?$B1W(B . 30410)
    (?$B1X(B . 39365)
    (?$B1Y(B . 24742)
    (?$B1Z(B . 35585)
    (?$B1[(B . 36234)
    (?$B1\(B . 38322)
    (?$B1](B . 27022)
    (?$B1^(B . 21421)
    (?$B1_(B . 20870)
    (?$B1`(B . 22290)
    (?$B1a(B . 22576)
    (?$B1b(B . 22852)
    (?$B1c(B . 23476)
    (?$B1d(B . 24310)
    (?$B1e(B . 24616)
    (?$B1f(B . 25513)
    (?$B1g(B . 25588)
    (?$B1h(B . 27839)
    (?$B1i(B . 28436)
    (?$B1j(B . 28814)
    (?$B1k(B . 28948)
    (?$B1l(B . 29017)
    (?$B1m(B . 29141)
    (?$B1n(B . 29503)
    (?$B1o(B . 32257)
    (?$B1p(B . 33398)
    (?$B1q(B . 33489)
    (?$B1r(B . 34199)
    (?$B1s(B . 36960)
    (?$B1t(B . 37467)
    (?$B1u(B . 40219)
    (?$B1v(B . 22633)
    (?$B1w(B . 26044)
    (?$B1x(B . 27738)
    (?$B1y(B . 29989)
    (?$B1z(B . 20985)
    (?$B1{(B . 22830)
    (?$B1|(B . 22885)
    (?$B1}(B . 24448)
    (?$B1~(B . 24540)
    (?$B2!(B . 25276)
    (?$B2"(B . 26106)
    (?$B2#(B . 27178)
    (?$B2$(B . 27431)
    (?$B2%(B . 27572)
    (?$B2&(B . 29579)
    (?$B2'(B . 32705)
    (?$B2((B . 35158)
    (?$B2)(B . 40236)
    (?$B2*(B . 40206)
    (?$B2+(B . 40644)
    (?$B2,(B . 23713)
    (?$B2-(B . 27798)
    (?$B2.(B . 33659)
    (?$B2/(B . 20740)
    (?$B20(B . 23627)
    (?$B21(B . 25014)
    (?$B22(B . 33222)
    (?$B23(B . 26742)
    (?$B24(B . 29281)
    (?$B25(B . 20057)
    (?$B26(B . 20474)
    (?$B27(B . 21368)
    (?$B28(B . 24681)
    (?$B29(B . 28201)
    (?$B2:(B . 31311)
    (?$B2;(B . 38899)
    (?$B2<(B . 19979)
    (?$B2=(B . 21270)
    (?$B2>(B . 20206)
    (?$B2?(B . 20309)
    (?$B2@(B . 20285)
    (?$B2A(B . 20385)
    (?$B2B(B . 20339)
    (?$B2C(B . 21152)
    (?$B2D(B . 21487)
    (?$B2E(B . 22025)
    (?$B2F(B . 22799)
    (?$B2G(B . 23233)
    (?$B2H(B . 23478)
    (?$B2I(B . 23521)
    (?$B2J(B . 31185)
    (?$B2K(B . 26247)
    (?$B2L(B . 26524)
    (?$B2M(B . 26550)
    (?$B2N(B . 27468)
    (?$B2O(B . 27827)
    (?$B2P(B . 28779)
    (?$B2Q(B . 29634)
    (?$B2R(B . 31117)
    (?$B2S(B . 31166)
    (?$B2T(B . 31292)
    (?$B2U(B . 31623)
    (?$B2V(B . 33457)
    (?$B2W(B . 33499)
    (?$B2X(B . 33540)
    (?$B2Y(B . 33655)
    (?$B2Z(B . 33775)
    (?$B2[(B . 33747)
    (?$B2\(B . 34662)
    (?$B2](B . 35506)
    (?$B2^(B . 22057)
    (?$B2_(B . 36008)
    (?$B2`(B . 36838)
    (?$B2a(B . 36942)
    (?$B2b(B . 38686)
    (?$B2c(B . 34442)
    (?$B2d(B . 20420)
    (?$B2e(B . 23784)
    (?$B2f(B . 25105)
    (?$B2g(B . 29273)
    (?$B2h(B . 30011)
    (?$B2i(B . 33253)
    (?$B2j(B . 33469)
    (?$B2k(B . 34558)
    (?$B2l(B . 36032)
    (?$B2m(B . 38597)
    (?$B2n(B . 39187)
    (?$B2o(B . 39381)
    (?$B2p(B . 20171)
    (?$B2q(B . 20250)
    (?$B2r(B . 35299)
    (?$B2s(B . 22238)
    (?$B2t(B . 22602)
    (?$B2u(B . 22730)
    (?$B2v(B . 24315)
    (?$B2w(B . 24555)
    (?$B2x(B . 24618)
    (?$B2y(B . 24724)
    (?$B2z(B . 24674)
    (?$B2{(B . 25040)
    (?$B2|(B . 25106)
    (?$B2}(B . 25296)
    (?$B2~(B . 25913)
    (?$B3!(B . 39745)
    (?$B3"(B . 26214)
    (?$B3#(B . 26800)
    (?$B3$(B . 28023)
    (?$B3%(B . 28784)
    (?$B3&(B . 30028)
    (?$B3'(B . 30342)
    (?$B3((B . 32117)
    (?$B3)(B . 33445)
    (?$B3*(B . 34809)
    (?$B3+(B . 38283)
    (?$B3,(B . 38542)
    (?$B3-(B . 35997)
    (?$B3.(B . 20977)
    (?$B3/(B . 21182)
    (?$B30(B . 22806)
    (?$B31(B . 21683)
    (?$B32(B . 23475)
    (?$B33(B . 23830)
    (?$B34(B . 24936)
    (?$B35(B . 27010)
    (?$B36(B . 28079)
    (?$B37(B . 30861)
    (?$B38(B . 33995)
    (?$B39(B . 34903)
    (?$B3:(B . 35442)
    (?$B3;(B . 37799)
    (?$B3<(B . 39608)
    (?$B3=(B . 28012)
    (?$B3>(B . 39336)
    (?$B3?(B . 34521)
    (?$B3@(B . 22435)
    (?$B3A(B . 26623)
    (?$B3B(B . 34510)
    (?$B3C(B . 37390)
    (?$B3D(B . 21123)
    (?$B3E(B . 22151)
    (?$B3F(B . 21508)
    (?$B3G(B . 24275)
    (?$B3H(B . 25313)
    (?$B3I(B . 25785)
    (?$B3J(B . 26684)
    (?$B3K(B . 26680)
    (?$B3L(B . 27579)
    (?$B3M(B . 29554)
    (?$B3N(B . 30906)
    (?$B3O(B . 31339)
    (?$B3P(B . 35226)
    (?$B3Q(B . 35282)
    (?$B3R(B . 36203)
    (?$B3S(B . 36611)
    (?$B3T(B . 37101)
    (?$B3U(B . 38307)
    (?$B3V(B . 38548)
    (?$B3W(B . 38761)
    (?$B3X(B . 23398)
    (?$B3Y(B . 23731)
    (?$B3Z(B . 27005)
    (?$B3[(B . 38989)
    (?$B3\(B . 38990)
    (?$B3](B . 25499)
    (?$B3^(B . 31520)
    (?$B3_(B . 27179)
    (?$B3`(B . 27263)
    (?$B3a(B . 26806)
    (?$B3b(B . 39949)
    (?$B3c(B . 28511)
    (?$B3d(B . 21106)
    (?$B3e(B . 21917)
    (?$B3f(B . 24688)
    (?$B3g(B . 25324)
    (?$B3h(B . 27963)
    (?$B3i(B . 28167)
    (?$B3j(B . 28369)
    (?$B3k(B . 33883)
    (?$B3l(B . 35088)
    (?$B3m(B . 36676)
    (?$B3n(B . 19988)
    (?$B3o(B . 39993)
    (?$B3p(B . 21494)
    (?$B3q(B . 26907)
    (?$B3r(B . 27194)
    (?$B3s(B . 38788)
    (?$B3t(B . 26666)
    (?$B3u(B . 20828)
    (?$B3v(B . 31427)
    (?$B3w(B . 33970)
    (?$B3x(B . 37340)
    (?$B3y(B . 37772)
    (?$B3z(B . 22107)
    (?$B3{(B . 40232)
    (?$B3|(B . 26658)
    (?$B3}(B . 33541)
    (?$B3~(B . 33841)
    (?$B4!(B . 31909)
    (?$B4"(B . 21000)
    (?$B4#(B . 33477)
    (?$B4$(B . 29926)
    (?$B4%(B . 20094)
    (?$B4&(B . 20355)
    (?$B4'(B . 20896)
    (?$B4((B . 23506)
    (?$B4)(B . 21002)
    (?$B4*(B . 21208)
    (?$B4+(B . 21223)
    (?$B4,(B . 24059)
    (?$B4-(B . 21914)
    (?$B4.(B . 22570)
    (?$B4/(B . 23014)
    (?$B40(B . 23436)
    (?$B41(B . 23448)
    (?$B42(B . 23515)
    (?$B43(B . 24178)
    (?$B44(B . 24185)
    (?$B45(B . 24739)
    (?$B46(B . 24863)
    (?$B47(B . 24931)
    (?$B48(B . 25022)
    (?$B49(B . 25563)
    (?$B4:(B . 25954)
    (?$B4;(B . 26577)
    (?$B4<(B . 26707)
    (?$B4=(B . 26874)
    (?$B4>(B . 27454)
    (?$B4?(B . 27475)
    (?$B4@(B . 27735)
    (?$B4A(B . 28450)
    (?$B4B(B . 28567)
    (?$B4C(B . 28485)
    (?$B4D(B . 29872)
    (?$B4E(B . 29976)
    (?$B4F(B . 30435)
    (?$B4G(B . 30475)
    (?$B4H(B . 31487)
    (?$B4I(B . 31649)
    (?$B4J(B . 31777)
    (?$B4K(B . 32233)
    (?$B4L(B . 32566)
    (?$B4M(B . 32752)
    (?$B4N(B . 32925)
    (?$B4O(B . 33382)
    (?$B4P(B . 33694)
    (?$B4Q(B . 35251)
    (?$B4R(B . 35532)
    (?$B4S(B . 36011)
    (?$B4T(B . 36996)
    (?$B4U(B . 37969)
    (?$B4V(B . 38291)
    (?$B4W(B . 38289)
    (?$B4X(B . 38306)
    (?$B4Y(B . 38501)
    (?$B4Z(B . 38867)
    (?$B4[(B . 39208)
    (?$B4\(B . 33304)
    (?$B4](B . 20024)
    (?$B4^(B . 21547)
    (?$B4_(B . 23736)
    (?$B4`(B . 24012)
    (?$B4a(B . 29609)
    (?$B4b(B . 30284)
    (?$B4c(B . 30524)
    (?$B4d(B . 23721)
    (?$B4e(B . 32747)
    (?$B4f(B . 36107)
    (?$B4g(B . 38593)
    (?$B4h(B . 38929)
    (?$B4i(B . 38996)
    (?$B4j(B . 39000)
    (?$B4k(B . 20225)
    (?$B4l(B . 20238)
    (?$B4m(B . 21361)
    (?$B4n(B . 21916)
    (?$B4o(B . 22120)
    (?$B4p(B . 22522)
    (?$B4q(B . 22855)
    (?$B4r(B . 23305)
    (?$B4s(B . 23492)
    (?$B4t(B . 23696)
    (?$B4u(B . 24076)
    (?$B4v(B . 24190)
    (?$B4w(B . 24524)
    (?$B4x(B . 25582)
    (?$B4y(B . 26426)
    (?$B4z(B . 26071)
    (?$B4{(B . 26082)
    (?$B4|(B . 26399)
    (?$B4}(B . 26827)
    (?$B4~(B . 26820)
    (?$B5!(B . 27231)
    (?$B5"(B . 24112)
    (?$B5#(B . 27589)
    (?$B5$(B . 27671)
    (?$B5%(B . 27773)
    (?$B5&(B . 30079)
    (?$B5'(B . 31048)
    (?$B5((B . 23395)
    (?$B5)(B . 31232)
    (?$B5*(B . 32000)
    (?$B5+(B . 24509)
    (?$B5,(B . 35215)
    (?$B5-(B . 35352)
    (?$B5.(B . 36020)
    (?$B5/(B . 36215)
    (?$B50(B . 36556)
    (?$B51(B . 36637)
    (?$B52(B . 39138)
    (?$B53(B . 39438)
    (?$B54(B . 39740)
    (?$B55(B . 20096)
    (?$B56(B . 20605)
    (?$B57(B . 20736)
    (?$B58(B . 22931)
    (?$B59(B . 23452)
    (?$B5:(B . 25135)
    (?$B5;(B . 25216)
    (?$B5<(B . 25836)
    (?$B5=(B . 27450)
    (?$B5>(B . 29344)
    (?$B5?(B . 30097)
    (?$B5@(B . 31047)
    (?$B5A(B . 32681)
    (?$B5B(B . 34811)
    (?$B5C(B . 35516)
    (?$B5D(B . 35696)
    (?$B5E(B . 25516)
    (?$B5F(B . 33738)
    (?$B5G(B . 38816)
    (?$B5H(B . 21513)
    (?$B5I(B . 21507)
    (?$B5J(B . 21931)
    (?$B5K(B . 26708)
    (?$B5L(B . 27224)
    (?$B5M(B . 35440)
    (?$B5N(B . 30759)
    (?$B5O(B . 26485)
    (?$B5P(B . 40653)
    (?$B5Q(B . 21364)
    (?$B5R(B . 23458)
    (?$B5S(B . 33050)
    (?$B5T(B . 34384)
    (?$B5U(B . 36870)
    (?$B5V(B . 19992)
    (?$B5W(B . 20037)
    (?$B5X(B . 20167)
    (?$B5Y(B . 20241)
    (?$B5Z(B . 21450)
    (?$B5[(B . 21560)
    (?$B5\(B . 23470)
    (?$B5](B . 24339)
    (?$B5^(B . 24613)
    (?$B5_(B . 25937)
    (?$B5`(B . 26429)
    (?$B5a(B . 27714)
    (?$B5b(B . 27762)
    (?$B5c(B . 27875)
    (?$B5d(B . 28792)
    (?$B5e(B . 29699)
    (?$B5f(B . 31350)
    (?$B5g(B . 31406)
    (?$B5h(B . 31496)
    (?$B5i(B . 32026)
    (?$B5j(B . 31998)
    (?$B5k(B . 32102)
    (?$B5l(B . 26087)
    (?$B5m(B . 29275)
    (?$B5n(B . 21435)
    (?$B5o(B . 23621)
    (?$B5p(B . 24040)
    (?$B5q(B . 25298)
    (?$B5r(B . 25312)
    (?$B5s(B . 25369)
    (?$B5t(B . 28192)
    (?$B5u(B . 34394)
    (?$B5v(B . 35377)
    (?$B5w(B . 36317)
    (?$B5x(B . 37624)
    (?$B5y(B . 28417)
    (?$B5z(B . 31142)
    (?$B5{(B . 39770)
    (?$B5|(B . 20136)
    (?$B5}(B . 20139)
    (?$B5~(B . 20140)
    (?$B6!(B . 20379)
    (?$B6"(B . 20384)
    (?$B6#(B . 20689)
    (?$B6$(B . 20807)
    (?$B6%(B . 31478)
    (?$B6&(B . 20849)
    (?$B6'(B . 20982)
    (?$B6((B . 21332)
    (?$B6)(B . 21281)
    (?$B6*(B . 21375)
    (?$B6+(B . 21483)
    (?$B6,(B . 21932)
    (?$B6-(B . 22659)
    (?$B6.(B . 23777)
    (?$B6/(B . 24375)
    (?$B60(B . 24394)
    (?$B61(B . 24623)
    (?$B62(B . 24656)
    (?$B63(B . 24685)
    (?$B64(B . 25375)
    (?$B65(B . 25945)
    (?$B66(B . 27211)
    (?$B67(B . 27841)
    (?$B68(B . 29378)
    (?$B69(B . 29421)
    (?$B6:(B . 30703)
    (?$B6;(B . 33016)
    (?$B6<(B . 33029)
    (?$B6=(B . 33288)
    (?$B6>(B . 34126)
    (?$B6?(B . 37111)
    (?$B6@(B . 37857)
    (?$B6A(B . 38911)
    (?$B6B(B . 39255)
    (?$B6C(B . 39514)
    (?$B6D(B . 20208)
    (?$B6E(B . 20957)
    (?$B6F(B . 23597)
    (?$B6G(B . 26241)
    (?$B6H(B . 26989)
    (?$B6I(B . 23616)
    (?$B6J(B . 26354)
    (?$B6K(B . 26997)
    (?$B6L(B . 29577)
    (?$B6M(B . 26704)
    (?$B6N(B . 31873)
    (?$B6O(B . 20677)
    (?$B6P(B . 21220)
    (?$B6Q(B . 22343)
    (?$B6R(B . 24062)
    (?$B6S(B . 37670)
    (?$B6T(B . 26020)
    (?$B6U(B . 27427)
    (?$B6V(B . 27453)
    (?$B6W(B . 29748)
    (?$B6X(B . 31105)
    (?$B6Y(B . 31165)
    (?$B6Z(B . 31563)
    (?$B6[(B . 32202)
    (?$B6\(B . 33465)
    (?$B6](B . 33740)
    (?$B6^(B . 34943)
    (?$B6_(B . 35167)
    (?$B6`(B . 35641)
    (?$B6a(B . 36817)
    (?$B6b(B . 37329)
    (?$B6c(B . 21535)
    (?$B6d(B . 37504)
    (?$B6e(B . 20061)
    (?$B6f(B . 20534)
    (?$B6g(B . 21477)
    (?$B6h(B . 21306)
    (?$B6i(B . 29399)
    (?$B6j(B . 29590)
    (?$B6k(B . 30697)
    (?$B6l(B . 33510)
    (?$B6m(B . 36527)
    (?$B6n(B . 39366)
    (?$B6o(B . 39368)
    (?$B6p(B . 39378)
    (?$B6q(B . 20855)
    (?$B6r(B . 24858)
    (?$B6s(B . 34398)
    (?$B6t(B . 21936)
    (?$B6u(B . 31354)
    (?$B6v(B . 20598)
    (?$B6w(B . 23507)
    (?$B6x(B . 36935)
    (?$B6y(B . 38533)
    (?$B6z(B . 20018)
    (?$B6{(B . 27355)
    (?$B6|(B . 37351)
    (?$B6}(B . 23633)
    (?$B6~(B . 23624)
    (?$B7!(B . 25496)
    (?$B7"(B . 31391)
    (?$B7#(B . 27795)
    (?$B7$(B . 38772)
    (?$B7%(B . 36705)
    (?$B7&(B . 31402)
    (?$B7'(B . 29066)
    (?$B7((B . 38536)
    (?$B7)(B . 31874)
    (?$B7*(B . 26647)
    (?$B7+(B . 32368)
    (?$B7,(B . 26705)
    (?$B7-(B . 37740)
    (?$B7.(B . 21234)
    (?$B7/(B . 21531)
    (?$B70(B . 34219)
    (?$B71(B . 35347)
    (?$B72(B . 32676)
    (?$B73(B . 36557)
    (?$B74(B . 37089)
    (?$B75(B . 21350)
    (?$B76(B . 34952)
    (?$B77(B . 31041)
    (?$B78(B . 20418)
    (?$B79(B . 20670)
    (?$B7:(B . 21009)
    (?$B7;(B . 20804)
    (?$B7<(B . 21843)
    (?$B7=(B . 22317)
    (?$B7>(B . 29674)
    (?$B7?(B . 22411)
    (?$B7@(B . 22865)
    (?$B7A(B . 24418)
    (?$B7B(B . 24452)
    (?$B7C(B . 24693)
    (?$B7D(B . 24950)
    (?$B7E(B . 24935)
    (?$B7F(B . 25001)
    (?$B7G(B . 25522)
    (?$B7H(B . 25658)
    (?$B7I(B . 25964)
    (?$B7J(B . 26223)
    (?$B7K(B . 26690)
    (?$B7L(B . 28179)
    (?$B7M(B . 30054)
    (?$B7N(B . 31293)
    (?$B7O(B . 31995)
    (?$B7P(B . 32076)
    (?$B7Q(B . 32153)
    (?$B7R(B . 32331)
    (?$B7S(B . 32619)
    (?$B7T(B . 33550)
    (?$B7U(B . 33610)
    (?$B7V(B . 34509)
    (?$B7W(B . 35336)
    (?$B7X(B . 35427)
    (?$B7Y(B . 35686)
    (?$B7Z(B . 36605)
    (?$B7[(B . 38938)
    (?$B7\(B . 40335)
    (?$B7](B . 33464)
    (?$B7^(B . 36814)
    (?$B7_(B . 39912)
    (?$B7`(B . 21127)
    (?$B7a(B . 25119)
    (?$B7b(B . 25731)
    (?$B7c(B . 28608)
    (?$B7d(B . 38553)
    (?$B7e(B . 26689)
    (?$B7f(B . 20625)
    (?$B7g(B . 27424)
    (?$B7h(B . 27770)
    (?$B7i(B . 28500)
    (?$B7j(B . 31348)
    (?$B7k(B . 32080)
    (?$B7l(B . 34880)
    (?$B7m(B . 35363)
    (?$B7n(B . 26376)
    (?$B7o(B . 20214)
    (?$B7p(B . 20537)
    (?$B7q(B . 20518)
    (?$B7r(B . 20581)
    (?$B7s(B . 20860)
    (?$B7t(B . 21048)
    (?$B7u(B . 21091)
    (?$B7v(B . 21927)
    (?$B7w(B . 22287)
    (?$B7x(B . 22533)
    (?$B7y(B . 23244)
    (?$B7z(B . 24314)
    (?$B7{(B . 25010)
    (?$B7|(B . 25080)
    (?$B7}(B . 25331)
    (?$B7~(B . 25458)
    (?$B8!(B . 26908)
    (?$B8"(B . 27177)
    (?$B8#(B . 29309)
    (?$B8$(B . 29356)
    (?$B8%(B . 29486)
    (?$B8&(B . 30740)
    (?$B8'(B . 30831)
    (?$B8((B . 32121)
    (?$B8)(B . 30476)
    (?$B8*(B . 32937)
    (?$B8+(B . 35211)
    (?$B8,(B . 35609)
    (?$B8-(B . 36066)
    (?$B8.(B . 36562)
    (?$B8/(B . 36963)
    (?$B80(B . 37749)
    (?$B81(B . 38522)
    (?$B82(B . 38997)
    (?$B83(B . 39443)
    (?$B84(B . 40568)
    (?$B85(B . 20803)
    (?$B86(B . 21407)
    (?$B87(B . 21427)
    (?$B88(B . 24187)
    (?$B89(B . 24358)
    (?$B8:(B . 28187)
    (?$B8;(B . 28304)
    (?$B8<(B . 29572)
    (?$B8=(B . 29694)
    (?$B8>(B . 32067)
    (?$B8?(B . 33335)
    (?$B8@(B . 35328)
    (?$B8A(B . 35578)
    (?$B8B(B . 38480)
    (?$B8C(B . 20046)
    (?$B8D(B . 20491)
    (?$B8E(B . 21476)
    (?$B8F(B . 21628)
    (?$B8G(B . 22266)
    (?$B8H(B . 22993)
    (?$B8I(B . 23396)
    (?$B8J(B . 24049)
    (?$B8K(B . 24235)
    (?$B8L(B . 24359)
    (?$B8M(B . 25144)
    (?$B8N(B . 25925)
    (?$B8O(B . 26543)
    (?$B8P(B . 28246)
    (?$B8Q(B . 29392)
    (?$B8R(B . 31946)
    (?$B8S(B . 34996)
    (?$B8T(B . 32929)
    (?$B8U(B . 32993)
    (?$B8V(B . 33776)
    (?$B8W(B . 34382)
    (?$B8X(B . 35463)
    (?$B8Y(B . 36328)
    (?$B8Z(B . 37431)
    (?$B8[(B . 38599)
    (?$B8\(B . 39015)
    (?$B8](B . 40723)
    (?$B8^(B . 20116)
    (?$B8_(B . 20114)
    (?$B8`(B . 20237)
    (?$B8a(B . 21320)
    (?$B8b(B . 21577)
    (?$B8c(B . 21566)
    (?$B8d(B . 23087)
    (?$B8e(B . 24460)
    (?$B8f(B . 24481)
    (?$B8g(B . 24735)
    (?$B8h(B . 26791)
    (?$B8i(B . 27278)
    (?$B8j(B . 29786)
    (?$B8k(B . 30849)
    (?$B8l(B . 35486)
    (?$B8m(B . 35492)
    (?$B8n(B . 35703)
    (?$B8o(B . 37264)
    (?$B8p(B . 20062)
    (?$B8q(B . 39881)
    (?$B8r(B . 20132)
    (?$B8s(B . 20348)
    (?$B8t(B . 20399)
    (?$B8u(B . 20505)
    (?$B8v(B . 20502)
    (?$B8w(B . 20809)
    (?$B8x(B . 20844)
    (?$B8y(B . 21151)
    (?$B8z(B . 21177)
    (?$B8{(B . 21246)
    (?$B8|(B . 21402)
    (?$B8}(B . 21475)
    (?$B8~(B . 21521)
    (?$B9!(B . 21518)
    (?$B9"(B . 21897)
    (?$B9#(B . 22353)
    (?$B9$(B . 22434)
    (?$B9%(B . 22909)
    (?$B9&(B . 23380)
    (?$B9'(B . 23389)
    (?$B9((B . 23439)
    (?$B9)(B . 24037)
    (?$B9*(B . 24039)
    (?$B9+(B . 24055)
    (?$B9,(B . 24184)
    (?$B9-(B . 24195)
    (?$B9.(B . 24218)
    (?$B9/(B . 24247)
    (?$B90(B . 24344)
    (?$B91(B . 24658)
    (?$B92(B . 24908)
    (?$B93(B . 25239)
    (?$B94(B . 25304)
    (?$B95(B . 25511)
    (?$B96(B . 25915)
    (?$B97(B . 26114)
    (?$B98(B . 26179)
    (?$B99(B . 26356)
    (?$B9:(B . 26477)
    (?$B9;(B . 26657)
    (?$B9<(B . 26775)
    (?$B9=(B . 27083)
    (?$B9>(B . 27743)
    (?$B9?(B . 27946)
    (?$B9@(B . 28009)
    (?$B9A(B . 28207)
    (?$B9B(B . 28317)
    (?$B9C(B . 30002)
    (?$B9D(B . 30343)
    (?$B9E(B . 30828)
    (?$B9F(B . 31295)
    (?$B9G(B . 31968)
    (?$B9H(B . 32005)
    (?$B9I(B . 32024)
    (?$B9J(B . 32094)
    (?$B9K(B . 32177)
    (?$B9L(B . 32789)
    (?$B9M(B . 32771)
    (?$B9N(B . 32943)
    (?$B9O(B . 32945)
    (?$B9P(B . 33108)
    (?$B9Q(B . 33167)
    (?$B9R(B . 33322)
    (?$B9S(B . 33618)
    (?$B9T(B . 34892)
    (?$B9U(B . 34913)
    (?$B9V(B . 35611)
    (?$B9W(B . 36002)
    (?$B9X(B . 36092)
    (?$B9Y(B . 37066)
    (?$B9Z(B . 37237)
    (?$B9[(B . 37489)
    (?$B9\(B . 30783)
    (?$B9](B . 37628)
    (?$B9^(B . 38308)
    (?$B9_(B . 38477)
    (?$B9`(B . 38917)
    (?$B9a(B . 39321)
    (?$B9b(B . 39640)
    (?$B9c(B . 40251)
    (?$B9d(B . 21083)
    (?$B9e(B . 21163)
    (?$B9f(B . 21495)
    (?$B9g(B . 21512)
    (?$B9h(B . 22741)
    (?$B9i(B . 25335)
    (?$B9j(B . 28640)
    (?$B9k(B . 35946)
    (?$B9l(B . 36703)
    (?$B9m(B . 40633)
    (?$B9n(B . 20811)
    (?$B9o(B . 21051)
    (?$B9p(B . 21578)
    (?$B9q(B . 22269)
    (?$B9r(B . 31296)
    (?$B9s(B . 37239)
    (?$B9t(B . 40288)
    (?$B9u(B . 40658)
    (?$B9v(B . 29508)
    (?$B9w(B . 28425)
    (?$B9x(B . 33136)
    (?$B9y(B . 29969)
    (?$B9z(B . 24573)
    (?$B9{(B . 24794)
    (?$B9|(B . 39592)
    (?$B9}(B . 29403)
    (?$B9~(B . 36796)
    (?$B:!(B . 27492)
    (?$B:"(B . 38915)
    (?$B:#(B . 20170)
    (?$B:$(B . 22256)
    (?$B:%(B . 22372)
    (?$B:&(B . 22718)
    (?$B:'(B . 23130)
    (?$B:((B . 24680)
    (?$B:)(B . 25031)
    (?$B:*(B . 26127)
    (?$B:+(B . 26118)
    (?$B:,(B . 26681)
    (?$B:-(B . 26801)
    (?$B:.(B . 28151)
    (?$B:/(B . 30165)
    (?$B:0(B . 32058)
    (?$B:1(B . 33390)
    (?$B:2(B . 39746)
    (?$B:3(B . 20123)
    (?$B:4(B . 20304)
    (?$B:5(B . 21449)
    (?$B:6(B . 21766)
    (?$B:7(B . 23919)
    (?$B:8(B . 24038)
    (?$B:9(B . 24046)
    (?$B::(B . 26619)
    (?$B:;(B . 27801)
    (?$B:<(B . 29811)
    (?$B:=(B . 30722)
    (?$B:>(B . 35408)
    (?$B:?(B . 37782)
    (?$B:@(B . 35039)
    (?$B:A(B . 22352)
    (?$B:B(B . 24231)
    (?$B:C(B . 25387)
    (?$B:D(B . 20661)
    (?$B:E(B . 20652)
    (?$B:F(B . 20877)
    (?$B:G(B . 26368)
    (?$B:H(B . 21705)
    (?$B:I(B . 22622)
    (?$B:J(B . 22971)
    (?$B:K(B . 23472)
    (?$B:L(B . 24425)
    (?$B:M(B . 25165)
    (?$B:N(B . 25505)
    (?$B:O(B . 26685)
    (?$B:P(B . 27507)
    (?$B:Q(B . 28168)
    (?$B:R(B . 28797)
    (?$B:S(B . 37319)
    (?$B:T(B . 29312)
    (?$B:U(B . 30741)
    (?$B:V(B . 30758)
    (?$B:W(B . 31085)
    (?$B:X(B . 25998)
    (?$B:Y(B . 32048)
    (?$B:Z(B . 33756)
    (?$B:[(B . 35009)
    (?$B:\(B . 36617)
    (?$B:](B . 38555)
    (?$B:^(B . 21092)
    (?$B:_(B . 22312)
    (?$B:`(B . 26448)
    (?$B:a(B . 32618)
    (?$B:b(B . 36001)
    (?$B:c(B . 20916)
    (?$B:d(B . 22338)
    (?$B:e(B . 38442)
    (?$B:f(B . 22586)
    (?$B:g(B . 27018)
    (?$B:h(B . 32948)
    (?$B:i(B . 21682)
    (?$B:j(B . 23822)
    (?$B:k(B . 22524)
    (?$B:l(B . 30869)
    (?$B:m(B . 40442)
    (?$B:n(B . 20316)
    (?$B:o(B . 21066)
    (?$B:p(B . 21643)
    (?$B:q(B . 25662)
    (?$B:r(B . 26152)
    (?$B:s(B . 26388)
    (?$B:t(B . 26613)
    (?$B:u(B . 31364)
    (?$B:v(B . 31574)
    (?$B:w(B . 32034)
    (?$B:x(B . 37679)
    (?$B:y(B . 26716)
    (?$B:z(B . 39853)
    (?$B:{(B . 31545)
    (?$B:|(B . 21273)
    (?$B:}(B . 20874)
    (?$B:~(B . 21047)
    (?$B;!(B . 23519)
    (?$B;"(B . 25334)
    (?$B;#(B . 25774)
    (?$B;$(B . 25830)
    (?$B;%(B . 26413)
    (?$B;&(B . 27578)
    (?$B;'(B . 34217)
    (?$B;((B . 38609)
    (?$B;)(B . 30352)
    (?$B;*(B . 39894)
    (?$B;+(B . 25420)
    (?$B;,(B . 37638)
    (?$B;-(B . 39851)
    (?$B;.(B . 30399)
    (?$B;/(B . 26194)
    (?$B;0(B . 19977)
    (?$B;1(B . 20632)
    (?$B;2(B . 21442)
    (?$B;3(B . 23665)
    (?$B;4(B . 24808)
    (?$B;5(B . 25746)
    (?$B;6(B . 25955)
    (?$B;7(B . 26719)
    (?$B;8(B . 29158)
    (?$B;9(B . 29642)
    (?$B;:(B . 29987)
    (?$B;;(B . 31639)
    (?$B;<(B . 32386)
    (?$B;=(B . 34453)
    (?$B;>(B . 35715)
    (?$B;?(B . 36059)
    (?$B;@(B . 37240)
    (?$B;A(B . 39184)
    (?$B;B(B . 26028)
    (?$B;C(B . 26283)
    (?$B;D(B . 27531)
    (?$B;E(B . 20181)
    (?$B;F(B . 20180)
    (?$B;G(B . 20282)
    (?$B;H(B . 20351)
    (?$B;I(B . 21050)
    (?$B;J(B . 21496)
    (?$B;K(B . 21490)
    (?$B;L(B . 21987)
    (?$B;M(B . 22235)
    (?$B;N(B . 22763)
    (?$B;O(B . 22987)
    (?$B;P(B . 22985)
    (?$B;Q(B . 23039)
    (?$B;R(B . 23376)
    (?$B;S(B . 23629)
    (?$B;T(B . 24066)
    (?$B;U(B . 24107)
    (?$B;V(B . 24535)
    (?$B;W(B . 24605)
    (?$B;X(B . 25351)
    (?$B;Y(B . 25903)
    (?$B;Z(B . 23388)
    (?$B;[(B . 26031)
    (?$B;\(B . 26045)
    (?$B;](B . 26088)
    (?$B;^(B . 26525)
    (?$B;_(B . 27490)
    (?$B;`(B . 27515)
    (?$B;a(B . 27663)
    (?$B;b(B . 29509)
    (?$B;c(B . 31049)
    (?$B;d(B . 31169)
    (?$B;e(B . 31992)
    (?$B;f(B . 32025)
    (?$B;g(B . 32043)
    (?$B;h(B . 32930)
    (?$B;i(B . 33026)
    (?$B;j(B . 33267)
    (?$B;k(B . 35222)
    (?$B;l(B . 35422)
    (?$B;m(B . 35433)
    (?$B;n(B . 35430)
    (?$B;o(B . 35468)
    (?$B;p(B . 35566)
    (?$B;q(B . 36039)
    (?$B;r(B . 36060)
    (?$B;s(B . 38604)
    (?$B;t(B . 39164)
    (?$B;u(B . 27503)
    (?$B;v(B . 20107)
    (?$B;w(B . 20284)
    (?$B;x(B . 20365)
    (?$B;y(B . 20816)
    (?$B;z(B . 23383)
    (?$B;{(B . 23546)
    (?$B;|(B . 24904)
    (?$B;}(B . 25345)
    (?$B;~(B . 26178)
    (?$B<!(B . 27425)
    (?$B<"(B . 28363)
    (?$B<#(B . 27835)
    (?$B<$(B . 29246)
    (?$B<%(B . 29885)
    (?$B<&(B . 30164)
    (?$B<'(B . 30913)
    (?$B<((B . 31034)
    (?$B<)(B . 32780)
    (?$B<*(B . 32819)
    (?$B<+(B . 33258)
    (?$B<,(B . 33940)
    (?$B<-(B . 36766)
    (?$B<.(B . 27728)
    (?$B</(B . 40575)
    (?$B<0(B . 24335)
    (?$B<1(B . 35672)
    (?$B<2(B . 40235)
    (?$B<3(B . 31482)
    (?$B<4(B . 36600)
    (?$B<5(B . 23437)
    (?$B<6(B . 38635)
    (?$B<7(B . 19971)
    (?$B<8(B . 21489)
    (?$B<9(B . 22519)
    (?$B<:(B . 22833)
    (?$B<;(B . 23241)
    (?$B<<(B . 23460)
    (?$B<=(B . 24713)
    (?$B<>(B . 28287)
    (?$B<?(B . 28422)
    (?$B<@(B . 30142)
    (?$B<A(B . 36074)
    (?$B<B(B . 23455)
    (?$B<C(B . 34048)
    (?$B<D(B . 31712)
    (?$B<E(B . 20594)
    (?$B<F(B . 26612)
    (?$B<G(B . 33437)
    (?$B<H(B . 23649)
    (?$B<I(B . 34122)
    (?$B<J(B . 32286)
    (?$B<K(B . 33294)
    (?$B<L(B . 20889)
    (?$B<M(B . 23556)
    (?$B<N(B . 25448)
    (?$B<O(B . 36198)
    (?$B<P(B . 26012)
    (?$B<Q(B . 29038)
    (?$B<R(B . 31038)
    (?$B<S(B . 32023)
    (?$B<T(B . 32773)
    (?$B<U(B . 35613)
    (?$B<V(B . 36554)
    (?$B<W(B . 36974)
    (?$B<X(B . 34503)
    (?$B<Y(B . 37034)
    (?$B<Z(B . 20511)
    (?$B<[(B . 21242)
    (?$B<\(B . 23610)
    (?$B<](B . 26451)
    (?$B<^(B . 28796)
    (?$B<_(B . 29237)
    (?$B<`(B . 37196)
    (?$B<a(B . 37320)
    (?$B<b(B . 37675)
    (?$B<c(B . 33509)
    (?$B<d(B . 23490)
    (?$B<e(B . 24369)
    (?$B<f(B . 24825)
    (?$B<g(B . 20027)
    (?$B<h(B . 21462)
    (?$B<i(B . 23432)
    (?$B<j(B . 25163)
    (?$B<k(B . 26417)
    (?$B<l(B . 27530)
    (?$B<m(B . 29417)
    (?$B<n(B . 29664)
    (?$B<o(B . 31278)
    (?$B<p(B . 33131)
    (?$B<q(B . 36259)
    (?$B<r(B . 37202)
    (?$B<s(B . 39318)
    (?$B<t(B . 20754)
    (?$B<u(B . 21463)
    (?$B<v(B . 21610)
    (?$B<w(B . 23551)
    (?$B<x(B . 25480)
    (?$B<y(B . 27193)
    (?$B<z(B . 32172)
    (?$B<{(B . 38656)
    (?$B<|(B . 22234)
    (?$B<}(B . 21454)
    (?$B<~(B . 21608)
    (?$B=!(B . 23447)
    (?$B="(B . 23601)
    (?$B=#(B . 24030)
    (?$B=$(B . 20462)
    (?$B=%(B . 24833)
    (?$B=&(B . 25342)
    (?$B='(B . 27954)
    (?$B=((B . 31168)
    (?$B=)(B . 31179)
    (?$B=*(B . 32066)
    (?$B=+(B . 32333)
    (?$B=,(B . 32722)
    (?$B=-(B . 33261)
    (?$B=.(B . 33311)
    (?$B=/(B . 33936)
    (?$B=0(B . 34886)
    (?$B=1(B . 35186)
    (?$B=2(B . 35728)
    (?$B=3(B . 36468)
    (?$B=4(B . 36655)
    (?$B=5(B . 36913)
    (?$B=6(B . 37195)
    (?$B=7(B . 37228)
    (?$B=8(B . 38598)
    (?$B=9(B . 37276)
    (?$B=:(B . 20160)
    (?$B=;(B . 20303)
    (?$B=<(B . 20805)
    (?$B==(B . 21313)
    (?$B=>(B . 24467)
    (?$B=?(B . 25102)
    (?$B=@(B . 26580)
    (?$B=A(B . 27713)
    (?$B=B(B . 28171)
    (?$B=C(B . 29539)
    (?$B=D(B . 32294)
    (?$B=E(B . 37325)
    (?$B=F(B . 37507)
    (?$B=G(B . 21460)
    (?$B=H(B . 22809)
    (?$B=I(B . 23487)
    (?$B=J(B . 28113)
    (?$B=K(B . 31069)
    (?$B=L(B . 32302)
    (?$B=M(B . 31899)
    (?$B=N(B . 22654)
    (?$B=O(B . 29087)
    (?$B=P(B . 20986)
    (?$B=Q(B . 34899)
    (?$B=R(B . 36848)
    (?$B=S(B . 20426)
    (?$B=T(B . 23803)
    (?$B=U(B . 26149)
    (?$B=V(B . 30636)
    (?$B=W(B . 31459)
    (?$B=X(B . 33308)
    (?$B=Y(B . 39423)
    (?$B=Z(B . 20934)
    (?$B=[(B . 24490)
    (?$B=\(B . 26092)
    (?$B=](B . 26991)
    (?$B=^(B . 27529)
    (?$B=_(B . 28147)
    (?$B=`(B . 28310)
    (?$B=a(B . 28516)
    (?$B=b(B . 30462)
    (?$B=c(B . 32020)
    (?$B=d(B . 24033)
    (?$B=e(B . 36981)
    (?$B=f(B . 37255)
    (?$B=g(B . 38918)
    (?$B=h(B . 20966)
    (?$B=i(B . 21021)
    (?$B=j(B . 25152)
    (?$B=k(B . 26257)
    (?$B=l(B . 26329)
    (?$B=m(B . 28186)
    (?$B=n(B . 24246)
    (?$B=o(B . 32210)
    (?$B=p(B . 32626)
    (?$B=q(B . 26360)
    (?$B=r(B . 34223)
    (?$B=s(B . 34295)
    (?$B=t(B . 35576)
    (?$B=u(B . 21161)
    (?$B=v(B . 21465)
    (?$B=w(B . 22899)
    (?$B=x(B . 24207)
    (?$B=y(B . 24464)
    (?$B=z(B . 24661)
    (?$B={(B . 37604)
    (?$B=|(B . 38500)
    (?$B=}(B . 20663)
    (?$B=~(B . 20767)
    (?$B>!(B . 21213)
    (?$B>"(B . 21280)
    (?$B>#(B . 21319)
    (?$B>$(B . 21484)
    (?$B>%(B . 21736)
    (?$B>&(B . 21830)
    (?$B>'(B . 21809)
    (?$B>((B . 22039)
    (?$B>)(B . 22888)
    (?$B>*(B . 22974)
    (?$B>+(B . 23100)
    (?$B>,(B . 23477)
    (?$B>-(B . 23558)
    (?$B>.(B . 23567)
    (?$B>/(B . 23569)
    (?$B>0(B . 23578)
    (?$B>1(B . 24196)
    (?$B>2(B . 24202)
    (?$B>3(B . 24288)
    (?$B>4(B . 24432)
    (?$B>5(B . 25215)
    (?$B>6(B . 25220)
    (?$B>7(B . 25307)
    (?$B>8(B . 25484)
    (?$B>9(B . 25463)
    (?$B>:(B . 26119)
    (?$B>;(B . 26124)
    (?$B><(B . 26157)
    (?$B>=(B . 26230)
    (?$B>>(B . 26494)
    (?$B>?(B . 26786)
    (?$B>@(B . 27167)
    (?$B>A(B . 27189)
    (?$B>B(B . 27836)
    (?$B>C(B . 28040)
    (?$B>D(B . 28169)
    (?$B>E(B . 28248)
    (?$B>F(B . 28988)
    (?$B>G(B . 28966)
    (?$B>H(B . 29031)
    (?$B>I(B . 30151)
    (?$B>J(B . 30465)
    (?$B>K(B . 30813)
    (?$B>L(B . 30977)
    (?$B>M(B . 31077)
    (?$B>N(B . 31216)
    (?$B>O(B . 31456)
    (?$B>P(B . 31505)
    (?$B>Q(B . 31911)
    (?$B>R(B . 32057)
    (?$B>S(B . 32918)
    (?$B>T(B . 33750)
    (?$B>U(B . 33931)
    (?$B>V(B . 34121)
    (?$B>W(B . 34909)
    (?$B>X(B . 35059)
    (?$B>Y(B . 35359)
    (?$B>Z(B . 35388)
    (?$B>[(B . 35412)
    (?$B>\(B . 35443)
    (?$B>](B . 35937)
    (?$B>^(B . 36062)
    (?$B>_(B . 37284)
    (?$B>`(B . 37478)
    (?$B>a(B . 37758)
    (?$B>b(B . 37912)
    (?$B>c(B . 38556)
    (?$B>d(B . 38808)
    (?$B>e(B . 19978)
    (?$B>f(B . 19976)
    (?$B>g(B . 19998)
    (?$B>h(B . 20055)
    (?$B>i(B . 20887)
    (?$B>j(B . 21104)
    (?$B>k(B . 22478)
    (?$B>l(B . 22580)
    (?$B>m(B . 22732)
    (?$B>n(B . 23330)
    (?$B>o(B . 24120)
    (?$B>p(B . 24773)
    (?$B>q(B . 25854)
    (?$B>r(B . 26465)
    (?$B>s(B . 26454)
    (?$B>t(B . 27972)
    (?$B>u(B . 29366)
    (?$B>v(B . 30067)
    (?$B>w(B . 31331)
    (?$B>x(B . 33976)
    (?$B>y(B . 35698)
    (?$B>z(B . 37304)
    (?$B>{(B . 37664)
    (?$B>|(B . 22065)
    (?$B>}(B . 22516)
    (?$B>~(B . 39166)
    (?$B?!(B . 25325)
    (?$B?"(B . 26893)
    (?$B?#(B . 27542)
    (?$B?$(B . 29165)
    (?$B?%(B . 32340)
    (?$B?&(B . 32887)
    (?$B?'(B . 33394)
    (?$B?((B . 35302)
    (?$B?)(B . 39135)
    (?$B?*(B . 34645)
    (?$B?+(B . 36785)
    (?$B?,(B . 23611)
    (?$B?-(B . 20280)
    (?$B?.(B . 20449)
    (?$B?/(B . 20405)
    (?$B?0(B . 21767)
    (?$B?1(B . 23072)
    (?$B?2(B . 23517)
    (?$B?3(B . 23529)
    (?$B?4(B . 24515)
    (?$B?5(B . 24910)
    (?$B?6(B . 25391)
    (?$B?7(B . 26032)
    (?$B?8(B . 26187)
    (?$B?9(B . 26862)
    (?$B?:(B . 27035)
    (?$B?;(B . 28024)
    (?$B?<(B . 28145)
    (?$B?=(B . 30003)
    (?$B?>(B . 30137)
    (?$B??(B . 30495)
    (?$B?@(B . 31070)
    (?$B?A(B . 31206)
    (?$B?B(B . 32051)
    (?$B?C(B . 33251)
    (?$B?D(B . 33455)
    (?$B?E(B . 34218)
    (?$B?F(B . 35242)
    (?$B?G(B . 35386)
    (?$B?H(B . 36523)
    (?$B?I(B . 36763)
    (?$B?J(B . 36914)
    (?$B?K(B . 37341)
    (?$B?L(B . 38663)
    (?$B?M(B . 20154)
    (?$B?N(B . 20161)
    (?$B?O(B . 20995)
    (?$B?P(B . 22645)
    (?$B?Q(B . 22764)
    (?$B?R(B . 23563)
    (?$B?S(B . 29978)
    (?$B?T(B . 23613)
    (?$B?U(B . 33102)
    (?$B?V(B . 35338)
    (?$B?W(B . 36805)
    (?$B?X(B . 38499)
    (?$B?Y(B . 38765)
    (?$B?Z(B . 31525)
    (?$B?[(B . 35535)
    (?$B?\(B . 38920)
    (?$B?](B . 37218)
    (?$B?^(B . 22259)
    (?$B?_(B . 21416)
    (?$B?`(B . 36887)
    (?$B?a(B . 21561)
    (?$B?b(B . 22402)
    (?$B?c(B . 24101)
    (?$B?d(B . 25512)
    (?$B?e(B . 27700)
    (?$B?f(B . 28810)
    (?$B?g(B . 30561)
    (?$B?h(B . 31883)
    (?$B?i(B . 32736)
    (?$B?j(B . 34928)
    (?$B?k(B . 36930)
    (?$B?l(B . 37204)
    (?$B?m(B . 37648)
    (?$B?n(B . 37656)
    (?$B?o(B . 38543)
    (?$B?p(B . 29790)
    (?$B?q(B . 39620)
    (?$B?r(B . 23815)
    (?$B?s(B . 23913)
    (?$B?t(B . 25968)
    (?$B?u(B . 26530)
    (?$B?v(B . 36264)
    (?$B?w(B . 38619)
    (?$B?x(B . 25454)
    (?$B?y(B . 26441)
    (?$B?z(B . 26905)
    (?$B?{(B . 33733)
    (?$B?|(B . 38935)
    (?$B?}(B . 38592)
    (?$B?~(B . 35070)
    (?$B@!(B . 28548)
    (?$B@"(B . 25722)
    (?$B@#(B . 23544)
    (?$B@$(B . 19990)
    (?$B@%(B . 28716)
    (?$B@&(B . 30045)
    (?$B@'(B . 26159)
    (?$B@((B . 20932)
    (?$B@)(B . 21046)
    (?$B@*(B . 21218)
    (?$B@+(B . 22995)
    (?$B@,(B . 24449)
    (?$B@-(B . 24615)
    (?$B@.(B . 25104)
    (?$B@/(B . 25919)
    (?$B@0(B . 25972)
    (?$B@1(B . 26143)
    (?$B@2(B . 26228)
    (?$B@3(B . 26866)
    (?$B@4(B . 26646)
    (?$B@5(B . 27491)
    (?$B@6(B . 28165)
    (?$B@7(B . 29298)
    (?$B@8(B . 29983)
    (?$B@9(B . 30427)
    (?$B@:(B . 31934)
    (?$B@;(B . 32854)
    (?$B@<(B . 22768)
    (?$B@=(B . 35069)
    (?$B@>(B . 35199)
    (?$B@?(B . 35488)
    (?$B@@(B . 35475)
    (?$B@A(B . 35531)
    (?$B@B(B . 36893)
    (?$B@C(B . 37266)
    (?$B@D(B . 38738)
    (?$B@E(B . 38745)
    (?$B@F(B . 25993)
    (?$B@G(B . 31246)
    (?$B@H(B . 33030)
    (?$B@I(B . 38587)
    (?$B@J(B . 24109)
    (?$B@K(B . 24796)
    (?$B@L(B . 25114)
    (?$B@M(B . 26021)
    (?$B@N(B . 26132)
    (?$B@O(B . 26512)
    (?$B@P(B . 30707)
    (?$B@Q(B . 31309)
    (?$B@R(B . 31821)
    (?$B@S(B . 32318)
    (?$B@T(B . 33034)
    (?$B@U(B . 36012)
    (?$B@V(B . 36196)
    (?$B@W(B . 36321)
    (?$B@X(B . 36447)
    (?$B@Y(B . 30889)
    (?$B@Z(B . 20999)
    (?$B@[(B . 25305)
    (?$B@\(B . 25509)
    (?$B@](B . 25666)
    (?$B@^(B . 25240)
    (?$B@_(B . 35373)
    (?$B@`(B . 31363)
    (?$B@a(B . 31680)
    (?$B@b(B . 35500)
    (?$B@c(B . 38634)
    (?$B@d(B . 32118)
    (?$B@e(B . 33292)
    (?$B@f(B . 34633)
    (?$B@g(B . 20185)
    (?$B@h(B . 20808)
    (?$B@i(B . 21315)
    (?$B@j(B . 21344)
    (?$B@k(B . 23459)
    (?$B@l(B . 23554)
    (?$B@m(B . 23574)
    (?$B@n(B . 24029)
    (?$B@o(B . 25126)
    (?$B@p(B . 25159)
    (?$B@q(B . 25776)
    (?$B@r(B . 26643)
    (?$B@s(B . 26676)
    (?$B@t(B . 27849)
    (?$B@u(B . 27973)
    (?$B@v(B . 27927)
    (?$B@w(B . 26579)
    (?$B@x(B . 28508)
    (?$B@y(B . 29006)
    (?$B@z(B . 29053)
    (?$B@{(B . 26059)
    (?$B@|(B . 31359)
    (?$B@}(B . 31661)
    (?$B@~(B . 32218)
    (?$BA!(B . 32330)
    (?$BA"(B . 32680)
    (?$BA#(B . 33146)
    (?$BA$(B . 33307)
    (?$BA%(B . 33337)
    (?$BA&(B . 34214)
    (?$BA'(B . 35438)
    (?$BA((B . 36046)
    (?$BA)(B . 36341)
    (?$BA*(B . 36984)
    (?$BA+(B . 36983)
    (?$BA,(B . 37549)
    (?$BA-(B . 37521)
    (?$BA.(B . 38275)
    (?$BA/(B . 39854)
    (?$BA0(B . 21069)
    (?$BA1(B . 21892)
    (?$BA2(B . 28472)
    (?$BA3(B . 28982)
    (?$BA4(B . 20840)
    (?$BA5(B . 31109)
    (?$BA6(B . 32341)
    (?$BA7(B . 33203)
    (?$BA8(B . 31950)
    (?$BA9(B . 22092)
    (?$BA:(B . 22609)
    (?$BA;(B . 23720)
    (?$BA<(B . 25514)
    (?$BA=(B . 26366)
    (?$BA>(B . 26365)
    (?$BA?(B . 26970)
    (?$BA@(B . 29401)
    (?$BAA(B . 30095)
    (?$BAB(B . 30094)
    (?$BAC(B . 30990)
    (?$BAD(B . 31062)
    (?$BAE(B . 31199)
    (?$BAF(B . 31895)
    (?$BAG(B . 32032)
    (?$BAH(B . 32068)
    (?$BAI(B . 34311)
    (?$BAJ(B . 35380)
    (?$BAK(B . 38459)
    (?$BAL(B . 36961)
    (?$BAM(B . 40736)
    (?$BAN(B . 20711)
    (?$BAO(B . 21109)
    (?$BAP(B . 21452)
    (?$BAQ(B . 21474)
    (?$BAR(B . 20489)
    (?$BAS(B . 21930)
    (?$BAT(B . 22766)
    (?$BAU(B . 22863)
    (?$BAV(B . 29245)
    (?$BAW(B . 23435)
    (?$BAX(B . 23652)
    (?$BAY(B . 21277)
    (?$BAZ(B . 24803)
    (?$BA[(B . 24819)
    (?$BA\(B . 25436)
    (?$BA](B . 25475)
    (?$BA^(B . 25407)
    (?$BA_(B . 25531)
    (?$BA`(B . 25805)
    (?$BAa(B . 26089)
    (?$BAb(B . 26361)
    (?$BAc(B . 24035)
    (?$BAd(B . 27085)
    (?$BAe(B . 27133)
    (?$BAf(B . 28437)
    (?$BAg(B . 29157)
    (?$BAh(B . 20105)
    (?$BAi(B . 30185)
    (?$BAj(B . 30456)
    (?$BAk(B . 31379)
    (?$BAl(B . 31967)
    (?$BAm(B . 32207)
    (?$BAn(B . 32156)
    (?$BAo(B . 32865)
    (?$BAp(B . 33609)
    (?$BAq(B . 33624)
    (?$BAr(B . 33900)
    (?$BAs(B . 33980)
    (?$BAt(B . 34299)
    (?$BAu(B . 35013)
    (?$BAv(B . 36208)
    (?$BAw(B . 36865)
    (?$BAx(B . 36973)
    (?$BAy(B . 37783)
    (?$BAz(B . 38684)
    (?$BA{(B . 39442)
    (?$BA|(B . 20687)
    (?$BA}(B . 22679)
    (?$BA~(B . 24974)
    (?$BB!(B . 33235)
    (?$BB"(B . 34101)
    (?$BB#(B . 36104)
    (?$BB$(B . 36896)
    (?$BB%(B . 20419)
    (?$BB&(B . 20596)
    (?$BB'(B . 21063)
    (?$BB((B . 21363)
    (?$BB)(B . 24687)
    (?$BB*(B . 25417)
    (?$BB+(B . 26463)
    (?$BB,(B . 28204)
    (?$BB-(B . 36275)
    (?$BB.(B . 36895)
    (?$BB/(B . 20439)
    (?$BB0(B . 23646)
    (?$BB1(B . 36042)
    (?$BB2(B . 26063)
    (?$BB3(B . 32154)
    (?$BB4(B . 21330)
    (?$BB5(B . 34966)
    (?$BB6(B . 20854)
    (?$BB7(B . 25539)
    (?$BB8(B . 23384)
    (?$BB9(B . 23403)
    (?$BB:(B . 23562)
    (?$BB;(B . 25613)
    (?$BB<(B . 26449)
    (?$BB=(B . 36956)
    (?$BB>(B . 20182)
    (?$BB?(B . 22810)
    (?$BB@(B . 22826)
    (?$BBA(B . 27760)
    (?$BBB(B . 35409)
    (?$BBC(B . 21822)
    (?$BBD(B . 22549)
    (?$BBE(B . 22949)
    (?$BBF(B . 24816)
    (?$BBG(B . 25171)
    (?$BBH(B . 26561)
    (?$BBI(B . 33333)
    (?$BBJ(B . 26965)
    (?$BBK(B . 38464)
    (?$BBL(B . 39364)
    (?$BBM(B . 39464)
    (?$BBN(B . 20307)
    (?$BBO(B . 22534)
    (?$BBP(B . 23550)
    (?$BBQ(B . 32784)
    (?$BBR(B . 23729)
    (?$BBS(B . 24111)
    (?$BBT(B . 24453)
    (?$BBU(B . 24608)
    (?$BBV(B . 24907)
    (?$BBW(B . 25140)
    (?$BBX(B . 26367)
    (?$BBY(B . 27888)
    (?$BBZ(B . 28382)
    (?$BB[(B . 32974)
    (?$BB\(B . 33151)
    (?$BB](B . 33492)
    (?$BB^(B . 34955)
    (?$BB_(B . 36024)
    (?$BB`(B . 36864)
    (?$BBa(B . 36910)
    (?$BBb(B . 38538)
    (?$BBc(B . 40667)
    (?$BBd(B . 39899)
    (?$BBe(B . 20195)
    (?$BBf(B . 21488)
    (?$BBg(B . 22823)
    (?$BBh(B . 31532)
    (?$BBi(B . 37261)
    (?$BBj(B . 38988)
    (?$BBk(B . 40441)
    (?$BBl(B . 28381)
    (?$BBm(B . 28711)
    (?$BBn(B . 21331)
    (?$BBo(B . 21828)
    (?$BBp(B . 23429)
    (?$BBq(B . 25176)
    (?$BBr(B . 25246)
    (?$BBs(B . 25299)
    (?$BBt(B . 27810)
    (?$BBu(B . 28655)
    (?$BBv(B . 29730)
    (?$BBw(B . 35351)
    (?$BBx(B . 37944)
    (?$BBy(B . 28609)
    (?$BBz(B . 35582)
    (?$BB{(B . 33592)
    (?$BB|(B . 20967)
    (?$BB}(B . 34552)
    (?$BB~(B . 21482)
    (?$BC!(B . 21481)
    (?$BC"(B . 20294)
    (?$BC#(B . 36948)
    (?$BC$(B . 36784)
    (?$BC%(B . 22890)
    (?$BC&(B . 33073)
    (?$BC'(B . 24061)
    (?$BC((B . 31466)
    (?$BC)(B . 36799)
    (?$BC*(B . 26842)
    (?$BC+(B . 35895)
    (?$BC,(B . 29432)
    (?$BC-(B . 40008)
    (?$BC.(B . 27197)
    (?$BC/(B . 35504)
    (?$BC0(B . 20025)
    (?$BC1(B . 21336)
    (?$BC2(B . 22022)
    (?$BC3(B . 22374)
    (?$BC4(B . 25285)
    (?$BC5(B . 25506)
    (?$BC6(B . 26086)
    (?$BC7(B . 27470)
    (?$BC8(B . 28129)
    (?$BC9(B . 28251)
    (?$BC:(B . 28845)
    (?$BC;(B . 30701)
    (?$BC<(B . 31471)
    (?$BC=(B . 31658)
    (?$BC>(B . 32187)
    (?$BC?(B . 32829)
    (?$BC@(B . 32966)
    (?$BCA(B . 34507)
    (?$BCB(B . 35477)
    (?$BCC(B . 37723)
    (?$BCD(B . 22243)
    (?$BCE(B . 22727)
    (?$BCF(B . 24382)
    (?$BCG(B . 26029)
    (?$BCH(B . 26262)
    (?$BCI(B . 27264)
    (?$BCJ(B . 27573)
    (?$BCK(B . 30007)
    (?$BCL(B . 35527)
    (?$BCM(B . 20516)
    (?$BCN(B . 30693)
    (?$BCO(B . 22320)
    (?$BCP(B . 24347)
    (?$BCQ(B . 24677)
    (?$BCR(B . 26234)
    (?$BCS(B . 27744)
    (?$BCT(B . 30196)
    (?$BCU(B . 31258)
    (?$BCV(B . 32622)
    (?$BCW(B . 33268)
    (?$BCX(B . 34584)
    (?$BCY(B . 36933)
    (?$BCZ(B . 39347)
    (?$BC[(B . 31689)
    (?$BC\(B . 30044)
    (?$BC](B . 31481)
    (?$BC^(B . 31569)
    (?$BC_(B . 33988)
    (?$BC`(B . 36880)
    (?$BCa(B . 31209)
    (?$BCb(B . 31378)
    (?$BCc(B . 33590)
    (?$BCd(B . 23265)
    (?$BCe(B . 30528)
    (?$BCf(B . 20013)
    (?$BCg(B . 20210)
    (?$BCh(B . 23449)
    (?$BCi(B . 24544)
    (?$BCj(B . 25277)
    (?$BCk(B . 26172)
    (?$BCl(B . 26609)
    (?$BCm(B . 27880)
    (?$BCn(B . 34411)
    (?$BCo(B . 34935)
    (?$BCp(B . 35387)
    (?$BCq(B . 37198)
    (?$BCr(B . 37619)
    (?$BCs(B . 39376)
    (?$BCt(B . 27159)
    (?$BCu(B . 28710)
    (?$BCv(B . 29482)
    (?$BCw(B . 33511)
    (?$BCx(B . 33879)
    (?$BCy(B . 36015)
    (?$BCz(B . 19969)
    (?$BC{(B . 20806)
    (?$BC|(B . 20939)
    (?$BC}(B . 21899)
    (?$BC~(B . 23541)
    (?$BD!(B . 24086)
    (?$BD"(B . 24115)
    (?$BD#(B . 24193)
    (?$BD$(B . 24340)
    (?$BD%(B . 24373)
    (?$BD&(B . 24427)
    (?$BD'(B . 24500)
    (?$BD((B . 25074)
    (?$BD)(B . 25361)
    (?$BD*(B . 26274)
    (?$BD+(B . 26397)
    (?$BD,(B . 28526)
    (?$BD-(B . 29266)
    (?$BD.(B . 30010)
    (?$BD/(B . 30522)
    (?$BD0(B . 32884)
    (?$BD1(B . 33081)
    (?$BD2(B . 33144)
    (?$BD3(B . 34678)
    (?$BD4(B . 35519)
    (?$BD5(B . 35548)
    (?$BD6(B . 36229)
    (?$BD7(B . 36339)
    (?$BD8(B . 37530)
    (?$BD9(B . 38263)
    (?$BD:(B . 38914)
    (?$BD;(B . 40165)
    (?$BD<(B . 21189)
    (?$BD=(B . 25431)
    (?$BD>(B . 30452)
    (?$BD?(B . 26389)
    (?$BD@(B . 27784)
    (?$BDA(B . 29645)
    (?$BDB(B . 36035)
    (?$BDC(B . 37806)
    (?$BDD(B . 38515)
    (?$BDE(B . 27941)
    (?$BDF(B . 22684)
    (?$BDG(B . 26894)
    (?$BDH(B . 27084)
    (?$BDI(B . 36861)
    (?$BDJ(B . 37786)
    (?$BDK(B . 30171)
    (?$BDL(B . 36890)
    (?$BDM(B . 22618)
    (?$BDN(B . 26626)
    (?$BDO(B . 25524)
    (?$BDP(B . 27131)
    (?$BDQ(B . 20291)
    (?$BDR(B . 28460)
    (?$BDS(B . 26584)
    (?$BDT(B . 36795)
    (?$BDU(B . 34086)
    (?$BDV(B . 32180)
    (?$BDW(B . 37716)
    (?$BDX(B . 26943)
    (?$BDY(B . 28528)
    (?$BDZ(B . 22378)
    (?$BD[(B . 22775)
    (?$BD\(B . 23340)
    (?$BD](B . 32044)
    (?$BD^(B . 29226)
    (?$BD_(B . 21514)
    (?$BD`(B . 37347)
    (?$BDa(B . 40372)
    (?$BDb(B . 20141)
    (?$BDc(B . 20302)
    (?$BDd(B . 20572)
    (?$BDe(B . 20597)
    (?$BDf(B . 21059)
    (?$BDg(B . 35998)
    (?$BDh(B . 21576)
    (?$BDi(B . 22564)
    (?$BDj(B . 23450)
    (?$BDk(B . 24093)
    (?$BDl(B . 24213)
    (?$BDm(B . 24237)
    (?$BDn(B . 24311)
    (?$BDo(B . 24351)
    (?$BDp(B . 24716)
    (?$BDq(B . 25269)
    (?$BDr(B . 25402)
    (?$BDs(B . 25552)
    (?$BDt(B . 26799)
    (?$BDu(B . 27712)
    (?$BDv(B . 30855)
    (?$BDw(B . 31118)
    (?$BDx(B . 31243)
    (?$BDy(B . 32224)
    (?$BDz(B . 33351)
    (?$BD{(B . 35330)
    (?$BD|(B . 35558)
    (?$BD}(B . 36420)
    (?$BD~(B . 36883)
    (?$BE!(B . 37048)
    (?$BE"(B . 37165)
    (?$BE#(B . 37336)
    (?$BE$(B . 40718)
    (?$BE%(B . 27877)
    (?$BE&(B . 25688)
    (?$BE'(B . 25826)
    (?$BE((B . 25973)
    (?$BE)(B . 28404)
    (?$BE*(B . 30340)
    (?$BE+(B . 31515)
    (?$BE,(B . 36969)
    (?$BE-(B . 37841)
    (?$BE.(B . 28346)
    (?$BE/(B . 21746)
    (?$BE0(B . 24505)
    (?$BE1(B . 25764)
    (?$BE2(B . 36685)
    (?$BE3(B . 36845)
    (?$BE4(B . 37444)
    (?$BE5(B . 20856)
    (?$BE6(B . 22635)
    (?$BE7(B . 22825)
    (?$BE8(B . 23637)
    (?$BE9(B . 24215)
    (?$BE:(B . 28155)
    (?$BE;(B . 32399)
    (?$BE<(B . 29980)
    (?$BE=(B . 36028)
    (?$BE>(B . 36578)
    (?$BE?(B . 39003)
    (?$BE@(B . 28857)
    (?$BEA(B . 20253)
    (?$BEB(B . 27583)
    (?$BEC(B . 28593)
    (?$BED(B . 30000)
    (?$BEE(B . 38651)
    (?$BEF(B . 20814)
    (?$BEG(B . 21520)
    (?$BEH(B . 22581)
    (?$BEI(B . 22615)
    (?$BEJ(B . 22956)
    (?$BEK(B . 23648)
    (?$BEL(B . 24466)
    (?$BEM(B . 26007)
    (?$BEN(B . 26460)
    (?$BEO(B . 28193)
    (?$BEP(B . 30331)
    (?$BEQ(B . 33759)
    (?$BER(B . 36077)
    (?$BES(B . 36884)
    (?$BET(B . 37117)
    (?$BEU(B . 37709)
    (?$BEV(B . 30757)
    (?$BEW(B . 30778)
    (?$BEX(B . 21162)
    (?$BEY(B . 24230)
    (?$BEZ(B . 22303)
    (?$BE[(B . 22900)
    (?$BE\(B . 24594)
    (?$BE](B . 20498)
    (?$BE^(B . 20826)
    (?$BE_(B . 20908)
    (?$BE`(B . 20941)
    (?$BEa(B . 20992)
    (?$BEb(B . 21776)
    (?$BEc(B . 22612)
    (?$BEd(B . 22616)
    (?$BEe(B . 22871)
    (?$BEf(B . 23445)
    (?$BEg(B . 23798)
    (?$BEh(B . 23947)
    (?$BEi(B . 24764)
    (?$BEj(B . 25237)
    (?$BEk(B . 25645)
    (?$BEl(B . 26481)
    (?$BEm(B . 26691)
    (?$BEn(B . 26812)
    (?$BEo(B . 26847)
    (?$BEp(B . 30423)
    (?$BEq(B . 28120)
    (?$BEr(B . 28271)
    (?$BEs(B . 28059)
    (?$BEt(B . 28783)
    (?$BEu(B . 29128)
    (?$BEv(B . 24403)
    (?$BEw(B . 30168)
    (?$BEx(B . 31095)
    (?$BEy(B . 31561)
    (?$BEz(B . 31572)
    (?$BE{(B . 31570)
    (?$BE|(B . 31958)
    (?$BE}(B . 32113)
    (?$BE~(B . 21040)
    (?$BF!(B . 33891)
    (?$BF"(B . 34153)
    (?$BF#(B . 34276)
    (?$BF$(B . 35342)
    (?$BF%(B . 35588)
    (?$BF&(B . 35910)
    (?$BF'(B . 36367)
    (?$BF((B . 36867)
    (?$BF)(B . 36879)
    (?$BF*(B . 37913)
    (?$BF+(B . 38518)
    (?$BF,(B . 38957)
    (?$BF-(B . 39472)
    (?$BF.(B . 38360)
    (?$BF/(B . 20685)
    (?$BF0(B . 21205)
    (?$BF1(B . 21516)
    (?$BF2(B . 22530)
    (?$BF3(B . 23566)
    (?$BF4(B . 24999)
    (?$BF5(B . 25758)
    (?$BF6(B . 27934)
    (?$BF7(B . 30643)
    (?$BF8(B . 31461)
    (?$BF9(B . 33012)
    (?$BF:(B . 33796)
    (?$BF;(B . 36947)
    (?$BF<(B . 37509)
    (?$BF=(B . 23776)
    (?$BF>(B . 40199)
    (?$BF?(B . 21311)
    (?$BF@(B . 24471)
    (?$BFA(B . 24499)
    (?$BFB(B . 28060)
    (?$BFC(B . 29305)
    (?$BFD(B . 30563)
    (?$BFE(B . 31167)
    (?$BFF(B . 31716)
    (?$BFG(B . 27602)
    (?$BFH(B . 29420)
    (?$BFI(B . 35501)
    (?$BFJ(B . 26627)
    (?$BFK(B . 27233)
    (?$BFL(B . 20984)
    (?$BFM(B . 31361)
    (?$BFN(B . 26932)
    (?$BFO(B . 23626)
    (?$BFP(B . 40182)
    (?$BFQ(B . 33515)
    (?$BFR(B . 23493)
    (?$BFS(B . 37193)
    (?$BFT(B . 28702)
    (?$BFU(B . 22136)
    (?$BFV(B . 23663)
    (?$BFW(B . 24775)
    (?$BFX(B . 25958)
    (?$BFY(B . 27788)
    (?$BFZ(B . 35930)
    (?$BF[(B . 36929)
    (?$BF\(B . 38931)
    (?$BF](B . 21585)
    (?$BF^(B . 26311)
    (?$BF_(B . 37389)
    (?$BF`(B . 22856)
    (?$BFa(B . 37027)
    (?$BFb(B . 20869)
    (?$BFc(B . 20045)
    (?$BFd(B . 20970)
    (?$BFe(B . 34201)
    (?$BFf(B . 35598)
    (?$BFg(B . 28760)
    (?$BFh(B . 25466)
    (?$BFi(B . 37707)
    (?$BFj(B . 26978)
    (?$BFk(B . 39348)
    (?$BFl(B . 32260)
    (?$BFm(B . 30071)
    (?$BFn(B . 21335)
    (?$BFo(B . 26976)
    (?$BFp(B . 36575)
    (?$BFq(B . 38627)
    (?$BFr(B . 27741)
    (?$BFs(B . 20108)
    (?$BFt(B . 23612)
    (?$BFu(B . 24336)
    (?$BFv(B . 36841)
    (?$BFw(B . 21250)
    (?$BFx(B . 36049)
    (?$BFy(B . 32905)
    (?$BFz(B . 34425)
    (?$BF{(B . 24319)
    (?$BF|(B . 26085)
    (?$BF}(B . 20083)
    (?$BF~(B . 20837)
    (?$BG!(B . 22914)
    (?$BG"(B . 23615)
    (?$BG#(B . 38894)
    (?$BG$(B . 20219)
    (?$BG%(B . 22922)
    (?$BG&(B . 24525)
    (?$BG'(B . 35469)
    (?$BG((B . 28641)
    (?$BG)(B . 31152)
    (?$BG*(B . 31074)
    (?$BG+(B . 23527)
    (?$BG,(B . 33905)
    (?$BG-(B . 29483)
    (?$BG.(B . 29105)
    (?$BG/(B . 24180)
    (?$BG0(B . 24565)
    (?$BG1(B . 25467)
    (?$BG2(B . 25754)
    (?$BG3(B . 29123)
    (?$BG4(B . 31896)
    (?$BG5(B . 20035)
    (?$BG6(B . 24316)
    (?$BG7(B . 20043)
    (?$BG8(B . 22492)
    (?$BG9(B . 22178)
    (?$BG:(B . 24745)
    (?$BG;(B . 28611)
    (?$BG<(B . 32013)
    (?$BG=(B . 33021)
    (?$BG>(B . 33075)
    (?$BG?(B . 33215)
    (?$BG@(B . 36786)
    (?$BGA(B . 35223)
    (?$BGB(B . 34468)
    (?$BGC(B . 24052)
    (?$BGD(B . 25226)
    (?$BGE(B . 25773)
    (?$BGF(B . 35207)
    (?$BGG(B . 26487)
    (?$BGH(B . 27874)
    (?$BGI(B . 27966)
    (?$BGJ(B . 29750)
    (?$BGK(B . 30772)
    (?$BGL(B . 23110)
    (?$BGM(B . 32629)
    (?$BGN(B . 33453)
    (?$BGO(B . 39340)
    (?$BGP(B . 20467)
    (?$BGQ(B . 24259)
    (?$BGR(B . 25309)
    (?$BGS(B . 25490)
    (?$BGT(B . 25943)
    (?$BGU(B . 26479)
    (?$BGV(B . 30403)
    (?$BGW(B . 29260)
    (?$BGX(B . 32972)
    (?$BGY(B . 32954)
    (?$BGZ(B . 36649)
    (?$BG[(B . 37197)
    (?$BG\(B . 20493)
    (?$BG](B . 22521)
    (?$BG^(B . 23186)
    (?$BG_(B . 26757)
    (?$BG`(B . 26995)
    (?$BGa(B . 29028)
    (?$BGb(B . 29437)
    (?$BGc(B . 36023)
    (?$BGd(B . 22770)
    (?$BGe(B . 36064)
    (?$BGf(B . 38506)
    (?$BGg(B . 36889)
    (?$BGh(B . 34687)
    (?$BGi(B . 31204)
    (?$BGj(B . 30695)
    (?$BGk(B . 33833)
    (?$BGl(B . 20271)
    (?$BGm(B . 21093)
    (?$BGn(B . 21338)
    (?$BGo(B . 25293)
    (?$BGp(B . 26575)
    (?$BGq(B . 27850)
    (?$BGr(B . 30333)
    (?$BGs(B . 31636)
    (?$BGt(B . 31893)
    (?$BGu(B . 33334)
    (?$BGv(B . 34180)
    (?$BGw(B . 36843)
    (?$BGx(B . 26333)
    (?$BGy(B . 28448)
    (?$BGz(B . 29190)
    (?$BG{(B . 32283)
    (?$BG|(B . 33707)
    (?$BG}(B . 39361)
    (?$BG~(B . 40614)
    (?$BH!(B . 20989)
    (?$BH"(B . 31665)
    (?$BH#(B . 30834)
    (?$BH$(B . 31672)
    (?$BH%(B . 32903)
    (?$BH&(B . 31560)
    (?$BH'(B . 27368)
    (?$BH((B . 24161)
    (?$BH)(B . 32908)
    (?$BH*(B . 30033)
    (?$BH+(B . 30048)
    (?$BH,(B . 20843)
    (?$BH-(B . 37474)
    (?$BH.(B . 28300)
    (?$BH/(B . 30330)
    (?$BH0(B . 37271)
    (?$BH1(B . 39658)
    (?$BH2(B . 20240)
    (?$BH3(B . 32624)
    (?$BH4(B . 25244)
    (?$BH5(B . 31567)
    (?$BH6(B . 38309)
    (?$BH7(B . 40169)
    (?$BH8(B . 22138)
    (?$BH9(B . 22617)
    (?$BH:(B . 34532)
    (?$BH;(B . 38588)
    (?$BH<(B . 20276)
    (?$BH=(B . 21028)
    (?$BH>(B . 21322)
    (?$BH?(B . 21453)
    (?$BH@(B . 21467)
    (?$BHA(B . 24070)
    (?$BHB(B . 25644)
    (?$BHC(B . 26001)
    (?$BHD(B . 26495)
    (?$BHE(B . 27710)
    (?$BHF(B . 27726)
    (?$BHG(B . 29256)
    (?$BHH(B . 29359)
    (?$BHI(B . 29677)
    (?$BHJ(B . 30036)
    (?$BHK(B . 32321)
    (?$BHL(B . 33324)
    (?$BHM(B . 34281)
    (?$BHN(B . 36009)
    (?$BHO(B . 31684)
    (?$BHP(B . 37318)
    (?$BHQ(B . 29033)
    (?$BHR(B . 38930)
    (?$BHS(B . 39151)
    (?$BHT(B . 25405)
    (?$BHU(B . 26217)
    (?$BHV(B . 30058)
    (?$BHW(B . 30436)
    (?$BHX(B . 30928)
    (?$BHY(B . 34115)
    (?$BHZ(B . 34542)
    (?$BH[(B . 21290)
    (?$BH\(B . 21329)
    (?$BH](B . 21542)
    (?$BH^(B . 22915)
    (?$BH_(B . 24199)
    (?$BH`(B . 24444)
    (?$BHa(B . 24754)
    (?$BHb(B . 25161)
    (?$BHc(B . 25209)
    (?$BHd(B . 25259)
    (?$BHe(B . 26000)
    (?$BHf(B . 27604)
    (?$BHg(B . 27852)
    (?$BHh(B . 30130)
    (?$BHi(B . 30382)
    (?$BHj(B . 30865)
    (?$BHk(B . 31192)
    (?$BHl(B . 32203)
    (?$BHm(B . 32631)
    (?$BHn(B . 32933)
    (?$BHo(B . 34987)
    (?$BHp(B . 35513)
    (?$BHq(B . 36027)
    (?$BHr(B . 36991)
    (?$BHs(B . 38750)
    (?$BHt(B . 39131)
    (?$BHu(B . 27147)
    (?$BHv(B . 31800)
    (?$BHw(B . 20633)
    (?$BHx(B . 23614)
    (?$BHy(B . 24494)
    (?$BHz(B . 26503)
    (?$BH{(B . 27608)
    (?$BH|(B . 29749)
    (?$BH}(B . 30473)
    (?$BH~(B . 32654)
    (?$BI!(B . 40763)
    (?$BI"(B . 26570)
    (?$BI#(B . 31255)
    (?$BI$(B . 21305)
    (?$BI%(B . 30091)
    (?$BI&(B . 39661)
    (?$BI'(B . 24422)
    (?$BI((B . 33181)
    (?$BI)(B . 33777)
    (?$BI*(B . 32920)
    (?$BI+(B . 24380)
    (?$BI,(B . 24517)
    (?$BI-(B . 30050)
    (?$BI.(B . 31558)
    (?$BI/(B . 36924)
    (?$BI0(B . 26727)
    (?$BI1(B . 23019)
    (?$BI2(B . 23195)
    (?$BI3(B . 32016)
    (?$BI4(B . 30334)
    (?$BI5(B . 35628)
    (?$BI6(B . 20469)
    (?$BI7(B . 24426)
    (?$BI8(B . 27161)
    (?$BI9(B . 27703)
    (?$BI:(B . 28418)
    (?$BI;(B . 29922)
    (?$BI<(B . 31080)
    (?$BI=(B . 34920)
    (?$BI>(B . 35413)
    (?$BI?(B . 35961)
    (?$BI@(B . 24287)
    (?$BIA(B . 25551)
    (?$BIB(B . 30149)
    (?$BIC(B . 31186)
    (?$BID(B . 33495)
    (?$BIE(B . 37672)
    (?$BIF(B . 37618)
    (?$BIG(B . 33948)
    (?$BIH(B . 34541)
    (?$BII(B . 39981)
    (?$BIJ(B . 21697)
    (?$BIK(B . 24428)
    (?$BIL(B . 25996)
    (?$BIM(B . 27996)
    (?$BIN(B . 28693)
    (?$BIO(B . 36007)
    (?$BIP(B . 36051)
    (?$BIQ(B . 38971)
    (?$BIR(B . 25935)
    (?$BIS(B . 29942)
    (?$BIT(B . 19981)
    (?$BIU(B . 20184)
    (?$BIV(B . 22496)
    (?$BIW(B . 22827)
    (?$BIX(B . 23142)
    (?$BIY(B . 23500)
    (?$BIZ(B . 20904)
    (?$BI[(B . 24067)
    (?$BI\(B . 24220)
    (?$BI](B . 24598)
    (?$BI^(B . 25206)
    (?$BI_(B . 25975)
    (?$BI`(B . 26023)
    (?$BIa(B . 26222)
    (?$BIb(B . 28014)
    (?$BIc(B . 29238)
    (?$BId(B . 31526)
    (?$BIe(B . 33104)
    (?$BIf(B . 33178)
    (?$BIg(B . 33433)
    (?$BIh(B . 35676)
    (?$BIi(B . 36000)
    (?$BIj(B . 36070)
    (?$BIk(B . 36212)
    (?$BIl(B . 38428)
    (?$BIm(B . 38468)
    (?$BIn(B . 20398)
    (?$BIo(B . 25771)
    (?$BIp(B . 27494)
    (?$BIq(B . 33310)
    (?$BIr(B . 33889)
    (?$BIs(B . 34154)
    (?$BIt(B . 37096)
    (?$BIu(B . 23553)
    (?$BIv(B . 26963)
    (?$BIw(B . 39080)
    (?$BIx(B . 33914)
    (?$BIy(B . 34135)
    (?$BIz(B . 20239)
    (?$BI{(B . 21103)
    (?$BI|(B . 24489)
    (?$BI}(B . 24133)
    (?$BI~(B . 26381)
    (?$BJ!(B . 31119)
    (?$BJ"(B . 33145)
    (?$BJ#(B . 35079)
    (?$BJ$(B . 35206)
    (?$BJ%(B . 28149)
    (?$BJ&(B . 24343)
    (?$BJ'(B . 25173)
    (?$BJ((B . 27832)
    (?$BJ)(B . 20175)
    (?$BJ*(B . 29289)
    (?$BJ+(B . 39826)
    (?$BJ,(B . 20998)
    (?$BJ-(B . 21563)
    (?$BJ.(B . 22132)
    (?$BJ/(B . 22707)
    (?$BJ0(B . 24996)
    (?$BJ1(B . 25198)
    (?$BJ2(B . 28954)
    (?$BJ3(B . 22894)
    (?$BJ4(B . 31881)
    (?$BJ5(B . 31966)
    (?$BJ6(B . 32027)
    (?$BJ7(B . 38640)
    (?$BJ8(B . 25991)
    (?$BJ9(B . 32862)
    (?$BJ:(B . 19993)
    (?$BJ;(B . 20341)
    (?$BJ<(B . 20853)
    (?$BJ=(B . 22592)
    (?$BJ>(B . 24163)
    (?$BJ?(B . 24179)
    (?$BJ@(B . 24330)
    (?$BJA(B . 26564)
    (?$BJB(B . 20006)
    (?$BJC(B . 34109)
    (?$BJD(B . 38281)
    (?$BJE(B . 38491)
    (?$BJF(B . 31859)
    (?$BJG(B . 38913)
    (?$BJH(B . 20731)
    (?$BJI(B . 22721)
    (?$BJJ(B . 30294)
    (?$BJK(B . 30887)
    (?$BJL(B . 21029)
    (?$BJM(B . 30629)
    (?$BJN(B . 34065)
    (?$BJO(B . 31622)
    (?$BJP(B . 20559)
    (?$BJQ(B . 22793)
    (?$BJR(B . 29255)
    (?$BJS(B . 31687)
    (?$BJT(B . 32232)
    (?$BJU(B . 36794)
    (?$BJV(B . 36820)
    (?$BJW(B . 36941)
    (?$BJX(B . 20415)
    (?$BJY(B . 21193)
    (?$BJZ(B . 23081)
    (?$BJ[(B . 24321)
    (?$BJ\(B . 38829)
    (?$BJ](B . 20445)
    (?$BJ^(B . 33303)
    (?$BJ_(B . 37610)
    (?$BJ`(B . 22275)
    (?$BJa(B . 25429)
    (?$BJb(B . 27497)
    (?$BJc(B . 29995)
    (?$BJd(B . 35036)
    (?$BJe(B . 36628)
    (?$BJf(B . 31298)
    (?$BJg(B . 21215)
    (?$BJh(B . 22675)
    (?$BJi(B . 24917)
    (?$BJj(B . 25098)
    (?$BJk(B . 26286)
    (?$BJl(B . 27597)
    (?$BJm(B . 31807)
    (?$BJn(B . 33769)
    (?$BJo(B . 20515)
    (?$BJp(B . 20472)
    (?$BJq(B . 21253)
    (?$BJr(B . 21574)
    (?$BJs(B . 22577)
    (?$BJt(B . 22857)
    (?$BJu(B . 23453)
    (?$BJv(B . 23792)
    (?$BJw(B . 23791)
    (?$BJx(B . 23849)
    (?$BJy(B . 24214)
    (?$BJz(B . 25265)
    (?$BJ{(B . 25447)
    (?$BJ|(B . 25918)
    (?$BJ}(B . 26041)
    (?$BJ~(B . 26379)
    (?$BK!(B . 27861)
    (?$BK"(B . 27873)
    (?$BK#(B . 28921)
    (?$BK$(B . 30770)
    (?$BK%(B . 32299)
    (?$BK&(B . 32990)
    (?$BK'(B . 33459)
    (?$BK((B . 33804)
    (?$BK)(B . 34028)
    (?$BK*(B . 34562)
    (?$BK+(B . 35090)
    (?$BK,(B . 35370)
    (?$BK-(B . 35914)
    (?$BK.(B . 37030)
    (?$BK/(B . 37586)
    (?$BK0(B . 39165)
    (?$BK1(B . 40179)
    (?$BK2(B . 40300)
    (?$BK3(B . 20047)
    (?$BK4(B . 20129)
    (?$BK5(B . 20621)
    (?$BK6(B . 21078)
    (?$BK7(B . 22346)
    (?$BK8(B . 22952)
    (?$BK9(B . 24125)
    (?$BK:(B . 24536)
    (?$BK;(B . 24537)
    (?$BK<(B . 25151)
    (?$BK=(B . 26292)
    (?$BK>(B . 26395)
    (?$BK?(B . 26576)
    (?$BK@(B . 26834)
    (?$BKA(B . 20882)
    (?$BKB(B . 32033)
    (?$BKC(B . 32938)
    (?$BKD(B . 33192)
    (?$BKE(B . 35584)
    (?$BKF(B . 35980)
    (?$BKG(B . 36031)
    (?$BKH(B . 37502)
    (?$BKI(B . 38450)
    (?$BKJ(B . 21536)
    (?$BKK(B . 38956)
    (?$BKL(B . 21271)
    (?$BKM(B . 20693)
    (?$BKN(B . 21340)
    (?$BKO(B . 22696)
    (?$BKP(B . 25778)
    (?$BKQ(B . 26420)
    (?$BKR(B . 29287)
    (?$BKS(B . 30566)
    (?$BKT(B . 31302)
    (?$BKU(B . 37350)
    (?$BKV(B . 21187)
    (?$BKW(B . 27809)
    (?$BKX(B . 27526)
    (?$BKY(B . 22528)
    (?$BKZ(B . 24140)
    (?$BK[(B . 22868)
    (?$BK\(B . 26412)
    (?$BK](B . 32763)
    (?$BK^(B . 20961)
    (?$BK_(B . 30406)
    (?$BK`(B . 25705)
    (?$BKa(B . 30952)
    (?$BKb(B . 39764)
    (?$BKc(B . 40635)
    (?$BKd(B . 22475)
    (?$BKe(B . 22969)
    (?$BKf(B . 26151)
    (?$BKg(B . 26522)
    (?$BKh(B . 27598)
    (?$BKi(B . 21737)
    (?$BKj(B . 27097)
    (?$BKk(B . 24149)
    (?$BKl(B . 33180)
    (?$BKm(B . 26517)
    (?$BKn(B . 39850)
    (?$BKo(B . 26622)
    (?$BKp(B . 40018)
    (?$BKq(B . 26717)
    (?$BKr(B . 20134)
    (?$BKs(B . 20451)
    (?$BKt(B . 21448)
    (?$BKu(B . 25273)
    (?$BKv(B . 26411)
    (?$BKw(B . 27819)
    (?$BKx(B . 36804)
    (?$BKy(B . 20397)
    (?$BKz(B . 32365)
    (?$BK{(B . 40639)
    (?$BK|(B . 19975)
    (?$BK}(B . 24930)
    (?$BK~(B . 28288)
    (?$BL!(B . 28459)
    (?$BL"(B . 34067)
    (?$BL#(B . 21619)
    (?$BL$(B . 26410)
    (?$BL%(B . 39749)
    (?$BL&(B . 24051)
    (?$BL'(B . 31637)
    (?$BL((B . 23724)
    (?$BL)(B . 23494)
    (?$BL*(B . 34588)
    (?$BL+(B . 28234)
    (?$BL,(B . 34001)
    (?$BL-(B . 31252)
    (?$BL.(B . 33032)
    (?$BL/(B . 22937)
    (?$BL0(B . 31885)
    (?$BL1(B . 27665)
    (?$BL2(B . 30496)
    (?$BL3(B . 21209)
    (?$BL4(B . 22818)
    (?$BL5(B . 28961)
    (?$BL6(B . 29279)
    (?$BL7(B . 30683)
    (?$BL8(B . 38695)
    (?$BL9(B . 40289)
    (?$BL:(B . 26891)
    (?$BL;(B . 23167)
    (?$BL<(B . 23064)
    (?$BL=(B . 20901)
    (?$BL>(B . 21517)
    (?$BL?(B . 21629)
    (?$BL@(B . 26126)
    (?$BLA(B . 30431)
    (?$BLB(B . 36855)
    (?$BLC(B . 37528)
    (?$BLD(B . 40180)
    (?$BLE(B . 23018)
    (?$BLF(B . 29277)
    (?$BLG(B . 28357)
    (?$BLH(B . 20813)
    (?$BLI(B . 26825)
    (?$BLJ(B . 32191)
    (?$BLK(B . 32236)
    (?$BLL(B . 38754)
    (?$BLM(B . 40634)
    (?$BLN(B . 25720)
    (?$BLO(B . 27169)
    (?$BLP(B . 33538)
    (?$BLQ(B . 22916)
    (?$BLR(B . 23391)
    (?$BLS(B . 27611)
    (?$BLT(B . 29467)
    (?$BLU(B . 30450)
    (?$BLV(B . 32178)
    (?$BLW(B . 32791)
    (?$BLX(B . 33945)
    (?$BLY(B . 20786)
    (?$BLZ(B . 26408)
    (?$BL[(B . 40665)
    (?$BL\(B . 30446)
    (?$BL](B . 26466)
    (?$BL^(B . 21247)
    (?$BL_(B . 39173)
    (?$BL`(B . 23588)
    (?$BLa(B . 25147)
    (?$BLb(B . 31870)
    (?$BLc(B . 36016)
    (?$BLd(B . 21839)
    (?$BLe(B . 24758)
    (?$BLf(B . 32011)
    (?$BLg(B . 38272)
    (?$BLh(B . 21249)
    (?$BLi(B . 20063)
    (?$BLj(B . 20918)
    (?$BLk(B . 22812)
    (?$BLl(B . 29242)
    (?$BLm(B . 32822)
    (?$BLn(B . 37326)
    (?$BLo(B . 24357)
    (?$BLp(B . 30690)
    (?$BLq(B . 21380)
    (?$BLr(B . 24441)
    (?$BLs(B . 32004)
    (?$BLt(B . 34220)
    (?$BLu(B . 35379)
    (?$BLv(B . 36493)
    (?$BLw(B . 38742)
    (?$BLx(B . 26611)
    (?$BLy(B . 34222)
    (?$BLz(B . 37971)
    (?$BL{(B . 24841)
    (?$BL|(B . 24840)
    (?$BL}(B . 27833)
    (?$BL~(B . 30290)
    (?$BM!(B . 35565)
    (?$BM"(B . 36664)
    (?$BM#(B . 21807)
    (?$BM$(B . 20305)
    (?$BM%(B . 20778)
    (?$BM&(B . 21191)
    (?$BM'(B . 21451)
    (?$BM((B . 23461)
    (?$BM)(B . 24189)
    (?$BM*(B . 24736)
    (?$BM+(B . 24962)
    (?$BM,(B . 25558)
    (?$BM-(B . 26377)
    (?$BM.(B . 26586)
    (?$BM/(B . 28263)
    (?$BM0(B . 28044)
    (?$BM1(B . 29494)
    (?$BM2(B . 29495)
    (?$BM3(B . 30001)
    (?$BM4(B . 31056)
    (?$BM5(B . 35029)
    (?$BM6(B . 35480)
    (?$BM7(B . 36938)
    (?$BM8(B . 37009)
    (?$BM9(B . 37109)
    (?$BM:(B . 38596)
    (?$BM;(B . 34701)
    (?$BM<(B . 22805)
    (?$BM=(B . 20104)
    (?$BM>(B . 20313)
    (?$BM?(B . 19982)
    (?$BM@(B . 35465)
    (?$BMA(B . 36671)
    (?$BMB(B . 38928)
    (?$BMC(B . 20653)
    (?$BMD(B . 24188)
    (?$BME(B . 22934)
    (?$BMF(B . 23481)
    (?$BMG(B . 24248)
    (?$BMH(B . 25562)
    (?$BMI(B . 25594)
    (?$BMJ(B . 25793)
    (?$BMK(B . 26332)
    (?$BML(B . 26954)
    (?$BMM(B . 27096)
    (?$BMN(B . 27915)
    (?$BMO(B . 28342)
    (?$BMP(B . 29076)
    (?$BMQ(B . 29992)
    (?$BMR(B . 31407)
    (?$BMS(B . 32650)
    (?$BMT(B . 32768)
    (?$BMU(B . 33865)
    (?$BMV(B . 33993)
    (?$BMW(B . 35201)
    (?$BMX(B . 35617)
    (?$BMY(B . 36362)
    (?$BMZ(B . 36965)
    (?$BM[(B . 38525)
    (?$BM\(B . 39178)
    (?$BM](B . 24958)
    (?$BM^(B . 25233)
    (?$BM_(B . 27442)
    (?$BM`(B . 27779)
    (?$BMa(B . 28020)
    (?$BMb(B . 32716)
    (?$BMc(B . 32764)
    (?$BMd(B . 28096)
    (?$BMe(B . 32645)
    (?$BMf(B . 34746)
    (?$BMg(B . 35064)
    (?$BMh(B . 26469)
    (?$BMi(B . 33713)
    (?$BMj(B . 38972)
    (?$BMk(B . 38647)
    (?$BMl(B . 27931)
    (?$BMm(B . 32097)
    (?$BMn(B . 33853)
    (?$BMo(B . 37226)
    (?$BMp(B . 20081)
    (?$BMq(B . 21365)
    (?$BMr(B . 23888)
    (?$BMs(B . 27396)
    (?$BMt(B . 28651)
    (?$BMu(B . 34253)
    (?$BMv(B . 34349)
    (?$BMw(B . 35239)
    (?$BMx(B . 21033)
    (?$BMy(B . 21519)
    (?$BMz(B . 23653)
    (?$BM{(B . 26446)
    (?$BM|(B . 26792)
    (?$BM}(B . 29702)
    (?$BM~(B . 29827)
    (?$BN!(B . 30178)
    (?$BN"(B . 35023)
    (?$BN#(B . 35041)
    (?$BN$(B . 37324)
    (?$BN%(B . 38626)
    (?$BN&(B . 38520)
    (?$BN'(B . 24459)
    (?$BN((B . 29575)
    (?$BN)(B . 31435)
    (?$BN*(B . 33870)
    (?$BN+(B . 25504)
    (?$BN,(B . 30053)
    (?$BN-(B . 21129)
    (?$BN.(B . 27969)
    (?$BN/(B . 28316)
    (?$BN0(B . 29705)
    (?$BN1(B . 30041)
    (?$BN2(B . 30827)
    (?$BN3(B . 31890)
    (?$BN4(B . 38534)
    (?$BN5(B . 31452)
    (?$BN6(B . 40845)
    (?$BN7(B . 20406)
    (?$BN8(B . 24942)
    (?$BN9(B . 26053)
    (?$BN:(B . 34396)
    (?$BN;(B . 20102)
    (?$BN<(B . 20142)
    (?$BN=(B . 20698)
    (?$BN>(B . 20001)
    (?$BN?(B . 20940)
    (?$BN@(B . 23534)
    (?$BNA(B . 26009)
    (?$BNB(B . 26753)
    (?$BNC(B . 28092)
    (?$BND(B . 29471)
    (?$BNE(B . 30274)
    (?$BNF(B . 30637)
    (?$BNG(B . 31260)
    (?$BNH(B . 31975)
    (?$BNI(B . 33391)
    (?$BNJ(B . 35538)
    (?$BNK(B . 36988)
    (?$BNL(B . 37327)
    (?$BNM(B . 38517)
    (?$BNN(B . 38936)
    (?$BNO(B . 21147)
    (?$BNP(B . 32209)
    (?$BNQ(B . 20523)
    (?$BNR(B . 21400)
    (?$BNS(B . 26519)
    (?$BNT(B . 28107)
    (?$BNU(B . 29136)
    (?$BNV(B . 29747)
    (?$BNW(B . 33256)
    (?$BNX(B . 36650)
    (?$BNY(B . 38563)
    (?$BNZ(B . 40023)
    (?$BN[(B . 40607)
    (?$BN\(B . 29792)
    (?$BN](B . 22593)
    (?$BN^(B . 28057)
    (?$BN_(B . 32047)
    (?$BN`(B . 39006)
    (?$BNa(B . 20196)
    (?$BNb(B . 20278)
    (?$BNc(B . 20363)
    (?$BNd(B . 20919)
    (?$BNe(B . 21169)
    (?$BNf(B . 23994)
    (?$BNg(B . 24604)
    (?$BNh(B . 29618)
    (?$BNi(B . 31036)
    (?$BNj(B . 33491)
    (?$BNk(B . 37428)
    (?$BNl(B . 38583)
    (?$BNm(B . 38646)
    (?$BNn(B . 38666)
    (?$BNo(B . 40599)
    (?$BNp(B . 40802)
    (?$BNq(B . 26278)
    (?$BNr(B . 27508)
    (?$BNs(B . 21015)
    (?$BNt(B . 21155)
    (?$BNu(B . 28872)
    (?$BNv(B . 35010)
    (?$BNw(B . 24265)
    (?$BNx(B . 24651)
    (?$BNy(B . 24976)
    (?$BNz(B . 28451)
    (?$BN{(B . 29001)
    (?$BN|(B . 31806)
    (?$BN}(B . 32244)
    (?$BN~(B . 32879)
    (?$BO!(B . 34030)
    (?$BO"(B . 36899)
    (?$BO#(B . 37676)
    (?$BO$(B . 21570)
    (?$BO%(B . 39791)
    (?$BO&(B . 27347)
    (?$BO'(B . 28809)
    (?$BO((B . 36034)
    (?$BO)(B . 36335)
    (?$BO*(B . 38706)
    (?$BO+(B . 21172)
    (?$BO,(B . 23105)
    (?$BO-(B . 24266)
    (?$BO.(B . 24324)
    (?$BO/(B . 26391)
    (?$BO0(B . 27004)
    (?$BO1(B . 27028)
    (?$BO2(B . 28010)
    (?$BO3(B . 28431)
    (?$BO4(B . 29282)
    (?$BO5(B . 29436)
    (?$BO6(B . 31725)
    (?$BO7(B . 32769)
    (?$BO8(B . 32894)
    (?$BO9(B . 34635)
    (?$BO:(B . 37070)
    (?$BO;(B . 20845)
    (?$BO<(B . 40595)
    (?$BO=(B . 31108)
    (?$BO>(B . 32907)
    (?$BO?(B . 37682)
    (?$BO@(B . 35542)
    (?$BOA(B . 20525)
    (?$BOB(B . 21644)
    (?$BOC(B . 35441)
    (?$BOD(B . 27498)
    (?$BOE(B . 36036)
    (?$BOF(B . 33031)
    (?$BOG(B . 24785)
    (?$BOH(B . 26528)
    (?$BOI(B . 40434)
    (?$BOJ(B . 20121)
    (?$BOK(B . 20120)
    (?$BOL(B . 39952)
    (?$BOM(B . 35435)
    (?$BON(B . 34241)
    (?$BOO(B . 34152)
    (?$BOP(B . 26880)
    (?$BOQ(B . 28286)
    (?$BOR(B . 30871)
    (?$BOS(B . 33109)
    (?$BP!(B . 24332)
    (?$BP"(B . 19984)
    (?$BP#(B . 19989)
    (?$BP$(B . 20010)
    (?$BP%(B . 20017)
    (?$BP&(B . 20022)
    (?$BP'(B . 20028)
    (?$BP((B . 20031)
    (?$BP)(B . 20034)
    (?$BP*(B . 20054)
    (?$BP+(B . 20056)
    (?$BP,(B . 20098)
    (?$BP-(B . 20101)
    (?$BP.(B . 35947)
    (?$BP/(B . 20106)
    (?$BP0(B . 33298)
    (?$BP1(B . 24333)
    (?$BP2(B . 20110)
    (?$BP3(B . 20126)
    (?$BP4(B . 20127)
    (?$BP5(B . 20128)
    (?$BP6(B . 20130)
    (?$BP7(B . 20144)
    (?$BP8(B . 20147)
    (?$BP9(B . 20150)
    (?$BP:(B . 20174)
    (?$BP;(B . 20173)
    (?$BP<(B . 20164)
    (?$BP=(B . 20166)
    (?$BP>(B . 20162)
    (?$BP?(B . 20183)
    (?$BP@(B . 20190)
    (?$BPA(B . 20205)
    (?$BPB(B . 20191)
    (?$BPC(B . 20215)
    (?$BPD(B . 20233)
    (?$BPE(B . 20314)
    (?$BPF(B . 20272)
    (?$BPG(B . 20315)
    (?$BPH(B . 20317)
    (?$BPI(B . 20311)
    (?$BPJ(B . 20295)
    (?$BPK(B . 20342)
    (?$BPL(B . 20360)
    (?$BPM(B . 20367)
    (?$BPN(B . 20376)
    (?$BPO(B . 20347)
    (?$BPP(B . 20329)
    (?$BPQ(B . 20336)
    (?$BPR(B . 20369)
    (?$BPS(B . 20335)
    (?$BPT(B . 20358)
    (?$BPU(B . 20374)
    (?$BPV(B . 20760)
    (?$BPW(B . 20436)
    (?$BPX(B . 20447)
    (?$BPY(B . 20430)
    (?$BPZ(B . 20440)
    (?$BP[(B . 20443)
    (?$BP\(B . 20433)
    (?$BP](B . 20442)
    (?$BP^(B . 20432)
    (?$BP_(B . 20452)
    (?$BP`(B . 20453)
    (?$BPa(B . 20506)
    (?$BPb(B . 20520)
    (?$BPc(B . 20500)
    (?$BPd(B . 20522)
    (?$BPe(B . 20517)
    (?$BPf(B . 20485)
    (?$BPg(B . 20252)
    (?$BPh(B . 20470)
    (?$BPi(B . 20513)
    (?$BPj(B . 20521)
    (?$BPk(B . 20524)
    (?$BPl(B . 20478)
    (?$BPm(B . 20463)
    (?$BPn(B . 20497)
    (?$BPo(B . 20486)
    (?$BPp(B . 20547)
    (?$BPq(B . 20551)
    (?$BPr(B . 26371)
    (?$BPs(B . 20565)
    (?$BPt(B . 20560)
    (?$BPu(B . 20552)
    (?$BPv(B . 20570)
    (?$BPw(B . 20566)
    (?$BPx(B . 20588)
    (?$BPy(B . 20600)
    (?$BPz(B . 20608)
    (?$BP{(B . 20634)
    (?$BP|(B . 20613)
    (?$BP}(B . 20660)
    (?$BP~(B . 20658)
    (?$BQ!(B . 20681)
    (?$BQ"(B . 20682)
    (?$BQ#(B . 20659)
    (?$BQ$(B . 20674)
    (?$BQ%(B . 20694)
    (?$BQ&(B . 20702)
    (?$BQ'(B . 20709)
    (?$BQ((B . 20717)
    (?$BQ)(B . 20707)
    (?$BQ*(B . 20718)
    (?$BQ+(B . 20729)
    (?$BQ,(B . 20725)
    (?$BQ-(B . 20745)
    (?$BQ.(B . 20737)
    (?$BQ/(B . 20738)
    (?$BQ0(B . 20758)
    (?$BQ1(B . 20757)
    (?$BQ2(B . 20756)
    (?$BQ3(B . 20762)
    (?$BQ4(B . 20769)
    (?$BQ5(B . 20794)
    (?$BQ6(B . 20791)
    (?$BQ7(B . 20796)
    (?$BQ8(B . 20795)
    (?$BQ9(B . 20799)
    (?$BQ:(B . 20800)
    (?$BQ;(B . 20818)
    (?$BQ<(B . 20812)
    (?$BQ=(B . 20820)
    (?$BQ>(B . 20834)
    (?$BQ?(B . 31480)
    (?$BQ@(B . 20841)
    (?$BQA(B . 20842)
    (?$BQB(B . 20846)
    (?$BQC(B . 20864)
    (?$BQD(B . 20866)
    (?$BQE(B . 22232)
    (?$BQF(B . 20876)
    (?$BQG(B . 20873)
    (?$BQH(B . 20879)
    (?$BQI(B . 20881)
    (?$BQJ(B . 20883)
    (?$BQK(B . 20885)
    (?$BQL(B . 20886)
    (?$BQM(B . 20900)
    (?$BQN(B . 20902)
    (?$BQO(B . 20898)
    (?$BQP(B . 20905)
    (?$BQQ(B . 20906)
    (?$BQR(B . 20907)
    (?$BQS(B . 20915)
    (?$BQT(B . 20913)
    (?$BQU(B . 20914)
    (?$BQV(B . 20912)
    (?$BQW(B . 20917)
    (?$BQX(B . 20925)
    (?$BQY(B . 20933)
    (?$BQZ(B . 20937)
    (?$BQ[(B . 20955)
    (?$BQ\(B . 20960)
    (?$BQ](B . 34389)
    (?$BQ^(B . 20969)
    (?$BQ_(B . 20973)
    (?$BQ`(B . 20976)
    (?$BQa(B . 20981)
    (?$BQb(B . 20990)
    (?$BQc(B . 20996)
    (?$BQd(B . 21003)
    (?$BQe(B . 21012)
    (?$BQf(B . 21006)
    (?$BQg(B . 21031)
    (?$BQh(B . 21034)
    (?$BQi(B . 21038)
    (?$BQj(B . 21043)
    (?$BQk(B . 21049)
    (?$BQl(B . 21071)
    (?$BQm(B . 21060)
    (?$BQn(B . 21067)
    (?$BQo(B . 21068)
    (?$BQp(B . 21086)
    (?$BQq(B . 21076)
    (?$BQr(B . 21098)
    (?$BQs(B . 21108)
    (?$BQt(B . 21097)
    (?$BQu(B . 21107)
    (?$BQv(B . 21119)
    (?$BQw(B . 21117)
    (?$BQx(B . 21133)
    (?$BQy(B . 21140)
    (?$BQz(B . 21138)
    (?$BQ{(B . 21105)
    (?$BQ|(B . 21128)
    (?$BQ}(B . 21137)
    (?$BQ~(B . 36776)
    (?$BR!(B . 36775)
    (?$BR"(B . 21164)
    (?$BR#(B . 21165)
    (?$BR$(B . 21180)
    (?$BR%(B . 21173)
    (?$BR&(B . 21185)
    (?$BR'(B . 21197)
    (?$BR((B . 21207)
    (?$BR)(B . 21214)
    (?$BR*(B . 21219)
    (?$BR+(B . 21222)
    (?$BR,(B . 39149)
    (?$BR-(B . 21216)
    (?$BR.(B . 21235)
    (?$BR/(B . 21237)
    (?$BR0(B . 21240)
    (?$BR1(B . 21241)
    (?$BR2(B . 21254)
    (?$BR3(B . 21256)
    (?$BR4(B . 30008)
    (?$BR5(B . 21261)
    (?$BR6(B . 21264)
    (?$BR7(B . 21263)
    (?$BR8(B . 21269)
    (?$BR9(B . 21274)
    (?$BR:(B . 21283)
    (?$BR;(B . 21295)
    (?$BR<(B . 21297)
    (?$BR=(B . 21299)
    (?$BR>(B . 21304)
    (?$BR?(B . 21312)
    (?$BR@(B . 21318)
    (?$BRA(B . 21317)
    (?$BRB(B . 19991)
    (?$BRC(B . 21321)
    (?$BRD(B . 21325)
    (?$BRE(B . 20950)
    (?$BRF(B . 21342)
    (?$BRG(B . 21353)
    (?$BRH(B . 21358)
    (?$BRI(B . 22808)
    (?$BRJ(B . 21371)
    (?$BRK(B . 21367)
    (?$BRL(B . 21378)
    (?$BRM(B . 21398)
    (?$BRN(B . 21408)
    (?$BRO(B . 21414)
    (?$BRP(B . 21413)
    (?$BRQ(B . 21422)
    (?$BRR(B . 21424)
    (?$BRS(B . 21430)
    (?$BRT(B . 21443)
    (?$BRU(B . 31762)
    (?$BRV(B . 38617)
    (?$BRW(B . 21471)
    (?$BRX(B . 26364)
    (?$BRY(B . 29166)
    (?$BRZ(B . 21486)
    (?$BR[(B . 21480)
    (?$BR\(B . 21485)
    (?$BR](B . 21498)
    (?$BR^(B . 21505)
    (?$BR_(B . 21565)
    (?$BR`(B . 21568)
    (?$BRa(B . 21548)
    (?$BRb(B . 21549)
    (?$BRc(B . 21564)
    (?$BRd(B . 21550)
    (?$BRe(B . 21558)
    (?$BRf(B . 21545)
    (?$BRg(B . 21533)
    (?$BRh(B . 21582)
    (?$BRi(B . 21647)
    (?$BRj(B . 21621)
    (?$BRk(B . 21646)
    (?$BRl(B . 21599)
    (?$BRm(B . 21617)
    (?$BRn(B . 21623)
    (?$BRo(B . 21616)
    (?$BRp(B . 21650)
    (?$BRq(B . 21627)
    (?$BRr(B . 21632)
    (?$BRs(B . 21622)
    (?$BRt(B . 21636)
    (?$BRu(B . 21648)
    (?$BRv(B . 21638)
    (?$BRw(B . 21703)
    (?$BRx(B . 21666)
    (?$BRy(B . 21688)
    (?$BRz(B . 21669)
    (?$BR{(B . 21676)
    (?$BR|(B . 21700)
    (?$BR}(B . 21704)
    (?$BR~(B . 21672)
    (?$BS!(B . 21675)
    (?$BS"(B . 21698)
    (?$BS#(B . 21668)
    (?$BS$(B . 21694)
    (?$BS%(B . 21692)
    (?$BS&(B . 21720)
    (?$BS'(B . 21733)
    (?$BS((B . 21734)
    (?$BS)(B . 21775)
    (?$BS*(B . 21780)
    (?$BS+(B . 21757)
    (?$BS,(B . 21742)
    (?$BS-(B . 21741)
    (?$BS.(B . 21754)
    (?$BS/(B . 21730)
    (?$BS0(B . 21817)
    (?$BS1(B . 21824)
    (?$BS2(B . 21859)
    (?$BS3(B . 21836)
    (?$BS4(B . 21806)
    (?$BS5(B . 21852)
    (?$BS6(B . 21829)
    (?$BS7(B . 21846)
    (?$BS8(B . 21847)
    (?$BS9(B . 21816)
    (?$BS:(B . 21811)
    (?$BS;(B . 21853)
    (?$BS<(B . 21913)
    (?$BS=(B . 21888)
    (?$BS>(B . 21679)
    (?$BS?(B . 21898)
    (?$BS@(B . 21919)
    (?$BSA(B . 21883)
    (?$BSB(B . 21886)
    (?$BSC(B . 21912)
    (?$BSD(B . 21918)
    (?$BSE(B . 21934)
    (?$BSF(B . 21884)
    (?$BSG(B . 21891)
    (?$BSH(B . 21929)
    (?$BSI(B . 21895)
    (?$BSJ(B . 21928)
    (?$BSK(B . 21978)
    (?$BSL(B . 21957)
    (?$BSM(B . 21983)
    (?$BSN(B . 21956)
    (?$BSO(B . 21980)
    (?$BSP(B . 21988)
    (?$BSQ(B . 21972)
    (?$BSR(B . 22036)
    (?$BSS(B . 22007)
    (?$BST(B . 22038)
    (?$BSU(B . 22014)
    (?$BSV(B . 22013)
    (?$BSW(B . 22043)
    (?$BSX(B . 22009)
    (?$BSY(B . 22094)
    (?$BSZ(B . 22096)
    (?$BS[(B . 29151)
    (?$BS\(B . 22068)
    (?$BS](B . 22070)
    (?$BS^(B . 22066)
    (?$BS_(B . 22072)
    (?$BS`(B . 22123)
    (?$BSa(B . 22116)
    (?$BSb(B . 22063)
    (?$BSc(B . 22124)
    (?$BSd(B . 22122)
    (?$BSe(B . 22150)
    (?$BSf(B . 22144)
    (?$BSg(B . 22154)
    (?$BSh(B . 22176)
    (?$BSi(B . 22164)
    (?$BSj(B . 22159)
    (?$BSk(B . 22181)
    (?$BSl(B . 22190)
    (?$BSm(B . 22198)
    (?$BSn(B . 22196)
    (?$BSo(B . 22210)
    (?$BSp(B . 22204)
    (?$BSq(B . 22209)
    (?$BSr(B . 22211)
    (?$BSs(B . 22208)
    (?$BSt(B . 22216)
    (?$BSu(B . 22222)
    (?$BSv(B . 22225)
    (?$BSw(B . 22227)
    (?$BSx(B . 22231)
    (?$BSy(B . 22254)
    (?$BSz(B . 22265)
    (?$BS{(B . 22272)
    (?$BS|(B . 22271)
    (?$BS}(B . 22276)
    (?$BS~(B . 22281)
    (?$BT!(B . 22280)
    (?$BT"(B . 22283)
    (?$BT#(B . 22285)
    (?$BT$(B . 22291)
    (?$BT%(B . 22296)
    (?$BT&(B . 22294)
    (?$BT'(B . 21959)
    (?$BT((B . 22300)
    (?$BT)(B . 22310)
    (?$BT*(B . 22327)
    (?$BT+(B . 22328)
    (?$BT,(B . 22350)
    (?$BT-(B . 22331)
    (?$BT.(B . 22336)
    (?$BT/(B . 22351)
    (?$BT0(B . 22377)
    (?$BT1(B . 22464)
    (?$BT2(B . 22408)
    (?$BT3(B . 22369)
    (?$BT4(B . 22399)
    (?$BT5(B . 22409)
    (?$BT6(B . 22419)
    (?$BT7(B . 22432)
    (?$BT8(B . 22451)
    (?$BT9(B . 22436)
    (?$BT:(B . 22442)
    (?$BT;(B . 22448)
    (?$BT<(B . 22467)
    (?$BT=(B . 22470)
    (?$BT>(B . 22484)
    (?$BT?(B . 22482)
    (?$BT@(B . 22483)
    (?$BTA(B . 22538)
    (?$BTB(B . 22486)
    (?$BTC(B . 22499)
    (?$BTD(B . 22539)
    (?$BTE(B . 22553)
    (?$BTF(B . 22557)
    (?$BTG(B . 22642)
    (?$BTH(B . 22561)
    (?$BTI(B . 22626)
    (?$BTJ(B . 22603)
    (?$BTK(B . 22640)
    (?$BTL(B . 27584)
    (?$BTM(B . 22610)
    (?$BTN(B . 22589)
    (?$BTO(B . 22649)
    (?$BTP(B . 22661)
    (?$BTQ(B . 22713)
    (?$BTR(B . 22687)
    (?$BTS(B . 22699)
    (?$BTT(B . 22714)
    (?$BTU(B . 22750)
    (?$BTV(B . 22715)
    (?$BTW(B . 22712)
    (?$BTX(B . 22702)
    (?$BTY(B . 22725)
    (?$BTZ(B . 22739)
    (?$BT[(B . 22737)
    (?$BT\(B . 22743)
    (?$BT](B . 22745)
    (?$BT^(B . 22744)
    (?$BT_(B . 22757)
    (?$BT`(B . 22748)
    (?$BTa(B . 22756)
    (?$BTb(B . 22751)
    (?$BTc(B . 22767)
    (?$BTd(B . 22778)
    (?$BTe(B . 22777)
    (?$BTf(B . 22779)
    (?$BTg(B . 22780)
    (?$BTh(B . 22781)
    (?$BTi(B . 22786)
    (?$BTj(B . 22794)
    (?$BTk(B . 22800)
    (?$BTl(B . 22811)
    (?$BTm(B . 26790)
    (?$BTn(B . 22821)
    (?$BTo(B . 22828)
    (?$BTp(B . 22829)
    (?$BTq(B . 22834)
    (?$BTr(B . 22840)
    (?$BTs(B . 22846)
    (?$BTt(B . 31442)
    (?$BTu(B . 22869)
    (?$BTv(B . 22864)
    (?$BTw(B . 22862)
    (?$BTx(B . 22874)
    (?$BTy(B . 22872)
    (?$BTz(B . 22882)
    (?$BT{(B . 22880)
    (?$BT|(B . 22887)
    (?$BT}(B . 22892)
    (?$BT~(B . 22889)
    (?$BU!(B . 22904)
    (?$BU"(B . 22913)
    (?$BU#(B . 22941)
    (?$BU$(B . 20318)
    (?$BU%(B . 20395)
    (?$BU&(B . 22947)
    (?$BU'(B . 22962)
    (?$BU((B . 22982)
    (?$BU)(B . 23016)
    (?$BU*(B . 23004)
    (?$BU+(B . 22925)
    (?$BU,(B . 23001)
    (?$BU-(B . 23002)
    (?$BU.(B . 23077)
    (?$BU/(B . 23071)
    (?$BU0(B . 23057)
    (?$BU1(B . 23068)
    (?$BU2(B . 23049)
    (?$BU3(B . 23066)
    (?$BU4(B . 23104)
    (?$BU5(B . 23148)
    (?$BU6(B . 23113)
    (?$BU7(B . 23093)
    (?$BU8(B . 23094)
    (?$BU9(B . 23138)
    (?$BU:(B . 23146)
    (?$BU;(B . 23194)
    (?$BU<(B . 23228)
    (?$BU=(B . 23230)
    (?$BU>(B . 23243)
    (?$BU?(B . 23234)
    (?$BU@(B . 23229)
    (?$BUA(B . 23267)
    (?$BUB(B . 23255)
    (?$BUC(B . 23270)
    (?$BUD(B . 23273)
    (?$BUE(B . 23254)
    (?$BUF(B . 23290)
    (?$BUG(B . 23291)
    (?$BUH(B . 23308)
    (?$BUI(B . 23307)
    (?$BUJ(B . 23318)
    (?$BUK(B . 23346)
    (?$BUL(B . 23248)
    (?$BUM(B . 23338)
    (?$BUN(B . 23350)
    (?$BUO(B . 23358)
    (?$BUP(B . 23363)
    (?$BUQ(B . 23365)
    (?$BUR(B . 23360)
    (?$BUS(B . 23377)
    (?$BUT(B . 23381)
    (?$BUU(B . 23386)
    (?$BUV(B . 23387)
    (?$BUW(B . 23397)
    (?$BUX(B . 23401)
    (?$BUY(B . 23408)
    (?$BUZ(B . 23411)
    (?$BU[(B . 23413)
    (?$BU\(B . 23416)
    (?$BU](B . 25992)
    (?$BU^(B . 23418)
    (?$BU_(B . 23424)
    (?$BU`(B . 23427)
    (?$BUa(B . 23462)
    (?$BUb(B . 23480)
    (?$BUc(B . 23491)
    (?$BUd(B . 23495)
    (?$BUe(B . 23497)
    (?$BUf(B . 23508)
    (?$BUg(B . 23504)
    (?$BUh(B . 23524)
    (?$BUi(B . 23526)
    (?$BUj(B . 23522)
    (?$BUk(B . 23518)
    (?$BUl(B . 23525)
    (?$BUm(B . 23531)
    (?$BUn(B . 23536)
    (?$BUo(B . 23542)
    (?$BUp(B . 23539)
    (?$BUq(B . 23557)
    (?$BUr(B . 23559)
    (?$BUs(B . 23560)
    (?$BUt(B . 23565)
    (?$BUu(B . 23571)
    (?$BUv(B . 23584)
    (?$BUw(B . 23586)
    (?$BUx(B . 23592)
    (?$BUy(B . 23608)
    (?$BUz(B . 23609)
    (?$BU{(B . 23617)
    (?$BU|(B . 23622)
    (?$BU}(B . 23630)
    (?$BU~(B . 23635)
    (?$BV!(B . 23632)
    (?$BV"(B . 23631)
    (?$BV#(B . 23409)
    (?$BV$(B . 23660)
    (?$BV%(B . 23662)
    (?$BV&(B . 20066)
    (?$BV'(B . 23670)
    (?$BV((B . 23673)
    (?$BV)(B . 23692)
    (?$BV*(B . 23697)
    (?$BV+(B . 23700)
    (?$BV,(B . 22939)
    (?$BV-(B . 23723)
    (?$BV.(B . 23739)
    (?$BV/(B . 23734)
    (?$BV0(B . 23740)
    (?$BV1(B . 23735)
    (?$BV2(B . 23749)
    (?$BV3(B . 23742)
    (?$BV4(B . 23751)
    (?$BV5(B . 23769)
    (?$BV6(B . 23785)
    (?$BV7(B . 23805)
    (?$BV8(B . 23802)
    (?$BV9(B . 23789)
    (?$BV:(B . 23948)
    (?$BV;(B . 23786)
    (?$BV<(B . 23819)
    (?$BV=(B . 23829)
    (?$BV>(B . 23831)
    (?$BV?(B . 23900)
    (?$BV@(B . 23839)
    (?$BVA(B . 23835)
    (?$BVB(B . 23825)
    (?$BVC(B . 23828)
    (?$BVD(B . 23842)
    (?$BVE(B . 23834)
    (?$BVF(B . 23833)
    (?$BVG(B . 23832)
    (?$BVH(B . 23884)
    (?$BVI(B . 23890)
    (?$BVJ(B . 23886)
    (?$BVK(B . 23883)
    (?$BVL(B . 23916)
    (?$BVM(B . 23923)
    (?$BVN(B . 23926)
    (?$BVO(B . 23943)
    (?$BVP(B . 23940)
    (?$BVQ(B . 23938)
    (?$BVR(B . 23970)
    (?$BVS(B . 23965)
    (?$BVT(B . 23980)
    (?$BVU(B . 23982)
    (?$BVV(B . 23997)
    (?$BVW(B . 23952)
    (?$BVX(B . 23991)
    (?$BVY(B . 23996)
    (?$BVZ(B . 24009)
    (?$BV[(B . 24013)
    (?$BV\(B . 24019)
    (?$BV](B . 24018)
    (?$BV^(B . 24022)
    (?$BV_(B . 24027)
    (?$BV`(B . 24043)
    (?$BVa(B . 24050)
    (?$BVb(B . 24053)
    (?$BVc(B . 24075)
    (?$BVd(B . 24090)
    (?$BVe(B . 24089)
    (?$BVf(B . 24081)
    (?$BVg(B . 24091)
    (?$BVh(B . 24118)
    (?$BVi(B . 24119)
    (?$BVj(B . 24132)
    (?$BVk(B . 24131)
    (?$BVl(B . 24128)
    (?$BVm(B . 24142)
    (?$BVn(B . 24151)
    (?$BVo(B . 24148)
    (?$BVp(B . 24159)
    (?$BVq(B . 24162)
    (?$BVr(B . 24164)
    (?$BVs(B . 24135)
    (?$BVt(B . 24181)
    (?$BVu(B . 24182)
    (?$BVv(B . 24186)
    (?$BVw(B . 40636)
    (?$BVx(B . 24191)
    (?$BVy(B . 24224)
    (?$BVz(B . 24257)
    (?$BV{(B . 24258)
    (?$BV|(B . 24264)
    (?$BV}(B . 24272)
    (?$BV~(B . 24271)
    (?$BW!(B . 24278)
    (?$BW"(B . 24291)
    (?$BW#(B . 24285)
    (?$BW$(B . 24282)
    (?$BW%(B . 24283)
    (?$BW&(B . 24290)
    (?$BW'(B . 24289)
    (?$BW((B . 24296)
    (?$BW)(B . 24297)
    (?$BW*(B . 24300)
    (?$BW+(B . 24305)
    (?$BW,(B . 24307)
    (?$BW-(B . 24304)
    (?$BW.(B . 24308)
    (?$BW/(B . 24312)
    (?$BW0(B . 24318)
    (?$BW1(B . 24323)
    (?$BW2(B . 24329)
    (?$BW3(B . 24413)
    (?$BW4(B . 24412)
    (?$BW5(B . 24331)
    (?$BW6(B . 24337)
    (?$BW7(B . 24342)
    (?$BW8(B . 24361)
    (?$BW9(B . 24365)
    (?$BW:(B . 24376)
    (?$BW;(B . 24385)
    (?$BW<(B . 24392)
    (?$BW=(B . 24396)
    (?$BW>(B . 24398)
    (?$BW?(B . 24367)
    (?$BW@(B . 24401)
    (?$BWA(B . 24406)
    (?$BWB(B . 24407)
    (?$BWC(B . 24409)
    (?$BWD(B . 24417)
    (?$BWE(B . 24429)
    (?$BWF(B . 24435)
    (?$BWG(B . 24439)
    (?$BWH(B . 24451)
    (?$BWI(B . 24450)
    (?$BWJ(B . 24447)
    (?$BWK(B . 24458)
    (?$BWL(B . 24456)
    (?$BWM(B . 24465)
    (?$BWN(B . 24455)
    (?$BWO(B . 24478)
    (?$BWP(B . 24473)
    (?$BWQ(B . 24472)
    (?$BWR(B . 24480)
    (?$BWS(B . 24488)
    (?$BWT(B . 24493)
    (?$BWU(B . 24508)
    (?$BWV(B . 24534)
    (?$BWW(B . 24571)
    (?$BWX(B . 24548)
    (?$BWY(B . 24568)
    (?$BWZ(B . 24561)
    (?$BW[(B . 24541)
    (?$BW\(B . 24755)
    (?$BW](B . 24575)
    (?$BW^(B . 24609)
    (?$BW_(B . 24672)
    (?$BW`(B . 24601)
    (?$BWa(B . 24592)
    (?$BWb(B . 24617)
    (?$BWc(B . 24590)
    (?$BWd(B . 24625)
    (?$BWe(B . 24603)
    (?$BWf(B . 24597)
    (?$BWg(B . 24619)
    (?$BWh(B . 24614)
    (?$BWi(B . 24591)
    (?$BWj(B . 24634)
    (?$BWk(B . 24666)
    (?$BWl(B . 24641)
    (?$BWm(B . 24682)
    (?$BWn(B . 24695)
    (?$BWo(B . 24671)
    (?$BWp(B . 24650)
    (?$BWq(B . 24646)
    (?$BWr(B . 24653)
    (?$BWs(B . 24675)
    (?$BWt(B . 24643)
    (?$BWu(B . 24676)
    (?$BWv(B . 24642)
    (?$BWw(B . 24684)
    (?$BWx(B . 24683)
    (?$BWy(B . 24665)
    (?$BWz(B . 24705)
    (?$BW{(B . 24717)
    (?$BW|(B . 24807)
    (?$BW}(B . 24707)
    (?$BW~(B . 24730)
    (?$BX!(B . 24708)
    (?$BX"(B . 24731)
    (?$BX#(B . 24726)
    (?$BX$(B . 24727)
    (?$BX%(B . 24722)
    (?$BX&(B . 24743)
    (?$BX'(B . 24715)
    (?$BX((B . 24801)
    (?$BX)(B . 24760)
    (?$BX*(B . 24800)
    (?$BX+(B . 24787)
    (?$BX,(B . 24756)
    (?$BX-(B . 24560)
    (?$BX.(B . 24765)
    (?$BX/(B . 24774)
    (?$BX0(B . 24757)
    (?$BX1(B . 24792)
    (?$BX2(B . 24909)
    (?$BX3(B . 24853)
    (?$BX4(B . 24838)
    (?$BX5(B . 24822)
    (?$BX6(B . 24823)
    (?$BX7(B . 24832)
    (?$BX8(B . 24820)
    (?$BX9(B . 24826)
    (?$BX:(B . 24835)
    (?$BX;(B . 24865)
    (?$BX<(B . 24827)
    (?$BX=(B . 24817)
    (?$BX>(B . 24845)
    (?$BX?(B . 24846)
    (?$BX@(B . 24903)
    (?$BXA(B . 24894)
    (?$BXB(B . 24872)
    (?$BXC(B . 24871)
    (?$BXD(B . 24906)
    (?$BXE(B . 24895)
    (?$BXF(B . 24892)
    (?$BXG(B . 24876)
    (?$BXH(B . 24884)
    (?$BXI(B . 24893)
    (?$BXJ(B . 24898)
    (?$BXK(B . 24900)
    (?$BXL(B . 24947)
    (?$BXM(B . 24951)
    (?$BXN(B . 24920)
    (?$BXO(B . 24921)
    (?$BXP(B . 24922)
    (?$BXQ(B . 24939)
    (?$BXR(B . 24948)
    (?$BXS(B . 24943)
    (?$BXT(B . 24933)
    (?$BXU(B . 24945)
    (?$BXV(B . 24927)
    (?$BXW(B . 24925)
    (?$BXX(B . 24915)
    (?$BXY(B . 24949)
    (?$BXZ(B . 24985)
    (?$BX[(B . 24982)
    (?$BX\(B . 24967)
    (?$BX](B . 25004)
    (?$BX^(B . 24980)
    (?$BX_(B . 24986)
    (?$BX`(B . 24970)
    (?$BXa(B . 24977)
    (?$BXb(B . 25003)
    (?$BXc(B . 25006)
    (?$BXd(B . 25036)
    (?$BXe(B . 25034)
    (?$BXf(B . 25033)
    (?$BXg(B . 25079)
    (?$BXh(B . 25032)
    (?$BXi(B . 25027)
    (?$BXj(B . 25030)
    (?$BXk(B . 25018)
    (?$BXl(B . 25035)
    (?$BXm(B . 32633)
    (?$BXn(B . 25037)
    (?$BXo(B . 25062)
    (?$BXp(B . 25059)
    (?$BXq(B . 25078)
    (?$BXr(B . 25082)
    (?$BXs(B . 25076)
    (?$BXt(B . 25087)
    (?$BXu(B . 25085)
    (?$BXv(B . 25084)
    (?$BXw(B . 25086)
    (?$BXx(B . 25088)
    (?$BXy(B . 25096)
    (?$BXz(B . 25097)
    (?$BX{(B . 25101)
    (?$BX|(B . 25100)
    (?$BX}(B . 25108)
    (?$BX~(B . 25115)
    (?$BY!(B . 25118)
    (?$BY"(B . 25121)
    (?$BY#(B . 25130)
    (?$BY$(B . 25134)
    (?$BY%(B . 25136)
    (?$BY&(B . 25138)
    (?$BY'(B . 25139)
    (?$BY((B . 25153)
    (?$BY)(B . 25166)
    (?$BY*(B . 25182)
    (?$BY+(B . 25187)
    (?$BY,(B . 25179)
    (?$BY-(B . 25184)
    (?$BY.(B . 25192)
    (?$BY/(B . 25212)
    (?$BY0(B . 25218)
    (?$BY1(B . 25225)
    (?$BY2(B . 25214)
    (?$BY3(B . 25234)
    (?$BY4(B . 25235)
    (?$BY5(B . 25238)
    (?$BY6(B . 25300)
    (?$BY7(B . 25219)
    (?$BY8(B . 25236)
    (?$BY9(B . 25303)
    (?$BY:(B . 25297)
    (?$BY;(B . 25275)
    (?$BY<(B . 25295)
    (?$BY=(B . 25343)
    (?$BY>(B . 25286)
    (?$BY?(B . 25812)
    (?$BY@(B . 25288)
    (?$BYA(B . 25308)
    (?$BYB(B . 25292)
    (?$BYC(B . 25290)
    (?$BYD(B . 25282)
    (?$BYE(B . 25287)
    (?$BYF(B . 25243)
    (?$BYG(B . 25289)
    (?$BYH(B . 25356)
    (?$BYI(B . 25326)
    (?$BYJ(B . 25329)
    (?$BYK(B . 25383)
    (?$BYL(B . 25346)
    (?$BYM(B . 25352)
    (?$BYN(B . 25327)
    (?$BYO(B . 25333)
    (?$BYP(B . 25424)
    (?$BYQ(B . 25406)
    (?$BYR(B . 25421)
    (?$BYS(B . 25628)
    (?$BYT(B . 25423)
    (?$BYU(B . 25494)
    (?$BYV(B . 25486)
    (?$BYW(B . 25472)
    (?$BYX(B . 25515)
    (?$BYY(B . 25462)
    (?$BYZ(B . 25507)
    (?$BY[(B . 25487)
    (?$BY\(B . 25481)
    (?$BY](B . 25503)
    (?$BY^(B . 25525)
    (?$BY_(B . 25451)
    (?$BY`(B . 25449)
    (?$BYa(B . 25534)
    (?$BYb(B . 25577)
    (?$BYc(B . 25536)
    (?$BYd(B . 25542)
    (?$BYe(B . 25571)
    (?$BYf(B . 25545)
    (?$BYg(B . 25554)
    (?$BYh(B . 25590)
    (?$BYi(B . 25540)
    (?$BYj(B . 25622)
    (?$BYk(B . 25652)
    (?$BYl(B . 25606)
    (?$BYm(B . 25619)
    (?$BYn(B . 25638)
    (?$BYo(B . 25654)
    (?$BYp(B . 25885)
    (?$BYq(B . 25623)
    (?$BYr(B . 25640)
    (?$BYs(B . 25615)
    (?$BYt(B . 25703)
    (?$BYu(B . 25711)
    (?$BYv(B . 25718)
    (?$BYw(B . 25678)
    (?$BYx(B . 25898)
    (?$BYy(B . 25749)
    (?$BYz(B . 25747)
    (?$BY{(B . 25765)
    (?$BY|(B . 25769)
    (?$BY}(B . 25736)
    (?$BY~(B . 25788)
    (?$BZ!(B . 25818)
    (?$BZ"(B . 25810)
    (?$BZ#(B . 25797)
    (?$BZ$(B . 25799)
    (?$BZ%(B . 25787)
    (?$BZ&(B . 25816)
    (?$BZ'(B . 25794)
    (?$BZ((B . 25841)
    (?$BZ)(B . 25831)
    (?$BZ*(B . 33289)
    (?$BZ+(B . 25824)
    (?$BZ,(B . 25825)
    (?$BZ-(B . 25260)
    (?$BZ.(B . 25827)
    (?$BZ/(B . 25839)
    (?$BZ0(B . 25900)
    (?$BZ1(B . 25846)
    (?$BZ2(B . 25844)
    (?$BZ3(B . 25842)
    (?$BZ4(B . 25850)
    (?$BZ5(B . 25856)
    (?$BZ6(B . 25853)
    (?$BZ7(B . 25880)
    (?$BZ8(B . 25884)
    (?$BZ9(B . 25861)
    (?$BZ:(B . 25892)
    (?$BZ;(B . 25891)
    (?$BZ<(B . 25899)
    (?$BZ=(B . 25908)
    (?$BZ>(B . 25909)
    (?$BZ?(B . 25911)
    (?$BZ@(B . 25910)
    (?$BZA(B . 25912)
    (?$BZB(B . 30027)
    (?$BZC(B . 25928)
    (?$BZD(B . 25942)
    (?$BZE(B . 25941)
    (?$BZF(B . 25933)
    (?$BZG(B . 25944)
    (?$BZH(B . 25950)
    (?$BZI(B . 25949)
    (?$BZJ(B . 25970)
    (?$BZK(B . 25976)
    (?$BZL(B . 25986)
    (?$BZM(B . 25987)
    (?$BZN(B . 35722)
    (?$BZO(B . 26011)
    (?$BZP(B . 26015)
    (?$BZQ(B . 26027)
    (?$BZR(B . 26039)
    (?$BZS(B . 26051)
    (?$BZT(B . 26054)
    (?$BZU(B . 26049)
    (?$BZV(B . 26052)
    (?$BZW(B . 26060)
    (?$BZX(B . 26066)
    (?$BZY(B . 26075)
    (?$BZZ(B . 26073)
    (?$BZ[(B . 26080)
    (?$BZ\(B . 26081)
    (?$BZ](B . 26097)
    (?$BZ^(B . 26482)
    (?$BZ_(B . 26122)
    (?$BZ`(B . 26115)
    (?$BZa(B . 26107)
    (?$BZb(B . 26483)
    (?$BZc(B . 26165)
    (?$BZd(B . 26166)
    (?$BZe(B . 26164)
    (?$BZf(B . 26140)
    (?$BZg(B . 26191)
    (?$BZh(B . 26180)
    (?$BZi(B . 26185)
    (?$BZj(B . 26177)
    (?$BZk(B . 26206)
    (?$BZl(B . 26205)
    (?$BZm(B . 26212)
    (?$BZn(B . 26215)
    (?$BZo(B . 26216)
    (?$BZp(B . 26207)
    (?$BZq(B . 26210)
    (?$BZr(B . 26224)
    (?$BZs(B . 26243)
    (?$BZt(B . 26248)
    (?$BZu(B . 26254)
    (?$BZv(B . 26249)
    (?$BZw(B . 26244)
    (?$BZx(B . 26264)
    (?$BZy(B . 26269)
    (?$BZz(B . 26305)
    (?$BZ{(B . 26297)
    (?$BZ|(B . 26313)
    (?$BZ}(B . 26302)
    (?$BZ~(B . 26300)
    (?$B[!(B . 26308)
    (?$B["(B . 26296)
    (?$B[#(B . 26326)
    (?$B[$(B . 26330)
    (?$B[%(B . 26336)
    (?$B[&(B . 26175)
    (?$B['(B . 26342)
    (?$B[((B . 26345)
    (?$B[)(B . 26352)
    (?$B[*(B . 26357)
    (?$B[+(B . 26359)
    (?$B[,(B . 26383)
    (?$B[-(B . 26390)
    (?$B[.(B . 26398)
    (?$B[/(B . 26406)
    (?$B[0(B . 26407)
    (?$B[1(B . 38712)
    (?$B[2(B . 26414)
    (?$B[3(B . 26431)
    (?$B[4(B . 26422)
    (?$B[5(B . 26433)
    (?$B[6(B . 26424)
    (?$B[7(B . 26423)
    (?$B[8(B . 26438)
    (?$B[9(B . 26462)
    (?$B[:(B . 26464)
    (?$B[;(B . 26457)
    (?$B[<(B . 26467)
    (?$B[=(B . 26468)
    (?$B[>(B . 26505)
    (?$B[?(B . 26480)
    (?$B[@(B . 26537)
    (?$B[A(B . 26492)
    (?$B[B(B . 26474)
    (?$B[C(B . 26508)
    (?$B[D(B . 26507)
    (?$B[E(B . 26534)
    (?$B[F(B . 26529)
    (?$B[G(B . 26501)
    (?$B[H(B . 26551)
    (?$B[I(B . 26607)
    (?$B[J(B . 26548)
    (?$B[K(B . 26604)
    (?$B[L(B . 26547)
    (?$B[M(B . 26601)
    (?$B[N(B . 26552)
    (?$B[O(B . 26596)
    (?$B[P(B . 26590)
    (?$B[Q(B . 26589)
    (?$B[R(B . 26594)
    (?$B[S(B . 26606)
    (?$B[T(B . 26553)
    (?$B[U(B . 26574)
    (?$B[V(B . 26566)
    (?$B[W(B . 26599)
    (?$B[X(B . 27292)
    (?$B[Y(B . 26654)
    (?$B[Z(B . 26694)
    (?$B[[(B . 26665)
    (?$B[\(B . 26688)
    (?$B[](B . 26701)
    (?$B[^(B . 26674)
    (?$B[_(B . 26702)
    (?$B[`(B . 26803)
    (?$B[a(B . 26667)
    (?$B[b(B . 26713)
    (?$B[c(B . 26723)
    (?$B[d(B . 26743)
    (?$B[e(B . 26751)
    (?$B[f(B . 26783)
    (?$B[g(B . 26767)
    (?$B[h(B . 26797)
    (?$B[i(B . 26772)
    (?$B[j(B . 26781)
    (?$B[k(B . 26779)
    (?$B[l(B . 26755)
    (?$B[m(B . 27310)
    (?$B[n(B . 26809)
    (?$B[o(B . 26740)
    (?$B[p(B . 26805)
    (?$B[q(B . 26784)
    (?$B[r(B . 26810)
    (?$B[s(B . 26895)
    (?$B[t(B . 26765)
    (?$B[u(B . 26750)
    (?$B[v(B . 26881)
    (?$B[w(B . 26826)
    (?$B[x(B . 26888)
    (?$B[y(B . 26840)
    (?$B[z(B . 26914)
    (?$B[{(B . 26918)
    (?$B[|(B . 26849)
    (?$B[}(B . 26892)
    (?$B[~(B . 26829)
    (?$B\!(B . 26836)
    (?$B\"(B . 26855)
    (?$B\#(B . 26837)
    (?$B\$(B . 26934)
    (?$B\%(B . 26898)
    (?$B\&(B . 26884)
    (?$B\'(B . 26839)
    (?$B\((B . 26851)
    (?$B\)(B . 26917)
    (?$B\*(B . 26873)
    (?$B\+(B . 26848)
    (?$B\,(B . 26863)
    (?$B\-(B . 26920)
    (?$B\.(B . 26922)
    (?$B\/(B . 26906)
    (?$B\0(B . 26915)
    (?$B\1(B . 26913)
    (?$B\2(B . 26822)
    (?$B\3(B . 27001)
    (?$B\4(B . 26999)
    (?$B\5(B . 26972)
    (?$B\6(B . 27000)
    (?$B\7(B . 26987)
    (?$B\8(B . 26964)
    (?$B\9(B . 27006)
    (?$B\:(B . 26990)
    (?$B\;(B . 26937)
    (?$B\<(B . 26996)
    (?$B\=(B . 26941)
    (?$B\>(B . 26969)
    (?$B\?(B . 26928)
    (?$B\@(B . 26977)
    (?$B\A(B . 26974)
    (?$B\B(B . 26973)
    (?$B\C(B . 27009)
    (?$B\D(B . 26986)
    (?$B\E(B . 27058)
    (?$B\F(B . 27054)
    (?$B\G(B . 27088)
    (?$B\H(B . 27071)
    (?$B\I(B . 27073)
    (?$B\J(B . 27091)
    (?$B\K(B . 27070)
    (?$B\L(B . 27086)
    (?$B\M(B . 23528)
    (?$B\N(B . 27082)
    (?$B\O(B . 27101)
    (?$B\P(B . 27067)
    (?$B\Q(B . 27075)
    (?$B\R(B . 27047)
    (?$B\S(B . 27182)
    (?$B\T(B . 27025)
    (?$B\U(B . 27040)
    (?$B\V(B . 27036)
    (?$B\W(B . 27029)
    (?$B\X(B . 27060)
    (?$B\Y(B . 27102)
    (?$B\Z(B . 27112)
    (?$B\[(B . 27138)
    (?$B\\(B . 27163)
    (?$B\](B . 27135)
    (?$B\^(B . 27402)
    (?$B\_(B . 27129)
    (?$B\`(B . 27122)
    (?$B\a(B . 27111)
    (?$B\b(B . 27141)
    (?$B\c(B . 27057)
    (?$B\d(B . 27166)
    (?$B\e(B . 27117)
    (?$B\f(B . 27156)
    (?$B\g(B . 27115)
    (?$B\h(B . 27146)
    (?$B\i(B . 27154)
    (?$B\j(B . 27329)
    (?$B\k(B . 27171)
    (?$B\l(B . 27155)
    (?$B\m(B . 27204)
    (?$B\n(B . 27148)
    (?$B\o(B . 27250)
    (?$B\p(B . 27190)
    (?$B\q(B . 27256)
    (?$B\r(B . 27207)
    (?$B\s(B . 27234)
    (?$B\t(B . 27225)
    (?$B\u(B . 27238)
    (?$B\v(B . 27208)
    (?$B\w(B . 27192)
    (?$B\x(B . 27170)
    (?$B\y(B . 27280)
    (?$B\z(B . 27277)
    (?$B\{(B . 27296)
    (?$B\|(B . 27268)
    (?$B\}(B . 27298)
    (?$B\~(B . 27299)
    (?$B]!(B . 27287)
    (?$B]"(B . 34327)
    (?$B]#(B . 27323)
    (?$B]$(B . 27331)
    (?$B]%(B . 27330)
    (?$B]&(B . 27320)
    (?$B]'(B . 27315)
    (?$B]((B . 27308)
    (?$B])(B . 27358)
    (?$B]*(B . 27345)
    (?$B]+(B . 27359)
    (?$B],(B . 27306)
    (?$B]-(B . 27354)
    (?$B].(B . 27370)
    (?$B]/(B . 27387)
    (?$B]0(B . 27397)
    (?$B]1(B . 34326)
    (?$B]2(B . 27386)
    (?$B]3(B . 27410)
    (?$B]4(B . 27414)
    (?$B]5(B . 39729)
    (?$B]6(B . 27423)
    (?$B]7(B . 27448)
    (?$B]8(B . 27447)
    (?$B]9(B . 30428)
    (?$B]:(B . 27449)
    (?$B];(B . 39150)
    (?$B]<(B . 27463)
    (?$B]=(B . 27459)
    (?$B]>(B . 27465)
    (?$B]?(B . 27472)
    (?$B]@(B . 27481)
    (?$B]A(B . 27476)
    (?$B]B(B . 27483)
    (?$B]C(B . 27487)
    (?$B]D(B . 27489)
    (?$B]E(B . 27512)
    (?$B]F(B . 27513)
    (?$B]G(B . 27519)
    (?$B]H(B . 27520)
    (?$B]I(B . 27524)
    (?$B]J(B . 27523)
    (?$B]K(B . 27533)
    (?$B]L(B . 27544)
    (?$B]M(B . 27541)
    (?$B]N(B . 27550)
    (?$B]O(B . 27556)
    (?$B]P(B . 27562)
    (?$B]Q(B . 27563)
    (?$B]R(B . 27567)
    (?$B]S(B . 27570)
    (?$B]T(B . 27569)
    (?$B]U(B . 27571)
    (?$B]V(B . 27575)
    (?$B]W(B . 27580)
    (?$B]X(B . 27590)
    (?$B]Y(B . 27595)
    (?$B]Z(B . 27603)
    (?$B][(B . 27615)
    (?$B]\(B . 27628)
    (?$B]](B . 27627)
    (?$B]^(B . 27635)
    (?$B]_(B . 27631)
    (?$B]`(B . 40638)
    (?$B]a(B . 27656)
    (?$B]b(B . 27667)
    (?$B]c(B . 27668)
    (?$B]d(B . 27675)
    (?$B]e(B . 27684)
    (?$B]f(B . 27683)
    (?$B]g(B . 27742)
    (?$B]h(B . 27733)
    (?$B]i(B . 27746)
    (?$B]j(B . 27754)
    (?$B]k(B . 27778)
    (?$B]l(B . 27789)
    (?$B]m(B . 27802)
    (?$B]n(B . 27777)
    (?$B]o(B . 27803)
    (?$B]p(B . 27774)
    (?$B]q(B . 27752)
    (?$B]r(B . 27763)
    (?$B]s(B . 27794)
    (?$B]t(B . 27792)
    (?$B]u(B . 27844)
    (?$B]v(B . 27889)
    (?$B]w(B . 27859)
    (?$B]x(B . 27837)
    (?$B]y(B . 27863)
    (?$B]z(B . 27845)
    (?$B]{(B . 27869)
    (?$B]|(B . 27822)
    (?$B]}(B . 27825)
    (?$B]~(B . 27838)
    (?$B^!(B . 27834)
    (?$B^"(B . 27867)
    (?$B^#(B . 27887)
    (?$B^$(B . 27865)
    (?$B^%(B . 27882)
    (?$B^&(B . 27935)
    (?$B^'(B . 34893)
    (?$B^((B . 27958)
    (?$B^)(B . 27947)
    (?$B^*(B . 27965)
    (?$B^+(B . 27960)
    (?$B^,(B . 27929)
    (?$B^-(B . 27957)
    (?$B^.(B . 27955)
    (?$B^/(B . 27922)
    (?$B^0(B . 27916)
    (?$B^1(B . 28003)
    (?$B^2(B . 28051)
    (?$B^3(B . 28004)
    (?$B^4(B . 27994)
    (?$B^5(B . 28025)
    (?$B^6(B . 27993)
    (?$B^7(B . 28046)
    (?$B^8(B . 28053)
    (?$B^9(B . 28644)
    (?$B^:(B . 28037)
    (?$B^;(B . 28153)
    (?$B^<(B . 28181)
    (?$B^=(B . 28170)
    (?$B^>(B . 28085)
    (?$B^?(B . 28103)
    (?$B^@(B . 28134)
    (?$B^A(B . 28088)
    (?$B^B(B . 28102)
    (?$B^C(B . 28140)
    (?$B^D(B . 28126)
    (?$B^E(B . 28108)
    (?$B^F(B . 28136)
    (?$B^G(B . 28114)
    (?$B^H(B . 28101)
    (?$B^I(B . 28154)
    (?$B^J(B . 28121)
    (?$B^K(B . 28132)
    (?$B^L(B . 28117)
    (?$B^M(B . 28138)
    (?$B^N(B . 28142)
    (?$B^O(B . 28205)
    (?$B^P(B . 28270)
    (?$B^Q(B . 28206)
    (?$B^R(B . 28185)
    (?$B^S(B . 28274)
    (?$B^T(B . 28255)
    (?$B^U(B . 28222)
    (?$B^V(B . 28195)
    (?$B^W(B . 28267)
    (?$B^X(B . 28203)
    (?$B^Y(B . 28278)
    (?$B^Z(B . 28237)
    (?$B^[(B . 28191)
    (?$B^\(B . 28227)
    (?$B^](B . 28218)
    (?$B^^(B . 28238)
    (?$B^_(B . 28196)
    (?$B^`(B . 28415)
    (?$B^a(B . 28189)
    (?$B^b(B . 28216)
    (?$B^c(B . 28290)
    (?$B^d(B . 28330)
    (?$B^e(B . 28312)
    (?$B^f(B . 28361)
    (?$B^g(B . 28343)
    (?$B^h(B . 28371)
    (?$B^i(B . 28349)
    (?$B^j(B . 28335)
    (?$B^k(B . 28356)
    (?$B^l(B . 28338)
    (?$B^m(B . 28372)
    (?$B^n(B . 28373)
    (?$B^o(B . 28303)
    (?$B^p(B . 28325)
    (?$B^q(B . 28354)
    (?$B^r(B . 28319)
    (?$B^s(B . 28481)
    (?$B^t(B . 28433)
    (?$B^u(B . 28748)
    (?$B^v(B . 28396)
    (?$B^w(B . 28408)
    (?$B^x(B . 28414)
    (?$B^y(B . 28479)
    (?$B^z(B . 28402)
    (?$B^{(B . 28465)
    (?$B^|(B . 28399)
    (?$B^}(B . 28466)
    (?$B^~(B . 28364)
    (?$B_!(B . 28478)
    (?$B_"(B . 28435)
    (?$B_#(B . 28407)
    (?$B_$(B . 28550)
    (?$B_%(B . 28538)
    (?$B_&(B . 28536)
    (?$B_'(B . 28545)
    (?$B_((B . 28544)
    (?$B_)(B . 28527)
    (?$B_*(B . 28507)
    (?$B_+(B . 28659)
    (?$B_,(B . 28525)
    (?$B_-(B . 28546)
    (?$B_.(B . 28540)
    (?$B_/(B . 28504)
    (?$B_0(B . 28558)
    (?$B_1(B . 28561)
    (?$B_2(B . 28610)
    (?$B_3(B . 28518)
    (?$B_4(B . 28595)
    (?$B_5(B . 28579)
    (?$B_6(B . 28577)
    (?$B_7(B . 28580)
    (?$B_8(B . 28601)
    (?$B_9(B . 28614)
    (?$B_:(B . 28586)
    (?$B_;(B . 28639)
    (?$B_<(B . 28629)
    (?$B_=(B . 28652)
    (?$B_>(B . 28628)
    (?$B_?(B . 28632)
    (?$B_@(B . 28657)
    (?$B_A(B . 28654)
    (?$B_B(B . 28635)
    (?$B_C(B . 28681)
    (?$B_D(B . 28683)
    (?$B_E(B . 28666)
    (?$B_F(B . 28689)
    (?$B_G(B . 28673)
    (?$B_H(B . 28687)
    (?$B_I(B . 28670)
    (?$B_J(B . 28699)
    (?$B_K(B . 28698)
    (?$B_L(B . 28532)
    (?$B_M(B . 28701)
    (?$B_N(B . 28696)
    (?$B_O(B . 28703)
    (?$B_P(B . 28720)
    (?$B_Q(B . 28734)
    (?$B_R(B . 28722)
    (?$B_S(B . 28753)
    (?$B_T(B . 28771)
    (?$B_U(B . 28825)
    (?$B_V(B . 28818)
    (?$B_W(B . 28847)
    (?$B_X(B . 28913)
    (?$B_Y(B . 28844)
    (?$B_Z(B . 28856)
    (?$B_[(B . 28851)
    (?$B_\(B . 28846)
    (?$B_](B . 28895)
    (?$B_^(B . 28875)
    (?$B__(B . 28893)
    (?$B_`(B . 28889)
    (?$B_a(B . 28937)
    (?$B_b(B . 28925)
    (?$B_c(B . 28956)
    (?$B_d(B . 28953)
    (?$B_e(B . 29029)
    (?$B_f(B . 29013)
    (?$B_g(B . 29064)
    (?$B_h(B . 29030)
    (?$B_i(B . 29026)
    (?$B_j(B . 29004)
    (?$B_k(B . 29014)
    (?$B_l(B . 29036)
    (?$B_m(B . 29071)
    (?$B_n(B . 29179)
    (?$B_o(B . 29060)
    (?$B_p(B . 29077)
    (?$B_q(B . 29096)
    (?$B_r(B . 29100)
    (?$B_s(B . 29143)
    (?$B_t(B . 29113)
    (?$B_u(B . 29118)
    (?$B_v(B . 29138)
    (?$B_w(B . 29129)
    (?$B_x(B . 29140)
    (?$B_y(B . 29134)
    (?$B_z(B . 29152)
    (?$B_{(B . 29164)
    (?$B_|(B . 29159)
    (?$B_}(B . 29173)
    (?$B_~(B . 29180)
    (?$B`!(B . 29177)
    (?$B`"(B . 29183)
    (?$B`#(B . 29197)
    (?$B`$(B . 29200)
    (?$B`%(B . 29211)
    (?$B`&(B . 29224)
    (?$B`'(B . 29229)
    (?$B`((B . 29228)
    (?$B`)(B . 29232)
    (?$B`*(B . 29234)
    (?$B`+(B . 29243)
    (?$B`,(B . 29244)
    (?$B`-(B . 29247)
    (?$B`.(B . 29248)
    (?$B`/(B . 29254)
    (?$B`0(B . 29259)
    (?$B`1(B . 29272)
    (?$B`2(B . 29300)
    (?$B`3(B . 29310)
    (?$B`4(B . 29314)
    (?$B`5(B . 29313)
    (?$B`6(B . 29319)
    (?$B`7(B . 29330)
    (?$B`8(B . 29334)
    (?$B`9(B . 29346)
    (?$B`:(B . 29351)
    (?$B`;(B . 29369)
    (?$B`<(B . 29362)
    (?$B`=(B . 29379)
    (?$B`>(B . 29382)
    (?$B`?(B . 29380)
    (?$B`@(B . 29390)
    (?$B`A(B . 29394)
    (?$B`B(B . 29410)
    (?$B`C(B . 29408)
    (?$B`D(B . 29409)
    (?$B`E(B . 29433)
    (?$B`F(B . 29431)
    (?$B`G(B . 20495)
    (?$B`H(B . 29463)
    (?$B`I(B . 29450)
    (?$B`J(B . 29468)
    (?$B`K(B . 29462)
    (?$B`L(B . 29469)
    (?$B`M(B . 29492)
    (?$B`N(B . 29487)
    (?$B`O(B . 29481)
    (?$B`P(B . 29477)
    (?$B`Q(B . 29502)
    (?$B`R(B . 29518)
    (?$B`S(B . 29519)
    (?$B`T(B . 40664)
    (?$B`U(B . 29527)
    (?$B`V(B . 29546)
    (?$B`W(B . 29544)
    (?$B`X(B . 29552)
    (?$B`Y(B . 29560)
    (?$B`Z(B . 29557)
    (?$B`[(B . 29563)
    (?$B`\(B . 29562)
    (?$B`](B . 29640)
    (?$B`^(B . 29619)
    (?$B`_(B . 29646)
    (?$B``(B . 29627)
    (?$B`a(B . 29632)
    (?$B`b(B . 29669)
    (?$B`c(B . 29678)
    (?$B`d(B . 29662)
    (?$B`e(B . 29858)
    (?$B`f(B . 29701)
    (?$B`g(B . 29807)
    (?$B`h(B . 29733)
    (?$B`i(B . 29688)
    (?$B`j(B . 29746)
    (?$B`k(B . 29754)
    (?$B`l(B . 29781)
    (?$B`m(B . 29759)
    (?$B`n(B . 29791)
    (?$B`o(B . 29785)
    (?$B`p(B . 29761)
    (?$B`q(B . 29788)
    (?$B`r(B . 29801)
    (?$B`s(B . 29808)
    (?$B`t(B . 29795)
    (?$B`u(B . 29802)
    (?$B`v(B . 29814)
    (?$B`w(B . 29822)
    (?$B`x(B . 29835)
    (?$B`y(B . 29854)
    (?$B`z(B . 29863)
    (?$B`{(B . 29898)
    (?$B`|(B . 29903)
    (?$B`}(B . 29908)
    (?$B`~(B . 29681)
    (?$Ba!(B . 29920)
    (?$Ba"(B . 29923)
    (?$Ba#(B . 29927)
    (?$Ba$(B . 29929)
    (?$Ba%(B . 29934)
    (?$Ba&(B . 29938)
    (?$Ba'(B . 29936)
    (?$Ba((B . 29937)
    (?$Ba)(B . 29944)
    (?$Ba*(B . 29943)
    (?$Ba+(B . 29956)
    (?$Ba,(B . 29955)
    (?$Ba-(B . 29957)
    (?$Ba.(B . 29964)
    (?$Ba/(B . 29966)
    (?$Ba0(B . 29965)
    (?$Ba1(B . 29973)
    (?$Ba2(B . 29971)
    (?$Ba3(B . 29982)
    (?$Ba4(B . 29990)
    (?$Ba5(B . 29996)
    (?$Ba6(B . 30012)
    (?$Ba7(B . 30020)
    (?$Ba8(B . 30029)
    (?$Ba9(B . 30026)
    (?$Ba:(B . 30025)
    (?$Ba;(B . 30043)
    (?$Ba<(B . 30022)
    (?$Ba=(B . 30042)
    (?$Ba>(B . 30057)
    (?$Ba?(B . 30052)
    (?$Ba@(B . 30055)
    (?$BaA(B . 30059)
    (?$BaB(B . 30061)
    (?$BaC(B . 30072)
    (?$BaD(B . 30070)
    (?$BaE(B . 30086)
    (?$BaF(B . 30087)
    (?$BaG(B . 30068)
    (?$BaH(B . 30090)
    (?$BaI(B . 30089)
    (?$BaJ(B . 30082)
    (?$BaK(B . 30100)
    (?$BaL(B . 30106)
    (?$BaM(B . 30109)
    (?$BaN(B . 30117)
    (?$BaO(B . 30115)
    (?$BaP(B . 30146)
    (?$BaQ(B . 30131)
    (?$BaR(B . 30147)
    (?$BaS(B . 30133)
    (?$BaT(B . 30141)
    (?$BaU(B . 30136)
    (?$BaV(B . 30140)
    (?$BaW(B . 30129)
    (?$BaX(B . 30157)
    (?$BaY(B . 30154)
    (?$BaZ(B . 30162)
    (?$Ba[(B . 30169)
    (?$Ba\(B . 30179)
    (?$Ba](B . 30174)
    (?$Ba^(B . 30206)
    (?$Ba_(B . 30207)
    (?$Ba`(B . 30204)
    (?$Baa(B . 30209)
    (?$Bab(B . 30192)
    (?$Bac(B . 30202)
    (?$Bad(B . 30194)
    (?$Bae(B . 30195)
    (?$Baf(B . 30219)
    (?$Bag(B . 30221)
    (?$Bah(B . 30217)
    (?$Bai(B . 30239)
    (?$Baj(B . 30247)
    (?$Bak(B . 30240)
    (?$Bal(B . 30241)
    (?$Bam(B . 30242)
    (?$Ban(B . 30244)
    (?$Bao(B . 30260)
    (?$Bap(B . 30256)
    (?$Baq(B . 30267)
    (?$Bar(B . 30279)
    (?$Bas(B . 30280)
    (?$Bat(B . 30278)
    (?$Bau(B . 30300)
    (?$Bav(B . 30296)
    (?$Baw(B . 30305)
    (?$Bax(B . 30306)
    (?$Bay(B . 30312)
    (?$Baz(B . 30313)
    (?$Ba{(B . 30314)
    (?$Ba|(B . 30311)
    (?$Ba}(B . 30316)
    (?$Ba~(B . 30320)
    (?$Bb!(B . 30322)
    (?$Bb"(B . 30326)
    (?$Bb#(B . 30328)
    (?$Bb$(B . 30332)
    (?$Bb%(B . 30336)
    (?$Bb&(B . 30339)
    (?$Bb'(B . 30344)
    (?$Bb((B . 30347)
    (?$Bb)(B . 30350)
    (?$Bb*(B . 30358)
    (?$Bb+(B . 30355)
    (?$Bb,(B . 30361)
    (?$Bb-(B . 30362)
    (?$Bb.(B . 30384)
    (?$Bb/(B . 30388)
    (?$Bb0(B . 30392)
    (?$Bb1(B . 30393)
    (?$Bb2(B . 30394)
    (?$Bb3(B . 30402)
    (?$Bb4(B . 30413)
    (?$Bb5(B . 30422)
    (?$Bb6(B . 30418)
    (?$Bb7(B . 30430)
    (?$Bb8(B . 30433)
    (?$Bb9(B . 30437)
    (?$Bb:(B . 30439)
    (?$Bb;(B . 30442)
    (?$Bb<(B . 34351)
    (?$Bb=(B . 30459)
    (?$Bb>(B . 30472)
    (?$Bb?(B . 30471)
    (?$Bb@(B . 30468)
    (?$BbA(B . 30505)
    (?$BbB(B . 30500)
    (?$BbC(B . 30494)
    (?$BbD(B . 30501)
    (?$BbE(B . 30502)
    (?$BbF(B . 30491)
    (?$BbG(B . 30519)
    (?$BbH(B . 30520)
    (?$BbI(B . 30535)
    (?$BbJ(B . 30554)
    (?$BbK(B . 30568)
    (?$BbL(B . 30571)
    (?$BbM(B . 30555)
    (?$BbN(B . 30565)
    (?$BbO(B . 30591)
    (?$BbP(B . 30590)
    (?$BbQ(B . 30585)
    (?$BbR(B . 30606)
    (?$BbS(B . 30603)
    (?$BbT(B . 30609)
    (?$BbU(B . 30624)
    (?$BbV(B . 30622)
    (?$BbW(B . 30640)
    (?$BbX(B . 30646)
    (?$BbY(B . 30649)
    (?$BbZ(B . 30655)
    (?$Bb[(B . 30652)
    (?$Bb\(B . 30653)
    (?$Bb](B . 30651)
    (?$Bb^(B . 30663)
    (?$Bb_(B . 30669)
    (?$Bb`(B . 30679)
    (?$Bba(B . 30682)
    (?$Bbb(B . 30684)
    (?$Bbc(B . 30691)
    (?$Bbd(B . 30702)
    (?$Bbe(B . 30716)
    (?$Bbf(B . 30732)
    (?$Bbg(B . 30738)
    (?$Bbh(B . 31014)
    (?$Bbi(B . 30752)
    (?$Bbj(B . 31018)
    (?$Bbk(B . 30789)
    (?$Bbl(B . 30862)
    (?$Bbm(B . 30836)
    (?$Bbn(B . 30854)
    (?$Bbo(B . 30844)
    (?$Bbp(B . 30874)
    (?$Bbq(B . 30860)
    (?$Bbr(B . 30883)
    (?$Bbs(B . 30901)
    (?$Bbt(B . 30890)
    (?$Bbu(B . 30895)
    (?$Bbv(B . 30929)
    (?$Bbw(B . 30918)
    (?$Bbx(B . 30923)
    (?$Bby(B . 30932)
    (?$Bbz(B . 30910)
    (?$Bb{(B . 30908)
    (?$Bb|(B . 30917)
    (?$Bb}(B . 30922)
    (?$Bb~(B . 30956)
    (?$Bc!(B . 30951)
    (?$Bc"(B . 30938)
    (?$Bc#(B . 30973)
    (?$Bc$(B . 30964)
    (?$Bc%(B . 30983)
    (?$Bc&(B . 30994)
    (?$Bc'(B . 30993)
    (?$Bc((B . 31001)
    (?$Bc)(B . 31020)
    (?$Bc*(B . 31019)
    (?$Bc+(B . 31040)
    (?$Bc,(B . 31072)
    (?$Bc-(B . 31063)
    (?$Bc.(B . 31071)
    (?$Bc/(B . 31066)
    (?$Bc0(B . 31061)
    (?$Bc1(B . 31059)
    (?$Bc2(B . 31098)
    (?$Bc3(B . 31103)
    (?$Bc4(B . 31114)
    (?$Bc5(B . 31133)
    (?$Bc6(B . 31143)
    (?$Bc7(B . 40779)
    (?$Bc8(B . 31146)
    (?$Bc9(B . 31150)
    (?$Bc:(B . 31155)
    (?$Bc;(B . 31161)
    (?$Bc<(B . 31162)
    (?$Bc=(B . 31177)
    (?$Bc>(B . 31189)
    (?$Bc?(B . 31207)
    (?$Bc@(B . 31212)
    (?$BcA(B . 31201)
    (?$BcB(B . 31203)
    (?$BcC(B . 31240)
    (?$BcD(B . 31245)
    (?$BcE(B . 31256)
    (?$BcF(B . 31257)
    (?$BcG(B . 31264)
    (?$BcH(B . 31263)
    (?$BcI(B . 31104)
    (?$BcJ(B . 31281)
    (?$BcK(B . 31291)
    (?$BcL(B . 31294)
    (?$BcM(B . 31287)
    (?$BcN(B . 31299)
    (?$BcO(B . 31319)
    (?$BcP(B . 31305)
    (?$BcQ(B . 31329)
    (?$BcR(B . 31330)
    (?$BcS(B . 31337)
    (?$BcT(B . 40861)
    (?$BcU(B . 31344)
    (?$BcV(B . 31353)
    (?$BcW(B . 31357)
    (?$BcX(B . 31368)
    (?$BcY(B . 31383)
    (?$BcZ(B . 31381)
    (?$Bc[(B . 31384)
    (?$Bc\(B . 31382)
    (?$Bc](B . 31401)
    (?$Bc^(B . 31432)
    (?$Bc_(B . 31408)
    (?$Bc`(B . 31414)
    (?$Bca(B . 31429)
    (?$Bcb(B . 31428)
    (?$Bcc(B . 31423)
    (?$Bcd(B . 36995)
    (?$Bce(B . 31431)
    (?$Bcf(B . 31434)
    (?$Bcg(B . 31437)
    (?$Bch(B . 31439)
    (?$Bci(B . 31445)
    (?$Bcj(B . 31443)
    (?$Bck(B . 31449)
    (?$Bcl(B . 31450)
    (?$Bcm(B . 31453)
    (?$Bcn(B . 31457)
    (?$Bco(B . 31458)
    (?$Bcp(B . 31462)
    (?$Bcq(B . 31469)
    (?$Bcr(B . 31472)
    (?$Bcs(B . 31490)
    (?$Bct(B . 31503)
    (?$Bcu(B . 31498)
    (?$Bcv(B . 31494)
    (?$Bcw(B . 31539)
    (?$Bcx(B . 31512)
    (?$Bcy(B . 31513)
    (?$Bcz(B . 31518)
    (?$Bc{(B . 31541)
    (?$Bc|(B . 31528)
    (?$Bc}(B . 31542)
    (?$Bc~(B . 31568)
    (?$Bd!(B . 31610)
    (?$Bd"(B . 31492)
    (?$Bd#(B . 31565)
    (?$Bd$(B . 31499)
    (?$Bd%(B . 31564)
    (?$Bd&(B . 31557)
    (?$Bd'(B . 31605)
    (?$Bd((B . 31589)
    (?$Bd)(B . 31604)
    (?$Bd*(B . 31591)
    (?$Bd+(B . 31600)
    (?$Bd,(B . 31601)
    (?$Bd-(B . 31596)
    (?$Bd.(B . 31598)
    (?$Bd/(B . 31645)
    (?$Bd0(B . 31640)
    (?$Bd1(B . 31647)
    (?$Bd2(B . 31629)
    (?$Bd3(B . 31644)
    (?$Bd4(B . 31642)
    (?$Bd5(B . 31627)
    (?$Bd6(B . 31634)
    (?$Bd7(B . 31631)
    (?$Bd8(B . 31581)
    (?$Bd9(B . 31641)
    (?$Bd:(B . 31691)
    (?$Bd;(B . 31681)
    (?$Bd<(B . 31692)
    (?$Bd=(B . 31695)
    (?$Bd>(B . 31668)
    (?$Bd?(B . 31686)
    (?$Bd@(B . 31709)
    (?$BdA(B . 31721)
    (?$BdB(B . 31761)
    (?$BdC(B . 31764)
    (?$BdD(B . 31718)
    (?$BdE(B . 31717)
    (?$BdF(B . 31840)
    (?$BdG(B . 31744)
    (?$BdH(B . 31751)
    (?$BdI(B . 31763)
    (?$BdJ(B . 31731)
    (?$BdK(B . 31735)
    (?$BdL(B . 31767)
    (?$BdM(B . 31757)
    (?$BdN(B . 31734)
    (?$BdO(B . 31779)
    (?$BdP(B . 31783)
    (?$BdQ(B . 31786)
    (?$BdR(B . 31775)
    (?$BdS(B . 31799)
    (?$BdT(B . 31787)
    (?$BdU(B . 31805)
    (?$BdV(B . 31820)
    (?$BdW(B . 31811)
    (?$BdX(B . 31828)
    (?$BdY(B . 31823)
    (?$BdZ(B . 31808)
    (?$Bd[(B . 31824)
    (?$Bd\(B . 31832)
    (?$Bd](B . 31839)
    (?$Bd^(B . 31844)
    (?$Bd_(B . 31830)
    (?$Bd`(B . 31845)
    (?$Bda(B . 31852)
    (?$Bdb(B . 31861)
    (?$Bdc(B . 31875)
    (?$Bdd(B . 31888)
    (?$Bde(B . 31908)
    (?$Bdf(B . 31917)
    (?$Bdg(B . 31906)
    (?$Bdh(B . 31915)
    (?$Bdi(B . 31905)
    (?$Bdj(B . 31912)
    (?$Bdk(B . 31923)
    (?$Bdl(B . 31922)
    (?$Bdm(B . 31921)
    (?$Bdn(B . 31918)
    (?$Bdo(B . 31929)
    (?$Bdp(B . 31933)
    (?$Bdq(B . 31936)
    (?$Bdr(B . 31941)
    (?$Bds(B . 31938)
    (?$Bdt(B . 31960)
    (?$Bdu(B . 31954)
    (?$Bdv(B . 31964)
    (?$Bdw(B . 31970)
    (?$Bdx(B . 39739)
    (?$Bdy(B . 31983)
    (?$Bdz(B . 31986)
    (?$Bd{(B . 31988)
    (?$Bd|(B . 31990)
    (?$Bd}(B . 31994)
    (?$Bd~(B . 32006)
    (?$Be!(B . 32002)
    (?$Be"(B . 32028)
    (?$Be#(B . 32021)
    (?$Be$(B . 32010)
    (?$Be%(B . 32069)
    (?$Be&(B . 32075)
    (?$Be'(B . 32046)
    (?$Be((B . 32050)
    (?$Be)(B . 32063)
    (?$Be*(B . 32053)
    (?$Be+(B . 32070)
    (?$Be,(B . 32115)
    (?$Be-(B . 32086)
    (?$Be.(B . 32078)
    (?$Be/(B . 32114)
    (?$Be0(B . 32104)
    (?$Be1(B . 32110)
    (?$Be2(B . 32079)
    (?$Be3(B . 32099)
    (?$Be4(B . 32147)
    (?$Be5(B . 32137)
    (?$Be6(B . 32091)
    (?$Be7(B . 32143)
    (?$Be8(B . 32125)
    (?$Be9(B . 32155)
    (?$Be:(B . 32186)
    (?$Be;(B . 32174)
    (?$Be<(B . 32163)
    (?$Be=(B . 32181)
    (?$Be>(B . 32199)
    (?$Be?(B . 32189)
    (?$Be@(B . 32171)
    (?$BeA(B . 32317)
    (?$BeB(B . 32162)
    (?$BeC(B . 32175)
    (?$BeD(B . 32220)
    (?$BeE(B . 32184)
    (?$BeF(B . 32159)
    (?$BeG(B . 32176)
    (?$BeH(B . 32216)
    (?$BeI(B . 32221)
    (?$BeJ(B . 32228)
    (?$BeK(B . 32222)
    (?$BeL(B . 32251)
    (?$BeM(B . 32242)
    (?$BeN(B . 32225)
    (?$BeO(B . 32261)
    (?$BeP(B . 32266)
    (?$BeQ(B . 32291)
    (?$BeR(B . 32289)
    (?$BeS(B . 32274)
    (?$BeT(B . 32305)
    (?$BeU(B . 32287)
    (?$BeV(B . 32265)
    (?$BeW(B . 32267)
    (?$BeX(B . 32290)
    (?$BeY(B . 32326)
    (?$BeZ(B . 32358)
    (?$Be[(B . 32315)
    (?$Be\(B . 32309)
    (?$Be](B . 32313)
    (?$Be^(B . 32323)
    (?$Be_(B . 32311)
    (?$Be`(B . 32306)
    (?$Bea(B . 32314)
    (?$Beb(B . 32359)
    (?$Bec(B . 32349)
    (?$Bed(B . 32342)
    (?$Bee(B . 32350)
    (?$Bef(B . 32345)
    (?$Beg(B . 32346)
    (?$Beh(B . 32377)
    (?$Bei(B . 32362)
    (?$Bej(B . 32361)
    (?$Bek(B . 32380)
    (?$Bel(B . 32379)
    (?$Bem(B . 32387)
    (?$Ben(B . 32213)
    (?$Beo(B . 32381)
    (?$Bep(B . 36782)
    (?$Beq(B . 32383)
    (?$Ber(B . 32392)
    (?$Bes(B . 32393)
    (?$Bet(B . 32396)
    (?$Beu(B . 32402)
    (?$Bev(B . 32400)
    (?$Bew(B . 32403)
    (?$Bex(B . 32404)
    (?$Bey(B . 32406)
    (?$Bez(B . 32398)
    (?$Be{(B . 32411)
    (?$Be|(B . 32412)
    (?$Be}(B . 32568)
    (?$Be~(B . 32570)
    (?$Bf!(B . 32581)
    (?$Bf"(B . 32588)
    (?$Bf#(B . 32589)
    (?$Bf$(B . 32590)
    (?$Bf%(B . 32592)
    (?$Bf&(B . 32593)
    (?$Bf'(B . 32597)
    (?$Bf((B . 32596)
    (?$Bf)(B . 32600)
    (?$Bf*(B . 32607)
    (?$Bf+(B . 32608)
    (?$Bf,(B . 32616)
    (?$Bf-(B . 32617)
    (?$Bf.(B . 32615)
    (?$Bf/(B . 32632)
    (?$Bf0(B . 32642)
    (?$Bf1(B . 32646)
    (?$Bf2(B . 32643)
    (?$Bf3(B . 32648)
    (?$Bf4(B . 32647)
    (?$Bf5(B . 32652)
    (?$Bf6(B . 32660)
    (?$Bf7(B . 32670)
    (?$Bf8(B . 32669)
    (?$Bf9(B . 32666)
    (?$Bf:(B . 32675)
    (?$Bf;(B . 32687)
    (?$Bf<(B . 32690)
    (?$Bf=(B . 32697)
    (?$Bf>(B . 32686)
    (?$Bf?(B . 32694)
    (?$Bf@(B . 32696)
    (?$BfA(B . 35697)
    (?$BfB(B . 32709)
    (?$BfC(B . 32710)
    (?$BfD(B . 32714)
    (?$BfE(B . 32725)
    (?$BfF(B . 32724)
    (?$BfG(B . 32737)
    (?$BfH(B . 32742)
    (?$BfI(B . 32745)
    (?$BfJ(B . 32755)
    (?$BfK(B . 32761)
    (?$BfL(B . 39132)
    (?$BfM(B . 32774)
    (?$BfN(B . 32772)
    (?$BfO(B . 32779)
    (?$BfP(B . 32786)
    (?$BfQ(B . 32792)
    (?$BfR(B . 32793)
    (?$BfS(B . 32796)
    (?$BfT(B . 32801)
    (?$BfU(B . 32808)
    (?$BfV(B . 32831)
    (?$BfW(B . 32827)
    (?$BfX(B . 32842)
    (?$BfY(B . 32838)
    (?$BfZ(B . 32850)
    (?$Bf[(B . 32856)
    (?$Bf\(B . 32858)
    (?$Bf](B . 32863)
    (?$Bf^(B . 32866)
    (?$Bf_(B . 32872)
    (?$Bf`(B . 32883)
    (?$Bfa(B . 32882)
    (?$Bfb(B . 32880)
    (?$Bfc(B . 32886)
    (?$Bfd(B . 32889)
    (?$Bfe(B . 32893)
    (?$Bff(B . 32895)
    (?$Bfg(B . 32900)
    (?$Bfh(B . 32902)
    (?$Bfi(B . 32901)
    (?$Bfj(B . 32923)
    (?$Bfk(B . 32915)
    (?$Bfl(B . 32922)
    (?$Bfm(B . 32941)
    (?$Bfn(B . 20880)
    (?$Bfo(B . 32940)
    (?$Bfp(B . 32987)
    (?$Bfq(B . 32997)
    (?$Bfr(B . 32985)
    (?$Bfs(B . 32989)
    (?$Bft(B . 32964)
    (?$Bfu(B . 32986)
    (?$Bfv(B . 32982)
    (?$Bfw(B . 33033)
    (?$Bfx(B . 33007)
    (?$Bfy(B . 33009)
    (?$Bfz(B . 33051)
    (?$Bf{(B . 33065)
    (?$Bf|(B . 33059)
    (?$Bf}(B . 33071)
    (?$Bf~(B . 33099)
    (?$Bg!(B . 38539)
    (?$Bg"(B . 33094)
    (?$Bg#(B . 33086)
    (?$Bg$(B . 33107)
    (?$Bg%(B . 33105)
    (?$Bg&(B . 33020)
    (?$Bg'(B . 33137)
    (?$Bg((B . 33134)
    (?$Bg)(B . 33125)
    (?$Bg*(B . 33126)
    (?$Bg+(B . 33140)
    (?$Bg,(B . 33155)
    (?$Bg-(B . 33160)
    (?$Bg.(B . 33162)
    (?$Bg/(B . 33152)
    (?$Bg0(B . 33154)
    (?$Bg1(B . 33184)
    (?$Bg2(B . 33173)
    (?$Bg3(B . 33188)
    (?$Bg4(B . 33187)
    (?$Bg5(B . 33119)
    (?$Bg6(B . 33171)
    (?$Bg7(B . 33193)
    (?$Bg8(B . 33200)
    (?$Bg9(B . 33205)
    (?$Bg:(B . 33214)
    (?$Bg;(B . 33208)
    (?$Bg<(B . 33213)
    (?$Bg=(B . 33216)
    (?$Bg>(B . 33218)
    (?$Bg?(B . 33210)
    (?$Bg@(B . 33225)
    (?$BgA(B . 33229)
    (?$BgB(B . 33233)
    (?$BgC(B . 33241)
    (?$BgD(B . 33240)
    (?$BgE(B . 33224)
    (?$BgF(B . 33242)
    (?$BgG(B . 33247)
    (?$BgH(B . 33248)
    (?$BgI(B . 33255)
    (?$BgJ(B . 33274)
    (?$BgK(B . 33275)
    (?$BgL(B . 33278)
    (?$BgM(B . 33281)
    (?$BgN(B . 33282)
    (?$BgO(B . 33285)
    (?$BgP(B . 33287)
    (?$BgQ(B . 33290)
    (?$BgR(B . 33293)
    (?$BgS(B . 33296)
    (?$BgT(B . 33302)
    (?$BgU(B . 33321)
    (?$BgV(B . 33323)
    (?$BgW(B . 33336)
    (?$BgX(B . 33331)
    (?$BgY(B . 33344)
    (?$BgZ(B . 33369)
    (?$Bg[(B . 33368)
    (?$Bg\(B . 33373)
    (?$Bg](B . 33370)
    (?$Bg^(B . 33375)
    (?$Bg_(B . 33380)
    (?$Bg`(B . 33378)
    (?$Bga(B . 33384)
    (?$Bgb(B . 33386)
    (?$Bgc(B . 33387)
    (?$Bgd(B . 33326)
    (?$Bge(B . 33393)
    (?$Bgf(B . 33399)
    (?$Bgg(B . 33400)
    (?$Bgh(B . 33406)
    (?$Bgi(B . 33421)
    (?$Bgj(B . 33426)
    (?$Bgk(B . 33451)
    (?$Bgl(B . 33439)
    (?$Bgm(B . 33467)
    (?$Bgn(B . 33452)
    (?$Bgo(B . 33505)
    (?$Bgp(B . 33507)
    (?$Bgq(B . 33503)
    (?$Bgr(B . 33490)
    (?$Bgs(B . 33524)
    (?$Bgt(B . 33523)
    (?$Bgu(B . 33530)
    (?$Bgv(B . 33683)
    (?$Bgw(B . 33539)
    (?$Bgx(B . 33531)
    (?$Bgy(B . 33529)
    (?$Bgz(B . 33502)
    (?$Bg{(B . 33542)
    (?$Bg|(B . 33500)
    (?$Bg}(B . 33545)
    (?$Bg~(B . 33497)
    (?$Bh!(B . 33589)
    (?$Bh"(B . 33588)
    (?$Bh#(B . 33558)
    (?$Bh$(B . 33586)
    (?$Bh%(B . 33585)
    (?$Bh&(B . 33600)
    (?$Bh'(B . 33593)
    (?$Bh((B . 33616)
    (?$Bh)(B . 33605)
    (?$Bh*(B . 33583)
    (?$Bh+(B . 33579)
    (?$Bh,(B . 33559)
    (?$Bh-(B . 33560)
    (?$Bh.(B . 33669)
    (?$Bh/(B . 33690)
    (?$Bh0(B . 33706)
    (?$Bh1(B . 33695)
    (?$Bh2(B . 33698)
    (?$Bh3(B . 33686)
    (?$Bh4(B . 33571)
    (?$Bh5(B . 33678)
    (?$Bh6(B . 33671)
    (?$Bh7(B . 33674)
    (?$Bh8(B . 33660)
    (?$Bh9(B . 33717)
    (?$Bh:(B . 33651)
    (?$Bh;(B . 33653)
    (?$Bh<(B . 33696)
    (?$Bh=(B . 33673)
    (?$Bh>(B . 33704)
    (?$Bh?(B . 33780)
    (?$Bh@(B . 33811)
    (?$BhA(B . 33771)
    (?$BhB(B . 33742)
    (?$BhC(B . 33789)
    (?$BhD(B . 33795)
    (?$BhE(B . 33752)
    (?$BhF(B . 33803)
    (?$BhG(B . 33729)
    (?$BhH(B . 33783)
    (?$BhI(B . 33799)
    (?$BhJ(B . 33760)
    (?$BhK(B . 33778)
    (?$BhL(B . 33805)
    (?$BhM(B . 33826)
    (?$BhN(B . 33824)
    (?$BhO(B . 33725)
    (?$BhP(B . 33848)
    (?$BhQ(B . 34054)
    (?$BhR(B . 33787)
    (?$BhS(B . 33901)
    (?$BhT(B . 33834)
    (?$BhU(B . 33852)
    (?$BhV(B . 34138)
    (?$BhW(B . 33924)
    (?$BhX(B . 33911)
    (?$BhY(B . 33899)
    (?$BhZ(B . 33965)
    (?$Bh[(B . 33902)
    (?$Bh\(B . 33922)
    (?$Bh](B . 33897)
    (?$Bh^(B . 33862)
    (?$Bh_(B . 33836)
    (?$Bh`(B . 33903)
    (?$Bha(B . 33913)
    (?$Bhb(B . 33845)
    (?$Bhc(B . 33994)
    (?$Bhd(B . 33890)
    (?$Bhe(B . 33977)
    (?$Bhf(B . 33983)
    (?$Bhg(B . 33951)
    (?$Bhh(B . 34009)
    (?$Bhi(B . 33997)
    (?$Bhj(B . 33979)
    (?$Bhk(B . 34010)
    (?$Bhl(B . 34000)
    (?$Bhm(B . 33985)
    (?$Bhn(B . 33990)
    (?$Bho(B . 34006)
    (?$Bhp(B . 33953)
    (?$Bhq(B . 34081)
    (?$Bhr(B . 34047)
    (?$Bhs(B . 34036)
    (?$Bht(B . 34071)
    (?$Bhu(B . 34072)
    (?$Bhv(B . 34092)
    (?$Bhw(B . 34079)
    (?$Bhx(B . 34069)
    (?$Bhy(B . 34068)
    (?$Bhz(B . 34044)
    (?$Bh{(B . 34112)
    (?$Bh|(B . 34147)
    (?$Bh}(B . 34136)
    (?$Bh~(B . 34120)
    (?$Bi!(B . 34113)
    (?$Bi"(B . 34306)
    (?$Bi#(B . 34123)
    (?$Bi$(B . 34133)
    (?$Bi%(B . 34176)
    (?$Bi&(B . 34212)
    (?$Bi'(B . 34184)
    (?$Bi((B . 34193)
    (?$Bi)(B . 34186)
    (?$Bi*(B . 34216)
    (?$Bi+(B . 34157)
    (?$Bi,(B . 34196)
    (?$Bi-(B . 34203)
    (?$Bi.(B . 34282)
    (?$Bi/(B . 34183)
    (?$Bi0(B . 34204)
    (?$Bi1(B . 34167)
    (?$Bi2(B . 34174)
    (?$Bi3(B . 34192)
    (?$Bi4(B . 34249)
    (?$Bi5(B . 34234)
    (?$Bi6(B . 34255)
    (?$Bi7(B . 34233)
    (?$Bi8(B . 34256)
    (?$Bi9(B . 34261)
    (?$Bi:(B . 34269)
    (?$Bi;(B . 34277)
    (?$Bi<(B . 34268)
    (?$Bi=(B . 34297)
    (?$Bi>(B . 34314)
    (?$Bi?(B . 34323)
    (?$Bi@(B . 34315)
    (?$BiA(B . 34302)
    (?$BiB(B . 34298)
    (?$BiC(B . 34310)
    (?$BiD(B . 34338)
    (?$BiE(B . 34330)
    (?$BiF(B . 34352)
    (?$BiG(B . 34367)
    (?$BiH(B . 34381)
    (?$BiI(B . 20053)
    (?$BiJ(B . 34388)
    (?$BiK(B . 34399)
    (?$BiL(B . 34407)
    (?$BiM(B . 34417)
    (?$BiN(B . 34451)
    (?$BiO(B . 34467)
    (?$BiP(B . 34473)
    (?$BiQ(B . 34474)
    (?$BiR(B . 34443)
    (?$BiS(B . 34444)
    (?$BiT(B . 34486)
    (?$BiU(B . 34479)
    (?$BiV(B . 34500)
    (?$BiW(B . 34502)
    (?$BiX(B . 34480)
    (?$BiY(B . 34505)
    (?$BiZ(B . 34851)
    (?$Bi[(B . 34475)
    (?$Bi\(B . 34516)
    (?$Bi](B . 34526)
    (?$Bi^(B . 34537)
    (?$Bi_(B . 34540)
    (?$Bi`(B . 34527)
    (?$Bia(B . 34523)
    (?$Bib(B . 34543)
    (?$Bic(B . 34578)
    (?$Bid(B . 34566)
    (?$Bie(B . 34568)
    (?$Bif(B . 34560)
    (?$Big(B . 34563)
    (?$Bih(B . 34555)
    (?$Bii(B . 34577)
    (?$Bij(B . 34569)
    (?$Bik(B . 34573)
    (?$Bil(B . 34553)
    (?$Bim(B . 34570)
    (?$Bin(B . 34612)
    (?$Bio(B . 34623)
    (?$Bip(B . 34615)
    (?$Biq(B . 34619)
    (?$Bir(B . 34597)
    (?$Bis(B . 34601)
    (?$Bit(B . 34586)
    (?$Biu(B . 34656)
    (?$Biv(B . 34655)
    (?$Biw(B . 34680)
    (?$Bix(B . 34636)
    (?$Biy(B . 34638)
    (?$Biz(B . 34676)
    (?$Bi{(B . 34647)
    (?$Bi|(B . 34664)
    (?$Bi}(B . 34670)
    (?$Bi~(B . 34649)
    (?$Bj!(B . 34643)
    (?$Bj"(B . 34659)
    (?$Bj#(B . 34666)
    (?$Bj$(B . 34821)
    (?$Bj%(B . 34722)
    (?$Bj&(B . 34719)
    (?$Bj'(B . 34690)
    (?$Bj((B . 34735)
    (?$Bj)(B . 34763)
    (?$Bj*(B . 34749)
    (?$Bj+(B . 34752)
    (?$Bj,(B . 34768)
    (?$Bj-(B . 38614)
    (?$Bj.(B . 34731)
    (?$Bj/(B . 34756)
    (?$Bj0(B . 34739)
    (?$Bj1(B . 34759)
    (?$Bj2(B . 34758)
    (?$Bj3(B . 34747)
    (?$Bj4(B . 34799)
    (?$Bj5(B . 34802)
    (?$Bj6(B . 34784)
    (?$Bj7(B . 34831)
    (?$Bj8(B . 34829)
    (?$Bj9(B . 34814)
    (?$Bj:(B . 34806)
    (?$Bj;(B . 34807)
    (?$Bj<(B . 34830)
    (?$Bj=(B . 34770)
    (?$Bj>(B . 34833)
    (?$Bj?(B . 34838)
    (?$Bj@(B . 34837)
    (?$BjA(B . 34850)
    (?$BjB(B . 34849)
    (?$BjC(B . 34865)
    (?$BjD(B . 34870)
    (?$BjE(B . 34873)
    (?$BjF(B . 34855)
    (?$BjG(B . 34875)
    (?$BjH(B . 34884)
    (?$BjI(B . 34882)
    (?$BjJ(B . 34898)
    (?$BjK(B . 34905)
    (?$BjL(B . 34910)
    (?$BjM(B . 34914)
    (?$BjN(B . 34923)
    (?$BjO(B . 34945)
    (?$BjP(B . 34942)
    (?$BjQ(B . 34974)
    (?$BjR(B . 34933)
    (?$BjS(B . 34941)
    (?$BjT(B . 34997)
    (?$BjU(B . 34930)
    (?$BjV(B . 34946)
    (?$BjW(B . 34967)
    (?$BjX(B . 34962)
    (?$BjY(B . 34990)
    (?$BjZ(B . 34969)
    (?$Bj[(B . 34978)
    (?$Bj\(B . 34957)
    (?$Bj](B . 34980)
    (?$Bj^(B . 34992)
    (?$Bj_(B . 35007)
    (?$Bj`(B . 34993)
    (?$Bja(B . 35011)
    (?$Bjb(B . 35012)
    (?$Bjc(B . 35028)
    (?$Bjd(B . 35032)
    (?$Bje(B . 35033)
    (?$Bjf(B . 35037)
    (?$Bjg(B . 35065)
    (?$Bjh(B . 35074)
    (?$Bji(B . 35068)
    (?$Bjj(B . 35060)
    (?$Bjk(B . 35048)
    (?$Bjl(B . 35058)
    (?$Bjm(B . 35076)
    (?$Bjn(B . 35084)
    (?$Bjo(B . 35082)
    (?$Bjp(B . 35091)
    (?$Bjq(B . 35139)
    (?$Bjr(B . 35102)
    (?$Bjs(B . 35109)
    (?$Bjt(B . 35114)
    (?$Bju(B . 35115)
    (?$Bjv(B . 35137)
    (?$Bjw(B . 35140)
    (?$Bjx(B . 35131)
    (?$Bjy(B . 35126)
    (?$Bjz(B . 35128)
    (?$Bj{(B . 35148)
    (?$Bj|(B . 35101)
    (?$Bj}(B . 35168)
    (?$Bj~(B . 35166)
    (?$Bk!(B . 35174)
    (?$Bk"(B . 35172)
    (?$Bk#(B . 35181)
    (?$Bk$(B . 35178)
    (?$Bk%(B . 35183)
    (?$Bk&(B . 35188)
    (?$Bk'(B . 35191)
    (?$Bk((B . 35198)
    (?$Bk)(B . 35203)
    (?$Bk*(B . 35208)
    (?$Bk+(B . 35210)
    (?$Bk,(B . 35219)
    (?$Bk-(B . 35224)
    (?$Bk.(B . 35233)
    (?$Bk/(B . 35241)
    (?$Bk0(B . 35238)
    (?$Bk1(B . 35244)
    (?$Bk2(B . 35247)
    (?$Bk3(B . 35250)
    (?$Bk4(B . 35258)
    (?$Bk5(B . 35261)
    (?$Bk6(B . 35263)
    (?$Bk7(B . 35264)
    (?$Bk8(B . 35290)
    (?$Bk9(B . 35292)
    (?$Bk:(B . 35293)
    (?$Bk;(B . 35303)
    (?$Bk<(B . 35316)
    (?$Bk=(B . 35320)
    (?$Bk>(B . 35331)
    (?$Bk?(B . 35350)
    (?$Bk@(B . 35344)
    (?$BkA(B . 35340)
    (?$BkB(B . 35355)
    (?$BkC(B . 35357)
    (?$BkD(B . 35365)
    (?$BkE(B . 35382)
    (?$BkF(B . 35393)
    (?$BkG(B . 35419)
    (?$BkH(B . 35410)
    (?$BkI(B . 35398)
    (?$BkJ(B . 35400)
    (?$BkK(B . 35452)
    (?$BkL(B . 35437)
    (?$BkM(B . 35436)
    (?$BkN(B . 35426)
    (?$BkO(B . 35461)
    (?$BkP(B . 35458)
    (?$BkQ(B . 35460)
    (?$BkR(B . 35496)
    (?$BkS(B . 35489)
    (?$BkT(B . 35473)
    (?$BkU(B . 35493)
    (?$BkV(B . 35494)
    (?$BkW(B . 35482)
    (?$BkX(B . 35491)
    (?$BkY(B . 35524)
    (?$BkZ(B . 35533)
    (?$Bk[(B . 35522)
    (?$Bk\(B . 35546)
    (?$Bk](B . 35563)
    (?$Bk^(B . 35571)
    (?$Bk_(B . 35559)
    (?$Bk`(B . 35556)
    (?$Bka(B . 35569)
    (?$Bkb(B . 35604)
    (?$Bkc(B . 35552)
    (?$Bkd(B . 35554)
    (?$Bke(B . 35575)
    (?$Bkf(B . 35550)
    (?$Bkg(B . 35547)
    (?$Bkh(B . 35596)
    (?$Bki(B . 35591)
    (?$Bkj(B . 35610)
    (?$Bkk(B . 35553)
    (?$Bkl(B . 35606)
    (?$Bkm(B . 35600)
    (?$Bkn(B . 35607)
    (?$Bko(B . 35616)
    (?$Bkp(B . 35635)
    (?$Bkq(B . 38827)
    (?$Bkr(B . 35622)
    (?$Bks(B . 35627)
    (?$Bkt(B . 35646)
    (?$Bku(B . 35624)
    (?$Bkv(B . 35649)
    (?$Bkw(B . 35660)
    (?$Bkx(B . 35663)
    (?$Bky(B . 35662)
    (?$Bkz(B . 35657)
    (?$Bk{(B . 35670)
    (?$Bk|(B . 35675)
    (?$Bk}(B . 35674)
    (?$Bk~(B . 35691)
    (?$Bl!(B . 35679)
    (?$Bl"(B . 35692)
    (?$Bl#(B . 35695)
    (?$Bl$(B . 35700)
    (?$Bl%(B . 35709)
    (?$Bl&(B . 35712)
    (?$Bl'(B . 35724)
    (?$Bl((B . 35726)
    (?$Bl)(B . 35730)
    (?$Bl*(B . 35731)
    (?$Bl+(B . 35734)
    (?$Bl,(B . 35737)
    (?$Bl-(B . 35738)
    (?$Bl.(B . 35898)
    (?$Bl/(B . 35905)
    (?$Bl0(B . 35903)
    (?$Bl1(B . 35912)
    (?$Bl2(B . 35916)
    (?$Bl3(B . 35918)
    (?$Bl4(B . 35920)
    (?$Bl5(B . 35925)
    (?$Bl6(B . 35938)
    (?$Bl7(B . 35948)
    (?$Bl8(B . 35960)
    (?$Bl9(B . 35962)
    (?$Bl:(B . 35970)
    (?$Bl;(B . 35977)
    (?$Bl<(B . 35973)
    (?$Bl=(B . 35978)
    (?$Bl>(B . 35981)
    (?$Bl?(B . 35982)
    (?$Bl@(B . 35988)
    (?$BlA(B . 35964)
    (?$BlB(B . 35992)
    (?$BlC(B . 25117)
    (?$BlD(B . 36013)
    (?$BlE(B . 36010)
    (?$BlF(B . 36029)
    (?$BlG(B . 36018)
    (?$BlH(B . 36019)
    (?$BlI(B . 36014)
    (?$BlJ(B . 36022)
    (?$BlK(B . 36040)
    (?$BlL(B . 36033)
    (?$BlM(B . 36068)
    (?$BlN(B . 36067)
    (?$BlO(B . 36058)
    (?$BlP(B . 36093)
    (?$BlQ(B . 36090)
    (?$BlR(B . 36091)
    (?$BlS(B . 36100)
    (?$BlT(B . 36101)
    (?$BlU(B . 36106)
    (?$BlV(B . 36103)
    (?$BlW(B . 36111)
    (?$BlX(B . 36109)
    (?$BlY(B . 36112)
    (?$BlZ(B . 40782)
    (?$Bl[(B . 36115)
    (?$Bl\(B . 36045)
    (?$Bl](B . 36116)
    (?$Bl^(B . 36118)
    (?$Bl_(B . 36199)
    (?$Bl`(B . 36205)
    (?$Bla(B . 36209)
    (?$Blb(B . 36211)
    (?$Blc(B . 36225)
    (?$Bld(B . 36249)
    (?$Ble(B . 36290)
    (?$Blf(B . 36286)
    (?$Blg(B . 36282)
    (?$Blh(B . 36303)
    (?$Bli(B . 36314)
    (?$Blj(B . 36310)
    (?$Blk(B . 36300)
    (?$Bll(B . 36315)
    (?$Blm(B . 36299)
    (?$Bln(B . 36330)
    (?$Blo(B . 36331)
    (?$Blp(B . 36319)
    (?$Blq(B . 36323)
    (?$Blr(B . 36348)
    (?$Bls(B . 36360)
    (?$Blt(B . 36361)
    (?$Blu(B . 36351)
    (?$Blv(B . 36381)
    (?$Blw(B . 36382)
    (?$Blx(B . 36368)
    (?$Bly(B . 36383)
    (?$Blz(B . 36418)
    (?$Bl{(B . 36405)
    (?$Bl|(B . 36400)
    (?$Bl}(B . 36404)
    (?$Bl~(B . 36426)
    (?$Bm!(B . 36423)
    (?$Bm"(B . 36425)
    (?$Bm#(B . 36428)
    (?$Bm$(B . 36432)
    (?$Bm%(B . 36424)
    (?$Bm&(B . 36441)
    (?$Bm'(B . 36452)
    (?$Bm((B . 36448)
    (?$Bm)(B . 36394)
    (?$Bm*(B . 36451)
    (?$Bm+(B . 36437)
    (?$Bm,(B . 36470)
    (?$Bm-(B . 36466)
    (?$Bm.(B . 36476)
    (?$Bm/(B . 36481)
    (?$Bm0(B . 36487)
    (?$Bm1(B . 36485)
    (?$Bm2(B . 36484)
    (?$Bm3(B . 36491)
    (?$Bm4(B . 36490)
    (?$Bm5(B . 36499)
    (?$Bm6(B . 36497)
    (?$Bm7(B . 36500)
    (?$Bm8(B . 36505)
    (?$Bm9(B . 36522)
    (?$Bm:(B . 36513)
    (?$Bm;(B . 36524)
    (?$Bm<(B . 36528)
    (?$Bm=(B . 36550)
    (?$Bm>(B . 36529)
    (?$Bm?(B . 36542)
    (?$Bm@(B . 36549)
    (?$BmA(B . 36552)
    (?$BmB(B . 36555)
    (?$BmC(B . 36571)
    (?$BmD(B . 36579)
    (?$BmE(B . 36604)
    (?$BmF(B . 36603)
    (?$BmG(B . 36587)
    (?$BmH(B . 36606)
    (?$BmI(B . 36618)
    (?$BmJ(B . 36613)
    (?$BmK(B . 36629)
    (?$BmL(B . 36626)
    (?$BmM(B . 36633)
    (?$BmN(B . 36627)
    (?$BmO(B . 36636)
    (?$BmP(B . 36639)
    (?$BmQ(B . 36635)
    (?$BmR(B . 36620)
    (?$BmS(B . 36646)
    (?$BmT(B . 36659)
    (?$BmU(B . 36667)
    (?$BmV(B . 36665)
    (?$BmW(B . 36677)
    (?$BmX(B . 36674)
    (?$BmY(B . 36670)
    (?$BmZ(B . 36684)
    (?$Bm[(B . 36681)
    (?$Bm\(B . 36678)
    (?$Bm](B . 36686)
    (?$Bm^(B . 36695)
    (?$Bm_(B . 36700)
    (?$Bm`(B . 36706)
    (?$Bma(B . 36707)
    (?$Bmb(B . 36708)
    (?$Bmc(B . 36764)
    (?$Bmd(B . 36767)
    (?$Bme(B . 36771)
    (?$Bmf(B . 36781)
    (?$Bmg(B . 36783)
    (?$Bmh(B . 36791)
    (?$Bmi(B . 36826)
    (?$Bmj(B . 36837)
    (?$Bmk(B . 36834)
    (?$Bml(B . 36842)
    (?$Bmm(B . 36847)
    (?$Bmn(B . 36999)
    (?$Bmo(B . 36852)
    (?$Bmp(B . 36869)
    (?$Bmq(B . 36857)
    (?$Bmr(B . 36858)
    (?$Bms(B . 36881)
    (?$Bmt(B . 36885)
    (?$Bmu(B . 36897)
    (?$Bmv(B . 36877)
    (?$Bmw(B . 36894)
    (?$Bmx(B . 36886)
    (?$Bmy(B . 36875)
    (?$Bmz(B . 36903)
    (?$Bm{(B . 36918)
    (?$Bm|(B . 36917)
    (?$Bm}(B . 36921)
    (?$Bm~(B . 36856)
    (?$Bn!(B . 36943)
    (?$Bn"(B . 36944)
    (?$Bn#(B . 36945)
    (?$Bn$(B . 36946)
    (?$Bn%(B . 36878)
    (?$Bn&(B . 36937)
    (?$Bn'(B . 36926)
    (?$Bn((B . 36950)
    (?$Bn)(B . 36952)
    (?$Bn*(B . 36958)
    (?$Bn+(B . 36968)
    (?$Bn,(B . 36975)
    (?$Bn-(B . 36982)
    (?$Bn.(B . 38568)
    (?$Bn/(B . 36978)
    (?$Bn0(B . 36994)
    (?$Bn1(B . 36989)
    (?$Bn2(B . 36993)
    (?$Bn3(B . 36992)
    (?$Bn4(B . 37002)
    (?$Bn5(B . 37001)
    (?$Bn6(B . 37007)
    (?$Bn7(B . 37032)
    (?$Bn8(B . 37039)
    (?$Bn9(B . 37041)
    (?$Bn:(B . 37045)
    (?$Bn;(B . 37090)
    (?$Bn<(B . 37092)
    (?$Bn=(B . 25160)
    (?$Bn>(B . 37083)
    (?$Bn?(B . 37122)
    (?$Bn@(B . 37138)
    (?$BnA(B . 37145)
    (?$BnB(B . 37170)
    (?$BnC(B . 37168)
    (?$BnD(B . 37194)
    (?$BnE(B . 37206)
    (?$BnF(B . 37208)
    (?$BnG(B . 37219)
    (?$BnH(B . 37221)
    (?$BnI(B . 37225)
    (?$BnJ(B . 37235)
    (?$BnK(B . 37234)
    (?$BnL(B . 37259)
    (?$BnM(B . 37257)
    (?$BnN(B . 37250)
    (?$BnO(B . 37282)
    (?$BnP(B . 37291)
    (?$BnQ(B . 37295)
    (?$BnR(B . 37290)
    (?$BnS(B . 37301)
    (?$BnT(B . 37300)
    (?$BnU(B . 37306)
    (?$BnV(B . 37312)
    (?$BnW(B . 37313)
    (?$BnX(B . 37321)
    (?$BnY(B . 37323)
    (?$BnZ(B . 37328)
    (?$Bn[(B . 37334)
    (?$Bn\(B . 37343)
    (?$Bn](B . 37345)
    (?$Bn^(B . 37339)
    (?$Bn_(B . 37372)
    (?$Bn`(B . 37365)
    (?$Bna(B . 37366)
    (?$Bnb(B . 37406)
    (?$Bnc(B . 37375)
    (?$Bnd(B . 37396)
    (?$Bne(B . 37420)
    (?$Bnf(B . 37397)
    (?$Bng(B . 37393)
    (?$Bnh(B . 37470)
    (?$Bni(B . 37463)
    (?$Bnj(B . 37445)
    (?$Bnk(B . 37449)
    (?$Bnl(B . 37476)
    (?$Bnm(B . 37448)
    (?$Bnn(B . 37525)
    (?$Bno(B . 37439)
    (?$Bnp(B . 37451)
    (?$Bnq(B . 37456)
    (?$Bnr(B . 37532)
    (?$Bns(B . 37526)
    (?$Bnt(B . 37523)
    (?$Bnu(B . 37531)
    (?$Bnv(B . 37466)
    (?$Bnw(B . 37583)
    (?$Bnx(B . 37561)
    (?$Bny(B . 37559)
    (?$Bnz(B . 37609)
    (?$Bn{(B . 37647)
    (?$Bn|(B . 37626)
    (?$Bn}(B . 37700)
    (?$Bn~(B . 37678)
    (?$Bo!(B . 37657)
    (?$Bo"(B . 37666)
    (?$Bo#(B . 37658)
    (?$Bo$(B . 37667)
    (?$Bo%(B . 37690)
    (?$Bo&(B . 37685)
    (?$Bo'(B . 37691)
    (?$Bo((B . 37724)
    (?$Bo)(B . 37728)
    (?$Bo*(B . 37756)
    (?$Bo+(B . 37742)
    (?$Bo,(B . 37718)
    (?$Bo-(B . 37808)
    (?$Bo.(B . 37804)
    (?$Bo/(B . 37805)
    (?$Bo0(B . 37780)
    (?$Bo1(B . 37817)
    (?$Bo2(B . 37846)
    (?$Bo3(B . 37847)
    (?$Bo4(B . 37864)
    (?$Bo5(B . 37861)
    (?$Bo6(B . 37848)
    (?$Bo7(B . 37827)
    (?$Bo8(B . 37853)
    (?$Bo9(B . 37840)
    (?$Bo:(B . 37832)
    (?$Bo;(B . 37860)
    (?$Bo<(B . 37914)
    (?$Bo=(B . 37908)
    (?$Bo>(B . 37907)
    (?$Bo?(B . 37891)
    (?$Bo@(B . 37895)
    (?$BoA(B . 37904)
    (?$BoB(B . 37942)
    (?$BoC(B . 37931)
    (?$BoD(B . 37941)
    (?$BoE(B . 37921)
    (?$BoF(B . 37946)
    (?$BoG(B . 37953)
    (?$BoH(B . 37970)
    (?$BoI(B . 37956)
    (?$BoJ(B . 37979)
    (?$BoK(B . 37984)
    (?$BoL(B . 37986)
    (?$BoM(B . 37982)
    (?$BoN(B . 37994)
    (?$BoO(B . 37417)
    (?$BoP(B . 38000)
    (?$BoQ(B . 38005)
    (?$BoR(B . 38007)
    (?$BoS(B . 38013)
    (?$BoT(B . 37978)
    (?$BoU(B . 38012)
    (?$BoV(B . 38014)
    (?$BoW(B . 38017)
    (?$BoX(B . 38015)
    (?$BoY(B . 38274)
    (?$BoZ(B . 38279)
    (?$Bo[(B . 38282)
    (?$Bo\(B . 38292)
    (?$Bo](B . 38294)
    (?$Bo^(B . 38296)
    (?$Bo_(B . 38297)
    (?$Bo`(B . 38304)
    (?$Boa(B . 38312)
    (?$Bob(B . 38311)
    (?$Boc(B . 38317)
    (?$Bod(B . 38332)
    (?$Boe(B . 38331)
    (?$Bof(B . 38329)
    (?$Bog(B . 38334)
    (?$Boh(B . 38346)
    (?$Boi(B . 28662)
    (?$Boj(B . 38339)
    (?$Bok(B . 38349)
    (?$Bol(B . 38348)
    (?$Bom(B . 38357)
    (?$Bon(B . 38356)
    (?$Boo(B . 38358)
    (?$Bop(B . 38364)
    (?$Boq(B . 38369)
    (?$Bor(B . 38373)
    (?$Bos(B . 38370)
    (?$Bot(B . 38433)
    (?$Bou(B . 38440)
    (?$Bov(B . 38446)
    (?$Bow(B . 38447)
    (?$Box(B . 38466)
    (?$Boy(B . 38476)
    (?$Boz(B . 38479)
    (?$Bo{(B . 38475)
    (?$Bo|(B . 38519)
    (?$Bo}(B . 38492)
    (?$Bo~(B . 38494)
    (?$Bp!(B . 38493)
    (?$Bp"(B . 38495)
    (?$Bp#(B . 38502)
    (?$Bp$(B . 38514)
    (?$Bp%(B . 38508)
    (?$Bp&(B . 38541)
    (?$Bp'(B . 38552)
    (?$Bp((B . 38549)
    (?$Bp)(B . 38551)
    (?$Bp*(B . 38570)
    (?$Bp+(B . 38567)
    (?$Bp,(B . 38577)
    (?$Bp-(B . 38578)
    (?$Bp.(B . 38576)
    (?$Bp/(B . 38580)
    (?$Bp0(B . 38582)
    (?$Bp1(B . 38584)
    (?$Bp2(B . 38585)
    (?$Bp3(B . 38606)
    (?$Bp4(B . 38603)
    (?$Bp5(B . 38601)
    (?$Bp6(B . 38605)
    (?$Bp7(B . 35149)
    (?$Bp8(B . 38620)
    (?$Bp9(B . 38669)
    (?$Bp:(B . 38613)
    (?$Bp;(B . 38649)
    (?$Bp<(B . 38660)
    (?$Bp=(B . 38662)
    (?$Bp>(B . 38664)
    (?$Bp?(B . 38675)
    (?$Bp@(B . 38670)
    (?$BpA(B . 38673)
    (?$BpB(B . 38671)
    (?$BpC(B . 38678)
    (?$BpD(B . 38681)
    (?$BpE(B . 38692)
    (?$BpF(B . 38698)
    (?$BpG(B . 38704)
    (?$BpH(B . 38713)
    (?$BpI(B . 38717)
    (?$BpJ(B . 38718)
    (?$BpK(B . 38724)
    (?$BpL(B . 38726)
    (?$BpM(B . 38728)
    (?$BpN(B . 38722)
    (?$BpO(B . 38729)
    (?$BpP(B . 38748)
    (?$BpQ(B . 38752)
    (?$BpR(B . 38756)
    (?$BpS(B . 38758)
    (?$BpT(B . 38760)
    (?$BpU(B . 21202)
    (?$BpV(B . 38763)
    (?$BpW(B . 38769)
    (?$BpX(B . 38777)
    (?$BpY(B . 38789)
    (?$BpZ(B . 38780)
    (?$Bp[(B . 38785)
    (?$Bp\(B . 38778)
    (?$Bp](B . 38790)
    (?$Bp^(B . 38795)
    (?$Bp_(B . 38799)
    (?$Bp`(B . 38800)
    (?$Bpa(B . 38812)
    (?$Bpb(B . 38824)
    (?$Bpc(B . 38822)
    (?$Bpd(B . 38819)
    (?$Bpe(B . 38835)
    (?$Bpf(B . 38836)
    (?$Bpg(B . 38851)
    (?$Bph(B . 38854)
    (?$Bpi(B . 38856)
    (?$Bpj(B . 38859)
    (?$Bpk(B . 38876)
    (?$Bpl(B . 38893)
    (?$Bpm(B . 40783)
    (?$Bpn(B . 38898)
    (?$Bpo(B . 31455)
    (?$Bpp(B . 38902)
    (?$Bpq(B . 38901)
    (?$Bpr(B . 38927)
    (?$Bps(B . 38924)
    (?$Bpt(B . 38968)
    (?$Bpu(B . 38948)
    (?$Bpv(B . 38945)
    (?$Bpw(B . 38967)
    (?$Bpx(B . 38973)
    (?$Bpy(B . 38982)
    (?$Bpz(B . 38991)
    (?$Bp{(B . 38987)
    (?$Bp|(B . 39019)
    (?$Bp}(B . 39023)
    (?$Bp~(B . 39024)
    (?$Bq!(B . 39025)
    (?$Bq"(B . 39028)
    (?$Bq#(B . 39027)
    (?$Bq$(B . 39082)
    (?$Bq%(B . 39087)
    (?$Bq&(B . 39089)
    (?$Bq'(B . 39094)
    (?$Bq((B . 39108)
    (?$Bq)(B . 39107)
    (?$Bq*(B . 39110)
    (?$Bq+(B . 39145)
    (?$Bq,(B . 39147)
    (?$Bq-(B . 39171)
    (?$Bq.(B . 39177)
    (?$Bq/(B . 39186)
    (?$Bq0(B . 39188)
    (?$Bq1(B . 39192)
    (?$Bq2(B . 39201)
    (?$Bq3(B . 39197)
    (?$Bq4(B . 39198)
    (?$Bq5(B . 39204)
    (?$Bq6(B . 39200)
    (?$Bq7(B . 39212)
    (?$Bq8(B . 39214)
    (?$Bq9(B . 39229)
    (?$Bq:(B . 39230)
    (?$Bq;(B . 39234)
    (?$Bq<(B . 39241)
    (?$Bq=(B . 39237)
    (?$Bq>(B . 39248)
    (?$Bq?(B . 39243)
    (?$Bq@(B . 39249)
    (?$BqA(B . 39250)
    (?$BqB(B . 39244)
    (?$BqC(B . 39253)
    (?$BqD(B . 39319)
    (?$BqE(B . 39320)
    (?$BqF(B . 39333)
    (?$BqG(B . 39341)
    (?$BqH(B . 39342)
    (?$BqI(B . 39356)
    (?$BqJ(B . 39391)
    (?$BqK(B . 39387)
    (?$BqL(B . 39389)
    (?$BqM(B . 39384)
    (?$BqN(B . 39377)
    (?$BqO(B . 39405)
    (?$BqP(B . 39406)
    (?$BqQ(B . 39409)
    (?$BqR(B . 39410)
    (?$BqS(B . 39419)
    (?$BqT(B . 39416)
    (?$BqU(B . 39425)
    (?$BqV(B . 39439)
    (?$BqW(B . 39429)
    (?$BqX(B . 39394)
    (?$BqY(B . 39449)
    (?$BqZ(B . 39467)
    (?$Bq[(B . 39479)
    (?$Bq\(B . 39493)
    (?$Bq](B . 39490)
    (?$Bq^(B . 39488)
    (?$Bq_(B . 39491)
    (?$Bq`(B . 39486)
    (?$Bqa(B . 39509)
    (?$Bqb(B . 39501)
    (?$Bqc(B . 39515)
    (?$Bqd(B . 39511)
    (?$Bqe(B . 39519)
    (?$Bqf(B . 39522)
    (?$Bqg(B . 39525)
    (?$Bqh(B . 39524)
    (?$Bqi(B . 39529)
    (?$Bqj(B . 39531)
    (?$Bqk(B . 39530)
    (?$Bql(B . 39597)
    (?$Bqm(B . 39600)
    (?$Bqn(B . 39612)
    (?$Bqo(B . 39616)
    (?$Bqp(B . 39631)
    (?$Bqq(B . 39633)
    (?$Bqr(B . 39635)
    (?$Bqs(B . 39636)
    (?$Bqt(B . 39646)
    (?$Bqu(B . 39647)
    (?$Bqv(B . 39650)
    (?$Bqw(B . 39651)
    (?$Bqx(B . 39654)
    (?$Bqy(B . 39663)
    (?$Bqz(B . 39659)
    (?$Bq{(B . 39662)
    (?$Bq|(B . 39668)
    (?$Bq}(B . 39665)
    (?$Bq~(B . 39671)
    (?$Br!(B . 39675)
    (?$Br"(B . 39686)
    (?$Br#(B . 39704)
    (?$Br$(B . 39706)
    (?$Br%(B . 39711)
    (?$Br&(B . 39714)
    (?$Br'(B . 39715)
    (?$Br((B . 39717)
    (?$Br)(B . 39719)
    (?$Br*(B . 39720)
    (?$Br+(B . 39721)
    (?$Br,(B . 39722)
    (?$Br-(B . 39726)
    (?$Br.(B . 39727)
    (?$Br/(B . 39730)
    (?$Br0(B . 39748)
    (?$Br1(B . 39747)
    (?$Br2(B . 39759)
    (?$Br3(B . 39757)
    (?$Br4(B . 39758)
    (?$Br5(B . 39761)
    (?$Br6(B . 39768)
    (?$Br7(B . 39796)
    (?$Br8(B . 39827)
    (?$Br9(B . 39811)
    (?$Br:(B . 39825)
    (?$Br;(B . 39830)
    (?$Br<(B . 39831)
    (?$Br=(B . 39839)
    (?$Br>(B . 39840)
    (?$Br?(B . 39848)
    (?$Br@(B . 39860)
    (?$BrA(B . 39872)
    (?$BrB(B . 39882)
    (?$BrC(B . 39865)
    (?$BrD(B . 39878)
    (?$BrE(B . 39887)
    (?$BrF(B . 39889)
    (?$BrG(B . 39890)
    (?$BrH(B . 39907)
    (?$BrI(B . 39906)
    (?$BrJ(B . 39908)
    (?$BrK(B . 39892)
    (?$BrL(B . 39905)
    (?$BrM(B . 39994)
    (?$BrN(B . 39922)
    (?$BrO(B . 39921)
    (?$BrP(B . 39920)
    (?$BrQ(B . 39957)
    (?$BrR(B . 39956)
    (?$BrS(B . 39945)
    (?$BrT(B . 39955)
    (?$BrU(B . 39948)
    (?$BrV(B . 39942)
    (?$BrW(B . 39944)
    (?$BrX(B . 39954)
    (?$BrY(B . 39946)
    (?$BrZ(B . 39940)
    (?$Br[(B . 39982)
    (?$Br\(B . 39963)
    (?$Br](B . 39973)
    (?$Br^(B . 39972)
    (?$Br_(B . 39969)
    (?$Br`(B . 39984)
    (?$Bra(B . 40007)
    (?$Brb(B . 39986)
    (?$Brc(B . 40006)
    (?$Brd(B . 39998)
    (?$Bre(B . 40026)
    (?$Brf(B . 40032)
    (?$Brg(B . 40039)
    (?$Brh(B . 40054)
    (?$Bri(B . 40056)
    (?$Brj(B . 40167)
    (?$Brk(B . 40172)
    (?$Brl(B . 40176)
    (?$Brm(B . 40201)
    (?$Brn(B . 40200)
    (?$Bro(B . 40171)
    (?$Brp(B . 40195)
    (?$Brq(B . 40198)
    (?$Brr(B . 40234)
    (?$Brs(B . 40230)
    (?$Brt(B . 40367)
    (?$Bru(B . 40227)
    (?$Brv(B . 40223)
    (?$Brw(B . 40260)
    (?$Brx(B . 40213)
    (?$Bry(B . 40210)
    (?$Brz(B . 40257)
    (?$Br{(B . 40255)
    (?$Br|(B . 40254)
    (?$Br}(B . 40262)
    (?$Br~(B . 40264)
    (?$Bs!(B . 40285)
    (?$Bs"(B . 40286)
    (?$Bs#(B . 40292)
    (?$Bs$(B . 40273)
    (?$Bs%(B . 40272)
    (?$Bs&(B . 40281)
    (?$Bs'(B . 40306)
    (?$Bs((B . 40329)
    (?$Bs)(B . 40327)
    (?$Bs*(B . 40363)
    (?$Bs+(B . 40303)
    (?$Bs,(B . 40314)
    (?$Bs-(B . 40346)
    (?$Bs.(B . 40356)
    (?$Bs/(B . 40361)
    (?$Bs0(B . 40370)
    (?$Bs1(B . 40388)
    (?$Bs2(B . 40385)
    (?$Bs3(B . 40379)
    (?$Bs4(B . 40376)
    (?$Bs5(B . 40378)
    (?$Bs6(B . 40390)
    (?$Bs7(B . 40399)
    (?$Bs8(B . 40386)
    (?$Bs9(B . 40409)
    (?$Bs:(B . 40403)
    (?$Bs;(B . 40440)
    (?$Bs<(B . 40422)
    (?$Bs=(B . 40429)
    (?$Bs>(B . 40431)
    (?$Bs?(B . 40445)
    (?$Bs@(B . 40474)
    (?$BsA(B . 40475)
    (?$BsB(B . 40478)
    (?$BsC(B . 40565)
    (?$BsD(B . 40569)
    (?$BsE(B . 40573)
    (?$BsF(B . 40577)
    (?$BsG(B . 40584)
    (?$BsH(B . 40587)
    (?$BsI(B . 40588)
    (?$BsJ(B . 40594)
    (?$BsK(B . 40597)
    (?$BsL(B . 40593)
    (?$BsM(B . 40605)
    (?$BsN(B . 40613)
    (?$BsO(B . 40617)
    (?$BsP(B . 40632)
    (?$BsQ(B . 40618)
    (?$BsR(B . 40621)
    (?$BsS(B . 38753)
    (?$BsT(B . 40652)
    (?$BsU(B . 40654)
    (?$BsV(B . 40655)
    (?$BsW(B . 40656)
    (?$BsX(B . 40660)
    (?$BsY(B . 40668)
    (?$BsZ(B . 40670)
    (?$Bs[(B . 40669)
    (?$Bs\(B . 40672)
    (?$Bs](B . 40677)
    (?$Bs^(B . 40680)
    (?$Bs_(B . 40687)
    (?$Bs`(B . 40692)
    (?$Bsa(B . 40694)
    (?$Bsb(B . 40695)
    (?$Bsc(B . 40697)
    (?$Bsd(B . 40699)
    (?$Bse(B . 40700)
    (?$Bsf(B . 40701)
    (?$Bsg(B . 40711)
    (?$Bsh(B . 40712)
    (?$Bsi(B . 30391)
    (?$Bsj(B . 40725)
    (?$Bsk(B . 40737)
    (?$Bsl(B . 40748)
    (?$Bsm(B . 40766)
    (?$Bsn(B . 40778)
    (?$Bso(B . 40786)
    (?$Bsp(B . 40788)
    (?$Bsq(B . 40803)
    (?$Bsr(B . 40799)
    (?$Bss(B . 40800)
    (?$Bst(B . 40801)
    (?$Bsu(B . 40806)
    (?$Bsv(B . 40807)
    (?$Bsw(B . 40812)
    (?$Bsx(B . 40810)
    (?$Bsy(B . 40823)
    (?$Bsz(B . 40818)
    (?$Bs{(B . 40822)
    (?$Bs|(B . 40853)
    (?$Bs}(B . 40860)
    (?$Bs~(B . 40864)
    (?$Bt!(B . 22575)
    (?$Bt"(B . 27079)
    (?$Bt#(B . 36953)
    (?$Bt$(B . 29796)
    (?$Bt%(B . 20956)
    (?$Bt&(B . 29081)))

(defvar jis-x-0208-vs-unicode-alist jis-x-0208-1990-vs-unicode-alist)

(provide 'ujisx0208)
