;;; -*- coding: iso-2022-7bit  -*-
;;; tae.el --- Translate And Encoding compiler(TAE:$BL/(B):-)

;; Copyright (C) 1997 Miyashita Hisashi

;; Keywords: mule, multilingual, encode, CCL

;; This file is part of MULE-UCS

;; MULE-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; MULE-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; This module manages Translation And Encodings.
;;; This is main and very important module to MULE-UCS.
;;; TAE is CORE module. But this is VERY insufficient version.

(require 'mucs)
(require 'mucs-ccl)
(require 'tbl-mg)

(register-ccl-translation-table
 'tae-cease-translation-table
 (vector t -1 0 (mucs-max-code)))

;;;
;;; IN TAE, translation functions are described as...
;;;         ((f (& (| f11 f12 f13 ...)
;;;                (c f21 f22 f23 ...))
;;;              reg)
;;;          reg)
;;;
;;; translation_func := (func reg)
;;; func := (OP func func ...) | 
;;;         (FOP (func func ...) translation_func) | 
;;;         TABLESET
;;; OP := `&' | `|' | `c'
;;; FOP := `f' | `ff'
;;; REG := r0 | r1 | r2 | ... | r9
;;; TABLESET := (table1 table2 .... )
;;;

;; MAPPING FUNCTION
;;
;;  mapping functions are 
;;

(defun tae-generate-ccl (func))

;; this is a temporal function.

(defun tae-generate-union-func-map (funcs decodep)
  "Make a union function from a list of functions."
  (let (elem func-alist tables ctables)
    (while funcs
	(setq elem (car funcs)
	      funcs (cdr funcs))
	(cond ((table-set-p elem)
	       (setq ctables
		     (get-table-set-tables elem decodep)
		     tables (append tables ctables)))
	       (t
		(error "Not yet supported type! %S" elem))))
	tables))

(defun tae-generate-func-to-func-map (funcs decodep &optional type)
  "Recieve a-list of (TAG . function)s.
Return a-list<CAR> (TAG . TABLE-NO(index of <CDR> list from 0)) and
a list<CDR> (TABLE<SYMBOL> TABLE<SYMBOL> ...)."
  (let ((idx 0) tbl-alist tbl-c
	elem elemt elemf func-alist tables)
    (while (setq elem (car funcs))
      (setq elemt (car elem)
	    elemf (cdr elem)
	    funcs (cdr funcs))
      (cond ((table-set-p elemf)
	     (if (setq tbl-c (assq elemt tbl-alist))
		 (setcdr tbl-c
			 (nconc
			  (cdr tbl-c)
			  (get-table-set-tables elemf decodep)))
	       (setq tbl-alist
		     (nconc
		      tbl-alist
		      (list
		       (cons elemt
			     (get-table-set-tables elemf decodep)))))))
	    (t
	     (error "Not yet supported type! %S" elem))))
    (while (setq elem (car tbl-alist))
      (setq elemt (car elem)
	    elemf (cdr elem)
	    tbl-alist (cdr tbl-alist)
	    func-alist (cons
			(cons elemt
			      (cond ((eq type 'symbol)
				     (car elemf))
				    (t idx)))
			func-alist)
	    idx (+ idx (length elemf) 1)
	    tables (append tables
			   (if tables
			       '(tae-cease-translation-table)
			     nil)
			   elemf)))
    (cons func-alist tables)))

;(defun tae-reduce-function (func)
;  "Reduce FUNC to simple form to operate with CCL."
;;;;    ((f (TABLESET ... TABLESET) reg) ...)
;  (let (op result)
;    (cond ((eq op '|)
;	   (while
;	       (
;
;)

(defun tae-generate-primitive-tables (func))

;; Generative Functions
;;

(defun tae-function-union-1 (func1 func2))
(defun tae-function-union-2 (func1 func2))

(defun tae-function-intersection-1 (func1 func2))
(defun tae-function-intersection-2 (func1 func2))

(defun tae-function-compose-1 (func1 func2))
(defun tae-function-compose-2 (func1 func2))

(defun tae-function-to-function (func1 reg))

(provide 'tae)
